/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.bulkeditor.editors;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.TypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.search.types.ISearchChildrenProvider;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.ui.widgets.DataTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.TypeSelectionProposalProvider;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.fordiac.ide.ui.widget.nattable.NatTableWidgetFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class AddAttributeTreeSelectionDialog
extends CheckedTreeSelectionDialog {
    private final String attributeDeclName;
    private final IProject project;
    private final Set<Object> disabledElements;
    private Text nameText = null;
    private Text typeText = null;
    private Text commentText = null;
    private Text valueText = null;
    private String name = null;
    private String type = null;
    private String comment = "";
    private String value = "";

    public AddAttributeTreeSelectionDialog(Shell shell, Collection<LibraryElement> initial, ISearchChildrenProvider childProv, String attributeDeclName, IProject project, Set<Object> disabledElements) {
        super(shell, (ILabelProvider)new DisabledElementsLabelProvider(disabledElements), (ITreeContentProvider)new AttributeTreeContentProvider(childProv, attributeDeclName, disabledElements));
        this.setInput(initial.toArray(LibraryElement[]::new));
        this.attributeDeclName = attributeDeclName;
        this.project = project;
        this.disabledElements = disabledElements;
    }

    protected CheckboxTreeViewer createTreeViewer(Composite parent) {
        CheckboxTreeViewer treeViewer = super.createTreeViewer(parent);
        treeViewer.addCheckStateListener(event -> {
            if (this.disabledElements.contains(event.getElement())) {
                treeViewer.setChecked(event.getElement(), !event.getChecked());
            }
        });
        return treeViewer;
    }

    protected void computeResult() {
        super.computeResult();
        if (this.nameText != null) {
            this.name = this.nameText.getText();
        }
        if (this.typeText != null) {
            this.type = this.typeText.getText();
        }
        this.comment = this.commentText.getText();
        this.value = this.valueText.getText();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite attributeComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)new GridLayout(2, false))).layoutData((Object)new GridData(4, 0x1000000, true, false))).create((Widget)composite);
        if (this.attributeDeclName != null) {
            WidgetFactory.label((int)0).text(FordiacMessages.Name).create((Widget)attributeComposite);
            ((TextFactory)((TextFactory)WidgetFactory.text((int)2048).layoutData((Object)new GridData(4, 0x1000000, true, true))).enabled(false)).text(this.attributeDeclName).create((Widget)attributeComposite);
        } else {
            WidgetFactory.label((int)0).text(FordiacMessages.Name).create((Widget)attributeComposite);
            this.nameText = (Text)((TextFactory)WidgetFactory.text((int)2048).layoutData((Object)new GridData(4, 0x1000000, true, true))).create((Widget)attributeComposite);
            WidgetFactory.label((int)0).text(FordiacMessages.Type).create((Widget)attributeComposite);
            this.typeText = (Text)((TextFactory)WidgetFactory.text((int)2048).layoutData((Object)new GridData(4, 0x1000000, true, true))).create((Widget)attributeComposite);
            TypeSelectionProposalProvider proposalProvider = new TypeSelectionProposalProvider(() -> TypeLibraryManager.INSTANCE.getTypeLibrary(this.project), (ITypeSelectionContentProvider)DataTypeSelectionContentProvider.INSTANCE);
            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)this.typeText, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)proposalProvider, KeyStroke.getInstance((int)262144, (int)32), NatTableWidgetFactory.getActivationChars());
            adapter.setProposalAcceptanceStyle(2);
        }
        WidgetFactory.label((int)0).text(FordiacMessages.Comment).create((Widget)attributeComposite);
        this.commentText = (Text)((TextFactory)WidgetFactory.text((int)2048).layoutData((Object)new GridData(4, 0x1000000, true, true))).create((Widget)attributeComposite);
        WidgetFactory.label((int)0).text(FordiacMessages.InitialValue).create((Widget)attributeComposite);
        this.valueText = (Text)((TextFactory)WidgetFactory.text((int)2048).layoutData((Object)new GridData(4, 0x1000000, true, true))).create((Widget)attributeComposite);
        return composite;
    }

    public String getAttributeName() {
        return this.name;
    }

    public String getAttributeType() {
        return this.type;
    }

    public String getAttributeComment() {
        return this.comment;
    }

    public String getAttributeValue() {
        return this.value;
    }

    private static class AttributeTreeContentProvider
    implements ITreeContentProvider {
        private final ISearchChildrenProvider childProv;
        private final String attributeDeclName;
        private final Set<Object> disabledElements;

        public AttributeTreeContentProvider(ISearchChildrenProvider childProv, String attributeDeclName, Set<Object> disabledElements) {
            this.childProv = childProv;
            this.attributeDeclName = attributeDeclName;
            this.disabledElements = disabledElements;
        }

        public boolean hasChildren(Object element) {
            UntypedSubApp untypedSubApp;
            if (element instanceof DirectlyDerivedType) {
                return false;
            }
            if (element instanceof IInterfaceElement) {
                return false;
            }
            if (element instanceof UntypedSubApp && (untypedSubApp = (UntypedSubApp)element).getSubAppNetwork().getNetworkElements().isEmpty() && untypedSubApp.getInterface().getAllInterfaceElements().findAny().isEmpty()) {
                return false;
            }
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                return this.childProv.hasChildren(eObject);
            }
            return false;
        }

        public Object getParent(Object element) {
            Object object = element;
            Objects.requireNonNull(object);
            Object object2 = object;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EObject.class}, (Object)object2, 0)) {
                case 0 -> {
                    EObject eobj = (EObject)object2;
                    EObject current = eobj.eContainer();
                    while (!(current instanceof ConfigurableObject)) {
                        current = current.eContainer();
                    }
                    yield current;
                }
                default -> null;
            };
        }

        public Object[] getElements(Object inputElement) {
            Object[] objectArray = (Object[])inputElement;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof ConfigurableObject) {
                    ConfigurableObject configElement = (ConfigurableObject)object;
                    configElement.getAttributes().stream().filter(asd -> asd.getAttributeDeclaration() != null).forEach(asdfasdfsadf -> {
                        AttributeDeclaration attdecl = asdfasdfsadf.getAttributeDeclaration();
                        if (PackageNameHelper.getFullTypeName((LibraryElement)attdecl).equals(this.attributeDeclName)) {
                            this.disabledElements.add(object);
                        }
                    });
                } else {
                    this.disabledElements.add(object);
                }
                ++n2;
            }
            return (Object[])inputElement;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof EObject) {
                Object[] configElements;
                EObject eObject = (EObject)parentElement;
                Object[] objectArray = configElements = (ConfigurableObject[])this.childProv.getChildren(eObject).filter(ConfigurableObject.class::isInstance).toArray(ConfigurableObject[]::new);
                int n = configElements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object configElement = objectArray[n2];
                    configElement.getAttributes().stream().filter(asd -> asd.getAttributeDeclaration() != null).forEach(arg_0 -> this.lambda$5((ConfigurableObject)configElement, arg_0));
                    ++n2;
                }
                return configElements;
            }
            return new Object[0];
        }

        private /* synthetic */ void lambda$5(ConfigurableObject configurableObject, Attribute asdfasdfsadf) {
            AttributeDeclaration attdecl = asdfasdfsadf.getAttributeDeclaration();
            if (PackageNameHelper.getFullTypeName((LibraryElement)attdecl).equals(this.attributeDeclName)) {
                this.disabledElements.add(configurableObject);
            }
        }
    }

    private static class DisabledElementsLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public final Set<Object> disabledElements;

        public DisabledElementsLabelProvider(Set<Object> disabledElements) {
            this.disabledElements = disabledElements;
        }

        public String getText(Object element) {
            if (element instanceof INamedElement) {
                INamedElement namedElement = (INamedElement)element;
                return namedElement.getName();
            }
            if (element instanceof Connection) {
                Connection conn = (Connection)element;
                return conn.getSource().getName() + " -> " + conn.getDestination().getName();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            Object object = element;
            Objects.requireNonNull(object);
            Object object2 = object;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UntypedSubApp.class, TypedSubApp.class, SubAppType.class, FunctionFBType.class, StructManipulator.class, IInterfaceElement.class, Connection.class, AutomationSystem.class, Application.class, CFBInstance.class, FB.class, SimpleFBType.class, BasicFBType.class, FBType.class, AttributeDeclaration.class, DataType.class}, (Object)object2, 0)) {
                case 0 -> {
                    UntypedSubApp o = (UntypedSubApp)object2;
                    yield FordiacImage.ICON_SUB_APP.getImage();
                }
                case 1 -> {
                    TypedSubApp o = (TypedSubApp)object2;
                    yield FordiacImage.ICON_SUB_APP_TYPE.getImage();
                }
                case 2 -> {
                    SubAppType o = (SubAppType)object2;
                    yield FordiacImage.ICON_SUB_APP_TYPE.getImage();
                }
                case 3 -> {
                    FunctionFBType o = (FunctionFBType)object2;
                    yield FordiacImage.ICON_FUNCTION.getImage();
                }
                case 4 -> {
                    StructManipulator o = (StructManipulator)object2;
                    yield FordiacImage.ICON_SIFB.getImage();
                }
                case 5 -> {
                    IInterfaceElement o = (IInterfaceElement)object2;
                    yield FordiacImage.ICON_INTERFACE_LIST.getImage();
                }
                case 6 -> {
                    Connection o = (Connection)object2;
                    yield FordiacImage.ICON_HIDE_DATA.getImage();
                }
                case 7 -> {
                    AutomationSystem o = (AutomationSystem)object2;
                    yield FordiacImage.ICON_SYSTEM.getImage();
                }
                case 8 -> {
                    Application o = (Application)object2;
                    yield FordiacImage.ICON_APPLICATION.getImage();
                }
                case 9 -> {
                    CFBInstance o = (CFBInstance)object2;
                    yield FordiacImage.ICON_COMPOSITE_FB.getImage();
                }
                case 10 -> {
                    FB o = (FB)object2;
                    yield FordiacImage.ICON_FB.getImage();
                }
                case 11 -> {
                    SimpleFBType o = (SimpleFBType)object2;
                    yield FordiacImage.ICON_SIMPLE_FB.getImage();
                }
                case 12 -> {
                    BasicFBType o = (BasicFBType)object2;
                    yield FordiacImage.ICON_BASIC_FB.getImage();
                }
                case 13 -> {
                    FBType o = (FBType)object2;
                    yield FordiacImage.ICON_FB_TYPE.getImage();
                }
                case 14 -> {
                    AttributeDeclaration o = (AttributeDeclaration)object2;
                    yield FordiacImage.ICON_ATTRIBUTE_DECLARATION.getImage();
                }
                case 15 -> {
                    DataType o = (DataType)object2;
                    yield FordiacImage.ICON_DATA_TYPE.getImage();
                }
                default -> super.getImage(element);
            };
        }

        public Color getForeground(Object element) {
            if (this.disabledElements.contains(element)) {
                return Display.getCurrent().getSystemColor(15);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

