/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.intermediate;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.elk.alg.rectpacking.options.RectPackingOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.common.util.EList;

public class InteractiveNodeReorderer
implements ILayoutProcessor<ElkNode> {
    public void process(ElkNode graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Interactive Node Reorderer", 1.0f);
        EList rectangles = graph.getChildren();
        ArrayList<ElkNode> fixedNodes = new ArrayList<ElkNode>();
        for (ElkNode elkNode : rectangles) {
            if (!elkNode.hasProperty(RectPackingOptions.DESIRED_POSITION)) continue;
            fixedNodes.add(elkNode);
        }
        for (ElkNode elkNode : fixedNodes) {
            rectangles.remove(elkNode);
        }
        Collections.sort(fixedNodes, (a, b) -> {
            int positionB;
            int positionA = (Integer)a.getProperty(RectPackingOptions.DESIRED_POSITION);
            if (positionA == (positionB = ((Integer)b.getProperty(RectPackingOptions.DESIRED_POSITION)).intValue())) {
                return -1;
            }
            return Integer.compare(positionA, positionB);
        });
        for (ElkNode elkNode : fixedNodes) {
            int position = (Integer)elkNode.getProperty(RectPackingOptions.DESIRED_POSITION);
            position = Math.min(position, rectangles.size());
            rectangles.add(position, elkNode);
        }
        int index = 0;
        for (ElkNode elkNode : rectangles) {
            elkNode.setProperty(RectPackingOptions.CURRENT_POSITION, (Object)index);
            ++index;
        }
        progressMonitor.done();
    }
}

