/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import java.util.List;
import org.eclipse.draw2d.AncestorListener;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.CommentTypeField;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.ui.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

class CommentTypeEditPart
extends AbstractGraphicalEditPart
implements AnnotableGraphicalEditPart {
    private static final int WITH_SIZE = 10;
    private static final int DISTANCE_TO_FB_BORDER = 15;
    private InterfaceEditPart referencedInterface;
    private final Adapter contentAdapter = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (1 == notification.getEventType()) {
                CommentTypeEditPart.this.refreshVisuals();
            }
        }
    };

    CommentTypeEditPart() {
    }

    public void activate() {
        super.activate();
        this.getModel().getReferencedElement().eAdapters().add((Object)this.contentAdapter);
        this.setupReferencedEP();
    }

    public void setupReferencedEP() {
        EditPart editPart = this.getViewer().getEditPartForModel((Object)this.getInterfaceElement());
        if (editPart instanceof InterfaceEditPart) {
            InterfaceEditPart iep;
            this.referencedInterface = iep = (InterfaceEditPart)editPart;
            this.referencedInterface.getFigure().addAncestorListener(new AncestorListener(){

                public void ancestorRemoved(IFigure ancestor) {
                }

                public void ancestorMoved(IFigure ancestor) {
                    CommentTypeEditPart.this.refreshVisuals();
                }

                public void ancestorAdded(IFigure ancestor) {
                    CommentTypeEditPart.this.refreshVisuals();
                }
            });
        }
    }

    public void deactivate() {
        super.deactivate();
        this.getModel().getReferencedElement().eAdapters().remove((Object)this.contentAdapter);
    }

    public void refresh() {
        super.refresh();
        this.refreshPosition();
    }

    public void refreshVisuals() {
        super.refreshVisuals();
        this.refreshPosition();
    }

    public void updateAnnotations(GraphicalAnnotationModelEvent event) {
        this.getChildren().stream().filter(AnnotableGraphicalEditPart.class::isInstance).map(AnnotableGraphicalEditPart.class::cast).forEach(child -> child.updateAnnotations(event));
    }

    public InterfaceEditPart getReferencedInterface() {
        return this.referencedInterface;
    }

    private void refreshPosition() {
        if (this.getParent() != null && this.getInterfaceElement().eContainer() != null) {
            Rectangle bounds = null;
            Point p = this.calculatePos();
            bounds = new Rectangle(p.x, p.y, this.getFigureWidth(), -1);
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
        }
    }

    private Point calculatePos() {
        if (this.referencedInterface != null) {
            Rectangle bounds = this.referencedInterface.getFigure().getBounds();
            InterfaceList interfaceList = this.getInterfaceElement().getInterfaceList();
            int dx = 0;
            if (this.getInterfaceElement().isIsInput()) {
                int countInputEvWITH = CommentTypeEditPart.getNrEvWITH((EList<Event>)interfaceList.getEventInputs());
                dx = -15 - this.getFigureWidth() - countInputEvWITH * 10;
            } else {
                int countOutputEvWITH = CommentTypeEditPart.getNrEvWITH((EList<Event>)interfaceList.getEventOutputs());
                dx = 15 + bounds.width + countOutputEvWITH * 10;
            }
            return new Point(bounds.x + dx, bounds.y);
        }
        return new Point(0, 0);
    }

    private static int getNrEvWITH(EList<Event> eList) {
        return (int)eList.stream().filter(ev -> !ev.getWith().isEmpty()).count();
    }

    private int getFigureWidth() {
        return this.getFigure().getPreferredSize().width;
    }

    public CommentTypeField getModel() {
        return (CommentTypeField)super.getModel();
    }

    public IInterfaceElement getInterfaceElement() {
        return this.getModel().getReferencedElement();
    }

    protected IFigure createFigure() {
        return new CommentTypeContainerFigure();
    }

    protected void createEditPolicies() {
    }

    protected List<Object> getModelChildren() {
        return this.getModel().getChildren();
    }

    private static class CommentTypeContainerFigure
    extends Figure {
        public CommentTypeContainerFigure() {
            GridLayout layout = new GridLayout(3, false);
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            this.setLayoutManager((LayoutManager)layout);
        }
    }
}

