/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbrtlauncher;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.fordiac.ide.fbrtlauncher.Messages;
import org.eclipse.fordiac.ide.runtime.RuntimeLaunchTab;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.widget.DirectoryChooserControl;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class FBRTLaunchTab
extends RuntimeLaunchTab {
    private static final String DEFAULT_FBRT_PORT = "61500";
    private static final String ATTR_FBRT_DEV_TYPE = "org.eclipse.fordiac.ide.fbrtlauncher.deviceType";
    private static final String ATTR_FBRT_PORT = "org.eclipse.fordiac.ide.fbrtlauncher.port";
    private static final String[] FBRT_DEV_TYPES = new String[]{"RMT_FRAME", "RMT_DEV"};
    private static final String DEFAULT_FBRT_DEV_TYPE = FBRT_DEV_TYPES[0];
    private DirectoryChooserControl workingDirChooser;
    private Combo devType;

    public void createControl(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)parent);
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(comp);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)comp);
        this.setControl((Control)comp);
        this.workingDirChooser = new DirectoryChooserControl(comp, 0, Messages.FBRTPreferencePage_FBRTLocation, true);
        this.workingDirChooser.addChooserValueChangedListener(newVal -> this.scheduleUpdateJob());
        this.createDevType(comp);
        this.createPortSelection(comp);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", FBRTLaunchTab.getJavaRte());
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.fbrtlauncher");
        String fbrtPath = store.getString("pathPreference");
        if (fbrtPath != null && !fbrtPath.isBlank()) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", fbrtPath);
        }
        configuration.setAttribute(ATTR_FBRT_DEV_TYPE, DEFAULT_FBRT_DEV_TYPE);
        configuration.setAttribute(ATTR_FBRT_PORT, DEFAULT_FBRT_PORT);
        FBRTLaunchTab.updateLaunchArguments(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.workingDirChooser.setValue(configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", ""));
            this.devType.select(FBRTLaunchTab.getSelectedDevTypeIndex(configuration.getAttribute(ATTR_FBRT_DEV_TYPE, DEFAULT_FBRT_DEV_TYPE)));
            this.setPortValue(configuration.getAttribute(ATTR_FBRT_PORT, DEFAULT_FBRT_PORT));
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String workingDir = this.workingDirChooser.getValue();
        if (!workingDir.isBlank()) {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", workingDir);
        }
        configuration.setAttribute(ATTR_FBRT_DEV_TYPE, FBRT_DEV_TYPES[this.devType.getSelectionIndex()]);
        configuration.setAttribute(ATTR_FBRT_PORT, this.getPortValue());
        FBRTLaunchTab.updateLaunchArguments(configuration);
    }

    public String getName() {
        return Messages.FBRTLaunchTab_TabName;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (!super.isValid(launchConfig)) {
            return false;
        }
        if (this.workingDirChooser.getValue().isBlank()) {
            this.setErrorMessage(Messages.FBRTLaunchTab_NoFBRTDirectorySet);
            return false;
        }
        return true;
    }

    private void createDevType(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.FBRTLaunchTab_DeviceType);
        this.devType = new Combo(parent, 2056);
        Arrays.stream(FBRT_DEV_TYPES).forEach(arg_0 -> ((Combo)this.devType).add(arg_0));
        GridDataFactory.fillDefaults().align(1, 2).applyTo((Control)this.devType);
        this.devType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FBRTLaunchTab.this.scheduleUpdateJob();
            }
        });
    }

    private static String getJavaRte() {
        Object javaRte = System.getProperty("java.home");
        if (((String)javaRte).isEmpty()) {
            return "";
        }
        javaRte = (String)javaRte + File.separatorChar + "bin" + File.separatorChar + "java";
        if (Platform.getOS().equalsIgnoreCase("win32")) {
            javaRte = (String)javaRte + ".exe";
        }
        return javaRte;
    }

    private static void updateLaunchArguments(ILaunchConfigurationWorkingCopy configuration) {
        try {
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", FBRTLaunchTab.getJavaRte());
            String portNum = configuration.getAttribute(ATTR_FBRT_PORT, DEFAULT_FBRT_PORT);
            String devType = configuration.getAttribute(ATTR_FBRT_DEV_TYPE, DEFAULT_FBRT_DEV_TYPE);
            String arguments = "-jar device.jar FBRT_WINDOW " + devType + " MGR_ID \"localhost:" + portNum + "\"";
            configuration.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", arguments);
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    private static int getSelectedDevTypeIndex(String devType) {
        int i = 0;
        while (i < FBRT_DEV_TYPES.length) {
            if (FBRT_DEV_TYPES[i].equals(devType)) {
                return i;
            }
            ++i;
        }
        return 0;
    }
}

