/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.ColorProvider;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.figures.AbstractFreeformFigure;

public class BackgroundFreeformFigure
extends AbstractFreeformFigure {
    private static final double CANVAS_SCALING_FACTOR = 0.9;
    final ZoomScalableFreeformRootEditPart zoomScalableFreeformRootEditPart;

    public BackgroundFreeformFigure(ZoomScalableFreeformRootEditPart zoomScalableFreeformRootEditPart) {
        this.zoomScalableFreeformRootEditPart = zoomScalableFreeformRootEditPart;
        this.setOpaque(true);
        this.setBackgroundColor(ColorProvider.SystemColorFactory.getColorProvider().getMenuBackground());
    }

    @Override
    protected Rectangle calculateFreeformExtent() {
        Rectangle newExtents = this.getContents().getFreeformExtent().getCopy();
        Dimension bckArea = this.getBackgroundArea();
        newExtents.expand(bckArea.width, bckArea.height);
        return newExtents;
    }

    @Override
    protected void setChildBounds(Rectangle childBounds) {
        Dimension bckArea = this.getBackgroundArea();
        super.setChildBounds(childBounds.getShrinked(bckArea.width, bckArea.height));
    }

    Dimension getBackgroundArea() {
        org.eclipse.swt.graphics.Rectangle canvasBounds = this.getCanvasBounds();
        return new Dimension((int)((double)canvasBounds.width * 0.9), (int)((double)canvasBounds.height * 0.9));
    }

    private org.eclipse.swt.graphics.Rectangle getCanvasBounds() {
        FigureCanvas figureCanvas = (FigureCanvas)this.zoomScalableFreeformRootEditPart.getViewer().getControl();
        return figureCanvas.getBounds();
    }
}

