/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.copy.command;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.copy.serializing.CopyDataToClipboardSerializer;
import org.eclipse.nebula.widgets.nattable.copy.serializing.CopyFormattedTextToClipboardSerializer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class CopyDataCommandHandler
extends AbstractLayerCommandHandler<CopyDataToClipboardCommand> {
    protected final SelectionLayer selectionLayer;
    private final ILayer columnHeaderLayer;
    private final ILayer rowHeaderLayer;
    private IUniqueIndexLayer copyLayer;
    private boolean copyFormattedText;

    public CopyDataCommandHandler(SelectionLayer selectionLayer) {
        this(selectionLayer, null, null);
    }

    public CopyDataCommandHandler(SelectionLayer selectionLayer, ILayer columnHeaderLayer, ILayer rowHeaderLayer) {
        if (selectionLayer == null) {
            throw new IllegalArgumentException("The SelectionLayer can not be null on creating a CopyDataCommandHandler");
        }
        this.selectionLayer = selectionLayer;
        this.columnHeaderLayer = columnHeaderLayer;
        this.rowHeaderLayer = rowHeaderLayer;
    }

    public void setCopyLayer(IUniqueIndexLayer copyLayer) {
        this.copyLayer = copyLayer;
    }

    public void setCopyFormattedText(boolean copyFormattedText) {
        this.copyFormattedText = copyFormattedText;
    }

    @Override
    public boolean doCommand(CopyDataToClipboardCommand command) {
        this.internalDoCommand(command, this.assembleCopiedDataStructure());
        return true;
    }

    protected void internalDoCommand(CopyDataToClipboardCommand command, ILayerCell[][] assembledCopiedDataStructure) {
        if (assembledCopiedDataStructure != null) {
            CopyDataToClipboardSerializer serializer = this.copyFormattedText ? new CopyFormattedTextToClipboardSerializer(assembledCopiedDataStructure, command) : new CopyDataToClipboardSerializer(assembledCopiedDataStructure, command);
            serializer.serialize();
        }
    }

    @Override
    public Class<CopyDataToClipboardCommand> getCommandClass() {
        return CopyDataToClipboardCommand.class;
    }

    protected ILayerCell[][] assembleCopiedDataStructure() {
        ILayerCell[][] columnHeaderCells;
        Set<Range> selectedRows = this.selectionLayer.getSelectedRowPositions();
        ArrayList<ILayerCell[]> copiedCells = new ArrayList<ILayerCell[]>();
        ILayerCell[][] iLayerCellArray = columnHeaderCells = this.assembleColumnHeaders();
        int n = columnHeaderCells.length;
        int n2 = 0;
        while (n2 < n) {
            ILayerCell[] cells = iLayerCellArray[n2];
            if (!this.isEmpty(cells)) {
                copiedCells.add(cells);
            }
            ++n2;
        }
        TreeSet<Integer> selectedRowPositions = new TreeSet<Integer>();
        for (Range range : selectedRows) {
            int rowPosition = range.start;
            while (rowPosition < range.end) {
                if (this.selectionLayer.getRowHeightByPosition(rowPosition) > 0) {
                    selectedRowPositions.add(rowPosition);
                }
                ++rowPosition;
            }
        }
        Iterator<Range> iterator = selectedRowPositions.iterator();
        while (iterator.hasNext()) {
            int rowPos = (Integer)((Object)iterator.next());
            ILayerCell[] body = this.assembleBody(rowPos);
            if (body == null) continue;
            copiedCells.add(body);
        }
        ILayerCell[][] result = new ILayerCell[copiedCells.size()][1];
        ILayerCell[] cells = null;
        boolean atLeastOne = false;
        int i = 0;
        while (i < copiedCells.size()) {
            cells = (ILayerCell[])copiedCells.get(i);
            if (!atLeastOne && !this.isEmpty(cells)) {
                atLeastOne = true;
            }
            result[i] = cells;
            ++i;
        }
        return atLeastOne ? result : null;
    }

    protected ILayerCell[][] assembleColumnHeaders() {
        int rowOffset = this.columnHeaderLayer != null ? this.columnHeaderLayer.getRowCount() : 0;
        int columnOffset = this.rowHeaderLayer != null ? this.rowHeaderLayer.getColumnCount() : 0;
        ILayerCell[][] copiedCells = new ILayerCell[this.selectionLayer.getSelectedRowCount() + rowOffset][1];
        if (this.columnHeaderLayer != null) {
            int[] selectedColumnPositions = this.getSelectedColumnPositions();
            ILayerCell cellToCopy = null;
            int i = 0;
            while (i < rowOffset) {
                ILayerCell[] cells = new ILayerCell[selectedColumnPositions.length + columnOffset];
                int columnPosition = 0;
                while (columnPosition < selectedColumnPositions.length) {
                    if (this.copyLayer == null) {
                        cellToCopy = this.columnHeaderLayer.getCellByPosition(selectedColumnPositions[columnPosition], i);
                    } else {
                        int copyColPos = LayerUtil.convertColumnPosition(this.selectionLayer, selectedColumnPositions[columnPosition], this.copyLayer);
                        cellToCopy = this.columnHeaderLayer.getCellByPosition(copyColPos, i);
                    }
                    if (this.isCopyAllowed(cellToCopy)) {
                        cells[columnPosition + columnOffset] = cellToCopy;
                    }
                    ++columnPosition;
                }
                copiedCells[i] = cells;
                ++i;
            }
        }
        return copiedCells;
    }

    protected ILayerCell[] assembleBody(int currentRowPosition) {
        int[] selectedColumns = this.getSelectedColumnPositions();
        int columnOffset = this.rowHeaderLayer != null ? this.rowHeaderLayer.getColumnCount() : 0;
        ILayerCell[] bodyCells = new ILayerCell[selectedColumns.length + columnOffset];
        ILayerCell cellToCopy = null;
        if (this.rowHeaderLayer != null) {
            int i = 0;
            while (i < this.rowHeaderLayer.getColumnCount()) {
                cellToCopy = this.rowHeaderLayer.getCellByPosition(i, currentRowPosition);
                if (this.isCopyAllowed(cellToCopy)) {
                    bodyCells[i] = cellToCopy;
                }
                ++i;
            }
        }
        int columnPosition = 0;
        while (columnPosition < selectedColumns.length) {
            int selectedColumnPosition = selectedColumns[columnPosition];
            if (this.selectionLayer.isCellPositionSelected(selectedColumnPosition, currentRowPosition)) {
                if (this.copyLayer == null) {
                    cellToCopy = this.selectionLayer.getCellByPosition(selectedColumnPosition, currentRowPosition);
                    if (this.isCopyAllowed(cellToCopy)) {
                        bodyCells[columnPosition + columnOffset] = cellToCopy;
                    }
                } else {
                    int copyRowPos;
                    int copyColPos = LayerUtil.convertColumnPosition(this.selectionLayer, selectedColumnPosition, this.copyLayer);
                    cellToCopy = this.copyLayer.getCellByPosition(copyColPos, copyRowPos = LayerUtil.convertRowPosition(this.selectionLayer, currentRowPosition, this.copyLayer));
                    if (this.isCopyAllowed(cellToCopy)) {
                        bodyCells[columnPosition + columnOffset] = cellToCopy;
                    }
                }
            }
            ++columnPosition;
        }
        return bodyCells;
    }

    protected int[] getSelectedColumnPositions() {
        ArrayList<Integer> selected = new ArrayList<Integer>();
        Object object = this.selectionLayer.getSelectedColumnPositions();
        int n = ((int[])object).length;
        int n2 = 0;
        while (n2 < n) {
            int pos = object[n2];
            if (this.selectionLayer.getColumnWidthByPosition(pos) > 0) {
                selected.add(pos);
            }
            ++n2;
        }
        int[] selectedColumns = new int[selected.size()];
        int index = 0;
        object = selected.iterator();
        while (object.hasNext()) {
            int pos;
            selectedColumns[index] = pos = ((Integer)object.next()).intValue();
            ++index;
        }
        return selectedColumns;
    }

    public ILayer getColumnHeaderLayer() {
        return this.columnHeaderLayer;
    }

    public ILayer getRowHeaderLayer() {
        return this.rowHeaderLayer;
    }

    public IUniqueIndexLayer getCopyLayer() {
        return this.copyLayer;
    }

    protected boolean isCopyAllowed(ILayerCell cellToCopy) {
        return true;
    }

    protected boolean isEmpty(ILayerCell[] layerCells) {
        if (layerCells != null) {
            ILayerCell[] iLayerCellArray = layerCells;
            int n = layerCells.length;
            int n2 = 0;
            while (n2 < n) {
                ILayerCell cell = iLayerCellArray[n2];
                if (cell != null) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }
}

