/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.ecore.opposites;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class AllInstancesContentAdapter
extends EContentAdapter {
    private Map<EClass, WeakHashMap<EObject, Object>> allInstances = new HashMap<EClass, WeakHashMap<EObject, Object>>();

    public static AllInstancesContentAdapter getInstanceForRootContextOf(Notifier context) {
        Notifier rootContext = AllInstancesContentAdapter.getRootContext(context);
        for (Adapter a : rootContext.eAdapters()) {
            if (!(a instanceof AllInstancesContentAdapter)) continue;
            return (AllInstancesContentAdapter)a;
        }
        AllInstancesContentAdapter result = new AllInstancesContentAdapter();
        rootContext.eAdapters().add((Object)result);
        return result;
    }

    private static Notifier getRootContext(Notifier context) {
        Object rootContext;
        if (context instanceof ResourceSet) {
            rootContext = context;
        } else if (context instanceof Resource) {
            rootContext = ((Resource)context).getResourceSet() != null ? ((Resource)context).getResourceSet() : context;
        } else if (context instanceof EObject) {
            ResourceSet rootResourceSet;
            EObject rootEObject = EcoreUtil.getRootContainer((EObject)((EObject)context));
            Resource rootResource = rootEObject.eResource();
            rootContext = rootResource != null ? ((rootResourceSet = rootResource.getResourceSet()) != null ? rootResourceSet : rootResource) : rootEObject;
        } else {
            throw new RuntimeException("What type of Notifier is this? " + context.getClass().getName());
        }
        return rootContext;
    }

    protected void setTarget(EObject target) {
        for (EClass c : target.eClass().getEAllSuperTypes()) {
            this.put(c, target);
        }
        this.put(target.eClass(), target);
        super.setTarget(target);
    }

    private void put(EClass c, EObject target) {
        WeakHashMap<Object, Object> set = this.allInstances.get(c);
        if (set == null) {
            set = new WeakHashMap();
            this.allInstances.put(c, set);
        }
        set.put(target, null);
    }

    protected void unsetTarget(EObject target) {
        for (EClass c : target.eClass().getEAllSuperTypes()) {
            this.remove(c, target);
        }
        this.remove(target.eClass(), target);
        super.unsetTarget(target);
    }

    private void remove(EClass c, EObject target) {
        WeakHashMap<EObject, Object> set = this.allInstances.get(c);
        if (set != null && set.remove(target) != null && set.isEmpty()) {
            this.allInstances.remove(c);
        }
    }

    public Set<EObject> allInstances(EClass c) {
        WeakHashMap<EObject, Object> map = this.allInstances.get(c);
        Set<Object> result = map == null ? Collections.emptySet() : map.keySet();
        return result;
    }
}

