/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.util.ICalculatedValueCache;
import org.eclipse.nebula.widgets.nattable.util.ICalculatedValueCacheKey;
import org.eclipse.nebula.widgets.nattable.util.ICalculator;

public class SafeCalculatedValueCache
implements ICalculatedValueCache {
    private ILayer layer;
    private final ExecutorService executor;
    private final Map<ICalculatedValueCacheKey, Object> cache = new ConcurrentHashMap<ICalculatedValueCacheKey, Object>();
    private final Map<ICalculatedValueCacheKey, Object> cacheCopy = new ConcurrentHashMap<ICalculatedValueCacheKey, Object>();
    private final Set<ICalculatedValueCacheKey> executing = ConcurrentHashMap.newKeySet();
    private final boolean useColumnAsKey;
    private final boolean useRowAsKey;
    private final boolean smoothUpdates;

    public SafeCalculatedValueCache(ILayer layer, boolean useColumnAsKey, boolean useRowAsKey) {
        this(layer, useColumnAsKey, useRowAsKey, true);
    }

    public SafeCalculatedValueCache(ILayer layer, boolean useColumnAsKey, boolean useRowAsKey, boolean smoothUpdates) {
        this.layer = layer;
        this.executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() + 1, Runtime.getRuntime().availableProcessors() + 1, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        ((ThreadPoolExecutor)this.executor).allowCoreThreadTimeOut(true);
        this.useColumnAsKey = useColumnAsKey;
        this.useRowAsKey = useRowAsKey;
        this.smoothUpdates = smoothUpdates;
    }

    public Object getCalculatedValue(int columnPosition, int rowPosition, boolean calculateInBackground, ICalculator calculator) {
        Object key = null;
        if (this.useColumnAsKey && this.useRowAsKey) {
            key = new CoordinateValueCacheKey(columnPosition, rowPosition);
        } else if (this.useColumnAsKey) {
            key = new PositionValueCacheKey(columnPosition);
        } else if (this.useRowAsKey) {
            key = new PositionValueCacheKey(rowPosition);
        } else {
            throw new IllegalStateException("SafeCalculatedValueCacheKey is configured to not use column or row position. Use getCalculatedValue() with ICalculatedValueCacheKey parameter instead.");
        }
        return this.getCalculatedValue(columnPosition, rowPosition, (ICalculatedValueCacheKey)key, calculateInBackground, calculator);
    }

    public Object getCalculatedValue(int columnPosition, int rowPosition, ICalculatedValueCacheKey key, boolean calculateInBackground, ICalculator calculator) {
        Object result = null;
        if (calculateInBackground) {
            Object cacheCopyValue;
            Object cacheValue = this.cache.get(key);
            result = cacheCopyValue = this.cacheCopy.get(key);
            if (cacheCopyValue == null || !Objects.equals(cacheValue, cacheCopyValue)) {
                if (!this.smoothUpdates) {
                    result = null;
                }
                if (this.executing.add(key)) {
                    this.executor.execute(() -> {
                        Object summaryValue = calculator.executeCalculation();
                        this.addToCache(key, summaryValue);
                        this.executing.remove(key);
                        if (!Objects.equals(summaryValue, cacheCopyValue) && this.layer != null) {
                            this.layer.fireLayerEvent((ILayerEvent)new CellVisualChangeEvent(this.layer, columnPosition, rowPosition));
                        }
                    });
                }
            }
        } else {
            result = calculator.executeCalculation();
            this.addToCache(key, result);
        }
        return result;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public void killCache() {
        this.cache.clear();
        this.cacheCopy.clear();
    }

    protected void addToCache(ICalculatedValueCacheKey key, Object value) {
        if (value != null) {
            this.cache.put(key, value);
            this.cacheCopy.put(key, value);
        } else {
            this.cache.remove(key);
            this.cacheCopy.remove(key);
        }
    }

    public void dispose() {
        this.executor.shutdownNow();
    }

    public void setLayer(ILayer layer) {
        this.layer = layer;
    }

    class CoordinateValueCacheKey
    implements ICalculatedValueCacheKey {
        private final int columnPosition;
        private final int rowPosition;

        public CoordinateValueCacheKey(int columnPosition, int rowPosition) {
            this.columnPosition = columnPosition;
            this.rowPosition = rowPosition;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.columnPosition;
            result = 31 * result + this.rowPosition;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CoordinateValueCacheKey other = (CoordinateValueCacheKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.columnPosition != other.columnPosition) {
                return false;
            }
            return this.rowPosition == other.rowPosition;
        }

        private SafeCalculatedValueCache getOuterType() {
            return SafeCalculatedValueCache.this;
        }
    }

    class PositionValueCacheKey
    implements ICalculatedValueCacheKey {
        private final int position;

        public PositionValueCacheKey(int position) {
            this.position = position;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.position;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PositionValueCacheKey other = (PositionValueCacheKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.position == other.position;
        }

        private SafeCalculatedValueCache getOuterType() {
            return SafeCalculatedValueCache.this;
        }
    }
}

