/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.nebula.jface.gridviewer.GridColumnLayout;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerEditor;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.nebula.widgets.grid.IRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultColumnHeaderRenderer;
import org.eclipse.nebula.widgets.grid.internal.DefaultEmptyColumnHeaderRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class NebulaGridWidgetFactory {
    public static GridTableViewer createPropertyGridTableViewer(Composite parent, GridColumnLayout layout) {
        return NebulaGridWidgetFactory.createPropertyGridTableViewer(parent, layout, 0);
    }

    public static GridTableViewer createPropertyGridTableViewer(Composite parent, GridColumnLayout layout, int style) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        composite.setLayout((Layout)layout);
        GridTableViewer gridTableViewer = new GridTableViewer(composite, 0x10B02 | style);
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)gridTableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        GridViewerEditor.create((GridTableViewer)gridTableViewer, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        return gridTableViewer;
    }

    public static GridHeaderRenderer createSimpleColumnHeader() {
        return new DefaultColumnHeaderRenderer(){

            public void paint(GC gc, Object value) {
                GridColumn column = (GridColumn)value;
                Color lineColor = this.getDisplay().getSystemColor(22);
                int x = this.getBounds().x;
                int y = this.getBounds().y;
                int width = this.getBounds().width;
                int height = this.getBounds().height;
                Color oldForeground = gc.getForeground();
                gc.setForeground(lineColor);
                gc.drawRectangle(x - 1, y - 1, width, height);
                gc.setForeground(oldForeground);
                String text = column.getText();
                gc.drawString(text, x + 4, y + 2);
            }
        };
    }

    public static IRenderer createSimpleEmptyColumnHeader() {
        return new DefaultEmptyColumnHeaderRenderer(){

            public void paint(GC gc, Object value) {
                Color oldForeground = gc.getForeground();
                gc.setForeground(this.getDisplay().getSystemColor(22));
                gc.drawRectangle(this.getBounds().x - 1, this.getBounds().y - 1, this.getBounds().width + 1, this.getBounds().height);
                gc.setForeground(oldForeground);
            }
        };
    }

    private NebulaGridWidgetFactory() {
        throw new UnsupportedOperationException("Widget Factory should not be instantiated");
    }
}

