/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.resource;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.model.datatype.helper.TypeDeclarationParser;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.TypedConfigureableObject;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.resource.STCoreResourceDescription;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpressionSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTypeDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IDefaultResourceDescriptionStrategy;
import org.eclipse.xtext.util.IResourceScopeCache;

public class STAlgorithmResourceDescription
extends STCoreResourceDescription {
    public STAlgorithmResourceDescription(Resource resource, IDefaultResourceDescriptionStrategy strategy, IResourceScopeCache cache, IQualifiedNameConverter nameConverter) {
        super(resource, strategy, cache, nameConverter);
    }

    protected void computeImportedNames(EObject object, Set<QualifiedName> result) {
        EObject eObject = object;
        Objects.requireNonNull(eObject);
        EObject eObject2 = eObject;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Attribute.class, VarDeclaration.class, TypedConfigureableObject.class, Import.class}, (Object)eObject2, 0)) {
            case 0: {
                Attribute attribute = (Attribute)eObject2;
                this.computeImportedNames(attribute, result);
                break;
            }
            case 1: {
                VarDeclaration varDeclaration = (VarDeclaration)eObject2;
                this.computeImportedNames(varDeclaration, result);
                break;
            }
            case 2: {
                TypedConfigureableObject typedConfigureableObject = (TypedConfigureableObject)eObject2;
                this.computeImportedNames(typedConfigureableObject, result);
                break;
            }
            case 3: {
                Import imp = (Import)eObject2;
                this.computeImportedNames(imp, result);
                break;
            }
        }
    }

    protected void computeImportedNames(Attribute attr, Set<QualifiedName> result) {
        STInitializerExpressionSource source;
        String fullTypeName = PackageNameHelper.getFullTypeName((LibraryElement)attr.getType());
        if (fullTypeName != null && !fullTypeName.isEmpty()) {
            result.add(this.getNameConverter().toQualifiedName(fullTypeName).toLowerCase());
        }
        if (!STCoreUtil.isSimpleAttributeValue((Attribute)attr, (boolean)false) && (source = StructuredTextParseUtil.validate(attr.getValue(), this.getURI(), STCoreUtil.getFeatureType((INamedElement)attr), (LibraryElement)EcoreUtil2.getContainerOfType((EObject)attr, LibraryElement.class), null, null)) != null) {
            result.addAll(STAlgorithmResourceDescription.getImportedNames((Resource)source.eResource()));
        }
    }

    protected void computeImportedNames(VarDeclaration decl, Set<QualifiedName> result) {
        STTypeDeclaration source;
        String fullTypeName = PackageNameHelper.getFullTypeName((LibraryElement)decl.getType());
        if (fullTypeName != null && !fullTypeName.isEmpty()) {
            result.add(this.getNameConverter().toQualifiedName(fullTypeName).toLowerCase());
        }
        if (decl.isArray() && !TypeDeclarationParser.isSimpleTypeDeclaration((String)decl.getArraySize().getValue()) && (source = StructuredTextParseUtil.validateType(decl, null)) != null) {
            result.addAll(STAlgorithmResourceDescription.getImportedNames((Resource)source.eResource()));
        }
        if (!STCoreUtil.isSimpleInitialValue((VarDeclaration)decl, (boolean)false) && (source = StructuredTextParseUtil.validate(decl.getValue().getValue(), this.getURI(), STCoreUtil.getFeatureType((INamedElement)decl), (LibraryElement)EcoreUtil2.getContainerOfType((EObject)decl, LibraryElement.class), null, null)) != null) {
            result.addAll(STAlgorithmResourceDescription.getImportedNames((Resource)source.eResource()));
        }
    }

    protected void computeImportedNames(TypedConfigureableObject element, Set<QualifiedName> result) {
        String fullTypeName = element.getFullTypeName();
        if (fullTypeName != null && !fullTypeName.isEmpty()) {
            result.add(this.getNameConverter().toQualifiedName(fullTypeName).toLowerCase());
        }
    }
}

