/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import org.eclipse.fordiac.ide.model.data.AnyDateType;
import org.eclipse.fordiac.ide.model.data.AnyDurationType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EnumeratedType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.value.TypedValue;
import org.eclipse.fordiac.ide.model.value.TypedValueConverter;

public abstract class AbstractVariable<T extends Value>
implements Variable<T> {
    private final String name;
    private final LibraryElement type;

    protected AbstractVariable(String name, LibraryElement type) {
        this.name = name;
        this.type = type;
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean pretty) {
        DataType dataType;
        LibraryElement valueType = this.getValue().getType();
        LibraryElement libraryElement = this.type;
        if (libraryElement instanceof DataType && IecTypes.GenericTypes.isAnyType((DataType)(dataType = (DataType)libraryElement)) && !(valueType instanceof AnyDurationType) && !(valueType instanceof AnyDateType) && !(valueType instanceof EnumeratedType)) {
            return PackageNameHelper.getFullTypeName((LibraryElement)valueType) + "#" + this.getValue().toString(pretty);
        }
        return this.getValue().toString(pretty);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public LibraryElement getType() {
        return this.type;
    }

    @Override
    public final void setValue(String value) throws IllegalArgumentException {
        this.setValue(value, null);
    }

    @Override
    public void setValue(String value, TypeLibrary typeLibrary) {
        if (value == null || value.isEmpty()) {
            this.setValue(ValueOperations.defaultValue(this.type));
        } else {
            LibraryElement libraryElement = this.type;
            if (libraryElement instanceof DataType) {
                DataType dataType = (DataType)libraryElement;
                this.setValue(new TypedValueConverter(dataType, typeLibrary != null ? typeLibrary.getDataTypeLibrary() : null).toTypedValue(value));
            } else {
                throw new UnsupportedOperationException("The type " + this.type.getName() + " is not supported");
            }
        }
    }

    @Override
    public void setValue(TypedValue value) {
        this.setValue(ValueOperations.wrapValue(value.value(), (LibraryElement)value.type()));
    }

    @Override
    public final boolean validateValue(String value) {
        return this.validateValue(value, null);
    }

    @Override
    public boolean validateValue(String value, TypeLibrary typeLibrary) {
        try {
            ValueOperations.parseValue(value, this.getType(), typeLibrary != null ? typeLibrary.getDataTypeLibrary() : null);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected RuntimeException createCastException(Value value) {
        throw new ClassCastException("Cannot assign value with incompatible type " + value.getType().getName() + " as " + this.type.getName());
    }

    protected RuntimeException createCastException(TypedValue value) {
        throw new ClassCastException("Cannot assign value with incompatible type " + value.type().getName() + " as " + this.type.getName());
    }
}

