/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;

public class AddNewImportCommand
extends CreationCommand
implements ScopedCommand {
    private Import importer;
    private final LibraryElement type;
    private final String importedNamespace;

    public AddNewImportCommand(LibraryElement type) {
        this(type, FordiacMessages.Unknown);
    }

    public AddNewImportCommand(LibraryElement type, String importedNamespace) {
        this.type = Objects.requireNonNull(type);
        this.importedNamespace = importedNamespace;
    }

    public void execute() {
        this.importer = LibraryElementFactory.eINSTANCE.createImport();
        this.importer.setImportedNamespace(this.importedNamespace);
        this.redo();
    }

    public void undo() {
        ImportHelper.getMutableImports((LibraryElement)this.type).remove((Object)this.importer);
    }

    public void redo() {
        ImportHelper.getMutableImports((LibraryElement)this.type).add((Object)this.importer);
    }

    public Object getCreatedElement() {
        return this.importer;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.type);
    }
}

