/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.build;

import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.hierarchymanager.build.Messages;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.HierarchyPackage;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Leaf;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.xtext.builder.IXtextBuilderParticipant;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.FileExtensionProvider;
import org.eclipse.xtext.resource.IResourceDescription;

public class HierarchyBuilderParticipant
implements IXtextBuilderParticipant {
    @Inject
    private FileExtensionProvider fileExtensionProvider;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public void build(IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        List<IResourceDescription.Delta> deltas = this.getRelevantDeltas(context);
        for (IResourceDescription.Delta delta : deltas) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (delta.getOld() != null) {
                HierarchyBuilderParticipant.doClean(delta);
            }
            if (delta.getNew() == null) continue;
            this.doBuild(delta, context, monitor);
        }
    }

    protected void doBuild(IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context, IProgressMonitor monitor) throws CoreException {
        try {
            HashSet<URI> references = new HashSet<URI>();
            Resource resource = context.getResourceSet().getResource(delta.getUri(), true);
            TreeIterator allContents = EcoreUtil.getAllContents((Resource)resource, (boolean)true);
            while (allContents.hasNext()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                EObject target = (EObject)allContents.next();
                if (!(target instanceof Leaf)) continue;
                Leaf leaf = (Leaf)target;
                this.validateLeaf(leaf, references, delta, context);
            }
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new CoreException(Status.error((String)("Exception processing build delta " + delta.getUri().toString()), (Throwable)e));
        }
    }

    protected static void doClean(IResourceDescription.Delta delta) throws CoreException {
        IFile file = HierarchyBuilderParticipant.getFile(delta.getOld().getURI());
        if (file != null && file.exists()) {
            file.deleteMarkers("org.eclipse.fordiac.ide.hierarchymanager.model.problem", true, 2);
        }
    }

    private void validateLeaf(Leaf leaf, Set<URI> references, IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context) throws CoreException {
        Resource resource = this.loadContainerFile(leaf, delta, context);
        if (resource == null) {
            return;
        }
        Optional<LibraryElement> libraryElement = resource.getContents().stream().filter(LibraryElement.class::isInstance).map(LibraryElement.class::cast).findFirst();
        if (libraryElement.isEmpty()) {
            this.createMarker(MessageFormat.format(Messages.HierarchyBuilderParticipant_NoSuchLibraryElement, leaf.getContainerFileName()), (EObject)leaf, (EStructuralFeature)HierarchyPackage.Literals.LEAF__CONTAINER_FILE_NAME, delta.getUri());
            return;
        }
        Optional referencedElement = libraryElement.get().findByQualifiedName(leaf.getRef()).findAny();
        if (referencedElement.isEmpty()) {
            this.createMarker(MessageFormat.format(Messages.HierarchyBuilderParticipant_NoSuchReferencedElement, leaf.getRef(), leaf.getContainerFileName()), (EObject)leaf, (EStructuralFeature)HierarchyPackage.Literals.LEAF__REF, delta.getUri());
        } else if (!references.add(EcoreUtil.getURI((EObject)((EObject)referencedElement.get())))) {
            this.createMarker(MessageFormat.format(Messages.HierarchyBuilderParticipant_DuplicateReferencedElement, leaf.getRef(), leaf.getContainerFileName()), (EObject)leaf, (EStructuralFeature)HierarchyPackage.Literals.LEAF__REF, delta.getUri());
        }
    }

    protected Resource loadContainerFile(Leaf leaf, IResourceDescription.Delta delta, IXtextBuilderParticipant.IBuildContext context) throws CoreException {
        IFile containerFile = context.getBuiltProject().getFile(leaf.getContainerFileName());
        if (!containerFile.exists()) {
            this.createMarker(MessageFormat.format(Messages.HierarchyBuilderParticipant_NoSuchContainerFile, leaf.getContainerFileName()), (EObject)leaf, (EStructuralFeature)HierarchyPackage.Literals.LEAF__CONTAINER_FILE_NAME, delta.getUri());
            return null;
        }
        URI containerURI = URI.createPlatformResourceURI((String)containerFile.getFullPath().toString(), (boolean)true);
        try {
            return context.getResourceSet().getResource(containerURI, true);
        }
        catch (Exception e) {
            this.createMarker(MessageFormat.format(Messages.HierarchyBuilderParticipant_CannotLoadContainerFile, leaf.getContainerFileName(), e.getLocalizedMessage()), (EObject)leaf, (EStructuralFeature)HierarchyPackage.Literals.LEAF__CONTAINER_FILE_NAME, delta.getUri());
            return null;
        }
    }

    protected void createMarker(String message, EObject target, EStructuralFeature feature, URI uri) throws CoreException {
        IFile file = HierarchyBuilderParticipant.getFile(uri);
        QualifiedName qualifiedName = this.qualifiedNameProvider.getFullyQualifiedName(target.eContainer());
        if (file != null && file.exists() && qualifiedName != null) {
            ErrorMarkerBuilder.createErrorMarkerBuilder((String)message).setType("org.eclipse.fordiac.ide.hierarchymanager.model.problem").setLocation(qualifiedName.toString("/")).setTarget(target).setFeature(feature).createMarker((IResource)file);
        }
    }

    protected List<IResourceDescription.Delta> getRelevantDeltas(IXtextBuilderParticipant.IBuildContext context) {
        return context.getDeltas().stream().filter(this::isRelevantDelta).toList();
    }

    protected boolean isRelevantDelta(IResourceDescription.Delta delta) {
        return this.fileExtensionProvider.isValid(delta.getUri().fileExtension());
    }

    protected static IFile getFile(URI uri) {
        if (uri.isPlatformResource()) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
        }
        return null;
    }
}

