/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.commands;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.swt.widgets.Display;

public class OperationHistoryCommandStack
extends CommandStack {
    private IUndoContext undoContext;
    private final IOperationHistory opHistory;
    private IUndoableOperation saveLocation;
    private OperationHistoryListener opHistoryListener;

    public OperationHistoryCommandStack() {
        this((IUndoContext)new UndoContext());
    }

    public OperationHistoryCommandStack(IUndoContext undoContext) {
        this.undoContext = undoContext;
        this.opHistory = OperationHistoryFactory.getOperationHistory();
    }

    public void addCommandStackEventListener(CommandStackEventListener listener) {
        super.addCommandStackEventListener(listener);
        if (this.opHistoryListener == null) {
            this.opHistoryListener = new OperationHistoryListener();
            this.opHistory.addOperationHistoryListener((IOperationHistoryListener)this.opHistoryListener);
        }
    }

    public void addCommandStackListener(CommandStackListener listener) {
        throw new UnsupportedOperationException("addCommandStackListener shall not be used anymore. Use addCommandStackEventListener instead!");
    }

    public boolean canRedo() {
        return this.opHistory.canRedo(this.undoContext);
    }

    public boolean canUndo() {
        return this.opHistory.canUndo(this.undoContext);
    }

    public void dispose() {
        if (this.opHistoryListener != null) {
            this.opHistory.removeOperationHistoryListener((IOperationHistoryListener)this.opHistoryListener);
            this.opHistoryListener = null;
        }
    }

    public void execute(Command command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        CommandWrapper cmd = new CommandWrapper(command);
        cmd.addContext(this.undoContext);
        try {
            this.opHistory.execute((IUndoableOperation)cmd, null, null);
        }
        catch (ExecutionException e) {
            FordiacLogHelper.logError((String)"Couldn't execute command: ", (Throwable)e);
        }
    }

    public void flush() {
        this.notifyListeners(null, 64);
        this.opHistory.dispose(this.undoContext, true, true, false);
        this.saveLocation = null;
        this.notifyListeners(null, 256);
    }

    public Object[] getCommands() {
        IUndoableOperation[] redoHistory = this.opHistory.getRedoHistory(this.undoContext);
        IUndoableOperation[] undoHistory = this.opHistory.getUndoHistory(this.undoContext);
        ArrayList<Command> commands = new ArrayList<Command>(redoHistory.length + undoHistory.length);
        IUndoableOperation[] iUndoableOperationArray = undoHistory;
        int n = undoHistory.length;
        int n2 = 0;
        while (n2 < n) {
            IUndoableOperation undoOp = iUndoableOperationArray[n2];
            if (undoOp instanceof CommandWrapper) {
                CommandWrapper wrapper = (CommandWrapper)undoOp;
                commands.add(wrapper.getCommand());
            }
            ++n2;
        }
        int i = redoHistory.length - 1;
        while (i >= 0) {
            IUndoableOperation iUndoableOperation = redoHistory[i];
            if (iUndoableOperation instanceof CommandWrapper) {
                CommandWrapper wrapper = (CommandWrapper)iUndoableOperation;
                commands.add(wrapper.getCommand());
            }
            --i;
        }
        return commands.toArray();
    }

    private static Command getLastCommandFromHistory(IUndoableOperation[] operationHistory) {
        int i = operationHistory.length - 1;
        while (i >= 0) {
            IUndoableOperation iUndoableOperation = operationHistory[i];
            if (iUndoableOperation instanceof CommandWrapper) {
                CommandWrapper wrapper = (CommandWrapper)iUndoableOperation;
                return wrapper.getCommand();
            }
            --i;
        }
        return null;
    }

    public Command getRedoCommand() {
        return OperationHistoryCommandStack.getLastCommandFromHistory(this.opHistory.getRedoHistory(this.undoContext));
    }

    public Command getUndoCommand() {
        return OperationHistoryCommandStack.getLastCommandFromHistory(this.opHistory.getUndoHistory(this.undoContext));
    }

    public int getUndoLimit() {
        return this.opHistory.getLimit(this.undoContext);
    }

    public boolean isDirty() {
        return this.opHistory.getUndoOperation(this.undoContext) != this.saveLocation;
    }

    public void markSaveLocation() {
        this.notifyListeners(null, 128);
        this.saveLocation = this.opHistory.getUndoOperation(this.undoContext);
        this.notifyListeners(null, 512);
    }

    public void redo() {
        try {
            this.opHistory.redo(this.undoContext, null, null);
        }
        catch (ExecutionException e) {
            FordiacLogHelper.logError((String)"Couldn't redo command: ", (Throwable)e);
        }
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        throw new UnsupportedOperationException("removeCommandStackListener shall not be used anymore. Use removeCommandStackEventListener instead!");
    }

    public IUndoContext getUndoContext() {
        return this.undoContext;
    }

    public void setUndoContext(IUndoContext undoContext) {
        this.flush();
        this.undoContext = undoContext;
    }

    public void setUndoLimit(int undoLimit) {
        this.opHistory.setLimit(this.undoContext, undoLimit);
    }

    public void undo() {
        try {
            this.opHistory.undo(this.undoContext, null, null);
        }
        catch (ExecutionException e) {
            FordiacLogHelper.logError((String)"Couldn't undo command: ", (Throwable)e);
        }
    }

    private static class CommandWrapper
    extends AbstractOperation {
        private final Command cmd;

        public CommandWrapper(Command cmd) {
            super(cmd.getLabel() != null ? cmd.getLabel() : "");
            this.cmd = cmd;
        }

        public Command getCommand() {
            return this.cmd;
        }

        public boolean canExecute() {
            return this.cmd.canExecute();
        }

        public boolean canRedo() {
            return this.cmd.canRedo();
        }

        public boolean canUndo() {
            return this.cmd.canUndo();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.cmd.execute();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.cmd.redo();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.cmd.undo();
            return Status.OK_STATUS;
        }
    }

    private class OperationHistoryListener
    implements IOperationHistoryListener {
        private int prevState;
        private IUndoableOperation prevOperation;

        private OperationHistoryListener() {
        }

        private Command getCommand(IUndoableOperation operation) {
            UnexecutableCommand unexecutableCommand;
            if (operation instanceof CommandWrapper) {
                CommandWrapper wrapper = (CommandWrapper)operation;
                unexecutableCommand = wrapper.getCommand();
            } else {
                unexecutableCommand = UnexecutableCommand.INSTANCE;
            }
            return unexecutableCommand;
        }

        private int getCommandStackState(OperationHistoryEvent event) {
            return switch (event.getEventType()) {
                case 1 -> 1;
                case 2 -> 2;
                case 9 -> 16;
                case 3 -> 4;
                case 10 -> 32;
                case 7 -> this.handleOperationNotOk(event);
                case 5 -> this.handleOperationAdd(event);
                case 4, 6, 8 -> 0;
                default -> 0;
            };
        }

        private int handleOperationAdd(OperationHistoryEvent event) {
            if (event.getOperation() != this.prevOperation) {
                return 0;
            }
            if (this.prevState == 4) {
                return 8;
            }
            return this.prevState;
        }

        private int handleOperationNotOk(OperationHistoryEvent event) {
            if (event.getOperation() != this.prevOperation) {
                return 0;
            }
            return switch (this.prevState) {
                case 1 -> 8;
                case 2 -> 16;
                case 3 -> 32;
                default -> 0;
            };
        }

        public void historyNotification(OperationHistoryEvent event) {
            if (!event.getOperation().hasContext(OperationHistoryCommandStack.this.undoContext)) {
                return;
            }
            int state = this.getCommandStackState(event);
            if (state != 0) {
                Display.getDefault().execute(() -> OperationHistoryCommandStack.this.notifyListeners(this.getCommand(event.getOperation()), state));
            }
            if (!this.isOperationEvent(event)) {
                this.prevState = event.getEventType();
                this.prevOperation = event.getOperation();
            }
        }

        private boolean isOperationEvent(OperationHistoryEvent event) {
            return switch (event.getEventType()) {
                case 5, 6, 8 -> true;
                default -> false;
            };
        }
    }
}

