/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.figures;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public abstract class AbstractFreeformFigure
extends Figure
implements FreeformFigure,
FreeformListener {
    private FreeformFigure contents;
    private Rectangle extent;

    protected AbstractFreeformFigure() {
    }

    public Rectangle getFreeformExtent() {
        if (this.extent == null) {
            this.extent = this.calculateFreeformExtent();
            this.translateToParent((Translatable)this.extent);
        }
        return this.extent;
    }

    protected abstract Rectangle calculateFreeformExtent();

    public void setFreeformBounds(Rectangle bounds) {
        this.setBounds(bounds);
        Rectangle childBounds = bounds.getCopy();
        this.translateFromParent((Translatable)childBounds);
        this.setChildBounds(childBounds);
    }

    protected void setChildBounds(Rectangle childBounds) {
        this.contents.setFreeformBounds(childBounds);
    }

    public void addFreeformListener(FreeformListener listener) {
        this.addListener(FreeformListener.class, listener);
    }

    public void removeFreeformListener(FreeformListener listener) {
        this.removeListener(FreeformListener.class, listener);
    }

    public void fireExtentChanged() {
        this.getListeners(FreeformListener.class).forEachRemaining(FreeformListener::notifyFreeformExtentChanged);
    }

    public void notifyFreeformExtentChanged() {
        this.revalidate();
    }

    public void setContents(FreeformFigure contents) {
        this.contents = contents;
        this.add((IFigure)contents);
        contents.addFreeformListener((FreeformListener)this);
    }

    public FreeformFigure getContents() {
        return this.contents;
    }

    public void invalidate() {
        this.extent = null;
        this.fireExtentChanged();
        super.invalidate();
    }
}

