% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe_friendly.R
\name{pipe_arithmetic}
\alias{pipe_arithmetic}
\alias{reciprocal}
\alias{pow}
\alias{add}
\alias{subtract}
\alias{mult}
\alias{divide}
\title{Pipe-friendly arithmetic helpers}
\usage{
reciprocal(x)

pow(x, p)

add(x, k)

subtract(x, k)

mult(x, k)

divide(x, k)
}
\arguments{
\item{x}{A numeric vector or scalar.}

\item{p}{A numeric scalar exponent (for \code{pow}).}

\item{k}{A numeric scalar for addition, subtraction, multiplication, or division.}
}
\value{
A numeric vector or scalar resulting from the transformation.
}
\description{
A set of simple, vectorized, pipe-friendly arithmetic functions for
transforming numeric data in pipelines. These helpers make common
operations like multiplication, division, addition, subtraction,
exponentiation, and reciprocals clearer when using the native pipe \verb{|>}.
}
\details{
All functions are vectorized and support numeric vectors, scalars, or compatible objects.
They are designed to improve the readability of transformation pipelines.
}
\examples{
x <- c(1, 2, 3)

# Multiplication and division
x |> mult(10)
x |> divide(2)

# Addition and subtraction
x |> add(5)
x |> subtract(1)

# Reciprocal
x |> reciprocal()

# Power
x |> pow(2)

# Combined use in pipelines
x |>
  mult(2) |>
  add(3) |>
  reciprocal()

}
\concept{pipe_arithmetic}
