%feature("docstring") OT::GeneralizedExtremeValue
R"RAW(Generalized ExtremeValue distribution.

Its cumulative distribution function and its probability density function are defined as:

.. math::
    :nowrap:

    \begin{eqnarray*}
        F_X(x) &  = & \exp(-t(x)), \quad \forall x \in \cS \\
        p_X(x) & = & \dfrac{1}{\sigma}t^{1+\xi} \exp(-t(x)), \quad \forall x \in \cS
    \end{eqnarray*}

where 

.. math::
    :nowrap:

    \begin{eqnarray*}
        t(x) &  = & \left(1+\xi \dfrac{x-\mu}{\sigma}\right)^{-1/\xi} \quad \text{ if } \xi \neq 0\\
        t(x) &  = & \exp \left(- \dfrac{x-\mu}{\sigma}\right) \quad \text{ if } \xi= 0
    \end{eqnarray*}

and 

.. math::
    :nowrap:

    \begin{eqnarray*}
        \cS &  = &  [\mu-\sigma/\xi, +\infty) \quad \text{ if } \xi > 0\\
            &  = &  \Rset \quad \text{ if } \xi = 0\\
            &  = &  (-\infty,\mu-\sigma/\xi] \quad \text{ if } \xi < 0
    \end{eqnarray*}


Its first moments are:

.. math::
    :nowrap:

    \begin{eqnarray*}
    \Expect{X} & = & \mu+\dfrac{\sigma}{\xi}\left(\Gamma(1-\xi)-1\right) \quad \text{ if } \xi < 1, \xi\neq 0 \\
               & = &     \mu + \sigma\gamma_e \quad \text{ if } \xi= 0 \\
               & = &    \infty  \quad \text{ if } \xi \geq 1
    \end{eqnarray*}

    \begin{eqnarray*}
        \Var{X} & = &  \dfrac{\sigma^2}{\xi^2}\left(\Gamma(1-2\xi)-\Gamma^2(1-\xi)\right) \quad \text{ if } \xi < 1/2, \xi\neq 0 \\
                & = & \dfrac{1}{6} \sigma^2\pi^2 \quad \text{ if } \xi= 0 \\
                & = & \infty \quad \text{ if } \xi \geq 1/2
    \end{eqnarray*}

where :math:`\gamma_e` is Euler's constant.

Available constructors:
    GeneralizedExtremeValue(*mu, sigma, xi*)

    GeneralizedExtremeValue(*distribution*)

Parameters
----------
mu : float
    Position parameter :math:`\mu`.
    
    Default value is 0.0.
sigma : float, :math:`\sigma > 0`
    Scale parameter :math:`\sigma >0`.
    
    Default value is 1.0.
xi : float
    Shape parameter :math:`\xi`.
    
    Default value is 0.0.
distribution : :class:`~openturns.WeibullMax`, :class:`~openturns.Frechet` or :class:`~openturns.Gumbel`
    The underlying distribution.

Notes
-----
When the constructor from a :class:`~openturns.WeibullMax`:math:`(\beta, \alpha, \gamma)` distribution is used, then it creates :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, \xi)` where:

.. math::
    :nowrap:

    \begin{eqnarray*}
       \mu & = & \gamma - \beta \\
       \sigma & = & \dfrac{\beta}{\alpha} \\
       \xi & = & -\dfrac{1}{\alpha}
    \end{eqnarray*}



When the constructor from a :class:`~openturns.Frechet`:math:`(\beta, \alpha, \gamma)` distribution is used,  then it creates :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, \xi)` where:

.. math::
    :nowrap:

    \begin{eqnarray*}
       \mu & = & \gamma + \beta \\
       \sigma & = & \dfrac{\beta}{\alpha} \\
       \xi & = & \dfrac{1}{\alpha}
    \end{eqnarray*}



When the constructor from a :class:`~openturns.Gumbel`:math:`(\beta, \gamma)` distribution is used,  then it creates :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, \xi)` where:

.. math::
    :nowrap:

    \begin{eqnarray*}
       \mu & = & \gamma  \\
       \sigma & = & \beta \\
       \xi & = & 0.0
    \end{eqnarray*}

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> dist1 = ot.GeneralizedExtremeValue(1.0, 2.0, -0.2)

Create it from a Frechet distribution:

>>> frechet = ot.Frechet(1.0, 2.0, 3.0)
>>> dist1 = ot.GeneralizedExtremeValue(frechet)

Draw a sample:

>>> sample = dist1.getSample(5)
)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::getActualDistribution
"Accessor to the internal distribution.

Returns
-------
distribution : :class:`~openturns.Distribution`
     The actual distribution in charge of the computation (:class:`~openturns.WeibullMax`, :class:`~openturns.Frechet`, :class:`~openturns.Gumbel`)."

// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::asFrechet
R"RAW(Temptative conversion to the underlying Frechet distribution.

Returns
-------
distribution : :class:`~openturns.Frechet`
     The underlying Frechet distribution.

Notes
-----
If :math:`\xi >0` then the :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, \xi)` is actually a :class:`~openturns.Frechet`:math:`(\beta, \alpha, \gamma)` distribution where:

.. math::
    :nowrap:

    \begin{eqnarray*}
       \beta & = & \dfrac{\sigma}{\xi} \\
       \alpha & = & \dfrac{1}{\xi} \\
       \gamma & = & \mu - \dfrac{\sigma}{\xi}
    \end{eqnarray*}
)RAW"
// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::asWeibullMax
R"RAW(Temptative conversion to the underlying WeibullMax distribution.

Returns
-------
distribution : :class:`~openturns.WeibullMax`
     The underlying WeibullMax  distribution.

Notes
-----
If :math:`\xi <0` then the :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, \xi)` is actually a :class:`~openturns.WeibullMax`:math:`(\beta, \alpha, \gamma)` distribution where:

.. math::
    :nowrap:

    \begin{eqnarray*}
       \beta & = & -\dfrac{\sigma}{\xi} \\
       \alpha & = & -\dfrac{1}{\xi} \\
       \gamma & = & \mu - \dfrac{\sigma}{\xi}
    \end{eqnarray*}
)RAW"
// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::asGumbel
R"RAW(Temptative conversion to the underlying Gumbel distribution.

Returns
-------
distribution : :class:`~openturns.Gumbel`
     The underlying Gumbel distribution.

Notes
-----
If :math:`\xi =0` then the :class:`~openturns.GeneralizedExtremeValue`:math:`(\mu, \sigma, 0.0)` is actually a :class:`~openturns.Gumbel`:math:`(\beta, \gamma)` distribution where:

.. math::
    :nowrap:

    \begin{eqnarray*}
       \beta & = & \sigma \\
       \gamma & = & \mu 
    \end{eqnarray*}
)RAW"
// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::getMu
R"RAW(Accessor to the distribution's position parameter :math:`\mu`.

Returns
-------
mu : float
    Position parameter :math:`\mu`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::getSigma
R"RAW(Accessor to the distribution's scale parameter :math:`\sigma`.

Returns
-------
sigma : float
    Scale parameter :math:`\sigma`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::getXi
R"RAW(Accessor to the distribution's shape parameter :math:`\xi`.

Returns
-------
xi : float
    Shape parameter :math:`\xi`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::setActualDistribution
"Accessor to the internal distribution.

Parameters
----------
distribution : :class:`~openturns.Distribution`
     The actual distribution in charge of the computation (:class:`~openturns.WeibullMax`, :class:`~openturns.Frechet`, :class:`~openturns.Gumbel`)."

// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::setMu
R"RAW(Accessor to the distribution's position parameter :math:`\mu`.

Parameters
----------
mu : float
    Position parameter :math:`\mu`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::setSigma
R"RAW(Accessor to the distribution's scale parameter :math:`\sigma`.

Parameters
----------
sigma : float, :math:`\sigma > 0`
    Scale parameter :math:`\sigma`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::setXi
R"RAW(Accessor to the distribution's shape parameter :math:`\xi`.

Parameters
----------
xi : float, :math:`\xi \in \Rset`
    Shape parameter :math:`\xi`.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::computeReturnLevel
"Accessor to the return level.

Parameters
----------
m : float
    Return period

Returns
-------
q : float
    Return level computed as the quantile of level :math:`1-1/m`."

// ---------------------------------------------------------------------

%feature("docstring") OT::GeneralizedExtremeValue::drawReturnLevel
"Plot the return level.

Returns
-------
graph : :class:`~openturns.Graph`
    Return level graph.

Notes
-----
The return level plot bounds are defined by the :class:`~openturns.ResourceMap`
entries `GeneralizedExtremeValue-MMin` and `GeneralizedExtremeValue-MMax`"
