{-# OPTIONS_GHC -fno-warn-unused-imports #-}
module DemoCabalInstall (render) where
import Prelude (String, fst, snd, ($), return)
import Control.Monad (forM_)
import CabalInstall
type Writer a = (String, a)
tell :: String -> Writer (); tell x = (x, ())
execWriter :: Writer a -> String; execWriter = fst
render :: CabalInstall -> String
render z_root = execWriter $ do
  if (ciLib z_root)
  then do
    tell "Cabal-Version:      2.0\n"
    return ()
  else do
    tell "Cabal-Version:      >= 1.10\n"
    return ()
  tell "-- NOTE: This file is autogenerated from 'cabal-install.cabal.zinza'.\n"
  tell "-- DO NOT EDIT MANUALLY.\n"
  tell "-- To update this file, edit 'cabal-install.cabal.pp' and run\n"
  tell "-- 'make cabal-install-prod' in the project's root folder.\n"
  tell "Name:               cabal-install\n"
  tell "Version:            3.3.0.0\n"
  let
    z_var0_cabal_BUILDDEPENDS = do
      tell "    build-depends:\n"
      tell "        async      >= 2.0      && < 2.3,\n"
      tell "        array      >= 0.4      && < 0.6,\n"
      tell "        base       >= 4.8      && < 4.14,\n"
      tell "        base16-bytestring >= 0.1.1 && < 0.2,\n"
      tell "        binary     >= 0.7.3    && < 0.9,\n"
      tell "        bytestring >= 0.10.6.0 && < 0.11,\n"
      tell "        Cabal      == 3.3.*,\n"
      tell "        containers >= 0.5.6.2  && < 0.7,\n"
      tell "        cryptohash-sha256 >= 0.11 && < 0.12,\n"
      tell "        deepseq    >= 1.4.1.1  && < 1.5,\n"
      tell "        directory  >= 1.2.2.0  && < 1.4,\n"
      tell "        echo       >= 0.1.3    && < 0.2,\n"
      tell "        edit-distance >= 0.2.2 && < 0.3,\n"
      tell "        filepath   >= 1.4.0.0  && < 1.5,\n"
      tell "        hashable   >= 1.0      && < 1.4,\n"
      tell "        HTTP       >= 4000.1.5 && < 4000.4,\n"
      tell "        mtl        >= 2.0      && < 2.3,\n"
      tell "        network-uri >= 2.6.0.2 && < 2.7,\n"
      tell "        network    >= 2.6      && < 3.2,\n"
      tell "        pretty     >= 1.1      && < 1.2,\n"
      tell "        process    >= 1.2.3.0  && < 1.7,\n"
      tell "        random     >= 1        && < 1.2,\n"
      tell "        stm        >= 2.0      && < 2.6,\n"
      tell "        tar        >= 0.5.0.3  && < 0.6,\n"
      tell "        time       >= 1.5.0.1  && < 1.10,\n"
      tell "        transformers >= 0.4.2.0 && < 0.6,\n"
      tell "        zlib       >= 0.5.3    && < 0.7,\n"
      tell "        hackage-security >= 0.6.0.0 && < 0.7,\n"
      tell "        text       >= 1.2.3    && < 1.3,\n"
      tell "        parsec     >= 3.1.13.0 && < 3.2\n"
      tell "\n"
      tell "    if !impl(ghc >= 8.0)\n"
      tell "        build-depends: fail        == 4.9.*\n"
      tell "        build-depends: semigroups  >= 0.18.3 && <0.20\n"
      tell "\n"
      tell "    if flag(native-dns)\n"
      tell "      if os(windows)\n"
      tell "        build-depends: windns      >= 0.1.0 && < 0.2\n"
      tell "      else\n"
      tell "        build-depends: resolv      >= 0.1.1 && < 0.2\n"
      tell "\n"
      tell "    if os(windows)\n"
      tell "      build-depends: Win32 >= 2 && < 3\n"
      tell "    else\n"
      tell "      build-depends: unix >= 2.5 && < 2.9\n"
      tell "\n"
      tell "    if flag(lukko)\n"
      tell "      build-depends: lukko >= 0.1 && <0.2\n"
      tell "    else\n"
      tell "      build-depends: base >= 4.10\n"
      return ()
  let
    z_var1_cabal_COMPONENTCOMMON = do
      tell "    default-language: Haskell2010\n"
      tell "    ghc-options:    -Wall -fwarn-tabs -fwarn-incomplete-uni-patterns\n"
      tell "    if impl(ghc >= 8.0)\n"
      tell "        ghc-options: -Wcompat\n"
      tell "                     -Wnoncanonical-monad-instances\n"
      tell "      if impl(ghc < 8.8)\n"
      tell "        ghc-options: -Wnoncanonical-monadfail-instances\n"
      tell "\n"
      return ()
  let
    z_var2_cabal_BUILDINFO = do
      if (ciLib z_root)
      then do
        tell "    exposed-modules:\n"
        return ()
      else do
        tell "    other-modules:\n"
        return ()
      tell "        -- this modules are moved from Cabal\n"
      tell "        -- they are needed for as long until cabal-install moves to parsec parser\n"
      tell "        Distribution.Deprecated.ParseUtils\n"
      tell "        Distribution.Deprecated.ReadP\n"
      tell "        Distribution.Deprecated.Text\n"
      tell "        Distribution.Deprecated.ViewAsFieldDescr\n"
      tell "\n"
      tell "        Distribution.Client.BuildReports.Anonymous\n"
      tell "        Distribution.Client.BuildReports.Storage\n"
      tell "        Distribution.Client.BuildReports.Types\n"
      tell "        Distribution.Client.BuildReports.Upload\n"
      tell "        Distribution.Client.Check\n"
      tell "        Distribution.Client.CmdBench\n"
      tell "        Distribution.Client.CmdBuild\n"
      tell "        Distribution.Client.CmdClean\n"
      tell "        Distribution.Client.CmdConfigure\n"
      tell "        Distribution.Client.CmdUpdate\n"
      tell "        Distribution.Client.CmdErrorMessages\n"
      tell "        Distribution.Client.CmdExec\n"
      tell "        Distribution.Client.CmdFreeze\n"
      tell "        Distribution.Client.CmdHaddock\n"
      tell "        Distribution.Client.CmdInstall\n"
      tell "        Distribution.Client.CmdInstall.ClientInstallFlags\n"
      tell "        Distribution.Client.CmdRepl\n"
      tell "        Distribution.Client.CmdRun\n"
      tell "        Distribution.Client.CmdTest\n"
      tell "        Distribution.Client.CmdLegacy\n"
      tell "        Distribution.Client.CmdSdist\n"
      tell "        Distribution.Client.Compat.Directory\n"
      tell "        Distribution.Client.Compat.ExecutablePath\n"
      tell "        Distribution.Client.Compat.FilePerms\n"
      tell "        Distribution.Client.Compat.Orphans\n"
      tell "        Distribution.Client.Compat.Prelude\n"
      tell "        Distribution.Client.Compat.Process\n"
      tell "        Distribution.Client.Compat.Semaphore\n"
      tell "        Distribution.Client.Config\n"
      tell "        Distribution.Client.Configure\n"
      tell "        Distribution.Client.Dependency\n"
      tell "        Distribution.Client.Dependency.Types\n"
      tell "        Distribution.Client.DistDirLayout\n"
      tell "        Distribution.Client.Exec\n"
      tell "        Distribution.Client.Fetch\n"
      tell "        Distribution.Client.FetchUtils\n"
      tell "        Distribution.Client.FileMonitor\n"
      tell "        Distribution.Client.Freeze\n"
      tell "        Distribution.Client.GZipUtils\n"
      tell "        Distribution.Client.GenBounds\n"
      tell "        Distribution.Client.Get\n"
      tell "        Distribution.Client.Glob\n"
      tell "        Distribution.Client.GlobalFlags\n"
      tell "        Distribution.Client.Haddock\n"
      tell "        Distribution.Client.HttpUtils\n"
      tell "        Distribution.Client.IndexUtils\n"
      tell "        Distribution.Client.IndexUtils.Timestamp\n"
      tell "        Distribution.Client.Init\n"
      tell "        Distribution.Client.Init.Heuristics\n"
      tell "        Distribution.Client.Init.Licenses\n"
      tell "        Distribution.Client.Init.Types\n"
      tell "        Distribution.Client.Install\n"
      tell "        Distribution.Client.InstallPlan\n"
      tell "        Distribution.Client.InstallSymlink\n"
      tell "        Distribution.Client.JobControl\n"
      tell "        Distribution.Client.List\n"
      tell "        Distribution.Client.Manpage\n"
      tell "        Distribution.Client.Nix\n"
      tell "        Distribution.Client.Outdated\n"
      tell "        Distribution.Client.PackageHash\n"
      tell "        Distribution.Client.PackageUtils\n"
      tell "        Distribution.Client.ParseUtils\n"
      tell "        Distribution.Client.ProjectBuilding\n"
      tell "        Distribution.Client.ProjectBuilding.Types\n"
      tell "        Distribution.Client.ProjectConfig\n"
      tell "        Distribution.Client.ProjectConfig.Legacy\n"
      tell "        Distribution.Client.ProjectConfig.Types\n"
      tell "        Distribution.Client.ProjectOrchestration\n"
      tell "        Distribution.Client.ProjectPlanOutput\n"
      tell "        Distribution.Client.ProjectPlanning\n"
      tell "        Distribution.Client.ProjectPlanning.Types\n"
      tell "        Distribution.Client.RebuildMonad\n"
      tell "        Distribution.Client.Reconfigure\n"
      tell "        Distribution.Client.Run\n"
      tell "        Distribution.Client.Sandbox\n"
      tell "        Distribution.Client.Sandbox.Index\n"
      tell "        Distribution.Client.Sandbox.PackageEnvironment\n"
      tell "        Distribution.Client.Sandbox.Timestamp\n"
      tell "        Distribution.Client.Sandbox.Types\n"
      tell "        Distribution.Client.SavedFlags\n"
      tell "        Distribution.Client.Security.DNS\n"
      tell "        Distribution.Client.Security.HTTP\n"
      tell "        Distribution.Client.Setup\n"
      tell "        Distribution.Client.SetupWrapper\n"
      tell "        Distribution.Client.SolverInstallPlan\n"
      tell "        Distribution.Client.SourceFiles\n"
      tell "        Distribution.Client.SourceRepo\n"
      tell "        Distribution.Client.SrcDist\n"
      tell "        Distribution.Client.Store\n"
      tell "        Distribution.Client.Tar\n"
      tell "        Distribution.Client.TargetSelector\n"
      tell "        Distribution.Client.Targets\n"
      tell "        Distribution.Client.Types\n"
      tell "        Distribution.Client.Update\n"
      tell "        Distribution.Client.Upload\n"
      tell "        Distribution.Client.Utils\n"
      tell "        Distribution.Client.Utils.Assertion\n"
      tell "        Distribution.Client.Utils.Json\n"
      tell "        Distribution.Client.Utils.Parsec\n"
      tell "        Distribution.Client.VCS\n"
      tell "        Distribution.Client.Win32SelfUpgrade\n"
      tell "        Distribution.Client.World\n"
      tell "        Distribution.Solver.Compat.Prelude\n"
      tell "        Distribution.Solver.Modular\n"
      tell "        Distribution.Solver.Modular.Assignment\n"
      tell "        Distribution.Solver.Modular.Builder\n"
      tell "        Distribution.Solver.Modular.Configured\n"
      tell "        Distribution.Solver.Modular.ConfiguredConversion\n"
      tell "        Distribution.Solver.Modular.ConflictSet\n"
      tell "        Distribution.Solver.Modular.Cycles\n"
      tell "        Distribution.Solver.Modular.Dependency\n"
      tell "        Distribution.Solver.Modular.Explore\n"
      tell "        Distribution.Solver.Modular.Flag\n"
      tell "        Distribution.Solver.Modular.Index\n"
      tell "        Distribution.Solver.Modular.IndexConversion\n"
      tell "        Distribution.Solver.Modular.LabeledGraph\n"
      tell "        Distribution.Solver.Modular.Linking\n"
      tell "        Distribution.Solver.Modular.Log\n"
      tell "        Distribution.Solver.Modular.Message\n"
      tell "        Distribution.Solver.Modular.PSQ\n"
      tell "        Distribution.Solver.Modular.Package\n"
      tell "        Distribution.Solver.Modular.Preference\n"
      tell "        Distribution.Solver.Modular.RetryLog\n"
      tell "        Distribution.Solver.Modular.Solver\n"
      tell "        Distribution.Solver.Modular.Tree\n"
      tell "        Distribution.Solver.Modular.Validate\n"
      tell "        Distribution.Solver.Modular.Var\n"
      tell "        Distribution.Solver.Modular.Version\n"
      tell "        Distribution.Solver.Modular.WeightedPSQ\n"
      tell "        Distribution.Solver.Types.ComponentDeps\n"
      tell "        Distribution.Solver.Types.ConstraintSource\n"
      tell "        Distribution.Solver.Types.DependencyResolver\n"
      tell "        Distribution.Solver.Types.Flag\n"
      tell "        Distribution.Solver.Types.InstSolverPackage\n"
      tell "        Distribution.Solver.Types.InstalledPreference\n"
      tell "        Distribution.Solver.Types.LabeledPackageConstraint\n"
      tell "        Distribution.Solver.Types.OptionalStanza\n"
      tell "        Distribution.Solver.Types.PackageConstraint\n"
      tell "        Distribution.Solver.Types.PackageFixedDeps\n"
      tell "        Distribution.Solver.Types.PackageIndex\n"
      tell "        Distribution.Solver.Types.PackagePath\n"
      tell "        Distribution.Solver.Types.PackagePreferences\n"
      tell "        Distribution.Solver.Types.PkgConfigDb\n"
      tell "        Distribution.Solver.Types.Progress\n"
      tell "        Distribution.Solver.Types.ResolverPackage\n"
      tell "        Distribution.Solver.Types.Settings\n"
      tell "        Distribution.Solver.Types.SolverId\n"
      tell "        Distribution.Solver.Types.SolverPackage\n"
      tell "        Distribution.Solver.Types.SourcePackage\n"
      tell "        Distribution.Solver.Types.Variable\n"
      tell "        Paths_cabal_install\n"
      tell "\n"
      if (ciLib z_root)
      then do
        tell "    autogen-modules:\n"
        tell "        Paths_cabal_install\n"
        return ()
      else do
        return ()
      z_var0_cabal_BUILDDEPENDS
      tell "    if flag(debug-expensive-assertions)\n"
      tell "      cpp-options: -DDEBUG_EXPENSIVE_ASSERTIONS\n"
      tell "\n"
      tell "    if flag(debug-conflict-sets)\n"
      tell "      cpp-options: -DDEBUG_CONFLICT_SETS\n"
      tell "      build-depends: base >= 4.8\n"
      tell "\n"
      tell "    if flag(debug-tracetree)\n"
      tell "      cpp-options: -DDEBUG_TRACETREE\n"
      tell "      build-depends: tracetree >= 0.1 && < 0.2\n"
      return ()
  tell "Synopsis:           The command-line interface for Cabal and Hackage.\n"
  tell "Description:\n"
  tell "    The \\'cabal\\' command-line program simplifies the process of managing\n"
  tell "    Haskell software by automating the fetching, configuration, compilation\n"
  tell "    and installation of Haskell libraries and programs.\n"
  tell "homepage:           http://www.haskell.org/cabal/\n"
  tell "bug-reports:        https://github.com/haskell/cabal/issues\n"
  tell "License:            BSD3\n"
  tell "License-File:       LICENSE\n"
  tell "Author:             Cabal Development Team (see AUTHORS file)\n"
  tell "Maintainer:         Cabal Development Team <cabal-devel@haskell.org>\n"
  tell "Copyright:          2003-2019, Cabal Development Team\n"
  tell "Category:           Distribution\n"
  if (ciLib z_root)
  then do
    tell "Build-type:         Simple\n"
    return ()
  else do
    tell "Build-type:         Custom\n"
    return ()
  tell "Extra-Source-Files:\n"
  tell "  README.md bash-completion/cabal bootstrap.sh changelog\n"
  tell "\n"
  tell "  -- Generated with 'make gen-extra-source-files'\n"
  tell "  -- Do NOT edit this section manually; instead, run the script.\n"
  tell "  -- BEGIN gen-extra-source-files\n"
  tell "  tests/IntegrationTests2/build/keep-going/cabal.project\n"
  tell "  tests/IntegrationTests2/build/keep-going/p/P.hs\n"
  tell "  tests/IntegrationTests2/build/keep-going/p/p.cabal\n"
  tell "  tests/IntegrationTests2/build/keep-going/q/Q.hs\n"
  tell "  tests/IntegrationTests2/build/keep-going/q/q.cabal\n"
  tell "  tests/IntegrationTests2/build/local-tarball/cabal.project\n"
  tell "  tests/IntegrationTests2/build/local-tarball/q/Q.hs\n"
  tell "  tests/IntegrationTests2/build/local-tarball/q/q.cabal\n"
  tell "  tests/IntegrationTests2/build/setup-custom1/A.hs\n"
  tell "  tests/IntegrationTests2/build/setup-custom1/Setup.hs\n"
  tell "  tests/IntegrationTests2/build/setup-custom1/a.cabal\n"
  tell "  tests/IntegrationTests2/build/setup-custom2/A.hs\n"
  tell "  tests/IntegrationTests2/build/setup-custom2/Setup.hs\n"
  tell "  tests/IntegrationTests2/build/setup-custom2/a.cabal\n"
  tell "  tests/IntegrationTests2/build/setup-simple/A.hs\n"
  tell "  tests/IntegrationTests2/build/setup-simple/Setup.hs\n"
  tell "  tests/IntegrationTests2/build/setup-simple/a.cabal\n"
  tell "  tests/IntegrationTests2/exception/bad-config/cabal.project\n"
  tell "  tests/IntegrationTests2/exception/build/Main.hs\n"
  tell "  tests/IntegrationTests2/exception/build/a.cabal\n"
  tell "  tests/IntegrationTests2/exception/configure/a.cabal\n"
  tell "  tests/IntegrationTests2/exception/no-pkg/empty.in\n"
  tell "  tests/IntegrationTests2/exception/no-pkg2/cabal.project\n"
  tell "  tests/IntegrationTests2/regression/3324/cabal.project\n"
  tell "  tests/IntegrationTests2/regression/3324/p/P.hs\n"
  tell "  tests/IntegrationTests2/regression/3324/p/p.cabal\n"
  tell "  tests/IntegrationTests2/regression/3324/q/Q.hs\n"
  tell "  tests/IntegrationTests2/regression/3324/q/q.cabal\n"
  tell "  tests/IntegrationTests2/targets/all-disabled/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/all-disabled/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/benchmarks-disabled/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/benchmarks-disabled/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/benchmarks-disabled/q/q.cabal\n"
  tell "  tests/IntegrationTests2/targets/complex/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/complex/q/Q.hs\n"
  tell "  tests/IntegrationTests2/targets/complex/q/q.cabal\n"
  tell "  tests/IntegrationTests2/targets/empty-pkg/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/empty-pkg/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/empty/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/empty/foo.hs\n"
  tell "  tests/IntegrationTests2/targets/exes-disabled/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/exes-disabled/p/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/exes-disabled/q/q.cabal\n"
  tell "  tests/IntegrationTests2/targets/lib-only/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/libs-disabled/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/libs-disabled/p/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/libs-disabled/q/q.cabal\n"
  tell "  tests/IntegrationTests2/targets/multiple-exes/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/multiple-exes/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/multiple-libs/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/multiple-libs/p/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/multiple-libs/q/q.cabal\n"
  tell "  tests/IntegrationTests2/targets/multiple-tests/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/multiple-tests/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/simple/P.hs\n"
  tell "  tests/IntegrationTests2/targets/simple/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/simple/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/simple/q/QQ.hs\n"
  tell "  tests/IntegrationTests2/targets/simple/q/q.cabal\n"
  tell "  tests/IntegrationTests2/targets/test-only/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/tests-disabled/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/tests-disabled/p.cabal\n"
  tell "  tests/IntegrationTests2/targets/tests-disabled/q/q.cabal\n"
  tell "  tests/IntegrationTests2/targets/variety/cabal.project\n"
  tell "  tests/IntegrationTests2/targets/variety/p.cabal\n"
  tell "  -- END gen-extra-source-files\n"
  tell "\n"
  tell "  -- Additional manual extra-source-files:\n"
  tell "  tests/IntegrationTests2/build/local-tarball/p-0.1.tar.gz\n"
  tell "\n"
  tell "\n"
  tell "source-repository head\n"
  tell "  type:     git\n"
  tell "  location: https://github.com/haskell/cabal/\n"
  tell "  subdir:   cabal-install\n"
  tell "\n"
  tell "Flag native-dns\n"
  tell "  description:  Enable use of the [resolv](https://hackage.haskell.org/package/resolv) & [windns](https://hackage.haskell.org/package/windns) packages for performing DNS lookups\n"
  tell "  default:      True\n"
  tell "  manual:       True\n"
  tell "\n"
  tell "Flag debug-expensive-assertions\n"
  tell "  description:  Enable expensive assertions for testing or debugging\n"
  tell "  default:      False\n"
  tell "  manual:       True\n"
  tell "\n"
  tell "Flag debug-conflict-sets\n"
  tell "  description:  Add additional information to ConflictSets\n"
  tell "  default:      False\n"
  tell "  manual:       True\n"
  tell "\n"
  tell "Flag debug-tracetree\n"
  tell "  description:  Compile in support for tracetree (used to debug the solver)\n"
  tell "  default:      False\n"
  tell "  manual:       True\n"
  tell "\n"
  tell "Flag lukko\n"
  tell "  description:  Use @lukko@ for file-locking\n"
  tell "  default:      True\n"
  tell "  manual:       True\n"
  tell "\n"
  if (ciLib z_root)
  then do
    return ()
  else do
    tell "custom-setup\n"
    tell "   setup-depends:\n"
    tell "       Cabal     >= 2.2,\n"
    tell "       base,\n"
    tell "       process   >= 1.1.0.1  && < 1.7,\n"
    tell "       filepath  >= 1.3      && < 1.5\n"
    tell "\n"
    return ()
  if (ciLib z_root)
  then do
    tell "library cabal-lib-client\n"
    z_var1_cabal_COMPONENTCOMMON
    tell "    hs-source-dirs: .\n"
    z_var2_cabal_BUILDINFO
    tell "\n"
    tell "library cabal-install-solver-dsl\n"
    z_var1_cabal_COMPONENTCOMMON
    tell "    hs-source-dirs: solver-dsl\n"
    tell "    exposed-modules:\n"
    tell "        UnitTests.Distribution.Solver.Modular.DSL\n"
    tell "    build-depends:\n"
    tell "        base,\n"
    tell "        Cabal,\n"
    tell "        containers,\n"
    tell "        -- TODO: depend on cabal-install-solver only\n"
    tell "        cabal-lib-client\n"
    return ()
  else do
    return ()
  tell "executable cabal\n"
  tell "    main-is:        Main.hs\n"
  tell "    hs-source-dirs: main\n"
  z_var1_cabal_COMPONENTCOMMON
  tell "\n"
  tell "    ghc-options: -rtsopts -threaded\n"
  tell "\n"
  tell "    -- On AIX, some legacy BSD operations such as flock(2) are provided by libbsd.a\n"
  tell "    if os(aix)\n"
  tell "        extra-libraries: bsd\n"
  if (ciLib z_root)
  then do
    tell "    build-depends:\n"
    tell "        cabal-lib-client,\n"
    tell "        Cabal,\n"
    tell "        base,\n"
    tell "        directory,\n"
    tell "        filepath\n"
    tell "\n"
    tell "    other-modules: Paths_cabal_install\n"
    return ()
  else do
    tell "    hs-source-dirs: .\n"
    z_var2_cabal_BUILDINFO
    return ()
  if (ciLib z_root)
  then do
    if (ciMonolithic z_root)
    then do
      tell "    -- Monolithic: tests fused into executable\n"
      tell "    hs-source-dirs: tests\n"
      tell "    other-modules:\n"
      tell "        UnitTests\n"
      tell "        MemoryUsageTests\n"
      tell "        SolverQuickCheck\n"
      tell "        IntegrationTests2\n"
      tell "\n"
      tell "        UnitTests.Distribution.Client.ArbitraryInstances\n"
      tell "        UnitTests.Distribution.Client.FileMonitor\n"
      tell "        UnitTests.Distribution.Client.Get\n"
      tell "        UnitTests.Distribution.Client.GenericInstances\n"
      tell "        UnitTests.Distribution.Client.GZipUtils\n"
      tell "        UnitTests.Distribution.Client.Glob\n"
      tell "        UnitTests.Distribution.Client.IndexUtils.Timestamp\n"
      tell "        UnitTests.Distribution.Client.InstallPlan\n"
      tell "        UnitTests.Distribution.Client.JobControl\n"
      tell "        UnitTests.Distribution.Client.ProjectConfig\n"
      tell "        UnitTests.Distribution.Client.Sandbox\n"
      tell "        UnitTests.Distribution.Client.Sandbox.Timestamp\n"
      tell "        UnitTests.Distribution.Client.Store\n"
      tell "        UnitTests.Distribution.Client.Tar\n"
      tell "        UnitTests.Distribution.Client.Targets\n"
      tell "        UnitTests.Distribution.Client.TreeDiffInstances\n"
      tell "        UnitTests.Distribution.Client.UserConfig\n"
      tell "        UnitTests.Distribution.Client.VCS\n"
      tell "        UnitTests.Distribution.Solver.Modular.Builder\n"
      tell "        UnitTests.Distribution.Solver.Modular.DSL.TestCaseUtils\n"
      tell "        UnitTests.Distribution.Solver.Modular.MemoryUsage\n"
      tell "        UnitTests.Distribution.Solver.Modular.QuickCheck\n"
      tell "        UnitTests.Distribution.Solver.Modular.QuickCheck.Utils\n"
      tell "        UnitTests.Distribution.Solver.Modular.RetryLog\n"
      tell "        UnitTests.Distribution.Solver.Modular.Solver\n"
      tell "        UnitTests.Distribution.Solver.Modular.WeightedPSQ\n"
      tell "        UnitTests.Options\n"
      tell "        UnitTests.TempTestDir\n"
      tell "\n"
      tell "    cpp-options: -DMONOLITHIC\n"
      tell "    build-depends:\n"
      tell "        Cabal      == 3.3.*,\n"
      tell "        cabal-install-solver-dsl,\n"
      tell "        QuickCheck >= 2.8.2,\n"
      tell "        array,\n"
      tell "        async,\n"
      tell "        bytestring,\n"
      tell "        containers,\n"
      tell "        deepseq,\n"
      tell "        directory,\n"
      tell "        edit-distance,\n"
      tell "        filepath,\n"
      tell "        hashable,\n"
      tell "        mtl,\n"
      tell "        network,\n"
      tell "        network-uri,\n"
      tell "        pretty-show >= 1.6.15,\n"
      tell "        random,\n"
      tell "        tagged,\n"
      tell "        tar,\n"
      tell "        tasty >= 1.2.3 && < 1.3,\n"
      tell "        tasty-hunit >= 0.10,\n"
      tell "        tasty-quickcheck,\n"
      tell "        tree-diff,\n"
      tell "        time,\n"
      tell "        zlib\n"
      return ()
    else do
      return ()
    return ()
  else do
    return ()
  if (ciLib z_root)
  then do
    tell "Test-Suite unit-tests\n"
    tell "  type: exitcode-stdio-1.0\n"
    tell "  main-is: UnitTests.hs\n"
    tell "  hs-source-dirs: tests\n"
    tell "  ghc-options: -Wall -fwarn-tabs -fwarn-incomplete-uni-patterns -main-is UnitTests\n"
    tell "  other-modules:\n"
    tell "    UnitTests.Distribution.Client.ArbitraryInstances\n"
    tell "    UnitTests.Distribution.Client.Targets\n"
    tell "    UnitTests.Distribution.Client.FileMonitor\n"
    tell "    UnitTests.Distribution.Client.Get\n"
    tell "    UnitTests.Distribution.Client.GenericInstances\n"
    tell "    UnitTests.Distribution.Client.Glob\n"
    tell "    UnitTests.Distribution.Client.GZipUtils\n"
    tell "    UnitTests.Distribution.Client.Sandbox\n"
    tell "    UnitTests.Distribution.Client.Sandbox.Timestamp\n"
    tell "    UnitTests.Distribution.Client.Store\n"
    tell "    UnitTests.Distribution.Client.Tar\n"
    tell "    UnitTests.Distribution.Client.TreeDiffInstances\n"
    tell "    UnitTests.Distribution.Client.UserConfig\n"
    tell "    UnitTests.Distribution.Client.ProjectConfig\n"
    tell "    UnitTests.Distribution.Client.JobControl\n"
    tell "    UnitTests.Distribution.Client.IndexUtils.Timestamp\n"
    tell "    UnitTests.Distribution.Client.InstallPlan\n"
    tell "    UnitTests.Distribution.Client.VCS\n"
    tell "    UnitTests.Distribution.Solver.Modular.Builder\n"
    tell "    UnitTests.Distribution.Solver.Modular.RetryLog\n"
    tell "    UnitTests.Distribution.Solver.Modular.Solver\n"
    tell "    UnitTests.Distribution.Solver.Modular.DSL.TestCaseUtils\n"
    tell "    UnitTests.Distribution.Solver.Modular.WeightedPSQ\n"
    tell "    UnitTests.Options\n"
    tell "    UnitTests.TempTestDir\n"
    tell "  build-depends:\n"
    tell "        array,\n"
    tell "        base,\n"
    tell "        async,\n"
    tell "        bytestring,\n"
    tell "        cabal-lib-client,\n"
    tell "        cabal-install-solver-dsl,\n"
    tell "        Cabal,\n"
    tell "        containers,\n"
    tell "        deepseq,\n"
    tell "        mtl,\n"
    tell "        random,\n"
    tell "        directory,\n"
    tell "        filepath,\n"
    tell "        tar,\n"
    tell "        time,\n"
    tell "        zlib,\n"
    tell "        network-uri < 2.6.2.0,\n"
    tell "        network,\n"
    tell "        tasty >= 1.2.3 && <1.3,\n"
    tell "        tasty-hunit >= 0.10,\n"
    tell "        tasty-quickcheck,\n"
    tell "        tagged,\n"
    tell "        tree-diff,\n"
    tell "        QuickCheck >= 2.8.2\n"
    tell "\n"
    tell "  ghc-options: -threaded\n"
    tell "\n"
    tell "  default-language: Haskell2010\n"
    tell "\n"
    tell "Test-Suite memory-usage-tests\n"
    tell "  type: exitcode-stdio-1.0\n"
    tell "  main-is: MemoryUsageTests.hs\n"
    tell "  hs-source-dirs: tests\n"
    tell "  ghc-options: -Wall -fwarn-tabs -fwarn-incomplete-uni-patterns \"-with-rtsopts=-M4M -K1K\" -main-is MemoryUsageTests\n"
    tell "  other-modules:\n"
    tell "    UnitTests.Distribution.Solver.Modular.DSL.TestCaseUtils\n"
    tell "    UnitTests.Distribution.Solver.Modular.MemoryUsage\n"
    tell "    UnitTests.Options\n"
    tell "  build-depends:\n"
    tell "        base,\n"
    tell "        async,\n"
    tell "        Cabal,\n"
    tell "        cabal-lib-client,\n"
    tell "        cabal-install-solver-dsl,\n"
    tell "        containers,\n"
    tell "        deepseq,\n"
    tell "        tagged,\n"
    tell "        tasty >= 1.2.3 && <1.3,\n"
    tell "        tasty-hunit >= 0.10\n"
    tell "\n"
    tell "  ghc-options: -threaded\n"
    tell "\n"
    tell "  default-language: Haskell2010\n"
    tell "\n"
    tell "Test-Suite solver-quickcheck\n"
    tell "  type: exitcode-stdio-1.0\n"
    tell "  main-is: SolverQuickCheck.hs\n"
    tell "  hs-source-dirs: tests\n"
    tell "  ghc-options: -Wall -fwarn-tabs -fwarn-incomplete-uni-patterns -main-is SolverQuickCheck\n"
    tell "  other-modules:\n"
    tell "    UnitTests.Distribution.Solver.Modular.QuickCheck\n"
    tell "    UnitTests.Distribution.Solver.Modular.QuickCheck.Utils\n"
    tell "  build-depends:\n"
    tell "        base,\n"
    tell "        async,\n"
    tell "        Cabal,\n"
    tell "        cabal-lib-client,\n"
    tell "        cabal-install-solver-dsl,\n"
    tell "        containers,\n"
    tell "        deepseq >= 1.2,\n"
    tell "        hashable,\n"
    tell "        random,\n"
    tell "        tagged,\n"
    tell "        tasty >= 1.2.3 && <1.3,\n"
    tell "        tasty-quickcheck,\n"
    tell "        QuickCheck >= 2.8.2,\n"
    tell "        pretty-show >= 1.6.15\n"
    tell "\n"
    tell "  ghc-options: -threaded\n"
    tell "\n"
    tell "  default-language: Haskell2010\n"
    tell "\n"
    tell "test-suite integration-tests2\n"
    tell "  type: exitcode-stdio-1.0\n"
    tell "  main-is: IntegrationTests2.hs\n"
    tell "  hs-source-dirs: tests\n"
    tell "  ghc-options: -Wall -fwarn-tabs -fwarn-incomplete-uni-patterns -main-is IntegrationTests2\n"
    tell "  other-modules:\n"
    tell "  build-depends:\n"
    tell "        base,\n"
    tell "        Cabal,\n"
    tell "        cabal-lib-client,\n"
    tell "        containers,\n"
    tell "        deepseq,\n"
    tell "        directory,\n"
    tell "        edit-distance,\n"
    tell "        filepath,\n"
    tell "        tasty >= 1.2.3 && <1.3,\n"
    tell "        tasty-hunit >= 0.10,\n"
    tell "        tagged\n"
    tell "\n"
    tell "  ghc-options: -threaded\n"
    tell "  default-language: Haskell2010\n"
    tell "\n"
    return ()
  else do
    return ()
