;*=====================================================================*/
;*    serrano/prgm/project/bigloo/api/libuv/examples/queue.scm         */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue May  6 12:10:13 2014                          */
;*    Last change :  Thu Oct 23 08:04:36 2014 (serrano)                */
;*    Copyright   :  2014 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    LIBUV queue                                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module libuv_hello
   (library libuv pthread)
   (main main))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*    -------------------------------------------------------------    */
;*    Broken as queue uses its own threads...                          */
;*---------------------------------------------------------------------*/
(define (main args)
   (let ((loop (uv-default-loop)))
      (let loop ((i 0))
	 (when (<fx i 1)
	    (uv-queue-work
	       (lambda ()
		  (sleep (random 3))
		  (print "fib(" i ")=" (fib i)))
	       (lambda (status)
		  (print "done with fib(" i ")")))
	    (loop (+fx i 1))))
      (print "entering loop")
      (uv-run loop)))

;*---------------------------------------------------------------------*/
;*    fib ...                                                          */
;*---------------------------------------------------------------------*/
(define (fib n)
   (if (<fx n 2)
       1
       (+ (fib (-fx n 1)) (fib (-fx n 2)))))
