# -*- coding:utf-8 -*-

%define AMC_modsdir %{_libdir}/AMC
%define AMC_modelsdir /usr/share/auto-multiple-choice/models
%define AMC_texdir /usr/share/texmf/tex/latex/AMC
%define AMC_bindir %{_bindir}
%define AMC_pixdir /usr/share/pixmaps
%define AMC_iconsdir /usr/share/auto-multiple-choice/icons
%define AMC_perlpath /usr/bin/perl
%define AMC_texdocdir /usr/share/texmf/doc/latex/AMC

%if 0%{?fedora}
%define AMC_perldir %{perl_privlib}
%else
%define AMC_perldir %{perl_vendorlib}
%endif

%define AMC_man1dir %{_mandir}/man1
%define AMC_docdir %{_docdir}/%{name}

%define AMC_OPENCV -I /usr/include/opencv4

%if 0%{?suse_version}
%define AMC_cat Education;Teaching;
%else
%define AMC_cat Education;
%endif

%define AMC_makepass SYSTEM_TYPE=rpm MODSDIR=%{AMC_modsdir} MODELSDIR=%{AMC_modelsdir} TEXDOCDIR=%{AMC_texdocdir} TEXDIR=%{AMC_texdir} BINDIR=%{AMC_bindir} ICONSDIR=%{AMC_iconsdir} PIXDIR=%{AMC_pixdir} PERLDIR=%{AMC_perldir} MAN1DIR=%{AMC_man1dir} DOCDIR=%{AMC_docdir} DESKTOPDIR="" DESKTOP_CAT="%{AMC_cat}" GCC_OPENCV="%{AMC_OPENCV}" PERLPATH="%{AMC_perlpath}"

Name: auto-multiple-choice
Summary: Auto Multiple Choice - Multiple Choice Papers Management
Version: 1.7.0
Release: 1%{?dist}
License: GPLv2+
Group: Productivity/Other
Source: auto-multiple-choice_1.7.0_dist.tar.gz

%if 0%{?fedora}
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}
%else
BuildRoot: %{_tmppath}/%{name}-%{version}-build
%endif
URL: https://www.auto-multiple-choice.net/
BuildRequires: gcc-c++

BuildRequires: pkgconfig(cairo)
BuildRequires: (pkgconfig(opencv4) or pkgconfig(opencv))
BuildRequires: pkgconfig(pangocairo)
BuildRequires: pkgconfig(poppler-glib)

BuildRequires: texlive

%if 0%{?fedora}
BuildRequires: libxslt
%else
BuildRequires: xsltproc
%endif

%if 0%{?suse_version}
BuildRequires: update-desktop-files, fontconfig-devel
%endif
%if 0%{?fedora}
BuildRequires: desktop-file-utils, fontconfig-devel
%endif
%if 0%{?mageia}
BuildRequires: desktop-file-utils, libfontconfig-devel
%endif

## Requirements

%if 0%{?suse_version}
%if 0%{?suse_version} < 1140
Requires: perl = %{perl_version}
%else
%{perl_requires}
%endif
%else
Requires: perl >= 5.12
%endif

Requires: texlive
%if 0%{?fedora:1}%{?suse_version:1}
Requires: tex(bophook.sty), tex(csvsimple.sty), tex(environ.sty)
%endif
%if 0%{?mageia}
Requires: texlive-dist
%endif

Requires: ghostscript, qpdf, poppler
Requires: /usr/bin/ppmtoxpm
Requires: /usr/bin/pdftoppm
Requires: /usr/bin/dvipdfm

Requires: perl(DBI), perl(DBD::SQLite)
Requires: (perl(Graphics::Magick) or perl(Image::Magick))

Requires: perl(File::MimeInfo::Magic)
Requires: perl(Text::Unidecode)
Requires: perl(Sys::CPU)

%if 0%{?suse_version}
Requires: typelib-1_0-Gtk-3_0, typelib(GdkPixdata), typelib(Notify)
%endif

Recommends: perl(Net::CUPS), perl(Net::CUPS::PPD)
Recommends: perl(OpenOffice::OODoc)
Recommends: (linux-libertine-fonts or fonts-ttf-libertine)
Recommends: perl(YAML::Syck), perl(Hash::Merge)

Requires: perl(Archive::Tar)
Requires: perl(Archive::Zip)
Requires: perl(Cairo)
Requires: perl(Cwd)
Requires: perl(Data::Dumper)
Requires: perl(Digest::MD5)
Requires: perl(Email::Address)
Requires: perl(Email::MIME)
Requires: perl(Email::Sender)
Requires: perl(Email::Sender::Simple)
Requires: perl(Encode)
Requires: perl(Exporter)
Requires: perl(Fcntl)
Requires: perl(File::Copy)
Requires: perl(File::Find)
Requires: perl(File::Path)
Requires: perl(File::Spec)
Requires: perl(File::Spec::Functions)
Requires: perl(File::stat)
Requires: perl(File::Temp)
Requires: perl(Getopt::Long)
Requires: perl(Glib)
Requires: perl(Glib::Object::Introspection)
Requires: perl(Gtk3)
Requires: perl(I18N::Langinfo)
Requires: perl(IO::File)
Requires: perl(IPC::Open2)
Requires: perl(IPC::Open3)
Requires: perl(IPC::Run)
Requires: perl(List::Util)
Requires: perl(Locale::gettext)
Requires: perl(Module::Load)
Requires: perl(Module::Load::Conditional)
Requires: perl(Pango)
Requires: perl(POSIX)
Requires: perl(Scalar::Util)
Requires: perl(Storable)
Requires: perl(Text::CSV)
Requires: perl(Text::ParseWords)
Requires: perl(Time::HiRes)
Requires: perl(Time::Local)
Requires: perl(Time::localtime)
Requires: perl(Unicode::Normalize)
Requires: perl(XML::LibXML)
Requires: perl(XML::Simple)
Requires: perl(XML::Writer)

Requires(post): texlive
Requires(postun): texlive

#################################################################
# DESCRIPTION                                                   #
#################################################################

%{?perl_default_filter}

%description
Utility to manage multiple choice questionnaires, with optionally
mixed questions and answers. AMC provides automatic marking from papers'
scans. Annotated papers are produced. Marks can be exported as a
LibreOffice sheet file.

#'

%prep

#################################################################
# SETUP                                                         #
#################################################################

%setup

%if 0%{?fedora}
# filter out package Perl modules, and optional OpenOffice::OODoc module.

cat << \EOF > %{name}-req
#!/bin/sh
%{__perl_requires} $* |\
sed -e '/perl(OpenOffice::OODoc)/d' -e '/perl(AMC::.*)/d'
EOF

%global __perl_requires %{_builddir}/%{name}-%{version}/%{name}-req
chmod +x %{__perl_requires}

%endif


#################################################################
# BUILD                                                         #
#################################################################

%build

make %{AMC_makepass} GCC="gcc" GCC_PP="g++" CFLAGS="$RPM_OPT_FLAGS -Wall" CXXFLAGS="$RPM_OPT_FLAGS -Wall"

#################################################################
# INSTALL                                                       #
#################################################################

%install
make DESTDIR=$RPM_BUILD_ROOT %{AMC_makepass} install

%if 0%{?fedora:1}%{?mageia:1}
desktop-file-install --delete-original --dir=%{buildroot}%{_datadir}/applications net.auto_multiple_choice.amc.desktop
%endif

%if 0%{?suse_version}
%suse_update_desktop_file -i net.auto_multiple_choice.amc
%endif

%find_lang %{name}

#################################################################
# CLEAN                                                         #
#################################################################

%clean
rm -rf $RPM_BUILD_ROOT

#################################################################
# FILES                                                         #
#################################################################

%files -f %{name}.lang
%defattr(-,root,root,-)

%doc COPYING ChangeLog doc/html doc/auto-multiple-choice.??.xml doc/auto-multiple-choice.??.pdf
%doc %{AMC_texdocdir}

%dir /usr/share/auto-multiple-choice

%if 0%{?suse_version}
%dir /usr/share/texmf
%dir /usr/share/texmf/tex
%dir /usr/share/texmf/tex/latex
%dir /usr/share/texmf/doc
%dir /usr/share/auto-multiple-choice/gtk
%dir /usr/share/gtksourceview-5
%dir /usr/share/gtksourceview-5/language-specs
%dir /usr/share/icons/hicolor
%dir /usr/share/icons/hicolor/16x16
%dir /usr/share/icons/hicolor/16x16/apps
%dir /usr/share/icons/hicolor/22x22
%dir /usr/share/icons/hicolor/22x22/apps
%dir /usr/share/icons/hicolor/24x24
%dir /usr/share/icons/hicolor/24x24/apps
%dir /usr/share/icons/hicolor/256x256
%dir /usr/share/icons/hicolor/256x256/apps
%dir /usr/share/icons/hicolor/32x32
%dir /usr/share/icons/hicolor/32x32/apps
%dir /usr/share/icons/hicolor/48x48
%dir /usr/share/icons/hicolor/48x48/apps
%dir /usr/share/icons/hicolor/512x512
%dir /usr/share/icons/hicolor/512x512/apps
%dir /usr/share/icons/hicolor/64x64
%dir /usr/share/icons/hicolor/64x64/apps
%dir /usr/share/icons/hicolor/scalable
%dir /usr/share/icons/hicolor/scalable/apps
%endif

%{AMC_modsdir}
%{AMC_modelsdir}
%{AMC_iconsdir}
%{AMC_texdir}
%{AMC_bindir}/auto-multiple-choice
%{AMC_pixdir}/auto-multiple-choice.xpm
%{AMC_perldir}/AMC
%{_datadir}/applications/net.auto_multiple_choice.amc.desktop
%{AMC_man1dir}/auto-multiple-choice.*.1*
%{AMC_man1dir}/auto-multiple-choice.1*
%{AMC_man1dir}/auto-multiple-choice-*.1*

/usr/share/gtksourceview-5/language-specs/amc-txt.lang
/usr/share/mime/packages/auto-multiple-choice.xml

/usr/share/auto-multiple-choice/gtk/auto-multiple-choice.css
/usr/share/icons/hicolor/*/apps/auto-multiple-choice.png
/usr/share/icons/hicolor/scalable/apps/auto-multiple-choice.svgz
/usr/share/metainfo/net.auto_multiple_choice.amc.metainfo.xml

#################################################################
# POST                                                          #
#################################################################

%post

%if 0%{?fedora}
texhash
%endif
%if 0%{?suse_version}
texconfig-sys rehash
%endif
%if 0%{?mageia}
texhash
%endif

%postun

%if 0%{?fedora}
texhash
%endif
%if 0%{?suse_version}
texconfig-sys rehash
%endif
%if 0%{?mageia}
texhash
%endif

#################################################################
# CHANGELOG                                                     #
#################################################################

%changelog

* Thu Apr 17 2025 Alexis Bienvenüe <paamc@passoire.fr> 1.7.0

  - auto spec file. See ChangeLog for information.
