#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp-test
version:              0.14.0.2
visibility:           public
id:                   lsp-test-0.14.0.2-8iE1w67ZUSm6xTzbuo3Ctf
key:                  lsp-test-0.14.0.2-8iE1w67ZUSm6xTzbuo3Ctf
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  e39a4bcac1914bedfe81e22acdeaca53
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav:Control.Applicative.Combinators,
    Language.LSP.Test,
    Language.LSP.Types from lsp-types-1.4.0.1-IBJPB4MShXPCZOTJtiVNOs:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.4.0.1-IBJPB4MShXPCZOTJtiVNOs:Language.LSP.Types.Capabilities

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.0.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.0.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test0.14.0
hs-libraries:         HSlsp-test-0.14.0.2-8iE1w67ZUSm6xTzbuo3Ctf
depends:
    Diff-0.4.1-LH1ky1AbixJl32mO74dkD Glob-0.10.2-FXgkuDBZUb2Gc2e66kmlY5
    aeson-2.1.2.1-7NKMY9av0haL3nHVKphSJj
    aeson-pretty-0.8.10-3jeGqHVOJRT1CI9DYJnt2A
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc
    async-2.2.5-HIvtQdOwlf5Hsyin6u1n7Q base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-86fl8mgs0PcICSp2A4xyva
    conduit-parse-0.2.1.1-9TUUC9sI7yV1S4LUuU1iyl containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    filepath-1.4.2.2 lens-5.2.3-4nDp1u1qKC5FV2ww18Mx1
    lsp-types-1.4.0.1-IBJPB4MShXPCZOTJtiVNOs mtl-2.2.2
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav process-1.6.18.0
    some-1.0.5-36xIADGNqiWGv9lC459cQD text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX

haddock-interfaces:   /usr/share/doc/haskell-lsp-test0.14.0/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test0.14.0/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

