﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codeguru-security/CodeGuruSecurity_EXPORTS.h>
#include <aws/codeguru-security/model/FilePath.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CodeGuruSecurity
{
namespace Model
{

  /**
   * <p>Information about a security vulnerability that Amazon CodeGuru Security
   * detected.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/Vulnerability">AWS
   * API Reference</a></p>
   */
  class Vulnerability
  {
  public:
    AWS_CODEGURUSECURITY_API Vulnerability() = default;
    AWS_CODEGURUSECURITY_API Vulnerability(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEGURUSECURITY_API Vulnerability& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_CODEGURUSECURITY_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p> An object that describes the location of the detected security vulnerability
     * in your code.</p>
     */
    inline const FilePath& GetFilePath() const { return m_filePath; }
    inline bool FilePathHasBeenSet() const { return m_filePathHasBeenSet; }
    template<typename FilePathT = FilePath>
    void SetFilePath(FilePathT&& value) { m_filePathHasBeenSet = true; m_filePath = std::forward<FilePathT>(value); }
    template<typename FilePathT = FilePath>
    Vulnerability& WithFilePath(FilePathT&& value) { SetFilePath(std::forward<FilePathT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The identifier for the vulnerability.</p>
     */
    inline const Aws::String& GetId() const { return m_id; }
    inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
    template<typename IdT = Aws::String>
    void SetId(IdT&& value) { m_idHasBeenSet = true; m_id = std::forward<IdT>(value); }
    template<typename IdT = Aws::String>
    Vulnerability& WithId(IdT&& value) { SetId(std::forward<IdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>One or more URL addresses that contain details about a vulnerability.</p>
     */
    inline const Aws::Vector<Aws::String>& GetReferenceUrls() const { return m_referenceUrls; }
    inline bool ReferenceUrlsHasBeenSet() const { return m_referenceUrlsHasBeenSet; }
    template<typename ReferenceUrlsT = Aws::Vector<Aws::String>>
    void SetReferenceUrls(ReferenceUrlsT&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = std::forward<ReferenceUrlsT>(value); }
    template<typename ReferenceUrlsT = Aws::Vector<Aws::String>>
    Vulnerability& WithReferenceUrls(ReferenceUrlsT&& value) { SetReferenceUrls(std::forward<ReferenceUrlsT>(value)); return *this;}
    template<typename ReferenceUrlsT = Aws::String>
    Vulnerability& AddReferenceUrls(ReferenceUrlsT&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.emplace_back(std::forward<ReferenceUrlsT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>One or more vulnerabilities that are related to the vulnerability being
     * described.</p>
     */
    inline const Aws::Vector<Aws::String>& GetRelatedVulnerabilities() const { return m_relatedVulnerabilities; }
    inline bool RelatedVulnerabilitiesHasBeenSet() const { return m_relatedVulnerabilitiesHasBeenSet; }
    template<typename RelatedVulnerabilitiesT = Aws::Vector<Aws::String>>
    void SetRelatedVulnerabilities(RelatedVulnerabilitiesT&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = std::forward<RelatedVulnerabilitiesT>(value); }
    template<typename RelatedVulnerabilitiesT = Aws::Vector<Aws::String>>
    Vulnerability& WithRelatedVulnerabilities(RelatedVulnerabilitiesT&& value) { SetRelatedVulnerabilities(std::forward<RelatedVulnerabilitiesT>(value)); return *this;}
    template<typename RelatedVulnerabilitiesT = Aws::String>
    Vulnerability& AddRelatedVulnerabilities(RelatedVulnerabilitiesT&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.emplace_back(std::forward<RelatedVulnerabilitiesT>(value)); return *this; }
    ///@}
  private:

    FilePath m_filePath;
    bool m_filePathHasBeenSet = false;

    Aws::String m_id;
    bool m_idHasBeenSet = false;

    Aws::Vector<Aws::String> m_referenceUrls;
    bool m_referenceUrlsHasBeenSet = false;

    Aws::Vector<Aws::String> m_relatedVulnerabilities;
    bool m_relatedVulnerabilitiesHasBeenSet = false;
  };

} // namespace Model
} // namespace CodeGuruSecurity
} // namespace Aws
