// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef node_inspector_protocol_Network_h
#define node_inspector_protocol_Network_h

#include "src/node/inspector/protocol/Protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "src/node/inspector/protocol/Runtime.h"

namespace node {
namespace inspector {
namespace protocol {
namespace Network {
using ResourceType = String;
using RequestId = String;
using TimeSinceEpoch = double;
using MonotonicTime = double;
class Initiator;
class Request;
class Response;
using Headers = Object;

// ------------- Forward and enum declarations.

namespace ResourceTypeEnum {
 extern const char Document[];
 extern const char Stylesheet[];
 extern const char Image[];
 extern const char Media[];
 extern const char Font[];
 extern const char Script[];
 extern const char TextTrack[];
 extern const char XHR[];
 extern const char Fetch[];
 extern const char Prefetch[];
 extern const char EventSource[];
 extern const char WebSocket[];
 extern const char Manifest[];
 extern const char SignedExchange[];
 extern const char Ping[];
 extern const char CSPViolationReport[];
 extern const char Preflight[];
 extern const char Other[];
} // namespace ResourceTypeEnum

// ------------- Type and builder declarations.

class  Initiator : public ::crdtp::ProtocolObject<Initiator> {
public:
    ~Initiator() override { }

    struct  TypeEnum {
        static const char* Parser;
        static const char* Script;
        static const char* Preload;
        static const char* SignedExchange;
        static const char* Preflight;
        static const char* Other;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    bool hasStack() { return m_stack.has_value(); }
    v8_inspector::protocol::Runtime::API::StackTrace* getStack(v8_inspector::protocol::Runtime::API::StackTrace* defaultValue) {
       return m_stack.has_value() ? &m_stack.value() : defaultValue;
    }
    void setStack(std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> value) { m_stack = std::move(value); }

    bool hasUrl() { return m_url.has_value(); }
    String getUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    void setUrl(const String& value) { m_url = value; }

    bool hasLineNumber() { return m_lineNumber.has_value(); }
    double getLineNumber(double defaultValue) const {
       return m_lineNumber.value_or(defaultValue);
    }
    void setLineNumber(double value) { m_lineNumber = value; }

    bool hasColumnNumber() { return m_columnNumber.has_value(); }
    double getColumnNumber(double defaultValue) const {
       return m_columnNumber.value_or(defaultValue);
    }
    void setColumnNumber(double value) { m_columnNumber = value; }

    bool hasRequestId() { return m_requestId.has_value(); }
    String getRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    void setRequestId(const String& value) { m_requestId = value; }

    template<int STATE>
    class InitiatorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        InitiatorBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        InitiatorBuilder<STATE>& setStack(std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> value)
        {
            m_result->setStack(std::move(value));
            return *this;
        }

        InitiatorBuilder<STATE>& setUrl(const String& value)
        {
            m_result->setUrl(value);
            return *this;
        }

        InitiatorBuilder<STATE>& setLineNumber(double value)
        {
            m_result->setLineNumber(value);
            return *this;
        }

        InitiatorBuilder<STATE>& setColumnNumber(double value)
        {
            m_result->setColumnNumber(value);
            return *this;
        }

        InitiatorBuilder<STATE>& setRequestId(const String& value)
        {
            m_result->setRequestId(value);
            return *this;
        }

        std::unique_ptr<Initiator> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Initiator;
        InitiatorBuilder() : m_result(new Initiator()) { }

        template<int STEP> InitiatorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InitiatorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Initiator> m_result;
    };

    static InitiatorBuilder<0> create()
    {
        return InitiatorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Initiator()
    {
    }

    String m_type;
    Maybe<v8_inspector::protocol::Runtime::API::StackTrace> m_stack;
    Maybe<String> m_url;
    Maybe<double> m_lineNumber;
    Maybe<double> m_columnNumber;
    Maybe<String> m_requestId;
};


class  Request : public ::crdtp::ProtocolObject<Request> {
public:
    ~Request() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    String getMethod() { return m_method; }
    void setMethod(const String& value) { m_method = value; }

    protocol::Network::Headers* getHeaders() { return m_headers.get(); }
    void setHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    template<int STATE>
    class RequestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            MethodSet = 1 << 2,
            HeadersSet = 1 << 3,
            AllFieldsSet = (UrlSet | MethodSet | HeadersSet | 0)};


        RequestBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        RequestBuilder<STATE | MethodSet>& setMethod(const String& value)
        {
            static_assert(!(STATE & MethodSet), "property method should not be set yet");
            m_result->setMethod(value);
            return castState<MethodSet>();
        }

        RequestBuilder<STATE | HeadersSet>& setHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->setHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        std::unique_ptr<Request> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Request;
        RequestBuilder() : m_result(new Request()) { }

        template<int STEP> RequestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RequestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Request> m_result;
    };

    static RequestBuilder<0> create()
    {
        return RequestBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Request()
    {
    }

    String m_url;
    String m_method;
    std::unique_ptr<protocol::Network::Headers> m_headers;
};


class  Response : public ::crdtp::ProtocolObject<Response> {
public:
    ~Response() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    int getStatus() { return m_status; }
    void setStatus(int value) { m_status = value; }

    String getStatusText() { return m_statusText; }
    void setStatusText(const String& value) { m_statusText = value; }

    protocol::Network::Headers* getHeaders() { return m_headers.get(); }
    void setHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    template<int STATE>
    class ResponseBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            StatusSet = 1 << 2,
            StatusTextSet = 1 << 3,
            HeadersSet = 1 << 4,
            AllFieldsSet = (UrlSet | StatusSet | StatusTextSet | HeadersSet | 0)};


        ResponseBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        ResponseBuilder<STATE | StatusSet>& setStatus(int value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->setStatus(value);
            return castState<StatusSet>();
        }

        ResponseBuilder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            static_assert(!(STATE & StatusTextSet), "property statusText should not be set yet");
            m_result->setStatusText(value);
            return castState<StatusTextSet>();
        }

        ResponseBuilder<STATE | HeadersSet>& setHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->setHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        std::unique_ptr<Response> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Response;
        ResponseBuilder() : m_result(new Response()) { }

        template<int STEP> ResponseBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ResponseBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Response> m_result;
    };

    static ResponseBuilder<0> create()
    {
        return ResponseBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Response()
    {
          m_status = 0;
    }

    String m_url;
    int m_status;
    String m_statusText;
    std::unique_ptr<protocol::Network::Headers> m_headers;
};


// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;

};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void requestWillBeSent(const String& requestId, std::unique_ptr<protocol::Network::Request> request, std::unique_ptr<protocol::Network::Initiator> initiator, double timestamp, double wallTime);
    void responseReceived(const String& requestId, double timestamp, const String& type, std::unique_ptr<protocol::Network::Response> response);
    void loadingFailed(const String& requestId, double timestamp, const String& type, const String& errorText);
    void loadingFinished(const String& requestId, double timestamp);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Network
} // namespace node
} // namespace inspector
} // namespace protocol

#endif // !defined(node_inspector_protocol_Network_h)
