// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "src/node/inspector/protocol/Network.h"

#include "src/node/inspector/protocol/Protocol.h"

#include "crdtp/cbor.h"
#include "crdtp/find_by_first.h"
#include "crdtp/span.h"

namespace node {
namespace inspector {
namespace protocol {
namespace Network {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Network";
const char Metainfo::commandPrefix[] = "Network.";
const char Metainfo::version[] = "1.0";

namespace ResourceTypeEnum {
const char Document[] = "Document";
const char Stylesheet[] = "Stylesheet";
const char Image[] = "Image";
const char Media[] = "Media";
const char Font[] = "Font";
const char Script[] = "Script";
const char TextTrack[] = "TextTrack";
const char XHR[] = "XHR";
const char Fetch[] = "Fetch";
const char Prefetch[] = "Prefetch";
const char EventSource[] = "EventSource";
const char WebSocket[] = "WebSocket";
const char Manifest[] = "Manifest";
const char SignedExchange[] = "SignedExchange";
const char Ping[] = "Ping";
const char CSPViolationReport[] = "CSPViolationReport";
const char Preflight[] = "Preflight";
const char Other[] = "Other";
} // namespace ResourceTypeEnum






const char* Initiator::TypeEnum::Parser = "parser";
const char* Initiator::TypeEnum::Script = "script";
const char* Initiator::TypeEnum::Preload = "preload";
const char* Initiator::TypeEnum::SignedExchange = "SignedExchange";
const char* Initiator::TypeEnum::Preflight = "preflight";
const char* Initiator::TypeEnum::Other = "other";
CRDTP_BEGIN_DESERIALIZER(Initiator)
    CRDTP_DESERIALIZE_FIELD_OPT("columnNumber", m_columnNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("lineNumber", m_lineNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("requestId", m_requestId),
    CRDTP_DESERIALIZE_FIELD_OPT("stack", m_stack),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
    CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Initiator)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("stack", m_stack);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
    CRDTP_SERIALIZE_FIELD("requestId", m_requestId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Request)
    CRDTP_DESERIALIZE_FIELD("headers", m_headers),
    CRDTP_DESERIALIZE_FIELD("method", m_method),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Request)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("method", m_method);
    CRDTP_SERIALIZE_FIELD("headers", m_headers);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Response)
    CRDTP_DESERIALIZE_FIELD("headers", m_headers),
    CRDTP_DESERIALIZE_FIELD("status", m_status),
    CRDTP_DESERIALIZE_FIELD("statusText", m_statusText),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Response)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("status", m_status);
    CRDTP_SERIALIZE_FIELD("statusText", m_statusText);
    CRDTP_SERIALIZE_FIELD("headers", m_headers);
CRDTP_END_SERIALIZER();



// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::requestWillBeSent(const String& requestId, std::unique_ptr<protocol::Network::Request> request, std::unique_ptr<protocol::Network::Initiator> initiator, double timestamp, double wallTime)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("request"), request);
    serializer.AddField(crdtp::MakeSpan("initiator"), initiator);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("wallTime"), wallTime);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.requestWillBeSent", serializer.Finish()));
}

void Frontend::responseReceived(const String& requestId, double timestamp, const String& type, std::unique_ptr<protocol::Network::Response> response)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("response"), response);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.responseReceived", serializer.Finish()));
}

void Frontend::loadingFailed(const String& requestId, double timestamp, const String& type, const String& errorText)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("errorText"), errorText);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.loadingFailed", serializer.Finish()));
}

void Frontend::loadingFinished(const String& requestId, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.loadingFinished", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void disable(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Network"), SortedRedirects(), std::move(dispatcher));
}

} // Network
} // namespace node
} // namespace inspector
} // namespace protocol
