-- autogenerated from https://www.unicode.org/Public/15.0.0/ucd/DerivedCoreProperties.txt
-- |
-- Module      : Unicode.Internal.Char.DerivedCoreProperties
-- Copyright   : (c) 2020 Composewell Technologies and Contributors
-- License     : Apache-2.0
-- Maintainer  : streamly@composewell.com
-- Stability   : experimental

{-# OPTIONS_HADDOCK hide #-}
{-# OPTIONS_GHC -Wno-unrecognised-pragmas #-}
{-# HLINT ignore "Use camelCase" #-}

module Unicode.Internal.Char.DerivedCoreProperties
    ( isXID_Continue
    , isXID_Start
    , isID_Continue
    , isID_Start
    , isUppercase
    , isLowercase
    , isAlphabetic
    ) where

import Data.Bits (Bits(..))
import Data.Char (ord)
import Data.Int (Int8)
import Data.Word (Word16)
import GHC.Exts (Ptr(..))
import Unicode.Internal.Bits (lookupBit, lookupWord16AsInt)

{-# INLINE isXID_Continue #-}
isXID_Continue :: Char -> Bool
isXID_Continue c
    | c < '\x002F' = False
    | c < '\x323B0' = lookupIsXID_ContinueBitMap (ord c)
    | c < '\xE0000' = False
    | c < '\xE01F0' = lookupIsXID_ContinueBitMap (ord c - 0xADC50)
    | otherwise = False

{-# INLINE lookupIsXID_ContinueBitMap #-}
lookupIsXID_ContinueBitMap :: Int -> Bool
lookupIsXID_ContinueBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isXID_ContinueDataBitMap
    !(Ptr offsets#) = isXID_ContinueOffsetsBitMap

isXID_ContinueDataBitMap :: Ptr Int8
isXID_ContinueDataBitMap = Ptr
    "\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\111\
    \\240\239\254\255\255\63\135\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\127\0\0\0\238\135\249\255\255\253\109\211\135\57\2\94\192\255\63\0\238\191\251\
    \\255\255\253\237\243\191\59\1\0\207\255\0\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\
    \\80\0\0\255\7\255\255\255\255\255\255\255\255\255\195\255\255\255\255\255\255\255\255\255\255\255\255\239\159\255\253\255\159\238\159\249\255\255\253\237\243\159\57\224\176\207\255\2\0\236\
    \\199\61\214\24\199\255\195\199\61\129\0\192\255\0\0\184\255\3\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\255\255\7\255\255\255\255\255\255\255\255\63\0\0\255\255\255\
    \\15\255\7\255\255\255\126\0\255\255\255\255\255\255\255\255\255\251\255\255\255\255\191\32\255\255\255\255\255\255\255\128\0\128\255\255\127\0\127\127\127\127\127\127\127\127\255\255\255\255\
    \\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\1\0\0\0\255\255\255\255\255\255\255\231\255\
    \\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\63\36\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\224\255\255\255\255\255\254\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\63\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\207\255\254\255\239\159\249\255\255\
    \\253\197\243\159\121\128\176\207\255\3\80\255\255\0\0\255\255\24\0\0\224\0\0\0\0\138\170\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\255\3\0\248\15\0\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\
    \\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\0\0\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\3\255\3\160\194\255\
    \\254\255\255\255\31\254\255\223\255\255\254\255\255\255\31\64\0\0\0\0\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\255\255\255\255\7\235\3\0\
    \\0\252\255\223\253\255\255\253\255\243\223\61\96\39\207\255\0\0\239\223\253\255\255\253\239\243\223\61\96\96\207\255\14\0\255\255\255\255\255\255\255\0\255\227\255\255\255\255\255\63\
    \\255\1\255\255\255\255\255\231\0\0\247\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\255\255\255\255\255\255\255\127\255\255\255\159\255\3\255\3\128\0\255\191\255\127\0\0\0\0\0\0\255\3\254\255\
    \\255\135\254\255\255\7\192\255\255\255\255\255\255\255\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\31\255\63\255\67\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\255\255\255\127\0\0\255\255\255\255\255\255\255\3\255\255\255\255\255\0\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\255\255\255\255\255\27\3\0\0\0\0\0\0\0\0\224\0\0\0\254\255\62\31\254\255\255\255\255\255\255\255\255\255\127\230\254\255\255\255\255\255\255\255\255\255\255\
    \\247\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\255\3\254\255\255\135\254\255\255\7\0\0\0\0\0\4\160\4\255\255\127\255\255\255\127\255\15\255\15\192\255\255\255\255\63\31\0\255\255\255\
    \\255\255\15\255\255\255\3\255\7\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\63\240\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\252\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\223\184\192\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\223\253\255\255\255\255\255\223\125\240\128\207\255\0\252\238\255\127\252\255\255\
    \\251\47\127\132\95\255\192\255\12\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\127\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\224\227\7\248\231\15\0\0\0\60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\
    \\63\255\1\0\0\63\0\0\0\0\255\255\255\255\255\0\255\255\255\255\255\255\15\0\255\247\255\247\183\255\251\255\251\27\0\0\0\0\0\0\0\0\28\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\224\227\7\248\231\15\0\0\0\60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\255\255\255\255\255\3\255\255\255\255\255\63\255\255\255\255\15\0\255\255\255\31\255\255\255\255\255\255\255\255\1\128\255\3\255\255\255\127\251\255\255\255\255\127\180\255\0\255\
    \\3\191\253\255\255\255\127\251\1\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\127\0\191\231\223\223\255\255\255\
    \\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\3\
    \\255\255\255\255\255\255\255\255\255\63\255\255\255\255\191\32\255\255\255\255\255\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\255\255\253\255\255\255\255\199\7\0\255\3\0\0\0\0\0\0\0\0\0\0\1\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\127\0\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\
    \\255\191\249\15\0\255\3\0\0\0\0\0\0\0\0\255\252\255\255\255\255\255\252\27\0\0\0\255\255\255\255\255\255\127\0\15\0\255\3\248\255\255\224\255\255\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\32\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\248\15\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\252\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\254\255\255\255\255\191\182\0\255\255\255\135\7\0\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\
    \\255\253\255\255\247\207\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\255\255\223\255\255\255\223\255\255\127\255\255\
    \\255\127\255\255\255\253\255\255\255\253\255\255\247\207\255\255\255\255\255\255\127\248\255\255\255\255\255\31\32\0\16\0\0\248\254\255\0\0\0\0\0\0\0\0\0\0\128\1\0\16\
    \\0\0\0\2\128\0\0\255\31\0\0\0\0\0\0\255\31\226\255\1\0\255\255\255\31\128\0\255\255\255\255\1\0\0\0\255\255\63\0\0\0\0\0\255\255\31\0\0\0\255\
    \\255\127\0\248\224\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\3\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\184\192\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\255\255\255\255\255\255\255\255\135\255\255\255\255\255\255\255\128\255\255\0\0\0\0\0\0\0\
    \\0\27\0\3\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\254\255\255\255\255\255\255\7\255\127\255\3\0\0\
    \\0\0\214\247\255\255\175\255\255\63\95\127\255\243\0\0\0\0\255\255\61\255\255\255\255\255\255\255\255\231\0\254\3\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\255\255\255\255\199\255\1\255\255\63\128\255\255\31\0\255\255\15\0\255\223\13\0\255\255\
    \\255\255\255\255\255\255\255\255\143\48\255\3\0\0\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\255\31\255\255\
    \\255\15\0\0\255\255\255\255\255\255\240\191\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\16\0\0\255\255\255\255\255\255\15\0\255\255\255\255\255\255\
    \\255\255\63\0\255\3\255\255\255\232\255\255\255\255\255\255\127\0\255\63\255\3\255\255\127\252\255\255\255\255\255\255\255\255\7\0\0\56\255\255\124\0\126\126\126\0\127\127\255\255\
    \\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\55\255\3\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\
    \\0\0\0\0\255\3\255\255\255\255\0\224\255\255\255\7\255\255\255\255\255\7\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\63\255\3\255\255\255\255\15\255\255\255\255\15\255\255\255\255\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\0\0\0\0\0\0\
    \\0\0\63\253\255\255\255\255\191\145\255\255\63\0\255\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\255\255\63\0\255\255\255\3\0\0\0\0\0\0\0\0\
    \\255\255\255\255\255\255\255\192\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\
    \\255\255\255\255\255\255\127\0\0\0\192\255\63\128\255\255\255\255\255\255\255\7\4\0\255\255\255\1\255\3\255\255\255\255\255\255\223\255\240\0\255\255\255\255\79\0\255\255\255\255\
    \\255\255\255\255\31\222\255\23\0\0\0\0\255\255\251\255\255\255\255\192\3\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\255\255\7\255\3\239\159\249\255\255\253\
    \\237\251\159\57\129\224\207\31\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\7\255\195\3\0\0\0\255\255\255\255\255\255\255\255\
    \\191\0\255\3\0\0\0\0\255\255\255\255\255\255\255\255\17\0\255\3\0\0\0\0\255\255\255\255\255\255\255\1\255\3\0\0\0\0\0\0\255\255\255\231\255\15\255\3\127\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\
    \\255\3\0\128\255\255\255\255\255\255\255\127\128\0\255\255\255\255\255\255\255\255\255\35\0\0\255\255\255\255\255\255\255\255\255\1\255\253\255\255\255\255\127\255\1\0\255\3\0\0\
    \\252\255\255\255\252\255\255\254\127\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\255\255\255\255\255\255\1\255\255\255\127\255\3\255\255\255\255\255\255\255\255\255\127\255\3\255\255\255\63\31\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\63\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\99\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\127\
    \\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\255\255\249\219\7\255\255\255\255\255\255\255\63\0\0\0\128\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\127\0\0\0\0\0\255\255\255\255\255\255\255\255\
    \\255\15\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\94\255\251\255\15\238\251\255\15\0\0\
    \\0\0\0\0\0\0\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"#

isXID_ContinueOffsetsBitMap :: Ptr Word16
isXID_ContinueOffsetsBitMap = Ptr
    "\180\4\113\0\121\0\17\5\255\4\50\8\151\0\133\1\239\0\17\2\81\0\183\0\34\3\48\5\182\9\229\2\154\6\113\0\40\1\214\9\112\0\113\0\246\9\22\10\214\0\207\4\146\3\71\2\66\3\113\0\113\0\54\10\191\8\0\0\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\248\7\12\1\154\4\154\4\45\4\209\1\
    \\154\4\154\4\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\79\1\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\80\5\113\0\86\10\3\3\118\10\22\6\150\10\182\10\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\118\3\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\113\0\
    \\24\9\253\8\239\4\214\10\49\2\176\3\77\4\183\7\103\1\246\10\22\11\180\5\113\0\54\11\86\11\118\11\49\0\150\11\128\2\254\3\14\4\223\8\182\11\214\11\246\11\22\12\54\12\148\5\86\12\118\12\150\12\103\7\182\12\154\4\214\12\53\6\75\6\240\6\113\0\113\0\113\0\134\4\118\4\93\2\154\4\154\4\154\4\154\4\154\4\154\4\
    \\154\4\154\4\154\4\107\2\113\0\113\0\113\0\113\0\185\2\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\113\0\113\0\246\12\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\
    \\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\113\0\113\0\22\13\135\7\154\4\154\4\159\7\119\9\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\160\2\113\0\113\0\113\0\113\0\54\13\16\0\154\4\154\4\
    \\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\18\0\113\0\93\3\107\3\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\86\13\154\4\154\4\154\4\154\4\154\4\
    \\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\106\5\154\4\126\5\204\5\154\4\129\6\165\1\177\1\82\8\154\4\154\4\166\8\154\4\154\4\154\4\154\4\118\13\150\13\208\3\222\3\154\4\246\5\154\4\154\4\72\7\182\13\214\13\154\4\154\4\154\4\154\4\246\13\154\4\154\4\154\4\154\4\154\4\
    \\154\4\154\4\154\4\154\4\154\4\154\4\154\4\156\4\154\4\154\4\154\4\154\4\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\75\1\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\67\1\239\1\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\251\1\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\208\6\154\4\154\4\
    \\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\154\4\113\0\113\0\22\14\154\4\154\4\154\4\154\4\154\4\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\99\4\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\81\1\103\2\113\0"#

{-# INLINE isXID_Start #-}
isXID_Start :: Char -> Bool
isXID_Start c = c >= '\x0041' && c <= '\x323AF' && lookupIsXID_StartBitMap (ord c)

{-# INLINE lookupIsXID_StartBitMap #-}
lookupIsXID_StartBitMap :: Int -> Bool
lookupIsXID_StartBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isXID_StartDataBitMap
    !(Ptr offsets#) = isXID_StartOffsetsBitMap

isXID_StartDataBitMap :: Ptr Int8
isXID_StartDataBitMap = Ptr
    "\224\255\255\255\255\255\254\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\255\255\255\0\0\15\0\0\0\248\255\255\224\255\255\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\138\170\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\31\0\128\7\0\128\3\0\0\0\255\255\255\255\255\255\0\0\176\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\127\0\0\0\0\0\15\
    \\0\0\0\0\255\255\255\255\255\7\0\0\0\192\254\255\255\255\255\255\255\255\255\255\255\255\47\0\96\192\0\156\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\111\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\254\255\255\7\254\255\255\7\0\0\0\0\0\4\32\4\255\255\127\255\255\255\127\255\255\61\255\255\255\255\255\255\255\
    \\255\7\0\0\0\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\
    \\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\31\120\12\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\
    \\253\255\255\247\255\255\255\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\
    \\255\255\255\255\255\255\199\255\1\0\239\254\255\255\63\0\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\31\0\0\0\255\255\255\255\255\255\255\255\15\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\
    \\255\255\255\255\255\7\0\128\0\0\63\60\98\192\225\255\3\64\0\0\255\255\255\255\191\32\255\255\255\255\255\247\255\31\255\255\0\12\0\0\255\255\255\255\255\127\0\128\255\255\
    \\255\63\255\255\255\255\255\255\255\255\255\255\0\0\126\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\
    \\1\0\0\247\15\0\0\255\255\127\196\255\255\255\255\255\255\98\62\5\0\0\56\255\7\28\0\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\0\0\0\0\224\0\252\255\255\255\63\255\1\255\255\255\
    \\255\255\231\0\0\0\0\0\222\111\4\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\0\0\255\
    \\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\255\
    \\255\255\255\7\235\3\0\0\252\255\255\63\0\255\255\127\0\0\0\255\255\255\31\240\255\255\255\255\255\7\0\0\128\0\0\223\255\0\124\224\159\249\255\255\253\237\35\0\0\0\
    \\176\3\0\2\0\232\199\61\214\24\199\255\3\0\0\1\0\0\0\0\0\0\0\255\254\255\255\255\31\0\0\0\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\
    \\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\0\0\0\0\254\255\255\7\254\255\255\7\192\255\255\255\255\
    \\255\255\63\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\15\255\255\255\255\15\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\3\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\255\
    \\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\255\0\128\2\0\0\0\0\0\
    \\0\0\0\0\0\0\255\252\255\255\255\255\1\0\10\0\0\0\255\255\255\255\255\255\255\255\255\255\255\63\240\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\3\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\223\184\64\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\255\127\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\128\0\0\0\0\0\0\0\0\0\
    \\0\0\127\251\255\255\255\255\1\0\64\0\0\0\191\253\255\255\255\3\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\255\7\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\
    \\239\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\0\0\0\0\
    \\0\0\0\0\255\255\255\135\7\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\1\0\0\0\244\255\253\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\7\0\255\255\255\255\255\255\0\0\16\0\0\0\0\0\0\0\255\255\255\255\255\7\0\1\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\255\255\255\255\255\127\0\0\0\0\0\15\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\15\0\0\255\255\255\255\255\255\255\255\255\255\
    \\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\3\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\
    \\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\0\255\255\255\255\255\255\15\0\255\247\255\247\183\255\251\255\251\27\0\0\0\0\0\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\128\0\255\255\63\0\0\0\0\0\255\255\3\0\0\0\0\0\255\255\31\0\0\0\255\255\127\0\248\160\255\253\
    \\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\
    \\0\0\0\255\255\255\255\0\224\255\255\255\7\255\255\255\255\63\0\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\
    \\255\255\255\255\255\255\1\0\0\0\0\0\255\255\3\128\255\255\3\0\255\255\3\0\255\223\1\0\255\255\255\255\255\255\15\0\0\0\128\16\0\0\0\0\255\255\255\255\255\255\
    \\255\255\255\255\255\1\255\255\255\255\255\5\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\3\255\255\251\255\255\
    \\15\0\128\1\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\127\0\0\0\0\0\0\255\255\255\63\31\0\255\255\255\255\255\15\255\255\255\3\0\0\0\0\0\
    \\0\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\255\255\5\255\255\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\255\255\255\255\255\255\255\255\255\7\1\0\0\0\0\0\0\0\248\255\0\0\0\0\0\0\0\0\11\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\63\4\16\1\0\0\255\255\255\1\255\7\255\255\255\126\0\0\255\255\255\255\255\3\0\0\0\0\0\0\253\255\255\255\
    \\0\0\0\224\255\255\255\255\255\255\255\255\255\255\63\0\2\0\0\252\255\255\255\7\48\4\240\255\255\255\255\255\255\35\0\0\1\255\3\0\254\255\225\159\249\255\255\253\197\35\
    \\0\64\0\176\3\0\3\16\224\135\249\255\255\253\109\3\0\0\0\94\0\0\28\0\224\191\251\255\255\253\237\35\0\0\1\0\3\0\0\2\224\223\253\255\255\253\255\35\0\0\
    \\0\39\3\0\0\0\225\223\253\255\255\253\239\35\0\0\0\96\3\0\6\0\240\223\253\255\255\255\255\39\0\64\112\128\3\0\0\252\224\255\127\252\255\255\251\47\127\0\0\0\
    \\0\0\0\0\254\255\255\255\255\255\5\0\127\0\0\0\0\0\0\0\214\247\255\255\175\255\5\32\95\0\0\240\0\0\0\0\224\255\255\255\255\255\15\0\224\31\0\0\0\0\
    \\0\0\248\255\255\255\1\192\0\252\255\255\255\255\63\0\0\0\255\255\255\255\191\32\255\255\255\255\255\255\255\128\0\0\255\255\127\0\127\127\127\127\127\127\127\127\0\0\0\0\
    \\224\0\0\0\254\3\62\31\254\255\255\255\255\255\255\255\255\255\127\224\254\255\255\255\255\255\255\255\255\255\255\247\187\247\255\255\7\0\0\0\255\255\255\255\255\255\15\0\252\255\
    \\255\255\255\255\15\0\0\0\0\0\0\0\252\104\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\0\0\255\255\255\255\
    \\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\63\253\255\255\255\255\191\145\255\255\63\0\255\255\127\0\255\255\255\127\0\0\
    \\0\0\0\0\0\0\255\255\55\0\255\255\63\0\255\255\255\3\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\0\0\0\248\255\255\255\255\255\255\0\
    \\0\0\0\0\0\0\38\0\248\255\255\255\255\255\0\0\0\0\255\255\255\1\0\0\248\255\255\255\127\0\0\0\144\0\255\255\255\255\71\0\248\255\255\255\255\255\7\0\30\0\
    \\0\20\0\0\0\0\224\159\249\255\255\253\237\35\0\0\1\224\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\7\0\0\0\0\127\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\248\255\255\255\255\7\4\0\0\1\240\255\255\255\255\255\3\0\32\0\0\255\255\255\255\255\255\255\255\
    \\255\1\255\253\255\255\255\127\0\0\1\0\0\0\0\0\252\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\1\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\63\0\0\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\
    \\255\253\255\255\247\15\0\0\0\0\0\0\255\255\255\255\255\255\255\255\15\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\255\255\255\150\254\
    \\247\10\132\234\150\170\150\247\247\94\255\251\255\15\238\251\255\15\0\0\0\0\0\0\0\0"#

isXID_StartOffsetsBitMap :: Ptr Word16
isXID_StartOffsetsBitMap = Ptr
    "\53\1\233\0\241\0\109\5\54\5\42\6\150\0\240\9\210\9\16\10\48\10\15\4\80\10\112\10\144\10\41\4\188\2\233\0\15\6\84\1\232\0\233\0\65\2\214\8\242\8\65\9\140\5\176\10\111\3\29\1\233\0\112\1\207\4\182\0\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\176\1\208\10\227\4\227\4\240\10\0\0\
    \\227\4\227\4\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\29\1\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\3\2\233\0\220\2\210\3\16\11\239\3\27\3\48\11\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\84\3\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\233\0\
    \\123\8\96\8\38\5\9\9\72\0\109\4\144\1\65\4\81\4\155\8\141\4\164\7\233\0\80\11\112\11\144\11\96\2\117\9\163\2\168\4\184\4\66\8\176\11\208\11\41\9\240\11\97\0\122\0\183\6\16\12\181\3\6\5\48\12\227\4\80\12\172\5\192\5\128\6\233\0\233\0\233\0\89\5\73\5\128\2\227\4\227\4\227\4\227\4\227\4\227\4\
    \\227\4\227\4\227\4\142\2\233\0\233\0\233\0\233\0\244\2\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\233\0\233\0\112\12\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\
    \\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\233\0\233\0\144\12\30\0\227\4\227\4\54\0\149\9\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\138\7\233\0\233\0\233\0\233\0\176\12\198\0\227\4\227\4\
    \\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\200\0\233\0\59\3\73\3\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\73\7\227\4\227\4\227\4\227\4\227\4\
    \\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\246\5\208\1\220\1\208\12\227\4\227\4\227\4\227\4\227\4\227\4\227\4\196\7\222\7\143\3\157\3\227\4\16\7\227\4\227\4\231\4\252\1\240\12\227\4\227\4\227\4\227\4\16\13\227\4\227\4\227\4\227\4\227\4\
    \\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\25\1\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\17\1\31\2\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\43\2\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\96\6\227\4\227\4\
    \\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\233\0\233\0\232\7\227\4\227\4\227\4\227\4\227\4\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\166\1\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\176\1"#

{-# INLINE isID_Continue #-}
isID_Continue :: Char -> Bool
isID_Continue c
    | c < '\x002F' = False
    | c < '\x323B0' = lookupIsID_ContinueBitMap (ord c)
    | c < '\xE0000' = False
    | c < '\xE01F0' = lookupIsID_ContinueBitMap (ord c - 0xADC50)
    | otherwise = False

{-# INLINE lookupIsID_ContinueBitMap #-}
lookupIsID_ContinueBitMap :: Int -> Bool
lookupIsID_ContinueBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isID_ContinueDataBitMap
    !(Ptr offsets#) = isID_ContinueOffsetsBitMap

isID_ContinueDataBitMap :: Ptr Int8
isID_ContinueDataBitMap = Ptr
    "\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\111\
    \\240\239\254\255\255\63\135\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\127\0\0\0\238\135\249\255\255\253\109\211\135\57\2\94\192\255\63\0\238\191\251\
    \\255\255\253\237\243\191\59\1\0\207\255\0\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\
    \\80\0\0\255\7\255\255\255\255\255\255\255\255\255\195\255\255\255\255\255\255\255\255\255\255\255\255\239\159\255\253\255\159\238\159\249\255\255\253\237\243\159\57\224\176\207\255\2\0\236\
    \\199\61\214\24\199\255\195\199\61\129\0\192\255\0\0\184\255\3\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\255\255\7\255\255\255\255\255\255\255\255\63\0\0\255\255\255\
    \\15\255\7\255\255\255\126\0\255\255\255\255\255\255\255\255\255\251\255\255\255\255\191\32\255\255\255\255\255\255\255\128\0\128\255\255\127\0\127\127\127\127\127\127\127\127\255\255\255\255\
    \\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\1\0\0\0\255\255\255\255\255\255\255\231\255\
    \\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\63\36\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\224\255\255\255\255\255\254\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\63\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\207\255\254\255\239\159\249\255\255\
    \\253\197\243\159\121\128\176\207\255\3\80\255\255\0\0\255\255\24\0\0\224\0\0\0\0\223\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\255\3\0\248\15\0\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\
    \\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\7\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\0\0\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\3\255\3\160\194\255\
    \\254\255\255\255\31\254\255\223\255\255\254\255\255\255\31\64\0\0\0\0\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\255\255\255\255\7\235\3\0\
    \\0\252\255\223\253\255\255\253\255\243\223\61\96\39\207\255\0\0\239\223\253\255\255\253\239\243\223\61\96\96\207\255\14\0\255\255\255\255\255\255\255\0\255\227\255\255\255\255\255\63\
    \\255\1\255\255\255\255\255\231\0\0\247\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\255\255\255\255\255\255\255\127\255\255\255\159\255\3\255\3\128\0\255\191\255\127\0\0\0\0\0\0\255\3\254\255\
    \\255\135\254\255\255\7\192\255\255\255\255\255\255\255\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\31\255\63\255\67\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\255\255\255\127\0\0\255\255\255\255\255\255\255\3\255\255\255\255\255\0\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\255\255\255\255\255\27\3\0\0\0\0\0\0\0\0\224\0\0\0\254\255\62\31\254\255\255\255\255\255\255\255\255\255\127\254\254\255\255\255\255\255\255\255\255\255\255\
    \\247\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\3\254\255\255\135\254\255\255\7\0\0\0\0\0\4\160\4\255\255\127\255\255\255\127\255\15\255\15\192\255\
    \\255\255\255\63\31\0\255\255\255\255\255\15\255\255\255\3\255\7\0\0\0\0\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\188\192\215\255\255\251\255\
    \\255\255\255\255\255\255\255\255\191\255\223\253\255\255\255\255\255\223\125\240\128\207\255\0\252\238\255\127\252\255\255\251\47\127\132\95\255\192\255\12\0\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\224\
    \\227\7\248\231\15\0\0\0\60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\255\1\0\0\63\0\0\0\0\255\255\255\255\255\0\255\255\255\
    \\255\255\255\15\0\255\247\255\247\183\255\251\255\251\27\0\0\0\0\0\0\0\0\28\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\224\227\7\
    \\248\231\15\0\0\0\60\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\3\255\255\255\255\255\63\255\255\255\255\15\
    \\0\255\255\255\31\255\255\255\255\255\255\255\255\1\128\255\3\255\255\255\127\251\255\255\255\255\127\180\255\0\255\3\191\253\255\255\255\127\251\1\255\3\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\127\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\63\255\255\255\255\191\32\255\255\255\
    \\255\255\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\1\0\0\0\255\255\253\255\255\255\255\199\7\0\255\3\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\255\255\127\0\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\255\191\249\15\0\255\3\0\0\0\0\0\0\0\0\255\252\255\255\
    \\255\255\255\252\27\0\0\0\255\255\255\255\255\255\127\0\15\0\255\3\248\255\255\224\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\32\255\255\255\63\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\
    \\248\15\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\251\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\254\255\255\
    \\255\255\191\182\0\255\255\255\135\7\0\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\207\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\207\255\255\255\255\255\
    \\255\127\248\255\255\255\255\255\31\32\0\16\0\0\248\254\255\0\0\0\0\0\0\0\0\0\0\128\1\0\16\0\0\0\2\128\0\0\255\31\0\0\0\0\0\0\255\31\226\255\
    \\1\0\255\255\255\31\128\0\255\255\255\255\1\0\0\0\255\255\63\0\0\0\0\0\255\255\31\0\0\0\255\255\127\0\248\224\255\253\127\95\219\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\127\0\248\224\255\253\127\95\219\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\15\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\188\192\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\195\255\3\0\31\80\0\0\255\255\255\255\255\255\255\255\255\135\255\255\255\255\255\255\255\128\255\255\0\0\0\0\0\0\0\0\27\0\3\0\0\0\0\0\0\
    \\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\254\255\255\255\255\255\255\7\255\127\255\3\0\0\0\0\214\247\255\255\175\255\255\63\
    \\95\127\255\243\0\0\0\0\255\255\61\255\255\255\255\255\255\255\255\231\0\254\3\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\255\255\255\255\199\255\1\255\255\63\128\255\255\31\0\255\255\15\0\255\223\13\0\255\255\255\255\255\255\255\255\255\255\143\48\
    \\255\3\0\0\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\255\31\255\255\255\15\0\0\255\255\255\255\255\255\
    \\240\191\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\16\0\0\255\255\255\255\255\255\15\0\255\255\255\255\255\255\255\255\63\0\255\3\255\255\255\232\
    \\255\255\255\255\255\255\127\0\255\63\255\3\255\255\127\252\255\255\255\255\255\255\255\255\7\0\0\56\255\255\124\0\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\55\255\3\255\255\255\255\0\224\255\255\255\7\255\255\255\255\255\7\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\3\255\255\255\255\15\255\255\255\255\15\255\255\255\255\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\
    \\253\7\0\0\0\0\0\0\0\0\63\253\255\255\255\255\191\145\255\255\63\0\255\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\255\255\63\0\255\255\255\3\
    \\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\192\255\63\128\255\255\255\255\255\255\255\7\4\0\255\255\255\1\255\3\255\255\255\255\255\255\223\255\240\0\255\255\
    \\255\255\79\0\255\255\255\255\255\255\255\255\31\222\255\23\0\0\0\0\255\255\251\255\255\255\255\192\3\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\255\255\7\
    \\255\3\239\159\249\255\255\253\237\251\159\57\129\224\207\31\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\7\255\195\3\0\0\0\
    \\255\255\255\255\255\255\255\255\191\0\255\3\0\0\0\0\255\255\255\255\255\255\255\255\17\0\255\3\0\0\0\0\255\255\255\255\255\255\255\1\255\3\0\0\0\0\0\0\255\255\
    \\255\231\255\15\255\3\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\255\255\255\255\255\255\255\255\3\0\128\255\255\255\255\255\255\255\127\128\0\255\255\255\255\255\255\255\255\255\35\0\0\255\255\255\255\255\255\255\255\255\1\255\253\255\255\255\255\
    \\127\255\1\0\255\3\0\0\252\255\255\255\252\255\255\254\127\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\1\255\255\255\127\255\3\255\255\255\255\255\255\255\255\255\127\255\3\255\255\255\63\31\0\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\99\0\0\0\0\0\0\0\0\
    \\0\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\255\255\249\219\7\255\255\255\255\255\255\255\63\
    \\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\127\0\0\0\0\0\
    \\255\255\255\255\255\255\255\255\255\15\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\94\255\251\
    \\255\15\238\251\255\15\0\0\0\0\0\0\0\0\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"#

isID_ContinueOffsetsBitMap :: Ptr Word16
isID_ContinueOffsetsBitMap = Ptr
    "\139\4\113\0\121\0\254\4\236\4\31\8\151\0\133\1\239\0\17\2\81\0\183\0\34\3\29\5\222\9\229\2\135\6\113\0\40\1\254\9\112\0\113\0\30\10\62\10\214\0\166\4\146\3\71\2\66\3\113\0\113\0\94\10\172\8\0\0\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\229\7\12\1\113\4\113\4\45\4\209\1\
    \\113\4\113\4\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\79\1\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\61\5\113\0\126\10\3\3\158\10\3\6\190\10\222\10\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\118\3\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\0\
    \\5\9\234\8\113\0\64\9\49\2\176\3\198\4\164\7\103\1\254\10\30\11\161\5\113\0\62\11\94\11\126\11\49\0\158\11\128\2\254\3\14\4\204\8\190\11\222\11\254\11\30\12\62\12\129\5\94\12\126\12\158\12\84\7\190\12\113\4\222\12\34\6\56\6\221\6\113\0\113\0\113\0\93\4\77\4\93\2\113\4\113\4\113\4\113\4\113\4\113\4\
    \\113\4\113\4\113\4\107\2\113\0\113\0\113\0\113\0\185\2\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\0\113\0\254\12\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\
    \\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\0\113\0\30\13\116\7\113\4\113\4\140\7\159\9\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\160\2\113\0\113\0\113\0\113\0\62\13\16\0\113\4\113\4\
    \\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\18\0\113\0\93\3\107\3\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\94\13\113\4\113\4\113\4\113\4\113\4\
    \\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\87\5\113\4\107\5\185\5\113\4\110\6\165\1\177\1\63\8\113\4\113\4\147\8\113\4\113\4\113\4\113\4\126\13\158\13\208\3\222\3\113\4\227\5\113\4\113\4\53\7\190\13\222\13\113\4\113\4\113\4\113\4\254\13\113\4\113\4\113\4\113\4\113\4\
    \\113\4\113\4\113\4\113\4\113\4\113\4\113\4\115\4\113\4\113\4\113\4\113\4\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\75\1\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\67\1\239\1\113\0\113\0\113\0\
    \\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\251\1\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\189\6\113\4\113\4\
    \\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\4\113\0\113\0\30\14\113\4\113\4\113\4\113\4\113\4\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\220\4\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\113\0\
    \\113\0\113\0\113\0\81\1\103\2\113\0"#

{-# INLINE isID_Start #-}
isID_Start :: Char -> Bool
isID_Start c = c >= '\x0041' && c <= '\x323AF' && lookupIsID_StartBitMap (ord c)

{-# INLINE lookupIsID_StartBitMap #-}
lookupIsID_StartBitMap :: Int -> Bool
lookupIsID_StartBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isID_StartDataBitMap
    !(Ptr offsets#) = isID_StartOffsetsBitMap

isID_StartDataBitMap :: Ptr Int8
isID_StartDataBitMap = Ptr
    "\224\255\255\255\255\255\254\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\255\255\255\0\0\15\0\0\0\248\255\255\224\255\255\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\223\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\31\0\128\7\0\128\3\0\0\0\255\255\255\255\255\255\0\0\176\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\127\0\0\0\0\0\15\
    \\0\0\0\0\255\255\255\255\255\7\0\0\0\192\254\255\255\255\255\255\255\255\255\255\255\255\47\0\96\192\0\156\132\252\47\63\80\253\255\243\224\67\0\0\255\255\255\255\255\1\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\111\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\254\255\255\7\254\255\255\7\0\0\0\0\0\4\32\4\255\255\127\255\255\255\127\255\255\61\255\255\255\255\255\255\255\
    \\255\7\0\0\0\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\255\255\255\255\63\63\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\
    \\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\31\120\12\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\
    \\253\255\255\247\255\255\255\247\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\
    \\255\255\255\255\255\255\199\255\1\0\239\254\255\255\63\0\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\31\0\0\0\255\255\255\255\255\255\255\255\15\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\0\255\
    \\255\255\255\255\255\7\0\128\0\0\63\60\98\192\225\255\3\64\0\0\255\255\255\255\191\32\255\255\255\255\255\247\255\31\255\255\0\12\0\0\255\255\255\255\255\127\0\128\255\255\
    \\255\63\255\255\255\255\255\255\255\255\255\255\0\0\126\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\
    \\1\0\0\247\15\0\0\255\255\127\196\255\255\255\255\255\255\98\62\5\0\0\56\255\7\28\0\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\0\0\0\0\224\0\252\255\255\255\63\255\1\255\255\255\
    \\255\255\231\0\0\0\0\0\222\111\4\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\0\0\255\
    \\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\255\249\255\255\255\255\
    \\255\255\255\7\235\3\0\0\252\255\255\63\0\255\255\127\0\0\0\255\255\255\31\240\255\255\255\255\255\7\0\0\128\0\0\223\255\0\124\224\159\249\255\255\253\237\35\0\0\0\
    \\176\3\0\2\0\232\199\61\214\24\199\255\3\0\0\1\0\0\0\0\0\0\0\255\254\255\255\255\31\0\0\0\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\
    \\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\0\0\0\0\0\254\255\255\7\254\255\255\7\192\255\255\255\255\
    \\255\255\255\255\255\255\127\252\252\252\28\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\15\255\255\255\255\15\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\3\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\255\
    \\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\255\0\128\2\0\0\0\0\0\
    \\0\0\0\0\0\0\255\252\255\255\255\255\1\0\10\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\223\188\64\215\255\255\251\255\255\255\255\255\255\
    \\255\255\255\191\255\255\127\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\127\251\255\255\255\255\1\0\64\0\0\0\191\253\
    \\255\255\255\3\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\7\0\191\231\223\223\255\255\255\123\95\252\253\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\
    \\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\0\0\0\0\0\0\0\0\255\255\255\135\7\0\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\244\255\
    \\253\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\
    \\255\7\0\255\255\255\255\255\255\0\0\16\0\0\0\0\0\0\0\255\255\255\255\255\7\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\127\0\
    \\0\0\0\0\15\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\15\0\0\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\7\255\31\255\1\255\3\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\255\255\255\255\
    \\255\255\15\0\255\247\255\247\183\255\251\255\251\27\0\0\0\0\0\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\31\128\63\0\64\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\
    \\255\31\128\0\255\255\63\0\0\0\0\0\255\255\3\0\0\0\0\0\255\255\31\0\0\0\255\255\127\0\248\160\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\3\0\0\0\248\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\127\0\248\160\255\253\127\95\219\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\15\255\255\255\255\
    \\0\224\255\255\255\7\255\255\255\255\63\0\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\31\255\255\255\255\255\255\1\
    \\0\0\0\0\0\255\255\3\128\255\255\3\0\255\255\3\0\255\223\1\0\255\255\255\255\255\255\15\0\0\0\128\16\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\1\255\
    \\255\255\255\255\5\255\255\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\251\255\255\15\0\128\1\0\0\
    \\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\127\0\0\0\0\0\0\255\255\255\63\31\0\255\255\255\255\255\15\255\255\255\3\0\0\0\0\0\0\255\255\255\255\255\
    \\255\255\255\255\255\255\1\255\255\255\255\255\5\255\255\255\255\255\255\255\255\63\0\255\255\255\3\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\0\0\
    \\0\255\255\255\255\255\255\255\255\255\7\1\0\0\0\0\0\0\0\248\255\0\0\0\0\0\0\0\0\11\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\255\255\63\4\16\1\0\0\255\255\255\1\255\7\255\255\255\126\0\0\255\255\255\255\255\3\0\0\0\0\0\0\253\255\255\255\0\0\
    \\0\224\255\255\255\255\255\255\255\255\255\255\63\0\2\0\0\252\255\255\255\7\48\4\240\255\255\255\255\255\255\35\0\0\1\255\3\0\254\255\225\159\249\255\255\253\197\35\0\64\
    \\0\176\3\0\3\16\224\135\249\255\255\253\109\3\0\0\0\94\0\0\28\0\224\191\251\255\255\253\237\35\0\0\1\0\3\0\0\2\224\223\253\255\255\253\255\35\0\0\0\39\
    \\3\0\0\0\225\223\253\255\255\253\239\35\0\0\0\96\3\0\6\0\240\223\253\255\255\255\255\39\0\64\112\128\3\0\0\252\224\255\127\252\255\255\251\47\127\0\0\0\0\0\
    \\0\0\254\255\255\255\255\255\13\0\127\0\0\0\0\0\0\0\214\247\255\255\175\255\13\32\95\0\0\240\0\0\0\0\224\255\255\255\255\255\15\0\224\31\0\0\0\0\0\0\
    \\248\255\255\255\1\192\0\252\255\255\255\255\63\0\0\0\255\255\255\255\191\32\255\255\255\255\255\255\255\128\0\0\255\255\127\0\127\127\127\127\127\127\127\127\0\0\0\0\224\0\
    \\0\0\254\3\62\31\254\255\255\255\255\255\255\255\255\255\127\248\254\255\255\255\255\255\255\255\255\255\255\247\187\247\255\255\7\0\0\0\255\255\255\255\255\255\15\0\252\255\255\255\
    \\255\255\15\0\0\0\0\0\0\0\252\104\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\0\0\255\255\255\255\255\255\
    \\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\63\253\255\255\255\255\191\145\255\255\63\0\255\255\127\0\255\255\255\127\0\0\0\0\
    \\0\0\0\0\255\255\55\0\248\255\255\255\255\255\255\0\0\0\0\0\0\0\38\0\248\255\255\255\255\255\0\0\0\0\255\255\255\1\0\0\248\255\255\255\127\0\0\0\144\0\
    \\255\255\255\255\71\0\248\255\255\255\255\255\7\0\30\0\0\20\0\0\0\0\224\159\249\255\255\253\237\35\0\0\1\224\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\255\255\255\7\0\0\0\0\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\1\248\255\255\255\255\7\4\0\0\1\240\255\255\
    \\255\255\255\3\0\32\0\0\255\255\255\255\255\255\255\255\255\1\255\253\255\255\255\127\0\0\1\0\0\0\0\0\252\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\255\255\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\1\255\255\255\127\0\0\255\255\255\255\
    \\255\255\255\255\255\127\0\0\255\255\255\63\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\255\255\223\255\
    \\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\15\0\0\0\0\0\0\255\255\255\255\255\255\255\255\15\8\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\239\255\255\255\150\254\247\10\132\234\150\170\150\247\247\94\255\251\255\15\238\251\255\15\0\0\0\0\0\0\0\0"#

isID_StartOffsetsBitMap :: Ptr Word16
isID_StartOffsetsBitMap = Ptr
    "\53\1\233\0\241\0\93\5\38\5\26\6\150\0\32\10\2\10\64\10\96\10\15\4\128\10\160\10\192\10\41\4\188\2\233\0\255\5\84\1\232\0\233\0\65\2\1\9\29\9\109\9\124\5\224\10\111\3\29\1\233\0\112\1\207\4\182\0\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\176\1\0\11\227\4\227\4\32\11\0\0\
    \\227\4\227\4\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\29\1\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\3\2\233\0\220\2\210\3\64\11\239\3\27\3\96\11\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\84\3\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\233\0\
    \\107\8\80\8\233\0\166\8\72\0\109\4\144\1\65\4\81\4\198\8\141\4\148\7\233\0\128\11\160\11\165\9\96\2\53\9\163\2\168\4\184\4\50\8\192\11\224\11\85\9\0\12\97\0\122\0\167\6\32\12\181\3\6\5\64\12\227\4\96\12\156\5\176\5\112\6\233\0\233\0\233\0\73\5\57\5\128\2\227\4\227\4\227\4\227\4\227\4\227\4\
    \\227\4\227\4\227\4\142\2\233\0\233\0\233\0\233\0\244\2\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\233\0\233\0\128\12\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\
    \\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\233\0\233\0\160\12\30\0\227\4\227\4\54\0\197\9\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\122\7\233\0\233\0\233\0\233\0\192\12\198\0\227\4\227\4\
    \\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\200\0\233\0\59\3\73\3\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\57\7\227\4\227\4\227\4\227\4\227\4\
    \\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\230\5\208\1\220\1\224\12\227\4\227\4\227\4\227\4\227\4\227\4\227\4\180\7\206\7\143\3\157\3\227\4\0\7\227\4\227\4\231\4\252\1\0\13\227\4\227\4\227\4\227\4\32\13\227\4\227\4\227\4\227\4\227\4\
    \\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\25\1\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\17\1\31\2\233\0\233\0\233\0\
    \\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\43\2\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\80\6\227\4\227\4\
    \\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\227\4\233\0\233\0\216\7\227\4\227\4\227\4\227\4\227\4\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\166\1\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\233\0\
    \\233\0\233\0\233\0\176\1"#

{-# INLINE isUppercase #-}
isUppercase :: Char -> Bool
isUppercase c = c >= '\x0041' && c <= '\x1F189' && lookupIsUppercaseBitMap (ord c)

{-# INLINE lookupIsUppercaseBitMap #-}
lookupIsUppercaseBitMap :: Int -> Bool
lookupIsUppercaseBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isUppercaseDataBitMap
    !(Ptr offsets#) = isUppercaseOffsetsBitMap

isUppercaseDataBitMap :: Ptr Int8
isUppercaseDataBitMap = Ptr
    "\255\255\255\255\255\255\0\0\0\0\0\0\85\85\85\85\1\84\85\85\85\85\85\85\171\42\85\85\85\85\85\85\254\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\255\255\255\255\255\231\0\0\0\0\0\0\0\0\85\85\85\85\85\21\0\0\85\85\85\5\0\0\0\0\0\0\0\0\0\0\0\0\240\255\255\31\
    \\0\0\0\192\255\255\127\0\0\0\0\255\255\255\1\0\0\0\4\0\0\0\0\0\0\254\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\254\255\255\7\0\0\0\0\
    \\0\0\0\0\0\0\0\0\255\255\127\127\0\0\0\0\255\0\63\0\255\0\255\0\63\0\170\0\255\0\0\0\0\0\0\0\0\0\15\0\15\0\15\0\31\0\15\85\85\85\
    \\85\85\85\85\170\170\84\85\85\85\85\85\43\214\206\219\177\213\210\174\17\144\164\170\74\85\85\210\85\85\85\85\85\85\85\85\85\85\85\85\85\85\85\85\85\85\21\64\85\85\
    \\85\85\85\85\85\85\85\85\85\85\254\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\192\255\255\
    \\255\0\0\0\0\0\0\255\255\255\3\255\255\255\3\255\255\255\3\255\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\255\255\255\255\191\32\0\0\0\0\0\0\84\85\84\85\85\85\85\85\85\85\0\106\85\40\69\85\85\125\95\85\245\2\65\1\0\0\32\0\85\85\85\85\
    \\85\85\5\108\122\85\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\255\255\255\255\255\255\255\255\255\255\63\0\132\56\39\62\80\61\15\192\32\0\0\0\255\255\0\0\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\247\255\247\
    \\55\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\69\128\64\215\254\255\251\15\0\0\0\128\
    \\28\85\85\85\144\230\176\231\223\31\0\0\0\123\95\252\1\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\0\255\255\255\1\
    \\0\0\0\252\255\255\7\176\231\223\31\0\0\0\123\95\252\1\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\208\100\222\63\
    \\0\0\0\255\255\255\3\0\0\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\255\247\255\247\55\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\3\0\0\240\255\255\63\0\0\0\255\255\255\3\0\0\208\100\222\63\0\0\0\255\255\255\3\0\0\
    \\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\0\0\0\0\0\0\157\234\37\192\85\85\85\85\
    \\85\85\85\85\85\85\85\85\5\40\4\0"#

isUppercaseOffsetsBitMap :: Ptr Word16
isUppercaseOffsetsBitMap = Ptr
    "\184\0\247\0\190\1\62\2\0\0\26\0\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\130\1\59\1\59\1\226\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\40\0\59\1\22\1\215\0\59\1\2\2\59\1\59\1\69\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\62\3\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\64\0\158\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\121\0\59\1\59\1\59\1\59\1\197\2\20\2\59\1\59\1\59\1\59\1\59\1\59\1\137\0\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\160\0\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\214\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\
    \\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\165\2\94\2\113\2\93\0\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\113\1\59\1\59\1\59\1\59\1\59\1\59\1\59\1\95\1"#

{-# INLINE isLowercase #-}
isLowercase :: Char -> Bool
isLowercase c = c >= '\x0061' && c <= '\x1E943' && lookupIsLowercaseBitMap (ord c)

{-# INLINE lookupIsLowercaseBitMap #-}
lookupIsLowercaseBitMap :: Int -> Bool
lookupIsLowercaseBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isLowercaseDataBitMap
    !(Ptr offsets#) = isLowercaseOffsetsBitMap

isLowercaseDataBitMap :: Ptr Int8
isLowercaseDataBitMap = Ptr
    "\170\170\170\170\170\170\170\85\85\171\170\170\170\170\170\212\41\49\36\78\42\45\81\230\64\82\85\181\170\170\41\170\170\170\170\170\170\250\147\133\170\255\255\255\255\255\255\255\255\239\
    \\255\255\255\255\1\3\0\0\0\31\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\252\255\255\15\0\0\192\223\
    \\255\255\0\0\0\252\255\255\15\0\0\192\235\239\255\0\0\0\252\255\255\223\15\0\0\192\255\255\127\63\0\0\0\255\255\255\253\0\0\0\252\255\255\247\11\0\0\0\0\0\
    \\0\255\255\255\255\255\255\170\170\170\170\2\168\170\170\170\170\170\170\84\213\170\170\170\170\170\170\0\0\0\0\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\15\255\251\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\252\255\255\255\15\127\0\248\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\0\0\0\0\
    \\0\0\0\0\32\0\0\0\0\0\138\60\0\0\1\0\0\240\255\255\255\127\227\170\170\170\47\25\255\255\255\255\191\32\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\63\0\196\8\0\
    \\0\128\16\50\192\67\0\0\0\0\255\255\16\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\3\0\0\0\0\168\170\171\
    \\170\170\170\170\170\170\170\255\149\170\80\186\170\170\130\160\170\10\5\170\2\0\0\92\7\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\170\234\191\170\170\170\170\170\
    \\170\170\170\170\170\170\170\0\0\0\0\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\255\255\255\255\255\255\7\0\0\196\8\0\0\128\16\50\192\67\0\0\0\0\255\255\16\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\255\31\0\0\0\
    \\0\0\0\0\0\0\0\0\0\254\255\255\7\0\0\0\0\0\4\32\4\0\0\0\128\255\255\127\255\15\0\0\192\255\255\255\0\0\0\252\255\255\15\0\0\192\255\255\255\0\
    \\0\0\252\255\255\15\0\0\192\255\255\255\0\0\0\252\255\255\63\0\0\0\252\255\255\247\3\0\0\240\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\128\255\251\255\251\27\0\0\0\0\
    \\0\0\0\0\170\170\170\170\170\42\0\0\170\170\170\58\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\185\255\255\255\255\255\253\7\0\0\0\0\0\0\0\0\254\255\
    \\255\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\98\21\218\63\170\170\170\170\170\170\170\170\170\170\170\170\26\80\8\0\255\0\
    \\63\0\255\0\255\0\63\0\255\0\255\0\255\63\255\0\255\0\255\0\223\64\220\0\207\0\255\0\220\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\255\31\0\
    \\0\0\0\0\0\0\0\0\0\0\0"#

isLowercaseOffsetsBitMap :: Ptr Word16
isLowercaseOffsetsBitMap = Ptr
    "\135\2\0\0\31\0\90\1\145\0\171\0\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\46\1\40\1\40\1\158\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\242\2\218\2\13\2\130\3\115\2\190\1\40\1\40\1\207\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\98\3\122\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\28\3\237\1\40\1\40\1\40\1\66\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\37\1\40\1\40\1\40\1\72\3\40\1\40\1\40\1\40\1\198\0\4\3\40\1\48\3\40\1\40\1\40\1\40\1\65\2\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\130\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\60\0\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\
    \\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\89\0\167\2\186\2\119\0\40\1\40\1\40\1\40\1\40\1\40\1\40\1\230\0\0\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\40\1\28\1"#

{-# INLINE isAlphabetic #-}
isAlphabetic :: Char -> Bool
isAlphabetic c = c >= '\x0041' && c <= '\x323AF' && lookupIsAlphabeticBitMap (ord c)

{-# INLINE lookupIsAlphabeticBitMap #-}
lookupIsAlphabeticBitMap :: Int -> Bool
lookupIsAlphabeticBitMap n =
    lookupBit data# (
        lookupWord16AsInt offsets# (
            n `shiftR` 8
        ) + ((n `shiftR` 3) .&. mask)
    ) (n .&. 7)
    where
    mask = (1 `shiftL` 5) - 1
    !(Ptr data#) = isAlphabeticDataBitMap
    !(Ptr offsets#) = isAlphabeticOffsetsBitMap

isAlphabeticDataBitMap :: Ptr Int8
isAlphabeticDataBitMap = Ptr
    "\132\252\47\62\80\189\255\243\224\67\0\0\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\239\111\
    \\240\239\254\255\255\63\0\0\0\0\0\255\255\255\31\255\255\255\31\0\0\0\0\255\254\255\255\31\0\0\0\254\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\195\255\3\0\31\80\0\0\255\7\255\255\255\255\255\255\255\254\0\192\255\255\255\255\255\255\255\255\255\255\255\255\239\31\254\225\
    \\0\156\224\255\255\255\255\255\254\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\0\0\0\0\0\0\255\255\255\252\255\31\0\0\255\255\255\1\255\7\255\255\255\126\
    \\0\0\255\255\255\255\255\3\240\255\248\3\255\255\255\255\191\32\255\255\255\255\255\255\255\128\0\0\255\255\127\0\127\127\127\127\127\127\127\127\255\255\255\255\255\255\255\3\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\128\255\31\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\63\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\192\255\255\255\255\255\255\
    \\3\0\0\255\255\255\255\255\255\0\224\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\252\255\255\255\7\48\4\255\239\255\255\127\255\255\183\255\63\255\63\0\0\0\0\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\120\12\0\191\231\223\
    \\223\255\255\255\123\95\252\253\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\255\255\255\253\255\255\247\255\255\255\247\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\159\255\255\254\255\255\7\255\255\255\255\255\255\255\255\255\199\255\1\255\255\255\255\255\255\255\255\
    \\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\255\255\255\255\255\255\7\
    \\0\255\255\255\255\255\255\7\0\240\0\255\255\255\255\71\0\255\255\255\255\255\255\255\255\30\192\0\20\0\0\0\0\254\255\255\7\254\255\255\7\192\255\255\255\255\255\255\255\255\
    \\255\255\127\252\252\252\28\0\0\0\0\255\31\255\255\0\12\0\0\255\255\255\255\255\127\240\143\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\126\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\1\0\255\255\255\255\7\0\4\0\0\0\39\0\240\0\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\255\255\127\248\255\255\255\255\255\15\255\255\255\255\255\255\255\127\254\255\31\0\
    \\0\0\0\0\128\0\0\128\1\112\0\0\0\0\0\0\255\255\255\255\255\31\128\63\0\64\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\
    \\255\63\0\0\255\255\255\255\255\15\0\0\255\255\251\255\255\255\159\192\3\0\0\0\0\0\0\0\127\189\255\191\255\1\255\255\255\255\255\255\255\1\0\0\0\0\0\0\0\255\
    \\254\255\255\255\31\254\255\15\255\255\254\255\255\255\31\0\0\0\0\0\0\0\0\255\255\255\255\255\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\
    \\31\255\255\255\255\255\255\1\0\0\0\0\0\238\159\249\255\255\253\237\227\159\25\192\176\15\0\2\0\236\199\61\214\24\199\255\195\199\29\129\0\0\0\0\0\128\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\255\255\255\255\255\27\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\127\0\0\0\63\0\0\0\0\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\3\252\255\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\2\128\0\0\255\31\0\0\0\0\0\0\0\0\0\0\0\0\0\0\223\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\31\128\0\255\255\63\0\0\0\0\0\255\255\3\0\0\0\0\0\255\255\31\0\0\0\255\255\127\0\127\251\255\255\255\255\127\180\203\0\0\0\191\253\255\255\255\127\123\
    \\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\127\0\191\231\223\223\255\255\255\123\95\252\253\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\239\255\223\225\255\15\0\254\255\239\159\249\255\
    \\255\253\197\227\159\89\128\176\15\0\3\16\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\255\255\255\1\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\0\0\0\128\255\252\255\255\255\255\255\255\255\255\255\255\255\
    \\255\249\255\255\255\255\255\255\255\7\235\3\0\0\252\255\255\255\7\255\255\255\255\7\0\255\255\255\31\255\255\255\255\255\255\247\255\0\128\0\0\255\255\0\124\255\255\253\255\255\
    \\255\255\199\1\0\0\0\0\0\0\0\0\0\0\0\0\0\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\127\0\
    \\255\255\255\255\255\255\255\255\255\255\255\255\255\127\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\0\0\0\0\255\255\255\15\0\0\255\255\255\255\255\255\255\255\255\255\223\255\255\255\255\255\255\255\255\223\100\222\255\235\239\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\7\255\31\255\1\255\67\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\111\255\127\242\111\255\255\255\191\153\7\
    \\0\0\0\0\0\0\0\0\0\0\0\255\252\255\255\255\255\255\252\26\0\0\0\255\255\255\63\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\0\0\0\0\0\0\0\0\254\255\255\7\254\255\255\7\0\0\0\0\
    \\0\4\32\4\255\255\127\255\255\255\127\255\15\255\1\0\0\255\255\255\63\31\0\255\255\255\255\255\15\255\255\255\3\0\0\0\0\0\0\239\255\255\255\150\254\247\10\132\234\150\
    \\170\150\247\247\94\255\251\255\15\238\251\255\15\0\0\0\0\0\0\0\0\255\255\255\3\255\255\255\3\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\32\0\0\
    \\0\0\0\223\188\64\215\255\255\251\255\255\255\255\255\255\255\255\255\191\255\255\255\255\0\0\0\255\255\255\255\255\255\15\0\255\255\255\255\255\255\255\255\47\0\0\0\0\0\252\
    \\232\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\255\127\249\0\0\255\255\255\255\255\255\255\255\0\60\255\255\
    \\255\255\191\32\255\255\255\255\255\247\127\0\248\224\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\63\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\0\127\0\248\224\255\253\127\95\219\255\255\255\255\255\255\255\255\255\255\255\255\255\3\0\0\0\248\255\255\255\255\
    \\255\255\255\63\0\0\255\255\255\255\255\255\255\255\252\255\255\255\255\255\255\0\0\0\0\0\255\15\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\255\255\255\255\255\255\0\224\255\255\255\7\255\255\255\255\255\7\255\255\255\63\255\255\255\255\15\255\62\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\
    \\255\31\255\255\255\255\255\255\1\0\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\63\0\0\255\255\255\255\15\255\255\255\255\15\128\255\255\15\
    \\0\255\255\15\0\255\223\13\0\255\255\255\255\255\255\207\255\255\1\128\16\0\0\0\0\255\255\255\255\255\255\255\255\255\255\255\1\255\255\255\255\255\7\255\255\255\255\255\255\255\
    \\255\63\0\0\0\0\0\62\0\255\255\255\255\255\255\255\1\4\0\255\255\255\1\0\0\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \\255\255\255\0\0\0\0\0\0\255\255\255\3\255\255\255\3\255\255\255\3\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\255\61\127\61\255\255\255\
    \\255\255\61\255\255\255\255\61\127\61\255\127\255\255\255\255\255\61\255\255\255\255\255\255\255\255\7\0\0\0\0\255\255\0\0\255\255\255\255\255\255\255\255\255\255\63\63\255\255\255\
    \\255\63\63\255\170\255\255\255\63\255\255\255\255\255\255\223\95\220\31\207\15\255\31\220\31\255\255\255\255\255\255\254\255\255\255\127\2\255\255\255\255\255\1\0\0\0\0\255\191\182\
    \\0\255\255\255\135\7\0\238\135\249\255\255\253\109\195\135\25\2\94\0\0\63\0\238\191\251\255\255\253\237\227\191\27\1\0\15\0\0\30\255\223\253\255\255\253\255\227\223\29\96\
    \\39\15\0\0\0\239\223\253\255\255\253\239\227\223\29\96\96\15\0\14\0\255\223\253\255\255\255\255\231\223\93\240\128\15\0\0\252\238\255\127\252\255\255\251\47\127\128\95\255\0\
    \\0\12\0\254\255\255\255\255\255\255\7\127\32\0\0\0\0\0\0\214\247\255\255\175\255\255\59\95\32\0\240\0\0\0\0\255\255\255\255\255\255\239\255\239\31\0\0\0\0\0\
    \\0\255\255\255\255\255\243\0\252\255\255\255\255\191\255\3\0\255\255\255\255\255\255\127\0\0\224\0\252\255\255\255\63\255\1\255\255\255\255\255\231\0\0\0\0\0\222\111\4\224\
    \\0\0\0\254\3\62\31\254\255\255\255\255\255\255\255\255\255\127\224\254\255\255\255\255\255\255\255\255\255\255\247\255\255\255\255\255\255\127\0\255\63\0\0\255\255\127\252\255\255\255\
    \\255\255\255\255\127\5\0\0\56\255\255\60\0\126\126\126\0\127\127\255\255\255\255\255\247\255\3\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\7\0\0\255\255\255\255\255\
    \\0\255\255\255\255\255\255\15\0\255\247\255\247\183\255\251\255\251\27\0\0\0\0\0\0\0\0\255\255\255\255\255\255\127\0\255\255\63\0\255\0\0\0\191\255\255\255\255\255\253\
    \\7\0\0\0\0\0\0\0\0\63\253\255\255\255\255\191\145\255\255\63\0\255\255\127\0\255\255\255\127\0\0\0\0\0\0\0\0\255\255\55\0\255\255\63\0\255\255\255\3\0\
    \\0\0\0\0\0\0\0\255\255\255\255\255\255\255\192\0\0\0\0\0\0\0\0\255\255\255\255\255\255\63\0\255\255\63\0\255\255\7\0\255\255\3\0\0\0\0\0\0\0\0\
    \\0\0\0\0\0\239\159\249\255\255\253\237\227\159\25\129\224\15\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\187\7\0\128\3\
    \\0\0\0\255\255\255\255\255\255\255\255\179\0\0\0\0\0\0\0\255\255\255\255\255\255\255\127\17\0\0\0\0\0\0\0\255\255\255\255\255\255\63\1\0\0\0\0\0\0\0\
    \\0\255\255\255\231\255\7\0\0\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\231\127\0\0\255\255\255\255\255\255\255\
    \\255\255\32\0\0\255\255\255\255\255\255\255\255\255\1\255\253\255\255\255\255\127\127\1\0\0\0\0\0\252\255\255\255\252\255\255\254\127\0\0\0\0\0\0\0\0\0\255\255\255\
    \\255\255\255\255\255\127\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\1\255\255\255\127\0\0\255\255\255\255\255\255\255\
    \\255\255\127\0\0\255\255\255\63\0\0\255\255\255\255\255\255\0\0\15\0\0\0\248\255\255\224\255\255\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\
    \\255\255\135\255\255\255\255\255\255\255\128\255\255\0\0\0\0\0\0\0\0\11\0\3\0\255\255\223\255\255\255\223\255\255\127\255\255\255\127\255\255\255\253\255\255\255\253\255\255\247\
    \\15\0\0\0\0\0\0\255\255\255\127\224\7\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\127\255\255\249\219\7\255\255\255\255\255\
    \\255\255\63\0\0\0\128\0\0\0\0\0\0\0\0\0\0\0\0\0\0\255\255\255\255\255\255\255\255\143\8\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
    \\0\0\0"#

isAlphabeticOffsetsBitMap :: Ptr Word16
isAlphabeticOffsetsBitMap = Ptr
    "\38\7\82\0\90\0\147\7\122\4\221\9\120\0\95\1\182\0\100\5\253\9\245\3\29\10\61\10\93\10\173\3\236\7\82\0\209\7\161\9\81\0\82\0\48\2\245\8\17\9\65\7\66\3\125\10\157\10\252\0\82\0\189\9\177\4\0\0\55\1\55\1\65\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\159\1\212\0\16\4\55\1\189\10\152\0\
    \\55\1\55\1\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\14\7\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\242\1\82\0\199\2\204\5\177\7\233\5\221\10\253\10\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\38\3\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\82\0\
    \\39\8\12\8\82\0\98\8\197\4\167\2\127\1\197\3\213\3\157\8\216\8\29\11\82\0\61\11\93\11\125\11\49\0\157\11\115\2\51\4\67\4\225\4\39\9\139\2\144\3\189\11\221\11\90\4\253\11\29\12\175\5\205\6\61\12\55\1\93\12\1\5\21\5\9\6\82\0\82\0\82\0\157\4\141\4\80\2\55\1\55\1\55\1\55\1\55\1\55\1\
    \\55\1\55\1\55\1\94\2\82\0\82\0\82\0\82\0\223\2\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\82\0\82\0\125\12\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\
    \\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\82\0\82\0\157\12\189\12\55\1\55\1\40\4\221\12\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\130\8\82\0\82\0\82\0\82\0\28\1\16\0\55\1\55\1\
    \\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\18\0\82\0\13\3\27\3\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\154\6\55\1\55\1\55\1\55\1\55\1\
    \\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\75\5\191\1\203\1\253\12\55\1\55\1\55\1\55\1\55\1\55\1\55\1\29\13\61\13\98\3\112\3\55\1\97\6\55\1\55\1\174\6\235\1\93\13\55\1\55\1\55\1\55\1\97\7\55\1\55\1\123\7\55\1\55\1\
    \\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\248\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\240\0\14\2\82\0\82\0\82\0\
    \\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\26\2\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\154\5\55\1\55\1\
    \\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\55\1\82\0\82\0\51\1\55\1\55\1\55\1\55\1\55\1\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\149\1\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\82\0\
    \\82\0\82\0\82\0\159\1"#

