-- autogenerated from https://www.unicode.org/Public/15.0.0/ucd/Blocks.txt
-- |
-- Module      : Unicode.Internal.Char.Blocks
-- Copyright   : (c) 2022 Composewell Technologies and Contributors
-- License     : Apache-2.0
-- Maintainer  : streamly@composewell.com
-- Stability   : experimental

{-# OPTIONS_HADDOCK hide #-}

module Unicode.Internal.Char.Blocks
(Block(..), block, blockDefinition)
where

import Data.Ix (Ix)
import Data.Word (Word32)
import GHC.Exts
import Unicode.Internal.Bits (lookupWord32#)

-- | Unicode [block](https://www.unicode.org/glossary/#block).
--
-- There is a total of 327 blocks.
--
-- @since 0.3.1
data Block
    = BasicLatin -- ^ @U+0000..U+007F@: Basic Latin.
    | Latin1Supplement -- ^ @U+0080..U+00FF@: Latin-1 Supplement.
    | LatinExtendedA -- ^ @U+0100..U+017F@: Latin Extended-A.
    | LatinExtendedB -- ^ @U+0180..U+024F@: Latin Extended-B.
    | IPAExtensions -- ^ @U+0250..U+02AF@: IPA Extensions.
    | SpacingModifierLetters -- ^ @U+02B0..U+02FF@: Spacing Modifier Letters.
    | CombiningDiacriticalMarks -- ^ @U+0300..U+036F@: Combining Diacritical Marks.
    | GreekAndCoptic -- ^ @U+0370..U+03FF@: Greek and Coptic.
    | Cyrillic -- ^ @U+0400..U+04FF@: Cyrillic.
    | CyrillicSupplement -- ^ @U+0500..U+052F@: Cyrillic Supplement.
    | Armenian -- ^ @U+0530..U+058F@: Armenian.
    | Hebrew -- ^ @U+0590..U+05FF@: Hebrew.
    | Arabic -- ^ @U+0600..U+06FF@: Arabic.
    | Syriac -- ^ @U+0700..U+074F@: Syriac.
    | ArabicSupplement -- ^ @U+0750..U+077F@: Arabic Supplement.
    | Thaana -- ^ @U+0780..U+07BF@: Thaana.
    | NKo -- ^ @U+07C0..U+07FF@: NKo.
    | Samaritan -- ^ @U+0800..U+083F@: Samaritan.
    | Mandaic -- ^ @U+0840..U+085F@: Mandaic.
    | SyriacSupplement -- ^ @U+0860..U+086F@: Syriac Supplement.
    | ArabicExtendedB -- ^ @U+0870..U+089F@: Arabic Extended-B.
    | ArabicExtendedA -- ^ @U+08A0..U+08FF@: Arabic Extended-A.
    | Devanagari -- ^ @U+0900..U+097F@: Devanagari.
    | Bengali -- ^ @U+0980..U+09FF@: Bengali.
    | Gurmukhi -- ^ @U+0A00..U+0A7F@: Gurmukhi.
    | Gujarati -- ^ @U+0A80..U+0AFF@: Gujarati.
    | Oriya -- ^ @U+0B00..U+0B7F@: Oriya.
    | Tamil -- ^ @U+0B80..U+0BFF@: Tamil.
    | Telugu -- ^ @U+0C00..U+0C7F@: Telugu.
    | Kannada -- ^ @U+0C80..U+0CFF@: Kannada.
    | Malayalam -- ^ @U+0D00..U+0D7F@: Malayalam.
    | Sinhala -- ^ @U+0D80..U+0DFF@: Sinhala.
    | Thai -- ^ @U+0E00..U+0E7F@: Thai.
    | Lao -- ^ @U+0E80..U+0EFF@: Lao.
    | Tibetan -- ^ @U+0F00..U+0FFF@: Tibetan.
    | Myanmar -- ^ @U+1000..U+109F@: Myanmar.
    | Georgian -- ^ @U+10A0..U+10FF@: Georgian.
    | HangulJamo -- ^ @U+1100..U+11FF@: Hangul Jamo.
    | Ethiopic -- ^ @U+1200..U+137F@: Ethiopic.
    | EthiopicSupplement -- ^ @U+1380..U+139F@: Ethiopic Supplement.
    | Cherokee -- ^ @U+13A0..U+13FF@: Cherokee.
    | UnifiedCanadianAboriginalSyllabics -- ^ @U+1400..U+167F@: Unified Canadian Aboriginal Syllabics.
    | Ogham -- ^ @U+1680..U+169F@: Ogham.
    | Runic -- ^ @U+16A0..U+16FF@: Runic.
    | Tagalog -- ^ @U+1700..U+171F@: Tagalog.
    | Hanunoo -- ^ @U+1720..U+173F@: Hanunoo.
    | Buhid -- ^ @U+1740..U+175F@: Buhid.
    | Tagbanwa -- ^ @U+1760..U+177F@: Tagbanwa.
    | Khmer -- ^ @U+1780..U+17FF@: Khmer.
    | Mongolian -- ^ @U+1800..U+18AF@: Mongolian.
    | UnifiedCanadianAboriginalSyllabicsExtended -- ^ @U+18B0..U+18FF@: Unified Canadian Aboriginal Syllabics Extended.
    | Limbu -- ^ @U+1900..U+194F@: Limbu.
    | TaiLe -- ^ @U+1950..U+197F@: Tai Le.
    | NewTaiLue -- ^ @U+1980..U+19DF@: New Tai Lue.
    | KhmerSymbols -- ^ @U+19E0..U+19FF@: Khmer Symbols.
    | Buginese -- ^ @U+1A00..U+1A1F@: Buginese.
    | TaiTham -- ^ @U+1A20..U+1AAF@: Tai Tham.
    | CombiningDiacriticalMarksExtended -- ^ @U+1AB0..U+1AFF@: Combining Diacritical Marks Extended.
    | Balinese -- ^ @U+1B00..U+1B7F@: Balinese.
    | Sundanese -- ^ @U+1B80..U+1BBF@: Sundanese.
    | Batak -- ^ @U+1BC0..U+1BFF@: Batak.
    | Lepcha -- ^ @U+1C00..U+1C4F@: Lepcha.
    | OlChiki -- ^ @U+1C50..U+1C7F@: Ol Chiki.
    | CyrillicExtendedC -- ^ @U+1C80..U+1C8F@: Cyrillic Extended-C.
    | GeorgianExtended -- ^ @U+1C90..U+1CBF@: Georgian Extended.
    | SundaneseSupplement -- ^ @U+1CC0..U+1CCF@: Sundanese Supplement.
    | VedicExtensions -- ^ @U+1CD0..U+1CFF@: Vedic Extensions.
    | PhoneticExtensions -- ^ @U+1D00..U+1D7F@: Phonetic Extensions.
    | PhoneticExtensionsSupplement -- ^ @U+1D80..U+1DBF@: Phonetic Extensions Supplement.
    | CombiningDiacriticalMarksSupplement -- ^ @U+1DC0..U+1DFF@: Combining Diacritical Marks Supplement.
    | LatinExtendedAdditional -- ^ @U+1E00..U+1EFF@: Latin Extended Additional.
    | GreekExtended -- ^ @U+1F00..U+1FFF@: Greek Extended.
    | GeneralPunctuation -- ^ @U+2000..U+206F@: General Punctuation.
    | SuperscriptsAndSubscripts -- ^ @U+2070..U+209F@: Superscripts and Subscripts.
    | CurrencySymbols -- ^ @U+20A0..U+20CF@: Currency Symbols.
    | CombiningDiacriticalMarksForSymbols -- ^ @U+20D0..U+20FF@: Combining Diacritical Marks for Symbols.
    | LetterlikeSymbols -- ^ @U+2100..U+214F@: Letterlike Symbols.
    | NumberForms -- ^ @U+2150..U+218F@: Number Forms.
    | Arrows -- ^ @U+2190..U+21FF@: Arrows.
    | MathematicalOperators -- ^ @U+2200..U+22FF@: Mathematical Operators.
    | MiscellaneousTechnical -- ^ @U+2300..U+23FF@: Miscellaneous Technical.
    | ControlPictures -- ^ @U+2400..U+243F@: Control Pictures.
    | OpticalCharacterRecognition -- ^ @U+2440..U+245F@: Optical Character Recognition.
    | EnclosedAlphanumerics -- ^ @U+2460..U+24FF@: Enclosed Alphanumerics.
    | BoxDrawing -- ^ @U+2500..U+257F@: Box Drawing.
    | BlockElements -- ^ @U+2580..U+259F@: Block Elements.
    | GeometricShapes -- ^ @U+25A0..U+25FF@: Geometric Shapes.
    | MiscellaneousSymbols -- ^ @U+2600..U+26FF@: Miscellaneous Symbols.
    | Dingbats -- ^ @U+2700..U+27BF@: Dingbats.
    | MiscellaneousMathematicalSymbolsA -- ^ @U+27C0..U+27EF@: Miscellaneous Mathematical Symbols-A.
    | SupplementalArrowsA -- ^ @U+27F0..U+27FF@: Supplemental Arrows-A.
    | BraillePatterns -- ^ @U+2800..U+28FF@: Braille Patterns.
    | SupplementalArrowsB -- ^ @U+2900..U+297F@: Supplemental Arrows-B.
    | MiscellaneousMathematicalSymbolsB -- ^ @U+2980..U+29FF@: Miscellaneous Mathematical Symbols-B.
    | SupplementalMathematicalOperators -- ^ @U+2A00..U+2AFF@: Supplemental Mathematical Operators.
    | MiscellaneousSymbolsAndArrows -- ^ @U+2B00..U+2BFF@: Miscellaneous Symbols and Arrows.
    | Glagolitic -- ^ @U+2C00..U+2C5F@: Glagolitic.
    | LatinExtendedC -- ^ @U+2C60..U+2C7F@: Latin Extended-C.
    | Coptic -- ^ @U+2C80..U+2CFF@: Coptic.
    | GeorgianSupplement -- ^ @U+2D00..U+2D2F@: Georgian Supplement.
    | Tifinagh -- ^ @U+2D30..U+2D7F@: Tifinagh.
    | EthiopicExtended -- ^ @U+2D80..U+2DDF@: Ethiopic Extended.
    | CyrillicExtendedA -- ^ @U+2DE0..U+2DFF@: Cyrillic Extended-A.
    | SupplementalPunctuation -- ^ @U+2E00..U+2E7F@: Supplemental Punctuation.
    | CJKRadicalsSupplement -- ^ @U+2E80..U+2EFF@: CJK Radicals Supplement.
    | KangxiRadicals -- ^ @U+2F00..U+2FDF@: Kangxi Radicals.
    | IdeographicDescriptionCharacters -- ^ @U+2FF0..U+2FFF@: Ideographic Description Characters.
    | CJKSymbolsAndPunctuation -- ^ @U+3000..U+303F@: CJK Symbols and Punctuation.
    | Hiragana -- ^ @U+3040..U+309F@: Hiragana.
    | Katakana -- ^ @U+30A0..U+30FF@: Katakana.
    | Bopomofo -- ^ @U+3100..U+312F@: Bopomofo.
    | HangulCompatibilityJamo -- ^ @U+3130..U+318F@: Hangul Compatibility Jamo.
    | Kanbun -- ^ @U+3190..U+319F@: Kanbun.
    | BopomofoExtended -- ^ @U+31A0..U+31BF@: Bopomofo Extended.
    | CJKStrokes -- ^ @U+31C0..U+31EF@: CJK Strokes.
    | KatakanaPhoneticExtensions -- ^ @U+31F0..U+31FF@: Katakana Phonetic Extensions.
    | EnclosedCJKLettersAndMonths -- ^ @U+3200..U+32FF@: Enclosed CJK Letters and Months.
    | CJKCompatibility -- ^ @U+3300..U+33FF@: CJK Compatibility.
    | CJKUnifiedIdeographsExtensionA -- ^ @U+3400..U+4DBF@: CJK Unified Ideographs Extension A.
    | YijingHexagramSymbols -- ^ @U+4DC0..U+4DFF@: Yijing Hexagram Symbols.
    | CJKUnifiedIdeographs -- ^ @U+4E00..U+9FFF@: CJK Unified Ideographs.
    | YiSyllables -- ^ @U+A000..U+A48F@: Yi Syllables.
    | YiRadicals -- ^ @U+A490..U+A4CF@: Yi Radicals.
    | Lisu -- ^ @U+A4D0..U+A4FF@: Lisu.
    | Vai -- ^ @U+A500..U+A63F@: Vai.
    | CyrillicExtendedB -- ^ @U+A640..U+A69F@: Cyrillic Extended-B.
    | Bamum -- ^ @U+A6A0..U+A6FF@: Bamum.
    | ModifierToneLetters -- ^ @U+A700..U+A71F@: Modifier Tone Letters.
    | LatinExtendedD -- ^ @U+A720..U+A7FF@: Latin Extended-D.
    | SylotiNagri -- ^ @U+A800..U+A82F@: Syloti Nagri.
    | CommonIndicNumberForms -- ^ @U+A830..U+A83F@: Common Indic Number Forms.
    | PhagsPa -- ^ @U+A840..U+A87F@: Phags-pa.
    | Saurashtra -- ^ @U+A880..U+A8DF@: Saurashtra.
    | DevanagariExtended -- ^ @U+A8E0..U+A8FF@: Devanagari Extended.
    | KayahLi -- ^ @U+A900..U+A92F@: Kayah Li.
    | Rejang -- ^ @U+A930..U+A95F@: Rejang.
    | HangulJamoExtendedA -- ^ @U+A960..U+A97F@: Hangul Jamo Extended-A.
    | Javanese -- ^ @U+A980..U+A9DF@: Javanese.
    | MyanmarExtendedB -- ^ @U+A9E0..U+A9FF@: Myanmar Extended-B.
    | Cham -- ^ @U+AA00..U+AA5F@: Cham.
    | MyanmarExtendedA -- ^ @U+AA60..U+AA7F@: Myanmar Extended-A.
    | TaiViet -- ^ @U+AA80..U+AADF@: Tai Viet.
    | MeeteiMayekExtensions -- ^ @U+AAE0..U+AAFF@: Meetei Mayek Extensions.
    | EthiopicExtendedA -- ^ @U+AB00..U+AB2F@: Ethiopic Extended-A.
    | LatinExtendedE -- ^ @U+AB30..U+AB6F@: Latin Extended-E.
    | CherokeeSupplement -- ^ @U+AB70..U+ABBF@: Cherokee Supplement.
    | MeeteiMayek -- ^ @U+ABC0..U+ABFF@: Meetei Mayek.
    | HangulSyllables -- ^ @U+AC00..U+D7AF@: Hangul Syllables.
    | HangulJamoExtendedB -- ^ @U+D7B0..U+D7FF@: Hangul Jamo Extended-B.
    | HighSurrogates -- ^ @U+D800..U+DB7F@: High Surrogates.
    | HighPrivateUseSurrogates -- ^ @U+DB80..U+DBFF@: High Private Use Surrogates.
    | LowSurrogates -- ^ @U+DC00..U+DFFF@: Low Surrogates.
    | PrivateUseArea -- ^ @U+E000..U+F8FF@: Private Use Area.
    | CJKCompatibilityIdeographs -- ^ @U+F900..U+FAFF@: CJK Compatibility Ideographs.
    | AlphabeticPresentationForms -- ^ @U+FB00..U+FB4F@: Alphabetic Presentation Forms.
    | ArabicPresentationFormsA -- ^ @U+FB50..U+FDFF@: Arabic Presentation Forms-A.
    | VariationSelectors -- ^ @U+FE00..U+FE0F@: Variation Selectors.
    | VerticalForms -- ^ @U+FE10..U+FE1F@: Vertical Forms.
    | CombiningHalfMarks -- ^ @U+FE20..U+FE2F@: Combining Half Marks.
    | CJKCompatibilityForms -- ^ @U+FE30..U+FE4F@: CJK Compatibility Forms.
    | SmallFormVariants -- ^ @U+FE50..U+FE6F@: Small Form Variants.
    | ArabicPresentationFormsB -- ^ @U+FE70..U+FEFF@: Arabic Presentation Forms-B.
    | HalfwidthAndFullwidthForms -- ^ @U+FF00..U+FFEF@: Halfwidth and Fullwidth Forms.
    | Specials -- ^ @U+FFF0..U+FFFF@: Specials.
    | LinearBSyllabary -- ^ @U+10000..U+1007F@: Linear B Syllabary.
    | LinearBIdeograms -- ^ @U+10080..U+100FF@: Linear B Ideograms.
    | AegeanNumbers -- ^ @U+10100..U+1013F@: Aegean Numbers.
    | AncientGreekNumbers -- ^ @U+10140..U+1018F@: Ancient Greek Numbers.
    | AncientSymbols -- ^ @U+10190..U+101CF@: Ancient Symbols.
    | PhaistosDisc -- ^ @U+101D0..U+101FF@: Phaistos Disc.
    | Lycian -- ^ @U+10280..U+1029F@: Lycian.
    | Carian -- ^ @U+102A0..U+102DF@: Carian.
    | CopticEpactNumbers -- ^ @U+102E0..U+102FF@: Coptic Epact Numbers.
    | OldItalic -- ^ @U+10300..U+1032F@: Old Italic.
    | Gothic -- ^ @U+10330..U+1034F@: Gothic.
    | OldPermic -- ^ @U+10350..U+1037F@: Old Permic.
    | Ugaritic -- ^ @U+10380..U+1039F@: Ugaritic.
    | OldPersian -- ^ @U+103A0..U+103DF@: Old Persian.
    | Deseret -- ^ @U+10400..U+1044F@: Deseret.
    | Shavian -- ^ @U+10450..U+1047F@: Shavian.
    | Osmanya -- ^ @U+10480..U+104AF@: Osmanya.
    | Osage -- ^ @U+104B0..U+104FF@: Osage.
    | Elbasan -- ^ @U+10500..U+1052F@: Elbasan.
    | CaucasianAlbanian -- ^ @U+10530..U+1056F@: Caucasian Albanian.
    | Vithkuqi -- ^ @U+10570..U+105BF@: Vithkuqi.
    | LinearA -- ^ @U+10600..U+1077F@: Linear A.
    | LatinExtendedF -- ^ @U+10780..U+107BF@: Latin Extended-F.
    | CypriotSyllabary -- ^ @U+10800..U+1083F@: Cypriot Syllabary.
    | ImperialAramaic -- ^ @U+10840..U+1085F@: Imperial Aramaic.
    | Palmyrene -- ^ @U+10860..U+1087F@: Palmyrene.
    | Nabataean -- ^ @U+10880..U+108AF@: Nabataean.
    | Hatran -- ^ @U+108E0..U+108FF@: Hatran.
    | Phoenician -- ^ @U+10900..U+1091F@: Phoenician.
    | Lydian -- ^ @U+10920..U+1093F@: Lydian.
    | MeroiticHieroglyphs -- ^ @U+10980..U+1099F@: Meroitic Hieroglyphs.
    | MeroiticCursive -- ^ @U+109A0..U+109FF@: Meroitic Cursive.
    | Kharoshthi -- ^ @U+10A00..U+10A5F@: Kharoshthi.
    | OldSouthArabian -- ^ @U+10A60..U+10A7F@: Old South Arabian.
    | OldNorthArabian -- ^ @U+10A80..U+10A9F@: Old North Arabian.
    | Manichaean -- ^ @U+10AC0..U+10AFF@: Manichaean.
    | Avestan -- ^ @U+10B00..U+10B3F@: Avestan.
    | InscriptionalParthian -- ^ @U+10B40..U+10B5F@: Inscriptional Parthian.
    | InscriptionalPahlavi -- ^ @U+10B60..U+10B7F@: Inscriptional Pahlavi.
    | PsalterPahlavi -- ^ @U+10B80..U+10BAF@: Psalter Pahlavi.
    | OldTurkic -- ^ @U+10C00..U+10C4F@: Old Turkic.
    | OldHungarian -- ^ @U+10C80..U+10CFF@: Old Hungarian.
    | HanifiRohingya -- ^ @U+10D00..U+10D3F@: Hanifi Rohingya.
    | RumiNumeralSymbols -- ^ @U+10E60..U+10E7F@: Rumi Numeral Symbols.
    | Yezidi -- ^ @U+10E80..U+10EBF@: Yezidi.
    | ArabicExtendedC -- ^ @U+10EC0..U+10EFF@: Arabic Extended-C.
    | OldSogdian -- ^ @U+10F00..U+10F2F@: Old Sogdian.
    | Sogdian -- ^ @U+10F30..U+10F6F@: Sogdian.
    | OldUyghur -- ^ @U+10F70..U+10FAF@: Old Uyghur.
    | Chorasmian -- ^ @U+10FB0..U+10FDF@: Chorasmian.
    | Elymaic -- ^ @U+10FE0..U+10FFF@: Elymaic.
    | Brahmi -- ^ @U+11000..U+1107F@: Brahmi.
    | Kaithi -- ^ @U+11080..U+110CF@: Kaithi.
    | SoraSompeng -- ^ @U+110D0..U+110FF@: Sora Sompeng.
    | Chakma -- ^ @U+11100..U+1114F@: Chakma.
    | Mahajani -- ^ @U+11150..U+1117F@: Mahajani.
    | Sharada -- ^ @U+11180..U+111DF@: Sharada.
    | SinhalaArchaicNumbers -- ^ @U+111E0..U+111FF@: Sinhala Archaic Numbers.
    | Khojki -- ^ @U+11200..U+1124F@: Khojki.
    | Multani -- ^ @U+11280..U+112AF@: Multani.
    | Khudawadi -- ^ @U+112B0..U+112FF@: Khudawadi.
    | Grantha -- ^ @U+11300..U+1137F@: Grantha.
    | Newa -- ^ @U+11400..U+1147F@: Newa.
    | Tirhuta -- ^ @U+11480..U+114DF@: Tirhuta.
    | Siddham -- ^ @U+11580..U+115FF@: Siddham.
    | Modi -- ^ @U+11600..U+1165F@: Modi.
    | MongolianSupplement -- ^ @U+11660..U+1167F@: Mongolian Supplement.
    | Takri -- ^ @U+11680..U+116CF@: Takri.
    | Ahom -- ^ @U+11700..U+1174F@: Ahom.
    | Dogra -- ^ @U+11800..U+1184F@: Dogra.
    | WarangCiti -- ^ @U+118A0..U+118FF@: Warang Citi.
    | DivesAkuru -- ^ @U+11900..U+1195F@: Dives Akuru.
    | Nandinagari -- ^ @U+119A0..U+119FF@: Nandinagari.
    | ZanabazarSquare -- ^ @U+11A00..U+11A4F@: Zanabazar Square.
    | Soyombo -- ^ @U+11A50..U+11AAF@: Soyombo.
    | UnifiedCanadianAboriginalSyllabicsExtendedA -- ^ @U+11AB0..U+11ABF@: Unified Canadian Aboriginal Syllabics Extended-A.
    | PauCinHau -- ^ @U+11AC0..U+11AFF@: Pau Cin Hau.
    | DevanagariExtendedA -- ^ @U+11B00..U+11B5F@: Devanagari Extended-A.
    | Bhaiksuki -- ^ @U+11C00..U+11C6F@: Bhaiksuki.
    | Marchen -- ^ @U+11C70..U+11CBF@: Marchen.
    | MasaramGondi -- ^ @U+11D00..U+11D5F@: Masaram Gondi.
    | GunjalaGondi -- ^ @U+11D60..U+11DAF@: Gunjala Gondi.
    | Makasar -- ^ @U+11EE0..U+11EFF@: Makasar.
    | Kawi -- ^ @U+11F00..U+11F5F@: Kawi.
    | LisuSupplement -- ^ @U+11FB0..U+11FBF@: Lisu Supplement.
    | TamilSupplement -- ^ @U+11FC0..U+11FFF@: Tamil Supplement.
    | Cuneiform -- ^ @U+12000..U+123FF@: Cuneiform.
    | CuneiformNumbersAndPunctuation -- ^ @U+12400..U+1247F@: Cuneiform Numbers and Punctuation.
    | EarlyDynasticCuneiform -- ^ @U+12480..U+1254F@: Early Dynastic Cuneiform.
    | CyproMinoan -- ^ @U+12F90..U+12FFF@: Cypro-Minoan.
    | EgyptianHieroglyphs -- ^ @U+13000..U+1342F@: Egyptian Hieroglyphs.
    | EgyptianHieroglyphFormatControls -- ^ @U+13430..U+1345F@: Egyptian Hieroglyph Format Controls.
    | AnatolianHieroglyphs -- ^ @U+14400..U+1467F@: Anatolian Hieroglyphs.
    | BamumSupplement -- ^ @U+16800..U+16A3F@: Bamum Supplement.
    | Mro -- ^ @U+16A40..U+16A6F@: Mro.
    | Tangsa -- ^ @U+16A70..U+16ACF@: Tangsa.
    | BassaVah -- ^ @U+16AD0..U+16AFF@: Bassa Vah.
    | PahawhHmong -- ^ @U+16B00..U+16B8F@: Pahawh Hmong.
    | Medefaidrin -- ^ @U+16E40..U+16E9F@: Medefaidrin.
    | Miao -- ^ @U+16F00..U+16F9F@: Miao.
    | IdeographicSymbolsAndPunctuation -- ^ @U+16FE0..U+16FFF@: Ideographic Symbols and Punctuation.
    | Tangut -- ^ @U+17000..U+187FF@: Tangut.
    | TangutComponents -- ^ @U+18800..U+18AFF@: Tangut Components.
    | KhitanSmallScript -- ^ @U+18B00..U+18CFF@: Khitan Small Script.
    | TangutSupplement -- ^ @U+18D00..U+18D7F@: Tangut Supplement.
    | KanaExtendedB -- ^ @U+1AFF0..U+1AFFF@: Kana Extended-B.
    | KanaSupplement -- ^ @U+1B000..U+1B0FF@: Kana Supplement.
    | KanaExtendedA -- ^ @U+1B100..U+1B12F@: Kana Extended-A.
    | SmallKanaExtension -- ^ @U+1B130..U+1B16F@: Small Kana Extension.
    | Nushu -- ^ @U+1B170..U+1B2FF@: Nushu.
    | Duployan -- ^ @U+1BC00..U+1BC9F@: Duployan.
    | ShorthandFormatControls -- ^ @U+1BCA0..U+1BCAF@: Shorthand Format Controls.
    | ZnamennyMusicalNotation -- ^ @U+1CF00..U+1CFCF@: Znamenny Musical Notation.
    | ByzantineMusicalSymbols -- ^ @U+1D000..U+1D0FF@: Byzantine Musical Symbols.
    | MusicalSymbols -- ^ @U+1D100..U+1D1FF@: Musical Symbols.
    | AncientGreekMusicalNotation -- ^ @U+1D200..U+1D24F@: Ancient Greek Musical Notation.
    | KaktovikNumerals -- ^ @U+1D2C0..U+1D2DF@: Kaktovik Numerals.
    | MayanNumerals -- ^ @U+1D2E0..U+1D2FF@: Mayan Numerals.
    | TaiXuanJingSymbols -- ^ @U+1D300..U+1D35F@: Tai Xuan Jing Symbols.
    | CountingRodNumerals -- ^ @U+1D360..U+1D37F@: Counting Rod Numerals.
    | MathematicalAlphanumericSymbols -- ^ @U+1D400..U+1D7FF@: Mathematical Alphanumeric Symbols.
    | SuttonSignWriting -- ^ @U+1D800..U+1DAAF@: Sutton SignWriting.
    | LatinExtendedG -- ^ @U+1DF00..U+1DFFF@: Latin Extended-G.
    | GlagoliticSupplement -- ^ @U+1E000..U+1E02F@: Glagolitic Supplement.
    | CyrillicExtendedD -- ^ @U+1E030..U+1E08F@: Cyrillic Extended-D.
    | NyiakengPuachueHmong -- ^ @U+1E100..U+1E14F@: Nyiakeng Puachue Hmong.
    | Toto -- ^ @U+1E290..U+1E2BF@: Toto.
    | Wancho -- ^ @U+1E2C0..U+1E2FF@: Wancho.
    | NagMundari -- ^ @U+1E4D0..U+1E4FF@: Nag Mundari.
    | EthiopicExtendedB -- ^ @U+1E7E0..U+1E7FF@: Ethiopic Extended-B.
    | MendeKikakui -- ^ @U+1E800..U+1E8DF@: Mende Kikakui.
    | Adlam -- ^ @U+1E900..U+1E95F@: Adlam.
    | IndicSiyaqNumbers -- ^ @U+1EC70..U+1ECBF@: Indic Siyaq Numbers.
    | OttomanSiyaqNumbers -- ^ @U+1ED00..U+1ED4F@: Ottoman Siyaq Numbers.
    | ArabicMathematicalAlphabeticSymbols -- ^ @U+1EE00..U+1EEFF@: Arabic Mathematical Alphabetic Symbols.
    | MahjongTiles -- ^ @U+1F000..U+1F02F@: Mahjong Tiles.
    | DominoTiles -- ^ @U+1F030..U+1F09F@: Domino Tiles.
    | PlayingCards -- ^ @U+1F0A0..U+1F0FF@: Playing Cards.
    | EnclosedAlphanumericSupplement -- ^ @U+1F100..U+1F1FF@: Enclosed Alphanumeric Supplement.
    | EnclosedIdeographicSupplement -- ^ @U+1F200..U+1F2FF@: Enclosed Ideographic Supplement.
    | MiscellaneousSymbolsAndPictographs -- ^ @U+1F300..U+1F5FF@: Miscellaneous Symbols and Pictographs.
    | Emoticons -- ^ @U+1F600..U+1F64F@: Emoticons.
    | OrnamentalDingbats -- ^ @U+1F650..U+1F67F@: Ornamental Dingbats.
    | TransportAndMapSymbols -- ^ @U+1F680..U+1F6FF@: Transport and Map Symbols.
    | AlchemicalSymbols -- ^ @U+1F700..U+1F77F@: Alchemical Symbols.
    | GeometricShapesExtended -- ^ @U+1F780..U+1F7FF@: Geometric Shapes Extended.
    | SupplementalArrowsC -- ^ @U+1F800..U+1F8FF@: Supplemental Arrows-C.
    | SupplementalSymbolsAndPictographs -- ^ @U+1F900..U+1F9FF@: Supplemental Symbols and Pictographs.
    | ChessSymbols -- ^ @U+1FA00..U+1FA6F@: Chess Symbols.
    | SymbolsAndPictographsExtendedA -- ^ @U+1FA70..U+1FAFF@: Symbols and Pictographs Extended-A.
    | SymbolsForLegacyComputing -- ^ @U+1FB00..U+1FBFF@: Symbols for Legacy Computing.
    | CJKUnifiedIdeographsExtensionB -- ^ @U+20000..U+2A6DF@: CJK Unified Ideographs Extension B.
    | CJKUnifiedIdeographsExtensionC -- ^ @U+2A700..U+2B73F@: CJK Unified Ideographs Extension C.
    | CJKUnifiedIdeographsExtensionD -- ^ @U+2B740..U+2B81F@: CJK Unified Ideographs Extension D.
    | CJKUnifiedIdeographsExtensionE -- ^ @U+2B820..U+2CEAF@: CJK Unified Ideographs Extension E.
    | CJKUnifiedIdeographsExtensionF -- ^ @U+2CEB0..U+2EBEF@: CJK Unified Ideographs Extension F.
    | CJKCompatibilityIdeographsSupplement -- ^ @U+2F800..U+2FA1F@: CJK Compatibility Ideographs Supplement.
    | CJKUnifiedIdeographsExtensionG -- ^ @U+30000..U+3134F@: CJK Unified Ideographs Extension G.
    | CJKUnifiedIdeographsExtensionH -- ^ @U+31350..U+323AF@: CJK Unified Ideographs Extension H.
    | Tags -- ^ @U+E0000..U+E007F@: Tags.
    | VariationSelectorsSupplement -- ^ @U+E0100..U+E01EF@: Variation Selectors Supplement.
    | SupplementaryPrivateUseAreaA -- ^ @U+F0000..U+FFFFF@: Supplementary Private Use Area-A.
    | SupplementaryPrivateUseAreaB -- ^ @U+100000..U+10FFFF@: Supplementary Private Use Area-B.
    deriving (Enum, Bounded, Eq, Ord, Ix, Show)

-- | Block definition
--
-- Undefined for values greater than 326.
--
-- Returned value:
--
-- * Lower bound
-- * Upper bound
-- * Name (null terminated ASCII string)
--
-- @since 0.3.1
blockDefinition :: Int# -> (# Int#, Int#, Addr# #)
blockDefinition = \case
    0# -> (# 0x0000#, 0x007f#, "Basic Latin\0"# #)
    1# -> (# 0x0080#, 0x00ff#, "Latin-1 Supplement\0"# #)
    2# -> (# 0x0100#, 0x017f#, "Latin Extended-A\0"# #)
    3# -> (# 0x0180#, 0x024f#, "Latin Extended-B\0"# #)
    4# -> (# 0x0250#, 0x02af#, "IPA Extensions\0"# #)
    5# -> (# 0x02b0#, 0x02ff#, "Spacing Modifier Letters\0"# #)
    6# -> (# 0x0300#, 0x036f#, "Combining Diacritical Marks\0"# #)
    7# -> (# 0x0370#, 0x03ff#, "Greek and Coptic\0"# #)
    8# -> (# 0x0400#, 0x04ff#, "Cyrillic\0"# #)
    9# -> (# 0x0500#, 0x052f#, "Cyrillic Supplement\0"# #)
    10# -> (# 0x0530#, 0x058f#, "Armenian\0"# #)
    11# -> (# 0x0590#, 0x05ff#, "Hebrew\0"# #)
    12# -> (# 0x0600#, 0x06ff#, "Arabic\0"# #)
    13# -> (# 0x0700#, 0x074f#, "Syriac\0"# #)
    14# -> (# 0x0750#, 0x077f#, "Arabic Supplement\0"# #)
    15# -> (# 0x0780#, 0x07bf#, "Thaana\0"# #)
    16# -> (# 0x07c0#, 0x07ff#, "NKo\0"# #)
    17# -> (# 0x0800#, 0x083f#, "Samaritan\0"# #)
    18# -> (# 0x0840#, 0x085f#, "Mandaic\0"# #)
    19# -> (# 0x0860#, 0x086f#, "Syriac Supplement\0"# #)
    20# -> (# 0x0870#, 0x089f#, "Arabic Extended-B\0"# #)
    21# -> (# 0x08a0#, 0x08ff#, "Arabic Extended-A\0"# #)
    22# -> (# 0x0900#, 0x097f#, "Devanagari\0"# #)
    23# -> (# 0x0980#, 0x09ff#, "Bengali\0"# #)
    24# -> (# 0x0a00#, 0x0a7f#, "Gurmukhi\0"# #)
    25# -> (# 0x0a80#, 0x0aff#, "Gujarati\0"# #)
    26# -> (# 0x0b00#, 0x0b7f#, "Oriya\0"# #)
    27# -> (# 0x0b80#, 0x0bff#, "Tamil\0"# #)
    28# -> (# 0x0c00#, 0x0c7f#, "Telugu\0"# #)
    29# -> (# 0x0c80#, 0x0cff#, "Kannada\0"# #)
    30# -> (# 0x0d00#, 0x0d7f#, "Malayalam\0"# #)
    31# -> (# 0x0d80#, 0x0dff#, "Sinhala\0"# #)
    32# -> (# 0x0e00#, 0x0e7f#, "Thai\0"# #)
    33# -> (# 0x0e80#, 0x0eff#, "Lao\0"# #)
    34# -> (# 0x0f00#, 0x0fff#, "Tibetan\0"# #)
    35# -> (# 0x1000#, 0x109f#, "Myanmar\0"# #)
    36# -> (# 0x10a0#, 0x10ff#, "Georgian\0"# #)
    37# -> (# 0x1100#, 0x11ff#, "Hangul Jamo\0"# #)
    38# -> (# 0x1200#, 0x137f#, "Ethiopic\0"# #)
    39# -> (# 0x1380#, 0x139f#, "Ethiopic Supplement\0"# #)
    40# -> (# 0x13a0#, 0x13ff#, "Cherokee\0"# #)
    41# -> (# 0x1400#, 0x167f#, "Unified Canadian Aboriginal Syllabics\0"# #)
    42# -> (# 0x1680#, 0x169f#, "Ogham\0"# #)
    43# -> (# 0x16a0#, 0x16ff#, "Runic\0"# #)
    44# -> (# 0x1700#, 0x171f#, "Tagalog\0"# #)
    45# -> (# 0x1720#, 0x173f#, "Hanunoo\0"# #)
    46# -> (# 0x1740#, 0x175f#, "Buhid\0"# #)
    47# -> (# 0x1760#, 0x177f#, "Tagbanwa\0"# #)
    48# -> (# 0x1780#, 0x17ff#, "Khmer\0"# #)
    49# -> (# 0x1800#, 0x18af#, "Mongolian\0"# #)
    50# -> (# 0x18b0#, 0x18ff#, "Unified Canadian Aboriginal Syllabics Extended\0"# #)
    51# -> (# 0x1900#, 0x194f#, "Limbu\0"# #)
    52# -> (# 0x1950#, 0x197f#, "Tai Le\0"# #)
    53# -> (# 0x1980#, 0x19df#, "New Tai Lue\0"# #)
    54# -> (# 0x19e0#, 0x19ff#, "Khmer Symbols\0"# #)
    55# -> (# 0x1a00#, 0x1a1f#, "Buginese\0"# #)
    56# -> (# 0x1a20#, 0x1aaf#, "Tai Tham\0"# #)
    57# -> (# 0x1ab0#, 0x1aff#, "Combining Diacritical Marks Extended\0"# #)
    58# -> (# 0x1b00#, 0x1b7f#, "Balinese\0"# #)
    59# -> (# 0x1b80#, 0x1bbf#, "Sundanese\0"# #)
    60# -> (# 0x1bc0#, 0x1bff#, "Batak\0"# #)
    61# -> (# 0x1c00#, 0x1c4f#, "Lepcha\0"# #)
    62# -> (# 0x1c50#, 0x1c7f#, "Ol Chiki\0"# #)
    63# -> (# 0x1c80#, 0x1c8f#, "Cyrillic Extended-C\0"# #)
    64# -> (# 0x1c90#, 0x1cbf#, "Georgian Extended\0"# #)
    65# -> (# 0x1cc0#, 0x1ccf#, "Sundanese Supplement\0"# #)
    66# -> (# 0x1cd0#, 0x1cff#, "Vedic Extensions\0"# #)
    67# -> (# 0x1d00#, 0x1d7f#, "Phonetic Extensions\0"# #)
    68# -> (# 0x1d80#, 0x1dbf#, "Phonetic Extensions Supplement\0"# #)
    69# -> (# 0x1dc0#, 0x1dff#, "Combining Diacritical Marks Supplement\0"# #)
    70# -> (# 0x1e00#, 0x1eff#, "Latin Extended Additional\0"# #)
    71# -> (# 0x1f00#, 0x1fff#, "Greek Extended\0"# #)
    72# -> (# 0x2000#, 0x206f#, "General Punctuation\0"# #)
    73# -> (# 0x2070#, 0x209f#, "Superscripts and Subscripts\0"# #)
    74# -> (# 0x20a0#, 0x20cf#, "Currency Symbols\0"# #)
    75# -> (# 0x20d0#, 0x20ff#, "Combining Diacritical Marks for Symbols\0"# #)
    76# -> (# 0x2100#, 0x214f#, "Letterlike Symbols\0"# #)
    77# -> (# 0x2150#, 0x218f#, "Number Forms\0"# #)
    78# -> (# 0x2190#, 0x21ff#, "Arrows\0"# #)
    79# -> (# 0x2200#, 0x22ff#, "Mathematical Operators\0"# #)
    80# -> (# 0x2300#, 0x23ff#, "Miscellaneous Technical\0"# #)
    81# -> (# 0x2400#, 0x243f#, "Control Pictures\0"# #)
    82# -> (# 0x2440#, 0x245f#, "Optical Character Recognition\0"# #)
    83# -> (# 0x2460#, 0x24ff#, "Enclosed Alphanumerics\0"# #)
    84# -> (# 0x2500#, 0x257f#, "Box Drawing\0"# #)
    85# -> (# 0x2580#, 0x259f#, "Block Elements\0"# #)
    86# -> (# 0x25a0#, 0x25ff#, "Geometric Shapes\0"# #)
    87# -> (# 0x2600#, 0x26ff#, "Miscellaneous Symbols\0"# #)
    88# -> (# 0x2700#, 0x27bf#, "Dingbats\0"# #)
    89# -> (# 0x27c0#, 0x27ef#, "Miscellaneous Mathematical Symbols-A\0"# #)
    90# -> (# 0x27f0#, 0x27ff#, "Supplemental Arrows-A\0"# #)
    91# -> (# 0x2800#, 0x28ff#, "Braille Patterns\0"# #)
    92# -> (# 0x2900#, 0x297f#, "Supplemental Arrows-B\0"# #)
    93# -> (# 0x2980#, 0x29ff#, "Miscellaneous Mathematical Symbols-B\0"# #)
    94# -> (# 0x2a00#, 0x2aff#, "Supplemental Mathematical Operators\0"# #)
    95# -> (# 0x2b00#, 0x2bff#, "Miscellaneous Symbols and Arrows\0"# #)
    96# -> (# 0x2c00#, 0x2c5f#, "Glagolitic\0"# #)
    97# -> (# 0x2c60#, 0x2c7f#, "Latin Extended-C\0"# #)
    98# -> (# 0x2c80#, 0x2cff#, "Coptic\0"# #)
    99# -> (# 0x2d00#, 0x2d2f#, "Georgian Supplement\0"# #)
    100# -> (# 0x2d30#, 0x2d7f#, "Tifinagh\0"# #)
    101# -> (# 0x2d80#, 0x2ddf#, "Ethiopic Extended\0"# #)
    102# -> (# 0x2de0#, 0x2dff#, "Cyrillic Extended-A\0"# #)
    103# -> (# 0x2e00#, 0x2e7f#, "Supplemental Punctuation\0"# #)
    104# -> (# 0x2e80#, 0x2eff#, "CJK Radicals Supplement\0"# #)
    105# -> (# 0x2f00#, 0x2fdf#, "Kangxi Radicals\0"# #)
    106# -> (# 0x2ff0#, 0x2fff#, "Ideographic Description Characters\0"# #)
    107# -> (# 0x3000#, 0x303f#, "CJK Symbols and Punctuation\0"# #)
    108# -> (# 0x3040#, 0x309f#, "Hiragana\0"# #)
    109# -> (# 0x30a0#, 0x30ff#, "Katakana\0"# #)
    110# -> (# 0x3100#, 0x312f#, "Bopomofo\0"# #)
    111# -> (# 0x3130#, 0x318f#, "Hangul Compatibility Jamo\0"# #)
    112# -> (# 0x3190#, 0x319f#, "Kanbun\0"# #)
    113# -> (# 0x31a0#, 0x31bf#, "Bopomofo Extended\0"# #)
    114# -> (# 0x31c0#, 0x31ef#, "CJK Strokes\0"# #)
    115# -> (# 0x31f0#, 0x31ff#, "Katakana Phonetic Extensions\0"# #)
    116# -> (# 0x3200#, 0x32ff#, "Enclosed CJK Letters and Months\0"# #)
    117# -> (# 0x3300#, 0x33ff#, "CJK Compatibility\0"# #)
    118# -> (# 0x3400#, 0x4dbf#, "CJK Unified Ideographs Extension A\0"# #)
    119# -> (# 0x4dc0#, 0x4dff#, "Yijing Hexagram Symbols\0"# #)
    120# -> (# 0x4e00#, 0x9fff#, "CJK Unified Ideographs\0"# #)
    121# -> (# 0xa000#, 0xa48f#, "Yi Syllables\0"# #)
    122# -> (# 0xa490#, 0xa4cf#, "Yi Radicals\0"# #)
    123# -> (# 0xa4d0#, 0xa4ff#, "Lisu\0"# #)
    124# -> (# 0xa500#, 0xa63f#, "Vai\0"# #)
    125# -> (# 0xa640#, 0xa69f#, "Cyrillic Extended-B\0"# #)
    126# -> (# 0xa6a0#, 0xa6ff#, "Bamum\0"# #)
    127# -> (# 0xa700#, 0xa71f#, "Modifier Tone Letters\0"# #)
    128# -> (# 0xa720#, 0xa7ff#, "Latin Extended-D\0"# #)
    129# -> (# 0xa800#, 0xa82f#, "Syloti Nagri\0"# #)
    130# -> (# 0xa830#, 0xa83f#, "Common Indic Number Forms\0"# #)
    131# -> (# 0xa840#, 0xa87f#, "Phags-pa\0"# #)
    132# -> (# 0xa880#, 0xa8df#, "Saurashtra\0"# #)
    133# -> (# 0xa8e0#, 0xa8ff#, "Devanagari Extended\0"# #)
    134# -> (# 0xa900#, 0xa92f#, "Kayah Li\0"# #)
    135# -> (# 0xa930#, 0xa95f#, "Rejang\0"# #)
    136# -> (# 0xa960#, 0xa97f#, "Hangul Jamo Extended-A\0"# #)
    137# -> (# 0xa980#, 0xa9df#, "Javanese\0"# #)
    138# -> (# 0xa9e0#, 0xa9ff#, "Myanmar Extended-B\0"# #)
    139# -> (# 0xaa00#, 0xaa5f#, "Cham\0"# #)
    140# -> (# 0xaa60#, 0xaa7f#, "Myanmar Extended-A\0"# #)
    141# -> (# 0xaa80#, 0xaadf#, "Tai Viet\0"# #)
    142# -> (# 0xaae0#, 0xaaff#, "Meetei Mayek Extensions\0"# #)
    143# -> (# 0xab00#, 0xab2f#, "Ethiopic Extended-A\0"# #)
    144# -> (# 0xab30#, 0xab6f#, "Latin Extended-E\0"# #)
    145# -> (# 0xab70#, 0xabbf#, "Cherokee Supplement\0"# #)
    146# -> (# 0xabc0#, 0xabff#, "Meetei Mayek\0"# #)
    147# -> (# 0xac00#, 0xd7af#, "Hangul Syllables\0"# #)
    148# -> (# 0xd7b0#, 0xd7ff#, "Hangul Jamo Extended-B\0"# #)
    149# -> (# 0xd800#, 0xdb7f#, "High Surrogates\0"# #)
    150# -> (# 0xdb80#, 0xdbff#, "High Private Use Surrogates\0"# #)
    151# -> (# 0xdc00#, 0xdfff#, "Low Surrogates\0"# #)
    152# -> (# 0xe000#, 0xf8ff#, "Private Use Area\0"# #)
    153# -> (# 0xf900#, 0xfaff#, "CJK Compatibility Ideographs\0"# #)
    154# -> (# 0xfb00#, 0xfb4f#, "Alphabetic Presentation Forms\0"# #)
    155# -> (# 0xfb50#, 0xfdff#, "Arabic Presentation Forms-A\0"# #)
    156# -> (# 0xfe00#, 0xfe0f#, "Variation Selectors\0"# #)
    157# -> (# 0xfe10#, 0xfe1f#, "Vertical Forms\0"# #)
    158# -> (# 0xfe20#, 0xfe2f#, "Combining Half Marks\0"# #)
    159# -> (# 0xfe30#, 0xfe4f#, "CJK Compatibility Forms\0"# #)
    160# -> (# 0xfe50#, 0xfe6f#, "Small Form Variants\0"# #)
    161# -> (# 0xfe70#, 0xfeff#, "Arabic Presentation Forms-B\0"# #)
    162# -> (# 0xff00#, 0xffef#, "Halfwidth and Fullwidth Forms\0"# #)
    163# -> (# 0xfff0#, 0xffff#, "Specials\0"# #)
    164# -> (# 0x10000#, 0x1007f#, "Linear B Syllabary\0"# #)
    165# -> (# 0x10080#, 0x100ff#, "Linear B Ideograms\0"# #)
    166# -> (# 0x10100#, 0x1013f#, "Aegean Numbers\0"# #)
    167# -> (# 0x10140#, 0x1018f#, "Ancient Greek Numbers\0"# #)
    168# -> (# 0x10190#, 0x101cf#, "Ancient Symbols\0"# #)
    169# -> (# 0x101d0#, 0x101ff#, "Phaistos Disc\0"# #)
    170# -> (# 0x10280#, 0x1029f#, "Lycian\0"# #)
    171# -> (# 0x102a0#, 0x102df#, "Carian\0"# #)
    172# -> (# 0x102e0#, 0x102ff#, "Coptic Epact Numbers\0"# #)
    173# -> (# 0x10300#, 0x1032f#, "Old Italic\0"# #)
    174# -> (# 0x10330#, 0x1034f#, "Gothic\0"# #)
    175# -> (# 0x10350#, 0x1037f#, "Old Permic\0"# #)
    176# -> (# 0x10380#, 0x1039f#, "Ugaritic\0"# #)
    177# -> (# 0x103a0#, 0x103df#, "Old Persian\0"# #)
    178# -> (# 0x10400#, 0x1044f#, "Deseret\0"# #)
    179# -> (# 0x10450#, 0x1047f#, "Shavian\0"# #)
    180# -> (# 0x10480#, 0x104af#, "Osmanya\0"# #)
    181# -> (# 0x104b0#, 0x104ff#, "Osage\0"# #)
    182# -> (# 0x10500#, 0x1052f#, "Elbasan\0"# #)
    183# -> (# 0x10530#, 0x1056f#, "Caucasian Albanian\0"# #)
    184# -> (# 0x10570#, 0x105bf#, "Vithkuqi\0"# #)
    185# -> (# 0x10600#, 0x1077f#, "Linear A\0"# #)
    186# -> (# 0x10780#, 0x107bf#, "Latin Extended-F\0"# #)
    187# -> (# 0x10800#, 0x1083f#, "Cypriot Syllabary\0"# #)
    188# -> (# 0x10840#, 0x1085f#, "Imperial Aramaic\0"# #)
    189# -> (# 0x10860#, 0x1087f#, "Palmyrene\0"# #)
    190# -> (# 0x10880#, 0x108af#, "Nabataean\0"# #)
    191# -> (# 0x108e0#, 0x108ff#, "Hatran\0"# #)
    192# -> (# 0x10900#, 0x1091f#, "Phoenician\0"# #)
    193# -> (# 0x10920#, 0x1093f#, "Lydian\0"# #)
    194# -> (# 0x10980#, 0x1099f#, "Meroitic Hieroglyphs\0"# #)
    195# -> (# 0x109a0#, 0x109ff#, "Meroitic Cursive\0"# #)
    196# -> (# 0x10a00#, 0x10a5f#, "Kharoshthi\0"# #)
    197# -> (# 0x10a60#, 0x10a7f#, "Old South Arabian\0"# #)
    198# -> (# 0x10a80#, 0x10a9f#, "Old North Arabian\0"# #)
    199# -> (# 0x10ac0#, 0x10aff#, "Manichaean\0"# #)
    200# -> (# 0x10b00#, 0x10b3f#, "Avestan\0"# #)
    201# -> (# 0x10b40#, 0x10b5f#, "Inscriptional Parthian\0"# #)
    202# -> (# 0x10b60#, 0x10b7f#, "Inscriptional Pahlavi\0"# #)
    203# -> (# 0x10b80#, 0x10baf#, "Psalter Pahlavi\0"# #)
    204# -> (# 0x10c00#, 0x10c4f#, "Old Turkic\0"# #)
    205# -> (# 0x10c80#, 0x10cff#, "Old Hungarian\0"# #)
    206# -> (# 0x10d00#, 0x10d3f#, "Hanifi Rohingya\0"# #)
    207# -> (# 0x10e60#, 0x10e7f#, "Rumi Numeral Symbols\0"# #)
    208# -> (# 0x10e80#, 0x10ebf#, "Yezidi\0"# #)
    209# -> (# 0x10ec0#, 0x10eff#, "Arabic Extended-C\0"# #)
    210# -> (# 0x10f00#, 0x10f2f#, "Old Sogdian\0"# #)
    211# -> (# 0x10f30#, 0x10f6f#, "Sogdian\0"# #)
    212# -> (# 0x10f70#, 0x10faf#, "Old Uyghur\0"# #)
    213# -> (# 0x10fb0#, 0x10fdf#, "Chorasmian\0"# #)
    214# -> (# 0x10fe0#, 0x10fff#, "Elymaic\0"# #)
    215# -> (# 0x11000#, 0x1107f#, "Brahmi\0"# #)
    216# -> (# 0x11080#, 0x110cf#, "Kaithi\0"# #)
    217# -> (# 0x110d0#, 0x110ff#, "Sora Sompeng\0"# #)
    218# -> (# 0x11100#, 0x1114f#, "Chakma\0"# #)
    219# -> (# 0x11150#, 0x1117f#, "Mahajani\0"# #)
    220# -> (# 0x11180#, 0x111df#, "Sharada\0"# #)
    221# -> (# 0x111e0#, 0x111ff#, "Sinhala Archaic Numbers\0"# #)
    222# -> (# 0x11200#, 0x1124f#, "Khojki\0"# #)
    223# -> (# 0x11280#, 0x112af#, "Multani\0"# #)
    224# -> (# 0x112b0#, 0x112ff#, "Khudawadi\0"# #)
    225# -> (# 0x11300#, 0x1137f#, "Grantha\0"# #)
    226# -> (# 0x11400#, 0x1147f#, "Newa\0"# #)
    227# -> (# 0x11480#, 0x114df#, "Tirhuta\0"# #)
    228# -> (# 0x11580#, 0x115ff#, "Siddham\0"# #)
    229# -> (# 0x11600#, 0x1165f#, "Modi\0"# #)
    230# -> (# 0x11660#, 0x1167f#, "Mongolian Supplement\0"# #)
    231# -> (# 0x11680#, 0x116cf#, "Takri\0"# #)
    232# -> (# 0x11700#, 0x1174f#, "Ahom\0"# #)
    233# -> (# 0x11800#, 0x1184f#, "Dogra\0"# #)
    234# -> (# 0x118a0#, 0x118ff#, "Warang Citi\0"# #)
    235# -> (# 0x11900#, 0x1195f#, "Dives Akuru\0"# #)
    236# -> (# 0x119a0#, 0x119ff#, "Nandinagari\0"# #)
    237# -> (# 0x11a00#, 0x11a4f#, "Zanabazar Square\0"# #)
    238# -> (# 0x11a50#, 0x11aaf#, "Soyombo\0"# #)
    239# -> (# 0x11ab0#, 0x11abf#, "Unified Canadian Aboriginal Syllabics Extended-A\0"# #)
    240# -> (# 0x11ac0#, 0x11aff#, "Pau Cin Hau\0"# #)
    241# -> (# 0x11b00#, 0x11b5f#, "Devanagari Extended-A\0"# #)
    242# -> (# 0x11c00#, 0x11c6f#, "Bhaiksuki\0"# #)
    243# -> (# 0x11c70#, 0x11cbf#, "Marchen\0"# #)
    244# -> (# 0x11d00#, 0x11d5f#, "Masaram Gondi\0"# #)
    245# -> (# 0x11d60#, 0x11daf#, "Gunjala Gondi\0"# #)
    246# -> (# 0x11ee0#, 0x11eff#, "Makasar\0"# #)
    247# -> (# 0x11f00#, 0x11f5f#, "Kawi\0"# #)
    248# -> (# 0x11fb0#, 0x11fbf#, "Lisu Supplement\0"# #)
    249# -> (# 0x11fc0#, 0x11fff#, "Tamil Supplement\0"# #)
    250# -> (# 0x12000#, 0x123ff#, "Cuneiform\0"# #)
    251# -> (# 0x12400#, 0x1247f#, "Cuneiform Numbers and Punctuation\0"# #)
    252# -> (# 0x12480#, 0x1254f#, "Early Dynastic Cuneiform\0"# #)
    253# -> (# 0x12f90#, 0x12fff#, "Cypro-Minoan\0"# #)
    254# -> (# 0x13000#, 0x1342f#, "Egyptian Hieroglyphs\0"# #)
    255# -> (# 0x13430#, 0x1345f#, "Egyptian Hieroglyph Format Controls\0"# #)
    256# -> (# 0x14400#, 0x1467f#, "Anatolian Hieroglyphs\0"# #)
    257# -> (# 0x16800#, 0x16a3f#, "Bamum Supplement\0"# #)
    258# -> (# 0x16a40#, 0x16a6f#, "Mro\0"# #)
    259# -> (# 0x16a70#, 0x16acf#, "Tangsa\0"# #)
    260# -> (# 0x16ad0#, 0x16aff#, "Bassa Vah\0"# #)
    261# -> (# 0x16b00#, 0x16b8f#, "Pahawh Hmong\0"# #)
    262# -> (# 0x16e40#, 0x16e9f#, "Medefaidrin\0"# #)
    263# -> (# 0x16f00#, 0x16f9f#, "Miao\0"# #)
    264# -> (# 0x16fe0#, 0x16fff#, "Ideographic Symbols and Punctuation\0"# #)
    265# -> (# 0x17000#, 0x187ff#, "Tangut\0"# #)
    266# -> (# 0x18800#, 0x18aff#, "Tangut Components\0"# #)
    267# -> (# 0x18b00#, 0x18cff#, "Khitan Small Script\0"# #)
    268# -> (# 0x18d00#, 0x18d7f#, "Tangut Supplement\0"# #)
    269# -> (# 0x1aff0#, 0x1afff#, "Kana Extended-B\0"# #)
    270# -> (# 0x1b000#, 0x1b0ff#, "Kana Supplement\0"# #)
    271# -> (# 0x1b100#, 0x1b12f#, "Kana Extended-A\0"# #)
    272# -> (# 0x1b130#, 0x1b16f#, "Small Kana Extension\0"# #)
    273# -> (# 0x1b170#, 0x1b2ff#, "Nushu\0"# #)
    274# -> (# 0x1bc00#, 0x1bc9f#, "Duployan\0"# #)
    275# -> (# 0x1bca0#, 0x1bcaf#, "Shorthand Format Controls\0"# #)
    276# -> (# 0x1cf00#, 0x1cfcf#, "Znamenny Musical Notation\0"# #)
    277# -> (# 0x1d000#, 0x1d0ff#, "Byzantine Musical Symbols\0"# #)
    278# -> (# 0x1d100#, 0x1d1ff#, "Musical Symbols\0"# #)
    279# -> (# 0x1d200#, 0x1d24f#, "Ancient Greek Musical Notation\0"# #)
    280# -> (# 0x1d2c0#, 0x1d2df#, "Kaktovik Numerals\0"# #)
    281# -> (# 0x1d2e0#, 0x1d2ff#, "Mayan Numerals\0"# #)
    282# -> (# 0x1d300#, 0x1d35f#, "Tai Xuan Jing Symbols\0"# #)
    283# -> (# 0x1d360#, 0x1d37f#, "Counting Rod Numerals\0"# #)
    284# -> (# 0x1d400#, 0x1d7ff#, "Mathematical Alphanumeric Symbols\0"# #)
    285# -> (# 0x1d800#, 0x1daaf#, "Sutton SignWriting\0"# #)
    286# -> (# 0x1df00#, 0x1dfff#, "Latin Extended-G\0"# #)
    287# -> (# 0x1e000#, 0x1e02f#, "Glagolitic Supplement\0"# #)
    288# -> (# 0x1e030#, 0x1e08f#, "Cyrillic Extended-D\0"# #)
    289# -> (# 0x1e100#, 0x1e14f#, "Nyiakeng Puachue Hmong\0"# #)
    290# -> (# 0x1e290#, 0x1e2bf#, "Toto\0"# #)
    291# -> (# 0x1e2c0#, 0x1e2ff#, "Wancho\0"# #)
    292# -> (# 0x1e4d0#, 0x1e4ff#, "Nag Mundari\0"# #)
    293# -> (# 0x1e7e0#, 0x1e7ff#, "Ethiopic Extended-B\0"# #)
    294# -> (# 0x1e800#, 0x1e8df#, "Mende Kikakui\0"# #)
    295# -> (# 0x1e900#, 0x1e95f#, "Adlam\0"# #)
    296# -> (# 0x1ec70#, 0x1ecbf#, "Indic Siyaq Numbers\0"# #)
    297# -> (# 0x1ed00#, 0x1ed4f#, "Ottoman Siyaq Numbers\0"# #)
    298# -> (# 0x1ee00#, 0x1eeff#, "Arabic Mathematical Alphabetic Symbols\0"# #)
    299# -> (# 0x1f000#, 0x1f02f#, "Mahjong Tiles\0"# #)
    300# -> (# 0x1f030#, 0x1f09f#, "Domino Tiles\0"# #)
    301# -> (# 0x1f0a0#, 0x1f0ff#, "Playing Cards\0"# #)
    302# -> (# 0x1f100#, 0x1f1ff#, "Enclosed Alphanumeric Supplement\0"# #)
    303# -> (# 0x1f200#, 0x1f2ff#, "Enclosed Ideographic Supplement\0"# #)
    304# -> (# 0x1f300#, 0x1f5ff#, "Miscellaneous Symbols and Pictographs\0"# #)
    305# -> (# 0x1f600#, 0x1f64f#, "Emoticons\0"# #)
    306# -> (# 0x1f650#, 0x1f67f#, "Ornamental Dingbats\0"# #)
    307# -> (# 0x1f680#, 0x1f6ff#, "Transport and Map Symbols\0"# #)
    308# -> (# 0x1f700#, 0x1f77f#, "Alchemical Symbols\0"# #)
    309# -> (# 0x1f780#, 0x1f7ff#, "Geometric Shapes Extended\0"# #)
    310# -> (# 0x1f800#, 0x1f8ff#, "Supplemental Arrows-C\0"# #)
    311# -> (# 0x1f900#, 0x1f9ff#, "Supplemental Symbols and Pictographs\0"# #)
    312# -> (# 0x1fa00#, 0x1fa6f#, "Chess Symbols\0"# #)
    313# -> (# 0x1fa70#, 0x1faff#, "Symbols and Pictographs Extended-A\0"# #)
    314# -> (# 0x1fb00#, 0x1fbff#, "Symbols for Legacy Computing\0"# #)
    315# -> (# 0x20000#, 0x2a6df#, "CJK Unified Ideographs Extension B\0"# #)
    316# -> (# 0x2a700#, 0x2b73f#, "CJK Unified Ideographs Extension C\0"# #)
    317# -> (# 0x2b740#, 0x2b81f#, "CJK Unified Ideographs Extension D\0"# #)
    318# -> (# 0x2b820#, 0x2ceaf#, "CJK Unified Ideographs Extension E\0"# #)
    319# -> (# 0x2ceb0#, 0x2ebef#, "CJK Unified Ideographs Extension F\0"# #)
    320# -> (# 0x2f800#, 0x2fa1f#, "CJK Compatibility Ideographs Supplement\0"# #)
    321# -> (# 0x30000#, 0x3134f#, "CJK Unified Ideographs Extension G\0"# #)
    322# -> (# 0x31350#, 0x323af#, "CJK Unified Ideographs Extension H\0"# #)
    323# -> (# 0xe0000#, 0xe007f#, "Tags\0"# #)
    324# -> (# 0xe0100#, 0xe01ef#, "Variation Selectors Supplement\0"# #)
    325# -> (# 0xf0000#, 0xfffff#, "Supplementary Private Use Area-A\0"# #)
    _    -> (# 0x100000#, 0x10ffff#, "Supplementary Private Use Area-B\0"# #)

-- | Character block, if defined, else -1.
--
-- @since 0.3.1
block :: Char# -> Int#
block c# = getBlock 0# 326#
    where
    -- [NOTE] Encoding
    -- A range is encoded as two LE Word32:
    -- • First one is the lower bound, where the higher 11 bits are the block
    --   index and the lower 21 bits are the codepoint.
    -- • Second one is the upper bound, which correspond to the codepoint.

    cp# = int2Word# (ord# c#)

    -- Binary search
    getBlock l# u# = if isTrue# (l# ># u#)
        then -1#
        else
            let k# = l# +# uncheckedIShiftRL# (u# -# l#) 1#
                j# = k# `uncheckedIShiftL#` 1#
                cpL0# = getRawCodePoint# j#
                cpL# = cpL0# `and#` 0x1fffff## -- Mask for codepoint: [0..0x10fff]
                cpU# = getRawCodePoint# (j# +# 1#)
            in if isTrue# (cpU# `ltWord#` cp#)
                -- cp > upper bound
                then getBlock (k# +# 1#) u#
                -- check lower bound
                else if isTrue# (cp# `ltWord#` cpL#)
                    -- cp < lower bound
                    then getBlock l# (k# -# 1#)
                    -- cp in block: get block index
                    else let block# = cpL0# `uncheckedShiftRL#` 21#
                         in word2Int# block#

    getRawCodePoint# = lookupWord32# ranges#

    -- Encoded ranges
    !(Ptr ranges#) = rangesBitmap

rangesBitmap :: Ptr Word32
rangesBitmap = Ptr
    "\0\0\0\0\127\0\0\0\128\0\32\0\255\0\0\0\0\1\64\0\127\1\0\0\128\1\96\0\79\2\0\0\80\2\128\0\175\2\0\0\176\2\160\0\255\2\0\0\0\3\192\0\111\3\0\0\112\3\224\0\255\3\0\0\0\4\0\1\255\4\0\0\0\5\32\1\47\5\0\0\48\5\64\1\143\5\0\0\144\5\96\1\255\5\0\0\0\6\128\1\255\6\0\0\0\7\160\1\79\7\0\0\80\7\192\1\127\7\0\0\128\7\224\1\191\7\0\0\192\7\0\2\255\7\0\0\0\8\32\2\63\8\0\0\64\8\64\2\95\8\0\0\96\8\96\2\111\8\0\0\112\8\128\2\159\8\0\0\160\8\160\2\255\8\0\0\0\9\192\2\127\9\0\0\128\9\224\2\255\9\0\0\0\10\0\3\127\10\0\0\128\10\32\3\255\10\0\0\0\11\64\3\127\11\0\0\128\11\96\3\255\11\0\0\0\12\128\3\127\12\0\0\128\12\160\3\255\12\0\0\0\13\192\3\127\13\0\0\128\13\224\3\255\13\0\
    \\0\0\14\0\4\127\14\0\0\128\14\32\4\255\14\0\0\0\15\64\4\255\15\0\0\0\16\96\4\159\16\0\0\160\16\128\4\255\16\0\0\0\17\160\4\255\17\0\0\0\18\192\4\127\19\0\0\128\19\224\4\159\19\0\0\160\19\0\5\255\19\0\0\0\20\32\5\127\22\0\0\128\22\64\5\159\22\0\0\160\22\96\5\255\22\0\0\0\23\128\5\31\23\0\0\32\23\160\5\63\23\0\0\64\23\192\5\95\23\0\0\96\23\224\5\127\23\0\0\128\23\0\6\255\23\0\0\0\24\32\6\175\24\0\0\176\24\64\6\255\24\0\0\0\25\96\6\79\25\0\0\80\25\128\6\127\25\0\0\128\25\160\6\223\25\0\0\224\25\192\6\255\25\0\0\0\26\224\6\31\26\0\0\32\26\0\7\175\26\0\0\176\26\32\7\255\26\0\0\0\27\64\7\127\27\0\0\128\27\96\7\191\27\0\0\192\27\128\7\255\27\0\0\0\28\160\7\79\28\0\0\80\28\192\7\127\28\0\0\128\28\224\7\143\28\
    \\0\0\144\28\0\8\191\28\0\0\192\28\32\8\207\28\0\0\208\28\64\8\255\28\0\0\0\29\96\8\127\29\0\0\128\29\128\8\191\29\0\0\192\29\160\8\255\29\0\0\0\30\192\8\255\30\0\0\0\31\224\8\255\31\0\0\0\32\0\9\111\32\0\0\112\32\32\9\159\32\0\0\160\32\64\9\207\32\0\0\208\32\96\9\255\32\0\0\0\33\128\9\79\33\0\0\80\33\160\9\143\33\0\0\144\33\192\9\255\33\0\0\0\34\224\9\255\34\0\0\0\35\0\10\255\35\0\0\0\36\32\10\63\36\0\0\64\36\64\10\95\36\0\0\96\36\96\10\255\36\0\0\0\37\128\10\127\37\0\0\128\37\160\10\159\37\0\0\160\37\192\10\255\37\0\0\0\38\224\10\255\38\0\0\0\39\0\11\191\39\0\0\192\39\32\11\239\39\0\0\240\39\64\11\255\39\0\0\0\40\96\11\255\40\0\0\0\41\128\11\127\41\0\0\128\41\160\11\255\41\0\0\0\42\192\11\255\42\0\0\0\43\224\11\255\
    \\43\0\0\0\44\0\12\95\44\0\0\96\44\32\12\127\44\0\0\128\44\64\12\255\44\0\0\0\45\96\12\47\45\0\0\48\45\128\12\127\45\0\0\128\45\160\12\223\45\0\0\224\45\192\12\255\45\0\0\0\46\224\12\127\46\0\0\128\46\0\13\255\46\0\0\0\47\32\13\223\47\0\0\240\47\64\13\255\47\0\0\0\48\96\13\63\48\0\0\64\48\128\13\159\48\0\0\160\48\160\13\255\48\0\0\0\49\192\13\47\49\0\0\48\49\224\13\143\49\0\0\144\49\0\14\159\49\0\0\160\49\32\14\191\49\0\0\192\49\64\14\239\49\0\0\240\49\96\14\255\49\0\0\0\50\128\14\255\50\0\0\0\51\160\14\255\51\0\0\0\52\192\14\191\77\0\0\192\77\224\14\255\77\0\0\0\78\0\15\255\159\0\0\0\160\32\15\143\164\0\0\144\164\64\15\207\164\0\0\208\164\96\15\255\164\0\0\0\165\128\15\63\166\0\0\64\166\160\15\159\166\0\0\160\166\192\15\255\166\0\0\0\167\224\15\
    \\31\167\0\0\32\167\0\16\255\167\0\0\0\168\32\16\47\168\0\0\48\168\64\16\63\168\0\0\64\168\96\16\127\168\0\0\128\168\128\16\223\168\0\0\224\168\160\16\255\168\0\0\0\169\192\16\47\169\0\0\48\169\224\16\95\169\0\0\96\169\0\17\127\169\0\0\128\169\32\17\223\169\0\0\224\169\64\17\255\169\0\0\0\170\96\17\95\170\0\0\96\170\128\17\127\170\0\0\128\170\160\17\223\170\0\0\224\170\192\17\255\170\0\0\0\171\224\17\47\171\0\0\48\171\0\18\111\171\0\0\112\171\32\18\191\171\0\0\192\171\64\18\255\171\0\0\0\172\96\18\175\215\0\0\176\215\128\18\255\215\0\0\0\216\160\18\127\219\0\0\128\219\192\18\255\219\0\0\0\220\224\18\255\223\0\0\0\224\0\19\255\248\0\0\0\249\32\19\255\250\0\0\0\251\64\19\79\251\0\0\80\251\96\19\255\253\0\0\0\254\128\19\15\254\0\0\16\254\160\19\31\254\0\0\32\254\192\19\47\254\0\0\48\254\224\
    \\19\79\254\0\0\80\254\0\20\111\254\0\0\112\254\32\20\255\254\0\0\0\255\64\20\239\255\0\0\240\255\96\20\255\255\0\0\0\0\129\20\127\0\1\0\128\0\161\20\255\0\1\0\0\1\193\20\63\1\1\0\64\1\225\20\143\1\1\0\144\1\1\21\207\1\1\0\208\1\33\21\255\1\1\0\128\2\65\21\159\2\1\0\160\2\97\21\223\2\1\0\224\2\129\21\255\2\1\0\0\3\161\21\47\3\1\0\48\3\193\21\79\3\1\0\80\3\225\21\127\3\1\0\128\3\1\22\159\3\1\0\160\3\33\22\223\3\1\0\0\4\65\22\79\4\1\0\80\4\97\22\127\4\1\0\128\4\129\22\175\4\1\0\176\4\161\22\255\4\1\0\0\5\193\22\47\5\1\0\48\5\225\22\111\5\1\0\112\5\1\23\191\5\1\0\0\6\33\23\127\7\1\0\128\7\65\23\191\7\1\0\0\8\97\23\63\8\1\0\64\8\129\23\95\8\1\0\96\8\161\23\127\8\1\0\128\8\193\23\175\8\1\0\224\8\
    \\225\23\255\8\1\0\0\9\1\24\31\9\1\0\32\9\33\24\63\9\1\0\128\9\65\24\159\9\1\0\160\9\97\24\255\9\1\0\0\10\129\24\95\10\1\0\96\10\161\24\127\10\1\0\128\10\193\24\159\10\1\0\192\10\225\24\255\10\1\0\0\11\1\25\63\11\1\0\64\11\33\25\95\11\1\0\96\11\65\25\127\11\1\0\128\11\97\25\175\11\1\0\0\12\129\25\79\12\1\0\128\12\161\25\255\12\1\0\0\13\193\25\63\13\1\0\96\14\225\25\127\14\1\0\128\14\1\26\191\14\1\0\192\14\33\26\255\14\1\0\0\15\65\26\47\15\1\0\48\15\97\26\111\15\1\0\112\15\129\26\175\15\1\0\176\15\161\26\223\15\1\0\224\15\193\26\255\15\1\0\0\16\225\26\127\16\1\0\128\16\1\27\207\16\1\0\208\16\33\27\255\16\1\0\0\17\65\27\79\17\1\0\80\17\97\27\127\17\1\0\128\17\129\27\223\17\1\0\224\17\161\27\255\17\1\0\0\18\193\27\79\18\1\0\128\
    \\18\225\27\175\18\1\0\176\18\1\28\255\18\1\0\0\19\33\28\127\19\1\0\0\20\65\28\127\20\1\0\128\20\97\28\223\20\1\0\128\21\129\28\255\21\1\0\0\22\161\28\95\22\1\0\96\22\193\28\127\22\1\0\128\22\225\28\207\22\1\0\0\23\1\29\79\23\1\0\0\24\33\29\79\24\1\0\160\24\65\29\255\24\1\0\0\25\97\29\95\25\1\0\160\25\129\29\255\25\1\0\0\26\161\29\79\26\1\0\80\26\193\29\175\26\1\0\176\26\225\29\191\26\1\0\192\26\1\30\255\26\1\0\0\27\33\30\95\27\1\0\0\28\65\30\111\28\1\0\112\28\97\30\191\28\1\0\0\29\129\30\95\29\1\0\96\29\161\30\175\29\1\0\224\30\193\30\255\30\1\0\0\31\225\30\95\31\1\0\176\31\1\31\191\31\1\0\192\31\33\31\255\31\1\0\0\32\65\31\255\35\1\0\0\36\97\31\127\36\1\0\128\36\129\31\79\37\1\0\144\47\161\31\255\47\1\0\0\48\193\31\47\52\1\0\
    \\48\52\225\31\95\52\1\0\0\68\1\32\127\70\1\0\0\104\33\32\63\106\1\0\64\106\65\32\111\106\1\0\112\106\97\32\207\106\1\0\208\106\129\32\255\106\1\0\0\107\161\32\143\107\1\0\64\110\193\32\159\110\1\0\0\111\225\32\159\111\1\0\224\111\1\33\255\111\1\0\0\112\33\33\255\135\1\0\0\136\65\33\255\138\1\0\0\139\97\33\255\140\1\0\0\141\129\33\127\141\1\0\240\175\161\33\255\175\1\0\0\176\193\33\255\176\1\0\0\177\225\33\47\177\1\0\48\177\1\34\111\177\1\0\112\177\33\34\255\178\1\0\0\188\65\34\159\188\1\0\160\188\97\34\175\188\1\0\0\207\129\34\207\207\1\0\0\208\161\34\255\208\1\0\0\209\193\34\255\209\1\0\0\210\225\34\79\210\1\0\192\210\1\35\223\210\1\0\224\210\33\35\255\210\1\0\0\211\65\35\95\211\1\0\96\211\97\35\127\211\1\0\0\212\129\35\255\215\1\0\0\216\161\35\175\218\1\0\0\223\193\35\255\223\1\
    \\0\0\224\225\35\47\224\1\0\48\224\1\36\143\224\1\0\0\225\33\36\79\225\1\0\144\226\65\36\191\226\1\0\192\226\97\36\255\226\1\0\208\228\129\36\255\228\1\0\224\231\161\36\255\231\1\0\0\232\193\36\223\232\1\0\0\233\225\36\95\233\1\0\112\236\1\37\191\236\1\0\0\237\33\37\79\237\1\0\0\238\65\37\255\238\1\0\0\240\97\37\47\240\1\0\48\240\129\37\159\240\1\0\160\240\161\37\255\240\1\0\0\241\193\37\255\241\1\0\0\242\225\37\255\242\1\0\0\243\1\38\255\245\1\0\0\246\33\38\79\246\1\0\80\246\65\38\127\246\1\0\128\246\97\38\255\246\1\0\0\247\129\38\127\247\1\0\128\247\161\38\255\247\1\0\0\248\193\38\255\248\1\0\0\249\225\38\255\249\1\0\0\250\1\39\111\250\1\0\112\250\33\39\255\250\1\0\0\251\65\39\255\251\1\0\0\0\98\39\223\166\2\0\0\167\130\39\63\183\2\0\64\183\162\39\31\184\2\0\32\184\194\39\175\206\
    \\2\0\176\206\226\39\239\235\2\0\0\248\2\40\31\250\2\0\0\0\35\40\79\19\3\0\80\19\67\40\175\35\3\0\0\0\110\40\127\0\14\0\0\1\142\40\239\1\14\0\0\0\175\40\255\255\15\0\0\0\208\40\255\255\16\0"#
