{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Structs.FixedChild
    ( 

-- * Exported types
    FixedChild(..)                          ,
    newZeroFixedChild                       ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveFixedChildMethod                 ,
#endif



 -- * Properties


-- ** widget #attr:widget#
-- | /No description available in the introspection data./

    clearFixedChildWidget                   ,
#if defined(ENABLE_OVERLOADING)
    fixedChild_widget                       ,
#endif
    getFixedChildWidget                     ,
    setFixedChildWidget                     ,


-- ** x #attr:x#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    fixedChild_x                            ,
#endif
    getFixedChildX                          ,
    setFixedChildX                          ,


-- ** y #attr:y#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    fixedChild_y                            ,
#endif
    getFixedChildY                          ,
    setFixedChildY                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Atk.Interfaces.ImplementorIface as Atk.ImplementorIface
import qualified GI.Atk.Objects.Object as Atk.Object
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.MarkupParser as GLib.MarkupParser
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Enums as Gdk.Enums
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Screen as Gdk.Screen
import qualified GI.Gdk.Objects.Visual as Gdk.Visual
import qualified GI.Gdk.Objects.Window as Gdk.Window
import qualified GI.Gdk.Structs.Atom as Gdk.Atom
import qualified GI.Gdk.Structs.Color as Gdk.Color
import qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import qualified GI.Gdk.Structs.EventVisibility as Gdk.EventVisibility
import qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.AccelGroup as Gtk.AccelGroup
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.Bin as Gtk.Bin
import {-# SOURCE #-} qualified GI.Gtk.Objects.Builder as Gtk.Builder
import {-# SOURCE #-} qualified GI.Gtk.Objects.Clipboard as Gtk.Clipboard
import {-# SOURCE #-} qualified GI.Gtk.Objects.Container as Gtk.Container
import {-# SOURCE #-} qualified GI.Gtk.Objects.IconFactory as Gtk.IconFactory
import {-# SOURCE #-} qualified GI.Gtk.Objects.RcStyle as Gtk.RcStyle
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Style as Gtk.Style
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleProperties as Gtk.StyleProperties
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextBuffer as Gtk.TextBuffer
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextChildAnchor as Gtk.TextChildAnchor
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextMark as Gtk.TextMark
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTag as Gtk.TextTag
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTagTable as Gtk.TextTagTable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.AccelGroupEntry as Gtk.AccelGroupEntry
import {-# SOURCE #-} qualified GI.Gtk.Structs.AccelKey as Gtk.AccelKey
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.CssSection as Gtk.CssSection
import {-# SOURCE #-} qualified GI.Gtk.Structs.IconSet as Gtk.IconSet
import {-# SOURCE #-} qualified GI.Gtk.Structs.IconSource as Gtk.IconSource
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.SelectionData as Gtk.SelectionData
import {-# SOURCE #-} qualified GI.Gtk.Structs.SettingsValue as Gtk.SettingsValue
import {-# SOURCE #-} qualified GI.Gtk.Structs.SymbolicColor as Gtk.SymbolicColor
import {-# SOURCE #-} qualified GI.Gtk.Structs.TargetEntry as Gtk.TargetEntry
import {-# SOURCE #-} qualified GI.Gtk.Structs.TargetList as Gtk.TargetList
import {-# SOURCE #-} qualified GI.Gtk.Structs.TextAppearance as Gtk.TextAppearance
import {-# SOURCE #-} qualified GI.Gtk.Structs.TextAttributes as Gtk.TextAttributes
import {-# SOURCE #-} qualified GI.Gtk.Structs.TextIter as Gtk.TextIter
import {-# SOURCE #-} qualified GI.Gtk.Structs.WidgetPath as Gtk.WidgetPath
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import qualified GI.Pango.Structs.Language as Pango.Language
import qualified GI.Pango.Structs.TabArray as Pango.TabArray

#else
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype FixedChild = FixedChild (SP.ManagedPtr FixedChild)
    deriving (Eq)

instance SP.ManagedPtrNewtype FixedChild where
    toManagedPtr (FixedChild p) = p

instance BoxedPtr FixedChild where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr FixedChild)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr FixedChild where
    boxedPtrCalloc = callocBytes 16


-- | Construct a `FixedChild` struct initialized to zero.
newZeroFixedChild :: MonadIO m => m FixedChild
newZeroFixedChild = liftIO $ boxedPtrCalloc >>= wrapPtr FixedChild

instance tag ~ 'AttrSet => Constructible FixedChild tag where
    new _ attrs = do
        o <- newZeroFixedChild
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@widget@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fixedChild #widget
-- @
getFixedChildWidget :: MonadIO m => FixedChild -> m (Maybe Gtk.Widget.Widget)
getFixedChildWidget s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO (Ptr Gtk.Widget.Widget)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gtk.Widget.Widget) val'
        return val''
    return result

-- | Set the value of the “@widget@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fixedChild [ #widget 'Data.GI.Base.Attributes.:=' value ]
-- @
setFixedChildWidget :: MonadIO m => FixedChild -> Ptr Gtk.Widget.Widget -> m ()
setFixedChildWidget s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Ptr Gtk.Widget.Widget)

-- | Set the value of the “@widget@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #widget
-- @
clearFixedChildWidget :: MonadIO m => FixedChild -> m ()
clearFixedChildWidget s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: Ptr Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data FixedChildWidgetFieldInfo
instance AttrInfo FixedChildWidgetFieldInfo where
    type AttrBaseTypeConstraint FixedChildWidgetFieldInfo = (~) FixedChild
    type AttrAllowedOps FixedChildWidgetFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint FixedChildWidgetFieldInfo = (~) (Ptr Gtk.Widget.Widget)
    type AttrTransferTypeConstraint FixedChildWidgetFieldInfo = (~)(Ptr Gtk.Widget.Widget)
    type AttrTransferType FixedChildWidgetFieldInfo = (Ptr Gtk.Widget.Widget)
    type AttrGetType FixedChildWidgetFieldInfo = Maybe Gtk.Widget.Widget
    type AttrLabel FixedChildWidgetFieldInfo = "widget"
    type AttrOrigin FixedChildWidgetFieldInfo = FixedChild
    attrGet = getFixedChildWidget
    attrSet = setFixedChildWidget
    attrConstruct = undefined
    attrClear = clearFixedChildWidget
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.FixedChild.widget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Structs-FixedChild.html#g:attr:widget"
        })

fixedChild_widget :: AttrLabelProxy "widget"
fixedChild_widget = AttrLabelProxy

#endif


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fixedChild #x
-- @
getFixedChildX :: MonadIO m => FixedChild -> m Int32
getFixedChildX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fixedChild [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setFixedChildX :: MonadIO m => FixedChild -> Int32 -> m ()
setFixedChildX s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data FixedChildXFieldInfo
instance AttrInfo FixedChildXFieldInfo where
    type AttrBaseTypeConstraint FixedChildXFieldInfo = (~) FixedChild
    type AttrAllowedOps FixedChildXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FixedChildXFieldInfo = (~) Int32
    type AttrTransferTypeConstraint FixedChildXFieldInfo = (~)Int32
    type AttrTransferType FixedChildXFieldInfo = Int32
    type AttrGetType FixedChildXFieldInfo = Int32
    type AttrLabel FixedChildXFieldInfo = "x"
    type AttrOrigin FixedChildXFieldInfo = FixedChild
    attrGet = getFixedChildX
    attrSet = setFixedChildX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.FixedChild.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Structs-FixedChild.html#g:attr:x"
        })

fixedChild_x :: AttrLabelProxy "x"
fixedChild_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' fixedChild #y
-- @
getFixedChildY :: MonadIO m => FixedChild -> m Int32
getFixedChildY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Int32
    return val

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' fixedChild [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setFixedChildY :: MonadIO m => FixedChild -> Int32 -> m ()
setFixedChildY s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data FixedChildYFieldInfo
instance AttrInfo FixedChildYFieldInfo where
    type AttrBaseTypeConstraint FixedChildYFieldInfo = (~) FixedChild
    type AttrAllowedOps FixedChildYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FixedChildYFieldInfo = (~) Int32
    type AttrTransferTypeConstraint FixedChildYFieldInfo = (~)Int32
    type AttrTransferType FixedChildYFieldInfo = Int32
    type AttrGetType FixedChildYFieldInfo = Int32
    type AttrLabel FixedChildYFieldInfo = "y"
    type AttrOrigin FixedChildYFieldInfo = FixedChild
    attrGet = getFixedChildY
    attrSet = setFixedChildY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.FixedChild.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Structs-FixedChild.html#g:attr:y"
        })

fixedChild_y :: AttrLabelProxy "y"
fixedChild_y = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FixedChild
type instance O.AttributeList FixedChild = FixedChildAttributeList
type FixedChildAttributeList = ('[ '("widget", FixedChildWidgetFieldInfo), '("x", FixedChildXFieldInfo), '("y", FixedChildYFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFixedChildMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFixedChildMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFixedChildMethod t FixedChild, O.OverloadedMethod info FixedChild p) => OL.IsLabel t (FixedChild -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFixedChildMethod t FixedChild, O.OverloadedMethod info FixedChild p, R.HasField t FixedChild p) => R.HasField t FixedChild p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFixedChildMethod t FixedChild, O.OverloadedMethodInfo info FixedChild) => OL.IsLabel t (O.MethodProxy info FixedChild) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


