{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- t'GI.Gtk.Objects.IMContext.IMContext' defines the interface for GTK+ input methods. An input method
-- is used by GTK+ text input widgets like t'GI.Gtk.Objects.Entry.Entry' to map from key events to
-- Unicode character strings.
-- 
-- The default input method can be set programmatically via the
-- [Settings:gtkImModule]("GI.Gtk.Objects.Settings#g:attr:gtkImModule") GtkSettings property. Alternatively, you may set
-- the GTK_IM_MODULE environment variable as documented in
-- [Running GTK+ Applications][gtk-running].
-- 
-- The t'GI.Gtk.Objects.Entry.Entry' [Entry:imModule]("GI.Gtk.Objects.Entry#g:attr:imModule") and t'GI.Gtk.Objects.TextView.TextView' [TextView:imModule]("GI.Gtk.Objects.TextView#g:attr:imModule")
-- properties may also be used to set input methods for specific widget
-- instances. For instance, a certain entry widget might be expected to contain
-- certain characters which would be easier to input with a certain input
-- method.
-- 
-- An input method may consume multiple key events in sequence and finally
-- output the composed result. This is called preediting, and an input method
-- may provide feedback about this process by displaying the intermediate
-- composition states as preedit text. For instance, the default GTK+ input
-- method implements the input of arbitrary Unicode code points by holding down
-- the Control and Shift keys and then typing “U” followed by the hexadecimal
-- digits of the code point.  When releasing the Control and Shift keys,
-- preediting ends and the character is inserted as text. Ctrl+Shift+u20AC for
-- example results in the € sign.
-- 
-- Additional input methods can be made available for use by GTK+ widgets as
-- loadable modules. An input method module is a small shared library which
-- implements a subclass of t'GI.Gtk.Objects.IMContext.IMContext' or t'GI.Gtk.Objects.IMContextSimple.IMContextSimple' and exports
-- these four functions:
-- 
-- 
-- === /C code/
-- >
-- >void im_module_init(GTypeModule *module);
-- 
-- This function should register the t'GType' of the t'GI.Gtk.Objects.IMContext.IMContext' subclass which
-- implements the input method by means of 'GI.GObject.Objects.TypeModule.typeModuleRegisterType'. Note
-- that 'GI.GObject.Functions.typeRegisterStatic' cannot be used as the type needs to be
-- registered dynamically.
-- 
-- 
-- === /C code/
-- >
-- >void im_module_exit(void);
-- 
-- Here goes any cleanup code your input method might require on module unload.
-- 
-- 
-- === /C code/
-- >
-- >void im_module_list(const GtkIMContextInfo ***contexts, int *n_contexts)
-- >{
-- >  *contexts = info_list;
-- >  *n_contexts = G_N_ELEMENTS (info_list);
-- >}
-- 
-- This function returns the list of input methods provided by the module. The
-- example implementation above shows a common solution and simply returns a
-- pointer to statically defined array of t'GI.Gtk.Structs.IMContextInfo.IMContextInfo' items for each
-- provided input method.
-- 
-- 
-- === /C code/
-- >
-- >GtkIMContext * im_module_create(const gchar *context_id);
-- 
-- This function should return a pointer to a newly created instance of the
-- t'GI.Gtk.Objects.IMContext.IMContext' subclass identified by /@contextId@/. The context ID is the same
-- as specified in the t'GI.Gtk.Structs.IMContextInfo.IMContextInfo' array returned by @/im_module_list()/@.
-- 
-- After a new loadable input method module has been installed on the system,
-- the configuration file @gtk.immodules@ needs to be
-- regenerated by [gtk-query-immodules-3.0][gtk-query-immodules-3.0],
-- in order for the new input method to become available to GTK+ applications.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.IMContext
    ( 

-- * Exported types
    IMContext(..)                           ,
    IsIMContext                             ,
    toIMContext                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [deleteSurrounding]("GI.Gtk.Objects.IMContext#g:method:deleteSurrounding"), [filterKeypress]("GI.Gtk.Objects.IMContext#g:method:filterKeypress"), [focusIn]("GI.Gtk.Objects.IMContext#g:method:focusIn"), [focusOut]("GI.Gtk.Objects.IMContext#g:method:focusOut"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [reset]("GI.Gtk.Objects.IMContext#g:method:reset"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getPreeditString]("GI.Gtk.Objects.IMContext#g:method:getPreeditString"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurrounding]("GI.Gtk.Objects.IMContext#g:method:getSurrounding").
-- 
-- ==== Setters
-- [setClientWindow]("GI.Gtk.Objects.IMContext#g:method:setClientWindow"), [setCursorLocation]("GI.Gtk.Objects.IMContext#g:method:setCursorLocation"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSurrounding]("GI.Gtk.Objects.IMContext#g:method:setSurrounding"), [setUsePreedit]("GI.Gtk.Objects.IMContext#g:method:setUsePreedit").

#if defined(ENABLE_OVERLOADING)
    ResolveIMContextMethod                  ,
#endif

-- ** deleteSurrounding #method:deleteSurrounding#

#if defined(ENABLE_OVERLOADING)
    IMContextDeleteSurroundingMethodInfo    ,
#endif
    iMContextDeleteSurrounding              ,


-- ** filterKeypress #method:filterKeypress#

#if defined(ENABLE_OVERLOADING)
    IMContextFilterKeypressMethodInfo       ,
#endif
    iMContextFilterKeypress                 ,


-- ** focusIn #method:focusIn#

#if defined(ENABLE_OVERLOADING)
    IMContextFocusInMethodInfo              ,
#endif
    iMContextFocusIn                        ,


-- ** focusOut #method:focusOut#

#if defined(ENABLE_OVERLOADING)
    IMContextFocusOutMethodInfo             ,
#endif
    iMContextFocusOut                       ,


-- ** getPreeditString #method:getPreeditString#

#if defined(ENABLE_OVERLOADING)
    IMContextGetPreeditStringMethodInfo     ,
#endif
    iMContextGetPreeditString               ,


-- ** getSurrounding #method:getSurrounding#

#if defined(ENABLE_OVERLOADING)
    IMContextGetSurroundingMethodInfo       ,
#endif
    iMContextGetSurrounding                 ,


-- ** reset #method:reset#

#if defined(ENABLE_OVERLOADING)
    IMContextResetMethodInfo                ,
#endif
    iMContextReset                          ,


-- ** setClientWindow #method:setClientWindow#

#if defined(ENABLE_OVERLOADING)
    IMContextSetClientWindowMethodInfo      ,
#endif
    iMContextSetClientWindow                ,


-- ** setCursorLocation #method:setCursorLocation#

#if defined(ENABLE_OVERLOADING)
    IMContextSetCursorLocationMethodInfo    ,
#endif
    iMContextSetCursorLocation              ,


-- ** setSurrounding #method:setSurrounding#

#if defined(ENABLE_OVERLOADING)
    IMContextSetSurroundingMethodInfo       ,
#endif
    iMContextSetSurrounding                 ,


-- ** setUsePreedit #method:setUsePreedit#

#if defined(ENABLE_OVERLOADING)
    IMContextSetUsePreeditMethodInfo        ,
#endif
    iMContextSetUsePreedit                  ,




 -- * Properties


-- ** inputHints #attr:inputHints#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    IMContextInputHintsPropertyInfo         ,
#endif
    constructIMContextInputHints            ,
    getIMContextInputHints                  ,
#if defined(ENABLE_OVERLOADING)
    iMContextInputHints                     ,
#endif
    setIMContextInputHints                  ,


-- ** inputPurpose #attr:inputPurpose#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    IMContextInputPurposePropertyInfo       ,
#endif
    constructIMContextInputPurpose          ,
    getIMContextInputPurpose                ,
#if defined(ENABLE_OVERLOADING)
    iMContextInputPurpose                   ,
#endif
    setIMContextInputPurpose                ,




 -- * Signals


-- ** commit #signal:commit#

    IMContextCommitCallback                 ,
#if defined(ENABLE_OVERLOADING)
    IMContextCommitSignalInfo               ,
#endif
    afterIMContextCommit                    ,
    onIMContextCommit                       ,


-- ** deleteSurrounding #signal:deleteSurrounding#

    IMContextDeleteSurroundingCallback      ,
#if defined(ENABLE_OVERLOADING)
    IMContextDeleteSurroundingSignalInfo    ,
#endif
    afterIMContextDeleteSurrounding         ,
    onIMContextDeleteSurrounding            ,


-- ** preeditChanged #signal:preeditChanged#

    IMContextPreeditChangedCallback         ,
#if defined(ENABLE_OVERLOADING)
    IMContextPreeditChangedSignalInfo       ,
#endif
    afterIMContextPreeditChanged            ,
    onIMContextPreeditChanged               ,


-- ** preeditEnd #signal:preeditEnd#

    IMContextPreeditEndCallback             ,
#if defined(ENABLE_OVERLOADING)
    IMContextPreeditEndSignalInfo           ,
#endif
    afterIMContextPreeditEnd                ,
    onIMContextPreeditEnd                   ,


-- ** preeditStart #signal:preeditStart#

    IMContextPreeditStartCallback           ,
#if defined(ENABLE_OVERLOADING)
    IMContextPreeditStartSignalInfo         ,
#endif
    afterIMContextPreeditStart              ,
    onIMContextPreeditStart                 ,


-- ** retrieveSurrounding #signal:retrieveSurrounding#

    IMContextRetrieveSurroundingCallback    ,
#if defined(ENABLE_OVERLOADING)
    IMContextRetrieveSurroundingSignalInfo  ,
#endif
    afterIMContextRetrieveSurrounding       ,
    onIMContextRetrieveSurrounding          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Window as Gdk.Window
import qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import qualified GI.Pango.Structs.AttrList as Pango.AttrList

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Window as Gdk.Window
import qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import qualified GI.Pango.Structs.AttrList as Pango.AttrList

#endif

-- | Memory-managed wrapper type.
newtype IMContext = IMContext (SP.ManagedPtr IMContext)
    deriving (Eq)

instance SP.ManagedPtrNewtype IMContext where
    toManagedPtr (IMContext p) = p

foreign import ccall "gtk_im_context_get_type"
    c_gtk_im_context_get_type :: IO B.Types.GType

instance B.Types.TypedObject IMContext where
    glibType = c_gtk_im_context_get_type

instance B.Types.GObject IMContext

-- | Type class for types which can be safely cast to `IMContext`, for instance with `toIMContext`.
class (SP.GObject o, O.IsDescendantOf IMContext o) => IsIMContext o
instance (SP.GObject o, O.IsDescendantOf IMContext o) => IsIMContext o

instance O.HasParentTypes IMContext
type instance O.ParentTypes IMContext = '[GObject.Object.Object]

-- | Cast to `IMContext`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toIMContext :: (MIO.MonadIO m, IsIMContext o) => o -> m IMContext
toIMContext = MIO.liftIO . B.ManagedPtr.unsafeCastTo IMContext

-- | Convert 'IMContext' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe IMContext) where
    gvalueGType_ = c_gtk_im_context_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr IMContext)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr IMContext)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject IMContext ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveIMContextMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveIMContextMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveIMContextMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveIMContextMethod "deleteSurrounding" o = IMContextDeleteSurroundingMethodInfo
    ResolveIMContextMethod "filterKeypress" o = IMContextFilterKeypressMethodInfo
    ResolveIMContextMethod "focusIn" o = IMContextFocusInMethodInfo
    ResolveIMContextMethod "focusOut" o = IMContextFocusOutMethodInfo
    ResolveIMContextMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveIMContextMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveIMContextMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveIMContextMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveIMContextMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveIMContextMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveIMContextMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveIMContextMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveIMContextMethod "reset" o = IMContextResetMethodInfo
    ResolveIMContextMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveIMContextMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveIMContextMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveIMContextMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveIMContextMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveIMContextMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveIMContextMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveIMContextMethod "getPreeditString" o = IMContextGetPreeditStringMethodInfo
    ResolveIMContextMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveIMContextMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveIMContextMethod "getSurrounding" o = IMContextGetSurroundingMethodInfo
    ResolveIMContextMethod "setClientWindow" o = IMContextSetClientWindowMethodInfo
    ResolveIMContextMethod "setCursorLocation" o = IMContextSetCursorLocationMethodInfo
    ResolveIMContextMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveIMContextMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveIMContextMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveIMContextMethod "setSurrounding" o = IMContextSetSurroundingMethodInfo
    ResolveIMContextMethod "setUsePreedit" o = IMContextSetUsePreeditMethodInfo
    ResolveIMContextMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveIMContextMethod t IMContext, O.OverloadedMethod info IMContext p) => OL.IsLabel t (IMContext -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveIMContextMethod t IMContext, O.OverloadedMethod info IMContext p, R.HasField t IMContext p) => R.HasField t IMContext p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveIMContextMethod t IMContext, O.OverloadedMethodInfo info IMContext) => OL.IsLabel t (O.MethodProxy info IMContext) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal IMContext::commit
-- | The [commit](#g:signal:commit) signal is emitted when a complete input sequence
-- has been entered by the user. This can be a single character
-- immediately after a key press or the final result of preediting.
type IMContextCommitCallback =
    T.Text
    -- ^ /@str@/: the completed character(s) entered by the user
    -> IO ()

type C_IMContextCommitCallback =
    Ptr IMContext ->                        -- object
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_IMContextCommitCallback`.
foreign import ccall "wrapper"
    mk_IMContextCommitCallback :: C_IMContextCommitCallback -> IO (FunPtr C_IMContextCommitCallback)

wrap_IMContextCommitCallback :: 
    GObject a => (a -> IMContextCommitCallback) ->
    C_IMContextCommitCallback
wrap_IMContextCommitCallback gi'cb gi'selfPtr str _ = do
    str' <- cstringToText str
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  str'


-- | Connect a signal handler for the [commit](#signal:commit) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iMContext #commit callback
-- @
-- 
-- 
onIMContextCommit :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextCommitCallback) -> m SignalHandlerId
onIMContextCommit obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextCommitCallback wrapped
    wrapped'' <- mk_IMContextCommitCallback wrapped'
    connectSignalFunPtr obj "commit" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [commit](#signal:commit) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iMContext #commit callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIMContextCommit :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextCommitCallback) -> m SignalHandlerId
afterIMContextCommit obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextCommitCallback wrapped
    wrapped'' <- mk_IMContextCommitCallback wrapped'
    connectSignalFunPtr obj "commit" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IMContextCommitSignalInfo
instance SignalInfo IMContextCommitSignalInfo where
    type HaskellCallbackType IMContextCommitSignalInfo = IMContextCommitCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IMContextCommitCallback cb
        cb'' <- mk_IMContextCommitCallback cb'
        connectSignalFunPtr obj "commit" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext::commit"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#g:signal:commit"})

#endif

-- signal IMContext::delete-surrounding
-- | The [deleteSurrounding](#g:signal:deleteSurrounding) signal is emitted when the input method
-- needs to delete all or part of the context surrounding the cursor.
type IMContextDeleteSurroundingCallback =
    Int32
    -- ^ /@offset@/: the character offset from the cursor position of the text
    --           to be deleted. A negative value indicates a position before
    --           the cursor.
    -> Int32
    -- ^ /@nChars@/: the number of characters to be deleted
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the signal was handled.

type C_IMContextDeleteSurroundingCallback =
    Ptr IMContext ->                        -- object
    Int32 ->
    Int32 ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_IMContextDeleteSurroundingCallback`.
foreign import ccall "wrapper"
    mk_IMContextDeleteSurroundingCallback :: C_IMContextDeleteSurroundingCallback -> IO (FunPtr C_IMContextDeleteSurroundingCallback)

wrap_IMContextDeleteSurroundingCallback :: 
    GObject a => (a -> IMContextDeleteSurroundingCallback) ->
    C_IMContextDeleteSurroundingCallback
wrap_IMContextDeleteSurroundingCallback gi'cb gi'selfPtr offset nChars _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  offset nChars
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [deleteSurrounding](#signal:deleteSurrounding) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iMContext #deleteSurrounding callback
-- @
-- 
-- 
onIMContextDeleteSurrounding :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextDeleteSurroundingCallback) -> m SignalHandlerId
onIMContextDeleteSurrounding obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextDeleteSurroundingCallback wrapped
    wrapped'' <- mk_IMContextDeleteSurroundingCallback wrapped'
    connectSignalFunPtr obj "delete-surrounding" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [deleteSurrounding](#signal:deleteSurrounding) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iMContext #deleteSurrounding callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIMContextDeleteSurrounding :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextDeleteSurroundingCallback) -> m SignalHandlerId
afterIMContextDeleteSurrounding obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextDeleteSurroundingCallback wrapped
    wrapped'' <- mk_IMContextDeleteSurroundingCallback wrapped'
    connectSignalFunPtr obj "delete-surrounding" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IMContextDeleteSurroundingSignalInfo
instance SignalInfo IMContextDeleteSurroundingSignalInfo where
    type HaskellCallbackType IMContextDeleteSurroundingSignalInfo = IMContextDeleteSurroundingCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IMContextDeleteSurroundingCallback cb
        cb'' <- mk_IMContextDeleteSurroundingCallback cb'
        connectSignalFunPtr obj "delete-surrounding" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext::delete-surrounding"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#g:signal:deleteSurrounding"})

#endif

-- signal IMContext::preedit-changed
-- | The [preeditChanged](#g:signal:preeditChanged) signal is emitted whenever the preedit sequence
-- currently being entered has changed.  It is also emitted at the end of
-- a preedit sequence, in which case
-- 'GI.Gtk.Objects.IMContext.iMContextGetPreeditString' returns the empty string.
type IMContextPreeditChangedCallback =
    IO ()

type C_IMContextPreeditChangedCallback =
    Ptr IMContext ->                        -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_IMContextPreeditChangedCallback`.
foreign import ccall "wrapper"
    mk_IMContextPreeditChangedCallback :: C_IMContextPreeditChangedCallback -> IO (FunPtr C_IMContextPreeditChangedCallback)

wrap_IMContextPreeditChangedCallback :: 
    GObject a => (a -> IMContextPreeditChangedCallback) ->
    C_IMContextPreeditChangedCallback
wrap_IMContextPreeditChangedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [preeditChanged](#signal:preeditChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iMContext #preeditChanged callback
-- @
-- 
-- 
onIMContextPreeditChanged :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextPreeditChangedCallback) -> m SignalHandlerId
onIMContextPreeditChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextPreeditChangedCallback wrapped
    wrapped'' <- mk_IMContextPreeditChangedCallback wrapped'
    connectSignalFunPtr obj "preedit-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [preeditChanged](#signal:preeditChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iMContext #preeditChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIMContextPreeditChanged :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextPreeditChangedCallback) -> m SignalHandlerId
afterIMContextPreeditChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextPreeditChangedCallback wrapped
    wrapped'' <- mk_IMContextPreeditChangedCallback wrapped'
    connectSignalFunPtr obj "preedit-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IMContextPreeditChangedSignalInfo
instance SignalInfo IMContextPreeditChangedSignalInfo where
    type HaskellCallbackType IMContextPreeditChangedSignalInfo = IMContextPreeditChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IMContextPreeditChangedCallback cb
        cb'' <- mk_IMContextPreeditChangedCallback cb'
        connectSignalFunPtr obj "preedit-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext::preedit-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#g:signal:preeditChanged"})

#endif

-- signal IMContext::preedit-end
-- | The [preeditEnd](#g:signal:preeditEnd) signal is emitted when a preediting sequence
-- has been completed or canceled.
type IMContextPreeditEndCallback =
    IO ()

type C_IMContextPreeditEndCallback =
    Ptr IMContext ->                        -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_IMContextPreeditEndCallback`.
foreign import ccall "wrapper"
    mk_IMContextPreeditEndCallback :: C_IMContextPreeditEndCallback -> IO (FunPtr C_IMContextPreeditEndCallback)

wrap_IMContextPreeditEndCallback :: 
    GObject a => (a -> IMContextPreeditEndCallback) ->
    C_IMContextPreeditEndCallback
wrap_IMContextPreeditEndCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [preeditEnd](#signal:preeditEnd) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iMContext #preeditEnd callback
-- @
-- 
-- 
onIMContextPreeditEnd :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextPreeditEndCallback) -> m SignalHandlerId
onIMContextPreeditEnd obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextPreeditEndCallback wrapped
    wrapped'' <- mk_IMContextPreeditEndCallback wrapped'
    connectSignalFunPtr obj "preedit-end" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [preeditEnd](#signal:preeditEnd) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iMContext #preeditEnd callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIMContextPreeditEnd :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextPreeditEndCallback) -> m SignalHandlerId
afterIMContextPreeditEnd obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextPreeditEndCallback wrapped
    wrapped'' <- mk_IMContextPreeditEndCallback wrapped'
    connectSignalFunPtr obj "preedit-end" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IMContextPreeditEndSignalInfo
instance SignalInfo IMContextPreeditEndSignalInfo where
    type HaskellCallbackType IMContextPreeditEndSignalInfo = IMContextPreeditEndCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IMContextPreeditEndCallback cb
        cb'' <- mk_IMContextPreeditEndCallback cb'
        connectSignalFunPtr obj "preedit-end" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext::preedit-end"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#g:signal:preeditEnd"})

#endif

-- signal IMContext::preedit-start
-- | The [preeditStart](#g:signal:preeditStart) signal is emitted when a new preediting sequence
-- starts.
type IMContextPreeditStartCallback =
    IO ()

type C_IMContextPreeditStartCallback =
    Ptr IMContext ->                        -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_IMContextPreeditStartCallback`.
foreign import ccall "wrapper"
    mk_IMContextPreeditStartCallback :: C_IMContextPreeditStartCallback -> IO (FunPtr C_IMContextPreeditStartCallback)

wrap_IMContextPreeditStartCallback :: 
    GObject a => (a -> IMContextPreeditStartCallback) ->
    C_IMContextPreeditStartCallback
wrap_IMContextPreeditStartCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [preeditStart](#signal:preeditStart) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iMContext #preeditStart callback
-- @
-- 
-- 
onIMContextPreeditStart :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextPreeditStartCallback) -> m SignalHandlerId
onIMContextPreeditStart obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextPreeditStartCallback wrapped
    wrapped'' <- mk_IMContextPreeditStartCallback wrapped'
    connectSignalFunPtr obj "preedit-start" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [preeditStart](#signal:preeditStart) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iMContext #preeditStart callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIMContextPreeditStart :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextPreeditStartCallback) -> m SignalHandlerId
afterIMContextPreeditStart obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextPreeditStartCallback wrapped
    wrapped'' <- mk_IMContextPreeditStartCallback wrapped'
    connectSignalFunPtr obj "preedit-start" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IMContextPreeditStartSignalInfo
instance SignalInfo IMContextPreeditStartSignalInfo where
    type HaskellCallbackType IMContextPreeditStartSignalInfo = IMContextPreeditStartCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IMContextPreeditStartCallback cb
        cb'' <- mk_IMContextPreeditStartCallback cb'
        connectSignalFunPtr obj "preedit-start" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext::preedit-start"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#g:signal:preeditStart"})

#endif

-- signal IMContext::retrieve-surrounding
-- | The [retrieveSurrounding](#g:signal:retrieveSurrounding) signal is emitted when the input method
-- requires the context surrounding the cursor.  The callback should set
-- the input method surrounding context by calling the
-- 'GI.Gtk.Objects.IMContext.iMContextSetSurrounding' method.
type IMContextRetrieveSurroundingCallback =
    IO Bool
    -- ^ __Returns:__ 'P.True' if the signal was handled.

type C_IMContextRetrieveSurroundingCallback =
    Ptr IMContext ->                        -- object
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_IMContextRetrieveSurroundingCallback`.
foreign import ccall "wrapper"
    mk_IMContextRetrieveSurroundingCallback :: C_IMContextRetrieveSurroundingCallback -> IO (FunPtr C_IMContextRetrieveSurroundingCallback)

wrap_IMContextRetrieveSurroundingCallback :: 
    GObject a => (a -> IMContextRetrieveSurroundingCallback) ->
    C_IMContextRetrieveSurroundingCallback
wrap_IMContextRetrieveSurroundingCallback gi'cb gi'selfPtr _ = do
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [retrieveSurrounding](#signal:retrieveSurrounding) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' iMContext #retrieveSurrounding callback
-- @
-- 
-- 
onIMContextRetrieveSurrounding :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextRetrieveSurroundingCallback) -> m SignalHandlerId
onIMContextRetrieveSurrounding obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextRetrieveSurroundingCallback wrapped
    wrapped'' <- mk_IMContextRetrieveSurroundingCallback wrapped'
    connectSignalFunPtr obj "retrieve-surrounding" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [retrieveSurrounding](#signal:retrieveSurrounding) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' iMContext #retrieveSurrounding callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterIMContextRetrieveSurrounding :: (IsIMContext a, MonadIO m) => a -> ((?self :: a) => IMContextRetrieveSurroundingCallback) -> m SignalHandlerId
afterIMContextRetrieveSurrounding obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_IMContextRetrieveSurroundingCallback wrapped
    wrapped'' <- mk_IMContextRetrieveSurroundingCallback wrapped'
    connectSignalFunPtr obj "retrieve-surrounding" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data IMContextRetrieveSurroundingSignalInfo
instance SignalInfo IMContextRetrieveSurroundingSignalInfo where
    type HaskellCallbackType IMContextRetrieveSurroundingSignalInfo = IMContextRetrieveSurroundingCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_IMContextRetrieveSurroundingCallback cb
        cb'' <- mk_IMContextRetrieveSurroundingCallback cb'
        connectSignalFunPtr obj "retrieve-surrounding" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext::retrieve-surrounding"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#g:signal:retrieveSurrounding"})

#endif

-- VVV Prop "input-hints"
   -- Type: TInterface (Name {namespace = "Gtk", name = "InputHints"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@input-hints@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iMContext #inputHints
-- @
getIMContextInputHints :: (MonadIO m, IsIMContext o) => o -> m [Gtk.Flags.InputHints]
getIMContextInputHints obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "input-hints"

-- | Set the value of the “@input-hints@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iMContext [ #inputHints 'Data.GI.Base.Attributes.:=' value ]
-- @
setIMContextInputHints :: (MonadIO m, IsIMContext o) => o -> [Gtk.Flags.InputHints] -> m ()
setIMContextInputHints obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "input-hints" val

-- | Construct a `GValueConstruct` with valid value for the “@input-hints@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIMContextInputHints :: (IsIMContext o, MIO.MonadIO m) => [Gtk.Flags.InputHints] -> m (GValueConstruct o)
constructIMContextInputHints val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "input-hints" val

#if defined(ENABLE_OVERLOADING)
data IMContextInputHintsPropertyInfo
instance AttrInfo IMContextInputHintsPropertyInfo where
    type AttrAllowedOps IMContextInputHintsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint IMContextInputHintsPropertyInfo = IsIMContext
    type AttrSetTypeConstraint IMContextInputHintsPropertyInfo = (~) [Gtk.Flags.InputHints]
    type AttrTransferTypeConstraint IMContextInputHintsPropertyInfo = (~) [Gtk.Flags.InputHints]
    type AttrTransferType IMContextInputHintsPropertyInfo = [Gtk.Flags.InputHints]
    type AttrGetType IMContextInputHintsPropertyInfo = [Gtk.Flags.InputHints]
    type AttrLabel IMContextInputHintsPropertyInfo = "input-hints"
    type AttrOrigin IMContextInputHintsPropertyInfo = IMContext
    attrGet = getIMContextInputHints
    attrSet = setIMContextInputHints
    attrTransfer _ v = do
        return v
    attrConstruct = constructIMContextInputHints
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.inputHints"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#g:attr:inputHints"
        })
#endif

-- VVV Prop "input-purpose"
   -- Type: TInterface (Name {namespace = "Gtk", name = "InputPurpose"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@input-purpose@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' iMContext #inputPurpose
-- @
getIMContextInputPurpose :: (MonadIO m, IsIMContext o) => o -> m Gtk.Enums.InputPurpose
getIMContextInputPurpose obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "input-purpose"

-- | Set the value of the “@input-purpose@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' iMContext [ #inputPurpose 'Data.GI.Base.Attributes.:=' value ]
-- @
setIMContextInputPurpose :: (MonadIO m, IsIMContext o) => o -> Gtk.Enums.InputPurpose -> m ()
setIMContextInputPurpose obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "input-purpose" val

-- | Construct a `GValueConstruct` with valid value for the “@input-purpose@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructIMContextInputPurpose :: (IsIMContext o, MIO.MonadIO m) => Gtk.Enums.InputPurpose -> m (GValueConstruct o)
constructIMContextInputPurpose val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "input-purpose" val

#if defined(ENABLE_OVERLOADING)
data IMContextInputPurposePropertyInfo
instance AttrInfo IMContextInputPurposePropertyInfo where
    type AttrAllowedOps IMContextInputPurposePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint IMContextInputPurposePropertyInfo = IsIMContext
    type AttrSetTypeConstraint IMContextInputPurposePropertyInfo = (~) Gtk.Enums.InputPurpose
    type AttrTransferTypeConstraint IMContextInputPurposePropertyInfo = (~) Gtk.Enums.InputPurpose
    type AttrTransferType IMContextInputPurposePropertyInfo = Gtk.Enums.InputPurpose
    type AttrGetType IMContextInputPurposePropertyInfo = Gtk.Enums.InputPurpose
    type AttrLabel IMContextInputPurposePropertyInfo = "input-purpose"
    type AttrOrigin IMContextInputPurposePropertyInfo = IMContext
    attrGet = getIMContextInputPurpose
    attrSet = setIMContextInputPurpose
    attrTransfer _ v = do
        return v
    attrConstruct = constructIMContextInputPurpose
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.inputPurpose"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#g:attr:inputPurpose"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList IMContext
type instance O.AttributeList IMContext = IMContextAttributeList
type IMContextAttributeList = ('[ '("inputHints", IMContextInputHintsPropertyInfo), '("inputPurpose", IMContextInputPurposePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
iMContextInputHints :: AttrLabelProxy "inputHints"
iMContextInputHints = AttrLabelProxy

iMContextInputPurpose :: AttrLabelProxy "inputPurpose"
iMContextInputPurpose = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList IMContext = IMContextSignalList
type IMContextSignalList = ('[ '("commit", IMContextCommitSignalInfo), '("deleteSurrounding", IMContextDeleteSurroundingSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("preeditChanged", IMContextPreeditChangedSignalInfo), '("preeditEnd", IMContextPreeditEndSignalInfo), '("preeditStart", IMContextPreeditStartSignalInfo), '("retrieveSurrounding", IMContextRetrieveSurroundingSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method IMContext::delete_surrounding
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkIMContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "offset from cursor position in chars;\n   a negative value means start before the cursor."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_chars"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "number of characters to delete."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_delete_surrounding" gtk_im_context_delete_surrounding :: 
    Ptr IMContext ->                        -- context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    Int32 ->                                -- offset : TBasicType TInt
    Int32 ->                                -- n_chars : TBasicType TInt
    IO CInt

-- | Asks the widget that the input context is attached to to delete
-- characters around the cursor position by emitting the
-- GtkIMContext[delete_surrounding](#g:signal:delete_surrounding) signal. Note that /@offset@/ and /@nChars@/
-- are in characters not in bytes which differs from the usage other
-- places in t'GI.Gtk.Objects.IMContext.IMContext'.
-- 
-- In order to use this function, you should first call
-- 'GI.Gtk.Objects.IMContext.iMContextGetSurrounding' to get the current context, and
-- call this function immediately afterwards to make sure that you
-- know what you are deleting. You should also account for the fact
-- that even if the signal was handled, the input context might not
-- have deleted all the characters that were requested to be deleted.
-- 
-- This function is used by an input method that wants to make
-- subsitutions in the existing text in response to new input. It is
-- not useful for applications.
iMContextDeleteSurrounding ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gtk.Objects.IMContext.IMContext'
    -> Int32
    -- ^ /@offset@/: offset from cursor position in chars;
    --    a negative value means start before the cursor.
    -> Int32
    -- ^ /@nChars@/: number of characters to delete.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the signal was handled.
iMContextDeleteSurrounding context offset nChars = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    result <- gtk_im_context_delete_surrounding context' offset nChars
    let result' = (/= 0) result
    touchManagedPtr context
    return result'

#if defined(ENABLE_OVERLOADING)
data IMContextDeleteSurroundingMethodInfo
instance (signature ~ (Int32 -> Int32 -> m Bool), MonadIO m, IsIMContext a) => O.OverloadedMethod IMContextDeleteSurroundingMethodInfo a signature where
    overloadedMethod = iMContextDeleteSurrounding

instance O.OverloadedMethodInfo IMContextDeleteSurroundingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.iMContextDeleteSurrounding",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#v:iMContextDeleteSurrounding"
        })


#endif

-- method IMContext::filter_keypress
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkIMContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "EventKey" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_filter_keypress" gtk_im_context_filter_keypress :: 
    Ptr IMContext ->                        -- context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    Ptr Gdk.EventKey.EventKey ->            -- event : TInterface (Name {namespace = "Gdk", name = "EventKey"})
    IO CInt

-- | Allow an input method to internally handle key press and release
-- events. If this function returns 'P.True', then no further processing
-- should be done for this key event.
iMContextFilterKeypress ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gtk.Objects.IMContext.IMContext'
    -> Gdk.EventKey.EventKey
    -- ^ /@event@/: the key event
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the input method handled the key event.
iMContextFilterKeypress context event = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    event' <- unsafeManagedPtrGetPtr event
    result <- gtk_im_context_filter_keypress context' event'
    let result' = (/= 0) result
    touchManagedPtr context
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data IMContextFilterKeypressMethodInfo
instance (signature ~ (Gdk.EventKey.EventKey -> m Bool), MonadIO m, IsIMContext a) => O.OverloadedMethod IMContextFilterKeypressMethodInfo a signature where
    overloadedMethod = iMContextFilterKeypress

instance O.OverloadedMethodInfo IMContextFilterKeypressMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.iMContextFilterKeypress",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#v:iMContextFilterKeypress"
        })


#endif

-- method IMContext::focus_in
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkIMContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_focus_in" gtk_im_context_focus_in :: 
    Ptr IMContext ->                        -- context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    IO ()

-- | Notify the input method that the widget to which this
-- input context corresponds has gained focus. The input method
-- may, for example, change the displayed feedback to reflect
-- this change.
iMContextFocusIn ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gtk.Objects.IMContext.IMContext'
    -> m ()
iMContextFocusIn context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gtk_im_context_focus_in context'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data IMContextFocusInMethodInfo
instance (signature ~ (m ()), MonadIO m, IsIMContext a) => O.OverloadedMethod IMContextFocusInMethodInfo a signature where
    overloadedMethod = iMContextFocusIn

instance O.OverloadedMethodInfo IMContextFocusInMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.iMContextFocusIn",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#v:iMContextFocusIn"
        })


#endif

-- method IMContext::focus_out
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkIMContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_focus_out" gtk_im_context_focus_out :: 
    Ptr IMContext ->                        -- context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    IO ()

-- | Notify the input method that the widget to which this
-- input context corresponds has lost focus. The input method
-- may, for example, change the displayed feedback or reset the contexts
-- state to reflect this change.
iMContextFocusOut ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gtk.Objects.IMContext.IMContext'
    -> m ()
iMContextFocusOut context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gtk_im_context_focus_out context'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data IMContextFocusOutMethodInfo
instance (signature ~ (m ()), MonadIO m, IsIMContext a) => O.OverloadedMethod IMContextFocusOutMethodInfo a signature where
    overloadedMethod = iMContextFocusOut

instance O.OverloadedMethodInfo IMContextFocusOutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.iMContextFocusOut",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#v:iMContextFocusOut"
        })


#endif

-- method IMContext::get_preedit_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkIMContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the retrieved\n             string. The string retrieved must be freed with g_free()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "attrs"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "AttrList" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store the retrieved\n             attribute list.  When you are done with this list, you\n             must unreference it with pango_attr_list_unref()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "cursor_pos"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store position of cursor (in characters)\n             within the preedit string."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_get_preedit_string" gtk_im_context_get_preedit_string :: 
    Ptr IMContext ->                        -- context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    Ptr CString ->                          -- str : TBasicType TUTF8
    Ptr (Ptr Pango.AttrList.AttrList) ->    -- attrs : TInterface (Name {namespace = "Pango", name = "AttrList"})
    Ptr Int32 ->                            -- cursor_pos : TBasicType TInt
    IO ()

-- | Retrieve the current preedit string for the input context,
-- and a list of attributes to apply to the string.
-- This string should be displayed inserted at the insertion
-- point.
iMContextGetPreeditString ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gtk.Objects.IMContext.IMContext'
    -> m ((T.Text, Pango.AttrList.AttrList, Int32))
iMContextGetPreeditString context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    str <- callocMem :: IO (Ptr CString)
    attrs <- callocMem :: IO (Ptr (Ptr Pango.AttrList.AttrList))
    cursorPos <- allocMem :: IO (Ptr Int32)
    gtk_im_context_get_preedit_string context' str attrs cursorPos
    str' <- peek str
    str'' <- cstringToText str'
    freeMem str'
    attrs' <- peek attrs
    attrs'' <- (wrapBoxed Pango.AttrList.AttrList) attrs'
    cursorPos' <- peek cursorPos
    touchManagedPtr context
    freeMem str
    freeMem attrs
    freeMem cursorPos
    return (str'', attrs'', cursorPos')

#if defined(ENABLE_OVERLOADING)
data IMContextGetPreeditStringMethodInfo
instance (signature ~ (m ((T.Text, Pango.AttrList.AttrList, Int32))), MonadIO m, IsIMContext a) => O.OverloadedMethod IMContextGetPreeditStringMethodInfo a signature where
    overloadedMethod = iMContextGetPreeditString

instance O.OverloadedMethodInfo IMContextGetPreeditStringMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.iMContextGetPreeditString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#v:iMContextGetPreeditString"
        })


#endif

-- method IMContext::get_surrounding
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkIMContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store a UTF-8 encoded\n       string of text holding context around the insertion point.\n       If the function returns %TRUE, then you must free the result\n       stored in this location with g_free()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "cursor_index"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "location to store byte index of the insertion\n       cursor within @text."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_get_surrounding" gtk_im_context_get_surrounding :: 
    Ptr IMContext ->                        -- context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    Ptr CString ->                          -- text : TBasicType TUTF8
    Ptr Int32 ->                            -- cursor_index : TBasicType TInt
    IO CInt

-- | Retrieves context around the insertion point. Input methods
-- typically want context in order to constrain input text based on
-- existing text; this is important for languages such as Thai where
-- only some sequences of characters are allowed.
-- 
-- This function is implemented by emitting the
-- GtkIMContext[retrieve_surrounding](#g:signal:retrieve_surrounding) signal on the input method; in
-- response to this signal, a widget should provide as much context as
-- is available, up to an entire paragraph, by calling
-- 'GI.Gtk.Objects.IMContext.iMContextSetSurrounding'. Note that there is no obligation
-- for a widget to respond to the [retrieve_surrounding](#g:signal:retrieve_surrounding) signal, so input
-- methods must be prepared to function without context.
iMContextGetSurrounding ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gtk.Objects.IMContext.IMContext'
    -> m ((Bool, T.Text, Int32))
    -- ^ __Returns:__ 'P.True' if surrounding text was provided; in this case
    --    you must free the result stored in *text.
iMContextGetSurrounding context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    text <- callocMem :: IO (Ptr CString)
    cursorIndex <- allocMem :: IO (Ptr Int32)
    result <- gtk_im_context_get_surrounding context' text cursorIndex
    let result' = (/= 0) result
    text' <- peek text
    text'' <- cstringToText text'
    freeMem text'
    cursorIndex' <- peek cursorIndex
    touchManagedPtr context
    freeMem text
    freeMem cursorIndex
    return (result', text'', cursorIndex')

#if defined(ENABLE_OVERLOADING)
data IMContextGetSurroundingMethodInfo
instance (signature ~ (m ((Bool, T.Text, Int32))), MonadIO m, IsIMContext a) => O.OverloadedMethod IMContextGetSurroundingMethodInfo a signature where
    overloadedMethod = iMContextGetSurrounding

instance O.OverloadedMethodInfo IMContextGetSurroundingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.iMContextGetSurrounding",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#v:iMContextGetSurrounding"
        })


#endif

-- method IMContext::reset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkIMContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_reset" gtk_im_context_reset :: 
    Ptr IMContext ->                        -- context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    IO ()

-- | Notify the input method that a change such as a change in cursor
-- position has been made. This will typically cause the input
-- method to clear the preedit state.
iMContextReset ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gtk.Objects.IMContext.IMContext'
    -> m ()
iMContextReset context = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    gtk_im_context_reset context'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data IMContextResetMethodInfo
instance (signature ~ (m ()), MonadIO m, IsIMContext a) => O.OverloadedMethod IMContextResetMethodInfo a signature where
    overloadedMethod = iMContextReset

instance O.OverloadedMethodInfo IMContextResetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.iMContextReset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#v:iMContextReset"
        })


#endif

-- method IMContext::set_client_window
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkIMContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the client window. This may be %NULL to indicate\n          that the previous client window no longer exists."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_set_client_window" gtk_im_context_set_client_window :: 
    Ptr IMContext ->                        -- context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    Ptr Gdk.Window.Window ->                -- window : TInterface (Name {namespace = "Gdk", name = "Window"})
    IO ()

-- | Set the client window for the input context; this is the
-- t'GI.Gdk.Objects.Window.Window' in which the input appears. This window is
-- used in order to correctly position status windows, and may
-- also be used for purposes internal to the input method.
iMContextSetClientWindow ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContext a, Gdk.Window.IsWindow b) =>
    a
    -- ^ /@context@/: a t'GI.Gtk.Objects.IMContext.IMContext'
    -> Maybe (b)
    -- ^ /@window@/: the client window. This may be 'P.Nothing' to indicate
    --           that the previous client window no longer exists.
    -> m ()
iMContextSetClientWindow context window = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    maybeWindow <- case window of
        Nothing -> return FP.nullPtr
        Just jWindow -> do
            jWindow' <- unsafeManagedPtrCastPtr jWindow
            return jWindow'
    gtk_im_context_set_client_window context' maybeWindow
    touchManagedPtr context
    whenJust window touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data IMContextSetClientWindowMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsIMContext a, Gdk.Window.IsWindow b) => O.OverloadedMethod IMContextSetClientWindowMethodInfo a signature where
    overloadedMethod = iMContextSetClientWindow

instance O.OverloadedMethodInfo IMContextSetClientWindowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.iMContextSetClientWindow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#v:iMContextSetClientWindow"
        })


#endif

-- method IMContext::set_cursor_location
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkIMContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "area"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new location" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_set_cursor_location" gtk_im_context_set_cursor_location :: 
    Ptr IMContext ->                        -- context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    Ptr Gdk.Rectangle.Rectangle ->          -- area : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | Notify the input method that a change in cursor
-- position has been made. The location is relative to the client
-- window.
iMContextSetCursorLocation ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gtk.Objects.IMContext.IMContext'
    -> Gdk.Rectangle.Rectangle
    -- ^ /@area@/: new location
    -> m ()
iMContextSetCursorLocation context area = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    area' <- unsafeManagedPtrGetPtr area
    gtk_im_context_set_cursor_location context' area'
    touchManagedPtr context
    touchManagedPtr area
    return ()

#if defined(ENABLE_OVERLOADING)
data IMContextSetCursorLocationMethodInfo
instance (signature ~ (Gdk.Rectangle.Rectangle -> m ()), MonadIO m, IsIMContext a) => O.OverloadedMethod IMContextSetCursorLocationMethodInfo a signature where
    overloadedMethod = iMContextSetCursorLocation

instance O.OverloadedMethodInfo IMContextSetCursorLocationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.iMContextSetCursorLocation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#v:iMContextSetCursorLocation"
        })


#endif

-- method IMContext::set_surrounding
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkIMContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "text surrounding the insertion point, as UTF-8.\n       the preedit string should not be included within\n       @text."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "len"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the length of @text, or -1 if @text is nul-terminated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cursor_index"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the byte index of the insertion cursor within @text."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_set_surrounding" gtk_im_context_set_surrounding :: 
    Ptr IMContext ->                        -- context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    CString ->                              -- text : TBasicType TUTF8
    Int32 ->                                -- len : TBasicType TInt
    Int32 ->                                -- cursor_index : TBasicType TInt
    IO ()

-- | Sets surrounding context around the insertion point and preedit
-- string. This function is expected to be called in response to the
-- GtkIMContext[retrieve_surrounding](#g:signal:retrieve_surrounding) signal, and will likely have no
-- effect if called at other times.
iMContextSetSurrounding ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gtk.Objects.IMContext.IMContext'
    -> T.Text
    -- ^ /@text@/: text surrounding the insertion point, as UTF-8.
    --        the preedit string should not be included within
    --        /@text@/.
    -> Int32
    -- ^ /@len@/: the length of /@text@/, or -1 if /@text@/ is nul-terminated
    -> Int32
    -- ^ /@cursorIndex@/: the byte index of the insertion cursor within /@text@/.
    -> m ()
iMContextSetSurrounding context text len cursorIndex = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    text' <- textToCString text
    gtk_im_context_set_surrounding context' text' len cursorIndex
    touchManagedPtr context
    freeMem text'
    return ()

#if defined(ENABLE_OVERLOADING)
data IMContextSetSurroundingMethodInfo
instance (signature ~ (T.Text -> Int32 -> Int32 -> m ()), MonadIO m, IsIMContext a) => O.OverloadedMethod IMContextSetSurroundingMethodInfo a signature where
    overloadedMethod = iMContextSetSurrounding

instance O.OverloadedMethodInfo IMContextSetSurroundingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.iMContextSetSurrounding",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#v:iMContextSetSurrounding"
        })


#endif

-- method IMContext::set_use_preedit
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "context"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "IMContext" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GtkIMContext" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_preedit"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether the IM context should use the preedit string."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_im_context_set_use_preedit" gtk_im_context_set_use_preedit :: 
    Ptr IMContext ->                        -- context : TInterface (Name {namespace = "Gtk", name = "IMContext"})
    CInt ->                                 -- use_preedit : TBasicType TBoolean
    IO ()

-- | Sets whether the IM context should use the preedit string
-- to display feedback. If /@usePreedit@/ is FALSE (default
-- is TRUE), then the IM context may use some other method to display
-- feedback, such as displaying it in a child of the root window.
iMContextSetUsePreedit ::
    (B.CallStack.HasCallStack, MonadIO m, IsIMContext a) =>
    a
    -- ^ /@context@/: a t'GI.Gtk.Objects.IMContext.IMContext'
    -> Bool
    -- ^ /@usePreedit@/: whether the IM context should use the preedit string.
    -> m ()
iMContextSetUsePreedit context usePreedit = liftIO $ do
    context' <- unsafeManagedPtrCastPtr context
    let usePreedit' = (P.fromIntegral . P.fromEnum) usePreedit
    gtk_im_context_set_use_preedit context' usePreedit'
    touchManagedPtr context
    return ()

#if defined(ENABLE_OVERLOADING)
data IMContextSetUsePreeditMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsIMContext a) => O.OverloadedMethod IMContextSetUsePreeditMethodInfo a signature where
    overloadedMethod = iMContextSetUsePreedit

instance O.OverloadedMethodInfo IMContextSetUsePreeditMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.IMContext.iMContextSetUsePreedit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-3.0.39/docs/GI-Gtk-Objects-IMContext.html#v:iMContextSetUsePreedit"
        })


#endif


