{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Gtk.Config ( overrides ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "namespace Gtk"
 , ""
 , "C-docs-url Gtk https://developer.gnome.org/gtk3/stable"
 , ""
 , "# We do not generate wrappers for GtkTreeModelModifyFunc, since it has"
 , "# fairly weird semantics."
 , "ignore TreeModelFilter.set_modify_func"
 , ""
 , "# Signal with an (out) (caller-allocates) parameter, which we support"
 , "# without needing annotations."
 , "delete-attr Gtk/Overlay/get-child-position/@parameters/allocation direction"
 , "delete-attr Gtk/Overlay/get-child-position/@parameters/allocation caller-allocates"
 , ""
 , "# gtk_widget_path_iter_add_qclass isn't exported despite being present in Gtk-3.0.typelib"
 , "# upstream issue: https://bugzilla.gnome.org/show_bug.cgi?id=761339"
 , "ignore WidgetPath.iter_add_qclass"
 , ""
 , "# The pixbuf parameter can be null if the request failed."
 , "set-attr Gtk/ClipboardImageReceivedFunc/@parameters/pixbuf nullable 1"
 , ""
 , "# Wrong introspection annotation, leading to crashes. See"
 , "# https://bugzilla.gnome.org/show_bug.cgi?id=783381"
 , "# https://github.com/haskell-gi/haskell-gi/issues/104"
 , "set-attr Gtk/Builder/add_callback_symbol/@parameters/callback_symbol scope notified"
 , ""
 , "# The group parameter here is stolen, leading to crashes if we try to free it ourselves."
 , "set-attr Gtk/RadioButton/new/@parameters/group transfer-ownership container"
 , "set-attr Gtk/RadioButton/new_with_label/@parameters/group transfer-ownership container"
 , "set-attr Gtk/RadioButton/new_with_mnemonic/@parameters/group transfer-ownership container"
 , "set-attr Gtk/RadioButton/set_group/@parameters/group transfer-ownership container"
 , "set-attr Gtk/RadioMenuItem/new/@parameters/group transfer-ownership container"
 , "set-attr Gtk/RadioMenuItem/new_with_label/@parameters/group transfer-ownership container"
 , "set-attr Gtk/RadioMenuItem/new_with_mnemonic/@parameters/group transfer-ownership container"
 , "set-attr Gtk/RadioMenuItem/set_group/@parameters/group transfer-ownership container"
 , "set-attr Gtk/RadioToolButton/new/@parameters/group transfer-ownership container"
 , "set-attr Gtk/RadioMenuItem/new_from_stock/@parameters/group transfer-ownership container"
 , ""
 , "# It is useful to expose these class structs when deriving new types"
 , "set-attr Gtk/WidgetClass haskell-gi-force-visible 1"
 , "set-attr Gtk/ContainerClass haskell-gi-force-visible 1"
 , ""
 , "# Not properly annotated in older versions of gtk"
 , "set-attr Gtk/CellLayoutDataFunc/@parameters/data closure 4"
 , ""
 , "# Missing nullable return annotation, see"
 , "# https://github.com/haskell-gi/haskell-gi/issues/192"
 , "set-attr Gtk/TreePath/get_indices_with_depth/@return-value nullable 1"
 , ""
 , "# Wrong introspection annotation, see"
 , "# https://bugzilla.gnome.org/show_bug.cgi?id=693393"
 , "set-attr Gtk/PrintOperation/create-custom-widget/@return-value transfer-ownership full"
 , ""
 , "# This is nullable, but not marked as such, see"
 , "# https://github.com/haskell-gi/haskell-gi/issues/90"
 , "# https://bugzilla.gnome.org/show_bug.cgi?id=781246"
 , "set-attr Gtk/Widget/get_parent_window/@return-value nullable 1"
 , ""
 , "# Nullablereturn value, but not marked as such"
 , "set-attr Gtk/ComboBoxText/get_active_text/@return-value nullable 1"
 , ""
 , "# Wrong introspection data in old gtk versions, see"
 , "# https://bugzilla.gnome.org/show_bug.cgi?id=674537"
 , "set-attr Gtk/MenuPositionFunc/@parameters/x direction inout"
 , "set-attr Gtk/MenuPositionFunc/@parameters/y direction inout"
 , ""
 , "# Missing nullable annotations in the return values, see"
 , "# https://github.com/haskell-gi/haskell-gi/issues/95"
 , "# https://bugzilla.gnome.org/show_bug.cgi?id=781935"
 , "# https://bugzilla.gnome.org/show_bug.cgi?id=781936"
 , "set-attr Gtk/UIManager/get_widget/@return-value nullable 1"
 , "set-attr Gtk/UIManager/get_action/@return-value nullable 1"
 , "set-attr Gtk/ActionGroup/get_action/@return-value nullable 1"
 , "set-attr Gtk/TextMark/get_name/@return-value nullable 1"
 , "set-attr Gtk/Notebook/get_tab_label/@return-value nullable 1"
 , ""
 , "# Missing nullable annotation in the return value"
 , "# https://bugzilla.gnome.org/show_bug.cgi?id=785423"
 , "# https://github.com/haskell-gi/haskell-gi/issues/111"
 , "set-attr Gtk/Bin/get_child/@return-value nullable 1"
 , ""
 , "# Marked as gint, but really GdkEventMask."
 , "# https://github.com/haskell-gi/haskell-gi/issues/136"
 , "set-attr Gtk/Widget/add_events/@parameters/events/@type name Gdk.EventMask"
 , "set-attr Gtk/Widget/add_events/@parameters/events/@type c:type GdkEventMask"
 , "set-attr Gtk/Widget/set_events/@parameters/events/@type name Gdk.EventMask"
 , "set-attr Gtk/Widget/set_events/@parameters/events/@type c:type GdkEventMask"
 , ""
 , "# https://github.com/haskell-gi/haskell-gi/issues/138"
 , "# https://gitlab.gnome.org/GNOME/gtk/issues/84"
 , "set-attr Gtk/Widget/drag_dest_find_target/@return-value nullable 1"
 , ""
 , "# Missing nullable return annotation, see"
 , "# https://github.com/haskell-gi/haskell-gi/issues/176"
 , "set-attr Gtk/Application/get_active_window/@return-value nullable 1"
 , ""
 , "if osx"
 , "    # Not supported in Quartz version of Gtk"
 , "    ignore drag_set_icon_gicon"
 , "    ignore drag_get_icon_gicon"
 , "endif"
 , ""
 , "# Wrong introspection data, see https://github.com/haskell-gi/haskell-gi/issues/56"
 , "set-attr Gtk/Widget/intersect/@parameters/intersection direction out"
 , "set-attr Gtk/Widget/intersect/@parameters/intersection caller-allocates 1"
 , "set-attr Gtk/Widget/intersect/@parameters/intersection nullable 0"
 , ""
 , "# The return value can be null, but it is not marked as such in the"
 , "# introspection data, leading to a rather confusing error message:"
 , "# https://github.com/haskell-gi/haskell-gi/issues/142"
 , "# https://github.com/haskell-gi/haskell-gi/issues/143"
 , "set-attr Gtk/Application/new/@return-value nullable 1"
 , ""
 , "# https://github.com/haskell-gi/haskell-gi/issues/148"
 , "set-attr cairo/FontOptions glib:get-type cairo_gobject_font_options_get_type"
 , ""
 , "# Marked as gsize, which is unsigned, but the function accepts (-1)"
 , "set-attr Gtk/Builder/add_from_string/@parameters/length/@type name gssize"
 , ""
 , "# We know the type of these closures"
 , "set-attr Gtk/AccelGroup/connect/@parameters/closure/@type closure-type AccelGroupActivate"
 , ""
 , "# The sizes argument is an array of RequestedSize, not a pointer to a"
 , "# single one, and the function overwrites it."
 , "set-attr Gtk/distribute_natural_allocation/@parameters/sizes direction inout"
 , "set-attr Gtk/distribute_natural_allocation/@parameters/sizes caller-allocates 1"
 , "delete-node Gtk/distribute_natural_allocation/@parameters/sizes/@type"
 , "add-node Gtk/distribute_natural_allocation/@parameters/sizes array"
 , "add-node Gtk/distribute_natural_allocation/@parameters/sizes/@array type"
 , "set-attr Gtk/distribute_natural_allocation/@parameters/sizes/@array c:type GtkRequestedSize"
 , "set-attr Gtk/distribute_natural_allocation/@parameters/sizes/@array/@type name RequestedSize"
 , "set-attr Gtk/distribute_natural_allocation/@parameters/sizes/@array/@type name RequestedSize"
 , "set-attr Gtk/distribute_natural_allocation/@parameters/sizes/@array length 1"
 , "set-attr Gtk/distribute_natural_allocation/@parameters/sizes/@array zero-terminated 0"
 , "set-attr Gtk/distribute_natural_allocation/@parameters/sizes/@array/@type c:type GtkRequestedSize"
 , ""
 , "# Generated from gtk+ 3.22.11 with xsltproc Nullable.xslt Gtk-3.0.gir"
 , "set-attr Gtk/AboutDialog/set_comments/@parameters/comments nullable 1"
 , "set-attr Gtk/AboutDialog/set_copyright/@parameters/copyright nullable 1"
 , "set-attr Gtk/AboutDialog/set_license/@parameters/license nullable 1"
 , "set-attr Gtk/AboutDialog/set_logo/@parameters/logo nullable 1"
 , "set-attr Gtk/AboutDialog/set_logo_icon_name/@parameters/icon_name nullable 1"
 , "set-attr Gtk/AboutDialog/set_translator_credits/@parameters/translator_credits nullable 1"
 , "set-attr Gtk/AboutDialog/set_version/@parameters/version nullable 1"
 , "set-attr Gtk/AboutDialog/set_website/@parameters/website nullable 1"
 , "set-attr Gtk/AccelGroup/from_accel_closure/@return-value nullable 1"
 , "set-attr Gtk/AccelGroup/disconnect/@parameters/closure nullable 1"
 , "set-attr Gtk/AccelGroup/find/@parameters/data nullable 1"
 , "set-attr Gtk/AccelGroup/query/@return-value nullable 1"
 , "set-attr Gtk/AccelGroupFindFunc/@parameters/data nullable 1"
 , "set-attr Gtk/AccelLabel/get_accel_widget/@return-value nullable 1"
 , "set-attr Gtk/AccelMap/foreach/@parameters/data nullable 1"
 , "set-attr Gtk/AccelMap/foreach_unfiltered/@parameters/data nullable 1"
 , "set-attr Gtk/AccelMapForeach/@parameters/data nullable 1"
 , "set-attr Gtk/Accessible/get_widget/@return-value nullable 1"
 , "set-attr Gtk/Accessible/set_widget/@parameters/widget nullable 1"
 , "set-attr Gtk/Action/new/@parameters/label nullable 1"
 , "set-attr Gtk/Action/new/@parameters/tooltip nullable 1"
 , "set-attr Gtk/Action/new/@parameters/stock_id nullable 1"
 , "set-attr Gtk/Action/set_accel_group/@parameters/accel_group nullable 1"
 , "set-attr Gtk/ActionBar/get_center_widget/@return-value nullable 1"
 , "set-attr Gtk/ActionBar/set_center_widget/@parameters/center_widget nullable 1"
 , "set-attr Gtk/ActionGroup/add_action_with_accel/@parameters/accelerator nullable 1"
 , "set-attr Gtk/ActionGroup/add_actions/@parameters/user_data nullable 1"
 , "set-attr Gtk/ActionGroup/add_actions_full/@parameters/user_data nullable 1"
 , "set-attr Gtk/ActionGroup/add_actions_full/@parameters/destroy nullable 1"
 , "set-attr Gtk/ActionGroup/add_radio_actions/@parameters/user_data nullable 1"
 , "set-attr Gtk/ActionGroup/add_radio_actions_full/@parameters/user_data nullable 1"
 , "set-attr Gtk/ActionGroup/add_toggle_actions/@parameters/user_data nullable 1"
 , "set-attr Gtk/ActionGroup/add_toggle_actions_full/@parameters/user_data nullable 1"
 , "set-attr Gtk/ActionGroup/add_toggle_actions_full/@parameters/destroy nullable 1"
 , "set-attr Gtk/ActionGroup/set_accel_group/@parameters/accel_group nullable 1"
 , "set-attr Gtk/ActionGroup/set_translate_func/@parameters/data nullable 1"
 , "set-attr Gtk/ActionGroup/set_translation_domain/@parameters/domain nullable 1"
 , "set-attr Gtk/Actionable/get_action_name/@return-value nullable 1"
 , "set-attr Gtk/Actionable/set_action_name/@parameters/action_name nullable 1"
 , "set-attr Gtk/Actionable/get_action_name/@return-value nullable 1"
 , "set-attr Gtk/Actionable/set_action_name/@parameters/action_name nullable 1"
 , "set-attr Gtk/ActionableInterface/get_action_name/get_action_name/@return-value nullable 1"
 , "set-attr Gtk/ActionableInterface/set_action_name/set_action_name/@parameters/action_name nullable 1"
 , "set-attr Gtk/Activatable/sync_action_properties/@parameters/action nullable 1"
 , "set-attr Gtk/Activatable/sync_action_properties/@parameters/action nullable 1"
 , "set-attr Gtk/ActivatableIface/sync_action_properties/sync_action_properties/@parameters/action nullable 1"
 , "set-attr Gtk/AppChooser/get_app_info/@return-value nullable 1"
 , "set-attr Gtk/AppChooserButton/get_heading/@return-value nullable 1"
 , "set-attr Gtk/AppChooserDialog/new/@parameters/parent nullable 1"
 , "set-attr Gtk/AppChooserDialog/new_for_content_type/@parameters/parent nullable 1"
 , "set-attr Gtk/AppChooserDialog/get_heading/@return-value nullable 1"
 , "set-attr Gtk/Application/new/@parameters/application_id nullable 1"
 , "set-attr Gtk/Application/add_accelerator/@parameters/parameter nullable 1"
 , "set-attr Gtk/Application/get_app_menu/@return-value nullable 1"
 , "set-attr Gtk/Application/get_window_by_id/@return-value nullable 1"
 , "set-attr Gtk/Application/inhibit/@parameters/window nullable 1"
 , "set-attr Gtk/Application/inhibit/@parameters/reason nullable 1"
 , "set-attr Gtk/Application/remove_accelerator/@parameters/parameter nullable 1"
 , "set-attr Gtk/Application/set_app_menu/@parameters/app_menu nullable 1"
 , "set-attr Gtk/Application/set_menubar/@parameters/menubar nullable 1"
 , "set-attr Gtk/ApplicationWindow/get_help_overlay/@return-value nullable 1"
 , "set-attr Gtk/ApplicationWindow/set_help_overlay/@parameters/help_overlay nullable 1"
 , "set-attr Gtk/AspectFrame/new/@parameters/label nullable 1"
 , "set-attr Gtk/Assistant/get_nth_page/@return-value nullable 1"
 , "set-attr Gtk/Assistant/set_forward_page_func/@parameters/page_func nullable 1"
 , "set-attr Gtk/Assistant/set_forward_page_func/@parameters/data nullable 1"
 , "set-attr Gtk/Assistant/set_page_header_image/@parameters/pixbuf nullable 1"
 , "set-attr Gtk/Assistant/set_page_side_image/@parameters/pixbuf nullable 1"
 , "set-attr Gtk/AssistantPageFunc/@parameters/data nullable 1"
 , "set-attr Gtk/BindingSet/by_class/@parameters/object_class nullable 1"
 , "set-attr Gtk/BindingSet/find/@return-value nullable 1"
 , "set-attr Gtk/Box/get_center_widget/@return-value nullable 1"
 , "set-attr Gtk/Box/set_center_widget/@parameters/widget nullable 1"
 , "set-attr Gtk/Buildable/add_child/@parameters/type nullable 1"
 , "set-attr Gtk/Buildable/custom_finished/@parameters/child nullable 1"
 , "set-attr Gtk/Buildable/custom_finished/@parameters/data nullable 1"
 , "set-attr Gtk/Buildable/custom_tag_end/@parameters/child nullable 1"
 , "set-attr Gtk/Buildable/custom_tag_end/@parameters/data nullable 1"
 , "set-attr Gtk/Buildable/custom_tag_start/@parameters/child nullable 1"
 , "set-attr Gtk/Buildable/custom_tag_start/@parameters/data nullable 1"
 , "set-attr Gtk/Buildable/add_child/@parameters/type nullable 1"
 , "set-attr Gtk/Buildable/custom_finished/@parameters/child nullable 1"
 , "set-attr Gtk/Buildable/custom_finished/@parameters/data nullable 1"
 , "set-attr Gtk/Buildable/custom_tag_end/@parameters/child nullable 1"
 , "set-attr Gtk/Buildable/custom_tag_end/@parameters/data nullable 1"
 , "set-attr Gtk/Buildable/custom_tag_start/@parameters/child nullable 1"
 , "set-attr Gtk/Buildable/custom_tag_start/@parameters/data nullable 1"
 , "set-attr Gtk/BuildableIface/add_child/add_child/@parameters/type nullable 1"
 , "set-attr Gtk/BuildableIface/custom_tag_start/custom_tag_start/@parameters/child nullable 1"
 , "set-attr Gtk/BuildableIface/custom_tag_start/custom_tag_start/@parameters/data nullable 1"
 , "set-attr Gtk/BuildableIface/custom_tag_end/custom_tag_end/@parameters/child nullable 1"
 , "set-attr Gtk/BuildableIface/custom_tag_end/custom_tag_end/@parameters/data nullable 1"
 , "set-attr Gtk/BuildableIface/custom_finished/custom_finished/@parameters/child nullable 1"
 , "set-attr Gtk/BuildableIface/custom_finished/custom_finished/@parameters/data nullable 1"
 , "set-attr Gtk/Builder/connect_signals/@parameters/user_data nullable 1"
 , "set-attr Gtk/Builder/connect_signals_full/@parameters/user_data nullable 1"
 , "set-attr Gtk/Builder/get_application/@return-value nullable 1"
 , "set-attr Gtk/Builder/get_object/@return-value nullable 1"
 , "set-attr Gtk/Builder/lookup_callback_symbol/@return-value nullable 1"
 , "set-attr Gtk/Builder/set_translation_domain/@parameters/domain nullable 1"
 , "set-attr Gtk/BuilderConnectFunc/@parameters/connect_object nullable 1"
 , "set-attr Gtk/BuilderConnectFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/Button/new_from_icon_name/@parameters/icon_name nullable 1"
 , "set-attr Gtk/Button/get_image/@return-value nullable 1"
 , "set-attr Gtk/Button/set_image/@parameters/image nullable 1"
 , "set-attr Gtk/Calendar/set_detail_func/@parameters/data nullable 1"
 , "set-attr Gtk/CalendarDetailFunc/@return-value nullable 1"
 , "set-attr Gtk/CalendarDetailFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/Callback/@parameters/data nullable 1"
 , "set-attr Gtk/CellAllocCallback/@parameters/data nullable 1"
 , "set-attr Gtk/CellArea/foreach/@parameters/callback_data nullable 1"
 , "set-attr Gtk/CellArea/foreach_alloc/@parameters/callback_data nullable 1"
 , "set-attr Gtk/CellArea/foreach/@parameters/callback_data nullable 1"
 , "set-attr Gtk/CellArea/foreach_alloc/@parameters/callback_data nullable 1"
 , "set-attr Gtk/CellArea/get_focus_from_sibling/@return-value nullable 1"
 , "set-attr Gtk/CellAreaClass/foreach/foreach/@parameters/callback_data nullable 1"
 , "set-attr Gtk/CellAreaClass/foreach_alloc/foreach_alloc/@parameters/callback_data nullable 1"
 , "set-attr Gtk/CellCallback/@parameters/data nullable 1"
 , "set-attr Gtk/CellEditable/start_editing/@parameters/event nullable 1"
 , "set-attr Gtk/CellEditable/start_editing/@parameters/event nullable 1"
 , "set-attr Gtk/CellEditableIface/start_editing/start_editing/@parameters/event nullable 1"
 , "set-attr Gtk/CellLayout/get_area/@return-value nullable 1"
 , "set-attr Gtk/CellLayout/set_cell_data_func/@parameters/func nullable 1"
 , "set-attr Gtk/CellLayout/set_cell_data_func/@parameters/func_data nullable 1"
 , "set-attr Gtk/CellLayout/get_area/@return-value nullable 1"
 , "set-attr Gtk/CellLayout/set_cell_data_func/@parameters/func nullable 1"
 , "set-attr Gtk/CellLayout/set_cell_data_func/@parameters/func_data nullable 1"
 , "set-attr Gtk/CellLayoutDataFunc/@parameters/data nullable 1"
 , "set-attr Gtk/CellLayoutIface/set_cell_data_func/set_cell_data_func/@parameters/func nullable 1"
 , "set-attr Gtk/CellLayoutIface/set_cell_data_func/set_cell_data_func/@parameters/func_data nullable 1"
 , "set-attr Gtk/CellLayoutIface/get_area/get_area/@return-value nullable 1"
 , "set-attr Gtk/CellRenderer/get_size/@parameters/cell_area nullable 1"
 , "set-attr Gtk/CellRenderer/start_editing/@return-value nullable 1"
 , "set-attr Gtk/CellRenderer/start_editing/@parameters/event nullable 1"
 , "set-attr Gtk/CellRenderer/get_size/@parameters/cell_area nullable 1"
 , "set-attr Gtk/CellRenderer/get_state/@parameters/cell nullable 1"
 , "set-attr Gtk/CellRenderer/get_state/@parameters/widget nullable 1"
 , "set-attr Gtk/CellRenderer/start_editing/@return-value nullable 1"
 , "set-attr Gtk/CellRenderer/start_editing/@parameters/event nullable 1"
 , "set-attr Gtk/CellRendererClass/get_size/get_size/@parameters/cell_area nullable 1"
 , "set-attr Gtk/CellRendererClass/start_editing/start_editing/@return-value nullable 1"
 , "set-attr Gtk/CellRendererClass/start_editing/start_editing/@parameters/event nullable 1"
 , "set-attr Gtk/CellView/get_displayed_row/@return-value nullable 1"
 , "set-attr Gtk/CellView/get_model/@return-value nullable 1"
 , "set-attr Gtk/CellView/set_displayed_row/@parameters/path nullable 1"
 , "set-attr Gtk/CellView/set_model/@parameters/model nullable 1"
 , "set-attr Gtk/Clipboard/request_contents/@parameters/user_data nullable 1"
 , "set-attr Gtk/Clipboard/request_image/@parameters/user_data nullable 1"
 , "set-attr Gtk/Clipboard/request_rich_text/@parameters/user_data nullable 1"
 , "set-attr Gtk/Clipboard/request_targets/@parameters/user_data nullable 1"
 , "set-attr Gtk/Clipboard/request_text/@parameters/user_data nullable 1"
 , "set-attr Gtk/Clipboard/request_uris/@parameters/user_data nullable 1"
 , "set-attr Gtk/Clipboard/set_can_store/@parameters/targets nullable 1"
 , "set-attr Gtk/Clipboard/set_with_data/@parameters/user_data nullable 1"
 , "set-attr Gtk/Clipboard/wait_for_contents/@return-value nullable 1"
 , "set-attr Gtk/Clipboard/wait_for_image/@return-value nullable 1"
 , "set-attr Gtk/Clipboard/wait_for_rich_text/@return-value nullable 1"
 , "set-attr Gtk/Clipboard/wait_for_text/@return-value nullable 1"
 , "set-attr Gtk/Clipboard/wait_for_uris/@return-value nullable 1"
 , "set-attr Gtk/ClipboardClearFunc/@parameters/user_data_or_owner nullable 1"
 , "set-attr Gtk/ClipboardGetFunc/@parameters/user_data_or_owner nullable 1"
 , "set-attr Gtk/ClipboardImageReceivedFunc/@parameters/data nullable 1"
 , "set-attr Gtk/ClipboardReceivedFunc/@parameters/data nullable 1"
 , "set-attr Gtk/ClipboardRichTextReceivedFunc/@parameters/text nullable 1"
 , "set-attr Gtk/ClipboardRichTextReceivedFunc/@parameters/data nullable 1"
 , "set-attr Gtk/ClipboardTargetsReceivedFunc/@parameters/atoms nullable 1"
 , "set-attr Gtk/ClipboardTargetsReceivedFunc/@parameters/data nullable 1"
 , "set-attr Gtk/ClipboardTextReceivedFunc/@parameters/text nullable 1"
 , "set-attr Gtk/ClipboardTextReceivedFunc/@parameters/data nullable 1"
 , "set-attr Gtk/ClipboardURIReceivedFunc/@parameters/data nullable 1"
 , "set-attr Gtk/ColorChooser/add_palette/@parameters/colors nullable 1"
 , "set-attr Gtk/ColorChooser/add_palette/@parameters/colors nullable 1"
 , "set-attr Gtk/ColorChooserDialog/new/@parameters/title nullable 1"
 , "set-attr Gtk/ColorChooserDialog/new/@parameters/parent nullable 1"
 , "set-attr Gtk/ColorChooserInterface/add_palette/add_palette/@parameters/colors nullable 1"
 , "set-attr Gtk/ComboBox/get_active_id/@return-value nullable 1"
 , "set-attr Gtk/ComboBox/set_active_id/@parameters/active_id nullable 1"
 , "set-attr Gtk/ComboBox/set_active_iter/@parameters/iter nullable 1"
 , "set-attr Gtk/ComboBox/set_model/@parameters/model nullable 1"
 , "set-attr Gtk/ComboBox/set_row_separator_func/@parameters/data nullable 1"
 , "set-attr Gtk/ComboBox/set_row_separator_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/ComboBoxText/append/@parameters/id nullable 1"
 , "set-attr Gtk/ComboBoxText/insert/@parameters/id nullable 1"
 , "set-attr Gtk/ComboBoxText/prepend/@parameters/id nullable 1"
 , "set-attr Gtk/Container/forall/@parameters/callback_data nullable 1"
 , "set-attr Gtk/Container/set_focus_child/@parameters/child nullable 1"
 , "set-attr Gtk/Container/forall/@parameters/callback_data nullable 1"
 , "set-attr Gtk/Container/foreach/@parameters/callback_data nullable 1"
 , "set-attr Gtk/Container/get_focus_child/@return-value nullable 1"
 , "set-attr Gtk/Container/get_focus_hadjustment/@return-value nullable 1"
 , "set-attr Gtk/Container/get_focus_vadjustment/@return-value nullable 1"
 , "set-attr Gtk/Container/set_focus_child/@parameters/child nullable 1"
 , "set-attr Gtk/ContainerClass/forall/forall/@parameters/callback_data nullable 1"
 , "set-attr Gtk/ContainerClass/set_focus_child/set_focus_child/@parameters/child nullable 1"
 , "set-attr Gtk/ContainerClass/find_child_property/@return-value nullable 1"
 , "set-attr Gtk/CssProvider/get_named/@parameters/variant nullable 1"
 , "set-attr Gtk/CssSection/get_parent/@return-value nullable 1"
 , "set-attr Gtk/Dialog/new_with_buttons/@parameters/title nullable 1"
 , "set-attr Gtk/Dialog/new_with_buttons/@parameters/parent nullable 1"
 , "set-attr Gtk/Dialog/new_with_buttons/@parameters/first_button_text nullable 1"
 , "set-attr Gtk/Dialog/get_widget_for_response/@return-value nullable 1"
 , "set-attr Gtk/Entry/get_attributes/@return-value nullable 1"
 , "set-attr Gtk/Entry/get_cursor_hadjustment/@return-value nullable 1"
 , "set-attr Gtk/Entry/get_icon_gicon/@return-value nullable 1"
 , "set-attr Gtk/Entry/get_icon_name/@return-value nullable 1"
 , "set-attr Gtk/Entry/get_icon_pixbuf/@return-value nullable 1"
 , "set-attr Gtk/Entry/get_icon_tooltip_markup/@return-value nullable 1"
 , "set-attr Gtk/Entry/get_icon_tooltip_text/@return-value nullable 1"
 , "set-attr Gtk/Entry/get_inner_border/@return-value nullable 1"
 , "set-attr Gtk/Entry/get_tabs/@return-value nullable 1"
 , "set-attr Gtk/Entry/set_completion/@parameters/completion nullable 1"
 , "set-attr Gtk/Entry/set_cursor_hadjustment/@parameters/adjustment nullable 1"
 , "set-attr Gtk/Entry/set_icon_from_gicon/@parameters/icon nullable 1"
 , "set-attr Gtk/Entry/set_icon_from_icon_name/@parameters/icon_name nullable 1"
 , "set-attr Gtk/Entry/set_icon_from_pixbuf/@parameters/pixbuf nullable 1"
 , "set-attr Gtk/Entry/set_icon_from_stock/@parameters/stock_id nullable 1"
 , "set-attr Gtk/Entry/set_icon_tooltip_markup/@parameters/tooltip nullable 1"
 , "set-attr Gtk/Entry/set_icon_tooltip_text/@parameters/tooltip nullable 1"
 , "set-attr Gtk/Entry/set_inner_border/@parameters/border nullable 1"
 , "set-attr Gtk/Entry/set_placeholder_text/@parameters/text nullable 1"
 , "set-attr Gtk/EntryBuffer/new/@parameters/initial_chars nullable 1"
 , "set-attr Gtk/EntryCompletion/compute_prefix/@return-value nullable 1"
 , "set-attr Gtk/EntryCompletion/get_model/@return-value nullable 1"
 , "set-attr Gtk/EntryCompletion/set_match_func/@parameters/func_data nullable 1"
 , "set-attr Gtk/EntryCompletion/set_model/@parameters/model nullable 1"
 , "set-attr Gtk/EntryCompletionMatchFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/Expander/new_with_mnemonic/@parameters/label nullable 1"
 , "set-attr Gtk/Expander/get_label_widget/@return-value nullable 1"
 , "set-attr Gtk/Expander/set_label/@parameters/label nullable 1"
 , "set-attr Gtk/Expander/set_label_widget/@parameters/label_widget nullable 1"
 , "set-attr Gtk/FileChooser/get_current_folder/@return-value nullable 1"
 , "set-attr Gtk/FileChooser/get_current_folder_uri/@return-value nullable 1"
 , "set-attr Gtk/FileChooser/get_extra_widget/@return-value nullable 1"
 , "set-attr Gtk/FileChooser/get_filename/@return-value nullable 1"
 , "set-attr Gtk/FileChooser/get_filter/@return-value nullable 1"
 , "set-attr Gtk/FileChooser/get_preview_file/@return-value nullable 1"
 , "set-attr Gtk/FileChooser/get_preview_filename/@return-value nullable 1"
 , "set-attr Gtk/FileChooser/get_preview_uri/@return-value nullable 1"
 , "set-attr Gtk/FileChooser/get_preview_widget/@return-value nullable 1"
 , "set-attr Gtk/FileChooser/get_uri/@return-value nullable 1"
 , "set-attr Gtk/FileChooser/list_shortcut_folder_uris/@return-value nullable 1"
 , "set-attr Gtk/FileChooser/list_shortcut_folders/@return-value nullable 1"
 , "set-attr Gtk/FileChooserDialog/new/@parameters/title nullable 1"
 , "set-attr Gtk/FileChooserDialog/new/@parameters/parent nullable 1"
 , "set-attr Gtk/FileChooserDialog/new/@parameters/first_button_text nullable 1"
 , "set-attr Gtk/FileChooserNative/new/@parameters/title nullable 1"
 , "set-attr Gtk/FileChooserNative/new/@parameters/parent nullable 1"
 , "set-attr Gtk/FileChooserNative/new/@parameters/accept_label nullable 1"
 , "set-attr Gtk/FileChooserNative/new/@parameters/cancel_label nullable 1"
 , "set-attr Gtk/FileChooserNative/get_accept_label/@return-value nullable 1"
 , "set-attr Gtk/FileChooserNative/get_cancel_label/@return-value nullable 1"
 , "set-attr Gtk/FileChooserNative/set_accept_label/@parameters/accept_label nullable 1"
 , "set-attr Gtk/FileChooserNative/set_cancel_label/@parameters/cancel_label nullable 1"
 , "set-attr Gtk/FileFilter/add_custom/@parameters/data nullable 1"
 , "set-attr Gtk/FileFilter/get_name/@return-value nullable 1"
 , "set-attr Gtk/FileFilter/set_name/@parameters/name nullable 1"
 , "set-attr Gtk/FileFilterFunc/@parameters/data nullable 1"
 , "set-attr Gtk/FlowBox/bind_model/@parameters/model nullable 1"
 , "set-attr Gtk/FlowBox/bind_model/@parameters/user_data nullable 1"
 , "set-attr Gtk/FlowBox/get_child_at_index/@return-value nullable 1"
 , "set-attr Gtk/FlowBox/get_child_at_pos/@return-value nullable 1"
 , "set-attr Gtk/FlowBox/selected_foreach/@parameters/data nullable 1"
 , "set-attr Gtk/FlowBox/set_filter_func/@parameters/filter_func nullable 1"
 , "set-attr Gtk/FlowBox/set_filter_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/FlowBox/set_sort_func/@parameters/sort_func nullable 1"
 , "set-attr Gtk/FlowBox/set_sort_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/FlowBoxCreateWidgetFunc/@parameters/item nullable 1"
 , "set-attr Gtk/FlowBoxCreateWidgetFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/FlowBoxFilterFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/FlowBoxForeachFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/FlowBoxSortFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/FontChooser/get_font_face/@return-value nullable 1"
 , "set-attr Gtk/FontChooser/get_font_family/@return-value nullable 1"
 , "set-attr Gtk/FontChooser/get_font_map/@return-value nullable 1"
 , "set-attr Gtk/FontChooser/set_filter_func/@parameters/filter nullable 1"
 , "set-attr Gtk/FontChooser/set_filter_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/FontChooser/set_font_map/@parameters/fontmap nullable 1"
 , "set-attr Gtk/FontChooser/get_font/@return-value nullable 1"
 , "set-attr Gtk/FontChooser/get_font_desc/@return-value nullable 1"
 , "set-attr Gtk/FontChooser/get_font_face/@return-value nullable 1"
 , "set-attr Gtk/FontChooser/get_font_family/@return-value nullable 1"
 , "set-attr Gtk/FontChooser/get_font_map/@return-value nullable 1"
 , "set-attr Gtk/FontChooser/set_filter_func/@parameters/filter nullable 1"
 , "set-attr Gtk/FontChooser/set_filter_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/FontChooser/set_font_map/@parameters/fontmap nullable 1"
 , "set-attr Gtk/FontChooserDialog/new/@parameters/title nullable 1"
 , "set-attr Gtk/FontChooserDialog/new/@parameters/parent nullable 1"
 , "set-attr Gtk/FontChooserIface/get_font_family/get_font_family/@return-value nullable 1"
 , "set-attr Gtk/FontChooserIface/get_font_face/get_font_face/@return-value nullable 1"
 , "set-attr Gtk/FontChooserIface/set_filter_func/set_filter_func/@parameters/filter nullable 1"
 , "set-attr Gtk/FontChooserIface/set_filter_func/set_filter_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/FontChooserIface/set_font_map/set_font_map/@parameters/fontmap nullable 1"
 , "set-attr Gtk/FontChooserIface/get_font_map/get_font_map/@return-value nullable 1"
 , "set-attr Gtk/FontFilterFunc/@parameters/data nullable 1"
 , "set-attr Gtk/Frame/new/@parameters/label nullable 1"
 , "set-attr Gtk/Frame/get_label/@return-value nullable 1"
 , "set-attr Gtk/Frame/get_label_widget/@return-value nullable 1"
 , "set-attr Gtk/Frame/set_label/@parameters/label nullable 1"
 , "set-attr Gtk/Frame/set_label_widget/@parameters/label_widget nullable 1"
 , "set-attr Gtk/GLArea/get_error/@return-value nullable 1"
 , "set-attr Gtk/GLArea/set_error/@parameters/error nullable 1"
 , "set-attr Gtk/Gesture/get_device/@return-value nullable 1"
 , "set-attr Gtk/Gesture/get_last_event/@return-value nullable 1"
 , "set-attr Gtk/Gesture/get_last_updated_sequence/@return-value nullable 1"
 , "set-attr Gtk/Gesture/get_point/@parameters/sequence nullable 1"
 , "set-attr Gtk/Gesture/get_window/@return-value nullable 1"
 , "set-attr Gtk/Gesture/handles_sequence/@parameters/sequence nullable 1"
 , "set-attr Gtk/Gesture/set_window/@parameters/window nullable 1"
 , "set-attr Gtk/GestureDrag/get_offset/@parameters/x nullable 1"
 , "set-attr Gtk/GestureDrag/get_offset/@parameters/y nullable 1"
 , "set-attr Gtk/GestureDrag/get_start_point/@parameters/x nullable 1"
 , "set-attr Gtk/GestureDrag/get_start_point/@parameters/y nullable 1"
 , "set-attr Gtk/GestureMultiPress/set_area/@parameters/rect nullable 1"
 , "set-attr Gtk/GestureSingle/get_current_sequence/@return-value nullable 1"
 , "set-attr Gtk/Grid/attach_next_to/@parameters/sibling nullable 1"
 , "set-attr Gtk/Grid/get_child_at/@return-value nullable 1"
 , "set-attr Gtk/HScale/new/@parameters/adjustment nullable 1"
 , "set-attr Gtk/HScrollbar/new/@parameters/adjustment nullable 1"
 , "set-attr Gtk/HeaderBar/get_custom_title/@return-value nullable 1"
 , "set-attr Gtk/HeaderBar/get_subtitle/@return-value nullable 1"
 , "set-attr Gtk/HeaderBar/get_title/@return-value nullable 1"
 , "set-attr Gtk/HeaderBar/set_custom_title/@parameters/title_widget nullable 1"
 , "set-attr Gtk/HeaderBar/set_decoration_layout/@parameters/layout nullable 1"
 , "set-attr Gtk/HeaderBar/set_subtitle/@parameters/subtitle nullable 1"
 , "set-attr Gtk/HeaderBar/set_title/@parameters/title nullable 1"
 , "set-attr Gtk/IMContext/set_client_window/@parameters/window nullable 1"
 , "set-attr Gtk/IMContext/set_client_window/@parameters/window nullable 1"
 , "set-attr Gtk/IMContextClass/set_client_window/set_client_window/@parameters/window nullable 1"
 , "set-attr Gtk/IconInfo/get_builtin_pixbuf/@return-value nullable 1"
 , "set-attr Gtk/IconInfo/get_filename/@return-value nullable 1"
 , "set-attr Gtk/IconInfo/load_icon_async/@parameters/cancellable nullable 1"
 , "set-attr Gtk/IconInfo/load_icon_async/@parameters/callback nullable 1"
 , "set-attr Gtk/IconInfo/load_icon_async/@parameters/user_data nullable 1"
 , "set-attr Gtk/IconInfo/load_surface/@parameters/for_window nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic/@parameters/success_color nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic/@parameters/warning_color nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic/@parameters/error_color nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic_async/@parameters/success_color nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic_async/@parameters/warning_color nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic_async/@parameters/error_color nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic_async/@parameters/cancellable nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic_async/@parameters/callback nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic_async/@parameters/user_data nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic_for_context_async/@parameters/cancellable nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic_for_context_async/@parameters/callback nullable 1"
 , "set-attr Gtk/IconInfo/load_symbolic_for_context_async/@parameters/user_data nullable 1"
 , "set-attr Gtk/IconSet/render_icon/@parameters/style nullable 1"
 , "set-attr Gtk/IconSet/render_icon/@parameters/widget nullable 1"
 , "set-attr Gtk/IconSet/render_icon/@parameters/detail nullable 1"
 , "set-attr Gtk/IconSet/render_icon_surface/@parameters/for_window nullable 1"
 , "set-attr Gtk/IconSource/set_icon_name/@parameters/icon_name nullable 1"
 , "set-attr Gtk/IconTheme/choose_icon/@return-value nullable 1"
 , "set-attr Gtk/IconTheme/choose_icon_for_scale/@return-value nullable 1"
 , "set-attr Gtk/IconTheme/get_example_icon_name/@return-value nullable 1"
 , "set-attr Gtk/IconTheme/list_icons/@parameters/context nullable 1"
 , "set-attr Gtk/IconTheme/load_icon/@return-value nullable 1"
 , "set-attr Gtk/IconTheme/load_icon_for_scale/@return-value nullable 1"
 , "set-attr Gtk/IconTheme/load_surface/@return-value nullable 1"
 , "set-attr Gtk/IconTheme/load_surface/@parameters/for_window nullable 1"
 , "set-attr Gtk/IconTheme/lookup_by_gicon/@return-value nullable 1"
 , "set-attr Gtk/IconTheme/lookup_by_gicon_for_scale/@return-value nullable 1"
 , "set-attr Gtk/IconTheme/lookup_icon/@return-value nullable 1"
 , "set-attr Gtk/IconTheme/lookup_icon_for_scale/@return-value nullable 1"
 , "set-attr Gtk/IconTheme/set_custom_theme/@parameters/theme_name nullable 1"
 , "set-attr Gtk/IconView/get_cell_rect/@parameters/cell nullable 1"
 , "set-attr Gtk/IconView/get_model/@return-value nullable 1"
 , "set-attr Gtk/IconView/get_path_at_pos/@return-value nullable 1"
 , "set-attr Gtk/IconView/selected_foreach/@parameters/data nullable 1"
 , "set-attr Gtk/IconView/set_cursor/@parameters/cell nullable 1"
 , "set-attr Gtk/IconView/set_drag_dest_item/@parameters/path nullable 1"
 , "set-attr Gtk/IconView/set_model/@parameters/model nullable 1"
 , "set-attr Gtk/IconView/set_tooltip_cell/@parameters/cell nullable 1"
 , "set-attr Gtk/IconViewForeachFunc/@parameters/data nullable 1"
 , "set-attr Gtk/Image/new_from_icon_name/@parameters/icon_name nullable 1"
 , "set-attr Gtk/Image/new_from_pixbuf/@parameters/pixbuf nullable 1"
 , "set-attr Gtk/Image/new_from_surface/@parameters/surface nullable 1"
 , "set-attr Gtk/Image/get_animation/@return-value nullable 1"
 , "set-attr Gtk/Image/get_pixbuf/@return-value nullable 1"
 , "set-attr Gtk/Image/set_from_file/@parameters/filename nullable 1"
 , "set-attr Gtk/Image/set_from_icon_name/@parameters/icon_name nullable 1"
 , "set-attr Gtk/Image/set_from_pixbuf/@parameters/pixbuf nullable 1"
 , "set-attr Gtk/Image/set_from_resource/@parameters/resource_path nullable 1"
 , "set-attr Gtk/Image/set_from_surface/@parameters/surface nullable 1"
 , "set-attr Gtk/ImageMenuItem/new_from_stock/@parameters/accel_group nullable 1"
 , "set-attr Gtk/ImageMenuItem/set_image/@parameters/image nullable 1"
 , "set-attr Gtk/InfoBar/new_with_buttons/@parameters/first_button_text nullable 1"
 , "set-attr Gtk/KeySnoopFunc/@parameters/func_data nullable 1"
 , "set-attr Gtk/Label/new/@parameters/str nullable 1"
 , "set-attr Gtk/Label/new_with_mnemonic/@parameters/str nullable 1"
 , "set-attr Gtk/Label/get_attributes/@return-value nullable 1"
 , "set-attr Gtk/Label/get_mnemonic_widget/@return-value nullable 1"
 , "set-attr Gtk/Label/set_attributes/@parameters/attrs nullable 1"
 , "set-attr Gtk/Label/set_mnemonic_widget/@parameters/widget nullable 1"
 , "set-attr Gtk/Layout/new/@parameters/hadjustment nullable 1"
 , "set-attr Gtk/Layout/new/@parameters/vadjustment nullable 1"
 , "set-attr Gtk/Layout/set_hadjustment/@parameters/adjustment nullable 1"
 , "set-attr Gtk/Layout/set_vadjustment/@parameters/adjustment nullable 1"
 , "set-attr Gtk/LevelBar/get_offset_value/@parameters/name nullable 1"
 , "set-attr Gtk/LevelBar/remove_offset_value/@parameters/name nullable 1"
 , "set-attr Gtk/LinkButton/new_with_label/@parameters/label nullable 1"
 , "set-attr Gtk/ListBox/bind_model/@parameters/model nullable 1"
 , "set-attr Gtk/ListBox/bind_model/@parameters/create_widget_func nullable 1"
 , "set-attr Gtk/ListBox/bind_model/@parameters/user_data nullable 1"
 , "set-attr Gtk/ListBox/get_row_at_index/@return-value nullable 1"
 , "set-attr Gtk/ListBox/get_row_at_y/@return-value nullable 1"
 , "set-attr Gtk/ListBox/select_row/@parameters/row nullable 1"
 , "set-attr Gtk/ListBox/selected_foreach/@parameters/data nullable 1"
 , "set-attr Gtk/ListBox/set_adjustment/@parameters/adjustment nullable 1"
 , "set-attr Gtk/ListBox/set_filter_func/@parameters/filter_func nullable 1"
 , "set-attr Gtk/ListBox/set_filter_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/ListBox/set_header_func/@parameters/update_header nullable 1"
 , "set-attr Gtk/ListBox/set_header_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/ListBox/set_placeholder/@parameters/placeholder nullable 1"
 , "set-attr Gtk/ListBox/set_sort_func/@parameters/sort_func nullable 1"
 , "set-attr Gtk/ListBox/set_sort_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/ListBox/row-selected/@parameters/row nullable 1"
 , "set-attr Gtk/ListBoxCreateWidgetFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/ListBoxFilterFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/ListBoxForeachFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/ListBoxRow/get_header/@return-value nullable 1"
 , "set-attr Gtk/ListBoxRow/set_header/@parameters/header nullable 1"
 , "set-attr Gtk/ListBoxSortFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/ListBoxUpdateHeaderFunc/@parameters/before nullable 1"
 , "set-attr Gtk/ListBoxUpdateHeaderFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/ListStore/insert_after/@parameters/sibling nullable 1"
 , "set-attr Gtk/ListStore/insert_before/@parameters/sibling nullable 1"
 , "set-attr Gtk/ListStore/move_after/@parameters/position nullable 1"
 , "set-attr Gtk/ListStore/move_before/@parameters/position nullable 1"
 , "set-attr Gtk/LockButton/new/@parameters/permission nullable 1"
 , "set-attr Gtk/LockButton/set_permission/@parameters/permission nullable 1"
 , "set-attr Gtk/Menu/attach_to_widget/@parameters/detacher nullable 1"
 , "set-attr Gtk/Menu/popup/@parameters/parent_menu_shell nullable 1"
 , "set-attr Gtk/Menu/popup/@parameters/parent_menu_item nullable 1"
 , "set-attr Gtk/Menu/popup/@parameters/func nullable 1"
 , "set-attr Gtk/Menu/popup/@parameters/data nullable 1"
 , "set-attr Gtk/Menu/popup_at_pointer/@parameters/trigger_event nullable 1"
 , "set-attr Gtk/Menu/popup_at_rect/@parameters/trigger_event nullable 1"
 , "set-attr Gtk/Menu/popup_at_widget/@parameters/trigger_event nullable 1"
 , "set-attr Gtk/Menu/popup_for_device/@parameters/device nullable 1"
 , "set-attr Gtk/Menu/popup_for_device/@parameters/parent_menu_shell nullable 1"
 , "set-attr Gtk/Menu/popup_for_device/@parameters/parent_menu_item nullable 1"
 , "set-attr Gtk/Menu/popup_for_device/@parameters/func nullable 1"
 , "set-attr Gtk/Menu/popup_for_device/@parameters/data nullable 1"
 , "set-attr Gtk/Menu/popup_for_device/@parameters/destroy nullable 1"
 , "set-attr Gtk/Menu/set_accel_group/@parameters/accel_group nullable 1"
 , "set-attr Gtk/Menu/set_accel_path/@parameters/accel_path nullable 1"
 , "set-attr Gtk/Menu/set_screen/@parameters/screen nullable 1"
 , "set-attr Gtk/Menu/popped-up/@parameters/flipped_rect nullable 1"
 , "set-attr Gtk/Menu/popped-up/@parameters/final_rect nullable 1"
 , "set-attr Gtk/MenuButton/get_align_widget/@return-value nullable 1"
 , "set-attr Gtk/MenuButton/get_menu_model/@return-value nullable 1"
 , "set-attr Gtk/MenuButton/get_popover/@return-value nullable 1"
 , "set-attr Gtk/MenuButton/get_popup/@return-value nullable 1"
 , "set-attr Gtk/MenuButton/set_align_widget/@parameters/align_widget nullable 1"
 , "set-attr Gtk/MenuButton/set_menu_model/@parameters/menu_model nullable 1"
 , "set-attr Gtk/MenuButton/set_popover/@parameters/popover nullable 1"
 , "set-attr Gtk/MenuButton/set_popup/@parameters/menu nullable 1"
 , "set-attr Gtk/MenuItem/get_accel_path/@return-value nullable 1"
 , "set-attr Gtk/MenuItem/get_submenu/@return-value nullable 1"
 , "set-attr Gtk/MenuItem/set_accel_path/@parameters/accel_path nullable 1"
 , "set-attr Gtk/MenuItem/set_submenu/@parameters/submenu nullable 1"
 , "set-attr Gtk/MenuItem/toggle-size-request/@parameters/object nullable 1"
 , "set-attr Gtk/MenuPositionFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/MenuShell/bind_model/@parameters/model nullable 1"
 , "set-attr Gtk/MenuShell/bind_model/@parameters/action_namespace nullable 1"
 , "set-attr Gtk/MenuToolButton/new/@parameters/icon_widget nullable 1"
 , "set-attr Gtk/MenuToolButton/new/@parameters/label nullable 1"
 , "set-attr Gtk/MessageDialog/new/@parameters/parent nullable 1"
 , "set-attr Gtk/MessageDialog/new/@parameters/message_format nullable 1"
 , "set-attr Gtk/MessageDialog/new_with_markup/@parameters/parent nullable 1"
 , "set-attr Gtk/MessageDialog/new_with_markup/@parameters/message_format nullable 1"
 , "set-attr Gtk/MessageDialog/format_secondary_text/@parameters/message_format nullable 1"
 , "set-attr Gtk/ModuleInitFunc/@parameters/argc nullable 1"
 , "set-attr Gtk/ModuleInitFunc/@parameters/argv nullable 1"
 , "set-attr Gtk/MountOperation/new/@parameters/parent nullable 1"
 , "set-attr Gtk/MountOperation/set_parent/@parameters/parent nullable 1"
 , "set-attr Gtk/NativeDialog/get_title/@return-value nullable 1"
 , "set-attr Gtk/NativeDialog/get_transient_for/@return-value nullable 1"
 , "set-attr Gtk/NativeDialog/set_transient_for/@parameters/parent nullable 1"
 , "set-attr Gtk/Notebook/append_page/@parameters/tab_label nullable 1"
 , "set-attr Gtk/Notebook/append_page_menu/@parameters/tab_label nullable 1"
 , "set-attr Gtk/Notebook/append_page_menu/@parameters/menu_label nullable 1"
 , "set-attr Gtk/Notebook/get_action_widget/@return-value nullable 1"
 , "set-attr Gtk/Notebook/get_group_name/@return-value nullable 1"
 , "set-attr Gtk/Notebook/get_menu_label/@return-value nullable 1"
 , "set-attr Gtk/Notebook/get_menu_label_text/@return-value nullable 1"
 , "set-attr Gtk/Notebook/get_nth_page/@return-value nullable 1"
 , "set-attr Gtk/Notebook/get_tab_label_text/@return-value nullable 1"
 , "set-attr Gtk/Notebook/insert_page/@parameters/tab_label nullable 1"
 , "set-attr Gtk/Notebook/insert_page_menu/@parameters/tab_label nullable 1"
 , "set-attr Gtk/Notebook/insert_page_menu/@parameters/menu_label nullable 1"
 , "set-attr Gtk/Notebook/prepend_page/@parameters/tab_label nullable 1"
 , "set-attr Gtk/Notebook/prepend_page_menu/@parameters/tab_label nullable 1"
 , "set-attr Gtk/Notebook/prepend_page_menu/@parameters/menu_label nullable 1"
 , "set-attr Gtk/Notebook/set_group_name/@parameters/group_name nullable 1"
 , "set-attr Gtk/Notebook/set_menu_label/@parameters/menu_label nullable 1"
 , "set-attr Gtk/Notebook/set_tab_label/@parameters/tab_label nullable 1"
 , "set-attr Gtk/NumerableIcon/get_background_gicon/@return-value nullable 1"
 , "set-attr Gtk/NumerableIcon/get_background_icon_name/@return-value nullable 1"
 , "set-attr Gtk/NumerableIcon/get_label/@return-value nullable 1"
 , "set-attr Gtk/NumerableIcon/get_style_context/@return-value nullable 1"
 , "set-attr Gtk/NumerableIcon/set_background_gicon/@parameters/icon nullable 1"
 , "set-attr Gtk/NumerableIcon/set_background_icon_name/@parameters/icon_name nullable 1"
 , "set-attr Gtk/NumerableIcon/set_label/@parameters/label nullable 1"
 , "set-attr Gtk/OffscreenWindow/get_pixbuf/@return-value nullable 1"
 , "set-attr Gtk/OffscreenWindow/get_surface/@return-value nullable 1"
 , "set-attr Gtk/PadController/new/@parameters/pad nullable 1"
 , "set-attr Gtk/PageSetup/new_from_key_file/@parameters/group_name nullable 1"
 , "set-attr Gtk/PageSetup/load_key_file/@parameters/group_name nullable 1"
 , "set-attr Gtk/PageSetupDoneFunc/@parameters/data nullable 1"
 , "set-attr Gtk/Paned/get_child1/@return-value nullable 1"
 , "set-attr Gtk/Paned/get_child2/@return-value nullable 1"
 , "set-attr Gtk/PaperSize/new/@parameters/name nullable 1"
 , "set-attr Gtk/PlacesSidebar/get_location/@return-value nullable 1"
 , "set-attr Gtk/PlacesSidebar/get_nth_bookmark/@return-value nullable 1"
 , "set-attr Gtk/PlacesSidebar/set_location/@parameters/location nullable 1"
 , "set-attr Gtk/PlacesSidebar/populate-popup/@parameters/selected_item nullable 1"
 , "set-attr Gtk/PlacesSidebar/populate-popup/@parameters/selected_volume nullable 1"
 , "set-attr Gtk/Popover/new/@parameters/relative_to nullable 1"
 , "set-attr Gtk/Popover/new_from_model/@parameters/relative_to nullable 1"
 , "set-attr Gtk/Popover/bind_model/@parameters/model nullable 1"
 , "set-attr Gtk/Popover/bind_model/@parameters/action_namespace nullable 1"
 , "set-attr Gtk/Popover/get_default_widget/@return-value nullable 1"
 , "set-attr Gtk/Popover/set_default_widget/@parameters/widget nullable 1"
 , "set-attr Gtk/Popover/set_relative_to/@parameters/relative_to nullable 1"
 , "set-attr Gtk/PrintOperation/run/@parameters/parent nullable 1"
 , "set-attr Gtk/PrintOperation/set_custom_tab_label/@parameters/label nullable 1"
 , "set-attr Gtk/PrintOperation/set_default_page_setup/@parameters/default_page_setup nullable 1"
 , "set-attr Gtk/PrintOperation/set_print_settings/@parameters/print_settings nullable 1"
 , "set-attr Gtk/PrintOperation/preview/@parameters/parent nullable 1"
 , "set-attr Gtk/PrintSettings/new_from_key_file/@parameters/group_name nullable 1"
 , "set-attr Gtk/PrintSettings/foreach/@parameters/user_data nullable 1"
 , "set-attr Gtk/PrintSettings/load_key_file/@parameters/group_name nullable 1"
 , "set-attr Gtk/PrintSettings/set/@parameters/value nullable 1"
 , "set-attr Gtk/PrintSettingsFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/ProgressBar/get_text/@return-value nullable 1"
 , "set-attr Gtk/ProgressBar/set_text/@parameters/text nullable 1"
 , "set-attr Gtk/RadioAction/new/@parameters/label nullable 1"
 , "set-attr Gtk/RadioAction/new/@parameters/tooltip nullable 1"
 , "set-attr Gtk/RadioAction/new/@parameters/stock_id nullable 1"
 , "set-attr Gtk/RadioAction/join_group/@parameters/group_source nullable 1"
 , "set-attr Gtk/RadioAction/set_group/@parameters/group nullable 1"
 , "set-attr Gtk/RadioButton/new/@parameters/group nullable 1"
 , "set-attr Gtk/RadioButton/new_from_widget/@parameters/radio_group_member nullable 1"
 , "set-attr Gtk/RadioButton/new_with_label/@parameters/group nullable 1"
 , "set-attr Gtk/RadioButton/new_with_label_from_widget/@parameters/radio_group_member nullable 1"
 , "set-attr Gtk/RadioButton/new_with_mnemonic/@parameters/group nullable 1"
 , "set-attr Gtk/RadioButton/new_with_mnemonic_from_widget/@parameters/radio_group_member nullable 1"
 , "set-attr Gtk/RadioButton/join_group/@parameters/group_source nullable 1"
 , "set-attr Gtk/RadioButton/set_group/@parameters/group nullable 1"
 , "set-attr Gtk/RadioMenuItem/new/@parameters/group nullable 1"
 , "set-attr Gtk/RadioMenuItem/new_from_widget/@parameters/group nullable 1"
 , "set-attr Gtk/RadioMenuItem/new_with_label/@parameters/group nullable 1"
 , "set-attr Gtk/RadioMenuItem/new_with_label_from_widget/@parameters/group nullable 1"
 , "set-attr Gtk/RadioMenuItem/new_with_label_from_widget/@parameters/label nullable 1"
 , "set-attr Gtk/RadioMenuItem/new_with_mnemonic/@parameters/group nullable 1"
 , "set-attr Gtk/RadioMenuItem/new_with_mnemonic_from_widget/@parameters/group nullable 1"
 , "set-attr Gtk/RadioMenuItem/new_with_mnemonic_from_widget/@parameters/label nullable 1"
 , "set-attr Gtk/RadioMenuItem/join_group/@parameters/group_source nullable 1"
 , "set-attr Gtk/RadioMenuItem/set_group/@parameters/group nullable 1"
 , "set-attr Gtk/RadioToolButton/new/@parameters/group nullable 1"
 , "set-attr Gtk/RadioToolButton/new_from_stock/@parameters/group nullable 1"
 , "set-attr Gtk/RadioToolButton/new_from_widget/@parameters/group nullable 1"
 , "set-attr Gtk/RadioToolButton/new_with_stock_from_widget/@parameters/group nullable 1"
 , "set-attr Gtk/RadioToolButton/set_group/@parameters/group nullable 1"
 , "set-attr Gtk/RecentAction/new/@parameters/label nullable 1"
 , "set-attr Gtk/RecentAction/new/@parameters/tooltip nullable 1"
 , "set-attr Gtk/RecentAction/new/@parameters/stock_id nullable 1"
 , "set-attr Gtk/RecentAction/new_for_manager/@parameters/label nullable 1"
 , "set-attr Gtk/RecentAction/new_for_manager/@parameters/tooltip nullable 1"
 , "set-attr Gtk/RecentAction/new_for_manager/@parameters/stock_id nullable 1"
 , "set-attr Gtk/RecentAction/new_for_manager/@parameters/manager nullable 1"
 , "set-attr Gtk/RecentChooser/set_sort_func/@parameters/sort_data nullable 1"
 , "set-attr Gtk/RecentChooser/set_sort_func/@parameters/data_destroy nullable 1"
 , "set-attr Gtk/RecentChooser/set_filter/@parameters/filter nullable 1"
 , "set-attr Gtk/RecentChooser/set_sort_func/@parameters/sort_data nullable 1"
 , "set-attr Gtk/RecentChooser/set_sort_func/@parameters/data_destroy nullable 1"
 , "set-attr Gtk/RecentChooserDialog/new/@parameters/title nullable 1"
 , "set-attr Gtk/RecentChooserDialog/new/@parameters/parent nullable 1"
 , "set-attr Gtk/RecentChooserDialog/new/@parameters/first_button_text nullable 1"
 , "set-attr Gtk/RecentChooserDialog/new_for_manager/@parameters/title nullable 1"
 , "set-attr Gtk/RecentChooserDialog/new_for_manager/@parameters/parent nullable 1"
 , "set-attr Gtk/RecentChooserDialog/new_for_manager/@parameters/first_button_text nullable 1"
 , "set-attr Gtk/RecentChooserIface/set_sort_func/set_sort_func/@parameters/sort_data nullable 1"
 , "set-attr Gtk/RecentChooserIface/set_sort_func/set_sort_func/@parameters/data_destroy nullable 1"
 , "set-attr Gtk/RecentFilter/add_custom/@parameters/data nullable 1"
 , "set-attr Gtk/RecentFilter/get_name/@return-value nullable 1"
 , "set-attr Gtk/RecentFilterFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/RecentInfo/create_app_info/@return-value nullable 1"
 , "set-attr Gtk/RecentInfo/create_app_info/@parameters/app_name nullable 1"
 , "set-attr Gtk/RecentInfo/get_gicon/@return-value nullable 1"
 , "set-attr Gtk/RecentInfo/get_icon/@return-value nullable 1"
 , "set-attr Gtk/RecentInfo/get_uri_display/@return-value nullable 1"
 , "set-attr Gtk/RecentManager/lookup_item/@return-value nullable 1"
 , "set-attr Gtk/RecentManager/move_item/@parameters/new_uri nullable 1"
 , "set-attr Gtk/RecentSortFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/Scale/new/@parameters/adjustment nullable 1"
 , "set-attr Gtk/Scale/add_mark/@parameters/markup nullable 1"
 , "set-attr Gtk/Scale/get_layout/@return-value nullable 1"
 , "set-attr Gtk/ScaleButton/new/@parameters/icons nullable 1"
 , "set-attr Gtk/Scrollable/set_hadjustment/@parameters/hadjustment nullable 1"
 , "set-attr Gtk/Scrollable/set_vadjustment/@parameters/vadjustment nullable 1"
 , "set-attr Gtk/Scrollbar/new/@parameters/adjustment nullable 1"
 , "set-attr Gtk/ScrolledWindow/new/@parameters/hadjustment nullable 1"
 , "set-attr Gtk/ScrolledWindow/new/@parameters/vadjustment nullable 1"
 , "set-attr Gtk/SelectionData/get_pixbuf/@return-value nullable 1"
 , "set-attr Gtk/SelectionData/get_text/@return-value nullable 1"
 , "set-attr Gtk/Settings/get_default/@return-value nullable 1"
 , "set-attr Gtk/ShortcutLabel/get_accelerator/@return-value nullable 1"
 , "set-attr Gtk/ShortcutLabel/get_disabled_text/@return-value nullable 1"
 , "set-attr Gtk/SpinButton/new/@parameters/adjustment nullable 1"
 , "set-attr Gtk/SpinButton/configure/@parameters/adjustment nullable 1"
 , "set-attr Gtk/Stack/get_child_by_name/@return-value nullable 1"
 , "set-attr Gtk/Stack/get_visible_child/@return-value nullable 1"
 , "set-attr Gtk/Stack/get_visible_child_name/@return-value nullable 1"
 , "set-attr Gtk/StackSidebar/get_stack/@return-value nullable 1"
 , "set-attr Gtk/StackSwitcher/get_stack/@return-value nullable 1"
 , "set-attr Gtk/StackSwitcher/set_stack/@parameters/stack nullable 1"
 , "set-attr Gtk/StatusIcon/get_gicon/@return-value nullable 1"
 , "set-attr Gtk/StatusIcon/get_icon_name/@return-value nullable 1"
 , "set-attr Gtk/StatusIcon/get_pixbuf/@return-value nullable 1"
 , "set-attr Gtk/StatusIcon/get_stock/@return-value nullable 1"
 , "set-attr Gtk/StatusIcon/get_tooltip_markup/@return-value nullable 1"
 , "set-attr Gtk/StatusIcon/get_tooltip_text/@return-value nullable 1"
 , "set-attr Gtk/StatusIcon/set_from_pixbuf/@parameters/pixbuf nullable 1"
 , "set-attr Gtk/StatusIcon/set_tooltip_markup/@parameters/markup nullable 1"
 , "set-attr Gtk/Style/render_icon/@parameters/widget nullable 1"
 , "set-attr Gtk/Style/render_icon/@parameters/detail nullable 1"
 , "set-attr Gtk/Style/render_icon/@parameters/widget nullable 1"
 , "set-attr Gtk/Style/render_icon/@parameters/detail nullable 1"
 , "set-attr Gtk/StyleClass/render_icon/render_icon/@parameters/widget nullable 1"
 , "set-attr Gtk/StyleClass/render_icon/render_icon/@parameters/detail nullable 1"
 , "set-attr Gtk/StyleContext/cancel_animations/@parameters/region_id nullable 1"
 , "set-attr Gtk/StyleContext/get_frame_clock/@return-value nullable 1"
 , "set-attr Gtk/StyleContext/get_parent/@return-value nullable 1"
 , "set-attr Gtk/StyleContext/get_section/@return-value nullable 1"
 , "set-attr Gtk/StyleContext/lookup_icon_set/@return-value nullable 1"
 , "set-attr Gtk/StyleContext/notify_state_change/@parameters/region_id nullable 1"
 , "set-attr Gtk/StyleContext/push_animatable_region/@parameters/region_id nullable 1"
 , "set-attr Gtk/StyleContext/set_parent/@parameters/parent nullable 1"
 , "set-attr Gtk/StyleProperties/register_property/@parameters/parse_func nullable 1"
 , "set-attr Gtk/StyleProvider/get_icon_factory/@return-value nullable 1"
 , "set-attr Gtk/StyleProvider/get_style/@return-value nullable 1"
 , "set-attr Gtk/StyleProvider/get_icon_factory/@return-value nullable 1"
 , "set-attr Gtk/StyleProvider/get_style/@return-value nullable 1"
 , "set-attr Gtk/StyleProviderIface/get_style/get_style/@return-value nullable 1"
 , "set-attr Gtk/StyleProviderIface/get_icon_factory/get_icon_factory/@return-value nullable 1"
 , "set-attr Gtk/SymbolicColor/resolve/@parameters/props nullable 1"
 , "set-attr Gtk/TargetList/new/@parameters/targets nullable 1"
 , "set-attr Gtk/TextBuffer/new/@parameters/table nullable 1"
 , "set-attr Gtk/TextBuffer/create_mark/@parameters/mark_name nullable 1"
 , "set-attr Gtk/TextBuffer/create_tag/@parameters/tag_name nullable 1"
 , "set-attr Gtk/TextBuffer/create_tag/@parameters/first_property_name nullable 1"
 , "set-attr Gtk/TextBuffer/get_mark/@return-value nullable 1"
 , "set-attr Gtk/TextBuffer/paste_clipboard/@parameters/override_location nullable 1"
 , "set-attr Gtk/TextBuffer/register_deserialize_format/@parameters/user_data nullable 1"
 , "set-attr Gtk/TextBuffer/register_deserialize_tagset/@parameters/tagset_name nullable 1"
 , "set-attr Gtk/TextBuffer/register_serialize_format/@parameters/user_data nullable 1"
 , "set-attr Gtk/TextBuffer/register_serialize_tagset/@parameters/tagset_name nullable 1"
 , "set-attr Gtk/TextBufferDeserializeFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/TextBufferSerializeFunc/@return-value nullable 1"
 , "set-attr Gtk/TextBufferSerializeFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/TextCharPredicate/@parameters/user_data nullable 1"
 , "set-attr Gtk/TextIter/backward_find_char/@parameters/user_data nullable 1"
 , "set-attr Gtk/TextIter/backward_find_char/@parameters/limit nullable 1"
 , "set-attr Gtk/TextIter/backward_search/@parameters/limit nullable 1"
 , "set-attr Gtk/TextIter/backward_to_tag_toggle/@parameters/tag nullable 1"
 , "set-attr Gtk/TextIter/begins_tag/@parameters/tag nullable 1"
 , "set-attr Gtk/TextIter/ends_tag/@parameters/tag nullable 1"
 , "set-attr Gtk/TextIter/forward_find_char/@parameters/user_data nullable 1"
 , "set-attr Gtk/TextIter/forward_find_char/@parameters/limit nullable 1"
 , "set-attr Gtk/TextIter/forward_search/@parameters/limit nullable 1"
 , "set-attr Gtk/TextIter/forward_to_tag_toggle/@parameters/tag nullable 1"
 , "set-attr Gtk/TextIter/starts_tag/@parameters/tag nullable 1"
 , "set-attr Gtk/TextIter/toggles_tag/@parameters/tag nullable 1"
 , "set-attr Gtk/TextMark/new/@parameters/name nullable 1"
 , "set-attr Gtk/TextTag/new/@parameters/name nullable 1"
 , "set-attr Gtk/TextTagTable/foreach/@parameters/data nullable 1"
 , "set-attr Gtk/TextTagTable/lookup/@return-value nullable 1"
 , "set-attr Gtk/TextTagTableForeach/@parameters/data nullable 1"
 , "set-attr Gtk/TextView/get_cursor_locations/@parameters/iter nullable 1"
 , "set-attr Gtk/TextView/get_tabs/@return-value nullable 1"
 , "set-attr Gtk/TextView/get_window/@return-value nullable 1"
 , "set-attr Gtk/TextView/set_buffer/@parameters/buffer nullable 1"
 , "set-attr Gtk/ThemingEngine/load/@return-value nullable 1"
 , "set-attr Gtk/ThemingEngine/register_property/@parameters/parse_func nullable 1"
 , "set-attr Gtk/ThemingEngine/get_screen/@return-value nullable 1"
 , "set-attr Gtk/TickCallback/@parameters/user_data nullable 1"
 , "set-attr Gtk/ToggleAction/new/@parameters/label nullable 1"
 , "set-attr Gtk/ToggleAction/new/@parameters/tooltip nullable 1"
 , "set-attr Gtk/ToggleAction/new/@parameters/stock_id nullable 1"
 , "set-attr Gtk/ToolButton/new/@parameters/icon_widget nullable 1"
 , "set-attr Gtk/ToolButton/new/@parameters/label nullable 1"
 , "set-attr Gtk/ToolButton/get_icon_name/@return-value nullable 1"
 , "set-attr Gtk/ToolButton/get_icon_widget/@return-value nullable 1"
 , "set-attr Gtk/ToolButton/get_label/@return-value nullable 1"
 , "set-attr Gtk/ToolButton/get_label_widget/@return-value nullable 1"
 , "set-attr Gtk/ToolButton/set_icon_name/@parameters/icon_name nullable 1"
 , "set-attr Gtk/ToolButton/set_icon_widget/@parameters/icon_widget nullable 1"
 , "set-attr Gtk/ToolButton/set_label/@parameters/label nullable 1"
 , "set-attr Gtk/ToolButton/set_label_widget/@parameters/label_widget nullable 1"
 , "set-attr Gtk/ToolButton/set_stock_id/@parameters/stock_id nullable 1"
 , "set-attr Gtk/ToolPalette/get_drop_group/@return-value nullable 1"
 , "set-attr Gtk/ToolPalette/get_drop_item/@return-value nullable 1"
 , "set-attr Gtk/Toolbar/get_nth_item/@return-value nullable 1"
 , "set-attr Gtk/Toolbar/set_drop_highlight_item/@parameters/tool_item nullable 1"
 , "set-attr Gtk/Tooltip/set_custom/@parameters/custom_widget nullable 1"
 , "set-attr Gtk/Tooltip/set_icon/@parameters/pixbuf nullable 1"
 , "set-attr Gtk/Tooltip/set_icon_from_gicon/@parameters/gicon nullable 1"
 , "set-attr Gtk/Tooltip/set_icon_from_icon_name/@parameters/icon_name nullable 1"
 , "set-attr Gtk/Tooltip/set_icon_from_stock/@parameters/stock_id nullable 1"
 , "set-attr Gtk/Tooltip/set_markup/@parameters/markup nullable 1"
 , "set-attr Gtk/Tooltip/set_text/@parameters/text nullable 1"
 , "set-attr Gtk/TranslateFunc/@parameters/func_data nullable 1"
 , "set-attr Gtk/TreeCellDataFunc/@parameters/data nullable 1"
 , "set-attr Gtk/TreeDestroyCountFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/TreeIterCompareFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/TreeModel/iter_children/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeModel/iter_n_children/@parameters/iter nullable 1"
 , "set-attr Gtk/TreeModel/iter_nth_child/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeModel/filter_new/@parameters/root nullable 1"
 , "set-attr Gtk/TreeModel/foreach/@parameters/user_data nullable 1"
 , "set-attr Gtk/TreeModel/iter_children/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeModel/iter_n_children/@parameters/iter nullable 1"
 , "set-attr Gtk/TreeModel/iter_nth_child/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeModel/rows_reordered_with_length/@parameters/iter nullable 1"
 , "set-attr Gtk/TreeModel/rows-reordered/@parameters/new_order nullable 1"
 , "set-attr Gtk/TreeModelFilter/convert_child_path_to_path/@return-value nullable 1"
 , "set-attr Gtk/TreeModelFilter/convert_path_to_child_path/@return-value nullable 1"
 , "set-attr Gtk/TreeModelFilter/set_modify_func/@parameters/data nullable 1"
 , "set-attr Gtk/TreeModelFilter/set_modify_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeModelFilter/set_visible_func/@parameters/data nullable 1"
 , "set-attr Gtk/TreeModelFilter/set_visible_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeModelFilterModifyFunc/@parameters/data nullable 1"
 , "set-attr Gtk/TreeModelFilterVisibleFunc/@parameters/data nullable 1"
 , "set-attr Gtk/TreeModelForeachFunc/@parameters/data nullable 1"
 , "set-attr Gtk/TreeModelIface/iter_children/iter_children/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeModelIface/iter_n_children/iter_n_children/@parameters/iter nullable 1"
 , "set-attr Gtk/TreeModelIface/iter_nth_child/iter_nth_child/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeModelSort/convert_child_path_to_path/@return-value nullable 1"
 , "set-attr Gtk/TreeModelSort/convert_path_to_child_path/@return-value nullable 1"
 , "set-attr Gtk/TreePath/free/@parameters/path nullable 1"
 , "set-attr Gtk/TreeRowReference/free/@parameters/reference nullable 1"
 , "set-attr Gtk/TreeRowReference/get_path/@return-value nullable 1"
 , "set-attr Gtk/TreeRowReference/valid/@parameters/reference nullable 1"
 , "set-attr Gtk/TreeSelection/get_user_data/@return-value nullable 1"
 , "set-attr Gtk/TreeSelection/selected_foreach/@parameters/data nullable 1"
 , "set-attr Gtk/TreeSelection/set_select_function/@parameters/data nullable 1"
 , "set-attr Gtk/TreeSelectionForeachFunc/@parameters/data nullable 1"
 , "set-attr Gtk/TreeSelectionFunc/@parameters/data nullable 1"
 , "set-attr Gtk/TreeSortable/set_default_sort_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/TreeSortable/set_default_sort_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeSortable/set_sort_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/TreeSortable/set_sort_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeSortable/set_default_sort_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/TreeSortable/set_default_sort_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeSortable/set_sort_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/TreeSortable/set_sort_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeSortableIface/set_sort_func/set_sort_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/TreeSortableIface/set_sort_func/set_sort_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeSortableIface/set_default_sort_func/set_default_sort_func/@parameters/user_data nullable 1"
 , "set-attr Gtk/TreeSortableIface/set_default_sort_func/set_default_sort_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeStore/append/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeStore/insert/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeStore/insert_after/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeStore/insert_after/@parameters/sibling nullable 1"
 , "set-attr Gtk/TreeStore/insert_before/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeStore/insert_before/@parameters/sibling nullable 1"
 , "set-attr Gtk/TreeStore/insert_with_values/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeStore/insert_with_valuesv/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeStore/move_after/@parameters/position nullable 1"
 , "set-attr Gtk/TreeStore/move_before/@parameters/position nullable 1"
 , "set-attr Gtk/TreeStore/prepend/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeStore/reorder/@parameters/parent nullable 1"
 , "set-attr Gtk/TreeView/get_background_area/@parameters/path nullable 1"
 , "set-attr Gtk/TreeView/get_background_area/@parameters/column nullable 1"
 , "set-attr Gtk/TreeView/get_bin_window/@return-value nullable 1"
 , "set-attr Gtk/TreeView/get_cell_area/@parameters/path nullable 1"
 , "set-attr Gtk/TreeView/get_cell_area/@parameters/column nullable 1"
 , "set-attr Gtk/TreeView/get_column/@return-value nullable 1"
 , "set-attr Gtk/TreeView/get_cursor/@parameters/path nullable 1"
 , "set-attr Gtk/TreeView/get_cursor/@parameters/focus_column nullable 1"
 , "set-attr Gtk/TreeView/get_dest_row_at_pos/@parameters/path nullable 1"
 , "set-attr Gtk/TreeView/get_drag_dest_row/@parameters/path nullable 1"
 , "set-attr Gtk/TreeView/get_model/@return-value nullable 1"
 , "set-attr Gtk/TreeView/get_path_at_pos/@parameters/path nullable 1"
 , "set-attr Gtk/TreeView/get_path_at_pos/@parameters/column nullable 1"
 , "set-attr Gtk/TreeView/get_tooltip_context/@parameters/model nullable 1"
 , "set-attr Gtk/TreeView/insert_column_with_data_func/@parameters/data nullable 1"
 , "set-attr Gtk/TreeView/map_expanded_rows/@parameters/data nullable 1"
 , "set-attr Gtk/TreeView/move_column_after/@parameters/base_column nullable 1"
 , "set-attr Gtk/TreeView/scroll_to_cell/@parameters/path nullable 1"
 , "set-attr Gtk/TreeView/scroll_to_cell/@parameters/column nullable 1"
 , "set-attr Gtk/TreeView/set_column_drag_function/@parameters/func nullable 1"
 , "set-attr Gtk/TreeView/set_column_drag_function/@parameters/user_data nullable 1"
 , "set-attr Gtk/TreeView/set_column_drag_function/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeView/set_cursor/@parameters/focus_column nullable 1"
 , "set-attr Gtk/TreeView/set_cursor_on_cell/@parameters/focus_column nullable 1"
 , "set-attr Gtk/TreeView/set_cursor_on_cell/@parameters/focus_cell nullable 1"
 , "set-attr Gtk/TreeView/set_destroy_count_func/@parameters/func nullable 1"
 , "set-attr Gtk/TreeView/set_destroy_count_func/@parameters/data nullable 1"
 , "set-attr Gtk/TreeView/set_destroy_count_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeView/set_drag_dest_row/@parameters/path nullable 1"
 , "set-attr Gtk/TreeView/set_hadjustment/@parameters/adjustment nullable 1"
 , "set-attr Gtk/TreeView/set_model/@parameters/model nullable 1"
 , "set-attr Gtk/TreeView/set_row_separator_func/@parameters/func nullable 1"
 , "set-attr Gtk/TreeView/set_row_separator_func/@parameters/data nullable 1"
 , "set-attr Gtk/TreeView/set_row_separator_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeView/set_search_entry/@parameters/entry nullable 1"
 , "set-attr Gtk/TreeView/set_search_equal_func/@parameters/search_user_data nullable 1"
 , "set-attr Gtk/TreeView/set_search_equal_func/@parameters/search_destroy nullable 1"
 , "set-attr Gtk/TreeView/set_search_position_func/@parameters/func nullable 1"
 , "set-attr Gtk/TreeView/set_search_position_func/@parameters/data nullable 1"
 , "set-attr Gtk/TreeView/set_search_position_func/@parameters/destroy nullable 1"
 , "set-attr Gtk/TreeView/set_tooltip_cell/@parameters/path nullable 1"
 , "set-attr Gtk/TreeView/set_tooltip_cell/@parameters/column nullable 1"
 , "set-attr Gtk/TreeView/set_tooltip_cell/@parameters/cell nullable 1"
 , "set-attr Gtk/TreeView/set_vadjustment/@parameters/adjustment nullable 1"
 , "set-attr Gtk/TreeViewColumn/cell_get_size/@parameters/cell_area nullable 1"
 , "set-attr Gtk/TreeViewColumn/get_tree_view/@return-value nullable 1"
 , "set-attr Gtk/TreeViewColumn/get_widget/@return-value nullable 1"
 , "set-attr Gtk/TreeViewColumn/set_cell_data_func/@parameters/func nullable 1"
 , "set-attr Gtk/TreeViewColumn/set_cell_data_func/@parameters/func_data nullable 1"
 , "set-attr Gtk/TreeViewColumn/set_widget/@parameters/widget nullable 1"
 , "set-attr Gtk/TreeViewColumnDropFunc/@parameters/data nullable 1"
 , "set-attr Gtk/TreeViewMappingFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/TreeViewRowSeparatorFunc/@parameters/data nullable 1"
 , "set-attr Gtk/TreeViewSearchEqualFunc/@parameters/search_data nullable 1"
 , "set-attr Gtk/TreeViewSearchPositionFunc/@parameters/user_data nullable 1"
 , "set-attr Gtk/UIManager/add_ui/@parameters/action nullable 1"
 , "set-attr Gtk/VScrollbar/new/@parameters/adjustment nullable 1"
 , "set-attr Gtk/Viewport/new/@parameters/hadjustment nullable 1"
 , "set-attr Gtk/Viewport/new/@parameters/vadjustment nullable 1"
 , "set-attr Gtk/Viewport/set_hadjustment/@parameters/adjustment nullable 1"
 , "set-attr Gtk/Viewport/set_vadjustment/@parameters/adjustment nullable 1"
 , "set-attr Gtk/Widget/add_tick_callback/@parameters/user_data nullable 1"
 , "set-attr Gtk/Widget/create_pango_layout/@parameters/text nullable 1"
 , "set-attr Gtk/Widget/drag_dest_find_target/@parameters/target_list nullable 1"
 , "set-attr Gtk/Widget/drag_dest_set/@parameters/targets nullable 1"
 , "set-attr Gtk/Widget/drag_dest_set_target_list/@parameters/target_list nullable 1"
 , "set-attr Gtk/Widget/drag_source_get_target_list/@return-value nullable 1"
 , "set-attr Gtk/Widget/drag_source_set/@parameters/targets nullable 1"
 , "set-attr Gtk/Widget/drag_source_set_target_list/@parameters/target_list nullable 1"
 , "set-attr Gtk/Widget/get_action_group/@return-value nullable 1"
 , "set-attr Gtk/Widget/get_ancestor/@return-value nullable 1"
 , "set-attr Gtk/Widget/get_font_map/@return-value nullable 1"
 , "set-attr Gtk/Widget/get_font_options/@return-value nullable 1"
 , "set-attr Gtk/Widget/get_frame_clock/@return-value nullable 1"
 , "set-attr Gtk/Widget/get_parent/@return-value nullable 1"
 , "set-attr Gtk/Widget/get_tooltip_markup/@return-value nullable 1"
 , "set-attr Gtk/Widget/get_tooltip_text/@return-value nullable 1"
 , "set-attr Gtk/Widget/get_window/@return-value nullable 1"
 , "set-attr Gtk/Widget/input_shape_combine_region/@parameters/region nullable 1"
 , "set-attr Gtk/Widget/insert_action_group/@parameters/group nullable 1"
 , "set-attr Gtk/Widget/intersect/@parameters/intersection nullable 1"
 , "set-attr Gtk/Widget/modify_base/@parameters/color nullable 1"
 , "set-attr Gtk/Widget/modify_bg/@parameters/color nullable 1"
 , "set-attr Gtk/Widget/modify_cursor/@parameters/primary nullable 1"
 , "set-attr Gtk/Widget/modify_cursor/@parameters/secondary nullable 1"
 , "set-attr Gtk/Widget/modify_fg/@parameters/color nullable 1"
 , "set-attr Gtk/Widget/modify_font/@parameters/font_desc nullable 1"
 , "set-attr Gtk/Widget/modify_text/@parameters/color nullable 1"
 , "set-attr Gtk/Widget/override_background_color/@parameters/color nullable 1"
 , "set-attr Gtk/Widget/override_color/@parameters/color nullable 1"
 , "set-attr Gtk/Widget/override_cursor/@parameters/cursor nullable 1"
 , "set-attr Gtk/Widget/override_cursor/@parameters/secondary_cursor nullable 1"
 , "set-attr Gtk/Widget/override_font/@parameters/font_desc nullable 1"
 , "set-attr Gtk/Widget/override_symbolic_color/@parameters/color nullable 1"
 , "set-attr Gtk/Widget/render_icon/@return-value nullable 1"
 , "set-attr Gtk/Widget/render_icon/@parameters/detail nullable 1"
 , "set-attr Gtk/Widget/render_icon_pixbuf/@return-value nullable 1"
 , "set-attr Gtk/Widget/set_accel_path/@parameters/accel_path nullable 1"
 , "set-attr Gtk/Widget/set_accel_path/@parameters/accel_group nullable 1"
 , "set-attr Gtk/Widget/set_font_map/@parameters/font_map nullable 1"
 , "set-attr Gtk/Widget/set_font_options/@parameters/options nullable 1"
 , "set-attr Gtk/Widget/set_style/@parameters/style nullable 1"
 , "set-attr Gtk/Widget/set_tooltip_markup/@parameters/markup nullable 1"
 , "set-attr Gtk/Widget/set_tooltip_text/@parameters/text nullable 1"
 , "set-attr Gtk/Widget/set_tooltip_window/@parameters/custom_window nullable 1"
 , "set-attr Gtk/Widget/set_visual/@parameters/visual nullable 1"
 , "set-attr Gtk/Widget/shape_combine_region/@parameters/region nullable 1"
 , "set-attr Gtk/Widget/hierarchy-changed/@parameters/previous_toplevel nullable 1"
 , "set-attr Gtk/Widget/parent-set/@parameters/old_parent nullable 1"
 , "set-attr Gtk/Widget/screen-changed/@parameters/previous_screen nullable 1"
 , "set-attr Gtk/Widget/style-set/@parameters/previous_style nullable 1"
 , "set-attr Gtk/WidgetClass/set_connect_func/@parameters/connect_data nullable 1"
 , "set-attr Gtk/WidgetPath/iter_get_name/@return-value nullable 1"
 , "set-attr Gtk/WidgetPath/iter_get_object_name/@return-value nullable 1"
 , "set-attr Gtk/WidgetPath/iter_set_object_name/@parameters/name nullable 1"
 , "set-attr Gtk/Window/set_focus/@parameters/focus nullable 1"
 , "set-attr Gtk/Window/get_application/@return-value nullable 1"
 , "set-attr Gtk/Window/get_attached_to/@return-value nullable 1"
 , "set-attr Gtk/Window/get_default_widget/@return-value nullable 1"
 , "set-attr Gtk/Window/get_focus/@return-value nullable 1"
 , "set-attr Gtk/Window/get_group/@parameters/window nullable 1"
 , "set-attr Gtk/Window/get_icon_name/@return-value nullable 1"
 , "set-attr Gtk/Window/get_role/@return-value nullable 1"
 , "set-attr Gtk/Window/get_size/@parameters/width nullable 1"
 , "set-attr Gtk/Window/get_size/@parameters/height nullable 1"
 , "set-attr Gtk/Window/get_title/@return-value nullable 1"
 , "set-attr Gtk/Window/get_titlebar/@return-value nullable 1"
 , "set-attr Gtk/Window/get_transient_for/@return-value nullable 1"
 , "set-attr Gtk/Window/set_application/@parameters/application nullable 1"
 , "set-attr Gtk/Window/set_attached_to/@parameters/attach_widget nullable 1"
 , "set-attr Gtk/Window/set_default/@parameters/default_widget nullable 1"
 , "set-attr Gtk/Window/set_focus/@parameters/focus nullable 1"
 , "set-attr Gtk/Window/set_geometry_hints/@parameters/geometry_widget nullable 1"
 , "set-attr Gtk/Window/set_geometry_hints/@parameters/geometry nullable 1"
 , "set-attr Gtk/Window/set_icon/@parameters/icon nullable 1"
 , "set-attr Gtk/Window/set_icon_name/@parameters/name nullable 1"
 , "set-attr Gtk/Window/set_titlebar/@parameters/titlebar nullable 1"
 , "set-attr Gtk/Window/set_transient_for/@parameters/parent nullable 1"
 , "set-attr Gtk/WindowClass/set_focus/set_focus/@parameters/focus nullable 1"
 , "set-attr Gtk/WindowGroup/get_current_device_grab/@return-value nullable 1"
 , "set-attr Gtk/accelerator_get_label_with_keycode/@parameters/display nullable 1"
 , "set-attr Gtk/accelerator_name_with_keycode/@parameters/display nullable 1"
 , "set-attr Gtk/alternative_dialog_button_order/@parameters/screen nullable 1"
 , "set-attr Gtk/binding_set_by_class/@parameters/object_class nullable 1"
 , "set-attr Gtk/binding_set_find/@return-value nullable 1"
 , "set-attr Gtk/check_version/@return-value nullable 1"
 , "set-attr Gtk/get_current_event/@return-value nullable 1"
 , "set-attr Gtk/get_current_event_device/@return-value nullable 1"
 , "set-attr Gtk/get_event_widget/@return-value nullable 1"
 , "set-attr Gtk/grab_get_current/@return-value nullable 1"
 , "set-attr Gtk/init/@parameters/argv nullable 1"
 , "set-attr Gtk/init_check/@parameters/argv nullable 1"
 , "set-attr Gtk/init_with_args/@parameters/argv nullable 1"
 , "set-attr Gtk/init_with_args/@parameters/parameter_string nullable 1"
 , "set-attr Gtk/init_with_args/@parameters/translation_domain nullable 1"
 , "set-attr Gtk/key_snooper_install/@parameters/func_data nullable 1"
 , "set-attr Gtk/paint_arrow/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_arrow/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_box/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_box/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_box_gap/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_box_gap/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_check/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_check/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_diamond/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_diamond/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_expander/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_expander/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_extension/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_extension/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_flat_box/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_flat_box/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_focus/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_focus/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_handle/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_handle/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_hline/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_hline/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_layout/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_layout/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_option/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_option/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_resize_grip/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_resize_grip/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_shadow/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_shadow/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_shadow_gap/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_shadow_gap/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_slider/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_slider/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_spinner/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_spinner/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_tab/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_tab/@parameters/detail nullable 1"
 , "set-attr Gtk/paint_vline/@parameters/widget nullable 1"
 , "set-attr Gtk/paint_vline/@parameters/detail nullable 1"
 , "set-attr Gtk/print_run_page_setup_dialog/@parameters/parent nullable 1"
 , "set-attr Gtk/print_run_page_setup_dialog/@parameters/page_setup nullable 1"
 , "set-attr Gtk/print_run_page_setup_dialog_async/@parameters/parent nullable 1"
 , "set-attr Gtk/print_run_page_setup_dialog_async/@parameters/page_setup nullable 1"
 , "set-attr Gtk/print_run_page_setup_dialog_async/@parameters/data nullable 1"
 , "set-attr Gtk/rc_get_style_by_paths/@return-value nullable 1"
 , "set-attr Gtk/rc_get_style_by_paths/@parameters/widget_path nullable 1"
 , "set-attr Gtk/rc_get_style_by_paths/@parameters/class_path nullable 1"
 , "set-attr Gtk/rc_parse_color_full/@parameters/style nullable 1"
 , "set-attr Gtk/selection_owner_set/@parameters/widget nullable 1"
 , "set-attr Gtk/selection_owner_set_for_display/@parameters/widget nullable 1"
 , "set-attr Gtk/show_about_dialog/@parameters/parent nullable 1"
 , "set-attr Gtk/show_uri/@parameters/screen nullable 1"
 , "set-attr Gtk/show_uri_on_window/@parameters/parent nullable 1"
 , "set-attr Gtk/stock_set_translate_func/@parameters/data nullable 1"
 , "set-attr Gtk/test_create_widget/@parameters/first_property_name nullable 1"
 , "set-attr Gtk/test_find_widget/@return-value nullable 1"
 , "set-attr Gtk/tree_get_row_drag_data/@parameters/tree_model nullable 1"
 , "set-attr Gtk/tree_get_row_drag_data/@parameters/path nullable 1"]
