{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Structs.WidgetClass
    ( 

-- * Exported types
    WidgetClass(..)                         ,
    newZeroWidgetClass                      ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addShortcut]("GI.Gtk.Structs.WidgetClass#g:method:addShortcut"), [bindTemplateCallbackFull]("GI.Gtk.Structs.WidgetClass#g:method:bindTemplateCallbackFull"), [bindTemplateChildFull]("GI.Gtk.Structs.WidgetClass#g:method:bindTemplateChildFull"), [installAction]("GI.Gtk.Structs.WidgetClass#g:method:installAction"), [installPropertyAction]("GI.Gtk.Structs.WidgetClass#g:method:installPropertyAction"), [queryAction]("GI.Gtk.Structs.WidgetClass#g:method:queryAction").
-- 
-- ==== Getters
-- [getAccessibleRole]("GI.Gtk.Structs.WidgetClass#g:method:getAccessibleRole"), [getActivateSignal]("GI.Gtk.Structs.WidgetClass#g:method:getActivateSignal"), [getCssName]("GI.Gtk.Structs.WidgetClass#g:method:getCssName"), [getLayoutManagerType]("GI.Gtk.Structs.WidgetClass#g:method:getLayoutManagerType").
-- 
-- ==== Setters
-- [setAccessibleRole]("GI.Gtk.Structs.WidgetClass#g:method:setAccessibleRole"), [setActivateSignal]("GI.Gtk.Structs.WidgetClass#g:method:setActivateSignal"), [setActivateSignalFromName]("GI.Gtk.Structs.WidgetClass#g:method:setActivateSignalFromName"), [setCssName]("GI.Gtk.Structs.WidgetClass#g:method:setCssName"), [setLayoutManagerType]("GI.Gtk.Structs.WidgetClass#g:method:setLayoutManagerType"), [setTemplate]("GI.Gtk.Structs.WidgetClass#g:method:setTemplate"), [setTemplateFromResource]("GI.Gtk.Structs.WidgetClass#g:method:setTemplateFromResource"), [setTemplateScope]("GI.Gtk.Structs.WidgetClass#g:method:setTemplateScope").

#if defined(ENABLE_OVERLOADING)
    ResolveWidgetClassMethod                ,
#endif

-- ** addShortcut #method:addShortcut#

#if defined(ENABLE_OVERLOADING)
    WidgetClassAddShortcutMethodInfo        ,
#endif
    widgetClassAddShortcut                  ,


-- ** bindTemplateCallbackFull #method:bindTemplateCallbackFull#

#if defined(ENABLE_OVERLOADING)
    WidgetClassBindTemplateCallbackFullMethodInfo,
#endif
    widgetClassBindTemplateCallbackFull     ,


-- ** bindTemplateChildFull #method:bindTemplateChildFull#

#if defined(ENABLE_OVERLOADING)
    WidgetClassBindTemplateChildFullMethodInfo,
#endif
    widgetClassBindTemplateChildFull        ,


-- ** getAccessibleRole #method:getAccessibleRole#

#if defined(ENABLE_OVERLOADING)
    WidgetClassGetAccessibleRoleMethodInfo  ,
#endif
    widgetClassGetAccessibleRole            ,


-- ** getActivateSignal #method:getActivateSignal#

#if defined(ENABLE_OVERLOADING)
    WidgetClassGetActivateSignalMethodInfo  ,
#endif
    widgetClassGetActivateSignal            ,


-- ** getCssName #method:getCssName#

#if defined(ENABLE_OVERLOADING)
    WidgetClassGetCssNameMethodInfo         ,
#endif
    widgetClassGetCssName                   ,


-- ** getLayoutManagerType #method:getLayoutManagerType#

#if defined(ENABLE_OVERLOADING)
    WidgetClassGetLayoutManagerTypeMethodInfo,
#endif
    widgetClassGetLayoutManagerType         ,


-- ** installAction #method:installAction#

#if defined(ENABLE_OVERLOADING)
    WidgetClassInstallActionMethodInfo      ,
#endif
    widgetClassInstallAction                ,


-- ** installPropertyAction #method:installPropertyAction#

#if defined(ENABLE_OVERLOADING)
    WidgetClassInstallPropertyActionMethodInfo,
#endif
    widgetClassInstallPropertyAction        ,


-- ** queryAction #method:queryAction#

#if defined(ENABLE_OVERLOADING)
    WidgetClassQueryActionMethodInfo        ,
#endif
    widgetClassQueryAction                  ,


-- ** setAccessibleRole #method:setAccessibleRole#

#if defined(ENABLE_OVERLOADING)
    WidgetClassSetAccessibleRoleMethodInfo  ,
#endif
    widgetClassSetAccessibleRole            ,


-- ** setActivateSignal #method:setActivateSignal#

#if defined(ENABLE_OVERLOADING)
    WidgetClassSetActivateSignalMethodInfo  ,
#endif
    widgetClassSetActivateSignal            ,


-- ** setActivateSignalFromName #method:setActivateSignalFromName#

#if defined(ENABLE_OVERLOADING)
    WidgetClassSetActivateSignalFromNameMethodInfo,
#endif
    widgetClassSetActivateSignalFromName    ,


-- ** setCssName #method:setCssName#

#if defined(ENABLE_OVERLOADING)
    WidgetClassSetCssNameMethodInfo         ,
#endif
    widgetClassSetCssName                   ,


-- ** setLayoutManagerType #method:setLayoutManagerType#

#if defined(ENABLE_OVERLOADING)
    WidgetClassSetLayoutManagerTypeMethodInfo,
#endif
    widgetClassSetLayoutManagerType         ,


-- ** setTemplate #method:setTemplate#

#if defined(ENABLE_OVERLOADING)
    WidgetClassSetTemplateMethodInfo        ,
#endif
    widgetClassSetTemplate                  ,


-- ** setTemplateFromResource #method:setTemplateFromResource#

#if defined(ENABLE_OVERLOADING)
    WidgetClassSetTemplateFromResourceMethodInfo,
#endif
    widgetClassSetTemplateFromResource      ,


-- ** setTemplateScope #method:setTemplateScope#

#if defined(ENABLE_OVERLOADING)
    WidgetClassSetTemplateScopeMethodInfo   ,
#endif
    widgetClassSetTemplateScope             ,




 -- * Properties


-- ** computeExpand #attr:computeExpand#
-- | Computes whether a container should give this
--   widget extra space when possible.

    clearWidgetClassComputeExpand           ,
    getWidgetClassComputeExpand             ,
    setWidgetClassComputeExpand             ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_computeExpand               ,
#endif


-- ** contains #attr:contains#
-- | Vfunc for 'GI.Gtk.Objects.Widget.widgetContains'.

    clearWidgetClassContains                ,
    getWidgetClassContains                  ,
    setWidgetClassContains                  ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_contains                    ,
#endif


-- ** cssChanged #attr:cssChanged#
-- | Vfunc called when the CSS used by widget was changed. Widgets
--   should then discard their caches that depend on CSS and queue resizes or
--   redraws accordingly. The default implementation will take care of this for
--   all the default CSS properties, so implementations must chain up.

    clearWidgetClassCssChanged              ,
    getWidgetClassCssChanged                ,
    setWidgetClassCssChanged                ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_cssChanged                  ,
#endif


-- ** directionChanged #attr:directionChanged#
-- | Signal emitted when the text direction of a
--   widget changes.

    clearWidgetClassDirectionChanged        ,
    getWidgetClassDirectionChanged          ,
    setWidgetClassDirectionChanged          ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_directionChanged            ,
#endif


-- ** focus #attr:focus#
-- | Vfunc for 'GI.Gtk.Objects.Widget.widgetChildFocus'

    clearWidgetClassFocus                   ,
    getWidgetClassFocus                     ,
    setWidgetClassFocus                     ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_focus                       ,
#endif


-- ** getRequestMode #attr:getRequestMode#
-- | Called to get the request mode, if the widget
--   does not have a layout manager.
--   This allows a widget to tell its parent container whether
--   it prefers to be allocated in 'GI.Gtk.Enums.SizeRequestModeHeightForWidth' or
--   'GI.Gtk.Enums.SizeRequestModeWidthForHeight' mode.
--   'GI.Gtk.Enums.SizeRequestModeHeightForWidth' means the widget prefers to have
--   @GtkWidgetClass.measure()@ called first to get the default width (passing
--   a for_size of -1), then again to get the height for said default width.
--   'GI.Gtk.Enums.SizeRequestModeConstantSize' disables any height-for-width or
--   width-for-height geometry management for said widget and is the
--   default return.
--   It’s important to note that any widget
--   which trades height-for-width or width-for-height must respond properly
--   to a for_size value >= -1 passed to @GtkWidgetClass.measure@, for both
--   possible orientations.

    clearWidgetClassGetRequestMode          ,
    getWidgetClassGetRequestMode            ,
    setWidgetClassGetRequestMode            ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_getRequestMode              ,
#endif


-- ** grabFocus #attr:grabFocus#
-- | Causes /@widget@/ to have the keyboard focus for the
--   @GtkWindow@ it’s inside.

    clearWidgetClassGrabFocus               ,
    getWidgetClassGrabFocus                 ,
    setWidgetClassGrabFocus                 ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_grabFocus                   ,
#endif


-- ** hide #attr:hide#
-- | Signal emitted when widget is hidden.

    clearWidgetClassHide                    ,
    getWidgetClassHide                      ,
    setWidgetClassHide                      ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_hide                        ,
#endif


-- ** keynavFailed #attr:keynavFailed#
-- | Signal emitted if keyboard navigation fails.

    clearWidgetClassKeynavFailed            ,
    getWidgetClassKeynavFailed              ,
    setWidgetClassKeynavFailed              ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_keynavFailed                ,
#endif


-- ** map #attr:map#
-- | Signal emitted when widget is going to be mapped, that is
--   when the widget is visible (which is controlled with
--   'GI.Gtk.Objects.Widget.widgetSetVisible') and all its parents up to the toplevel
--   widget are also visible.

    clearWidgetClassMap                     ,
    getWidgetClassMap                       ,
    setWidgetClassMap                       ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_map                         ,
#endif


-- ** measure #attr:measure#
-- | Called to obtain the minimum and natural size of the widget,
--   if the widget does not have a layout manager.
--   Depending on the orientation parameter, the passed for_size can be
--   interpreted as width or height. A widget will never be allocated less
--   than its minimum size.

    clearWidgetClassMeasure                 ,
    getWidgetClassMeasure                   ,
    setWidgetClassMeasure                   ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_measure                     ,
#endif


-- ** mnemonicActivate #attr:mnemonicActivate#
-- | Activates the /@widget@/ if /@groupCycling@/ is
--   'P.False', and just grabs the focus if /@groupCycling@/ is 'P.True'.

    clearWidgetClassMnemonicActivate        ,
    getWidgetClassMnemonicActivate          ,
    setWidgetClassMnemonicActivate          ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_mnemonicActivate            ,
#endif


-- ** moveFocus #attr:moveFocus#
-- | Signal emitted when a change of focus is requested

    clearWidgetClassMoveFocus               ,
    getWidgetClassMoveFocus                 ,
    setWidgetClassMoveFocus                 ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_moveFocus                   ,
#endif


-- ** parentClass #attr:parentClass#
-- | The object class structure needs to be the first
--   element in the widget class structure in order for the class mechanism
--   to work correctly. This allows a GtkWidgetClass pointer to be cast to
--   a GObjectClass pointer.

    getWidgetClassParentClass               ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_parentClass                 ,
#endif


-- ** queryTooltip #attr:queryTooltip#
-- | Signal emitted when “has-tooltip” is 'P.True' and the
--   hover timeout has expired with the cursor hovering “above”
--   widget; or emitted when widget got focus in keyboard mode.

    clearWidgetClassQueryTooltip            ,
    getWidgetClassQueryTooltip              ,
    setWidgetClassQueryTooltip              ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_queryTooltip                ,
#endif


-- ** realize #attr:realize#
-- | Signal emitted when widget is associated with a
--   @GdkSurface@, which means that 'GI.Gtk.Objects.Widget.widgetRealize' has been called or
--   the widget has been mapped (that is, it is going to be drawn).

    clearWidgetClassRealize                 ,
    getWidgetClassRealize                   ,
    setWidgetClassRealize                   ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_realize                     ,
#endif


-- ** root #attr:root#
-- | Called when the widget gets added to a @GtkRoot@ widget. Must
--   chain up

    clearWidgetClassRoot                    ,
    getWidgetClassRoot                      ,
    setWidgetClassRoot                      ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_root                        ,
#endif


-- ** setFocusChild #attr:setFocusChild#
-- | Sets the focused child of a widget. Must chain up

    clearWidgetClassSetFocusChild           ,
    getWidgetClassSetFocusChild             ,
    setWidgetClassSetFocusChild             ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_setFocusChild               ,
#endif


-- ** show #attr:show#
-- | Signal emitted when widget is shown

    clearWidgetClassShow                    ,
    getWidgetClassShow                      ,
    setWidgetClassShow                      ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_show                        ,
#endif


-- ** sizeAllocate #attr:sizeAllocate#
-- | Called to set the allocation, if the widget does
--   not have a layout manager.

    clearWidgetClassSizeAllocate            ,
    getWidgetClassSizeAllocate              ,
    setWidgetClassSizeAllocate              ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_sizeAllocate                ,
#endif


-- ** snapshot #attr:snapshot#
-- | Vfunc called when a new snapshot of the widget has to be taken.

    clearWidgetClassSnapshot                ,
    getWidgetClassSnapshot                  ,
    setWidgetClassSnapshot                  ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_snapshot                    ,
#endif


-- ** stateFlagsChanged #attr:stateFlagsChanged#
-- | Signal emitted when the widget state changes,
--   see 'GI.Gtk.Objects.Widget.widgetGetStateFlags'.

    clearWidgetClassStateFlagsChanged       ,
    getWidgetClassStateFlagsChanged         ,
    setWidgetClassStateFlagsChanged         ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_stateFlagsChanged           ,
#endif


-- ** systemSettingChanged #attr:systemSettingChanged#
-- | Emitted when a system setting was changed. Must chain up.

    clearWidgetClassSystemSettingChanged    ,
    getWidgetClassSystemSettingChanged      ,
    setWidgetClassSystemSettingChanged      ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_systemSettingChanged        ,
#endif


-- ** unmap #attr:unmap#
-- | Signal emitted when widget is going to be unmapped, which
--   means that either it or any of its parents up to the toplevel
--   widget have been set as hidden.

    clearWidgetClassUnmap                   ,
    getWidgetClassUnmap                     ,
    setWidgetClassUnmap                     ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_unmap                       ,
#endif


-- ** unrealize #attr:unrealize#
-- | Signal emitted when the GdkSurface associated with
--   widget is destroyed, which means that 'GI.Gtk.Objects.Widget.widgetUnrealize' has
--   been called or the widget has been unmapped (that is, it is going
--   to be hidden).

    clearWidgetClassUnrealize               ,
    getWidgetClassUnrealize                 ,
    setWidgetClassUnrealize                 ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_unrealize                   ,
#endif


-- ** unroot #attr:unroot#
-- | Called when the widget is about to be removed from its
--   @GtkRoot@ widget. Must chain up

    clearWidgetClassUnroot                  ,
    getWidgetClassUnroot                    ,
    setWidgetClassUnroot                    ,
#if defined(ENABLE_OVERLOADING)
    widgetClass_unroot                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.InitiallyUnownedClass as GObject.InitiallyUnownedClass
import qualified GI.Gdk.Enums as Gdk.Enums
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.BuilderScope as Gtk.BuilderScope
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Shortcut as Gtk.Shortcut
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutAction as Gtk.ShortcutAction
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutTrigger as Gtk.ShortcutTrigger
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Structs.InitiallyUnownedClass as GObject.InitiallyUnownedClass
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.BuilderScope as Gtk.BuilderScope
import {-# SOURCE #-} qualified GI.Gtk.Objects.Shortcut as Gtk.Shortcut

#endif

-- | Memory-managed wrapper type.
newtype WidgetClass = WidgetClass (SP.ManagedPtr WidgetClass)
    deriving (Eq)

instance SP.ManagedPtrNewtype WidgetClass where
    toManagedPtr (WidgetClass p) = p

instance BoxedPtr WidgetClass where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 408 >=> B.ManagedPtr.wrapPtr WidgetClass)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr WidgetClass where
    boxedPtrCalloc = callocBytes 408


-- | Construct a `WidgetClass` struct initialized to zero.
newZeroWidgetClass :: MonadIO m => m WidgetClass
newZeroWidgetClass = liftIO $ boxedPtrCalloc >>= wrapPtr WidgetClass

instance tag ~ 'AttrSet => Constructible WidgetClass tag where
    new _ attrs = do
        o <- newZeroWidgetClass
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@parent_class@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #parentClass
-- @
getWidgetClassParentClass :: MonadIO m => WidgetClass -> m GObject.InitiallyUnownedClass.InitiallyUnownedClass
getWidgetClassParentClass s = liftIO $ withManagedPtr s $ \ptr -> do
    let val = ptr `plusPtr` 0 :: (Ptr GObject.InitiallyUnownedClass.InitiallyUnownedClass)
    val' <- (newPtr GObject.InitiallyUnownedClass.InitiallyUnownedClass) val
    return val'

#if defined(ENABLE_OVERLOADING)
data WidgetClassParentClassFieldInfo
instance AttrInfo WidgetClassParentClassFieldInfo where
    type AttrBaseTypeConstraint WidgetClassParentClassFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassParentClassFieldInfo = '[ 'AttrGet]
    type AttrSetTypeConstraint WidgetClassParentClassFieldInfo = (~) (Ptr GObject.InitiallyUnownedClass.InitiallyUnownedClass)
    type AttrTransferTypeConstraint WidgetClassParentClassFieldInfo = (~)(Ptr GObject.InitiallyUnownedClass.InitiallyUnownedClass)
    type AttrTransferType WidgetClassParentClassFieldInfo = (Ptr GObject.InitiallyUnownedClass.InitiallyUnownedClass)
    type AttrGetType WidgetClassParentClassFieldInfo = GObject.InitiallyUnownedClass.InitiallyUnownedClass
    type AttrLabel WidgetClassParentClassFieldInfo = "parent_class"
    type AttrOrigin WidgetClassParentClassFieldInfo = WidgetClass
    attrGet = getWidgetClassParentClass
    attrSet = undefined
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.parentClass"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:parentClass"
        })

widgetClass_parentClass :: AttrLabelProxy "parentClass"
widgetClass_parentClass = AttrLabelProxy

#endif


-- | Get the value of the “@show@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #show
-- @
getWidgetClassShow :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassShowFieldCallback)
getWidgetClassShow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 136) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassShowFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassShowFieldCallback val'
        return val''
    return result

-- | Set the value of the “@show@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #show 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassShow :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassShowFieldCallback -> m ()
setWidgetClassShow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 136) (val :: FunPtr Gtk.Callbacks.C_WidgetClassShowFieldCallback)

-- | Set the value of the “@show@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #show
-- @
clearWidgetClassShow :: MonadIO m => WidgetClass -> m ()
clearWidgetClassShow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 136) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassShowFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassShowFieldInfo
instance AttrInfo WidgetClassShowFieldInfo where
    type AttrBaseTypeConstraint WidgetClassShowFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassShowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassShowFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassShowFieldCallback)
    type AttrTransferTypeConstraint WidgetClassShowFieldInfo = (~)Gtk.Callbacks.WidgetClassShowFieldCallback
    type AttrTransferType WidgetClassShowFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassShowFieldCallback)
    type AttrGetType WidgetClassShowFieldInfo = Maybe Gtk.Callbacks.WidgetClassShowFieldCallback
    type AttrLabel WidgetClassShowFieldInfo = "show"
    type AttrOrigin WidgetClassShowFieldInfo = WidgetClass
    attrGet = getWidgetClassShow
    attrSet = setWidgetClassShow
    attrConstruct = undefined
    attrClear = clearWidgetClassShow
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassShowFieldCallback (Gtk.Callbacks.wrap_WidgetClassShowFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.show"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:show"
        })

widgetClass_show :: AttrLabelProxy "show"
widgetClass_show = AttrLabelProxy

#endif


-- | Get the value of the “@hide@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #hide
-- @
getWidgetClassHide :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassHideFieldCallback)
getWidgetClassHide s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 144) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassHideFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassHideFieldCallback val'
        return val''
    return result

-- | Set the value of the “@hide@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #hide 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassHide :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassHideFieldCallback -> m ()
setWidgetClassHide s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 144) (val :: FunPtr Gtk.Callbacks.C_WidgetClassHideFieldCallback)

-- | Set the value of the “@hide@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #hide
-- @
clearWidgetClassHide :: MonadIO m => WidgetClass -> m ()
clearWidgetClassHide s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 144) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassHideFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassHideFieldInfo
instance AttrInfo WidgetClassHideFieldInfo where
    type AttrBaseTypeConstraint WidgetClassHideFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassHideFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassHideFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassHideFieldCallback)
    type AttrTransferTypeConstraint WidgetClassHideFieldInfo = (~)Gtk.Callbacks.WidgetClassHideFieldCallback
    type AttrTransferType WidgetClassHideFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassHideFieldCallback)
    type AttrGetType WidgetClassHideFieldInfo = Maybe Gtk.Callbacks.WidgetClassHideFieldCallback
    type AttrLabel WidgetClassHideFieldInfo = "hide"
    type AttrOrigin WidgetClassHideFieldInfo = WidgetClass
    attrGet = getWidgetClassHide
    attrSet = setWidgetClassHide
    attrConstruct = undefined
    attrClear = clearWidgetClassHide
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassHideFieldCallback (Gtk.Callbacks.wrap_WidgetClassHideFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.hide"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:hide"
        })

widgetClass_hide :: AttrLabelProxy "hide"
widgetClass_hide = AttrLabelProxy

#endif


-- | Get the value of the “@map@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #map
-- @
getWidgetClassMap :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassMapFieldCallback)
getWidgetClassMap s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 152) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassMapFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassMapFieldCallback val'
        return val''
    return result

-- | Set the value of the “@map@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #map 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassMap :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassMapFieldCallback -> m ()
setWidgetClassMap s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 152) (val :: FunPtr Gtk.Callbacks.C_WidgetClassMapFieldCallback)

-- | Set the value of the “@map@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #map
-- @
clearWidgetClassMap :: MonadIO m => WidgetClass -> m ()
clearWidgetClassMap s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 152) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassMapFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassMapFieldInfo
instance AttrInfo WidgetClassMapFieldInfo where
    type AttrBaseTypeConstraint WidgetClassMapFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassMapFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassMapFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassMapFieldCallback)
    type AttrTransferTypeConstraint WidgetClassMapFieldInfo = (~)Gtk.Callbacks.WidgetClassMapFieldCallback
    type AttrTransferType WidgetClassMapFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassMapFieldCallback)
    type AttrGetType WidgetClassMapFieldInfo = Maybe Gtk.Callbacks.WidgetClassMapFieldCallback
    type AttrLabel WidgetClassMapFieldInfo = "map"
    type AttrOrigin WidgetClassMapFieldInfo = WidgetClass
    attrGet = getWidgetClassMap
    attrSet = setWidgetClassMap
    attrConstruct = undefined
    attrClear = clearWidgetClassMap
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassMapFieldCallback (Gtk.Callbacks.wrap_WidgetClassMapFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.map"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:map"
        })

widgetClass_map :: AttrLabelProxy "map"
widgetClass_map = AttrLabelProxy

#endif


-- | Get the value of the “@unmap@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #unmap
-- @
getWidgetClassUnmap :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassUnmapFieldCallback)
getWidgetClassUnmap s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 160) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassUnmapFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassUnmapFieldCallback val'
        return val''
    return result

-- | Set the value of the “@unmap@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #unmap 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassUnmap :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassUnmapFieldCallback -> m ()
setWidgetClassUnmap s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 160) (val :: FunPtr Gtk.Callbacks.C_WidgetClassUnmapFieldCallback)

-- | Set the value of the “@unmap@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #unmap
-- @
clearWidgetClassUnmap :: MonadIO m => WidgetClass -> m ()
clearWidgetClassUnmap s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 160) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassUnmapFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassUnmapFieldInfo
instance AttrInfo WidgetClassUnmapFieldInfo where
    type AttrBaseTypeConstraint WidgetClassUnmapFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassUnmapFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassUnmapFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassUnmapFieldCallback)
    type AttrTransferTypeConstraint WidgetClassUnmapFieldInfo = (~)Gtk.Callbacks.WidgetClassUnmapFieldCallback
    type AttrTransferType WidgetClassUnmapFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassUnmapFieldCallback)
    type AttrGetType WidgetClassUnmapFieldInfo = Maybe Gtk.Callbacks.WidgetClassUnmapFieldCallback
    type AttrLabel WidgetClassUnmapFieldInfo = "unmap"
    type AttrOrigin WidgetClassUnmapFieldInfo = WidgetClass
    attrGet = getWidgetClassUnmap
    attrSet = setWidgetClassUnmap
    attrConstruct = undefined
    attrClear = clearWidgetClassUnmap
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassUnmapFieldCallback (Gtk.Callbacks.wrap_WidgetClassUnmapFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.unmap"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:unmap"
        })

widgetClass_unmap :: AttrLabelProxy "unmap"
widgetClass_unmap = AttrLabelProxy

#endif


-- | Get the value of the “@realize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #realize
-- @
getWidgetClassRealize :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassRealizeFieldCallback)
getWidgetClassRealize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 168) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassRealizeFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassRealizeFieldCallback val'
        return val''
    return result

-- | Set the value of the “@realize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #realize 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassRealize :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassRealizeFieldCallback -> m ()
setWidgetClassRealize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 168) (val :: FunPtr Gtk.Callbacks.C_WidgetClassRealizeFieldCallback)

-- | Set the value of the “@realize@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #realize
-- @
clearWidgetClassRealize :: MonadIO m => WidgetClass -> m ()
clearWidgetClassRealize s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 168) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassRealizeFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassRealizeFieldInfo
instance AttrInfo WidgetClassRealizeFieldInfo where
    type AttrBaseTypeConstraint WidgetClassRealizeFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassRealizeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassRealizeFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassRealizeFieldCallback)
    type AttrTransferTypeConstraint WidgetClassRealizeFieldInfo = (~)Gtk.Callbacks.WidgetClassRealizeFieldCallback
    type AttrTransferType WidgetClassRealizeFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassRealizeFieldCallback)
    type AttrGetType WidgetClassRealizeFieldInfo = Maybe Gtk.Callbacks.WidgetClassRealizeFieldCallback
    type AttrLabel WidgetClassRealizeFieldInfo = "realize"
    type AttrOrigin WidgetClassRealizeFieldInfo = WidgetClass
    attrGet = getWidgetClassRealize
    attrSet = setWidgetClassRealize
    attrConstruct = undefined
    attrClear = clearWidgetClassRealize
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassRealizeFieldCallback (Gtk.Callbacks.wrap_WidgetClassRealizeFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.realize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:realize"
        })

widgetClass_realize :: AttrLabelProxy "realize"
widgetClass_realize = AttrLabelProxy

#endif


-- | Get the value of the “@unrealize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #unrealize
-- @
getWidgetClassUnrealize :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassUnrealizeFieldCallback)
getWidgetClassUnrealize s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 176) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassUnrealizeFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassUnrealizeFieldCallback val'
        return val''
    return result

-- | Set the value of the “@unrealize@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #unrealize 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassUnrealize :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassUnrealizeFieldCallback -> m ()
setWidgetClassUnrealize s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 176) (val :: FunPtr Gtk.Callbacks.C_WidgetClassUnrealizeFieldCallback)

-- | Set the value of the “@unrealize@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #unrealize
-- @
clearWidgetClassUnrealize :: MonadIO m => WidgetClass -> m ()
clearWidgetClassUnrealize s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 176) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassUnrealizeFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassUnrealizeFieldInfo
instance AttrInfo WidgetClassUnrealizeFieldInfo where
    type AttrBaseTypeConstraint WidgetClassUnrealizeFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassUnrealizeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassUnrealizeFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassUnrealizeFieldCallback)
    type AttrTransferTypeConstraint WidgetClassUnrealizeFieldInfo = (~)Gtk.Callbacks.WidgetClassUnrealizeFieldCallback
    type AttrTransferType WidgetClassUnrealizeFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassUnrealizeFieldCallback)
    type AttrGetType WidgetClassUnrealizeFieldInfo = Maybe Gtk.Callbacks.WidgetClassUnrealizeFieldCallback
    type AttrLabel WidgetClassUnrealizeFieldInfo = "unrealize"
    type AttrOrigin WidgetClassUnrealizeFieldInfo = WidgetClass
    attrGet = getWidgetClassUnrealize
    attrSet = setWidgetClassUnrealize
    attrConstruct = undefined
    attrClear = clearWidgetClassUnrealize
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassUnrealizeFieldCallback (Gtk.Callbacks.wrap_WidgetClassUnrealizeFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.unrealize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:unrealize"
        })

widgetClass_unrealize :: AttrLabelProxy "unrealize"
widgetClass_unrealize = AttrLabelProxy

#endif


-- | Get the value of the “@root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #root
-- @
getWidgetClassRoot :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassRootFieldCallback)
getWidgetClassRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 184) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassRootFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassRootFieldCallback val'
        return val''
    return result

-- | Set the value of the “@root@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #root 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassRoot :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassRootFieldCallback -> m ()
setWidgetClassRoot s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 184) (val :: FunPtr Gtk.Callbacks.C_WidgetClassRootFieldCallback)

-- | Set the value of the “@root@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #root
-- @
clearWidgetClassRoot :: MonadIO m => WidgetClass -> m ()
clearWidgetClassRoot s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 184) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassRootFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassRootFieldInfo
instance AttrInfo WidgetClassRootFieldInfo where
    type AttrBaseTypeConstraint WidgetClassRootFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassRootFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassRootFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassRootFieldCallback)
    type AttrTransferTypeConstraint WidgetClassRootFieldInfo = (~)Gtk.Callbacks.WidgetClassRootFieldCallback
    type AttrTransferType WidgetClassRootFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassRootFieldCallback)
    type AttrGetType WidgetClassRootFieldInfo = Maybe Gtk.Callbacks.WidgetClassRootFieldCallback
    type AttrLabel WidgetClassRootFieldInfo = "root"
    type AttrOrigin WidgetClassRootFieldInfo = WidgetClass
    attrGet = getWidgetClassRoot
    attrSet = setWidgetClassRoot
    attrConstruct = undefined
    attrClear = clearWidgetClassRoot
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassRootFieldCallback (Gtk.Callbacks.wrap_WidgetClassRootFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.root"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:root"
        })

widgetClass_root :: AttrLabelProxy "root"
widgetClass_root = AttrLabelProxy

#endif


-- | Get the value of the “@unroot@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #unroot
-- @
getWidgetClassUnroot :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassUnrootFieldCallback)
getWidgetClassUnroot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 192) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassUnrootFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassUnrootFieldCallback val'
        return val''
    return result

-- | Set the value of the “@unroot@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #unroot 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassUnroot :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassUnrootFieldCallback -> m ()
setWidgetClassUnroot s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 192) (val :: FunPtr Gtk.Callbacks.C_WidgetClassUnrootFieldCallback)

-- | Set the value of the “@unroot@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #unroot
-- @
clearWidgetClassUnroot :: MonadIO m => WidgetClass -> m ()
clearWidgetClassUnroot s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 192) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassUnrootFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassUnrootFieldInfo
instance AttrInfo WidgetClassUnrootFieldInfo where
    type AttrBaseTypeConstraint WidgetClassUnrootFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassUnrootFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassUnrootFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassUnrootFieldCallback)
    type AttrTransferTypeConstraint WidgetClassUnrootFieldInfo = (~)Gtk.Callbacks.WidgetClassUnrootFieldCallback
    type AttrTransferType WidgetClassUnrootFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassUnrootFieldCallback)
    type AttrGetType WidgetClassUnrootFieldInfo = Maybe Gtk.Callbacks.WidgetClassUnrootFieldCallback
    type AttrLabel WidgetClassUnrootFieldInfo = "unroot"
    type AttrOrigin WidgetClassUnrootFieldInfo = WidgetClass
    attrGet = getWidgetClassUnroot
    attrSet = setWidgetClassUnroot
    attrConstruct = undefined
    attrClear = clearWidgetClassUnroot
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassUnrootFieldCallback (Gtk.Callbacks.wrap_WidgetClassUnrootFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.unroot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:unroot"
        })

widgetClass_unroot :: AttrLabelProxy "unroot"
widgetClass_unroot = AttrLabelProxy

#endif


-- | Get the value of the “@size_allocate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #sizeAllocate
-- @
getWidgetClassSizeAllocate :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassSizeAllocateFieldCallback)
getWidgetClassSizeAllocate s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 200) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassSizeAllocateFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassSizeAllocateFieldCallback val'
        return val''
    return result

-- | Set the value of the “@size_allocate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #sizeAllocate 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassSizeAllocate :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassSizeAllocateFieldCallback -> m ()
setWidgetClassSizeAllocate s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 200) (val :: FunPtr Gtk.Callbacks.C_WidgetClassSizeAllocateFieldCallback)

-- | Set the value of the “@size_allocate@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #sizeAllocate
-- @
clearWidgetClassSizeAllocate :: MonadIO m => WidgetClass -> m ()
clearWidgetClassSizeAllocate s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 200) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassSizeAllocateFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassSizeAllocateFieldInfo
instance AttrInfo WidgetClassSizeAllocateFieldInfo where
    type AttrBaseTypeConstraint WidgetClassSizeAllocateFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassSizeAllocateFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassSizeAllocateFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassSizeAllocateFieldCallback)
    type AttrTransferTypeConstraint WidgetClassSizeAllocateFieldInfo = (~)Gtk.Callbacks.WidgetClassSizeAllocateFieldCallback
    type AttrTransferType WidgetClassSizeAllocateFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassSizeAllocateFieldCallback)
    type AttrGetType WidgetClassSizeAllocateFieldInfo = Maybe Gtk.Callbacks.WidgetClassSizeAllocateFieldCallback
    type AttrLabel WidgetClassSizeAllocateFieldInfo = "size_allocate"
    type AttrOrigin WidgetClassSizeAllocateFieldInfo = WidgetClass
    attrGet = getWidgetClassSizeAllocate
    attrSet = setWidgetClassSizeAllocate
    attrConstruct = undefined
    attrClear = clearWidgetClassSizeAllocate
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassSizeAllocateFieldCallback (Gtk.Callbacks.wrap_WidgetClassSizeAllocateFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.sizeAllocate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:sizeAllocate"
        })

widgetClass_sizeAllocate :: AttrLabelProxy "sizeAllocate"
widgetClass_sizeAllocate = AttrLabelProxy

#endif


-- | Get the value of the “@state_flags_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #stateFlagsChanged
-- @
getWidgetClassStateFlagsChanged :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassStateFlagsChangedFieldCallback)
getWidgetClassStateFlagsChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 208) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassStateFlagsChangedFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassStateFlagsChangedFieldCallback val'
        return val''
    return result

-- | Set the value of the “@state_flags_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #stateFlagsChanged 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassStateFlagsChanged :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassStateFlagsChangedFieldCallback -> m ()
setWidgetClassStateFlagsChanged s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 208) (val :: FunPtr Gtk.Callbacks.C_WidgetClassStateFlagsChangedFieldCallback)

-- | Set the value of the “@state_flags_changed@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #stateFlagsChanged
-- @
clearWidgetClassStateFlagsChanged :: MonadIO m => WidgetClass -> m ()
clearWidgetClassStateFlagsChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 208) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassStateFlagsChangedFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassStateFlagsChangedFieldInfo
instance AttrInfo WidgetClassStateFlagsChangedFieldInfo where
    type AttrBaseTypeConstraint WidgetClassStateFlagsChangedFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassStateFlagsChangedFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassStateFlagsChangedFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassStateFlagsChangedFieldCallback)
    type AttrTransferTypeConstraint WidgetClassStateFlagsChangedFieldInfo = (~)Gtk.Callbacks.WidgetClassStateFlagsChangedFieldCallback
    type AttrTransferType WidgetClassStateFlagsChangedFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassStateFlagsChangedFieldCallback)
    type AttrGetType WidgetClassStateFlagsChangedFieldInfo = Maybe Gtk.Callbacks.WidgetClassStateFlagsChangedFieldCallback
    type AttrLabel WidgetClassStateFlagsChangedFieldInfo = "state_flags_changed"
    type AttrOrigin WidgetClassStateFlagsChangedFieldInfo = WidgetClass
    attrGet = getWidgetClassStateFlagsChanged
    attrSet = setWidgetClassStateFlagsChanged
    attrConstruct = undefined
    attrClear = clearWidgetClassStateFlagsChanged
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassStateFlagsChangedFieldCallback (Gtk.Callbacks.wrap_WidgetClassStateFlagsChangedFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.stateFlagsChanged"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:stateFlagsChanged"
        })

widgetClass_stateFlagsChanged :: AttrLabelProxy "stateFlagsChanged"
widgetClass_stateFlagsChanged = AttrLabelProxy

#endif


-- | Get the value of the “@direction_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #directionChanged
-- @
getWidgetClassDirectionChanged :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassDirectionChangedFieldCallback)
getWidgetClassDirectionChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 216) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassDirectionChangedFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassDirectionChangedFieldCallback val'
        return val''
    return result

-- | Set the value of the “@direction_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #directionChanged 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassDirectionChanged :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassDirectionChangedFieldCallback -> m ()
setWidgetClassDirectionChanged s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 216) (val :: FunPtr Gtk.Callbacks.C_WidgetClassDirectionChangedFieldCallback)

-- | Set the value of the “@direction_changed@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #directionChanged
-- @
clearWidgetClassDirectionChanged :: MonadIO m => WidgetClass -> m ()
clearWidgetClassDirectionChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 216) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassDirectionChangedFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassDirectionChangedFieldInfo
instance AttrInfo WidgetClassDirectionChangedFieldInfo where
    type AttrBaseTypeConstraint WidgetClassDirectionChangedFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassDirectionChangedFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassDirectionChangedFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassDirectionChangedFieldCallback)
    type AttrTransferTypeConstraint WidgetClassDirectionChangedFieldInfo = (~)Gtk.Callbacks.WidgetClassDirectionChangedFieldCallback
    type AttrTransferType WidgetClassDirectionChangedFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassDirectionChangedFieldCallback)
    type AttrGetType WidgetClassDirectionChangedFieldInfo = Maybe Gtk.Callbacks.WidgetClassDirectionChangedFieldCallback
    type AttrLabel WidgetClassDirectionChangedFieldInfo = "direction_changed"
    type AttrOrigin WidgetClassDirectionChangedFieldInfo = WidgetClass
    attrGet = getWidgetClassDirectionChanged
    attrSet = setWidgetClassDirectionChanged
    attrConstruct = undefined
    attrClear = clearWidgetClassDirectionChanged
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassDirectionChangedFieldCallback (Gtk.Callbacks.wrap_WidgetClassDirectionChangedFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.directionChanged"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:directionChanged"
        })

widgetClass_directionChanged :: AttrLabelProxy "directionChanged"
widgetClass_directionChanged = AttrLabelProxy

#endif


-- | Get the value of the “@get_request_mode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #getRequestMode
-- @
getWidgetClassGetRequestMode :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassGetRequestModeFieldCallback)
getWidgetClassGetRequestMode s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 224) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassGetRequestModeFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassGetRequestModeFieldCallback val'
        return val''
    return result

-- | Set the value of the “@get_request_mode@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #getRequestMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassGetRequestMode :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassGetRequestModeFieldCallback -> m ()
setWidgetClassGetRequestMode s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 224) (val :: FunPtr Gtk.Callbacks.C_WidgetClassGetRequestModeFieldCallback)

-- | Set the value of the “@get_request_mode@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #getRequestMode
-- @
clearWidgetClassGetRequestMode :: MonadIO m => WidgetClass -> m ()
clearWidgetClassGetRequestMode s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 224) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassGetRequestModeFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassGetRequestModeFieldInfo
instance AttrInfo WidgetClassGetRequestModeFieldInfo where
    type AttrBaseTypeConstraint WidgetClassGetRequestModeFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassGetRequestModeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassGetRequestModeFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassGetRequestModeFieldCallback)
    type AttrTransferTypeConstraint WidgetClassGetRequestModeFieldInfo = (~)Gtk.Callbacks.WidgetClassGetRequestModeFieldCallback
    type AttrTransferType WidgetClassGetRequestModeFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassGetRequestModeFieldCallback)
    type AttrGetType WidgetClassGetRequestModeFieldInfo = Maybe Gtk.Callbacks.WidgetClassGetRequestModeFieldCallback
    type AttrLabel WidgetClassGetRequestModeFieldInfo = "get_request_mode"
    type AttrOrigin WidgetClassGetRequestModeFieldInfo = WidgetClass
    attrGet = getWidgetClassGetRequestMode
    attrSet = setWidgetClassGetRequestMode
    attrConstruct = undefined
    attrClear = clearWidgetClassGetRequestMode
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassGetRequestModeFieldCallback (Gtk.Callbacks.wrap_WidgetClassGetRequestModeFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.getRequestMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:getRequestMode"
        })

widgetClass_getRequestMode :: AttrLabelProxy "getRequestMode"
widgetClass_getRequestMode = AttrLabelProxy

#endif


-- | Get the value of the “@measure@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #measure
-- @
getWidgetClassMeasure :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassMeasureFieldCallback)
getWidgetClassMeasure s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 232) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassMeasureFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassMeasureFieldCallback val'
        return val''
    return result

-- | Set the value of the “@measure@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #measure 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassMeasure :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassMeasureFieldCallback -> m ()
setWidgetClassMeasure s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 232) (val :: FunPtr Gtk.Callbacks.C_WidgetClassMeasureFieldCallback)

-- | Set the value of the “@measure@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #measure
-- @
clearWidgetClassMeasure :: MonadIO m => WidgetClass -> m ()
clearWidgetClassMeasure s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 232) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassMeasureFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassMeasureFieldInfo
instance AttrInfo WidgetClassMeasureFieldInfo where
    type AttrBaseTypeConstraint WidgetClassMeasureFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassMeasureFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassMeasureFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassMeasureFieldCallback)
    type AttrTransferTypeConstraint WidgetClassMeasureFieldInfo = (~)Gtk.Callbacks.WidgetClassMeasureFieldCallback
    type AttrTransferType WidgetClassMeasureFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassMeasureFieldCallback)
    type AttrGetType WidgetClassMeasureFieldInfo = Maybe Gtk.Callbacks.WidgetClassMeasureFieldCallback
    type AttrLabel WidgetClassMeasureFieldInfo = "measure"
    type AttrOrigin WidgetClassMeasureFieldInfo = WidgetClass
    attrGet = getWidgetClassMeasure
    attrSet = setWidgetClassMeasure
    attrConstruct = undefined
    attrClear = clearWidgetClassMeasure
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassMeasureFieldCallback (Gtk.Callbacks.wrap_WidgetClassMeasureFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.measure"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:measure"
        })

widgetClass_measure :: AttrLabelProxy "measure"
widgetClass_measure = AttrLabelProxy

#endif


-- | Get the value of the “@mnemonic_activate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #mnemonicActivate
-- @
getWidgetClassMnemonicActivate :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassMnemonicActivateFieldCallback)
getWidgetClassMnemonicActivate s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 240) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassMnemonicActivateFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassMnemonicActivateFieldCallback val'
        return val''
    return result

-- | Set the value of the “@mnemonic_activate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #mnemonicActivate 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassMnemonicActivate :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassMnemonicActivateFieldCallback -> m ()
setWidgetClassMnemonicActivate s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 240) (val :: FunPtr Gtk.Callbacks.C_WidgetClassMnemonicActivateFieldCallback)

-- | Set the value of the “@mnemonic_activate@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #mnemonicActivate
-- @
clearWidgetClassMnemonicActivate :: MonadIO m => WidgetClass -> m ()
clearWidgetClassMnemonicActivate s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 240) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassMnemonicActivateFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassMnemonicActivateFieldInfo
instance AttrInfo WidgetClassMnemonicActivateFieldInfo where
    type AttrBaseTypeConstraint WidgetClassMnemonicActivateFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassMnemonicActivateFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassMnemonicActivateFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassMnemonicActivateFieldCallback)
    type AttrTransferTypeConstraint WidgetClassMnemonicActivateFieldInfo = (~)Gtk.Callbacks.WidgetClassMnemonicActivateFieldCallback
    type AttrTransferType WidgetClassMnemonicActivateFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassMnemonicActivateFieldCallback)
    type AttrGetType WidgetClassMnemonicActivateFieldInfo = Maybe Gtk.Callbacks.WidgetClassMnemonicActivateFieldCallback
    type AttrLabel WidgetClassMnemonicActivateFieldInfo = "mnemonic_activate"
    type AttrOrigin WidgetClassMnemonicActivateFieldInfo = WidgetClass
    attrGet = getWidgetClassMnemonicActivate
    attrSet = setWidgetClassMnemonicActivate
    attrConstruct = undefined
    attrClear = clearWidgetClassMnemonicActivate
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassMnemonicActivateFieldCallback (Gtk.Callbacks.wrap_WidgetClassMnemonicActivateFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.mnemonicActivate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:mnemonicActivate"
        })

widgetClass_mnemonicActivate :: AttrLabelProxy "mnemonicActivate"
widgetClass_mnemonicActivate = AttrLabelProxy

#endif


-- | Get the value of the “@grab_focus@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #grabFocus
-- @
getWidgetClassGrabFocus :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassGrabFocusFieldCallback)
getWidgetClassGrabFocus s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 248) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassGrabFocusFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassGrabFocusFieldCallback val'
        return val''
    return result

-- | Set the value of the “@grab_focus@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #grabFocus 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassGrabFocus :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassGrabFocusFieldCallback -> m ()
setWidgetClassGrabFocus s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 248) (val :: FunPtr Gtk.Callbacks.C_WidgetClassGrabFocusFieldCallback)

-- | Set the value of the “@grab_focus@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #grabFocus
-- @
clearWidgetClassGrabFocus :: MonadIO m => WidgetClass -> m ()
clearWidgetClassGrabFocus s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 248) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassGrabFocusFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassGrabFocusFieldInfo
instance AttrInfo WidgetClassGrabFocusFieldInfo where
    type AttrBaseTypeConstraint WidgetClassGrabFocusFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassGrabFocusFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassGrabFocusFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassGrabFocusFieldCallback)
    type AttrTransferTypeConstraint WidgetClassGrabFocusFieldInfo = (~)Gtk.Callbacks.WidgetClassGrabFocusFieldCallback
    type AttrTransferType WidgetClassGrabFocusFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassGrabFocusFieldCallback)
    type AttrGetType WidgetClassGrabFocusFieldInfo = Maybe Gtk.Callbacks.WidgetClassGrabFocusFieldCallback
    type AttrLabel WidgetClassGrabFocusFieldInfo = "grab_focus"
    type AttrOrigin WidgetClassGrabFocusFieldInfo = WidgetClass
    attrGet = getWidgetClassGrabFocus
    attrSet = setWidgetClassGrabFocus
    attrConstruct = undefined
    attrClear = clearWidgetClassGrabFocus
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassGrabFocusFieldCallback (Gtk.Callbacks.wrap_WidgetClassGrabFocusFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.grabFocus"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:grabFocus"
        })

widgetClass_grabFocus :: AttrLabelProxy "grabFocus"
widgetClass_grabFocus = AttrLabelProxy

#endif


-- | Get the value of the “@focus@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #focus
-- @
getWidgetClassFocus :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassFocusFieldCallback)
getWidgetClassFocus s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 256) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassFocusFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassFocusFieldCallback val'
        return val''
    return result

-- | Set the value of the “@focus@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #focus 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassFocus :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassFocusFieldCallback -> m ()
setWidgetClassFocus s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 256) (val :: FunPtr Gtk.Callbacks.C_WidgetClassFocusFieldCallback)

-- | Set the value of the “@focus@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #focus
-- @
clearWidgetClassFocus :: MonadIO m => WidgetClass -> m ()
clearWidgetClassFocus s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 256) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassFocusFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassFocusFieldInfo
instance AttrInfo WidgetClassFocusFieldInfo where
    type AttrBaseTypeConstraint WidgetClassFocusFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassFocusFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassFocusFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassFocusFieldCallback)
    type AttrTransferTypeConstraint WidgetClassFocusFieldInfo = (~)Gtk.Callbacks.WidgetClassFocusFieldCallback
    type AttrTransferType WidgetClassFocusFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassFocusFieldCallback)
    type AttrGetType WidgetClassFocusFieldInfo = Maybe Gtk.Callbacks.WidgetClassFocusFieldCallback
    type AttrLabel WidgetClassFocusFieldInfo = "focus"
    type AttrOrigin WidgetClassFocusFieldInfo = WidgetClass
    attrGet = getWidgetClassFocus
    attrSet = setWidgetClassFocus
    attrConstruct = undefined
    attrClear = clearWidgetClassFocus
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassFocusFieldCallback (Gtk.Callbacks.wrap_WidgetClassFocusFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.focus"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:focus"
        })

widgetClass_focus :: AttrLabelProxy "focus"
widgetClass_focus = AttrLabelProxy

#endif


-- | Get the value of the “@set_focus_child@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #setFocusChild
-- @
getWidgetClassSetFocusChild :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassSetFocusChildFieldCallback)
getWidgetClassSetFocusChild s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 264) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassSetFocusChildFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassSetFocusChildFieldCallback val'
        return val''
    return result

-- | Set the value of the “@set_focus_child@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #setFocusChild 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassSetFocusChild :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassSetFocusChildFieldCallback -> m ()
setWidgetClassSetFocusChild s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 264) (val :: FunPtr Gtk.Callbacks.C_WidgetClassSetFocusChildFieldCallback)

-- | Set the value of the “@set_focus_child@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #setFocusChild
-- @
clearWidgetClassSetFocusChild :: MonadIO m => WidgetClass -> m ()
clearWidgetClassSetFocusChild s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 264) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassSetFocusChildFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassSetFocusChildFieldInfo
instance AttrInfo WidgetClassSetFocusChildFieldInfo where
    type AttrBaseTypeConstraint WidgetClassSetFocusChildFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassSetFocusChildFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassSetFocusChildFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassSetFocusChildFieldCallback)
    type AttrTransferTypeConstraint WidgetClassSetFocusChildFieldInfo = (~)Gtk.Callbacks.WidgetClassSetFocusChildFieldCallback
    type AttrTransferType WidgetClassSetFocusChildFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassSetFocusChildFieldCallback)
    type AttrGetType WidgetClassSetFocusChildFieldInfo = Maybe Gtk.Callbacks.WidgetClassSetFocusChildFieldCallback
    type AttrLabel WidgetClassSetFocusChildFieldInfo = "set_focus_child"
    type AttrOrigin WidgetClassSetFocusChildFieldInfo = WidgetClass
    attrGet = getWidgetClassSetFocusChild
    attrSet = setWidgetClassSetFocusChild
    attrConstruct = undefined
    attrClear = clearWidgetClassSetFocusChild
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassSetFocusChildFieldCallback (Gtk.Callbacks.wrap_WidgetClassSetFocusChildFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.setFocusChild"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:setFocusChild"
        })

widgetClass_setFocusChild :: AttrLabelProxy "setFocusChild"
widgetClass_setFocusChild = AttrLabelProxy

#endif


-- | Get the value of the “@move_focus@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #moveFocus
-- @
getWidgetClassMoveFocus :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassMoveFocusFieldCallback)
getWidgetClassMoveFocus s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 272) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassMoveFocusFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassMoveFocusFieldCallback val'
        return val''
    return result

-- | Set the value of the “@move_focus@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #moveFocus 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassMoveFocus :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassMoveFocusFieldCallback -> m ()
setWidgetClassMoveFocus s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 272) (val :: FunPtr Gtk.Callbacks.C_WidgetClassMoveFocusFieldCallback)

-- | Set the value of the “@move_focus@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #moveFocus
-- @
clearWidgetClassMoveFocus :: MonadIO m => WidgetClass -> m ()
clearWidgetClassMoveFocus s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 272) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassMoveFocusFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassMoveFocusFieldInfo
instance AttrInfo WidgetClassMoveFocusFieldInfo where
    type AttrBaseTypeConstraint WidgetClassMoveFocusFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassMoveFocusFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassMoveFocusFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassMoveFocusFieldCallback)
    type AttrTransferTypeConstraint WidgetClassMoveFocusFieldInfo = (~)Gtk.Callbacks.WidgetClassMoveFocusFieldCallback
    type AttrTransferType WidgetClassMoveFocusFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassMoveFocusFieldCallback)
    type AttrGetType WidgetClassMoveFocusFieldInfo = Maybe Gtk.Callbacks.WidgetClassMoveFocusFieldCallback
    type AttrLabel WidgetClassMoveFocusFieldInfo = "move_focus"
    type AttrOrigin WidgetClassMoveFocusFieldInfo = WidgetClass
    attrGet = getWidgetClassMoveFocus
    attrSet = setWidgetClassMoveFocus
    attrConstruct = undefined
    attrClear = clearWidgetClassMoveFocus
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassMoveFocusFieldCallback (Gtk.Callbacks.wrap_WidgetClassMoveFocusFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.moveFocus"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:moveFocus"
        })

widgetClass_moveFocus :: AttrLabelProxy "moveFocus"
widgetClass_moveFocus = AttrLabelProxy

#endif


-- | Get the value of the “@keynav_failed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #keynavFailed
-- @
getWidgetClassKeynavFailed :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassKeynavFailedFieldCallback)
getWidgetClassKeynavFailed s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 280) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassKeynavFailedFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassKeynavFailedFieldCallback val'
        return val''
    return result

-- | Set the value of the “@keynav_failed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #keynavFailed 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassKeynavFailed :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassKeynavFailedFieldCallback -> m ()
setWidgetClassKeynavFailed s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 280) (val :: FunPtr Gtk.Callbacks.C_WidgetClassKeynavFailedFieldCallback)

-- | Set the value of the “@keynav_failed@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #keynavFailed
-- @
clearWidgetClassKeynavFailed :: MonadIO m => WidgetClass -> m ()
clearWidgetClassKeynavFailed s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 280) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassKeynavFailedFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassKeynavFailedFieldInfo
instance AttrInfo WidgetClassKeynavFailedFieldInfo where
    type AttrBaseTypeConstraint WidgetClassKeynavFailedFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassKeynavFailedFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassKeynavFailedFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassKeynavFailedFieldCallback)
    type AttrTransferTypeConstraint WidgetClassKeynavFailedFieldInfo = (~)Gtk.Callbacks.WidgetClassKeynavFailedFieldCallback
    type AttrTransferType WidgetClassKeynavFailedFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassKeynavFailedFieldCallback)
    type AttrGetType WidgetClassKeynavFailedFieldInfo = Maybe Gtk.Callbacks.WidgetClassKeynavFailedFieldCallback
    type AttrLabel WidgetClassKeynavFailedFieldInfo = "keynav_failed"
    type AttrOrigin WidgetClassKeynavFailedFieldInfo = WidgetClass
    attrGet = getWidgetClassKeynavFailed
    attrSet = setWidgetClassKeynavFailed
    attrConstruct = undefined
    attrClear = clearWidgetClassKeynavFailed
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassKeynavFailedFieldCallback (Gtk.Callbacks.wrap_WidgetClassKeynavFailedFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.keynavFailed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:keynavFailed"
        })

widgetClass_keynavFailed :: AttrLabelProxy "keynavFailed"
widgetClass_keynavFailed = AttrLabelProxy

#endif


-- | Get the value of the “@query_tooltip@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #queryTooltip
-- @
getWidgetClassQueryTooltip :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassQueryTooltipFieldCallback)
getWidgetClassQueryTooltip s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 288) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassQueryTooltipFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassQueryTooltipFieldCallback val'
        return val''
    return result

-- | Set the value of the “@query_tooltip@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #queryTooltip 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassQueryTooltip :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassQueryTooltipFieldCallback -> m ()
setWidgetClassQueryTooltip s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 288) (val :: FunPtr Gtk.Callbacks.C_WidgetClassQueryTooltipFieldCallback)

-- | Set the value of the “@query_tooltip@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #queryTooltip
-- @
clearWidgetClassQueryTooltip :: MonadIO m => WidgetClass -> m ()
clearWidgetClassQueryTooltip s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 288) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassQueryTooltipFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassQueryTooltipFieldInfo
instance AttrInfo WidgetClassQueryTooltipFieldInfo where
    type AttrBaseTypeConstraint WidgetClassQueryTooltipFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassQueryTooltipFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassQueryTooltipFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassQueryTooltipFieldCallback)
    type AttrTransferTypeConstraint WidgetClassQueryTooltipFieldInfo = (~)Gtk.Callbacks.WidgetClassQueryTooltipFieldCallback
    type AttrTransferType WidgetClassQueryTooltipFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassQueryTooltipFieldCallback)
    type AttrGetType WidgetClassQueryTooltipFieldInfo = Maybe Gtk.Callbacks.WidgetClassQueryTooltipFieldCallback
    type AttrLabel WidgetClassQueryTooltipFieldInfo = "query_tooltip"
    type AttrOrigin WidgetClassQueryTooltipFieldInfo = WidgetClass
    attrGet = getWidgetClassQueryTooltip
    attrSet = setWidgetClassQueryTooltip
    attrConstruct = undefined
    attrClear = clearWidgetClassQueryTooltip
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassQueryTooltipFieldCallback (Gtk.Callbacks.wrap_WidgetClassQueryTooltipFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.queryTooltip"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:queryTooltip"
        })

widgetClass_queryTooltip :: AttrLabelProxy "queryTooltip"
widgetClass_queryTooltip = AttrLabelProxy

#endif


-- | Get the value of the “@compute_expand@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #computeExpand
-- @
getWidgetClassComputeExpand :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassComputeExpandFieldCallback)
getWidgetClassComputeExpand s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 296) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassComputeExpandFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassComputeExpandFieldCallback val'
        return val''
    return result

-- | Set the value of the “@compute_expand@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #computeExpand 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassComputeExpand :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassComputeExpandFieldCallback -> m ()
setWidgetClassComputeExpand s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 296) (val :: FunPtr Gtk.Callbacks.C_WidgetClassComputeExpandFieldCallback)

-- | Set the value of the “@compute_expand@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #computeExpand
-- @
clearWidgetClassComputeExpand :: MonadIO m => WidgetClass -> m ()
clearWidgetClassComputeExpand s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 296) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassComputeExpandFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassComputeExpandFieldInfo
instance AttrInfo WidgetClassComputeExpandFieldInfo where
    type AttrBaseTypeConstraint WidgetClassComputeExpandFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassComputeExpandFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassComputeExpandFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassComputeExpandFieldCallback)
    type AttrTransferTypeConstraint WidgetClassComputeExpandFieldInfo = (~)Gtk.Callbacks.WidgetClassComputeExpandFieldCallback
    type AttrTransferType WidgetClassComputeExpandFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassComputeExpandFieldCallback)
    type AttrGetType WidgetClassComputeExpandFieldInfo = Maybe Gtk.Callbacks.WidgetClassComputeExpandFieldCallback
    type AttrLabel WidgetClassComputeExpandFieldInfo = "compute_expand"
    type AttrOrigin WidgetClassComputeExpandFieldInfo = WidgetClass
    attrGet = getWidgetClassComputeExpand
    attrSet = setWidgetClassComputeExpand
    attrConstruct = undefined
    attrClear = clearWidgetClassComputeExpand
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassComputeExpandFieldCallback (Gtk.Callbacks.wrap_WidgetClassComputeExpandFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.computeExpand"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:computeExpand"
        })

widgetClass_computeExpand :: AttrLabelProxy "computeExpand"
widgetClass_computeExpand = AttrLabelProxy

#endif


-- | Get the value of the “@css_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #cssChanged
-- @
getWidgetClassCssChanged :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassCssChangedFieldCallback)
getWidgetClassCssChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 304) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassCssChangedFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassCssChangedFieldCallback val'
        return val''
    return result

-- | Set the value of the “@css_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #cssChanged 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassCssChanged :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassCssChangedFieldCallback -> m ()
setWidgetClassCssChanged s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 304) (val :: FunPtr Gtk.Callbacks.C_WidgetClassCssChangedFieldCallback)

-- | Set the value of the “@css_changed@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #cssChanged
-- @
clearWidgetClassCssChanged :: MonadIO m => WidgetClass -> m ()
clearWidgetClassCssChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 304) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassCssChangedFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassCssChangedFieldInfo
instance AttrInfo WidgetClassCssChangedFieldInfo where
    type AttrBaseTypeConstraint WidgetClassCssChangedFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassCssChangedFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassCssChangedFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassCssChangedFieldCallback)
    type AttrTransferTypeConstraint WidgetClassCssChangedFieldInfo = (~)Gtk.Callbacks.WidgetClassCssChangedFieldCallback
    type AttrTransferType WidgetClassCssChangedFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassCssChangedFieldCallback)
    type AttrGetType WidgetClassCssChangedFieldInfo = Maybe Gtk.Callbacks.WidgetClassCssChangedFieldCallback
    type AttrLabel WidgetClassCssChangedFieldInfo = "css_changed"
    type AttrOrigin WidgetClassCssChangedFieldInfo = WidgetClass
    attrGet = getWidgetClassCssChanged
    attrSet = setWidgetClassCssChanged
    attrConstruct = undefined
    attrClear = clearWidgetClassCssChanged
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassCssChangedFieldCallback (Gtk.Callbacks.wrap_WidgetClassCssChangedFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.cssChanged"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:cssChanged"
        })

widgetClass_cssChanged :: AttrLabelProxy "cssChanged"
widgetClass_cssChanged = AttrLabelProxy

#endif


-- | Get the value of the “@system_setting_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #systemSettingChanged
-- @
getWidgetClassSystemSettingChanged :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassSystemSettingChangedFieldCallback)
getWidgetClassSystemSettingChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 312) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassSystemSettingChangedFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassSystemSettingChangedFieldCallback val'
        return val''
    return result

-- | Set the value of the “@system_setting_changed@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #systemSettingChanged 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassSystemSettingChanged :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassSystemSettingChangedFieldCallback -> m ()
setWidgetClassSystemSettingChanged s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 312) (val :: FunPtr Gtk.Callbacks.C_WidgetClassSystemSettingChangedFieldCallback)

-- | Set the value of the “@system_setting_changed@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #systemSettingChanged
-- @
clearWidgetClassSystemSettingChanged :: MonadIO m => WidgetClass -> m ()
clearWidgetClassSystemSettingChanged s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 312) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassSystemSettingChangedFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassSystemSettingChangedFieldInfo
instance AttrInfo WidgetClassSystemSettingChangedFieldInfo where
    type AttrBaseTypeConstraint WidgetClassSystemSettingChangedFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassSystemSettingChangedFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassSystemSettingChangedFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassSystemSettingChangedFieldCallback)
    type AttrTransferTypeConstraint WidgetClassSystemSettingChangedFieldInfo = (~)Gtk.Callbacks.WidgetClassSystemSettingChangedFieldCallback
    type AttrTransferType WidgetClassSystemSettingChangedFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassSystemSettingChangedFieldCallback)
    type AttrGetType WidgetClassSystemSettingChangedFieldInfo = Maybe Gtk.Callbacks.WidgetClassSystemSettingChangedFieldCallback
    type AttrLabel WidgetClassSystemSettingChangedFieldInfo = "system_setting_changed"
    type AttrOrigin WidgetClassSystemSettingChangedFieldInfo = WidgetClass
    attrGet = getWidgetClassSystemSettingChanged
    attrSet = setWidgetClassSystemSettingChanged
    attrConstruct = undefined
    attrClear = clearWidgetClassSystemSettingChanged
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassSystemSettingChangedFieldCallback (Gtk.Callbacks.wrap_WidgetClassSystemSettingChangedFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.systemSettingChanged"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:systemSettingChanged"
        })

widgetClass_systemSettingChanged :: AttrLabelProxy "systemSettingChanged"
widgetClass_systemSettingChanged = AttrLabelProxy

#endif


-- | Get the value of the “@snapshot@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #snapshot
-- @
getWidgetClassSnapshot :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassSnapshotFieldCallback)
getWidgetClassSnapshot s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 320) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassSnapshotFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassSnapshotFieldCallback val'
        return val''
    return result

-- | Set the value of the “@snapshot@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #snapshot 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassSnapshot :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassSnapshotFieldCallback -> m ()
setWidgetClassSnapshot s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 320) (val :: FunPtr Gtk.Callbacks.C_WidgetClassSnapshotFieldCallback)

-- | Set the value of the “@snapshot@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #snapshot
-- @
clearWidgetClassSnapshot :: MonadIO m => WidgetClass -> m ()
clearWidgetClassSnapshot s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 320) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassSnapshotFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassSnapshotFieldInfo
instance AttrInfo WidgetClassSnapshotFieldInfo where
    type AttrBaseTypeConstraint WidgetClassSnapshotFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassSnapshotFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassSnapshotFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassSnapshotFieldCallback)
    type AttrTransferTypeConstraint WidgetClassSnapshotFieldInfo = (~)Gtk.Callbacks.WidgetClassSnapshotFieldCallback
    type AttrTransferType WidgetClassSnapshotFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassSnapshotFieldCallback)
    type AttrGetType WidgetClassSnapshotFieldInfo = Maybe Gtk.Callbacks.WidgetClassSnapshotFieldCallback
    type AttrLabel WidgetClassSnapshotFieldInfo = "snapshot"
    type AttrOrigin WidgetClassSnapshotFieldInfo = WidgetClass
    attrGet = getWidgetClassSnapshot
    attrSet = setWidgetClassSnapshot
    attrConstruct = undefined
    attrClear = clearWidgetClassSnapshot
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassSnapshotFieldCallback (Gtk.Callbacks.wrap_WidgetClassSnapshotFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.snapshot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:snapshot"
        })

widgetClass_snapshot :: AttrLabelProxy "snapshot"
widgetClass_snapshot = AttrLabelProxy

#endif


-- | Get the value of the “@contains@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' widgetClass #contains
-- @
getWidgetClassContains :: MonadIO m => WidgetClass -> m (Maybe Gtk.Callbacks.WidgetClassContainsFieldCallback)
getWidgetClassContains s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 328) :: IO (FunPtr Gtk.Callbacks.C_WidgetClassContainsFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gtk.Callbacks.dynamic_WidgetClassContainsFieldCallback val'
        return val''
    return result

-- | Set the value of the “@contains@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' widgetClass [ #contains 'Data.GI.Base.Attributes.:=' value ]
-- @
setWidgetClassContains :: MonadIO m => WidgetClass -> FunPtr Gtk.Callbacks.C_WidgetClassContainsFieldCallback -> m ()
setWidgetClassContains s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 328) (val :: FunPtr Gtk.Callbacks.C_WidgetClassContainsFieldCallback)

-- | Set the value of the “@contains@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #contains
-- @
clearWidgetClassContains :: MonadIO m => WidgetClass -> m ()
clearWidgetClassContains s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 328) (FP.nullFunPtr :: FunPtr Gtk.Callbacks.C_WidgetClassContainsFieldCallback)

#if defined(ENABLE_OVERLOADING)
data WidgetClassContainsFieldInfo
instance AttrInfo WidgetClassContainsFieldInfo where
    type AttrBaseTypeConstraint WidgetClassContainsFieldInfo = (~) WidgetClass
    type AttrAllowedOps WidgetClassContainsFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint WidgetClassContainsFieldInfo = (~) (FunPtr Gtk.Callbacks.C_WidgetClassContainsFieldCallback)
    type AttrTransferTypeConstraint WidgetClassContainsFieldInfo = (~)Gtk.Callbacks.WidgetClassContainsFieldCallback
    type AttrTransferType WidgetClassContainsFieldInfo = (FunPtr Gtk.Callbacks.C_WidgetClassContainsFieldCallback)
    type AttrGetType WidgetClassContainsFieldInfo = Maybe Gtk.Callbacks.WidgetClassContainsFieldCallback
    type AttrLabel WidgetClassContainsFieldInfo = "contains"
    type AttrOrigin WidgetClassContainsFieldInfo = WidgetClass
    attrGet = getWidgetClassContains
    attrSet = setWidgetClassContains
    attrConstruct = undefined
    attrClear = clearWidgetClassContains
    attrTransfer _ v = do
        Gtk.Callbacks.mk_WidgetClassContainsFieldCallback (Gtk.Callbacks.wrap_WidgetClassContainsFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.contains"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#g:attr:contains"
        })

widgetClass_contains :: AttrLabelProxy "contains"
widgetClass_contains = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList WidgetClass
type instance O.AttributeList WidgetClass = WidgetClassAttributeList
type WidgetClassAttributeList = ('[ '("parentClass", WidgetClassParentClassFieldInfo), '("show", WidgetClassShowFieldInfo), '("hide", WidgetClassHideFieldInfo), '("map", WidgetClassMapFieldInfo), '("unmap", WidgetClassUnmapFieldInfo), '("realize", WidgetClassRealizeFieldInfo), '("unrealize", WidgetClassUnrealizeFieldInfo), '("root", WidgetClassRootFieldInfo), '("unroot", WidgetClassUnrootFieldInfo), '("sizeAllocate", WidgetClassSizeAllocateFieldInfo), '("stateFlagsChanged", WidgetClassStateFlagsChangedFieldInfo), '("directionChanged", WidgetClassDirectionChangedFieldInfo), '("getRequestMode", WidgetClassGetRequestModeFieldInfo), '("measure", WidgetClassMeasureFieldInfo), '("mnemonicActivate", WidgetClassMnemonicActivateFieldInfo), '("grabFocus", WidgetClassGrabFocusFieldInfo), '("focus", WidgetClassFocusFieldInfo), '("setFocusChild", WidgetClassSetFocusChildFieldInfo), '("moveFocus", WidgetClassMoveFocusFieldInfo), '("keynavFailed", WidgetClassKeynavFailedFieldInfo), '("queryTooltip", WidgetClassQueryTooltipFieldInfo), '("computeExpand", WidgetClassComputeExpandFieldInfo), '("cssChanged", WidgetClassCssChangedFieldInfo), '("systemSettingChanged", WidgetClassSystemSettingChangedFieldInfo), '("snapshot", WidgetClassSnapshotFieldInfo), '("contains", WidgetClassContainsFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method WidgetClass::add_shortcut
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the class to add the shortcut to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "shortcut"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Shortcut" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the shortcut to add"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_add_shortcut" gtk_widget_class_add_shortcut :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    Ptr Gtk.Shortcut.Shortcut ->            -- shortcut : TInterface (Name {namespace = "Gtk", name = "Shortcut"})
    IO ()

-- | Installs a shortcut in /@widgetClass@/.
-- 
-- Every instance created for /@widgetClass@/ or its subclasses will
-- inherit this shortcut and trigger it.
-- 
-- Shortcuts added this way will be triggered in the [enum/@gtk@/.PropagationPhase.bubble]
-- phase, which means they may also trigger if child widgets have focus.
-- 
-- This function must only be used in class initialization functions
-- otherwise it is not guaranteed that the shortcut will be installed.
widgetClassAddShortcut ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Shortcut.IsShortcut a) =>
    WidgetClass
    -- ^ /@widgetClass@/: the class to add the shortcut to
    -> a
    -- ^ /@shortcut@/: the shortcut to add
    -> m ()
widgetClassAddShortcut widgetClass shortcut = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    shortcut' <- unsafeManagedPtrCastPtr shortcut
    gtk_widget_class_add_shortcut widgetClass' shortcut'
    touchManagedPtr widgetClass
    touchManagedPtr shortcut
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassAddShortcutMethodInfo
instance (signature ~ (a -> m ()), MonadIO m, Gtk.Shortcut.IsShortcut a) => O.OverloadedMethod WidgetClassAddShortcutMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassAddShortcut

instance O.OverloadedMethodInfo WidgetClassAddShortcutMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassAddShortcut",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassAddShortcut"
        })


#endif

-- method WidgetClass::bind_template_callback_full
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "name of the callback as expected in the template XML"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback_symbol"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Callback" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the callback symbol"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_bind_template_callback_full" gtk_widget_class_bind_template_callback_full :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    CString ->                              -- callback_name : TBasicType TUTF8
    FunPtr GObject.Callbacks.C_Callback ->  -- callback_symbol : TInterface (Name {namespace = "GObject", name = "Callback"})
    IO ()

-- | Associates a name to be used in GtkBuilder XML with a symbol.
-- 
-- This function is not supported after 'GI.Gtk.Structs.WidgetClass.widgetClassSetTemplateScope'
-- has been used on /@widgetClass@/.
-- 
-- See 'GI.Gtk.Objects.BuilderCScope.builderCScopeAddCallbackSymbol'.
-- 
-- Note that this must be called from a composite widget classes
-- class initializer after calling 'GI.Gtk.Structs.WidgetClass.widgetClassSetTemplate'.
widgetClassBindTemplateCallbackFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> T.Text
    -- ^ /@callbackName@/: name of the callback as expected in the template XML
    -> GObject.Callbacks.Callback
    -- ^ /@callbackSymbol@/: the callback symbol
    -> m ()
widgetClassBindTemplateCallbackFull widgetClass callbackName callbackSymbol = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    callbackName' <- textToCString callbackName
    ptrcallbackSymbol <- callocMem :: IO (Ptr (FunPtr GObject.Callbacks.C_Callback))
    callbackSymbol' <- GObject.Callbacks.mk_Callback (GObject.Callbacks.wrap_Callback (Just ptrcallbackSymbol) callbackSymbol)
    poke ptrcallbackSymbol callbackSymbol'
    gtk_widget_class_bind_template_callback_full widgetClass' callbackName' callbackSymbol'
    touchManagedPtr widgetClass
    freeMem callbackName'
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassBindTemplateCallbackFullMethodInfo
instance (signature ~ (T.Text -> GObject.Callbacks.Callback -> m ()), MonadIO m) => O.OverloadedMethod WidgetClassBindTemplateCallbackFullMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassBindTemplateCallbackFull

instance O.OverloadedMethodInfo WidgetClassBindTemplateCallbackFullMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassBindTemplateCallbackFull",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassBindTemplateCallbackFull"
        })


#endif

-- method WidgetClass::bind_template_child_full
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "ID of the child defined in the template XML"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "internal_child"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether the child should be accessible as an \8220internal-child\8221\n  when this class is used in GtkBuilder XML"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "struct_offset"
--           , argType = TBasicType TSSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The offset into the composite widget\8217s instance\n  public or private structure where the automated child pointer should be set,\n  or 0 to not assign the pointer"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_bind_template_child_full" gtk_widget_class_bind_template_child_full :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    CString ->                              -- name : TBasicType TUTF8
    CInt ->                                 -- internal_child : TBasicType TBoolean
    DI.Int64 ->                             -- struct_offset : TBasicType TSSize
    IO ()

-- | Assigns an object declared in the class template XML to be set to
-- a location on a freshly built instance’s private data, or
-- alternatively accessible via 'GI.Gtk.Objects.Widget.widgetGetTemplateChild'.
-- 
-- The struct can point either into the public instance, then you should
-- use @G_STRUCT_OFFSET(WidgetType, member)@ for /@structOffset@/, or in the
-- private struct, then you should use @G_PRIVATE_OFFSET(WidgetType, member)@.
-- 
-- An explicit strong reference will be held automatically for the duration
-- of your instance’s life cycle, it will be released automatically when
-- @GObjectClass.dispose()@ runs on your instance and if a nonzero /@structOffset@/
-- is specified, then the automatic location in your instance public or private
-- data will be set to @NULL@. You can however access an automated child pointer
-- the first time your classes @GObjectClass.dispose()@ runs, or alternatively
-- in [Widget::destroy]("GI.Gtk.Objects.Widget#g:signal:destroy").
-- 
-- If /@internalChild@/ is specified, t'GI.Gtk.Interfaces.Buildable.Buildable'.@/get_internal_child/@()
-- will be automatically implemented by the widget class so there is no
-- need to implement it manually.
-- 
-- The wrapper macros @/Gtk.widget_class_bind_template_child/@,
-- @/Gtk.widget_class_bind_template_child_internal/@,
-- @/Gtk.widget_class_bind_template_child_private/@ and
-- @/Gtk.widget_class_bind_template_child_internal_private/@
-- might be more convenient to use.
-- 
-- Note that this must be called from a composite widget classes class
-- initializer after calling 'GI.Gtk.Structs.WidgetClass.widgetClassSetTemplate'.
widgetClassBindTemplateChildFull ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> T.Text
    -- ^ /@name@/: ID of the child defined in the template XML
    -> Bool
    -- ^ /@internalChild@/: whether the child should be accessible as an “internal-child”
    --   when this class is used in GtkBuilder XML
    -> DI.Int64
    -- ^ /@structOffset@/: The offset into the composite widget’s instance
    --   public or private structure where the automated child pointer should be set,
    --   or 0 to not assign the pointer
    -> m ()
widgetClassBindTemplateChildFull widgetClass name internalChild structOffset = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    name' <- textToCString name
    let internalChild' = (P.fromIntegral . P.fromEnum) internalChild
    gtk_widget_class_bind_template_child_full widgetClass' name' internalChild' structOffset
    touchManagedPtr widgetClass
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassBindTemplateChildFullMethodInfo
instance (signature ~ (T.Text -> Bool -> DI.Int64 -> m ()), MonadIO m) => O.OverloadedMethod WidgetClassBindTemplateChildFullMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassBindTemplateChildFull

instance O.OverloadedMethodInfo WidgetClassBindTemplateChildFullMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassBindTemplateChildFull",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassBindTemplateChildFull"
        })


#endif

-- method WidgetClass::get_accessible_role
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "AccessibleRole" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_get_accessible_role" gtk_widget_class_get_accessible_role :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    IO CUInt

-- | Retrieves the accessible role used by the given widget class.
-- 
-- Different accessible roles have different states, and are rendered
-- differently by assistive technologies.
-- 
-- See also: 'GI.Gtk.Interfaces.Accessible.accessibleGetAccessibleRole'.
widgetClassGetAccessibleRole ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> m Gtk.Enums.AccessibleRole
    -- ^ __Returns:__ the accessible role for the widget class
widgetClassGetAccessibleRole widgetClass = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    result <- gtk_widget_class_get_accessible_role widgetClass'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr widgetClass
    return result'

#if defined(ENABLE_OVERLOADING)
data WidgetClassGetAccessibleRoleMethodInfo
instance (signature ~ (m Gtk.Enums.AccessibleRole), MonadIO m) => O.OverloadedMethod WidgetClassGetAccessibleRoleMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassGetAccessibleRole

instance O.OverloadedMethodInfo WidgetClassGetAccessibleRoleMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassGetAccessibleRole",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassGetAccessibleRole"
        })


#endif

-- method WidgetClass::get_activate_signal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_get_activate_signal" gtk_widget_class_get_activate_signal :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    IO Word32

-- | Retrieves the signal id for the activation signal.
-- 
-- The activation signal is set using
-- 'GI.Gtk.Structs.WidgetClass.widgetClassSetActivateSignal'.
widgetClassGetActivateSignal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> m Word32
    -- ^ __Returns:__ a signal id, or 0 if the widget class does not
    --   specify an activation signal
widgetClassGetActivateSignal widgetClass = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    result <- gtk_widget_class_get_activate_signal widgetClass'
    touchManagedPtr widgetClass
    return result

#if defined(ENABLE_OVERLOADING)
data WidgetClassGetActivateSignalMethodInfo
instance (signature ~ (m Word32), MonadIO m) => O.OverloadedMethod WidgetClassGetActivateSignalMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassGetActivateSignal

instance O.OverloadedMethodInfo WidgetClassGetActivateSignalMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassGetActivateSignal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassGetActivateSignal"
        })


#endif

-- method WidgetClass::get_css_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "class to set the name on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_get_css_name" gtk_widget_class_get_css_name :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    IO CString

-- | Gets the name used by this class for matching in CSS code.
-- 
-- See 'GI.Gtk.Structs.WidgetClass.widgetClassSetCssName' for details.
widgetClassGetCssName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: class to set the name on
    -> m T.Text
    -- ^ __Returns:__ the CSS name of the given class
widgetClassGetCssName widgetClass = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    result <- gtk_widget_class_get_css_name widgetClass'
    checkUnexpectedReturnNULL "widgetClassGetCssName" result
    result' <- cstringToText result
    touchManagedPtr widgetClass
    return result'

#if defined(ENABLE_OVERLOADING)
data WidgetClassGetCssNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m) => O.OverloadedMethod WidgetClassGetCssNameMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassGetCssName

instance O.OverloadedMethodInfo WidgetClassGetCssNameMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassGetCssName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassGetCssName"
        })


#endif

-- method WidgetClass::get_layout_manager_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TGType)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_get_layout_manager_type" gtk_widget_class_get_layout_manager_type :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    IO CGType

-- | Retrieves the type of the t'GI.Gtk.Objects.LayoutManager.LayoutManager'
-- used by widgets of class /@widgetClass@/.
-- 
-- See also: 'GI.Gtk.Structs.WidgetClass.widgetClassSetLayoutManagerType'.
widgetClassGetLayoutManagerType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> m GType
    -- ^ __Returns:__ type of a @GtkLayoutManager@ subclass, or @G_TYPE_INVALID@
widgetClassGetLayoutManagerType widgetClass = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    result <- gtk_widget_class_get_layout_manager_type widgetClass'
    let result' = GType result
    touchManagedPtr widgetClass
    return result'

#if defined(ENABLE_OVERLOADING)
data WidgetClassGetLayoutManagerTypeMethodInfo
instance (signature ~ (m GType), MonadIO m) => O.OverloadedMethod WidgetClassGetLayoutManagerTypeMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassGetLayoutManagerType

instance O.OverloadedMethodInfo WidgetClassGetLayoutManagerTypeMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassGetLayoutManagerType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassGetLayoutManagerType"
        })


#endif

-- method WidgetClass::install_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a prefixed action name, such as \"clipboard.paste\""
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parameter_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the parameter type" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "activate"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "WidgetActionActivateFunc" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "callback to use when the action is activated"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeNotified
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_install_action" gtk_widget_class_install_action :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    CString ->                              -- action_name : TBasicType TUTF8
    CString ->                              -- parameter_type : TBasicType TUTF8
    FunPtr Gtk.Callbacks.C_WidgetActionActivateFunc -> -- activate : TInterface (Name {namespace = "Gtk", name = "WidgetActionActivateFunc"})
    IO ()

-- | Adds an action for all instances of a widget class.
-- 
-- This function should be called at class initialization time.
-- 
-- Actions installed by this function are stateless. The only state
-- they have is whether they are enabled or not (which can be changed
-- with 'GI.Gtk.Objects.Widget.widgetActionSetEnabled').
widgetClassInstallAction ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> T.Text
    -- ^ /@actionName@/: a prefixed action name, such as \"clipboard.paste\"
    -> Maybe (T.Text)
    -- ^ /@parameterType@/: the parameter type
    -> Gtk.Callbacks.WidgetActionActivateFunc
    -- ^ /@activate@/: callback to use when the action is activated
    -> m ()
widgetClassInstallAction widgetClass actionName parameterType activate = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    actionName' <- textToCString actionName
    maybeParameterType <- case parameterType of
        Nothing -> return FP.nullPtr
        Just jParameterType -> do
            jParameterType' <- textToCString jParameterType
            return jParameterType'
    activate' <- Gtk.Callbacks.mk_WidgetActionActivateFunc (Gtk.Callbacks.wrap_WidgetActionActivateFunc Nothing activate)
    gtk_widget_class_install_action widgetClass' actionName' maybeParameterType activate'
    touchManagedPtr widgetClass
    freeMem actionName'
    freeMem maybeParameterType
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassInstallActionMethodInfo
instance (signature ~ (T.Text -> Maybe (T.Text) -> Gtk.Callbacks.WidgetActionActivateFunc -> m ()), MonadIO m) => O.OverloadedMethod WidgetClassInstallActionMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassInstallAction

instance O.OverloadedMethodInfo WidgetClassInstallActionMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassInstallAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassInstallAction"
        })


#endif

-- method WidgetClass::install_property_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name of the action" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "name of a property in instances of @widget_class\n  or any parent class"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_install_property_action" gtk_widget_class_install_property_action :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    CString ->                              -- action_name : TBasicType TUTF8
    CString ->                              -- property_name : TBasicType TUTF8
    IO ()

-- | Installs an action called /@actionName@/ on /@widgetClass@/ and
-- binds its state to the value of the /@propertyName@/ property.
-- 
-- This function will perform a few sanity checks on the property selected
-- via /@propertyName@/. Namely, the property must exist, must be readable,
-- writable and must not be construct-only. There are also restrictions
-- on the type of the given property, it must be boolean, int, unsigned int,
-- double or string. If any of these conditions are not met, a critical
-- warning will be printed and no action will be added.
-- 
-- The state type of the action matches the property type.
-- 
-- If the property is boolean, the action will have no parameter and
-- toggle the property value. Otherwise, the action will have a parameter
-- of the same type as the property.
widgetClassInstallPropertyAction ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> T.Text
    -- ^ /@actionName@/: name of the action
    -> T.Text
    -- ^ /@propertyName@/: name of a property in instances of /@widgetClass@/
    --   or any parent class
    -> m ()
widgetClassInstallPropertyAction widgetClass actionName propertyName = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    actionName' <- textToCString actionName
    propertyName' <- textToCString propertyName
    gtk_widget_class_install_property_action widgetClass' actionName' propertyName'
    touchManagedPtr widgetClass
    freeMem actionName'
    freeMem propertyName'
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassInstallPropertyActionMethodInfo
instance (signature ~ (T.Text -> T.Text -> m ()), MonadIO m) => O.OverloadedMethod WidgetClassInstallPropertyActionMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassInstallPropertyAction

instance O.OverloadedMethodInfo WidgetClassInstallPropertyActionMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassInstallPropertyAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassInstallPropertyAction"
        })


#endif

-- method WidgetClass::query_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "index_"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "position of the action to query"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "owner"
--           , argType = TBasicType TGType
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the type where the action was defined"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the action name"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parameter_type"
--           , argType =
--               TInterface Name { namespace = "GLib" , name = "VariantType" }
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the parameter type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "property_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the property name"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_query_action" gtk_widget_class_query_action :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    Word32 ->                               -- index_ : TBasicType TUInt
    Ptr CGType ->                           -- owner : TBasicType TGType
    Ptr CString ->                          -- action_name : TBasicType TUTF8
    Ptr (Ptr GLib.VariantType.VariantType) -> -- parameter_type : TInterface (Name {namespace = "GLib", name = "VariantType"})
    Ptr CString ->                          -- property_name : TBasicType TUTF8
    IO CInt

-- | Returns details about an action that has been
-- installed for /@widgetClass@/.
-- 
-- See 'GI.Gtk.Structs.WidgetClass.widgetClassInstallAction' for details on
-- how to install actions.
-- 
-- Note that this function will also return actions defined
-- by parent classes. You can identify those by looking
-- at /@owner@/.
widgetClassQueryAction ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> Word32
    -- ^ /@index_@/: position of the action to query
    -> m ((Bool, GType, T.Text, Maybe GLib.VariantType.VariantType, Maybe T.Text))
    -- ^ __Returns:__ true if the action was found
widgetClassQueryAction widgetClass index_ = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    owner <- allocMem :: IO (Ptr CGType)
    actionName <- callocMem :: IO (Ptr CString)
    parameterType <- callocMem :: IO (Ptr (Ptr GLib.VariantType.VariantType))
    propertyName <- callocMem :: IO (Ptr CString)
    result <- gtk_widget_class_query_action widgetClass' index_ owner actionName parameterType propertyName
    let result' = (/= 0) result
    owner' <- peek owner
    let owner'' = GType owner'
    actionName' <- peek actionName
    actionName'' <- cstringToText actionName'
    parameterType' <- peek parameterType
    maybeParameterType' <- convertIfNonNull parameterType' $ \parameterType'' -> do
        parameterType''' <- (newBoxed GLib.VariantType.VariantType) parameterType''
        return parameterType'''
    propertyName' <- peek propertyName
    maybePropertyName' <- convertIfNonNull propertyName' $ \propertyName'' -> do
        propertyName''' <- cstringToText propertyName''
        return propertyName'''
    touchManagedPtr widgetClass
    freeMem owner
    freeMem actionName
    freeMem parameterType
    freeMem propertyName
    return (result', owner'', actionName'', maybeParameterType', maybePropertyName')

#if defined(ENABLE_OVERLOADING)
data WidgetClassQueryActionMethodInfo
instance (signature ~ (Word32 -> m ((Bool, GType, T.Text, Maybe GLib.VariantType.VariantType, Maybe T.Text))), MonadIO m) => O.OverloadedMethod WidgetClassQueryActionMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassQueryAction

instance O.OverloadedMethodInfo WidgetClassQueryActionMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassQueryAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassQueryAction"
        })


#endif

-- method WidgetClass::set_accessible_role
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accessible_role"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AccessibleRole" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the accessible role to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_set_accessible_role" gtk_widget_class_set_accessible_role :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    CUInt ->                                -- accessible_role : TInterface (Name {namespace = "Gtk", name = "AccessibleRole"})
    IO ()

-- | Sets the accessible role used by the given widget class.
-- 
-- Different accessible roles have different states, and are
-- rendered differently by assistive technologies.
widgetClassSetAccessibleRole ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> Gtk.Enums.AccessibleRole
    -- ^ /@accessibleRole@/: the accessible role to use
    -> m ()
widgetClassSetAccessibleRole widgetClass accessibleRole = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    let accessibleRole' = (fromIntegral . fromEnum) accessibleRole
    gtk_widget_class_set_accessible_role widgetClass' accessibleRole'
    touchManagedPtr widgetClass
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassSetAccessibleRoleMethodInfo
instance (signature ~ (Gtk.Enums.AccessibleRole -> m ()), MonadIO m) => O.OverloadedMethod WidgetClassSetAccessibleRoleMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassSetAccessibleRole

instance O.OverloadedMethodInfo WidgetClassSetAccessibleRoleMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassSetAccessibleRole",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassSetAccessibleRole"
        })


#endif

-- method WidgetClass::set_activate_signal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the id for the activate signal"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_set_activate_signal" gtk_widget_class_set_activate_signal :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    Word32 ->                               -- signal_id : TBasicType TUInt
    IO ()

-- | Sets the activation signal for a widget class.
-- 
-- The signal will be emitted when calling 'GI.Gtk.Objects.Widget.widgetActivate'.
-- 
-- The /@signalId@/ must have been registered with [function.GObject.signal_new]
-- or @/GObject.signal_newv/@ before calling this function.
widgetClassSetActivateSignal ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> Word32
    -- ^ /@signalId@/: the id for the activate signal
    -> m ()
widgetClassSetActivateSignal widgetClass signalId = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    gtk_widget_class_set_activate_signal widgetClass' signalId
    touchManagedPtr widgetClass
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassSetActivateSignalMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m) => O.OverloadedMethod WidgetClassSetActivateSignalMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassSetActivateSignal

instance O.OverloadedMethodInfo WidgetClassSetActivateSignalMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassSetActivateSignal",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassSetActivateSignal"
        })


#endif

-- method WidgetClass::set_activate_signal_from_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "signal_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the name of the activate signal of @widget_type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_set_activate_signal_from_name" gtk_widget_class_set_activate_signal_from_name :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    CString ->                              -- signal_name : TBasicType TUTF8
    IO ()

-- | Sets the activation signal for a widget class.
-- 
-- The signal id will by looked up by /@signalName@/.
-- 
-- The signal will be emitted when calling 'GI.Gtk.Objects.Widget.widgetActivate'.
-- 
-- The /@signalName@/ must have been registered with [function.GObject.signal_new]
-- or @/GObject.signal_newv/@ before calling this function.
widgetClassSetActivateSignalFromName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> T.Text
    -- ^ /@signalName@/: the name of the activate signal of /@widgetType@/
    -> m ()
widgetClassSetActivateSignalFromName widgetClass signalName = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    signalName' <- textToCString signalName
    gtk_widget_class_set_activate_signal_from_name widgetClass' signalName'
    touchManagedPtr widgetClass
    freeMem signalName'
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassSetActivateSignalFromNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod WidgetClassSetActivateSignalFromNameMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassSetActivateSignalFromName

instance O.OverloadedMethodInfo WidgetClassSetActivateSignalFromNameMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassSetActivateSignalFromName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassSetActivateSignalFromName"
        })


#endif

-- method WidgetClass::set_css_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "class to set the name on"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_set_css_name" gtk_widget_class_set_css_name :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Sets the name to be used for CSS matching of widgets.
-- 
-- If this function is not called for a given class, the name
-- set on the parent class is used. By default, @GtkWidget@
-- uses the name \"widget\".
widgetClassSetCssName ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: class to set the name on
    -> T.Text
    -- ^ /@name@/: name to use
    -> m ()
widgetClassSetCssName widgetClass name = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    name' <- textToCString name
    gtk_widget_class_set_css_name widgetClass' name'
    touchManagedPtr widgetClass
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassSetCssNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod WidgetClassSetCssNameMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassSetCssName

instance O.OverloadedMethodInfo WidgetClassSetCssNameMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassSetCssName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassSetCssName"
        })


#endif

-- method WidgetClass::set_layout_manager_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the object type that implements the `GtkLayoutManager`\n  for @widget_class"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_set_layout_manager_type" gtk_widget_class_set_layout_manager_type :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    CGType ->                               -- type : TBasicType TGType
    IO ()

-- | Sets the type to be used for creating layout managers for
-- widgets of /@widgetClass@/.
-- 
-- The given /@type@/ must be a subtype of t'GI.Gtk.Objects.LayoutManager.LayoutManager'.
-- 
-- This function should only be called from class init functions
-- of widgets.
widgetClassSetLayoutManagerType ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> GType
    -- ^ /@type@/: the object type that implements the @GtkLayoutManager@
    --   for /@widgetClass@/
    -> m ()
widgetClassSetLayoutManagerType widgetClass type_ = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    let type_' = gtypeToCGType type_
    gtk_widget_class_set_layout_manager_type widgetClass' type_'
    touchManagedPtr widgetClass
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassSetLayoutManagerTypeMethodInfo
instance (signature ~ (GType -> m ()), MonadIO m) => O.OverloadedMethod WidgetClassSetLayoutManagerTypeMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassSetLayoutManagerType

instance O.OverloadedMethodInfo WidgetClassSetLayoutManagerTypeMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassSetLayoutManagerType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassSetLayoutManagerType"
        })


#endif

-- method WidgetClass::set_template
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "template_bytes"
--           , argType = TInterface Name { namespace = "GLib" , name = "Bytes" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "`GBytes` holding the `GtkBuilder` XML"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_set_template" gtk_widget_class_set_template :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    Ptr GLib.Bytes.Bytes ->                 -- template_bytes : TInterface (Name {namespace = "GLib", name = "Bytes"})
    IO ()

-- | This should be called at class initialization time to specify
-- the @GtkBuilder@ XML to be used to extend a widget.
-- 
-- For convenience, 'GI.Gtk.Structs.WidgetClass.widgetClassSetTemplateFromResource'
-- is also provided.
-- 
-- Note that any class that installs templates must call
-- 'GI.Gtk.Objects.Widget.widgetInitTemplate' in the widget’s instance initializer.
widgetClassSetTemplate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> GLib.Bytes.Bytes
    -- ^ /@templateBytes@/: @GBytes@ holding the @GtkBuilder@ XML
    -> m ()
widgetClassSetTemplate widgetClass templateBytes = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    templateBytes' <- unsafeManagedPtrGetPtr templateBytes
    gtk_widget_class_set_template widgetClass' templateBytes'
    touchManagedPtr widgetClass
    touchManagedPtr templateBytes
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassSetTemplateMethodInfo
instance (signature ~ (GLib.Bytes.Bytes -> m ()), MonadIO m) => O.OverloadedMethod WidgetClassSetTemplateMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassSetTemplate

instance O.OverloadedMethodInfo WidgetClassSetTemplateMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassSetTemplate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassSetTemplate"
        })


#endif

-- method WidgetClass::set_template_from_resource
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resource_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "resource path to load the template from"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_set_template_from_resource" gtk_widget_class_set_template_from_resource :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    CString ->                              -- resource_name : TBasicType TUTF8
    IO ()

-- | A convenience function that calls 'GI.Gtk.Structs.WidgetClass.widgetClassSetTemplate'
-- with the contents of a resource.
-- 
-- Note that any class that installs templates must call
-- 'GI.Gtk.Objects.Widget.widgetInitTemplate' in the widget’s instance
-- initializer.
widgetClassSetTemplateFromResource ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> T.Text
    -- ^ /@resourceName@/: resource path to load the template from
    -> m ()
widgetClassSetTemplateFromResource widgetClass resourceName = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    resourceName' <- textToCString resourceName
    gtk_widget_class_set_template_from_resource widgetClass' resourceName'
    touchManagedPtr widgetClass
    freeMem resourceName'
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassSetTemplateFromResourceMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m) => O.OverloadedMethod WidgetClassSetTemplateFromResourceMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassSetTemplateFromResource

instance O.OverloadedMethodInfo WidgetClassSetTemplateFromResourceMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassSetTemplateFromResource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassSetTemplateFromResource"
        })


#endif

-- method WidgetClass::set_template_scope
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "widget_class"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WidgetClass" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a widget class" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "scope"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BuilderScope" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "`GtkBuilderScope` to use when loading\n  the class template"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_widget_class_set_template_scope" gtk_widget_class_set_template_scope :: 
    Ptr WidgetClass ->                      -- widget_class : TInterface (Name {namespace = "Gtk", name = "WidgetClass"})
    Ptr Gtk.BuilderScope.BuilderScope ->    -- scope : TInterface (Name {namespace = "Gtk", name = "BuilderScope"})
    IO ()

-- | Overrides the default scope to be used when parsing the class template.
-- 
-- This function is intended for language bindings.
-- 
-- Note that this must be called from a composite widget classes class
-- initializer after calling 'GI.Gtk.Structs.WidgetClass.widgetClassSetTemplate'.
widgetClassSetTemplateScope ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.BuilderScope.IsBuilderScope a) =>
    WidgetClass
    -- ^ /@widgetClass@/: a widget class
    -> a
    -- ^ /@scope@/: @GtkBuilderScope@ to use when loading
    --   the class template
    -> m ()
widgetClassSetTemplateScope widgetClass scope = liftIO $ do
    widgetClass' <- unsafeManagedPtrGetPtr widgetClass
    scope' <- unsafeManagedPtrCastPtr scope
    gtk_widget_class_set_template_scope widgetClass' scope'
    touchManagedPtr widgetClass
    touchManagedPtr scope
    return ()

#if defined(ENABLE_OVERLOADING)
data WidgetClassSetTemplateScopeMethodInfo
instance (signature ~ (a -> m ()), MonadIO m, Gtk.BuilderScope.IsBuilderScope a) => O.OverloadedMethod WidgetClassSetTemplateScopeMethodInfo WidgetClass signature where
    overloadedMethod = widgetClassSetTemplateScope

instance O.OverloadedMethodInfo WidgetClassSetTemplateScopeMethodInfo WidgetClass where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.WidgetClass.widgetClassSetTemplateScope",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Structs-WidgetClass.html#v:widgetClassSetTemplateScope"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveWidgetClassMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveWidgetClassMethod "addShortcut" o = WidgetClassAddShortcutMethodInfo
    ResolveWidgetClassMethod "bindTemplateCallbackFull" o = WidgetClassBindTemplateCallbackFullMethodInfo
    ResolveWidgetClassMethod "bindTemplateChildFull" o = WidgetClassBindTemplateChildFullMethodInfo
    ResolveWidgetClassMethod "installAction" o = WidgetClassInstallActionMethodInfo
    ResolveWidgetClassMethod "installPropertyAction" o = WidgetClassInstallPropertyActionMethodInfo
    ResolveWidgetClassMethod "queryAction" o = WidgetClassQueryActionMethodInfo
    ResolveWidgetClassMethod "getAccessibleRole" o = WidgetClassGetAccessibleRoleMethodInfo
    ResolveWidgetClassMethod "getActivateSignal" o = WidgetClassGetActivateSignalMethodInfo
    ResolveWidgetClassMethod "getCssName" o = WidgetClassGetCssNameMethodInfo
    ResolveWidgetClassMethod "getLayoutManagerType" o = WidgetClassGetLayoutManagerTypeMethodInfo
    ResolveWidgetClassMethod "setAccessibleRole" o = WidgetClassSetAccessibleRoleMethodInfo
    ResolveWidgetClassMethod "setActivateSignal" o = WidgetClassSetActivateSignalMethodInfo
    ResolveWidgetClassMethod "setActivateSignalFromName" o = WidgetClassSetActivateSignalFromNameMethodInfo
    ResolveWidgetClassMethod "setCssName" o = WidgetClassSetCssNameMethodInfo
    ResolveWidgetClassMethod "setLayoutManagerType" o = WidgetClassSetLayoutManagerTypeMethodInfo
    ResolveWidgetClassMethod "setTemplate" o = WidgetClassSetTemplateMethodInfo
    ResolveWidgetClassMethod "setTemplateFromResource" o = WidgetClassSetTemplateFromResourceMethodInfo
    ResolveWidgetClassMethod "setTemplateScope" o = WidgetClassSetTemplateScopeMethodInfo
    ResolveWidgetClassMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveWidgetClassMethod t WidgetClass, O.OverloadedMethod info WidgetClass p) => OL.IsLabel t (WidgetClass -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveWidgetClassMethod t WidgetClass, O.OverloadedMethod info WidgetClass p, R.HasField t WidgetClass p) => R.HasField t WidgetClass p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveWidgetClassMethod t WidgetClass, O.OverloadedMethodInfo info WidgetClass) => OL.IsLabel t (O.MethodProxy info WidgetClass) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


