{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Shows window frame controls.
-- 
-- Typical window frame controls are minimize, maximize and close buttons,
-- and the window icon.
-- 
-- \<picture>
--   \<source srcset=\"windowcontrols-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkWindowControls\" src=\"windowcontrols.png\">
-- \<\/picture>
-- 
-- @GtkWindowControls@ only displays start or end side of the controls (see
-- [WindowControls:side]("GI.Gtk.Objects.WindowControls#g:attr:side")), so it\'s intended to be always used
-- in pair with another @GtkWindowControls@ for the opposite side, for example:
-- 
-- 
-- === /xml code/
-- ><object class="GtkBox">
-- >  <child>
-- >    <object class="GtkWindowControls">
-- >      <property name="side">start</property>
-- >    </object>
-- >  </child>
-- >
-- >  ...
-- >
-- >  <child>
-- >    <object class="GtkWindowControls">
-- >      <property name="side">end</property>
-- >    </object>
-- >  </child>
-- ></object>
-- 
-- 
-- = CSS nodes
-- 
-- >windowcontrols
-- >├── [image.icon]
-- >├── [button.minimize]
-- >├── [button.maximize]
-- >╰── [button.close]
-- 
-- 
-- A @GtkWindowControls@\' CSS node is called windowcontrols. It contains
-- subnodes corresponding to each title button. Which of the title buttons
-- exist and where they are placed exactly depends on the desktop environment
-- and [WindowControls:decorationLayout]("GI.Gtk.Objects.WindowControls#g:attr:decorationLayout") value.
-- 
-- When [WindowControls:empty]("GI.Gtk.Objects.WindowControls#g:attr:empty") is true, it gets the .empty
-- style class.
-- 
-- = Accessibility
-- 
-- @GtkWindowControls@ uses the [enum/@gtk@/.AccessibleRole.group] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.WindowControls
    ( 

-- * Exported types
    WindowControls(..)                      ,
    IsWindowControls                        ,
    toWindowControls                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDecorationLayout]("GI.Gtk.Objects.WindowControls#g:method:getDecorationLayout"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEmpty]("GI.Gtk.Objects.WindowControls#g:method:getEmpty"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSide]("GI.Gtk.Objects.WindowControls#g:method:getSide"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getUseNativeControls]("GI.Gtk.Objects.WindowControls#g:method:getUseNativeControls"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorationLayout]("GI.Gtk.Objects.WindowControls#g:method:setDecorationLayout"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSide]("GI.Gtk.Objects.WindowControls#g:method:setSide"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setUseNativeControls]("GI.Gtk.Objects.WindowControls#g:method:setUseNativeControls"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveWindowControlsMethod             ,
#endif

-- ** getDecorationLayout #method:getDecorationLayout#

#if defined(ENABLE_OVERLOADING)
    WindowControlsGetDecorationLayoutMethodInfo,
#endif
    windowControlsGetDecorationLayout       ,


-- ** getEmpty #method:getEmpty#

#if defined(ENABLE_OVERLOADING)
    WindowControlsGetEmptyMethodInfo        ,
#endif
    windowControlsGetEmpty                  ,


-- ** getSide #method:getSide#

#if defined(ENABLE_OVERLOADING)
    WindowControlsGetSideMethodInfo         ,
#endif
    windowControlsGetSide                   ,


-- ** getUseNativeControls #method:getUseNativeControls#

#if defined(ENABLE_OVERLOADING)
    WindowControlsGetUseNativeControlsMethodInfo,
#endif
    windowControlsGetUseNativeControls      ,


-- ** new #method:new#

    windowControlsNew                       ,


-- ** setDecorationLayout #method:setDecorationLayout#

#if defined(ENABLE_OVERLOADING)
    WindowControlsSetDecorationLayoutMethodInfo,
#endif
    windowControlsSetDecorationLayout       ,


-- ** setSide #method:setSide#

#if defined(ENABLE_OVERLOADING)
    WindowControlsSetSideMethodInfo         ,
#endif
    windowControlsSetSide                   ,


-- ** setUseNativeControls #method:setUseNativeControls#

#if defined(ENABLE_OVERLOADING)
    WindowControlsSetUseNativeControlsMethodInfo,
#endif
    windowControlsSetUseNativeControls      ,




 -- * Properties


-- ** decorationLayout #attr:decorationLayout#
-- | The decoration layout for window buttons.
-- 
-- If this property is not set, the
-- [Settings:gtkDecorationLayout]("GI.Gtk.Objects.Settings#g:attr:gtkDecorationLayout") setting is used.

#if defined(ENABLE_OVERLOADING)
    WindowControlsDecorationLayoutPropertyInfo,
#endif
    clearWindowControlsDecorationLayout     ,
    constructWindowControlsDecorationLayout ,
    getWindowControlsDecorationLayout       ,
    setWindowControlsDecorationLayout       ,
#if defined(ENABLE_OVERLOADING)
    windowControlsDecorationLayout          ,
#endif


-- ** empty #attr:empty#
-- | Whether the widget has any window buttons.

#if defined(ENABLE_OVERLOADING)
    WindowControlsEmptyPropertyInfo         ,
#endif
    getWindowControlsEmpty                  ,
#if defined(ENABLE_OVERLOADING)
    windowControlsEmpty                     ,
#endif


-- ** side #attr:side#
-- | Whether the widget shows start or end side of the decoration layout.
-- 
-- See [property/@gtk@/.WindowControls:decoration_layout].

#if defined(ENABLE_OVERLOADING)
    WindowControlsSidePropertyInfo          ,
#endif
    constructWindowControlsSide             ,
    getWindowControlsSide                   ,
    setWindowControlsSide                   ,
#if defined(ENABLE_OVERLOADING)
    windowControlsSide                      ,
#endif


-- ** useNativeControls #attr:useNativeControls#
-- | Whether to show platform native close\/minimize\/maximize buttons.
-- 
-- For macOS, the [HeaderBar:decorationLayout]("GI.Gtk.Objects.HeaderBar#g:attr:decorationLayout") property
-- controls the use of native window controls.
-- 
-- On other platforms, this option has no effect.
-- 
-- See also <https://docs.gtk.org/gtk4/osx.html?native-window-controls Using GTK on Apple macOS>.
-- 
-- /Since: 4.18/

#if defined(ENABLE_OVERLOADING)
    WindowControlsUseNativeControlsPropertyInfo,
#endif
    constructWindowControlsUseNativeControls,
    getWindowControlsUseNativeControls      ,
    setWindowControlsUseNativeControls      ,
#if defined(ENABLE_OVERLOADING)
    windowControlsUseNativeControls         ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype WindowControls = WindowControls (SP.ManagedPtr WindowControls)
    deriving (Eq)

instance SP.ManagedPtrNewtype WindowControls where
    toManagedPtr (WindowControls p) = p

foreign import ccall "gtk_window_controls_get_type"
    c_gtk_window_controls_get_type :: IO B.Types.GType

instance B.Types.TypedObject WindowControls where
    glibType = c_gtk_window_controls_get_type

instance B.Types.GObject WindowControls

-- | Type class for types which can be safely cast to `WindowControls`, for instance with `toWindowControls`.
class (SP.GObject o, O.IsDescendantOf WindowControls o) => IsWindowControls o
instance (SP.GObject o, O.IsDescendantOf WindowControls o) => IsWindowControls o

instance O.HasParentTypes WindowControls
type instance O.ParentTypes WindowControls = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `WindowControls`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toWindowControls :: (MIO.MonadIO m, IsWindowControls o) => o -> m WindowControls
toWindowControls = MIO.liftIO . B.ManagedPtr.unsafeCastTo WindowControls

-- | Convert 'WindowControls' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe WindowControls) where
    gvalueGType_ = c_gtk_window_controls_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr WindowControls)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr WindowControls)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject WindowControls ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveWindowControlsMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveWindowControlsMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveWindowControlsMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveWindowControlsMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveWindowControlsMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveWindowControlsMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveWindowControlsMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveWindowControlsMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveWindowControlsMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveWindowControlsMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveWindowControlsMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveWindowControlsMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveWindowControlsMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveWindowControlsMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveWindowControlsMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveWindowControlsMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveWindowControlsMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveWindowControlsMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveWindowControlsMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveWindowControlsMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveWindowControlsMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveWindowControlsMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveWindowControlsMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveWindowControlsMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveWindowControlsMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveWindowControlsMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveWindowControlsMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveWindowControlsMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveWindowControlsMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveWindowControlsMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveWindowControlsMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveWindowControlsMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveWindowControlsMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveWindowControlsMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveWindowControlsMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveWindowControlsMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveWindowControlsMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveWindowControlsMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveWindowControlsMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveWindowControlsMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveWindowControlsMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveWindowControlsMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveWindowControlsMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveWindowControlsMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveWindowControlsMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveWindowControlsMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveWindowControlsMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveWindowControlsMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveWindowControlsMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveWindowControlsMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveWindowControlsMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveWindowControlsMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveWindowControlsMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveWindowControlsMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveWindowControlsMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveWindowControlsMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveWindowControlsMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveWindowControlsMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveWindowControlsMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveWindowControlsMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveWindowControlsMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveWindowControlsMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveWindowControlsMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveWindowControlsMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveWindowControlsMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveWindowControlsMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveWindowControlsMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveWindowControlsMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveWindowControlsMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveWindowControlsMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveWindowControlsMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveWindowControlsMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveWindowControlsMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveWindowControlsMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveWindowControlsMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveWindowControlsMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveWindowControlsMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveWindowControlsMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveWindowControlsMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveWindowControlsMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveWindowControlsMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveWindowControlsMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveWindowControlsMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveWindowControlsMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveWindowControlsMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveWindowControlsMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveWindowControlsMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveWindowControlsMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveWindowControlsMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveWindowControlsMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveWindowControlsMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveWindowControlsMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveWindowControlsMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveWindowControlsMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveWindowControlsMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveWindowControlsMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveWindowControlsMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveWindowControlsMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveWindowControlsMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveWindowControlsMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveWindowControlsMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveWindowControlsMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveWindowControlsMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveWindowControlsMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveWindowControlsMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveWindowControlsMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveWindowControlsMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveWindowControlsMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveWindowControlsMethod "getDecorationLayout" o = WindowControlsGetDecorationLayoutMethodInfo
    ResolveWindowControlsMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveWindowControlsMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveWindowControlsMethod "getEmpty" o = WindowControlsGetEmptyMethodInfo
    ResolveWindowControlsMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveWindowControlsMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveWindowControlsMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveWindowControlsMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveWindowControlsMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveWindowControlsMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveWindowControlsMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveWindowControlsMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveWindowControlsMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveWindowControlsMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveWindowControlsMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveWindowControlsMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveWindowControlsMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveWindowControlsMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveWindowControlsMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveWindowControlsMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveWindowControlsMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveWindowControlsMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveWindowControlsMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveWindowControlsMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveWindowControlsMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveWindowControlsMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveWindowControlsMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveWindowControlsMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveWindowControlsMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveWindowControlsMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveWindowControlsMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveWindowControlsMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveWindowControlsMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveWindowControlsMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveWindowControlsMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveWindowControlsMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveWindowControlsMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveWindowControlsMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveWindowControlsMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveWindowControlsMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveWindowControlsMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveWindowControlsMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveWindowControlsMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveWindowControlsMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveWindowControlsMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveWindowControlsMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveWindowControlsMethod "getSide" o = WindowControlsGetSideMethodInfo
    ResolveWindowControlsMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveWindowControlsMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveWindowControlsMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveWindowControlsMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveWindowControlsMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveWindowControlsMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveWindowControlsMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveWindowControlsMethod "getUseNativeControls" o = WindowControlsGetUseNativeControlsMethodInfo
    ResolveWindowControlsMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveWindowControlsMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveWindowControlsMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveWindowControlsMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveWindowControlsMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveWindowControlsMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveWindowControlsMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveWindowControlsMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveWindowControlsMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveWindowControlsMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveWindowControlsMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveWindowControlsMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveWindowControlsMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveWindowControlsMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveWindowControlsMethod "setDecorationLayout" o = WindowControlsSetDecorationLayoutMethodInfo
    ResolveWindowControlsMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveWindowControlsMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveWindowControlsMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveWindowControlsMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveWindowControlsMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveWindowControlsMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveWindowControlsMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveWindowControlsMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveWindowControlsMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveWindowControlsMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveWindowControlsMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveWindowControlsMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveWindowControlsMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveWindowControlsMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveWindowControlsMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveWindowControlsMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveWindowControlsMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveWindowControlsMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveWindowControlsMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveWindowControlsMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveWindowControlsMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveWindowControlsMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveWindowControlsMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveWindowControlsMethod "setSide" o = WindowControlsSetSideMethodInfo
    ResolveWindowControlsMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveWindowControlsMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveWindowControlsMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveWindowControlsMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveWindowControlsMethod "setUseNativeControls" o = WindowControlsSetUseNativeControlsMethodInfo
    ResolveWindowControlsMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveWindowControlsMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveWindowControlsMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveWindowControlsMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveWindowControlsMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveWindowControlsMethod t WindowControls, O.OverloadedMethod info WindowControls p) => OL.IsLabel t (WindowControls -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveWindowControlsMethod t WindowControls, O.OverloadedMethod info WindowControls p, R.HasField t WindowControls p) => R.HasField t WindowControls p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveWindowControlsMethod t WindowControls, O.OverloadedMethodInfo info WindowControls) => OL.IsLabel t (O.MethodProxy info WindowControls) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "decoration-layout"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@decoration-layout@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowControls #decorationLayout
-- @
getWindowControlsDecorationLayout :: (MonadIO m, IsWindowControls o) => o -> m (Maybe T.Text)
getWindowControlsDecorationLayout obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "decoration-layout"

-- | Set the value of the “@decoration-layout@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowControls [ #decorationLayout 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowControlsDecorationLayout :: (MonadIO m, IsWindowControls o) => o -> T.Text -> m ()
setWindowControlsDecorationLayout obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "decoration-layout" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@decoration-layout@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowControlsDecorationLayout :: (IsWindowControls o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructWindowControlsDecorationLayout val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "decoration-layout" (P.Just val)

-- | Set the value of the “@decoration-layout@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #decorationLayout
-- @
clearWindowControlsDecorationLayout :: (MonadIO m, IsWindowControls o) => o -> m ()
clearWindowControlsDecorationLayout obj = liftIO $ B.Properties.setObjectPropertyString obj "decoration-layout" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data WindowControlsDecorationLayoutPropertyInfo
instance AttrInfo WindowControlsDecorationLayoutPropertyInfo where
    type AttrAllowedOps WindowControlsDecorationLayoutPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WindowControlsDecorationLayoutPropertyInfo = IsWindowControls
    type AttrSetTypeConstraint WindowControlsDecorationLayoutPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint WindowControlsDecorationLayoutPropertyInfo = (~) T.Text
    type AttrTransferType WindowControlsDecorationLayoutPropertyInfo = T.Text
    type AttrGetType WindowControlsDecorationLayoutPropertyInfo = (Maybe T.Text)
    type AttrLabel WindowControlsDecorationLayoutPropertyInfo = "decoration-layout"
    type AttrOrigin WindowControlsDecorationLayoutPropertyInfo = WindowControls
    attrGet = getWindowControlsDecorationLayout
    attrSet = setWindowControlsDecorationLayout
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowControlsDecorationLayout
    attrClear = clearWindowControlsDecorationLayout
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowControls.decorationLayout"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-WindowControls.html#g:attr:decorationLayout"
        })
#endif

-- VVV Prop "empty"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@empty@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowControls #empty
-- @
getWindowControlsEmpty :: (MonadIO m, IsWindowControls o) => o -> m Bool
getWindowControlsEmpty obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "empty"

#if defined(ENABLE_OVERLOADING)
data WindowControlsEmptyPropertyInfo
instance AttrInfo WindowControlsEmptyPropertyInfo where
    type AttrAllowedOps WindowControlsEmptyPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint WindowControlsEmptyPropertyInfo = IsWindowControls
    type AttrSetTypeConstraint WindowControlsEmptyPropertyInfo = (~) ()
    type AttrTransferTypeConstraint WindowControlsEmptyPropertyInfo = (~) ()
    type AttrTransferType WindowControlsEmptyPropertyInfo = ()
    type AttrGetType WindowControlsEmptyPropertyInfo = Bool
    type AttrLabel WindowControlsEmptyPropertyInfo = "empty"
    type AttrOrigin WindowControlsEmptyPropertyInfo = WindowControls
    attrGet = getWindowControlsEmpty
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowControls.empty"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-WindowControls.html#g:attr:empty"
        })
#endif

-- VVV Prop "side"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PackType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@side@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowControls #side
-- @
getWindowControlsSide :: (MonadIO m, IsWindowControls o) => o -> m Gtk.Enums.PackType
getWindowControlsSide obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "side"

-- | Set the value of the “@side@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowControls [ #side 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowControlsSide :: (MonadIO m, IsWindowControls o) => o -> Gtk.Enums.PackType -> m ()
setWindowControlsSide obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "side" val

-- | Construct a `GValueConstruct` with valid value for the “@side@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowControlsSide :: (IsWindowControls o, MIO.MonadIO m) => Gtk.Enums.PackType -> m (GValueConstruct o)
constructWindowControlsSide val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "side" val

#if defined(ENABLE_OVERLOADING)
data WindowControlsSidePropertyInfo
instance AttrInfo WindowControlsSidePropertyInfo where
    type AttrAllowedOps WindowControlsSidePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowControlsSidePropertyInfo = IsWindowControls
    type AttrSetTypeConstraint WindowControlsSidePropertyInfo = (~) Gtk.Enums.PackType
    type AttrTransferTypeConstraint WindowControlsSidePropertyInfo = (~) Gtk.Enums.PackType
    type AttrTransferType WindowControlsSidePropertyInfo = Gtk.Enums.PackType
    type AttrGetType WindowControlsSidePropertyInfo = Gtk.Enums.PackType
    type AttrLabel WindowControlsSidePropertyInfo = "side"
    type AttrOrigin WindowControlsSidePropertyInfo = WindowControls
    attrGet = getWindowControlsSide
    attrSet = setWindowControlsSide
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowControlsSide
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowControls.side"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-WindowControls.html#g:attr:side"
        })
#endif

-- VVV Prop "use-native-controls"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@use-native-controls@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowControls #useNativeControls
-- @
getWindowControlsUseNativeControls :: (MonadIO m, IsWindowControls o) => o -> m Bool
getWindowControlsUseNativeControls obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "use-native-controls"

-- | Set the value of the “@use-native-controls@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowControls [ #useNativeControls 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowControlsUseNativeControls :: (MonadIO m, IsWindowControls o) => o -> Bool -> m ()
setWindowControlsUseNativeControls obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "use-native-controls" val

-- | Construct a `GValueConstruct` with valid value for the “@use-native-controls@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowControlsUseNativeControls :: (IsWindowControls o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructWindowControlsUseNativeControls val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "use-native-controls" val

#if defined(ENABLE_OVERLOADING)
data WindowControlsUseNativeControlsPropertyInfo
instance AttrInfo WindowControlsUseNativeControlsPropertyInfo where
    type AttrAllowedOps WindowControlsUseNativeControlsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint WindowControlsUseNativeControlsPropertyInfo = IsWindowControls
    type AttrSetTypeConstraint WindowControlsUseNativeControlsPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint WindowControlsUseNativeControlsPropertyInfo = (~) Bool
    type AttrTransferType WindowControlsUseNativeControlsPropertyInfo = Bool
    type AttrGetType WindowControlsUseNativeControlsPropertyInfo = Bool
    type AttrLabel WindowControlsUseNativeControlsPropertyInfo = "use-native-controls"
    type AttrOrigin WindowControlsUseNativeControlsPropertyInfo = WindowControls
    attrGet = getWindowControlsUseNativeControls
    attrSet = setWindowControlsUseNativeControls
    attrTransfer _ v = do
        return v
    attrConstruct = constructWindowControlsUseNativeControls
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowControls.useNativeControls"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-WindowControls.html#g:attr:useNativeControls"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList WindowControls
type instance O.AttributeList WindowControls = WindowControlsAttributeList
type WindowControlsAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("decorationLayout", WindowControlsDecorationLayoutPropertyInfo), '("empty", WindowControlsEmptyPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("side", WindowControlsSidePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("useNativeControls", WindowControlsUseNativeControlsPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
windowControlsDecorationLayout :: AttrLabelProxy "decorationLayout"
windowControlsDecorationLayout = AttrLabelProxy

windowControlsEmpty :: AttrLabelProxy "empty"
windowControlsEmpty = AttrLabelProxy

windowControlsSide :: AttrLabelProxy "side"
windowControlsSide = AttrLabelProxy

windowControlsUseNativeControls :: AttrLabelProxy "useNativeControls"
windowControlsUseNativeControls = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList WindowControls = WindowControlsSignalList
type WindowControlsSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method WindowControls::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "side"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PackType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the side" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "WindowControls" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_controls_new" gtk_window_controls_new :: 
    CUInt ->                                -- side : TInterface (Name {namespace = "Gtk", name = "PackType"})
    IO (Ptr WindowControls)

-- | Creates a new @GtkWindowControls@.
windowControlsNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Gtk.Enums.PackType
    -- ^ /@side@/: the side
    -> m WindowControls
    -- ^ __Returns:__ a new @GtkWindowControls@
windowControlsNew side = liftIO $ do
    let side' = (fromIntegral . fromEnum) side
    result <- gtk_window_controls_new side'
    checkUnexpectedReturnNULL "windowControlsNew" result
    result' <- (newObject WindowControls) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method WindowControls::get_decoration_layout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WindowControls" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window controls widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_controls_get_decoration_layout" gtk_window_controls_get_decoration_layout :: 
    Ptr WindowControls ->                   -- self : TInterface (Name {namespace = "Gtk", name = "WindowControls"})
    IO CString

-- | Gets the decoration layout of this window controls widget
windowControlsGetDecorationLayout ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindowControls a) =>
    a
    -- ^ /@self@/: a window controls widget
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the decoration layout
windowControlsGetDecorationLayout self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_window_controls_get_decoration_layout self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowControlsGetDecorationLayoutMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsWindowControls a) => O.OverloadedMethod WindowControlsGetDecorationLayoutMethodInfo a signature where
    overloadedMethod = windowControlsGetDecorationLayout

instance O.OverloadedMethodInfo WindowControlsGetDecorationLayoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowControls.windowControlsGetDecorationLayout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-WindowControls.html#v:windowControlsGetDecorationLayout"
        })


#endif

-- method WindowControls::get_empty
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WindowControls" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window controls widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_controls_get_empty" gtk_window_controls_get_empty :: 
    Ptr WindowControls ->                   -- self : TInterface (Name {namespace = "Gtk", name = "WindowControls"})
    IO CInt

-- | Gets whether the widget has any window buttons.
windowControlsGetEmpty ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindowControls a) =>
    a
    -- ^ /@self@/: a window controls widget
    -> m Bool
    -- ^ __Returns:__ true if the widget has window buttons
windowControlsGetEmpty self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_window_controls_get_empty self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowControlsGetEmptyMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindowControls a) => O.OverloadedMethod WindowControlsGetEmptyMethodInfo a signature where
    overloadedMethod = windowControlsGetEmpty

instance O.OverloadedMethodInfo WindowControlsGetEmptyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowControls.windowControlsGetEmpty",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-WindowControls.html#v:windowControlsGetEmpty"
        })


#endif

-- method WindowControls::get_side
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WindowControls" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window controls widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "PackType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_controls_get_side" gtk_window_controls_get_side :: 
    Ptr WindowControls ->                   -- self : TInterface (Name {namespace = "Gtk", name = "WindowControls"})
    IO CUInt

-- | Gets the side to which this window controls widget belongs.
windowControlsGetSide ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindowControls a) =>
    a
    -- ^ /@self@/: a window controls widget
    -> m Gtk.Enums.PackType
    -- ^ __Returns:__ the side
windowControlsGetSide self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_window_controls_get_side self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowControlsGetSideMethodInfo
instance (signature ~ (m Gtk.Enums.PackType), MonadIO m, IsWindowControls a) => O.OverloadedMethod WindowControlsGetSideMethodInfo a signature where
    overloadedMethod = windowControlsGetSide

instance O.OverloadedMethodInfo WindowControlsGetSideMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowControls.windowControlsGetSide",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-WindowControls.html#v:windowControlsGetSide"
        })


#endif

-- method WindowControls::get_use_native_controls
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WindowControls" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window controls widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_controls_get_use_native_controls" gtk_window_controls_get_use_native_controls :: 
    Ptr WindowControls ->                   -- self : TInterface (Name {namespace = "Gtk", name = "WindowControls"})
    IO CInt

-- | Returns whether platform native window controls are shown.
-- 
-- /Since: 4.18/
windowControlsGetUseNativeControls ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindowControls a) =>
    a
    -- ^ /@self@/: a window controls widget
    -> m Bool
    -- ^ __Returns:__ true if native window controls are shown
windowControlsGetUseNativeControls self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_window_controls_get_use_native_controls self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data WindowControlsGetUseNativeControlsMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsWindowControls a) => O.OverloadedMethod WindowControlsGetUseNativeControlsMethodInfo a signature where
    overloadedMethod = windowControlsGetUseNativeControls

instance O.OverloadedMethodInfo WindowControlsGetUseNativeControlsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowControls.windowControlsGetUseNativeControls",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-WindowControls.html#v:windowControlsGetUseNativeControls"
        })


#endif

-- method WindowControls::set_decoration_layout
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WindowControls" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window controls widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "layout"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a decoration layout, or `NULL` to unset the layout"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_controls_set_decoration_layout" gtk_window_controls_set_decoration_layout :: 
    Ptr WindowControls ->                   -- self : TInterface (Name {namespace = "Gtk", name = "WindowControls"})
    CString ->                              -- layout : TBasicType TUTF8
    IO ()

-- | Sets the decoration layout for the title buttons.
-- 
-- This overrides the [Settings:gtkDecorationLayout]("GI.Gtk.Objects.Settings#g:attr:gtkDecorationLayout")
-- setting.
-- 
-- The format of the string is button names, separated by commas.
-- A colon separates the buttons that should appear on the left
-- from those on the right. Recognized button names are minimize,
-- maximize, close and icon (the window icon).
-- 
-- For example, “icon:minimize,maximize,close” specifies a icon
-- on the left, and minimize, maximize and close buttons on the right.
-- 
-- If [WindowControls:side]("GI.Gtk.Objects.WindowControls#g:attr:side") value is [enum/@gtk@/.PackType.start],
-- /@self@/ will display the part before the colon, otherwise after that.
windowControlsSetDecorationLayout ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindowControls a) =>
    a
    -- ^ /@self@/: a window controls widget
    -> Maybe (T.Text)
    -- ^ /@layout@/: a decoration layout, or @NULL@ to unset the layout
    -> m ()
windowControlsSetDecorationLayout self layout = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeLayout <- case layout of
        Nothing -> return FP.nullPtr
        Just jLayout -> do
            jLayout' <- textToCString jLayout
            return jLayout'
    gtk_window_controls_set_decoration_layout self' maybeLayout
    touchManagedPtr self
    freeMem maybeLayout
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowControlsSetDecorationLayoutMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsWindowControls a) => O.OverloadedMethod WindowControlsSetDecorationLayoutMethodInfo a signature where
    overloadedMethod = windowControlsSetDecorationLayout

instance O.OverloadedMethodInfo WindowControlsSetDecorationLayoutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowControls.windowControlsSetDecorationLayout",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-WindowControls.html#v:windowControlsSetDecorationLayout"
        })


#endif

-- method WindowControls::set_side
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WindowControls" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window controls widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "side"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PackType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a side" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_controls_set_side" gtk_window_controls_set_side :: 
    Ptr WindowControls ->                   -- self : TInterface (Name {namespace = "Gtk", name = "WindowControls"})
    CUInt ->                                -- side : TInterface (Name {namespace = "Gtk", name = "PackType"})
    IO ()

-- | Determines which part of decoration layout
-- the window controls widget uses.
-- 
-- See [WindowControls:decorationLayout]("GI.Gtk.Objects.WindowControls#g:attr:decorationLayout").
windowControlsSetSide ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindowControls a) =>
    a
    -- ^ /@self@/: a window controls widget
    -> Gtk.Enums.PackType
    -- ^ /@side@/: a side
    -> m ()
windowControlsSetSide self side = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let side' = (fromIntegral . fromEnum) side
    gtk_window_controls_set_side self' side'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowControlsSetSideMethodInfo
instance (signature ~ (Gtk.Enums.PackType -> m ()), MonadIO m, IsWindowControls a) => O.OverloadedMethod WindowControlsSetSideMethodInfo a signature where
    overloadedMethod = windowControlsSetSide

instance O.OverloadedMethodInfo WindowControlsSetSideMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowControls.windowControlsSetSide",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-WindowControls.html#v:windowControlsSetSide"
        })


#endif

-- method WindowControls::set_use_native_controls
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WindowControls" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a window_controls widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "true to show native window controls"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_controls_set_use_native_controls" gtk_window_controls_set_use_native_controls :: 
    Ptr WindowControls ->                   -- self : TInterface (Name {namespace = "Gtk", name = "WindowControls"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets whether platform native window controls are used.
-- 
-- This option shows the \"stoplight\" buttons on macOS.
-- For Linux, this option has no effect.
-- 
-- See also <https://docs.gtk.org/gtk4/osx.html?native-window-controls Using GTK on Apple macOS>.
-- 
-- /Since: 4.18/
windowControlsSetUseNativeControls ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindowControls a) =>
    a
    -- ^ /@self@/: a window_controls widget
    -> Bool
    -- ^ /@setting@/: true to show native window controls
    -> m ()
windowControlsSetUseNativeControls self setting = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_window_controls_set_use_native_controls self' setting'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowControlsSetUseNativeControlsMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsWindowControls a) => O.OverloadedMethod WindowControlsSetUseNativeControlsMethodInfo a signature where
    overloadedMethod = windowControlsSetUseNativeControls

instance O.OverloadedMethodInfo WindowControlsSetUseNativeControlsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowControls.windowControlsSetUseNativeControls",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-WindowControls.html#v:windowControlsSetUseNativeControls"
        })


#endif


