{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Shows a @GtkMediaStream@ with media controls.
-- 
-- \<picture>
--   \<source srcset=\"video-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkVideo\" src=\"video.png\">
-- \<\/picture>
-- 
-- The controls are available separately as t'GI.Gtk.Objects.MediaControls.MediaControls'.
-- If you just want to display a video without controls, you can treat it
-- like any other paintable and for example put it into a t'GI.Gtk.Objects.Picture.Picture'.
-- 
-- @GtkVideo@ aims to cover use cases such as previews, embedded animations,
-- etc. It supports autoplay, looping, and simple media controls. It does
-- not have support for video overlays, multichannel audio, device
-- selection, or input. If you are writing a full-fledged video player,
-- you may want to use the t'GI.Gdk.Interfaces.Paintable.Paintable' API and a media framework
-- such as Gstreamer directly.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Video
    ( 

-- * Exported types
    Video(..)                               ,
    IsVideo                                 ,
    toVideo                                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getAutoplay]("GI.Gtk.Objects.Video#g:method:getAutoplay"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFile]("GI.Gtk.Objects.Video#g:method:getFile"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getGraphicsOffload]("GI.Gtk.Objects.Video#g:method:getGraphicsOffload"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getLoop]("GI.Gtk.Objects.Video#g:method:getLoop"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMediaStream]("GI.Gtk.Objects.Video#g:method:getMediaStream"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAutoplay]("GI.Gtk.Objects.Video#g:method:setAutoplay"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFile]("GI.Gtk.Objects.Video#g:method:setFile"), [setFilename]("GI.Gtk.Objects.Video#g:method:setFilename"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setGraphicsOffload]("GI.Gtk.Objects.Video#g:method:setGraphicsOffload"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setLoop]("GI.Gtk.Objects.Video#g:method:setLoop"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMediaStream]("GI.Gtk.Objects.Video#g:method:setMediaStream"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResource]("GI.Gtk.Objects.Video#g:method:setResource"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveVideoMethod                      ,
#endif

-- ** getAutoplay #method:getAutoplay#

#if defined(ENABLE_OVERLOADING)
    VideoGetAutoplayMethodInfo              ,
#endif
    videoGetAutoplay                        ,


-- ** getFile #method:getFile#

#if defined(ENABLE_OVERLOADING)
    VideoGetFileMethodInfo                  ,
#endif
    videoGetFile                            ,


-- ** getGraphicsOffload #method:getGraphicsOffload#

#if defined(ENABLE_OVERLOADING)
    VideoGetGraphicsOffloadMethodInfo       ,
#endif
    videoGetGraphicsOffload                 ,


-- ** getLoop #method:getLoop#

#if defined(ENABLE_OVERLOADING)
    VideoGetLoopMethodInfo                  ,
#endif
    videoGetLoop                            ,


-- ** getMediaStream #method:getMediaStream#

#if defined(ENABLE_OVERLOADING)
    VideoGetMediaStreamMethodInfo           ,
#endif
    videoGetMediaStream                     ,


-- ** new #method:new#

    videoNew                                ,


-- ** newForFile #method:newForFile#

    videoNewForFile                         ,


-- ** newForFilename #method:newForFilename#

    videoNewForFilename                     ,


-- ** newForMediaStream #method:newForMediaStream#

    videoNewForMediaStream                  ,


-- ** newForResource #method:newForResource#

    videoNewForResource                     ,


-- ** setAutoplay #method:setAutoplay#

#if defined(ENABLE_OVERLOADING)
    VideoSetAutoplayMethodInfo              ,
#endif
    videoSetAutoplay                        ,


-- ** setFile #method:setFile#

#if defined(ENABLE_OVERLOADING)
    VideoSetFileMethodInfo                  ,
#endif
    videoSetFile                            ,


-- ** setFilename #method:setFilename#

#if defined(ENABLE_OVERLOADING)
    VideoSetFilenameMethodInfo              ,
#endif
    videoSetFilename                        ,


-- ** setGraphicsOffload #method:setGraphicsOffload#

#if defined(ENABLE_OVERLOADING)
    VideoSetGraphicsOffloadMethodInfo       ,
#endif
    videoSetGraphicsOffload                 ,


-- ** setLoop #method:setLoop#

#if defined(ENABLE_OVERLOADING)
    VideoSetLoopMethodInfo                  ,
#endif
    videoSetLoop                            ,


-- ** setMediaStream #method:setMediaStream#

#if defined(ENABLE_OVERLOADING)
    VideoSetMediaStreamMethodInfo           ,
#endif
    videoSetMediaStream                     ,


-- ** setResource #method:setResource#

#if defined(ENABLE_OVERLOADING)
    VideoSetResourceMethodInfo              ,
#endif
    videoSetResource                        ,




 -- * Properties


-- ** autoplay #attr:autoplay#
-- | If the video should automatically begin playing.

#if defined(ENABLE_OVERLOADING)
    VideoAutoplayPropertyInfo               ,
#endif
    constructVideoAutoplay                  ,
    getVideoAutoplay                        ,
    setVideoAutoplay                        ,
#if defined(ENABLE_OVERLOADING)
    videoAutoplay                           ,
#endif


-- ** file #attr:file#
-- | The file played by this video if the video is playing a file.

#if defined(ENABLE_OVERLOADING)
    VideoFilePropertyInfo                   ,
#endif
    clearVideoFile                          ,
    constructVideoFile                      ,
    getVideoFile                            ,
    setVideoFile                            ,
#if defined(ENABLE_OVERLOADING)
    videoFile                               ,
#endif


-- ** graphicsOffload #attr:graphicsOffload#
-- | Whether to enable graphics offload.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    VideoGraphicsOffloadPropertyInfo        ,
#endif
    constructVideoGraphicsOffload           ,
    getVideoGraphicsOffload                 ,
    setVideoGraphicsOffload                 ,
#if defined(ENABLE_OVERLOADING)
    videoGraphicsOffload                    ,
#endif


-- ** loop #attr:loop#
-- | If new media files should be set to loop.

#if defined(ENABLE_OVERLOADING)
    VideoLoopPropertyInfo                   ,
#endif
    constructVideoLoop                      ,
    getVideoLoop                            ,
    setVideoLoop                            ,
#if defined(ENABLE_OVERLOADING)
    videoLoop                               ,
#endif


-- ** mediaStream #attr:mediaStream#
-- | The media-stream played

#if defined(ENABLE_OVERLOADING)
    VideoMediaStreamPropertyInfo            ,
#endif
    clearVideoMediaStream                   ,
    constructVideoMediaStream               ,
    getVideoMediaStream                     ,
    setVideoMediaStream                     ,
#if defined(ENABLE_OVERLOADING)
    videoMediaStream                        ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.MediaStream as Gtk.MediaStream
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.File as Gio.File
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.MediaStream as Gtk.MediaStream
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Video = Video (SP.ManagedPtr Video)
    deriving (Eq)

instance SP.ManagedPtrNewtype Video where
    toManagedPtr (Video p) = p

foreign import ccall "gtk_video_get_type"
    c_gtk_video_get_type :: IO B.Types.GType

instance B.Types.TypedObject Video where
    glibType = c_gtk_video_get_type

instance B.Types.GObject Video

-- | Type class for types which can be safely cast to `Video`, for instance with `toVideo`.
class (SP.GObject o, O.IsDescendantOf Video o) => IsVideo o
instance (SP.GObject o, O.IsDescendantOf Video o) => IsVideo o

instance O.HasParentTypes Video
type instance O.ParentTypes Video = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `Video`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toVideo :: (MIO.MonadIO m, IsVideo o) => o -> m Video
toVideo = MIO.liftIO . B.ManagedPtr.unsafeCastTo Video

-- | Convert 'Video' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Video) where
    gvalueGType_ = c_gtk_video_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Video)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Video)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Video ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveVideoMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveVideoMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveVideoMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveVideoMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveVideoMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveVideoMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveVideoMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveVideoMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveVideoMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveVideoMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveVideoMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveVideoMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveVideoMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveVideoMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveVideoMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveVideoMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveVideoMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveVideoMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveVideoMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveVideoMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveVideoMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveVideoMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveVideoMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveVideoMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveVideoMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveVideoMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveVideoMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveVideoMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveVideoMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveVideoMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveVideoMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveVideoMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveVideoMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveVideoMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveVideoMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveVideoMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveVideoMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveVideoMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveVideoMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveVideoMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveVideoMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveVideoMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveVideoMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveVideoMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveVideoMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveVideoMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveVideoMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveVideoMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveVideoMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveVideoMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveVideoMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveVideoMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveVideoMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveVideoMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveVideoMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveVideoMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveVideoMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveVideoMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveVideoMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveVideoMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveVideoMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveVideoMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveVideoMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveVideoMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveVideoMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveVideoMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveVideoMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveVideoMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveVideoMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveVideoMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveVideoMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveVideoMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveVideoMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveVideoMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveVideoMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveVideoMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveVideoMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveVideoMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveVideoMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveVideoMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveVideoMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveVideoMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveVideoMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveVideoMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveVideoMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveVideoMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveVideoMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveVideoMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveVideoMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveVideoMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveVideoMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveVideoMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveVideoMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveVideoMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveVideoMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveVideoMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveVideoMethod "getAutoplay" o = VideoGetAutoplayMethodInfo
    ResolveVideoMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveVideoMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveVideoMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveVideoMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveVideoMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveVideoMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveVideoMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveVideoMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveVideoMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveVideoMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveVideoMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveVideoMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveVideoMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveVideoMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveVideoMethod "getFile" o = VideoGetFileMethodInfo
    ResolveVideoMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveVideoMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveVideoMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveVideoMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveVideoMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveVideoMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveVideoMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveVideoMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveVideoMethod "getGraphicsOffload" o = VideoGetGraphicsOffloadMethodInfo
    ResolveVideoMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveVideoMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveVideoMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveVideoMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveVideoMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveVideoMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveVideoMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveVideoMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveVideoMethod "getLoop" o = VideoGetLoopMethodInfo
    ResolveVideoMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveVideoMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveVideoMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveVideoMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveVideoMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveVideoMethod "getMediaStream" o = VideoGetMediaStreamMethodInfo
    ResolveVideoMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveVideoMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveVideoMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveVideoMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveVideoMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveVideoMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveVideoMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveVideoMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveVideoMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveVideoMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveVideoMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveVideoMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveVideoMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveVideoMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveVideoMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveVideoMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveVideoMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveVideoMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveVideoMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveVideoMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveVideoMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveVideoMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveVideoMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveVideoMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveVideoMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveVideoMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveVideoMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveVideoMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveVideoMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveVideoMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveVideoMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveVideoMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveVideoMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveVideoMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveVideoMethod "setAutoplay" o = VideoSetAutoplayMethodInfo
    ResolveVideoMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveVideoMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveVideoMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveVideoMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveVideoMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveVideoMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveVideoMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveVideoMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveVideoMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveVideoMethod "setFile" o = VideoSetFileMethodInfo
    ResolveVideoMethod "setFilename" o = VideoSetFilenameMethodInfo
    ResolveVideoMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveVideoMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveVideoMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveVideoMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveVideoMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveVideoMethod "setGraphicsOffload" o = VideoSetGraphicsOffloadMethodInfo
    ResolveVideoMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveVideoMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveVideoMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveVideoMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveVideoMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveVideoMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveVideoMethod "setLoop" o = VideoSetLoopMethodInfo
    ResolveVideoMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveVideoMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveVideoMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveVideoMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveVideoMethod "setMediaStream" o = VideoSetMediaStreamMethodInfo
    ResolveVideoMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveVideoMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveVideoMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveVideoMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveVideoMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveVideoMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveVideoMethod "setResource" o = VideoSetResourceMethodInfo
    ResolveVideoMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveVideoMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveVideoMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveVideoMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveVideoMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveVideoMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveVideoMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveVideoMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveVideoMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveVideoMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveVideoMethod t Video, O.OverloadedMethod info Video p) => OL.IsLabel t (Video -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveVideoMethod t Video, O.OverloadedMethod info Video p, R.HasField t Video p) => R.HasField t Video p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveVideoMethod t Video, O.OverloadedMethodInfo info Video) => OL.IsLabel t (O.MethodProxy info Video) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "autoplay"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@autoplay@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' video #autoplay
-- @
getVideoAutoplay :: (MonadIO m, IsVideo o) => o -> m Bool
getVideoAutoplay obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "autoplay"

-- | Set the value of the “@autoplay@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' video [ #autoplay 'Data.GI.Base.Attributes.:=' value ]
-- @
setVideoAutoplay :: (MonadIO m, IsVideo o) => o -> Bool -> m ()
setVideoAutoplay obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "autoplay" val

-- | Construct a `GValueConstruct` with valid value for the “@autoplay@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructVideoAutoplay :: (IsVideo o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructVideoAutoplay val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "autoplay" val

#if defined(ENABLE_OVERLOADING)
data VideoAutoplayPropertyInfo
instance AttrInfo VideoAutoplayPropertyInfo where
    type AttrAllowedOps VideoAutoplayPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint VideoAutoplayPropertyInfo = IsVideo
    type AttrSetTypeConstraint VideoAutoplayPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint VideoAutoplayPropertyInfo = (~) Bool
    type AttrTransferType VideoAutoplayPropertyInfo = Bool
    type AttrGetType VideoAutoplayPropertyInfo = Bool
    type AttrLabel VideoAutoplayPropertyInfo = "autoplay"
    type AttrOrigin VideoAutoplayPropertyInfo = Video
    attrGet = getVideoAutoplay
    attrSet = setVideoAutoplay
    attrTransfer _ v = do
        return v
    attrConstruct = constructVideoAutoplay
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.autoplay"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#g:attr:autoplay"
        })
#endif

-- VVV Prop "file"
   -- Type: TInterface (Name {namespace = "Gio", name = "File"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@file@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' video #file
-- @
getVideoFile :: (MonadIO m, IsVideo o) => o -> m (Maybe Gio.File.File)
getVideoFile obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "file" Gio.File.File

-- | Set the value of the “@file@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' video [ #file 'Data.GI.Base.Attributes.:=' value ]
-- @
setVideoFile :: (MonadIO m, IsVideo o, Gio.File.IsFile a) => o -> a -> m ()
setVideoFile obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "file" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@file@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructVideoFile :: (IsVideo o, MIO.MonadIO m, Gio.File.IsFile a) => a -> m (GValueConstruct o)
constructVideoFile val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "file" (P.Just val)

-- | Set the value of the “@file@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #file
-- @
clearVideoFile :: (MonadIO m, IsVideo o) => o -> m ()
clearVideoFile obj = liftIO $ B.Properties.setObjectPropertyObject obj "file" (Nothing :: Maybe Gio.File.File)

#if defined(ENABLE_OVERLOADING)
data VideoFilePropertyInfo
instance AttrInfo VideoFilePropertyInfo where
    type AttrAllowedOps VideoFilePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint VideoFilePropertyInfo = IsVideo
    type AttrSetTypeConstraint VideoFilePropertyInfo = Gio.File.IsFile
    type AttrTransferTypeConstraint VideoFilePropertyInfo = Gio.File.IsFile
    type AttrTransferType VideoFilePropertyInfo = Gio.File.File
    type AttrGetType VideoFilePropertyInfo = (Maybe Gio.File.File)
    type AttrLabel VideoFilePropertyInfo = "file"
    type AttrOrigin VideoFilePropertyInfo = Video
    attrGet = getVideoFile
    attrSet = setVideoFile
    attrTransfer _ v = do
        unsafeCastTo Gio.File.File v
    attrConstruct = constructVideoFile
    attrClear = clearVideoFile
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.file"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#g:attr:file"
        })
#endif

-- VVV Prop "graphics-offload"
   -- Type: TInterface (Name {namespace = "Gtk", name = "GraphicsOffloadEnabled"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@graphics-offload@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' video #graphicsOffload
-- @
getVideoGraphicsOffload :: (MonadIO m, IsVideo o) => o -> m Gtk.Enums.GraphicsOffloadEnabled
getVideoGraphicsOffload obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "graphics-offload"

-- | Set the value of the “@graphics-offload@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' video [ #graphicsOffload 'Data.GI.Base.Attributes.:=' value ]
-- @
setVideoGraphicsOffload :: (MonadIO m, IsVideo o) => o -> Gtk.Enums.GraphicsOffloadEnabled -> m ()
setVideoGraphicsOffload obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "graphics-offload" val

-- | Construct a `GValueConstruct` with valid value for the “@graphics-offload@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructVideoGraphicsOffload :: (IsVideo o, MIO.MonadIO m) => Gtk.Enums.GraphicsOffloadEnabled -> m (GValueConstruct o)
constructVideoGraphicsOffload val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "graphics-offload" val

#if defined(ENABLE_OVERLOADING)
data VideoGraphicsOffloadPropertyInfo
instance AttrInfo VideoGraphicsOffloadPropertyInfo where
    type AttrAllowedOps VideoGraphicsOffloadPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint VideoGraphicsOffloadPropertyInfo = IsVideo
    type AttrSetTypeConstraint VideoGraphicsOffloadPropertyInfo = (~) Gtk.Enums.GraphicsOffloadEnabled
    type AttrTransferTypeConstraint VideoGraphicsOffloadPropertyInfo = (~) Gtk.Enums.GraphicsOffloadEnabled
    type AttrTransferType VideoGraphicsOffloadPropertyInfo = Gtk.Enums.GraphicsOffloadEnabled
    type AttrGetType VideoGraphicsOffloadPropertyInfo = Gtk.Enums.GraphicsOffloadEnabled
    type AttrLabel VideoGraphicsOffloadPropertyInfo = "graphics-offload"
    type AttrOrigin VideoGraphicsOffloadPropertyInfo = Video
    attrGet = getVideoGraphicsOffload
    attrSet = setVideoGraphicsOffload
    attrTransfer _ v = do
        return v
    attrConstruct = constructVideoGraphicsOffload
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.graphicsOffload"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#g:attr:graphicsOffload"
        })
#endif

-- VVV Prop "loop"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@loop@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' video #loop
-- @
getVideoLoop :: (MonadIO m, IsVideo o) => o -> m Bool
getVideoLoop obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "loop"

-- | Set the value of the “@loop@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' video [ #loop 'Data.GI.Base.Attributes.:=' value ]
-- @
setVideoLoop :: (MonadIO m, IsVideo o) => o -> Bool -> m ()
setVideoLoop obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "loop" val

-- | Construct a `GValueConstruct` with valid value for the “@loop@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructVideoLoop :: (IsVideo o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructVideoLoop val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "loop" val

#if defined(ENABLE_OVERLOADING)
data VideoLoopPropertyInfo
instance AttrInfo VideoLoopPropertyInfo where
    type AttrAllowedOps VideoLoopPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint VideoLoopPropertyInfo = IsVideo
    type AttrSetTypeConstraint VideoLoopPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint VideoLoopPropertyInfo = (~) Bool
    type AttrTransferType VideoLoopPropertyInfo = Bool
    type AttrGetType VideoLoopPropertyInfo = Bool
    type AttrLabel VideoLoopPropertyInfo = "loop"
    type AttrOrigin VideoLoopPropertyInfo = Video
    attrGet = getVideoLoop
    attrSet = setVideoLoop
    attrTransfer _ v = do
        return v
    attrConstruct = constructVideoLoop
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.loop"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#g:attr:loop"
        })
#endif

-- VVV Prop "media-stream"
   -- Type: TInterface (Name {namespace = "Gtk", name = "MediaStream"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@media-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' video #mediaStream
-- @
getVideoMediaStream :: (MonadIO m, IsVideo o) => o -> m (Maybe Gtk.MediaStream.MediaStream)
getVideoMediaStream obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "media-stream" Gtk.MediaStream.MediaStream

-- | Set the value of the “@media-stream@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' video [ #mediaStream 'Data.GI.Base.Attributes.:=' value ]
-- @
setVideoMediaStream :: (MonadIO m, IsVideo o, Gtk.MediaStream.IsMediaStream a) => o -> a -> m ()
setVideoMediaStream obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "media-stream" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@media-stream@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructVideoMediaStream :: (IsVideo o, MIO.MonadIO m, Gtk.MediaStream.IsMediaStream a) => a -> m (GValueConstruct o)
constructVideoMediaStream val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "media-stream" (P.Just val)

-- | Set the value of the “@media-stream@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #mediaStream
-- @
clearVideoMediaStream :: (MonadIO m, IsVideo o) => o -> m ()
clearVideoMediaStream obj = liftIO $ B.Properties.setObjectPropertyObject obj "media-stream" (Nothing :: Maybe Gtk.MediaStream.MediaStream)

#if defined(ENABLE_OVERLOADING)
data VideoMediaStreamPropertyInfo
instance AttrInfo VideoMediaStreamPropertyInfo where
    type AttrAllowedOps VideoMediaStreamPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint VideoMediaStreamPropertyInfo = IsVideo
    type AttrSetTypeConstraint VideoMediaStreamPropertyInfo = Gtk.MediaStream.IsMediaStream
    type AttrTransferTypeConstraint VideoMediaStreamPropertyInfo = Gtk.MediaStream.IsMediaStream
    type AttrTransferType VideoMediaStreamPropertyInfo = Gtk.MediaStream.MediaStream
    type AttrGetType VideoMediaStreamPropertyInfo = (Maybe Gtk.MediaStream.MediaStream)
    type AttrLabel VideoMediaStreamPropertyInfo = "media-stream"
    type AttrOrigin VideoMediaStreamPropertyInfo = Video
    attrGet = getVideoMediaStream
    attrSet = setVideoMediaStream
    attrTransfer _ v = do
        unsafeCastTo Gtk.MediaStream.MediaStream v
    attrConstruct = constructVideoMediaStream
    attrClear = clearVideoMediaStream
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.mediaStream"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#g:attr:mediaStream"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Video
type instance O.AttributeList Video = VideoAttributeList
type VideoAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("autoplay", VideoAutoplayPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("file", VideoFilePropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("graphicsOffload", VideoGraphicsOffloadPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("loop", VideoLoopPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("mediaStream", VideoMediaStreamPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
videoAutoplay :: AttrLabelProxy "autoplay"
videoAutoplay = AttrLabelProxy

videoFile :: AttrLabelProxy "file"
videoFile = AttrLabelProxy

videoGraphicsOffload :: AttrLabelProxy "graphicsOffload"
videoGraphicsOffload = AttrLabelProxy

videoLoop :: AttrLabelProxy "loop"
videoLoop = AttrLabelProxy

videoMediaStream :: AttrLabelProxy "mediaStream"
videoMediaStream = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Video = VideoSignalList
type VideoSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Video::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Video" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_new" gtk_video_new :: 
    IO (Ptr Video)

-- | Creates a new empty @GtkVideo@.
videoNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Video
    -- ^ __Returns:__ a new @GtkVideo@
videoNew  = liftIO $ do
    result <- gtk_video_new
    checkUnexpectedReturnNULL "videoNew" result
    result' <- (newObject Video) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Video::new_for_file
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GFile`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Video" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_new_for_file" gtk_video_new_for_file :: 
    Ptr Gio.File.File ->                    -- file : TInterface (Name {namespace = "Gio", name = "File"})
    IO (Ptr Video)

-- | Creates a @GtkVideo@ to play back the given /@file@/.
videoNewForFile ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.File.IsFile a) =>
    Maybe (a)
    -- ^ /@file@/: a @GFile@
    -> m Video
    -- ^ __Returns:__ a new @GtkVideo@
videoNewForFile file = liftIO $ do
    maybeFile <- case file of
        Nothing -> return FP.nullPtr
        Just jFile -> do
            jFile' <- unsafeManagedPtrCastPtr jFile
            return jFile'
    result <- gtk_video_new_for_file maybeFile
    checkUnexpectedReturnNULL "videoNewForFile" result
    result' <- (newObject Video) result
    whenJust file touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Video::new_for_filename
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "filename to play back"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Video" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_new_for_filename" gtk_video_new_for_filename :: 
    CString ->                              -- filename : TBasicType TFileName
    IO (Ptr Video)

-- | Creates a @GtkVideo@ to play back the given /@filename@/.
-- 
-- This is a utility function that calls 'GI.Gtk.Objects.Video.videoNewForFile',
-- See that function for details.
videoNewForFilename ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe ([Char])
    -- ^ /@filename@/: filename to play back
    -> m Video
    -- ^ __Returns:__ a new @GtkVideo@
videoNewForFilename filename = liftIO $ do
    maybeFilename <- case filename of
        Nothing -> return FP.nullPtr
        Just jFilename -> do
            jFilename' <- stringToCString jFilename
            return jFilename'
    result <- gtk_video_new_for_filename maybeFilename
    checkUnexpectedReturnNULL "videoNewForFilename" result
    result' <- (newObject Video) result
    freeMem maybeFilename
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Video::new_for_media_stream
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkMediaStream`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Video" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_new_for_media_stream" gtk_video_new_for_media_stream :: 
    Ptr Gtk.MediaStream.MediaStream ->      -- stream : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO (Ptr Video)

-- | Creates a @GtkVideo@ to play back the given /@stream@/.
videoNewForMediaStream ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.MediaStream.IsMediaStream a) =>
    Maybe (a)
    -- ^ /@stream@/: a @GtkMediaStream@
    -> m Video
    -- ^ __Returns:__ a new @GtkVideo@
videoNewForMediaStream stream = liftIO $ do
    maybeStream <- case stream of
        Nothing -> return FP.nullPtr
        Just jStream -> do
            jStream' <- unsafeManagedPtrCastPtr jStream
            return jStream'
    result <- gtk_video_new_for_media_stream maybeStream
    checkUnexpectedReturnNULL "videoNewForMediaStream" result
    result' <- (newObject Video) result
    whenJust stream touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Video::new_for_resource
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "resource_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "resource path to play back"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Video" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_new_for_resource" gtk_video_new_for_resource :: 
    CString ->                              -- resource_path : TBasicType TUTF8
    IO (Ptr Video)

-- | Creates a @GtkVideo@ to play back the resource at the
-- given /@resourcePath@/.
-- 
-- This is a utility function that calls 'GI.Gtk.Objects.Video.videoNewForFile'.
videoNewForResource ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@resourcePath@/: resource path to play back
    -> m Video
    -- ^ __Returns:__ a new @GtkVideo@
videoNewForResource resourcePath = liftIO $ do
    maybeResourcePath <- case resourcePath of
        Nothing -> return FP.nullPtr
        Just jResourcePath -> do
            jResourcePath' <- textToCString jResourcePath
            return jResourcePath'
    result <- gtk_video_new_for_resource maybeResourcePath
    checkUnexpectedReturnNULL "videoNewForResource" result
    result' <- (newObject Video) result
    freeMem maybeResourcePath
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Video::get_autoplay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_get_autoplay" gtk_video_get_autoplay :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    IO CInt

-- | Returns 'P.True' if videos have been set to loop.
videoGetAutoplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if streams should autoplay
videoGetAutoplay self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_video_get_autoplay self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data VideoGetAutoplayMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsVideo a) => O.OverloadedMethod VideoGetAutoplayMethodInfo a signature where
    overloadedMethod = videoGetAutoplay

instance O.OverloadedMethodInfo VideoGetAutoplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoGetAutoplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoGetAutoplay"
        })


#endif

-- method Video::get_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "File" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_get_file" gtk_video_get_file :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    IO (Ptr Gio.File.File)

-- | Gets the file played by /@self@/ or 'P.Nothing' if not playing back
-- a file.
videoGetFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> m (Maybe Gio.File.File)
    -- ^ __Returns:__ The file played by /@self@/
videoGetFile self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_video_get_file self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.File.File) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data VideoGetFileMethodInfo
instance (signature ~ (m (Maybe Gio.File.File)), MonadIO m, IsVideo a) => O.OverloadedMethod VideoGetFileMethodInfo a signature where
    overloadedMethod = videoGetFile

instance O.OverloadedMethodInfo VideoGetFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoGetFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoGetFile"
        })


#endif

-- method Video::get_graphics_offload
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "GraphicsOffloadEnabled" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_get_graphics_offload" gtk_video_get_graphics_offload :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    IO CUInt

-- | Returns whether graphics offload is enabled.
-- 
-- See t'GI.Gtk.Objects.GraphicsOffload.GraphicsOffload' for more information on graphics offload.
-- 
-- /Since: 4.14/
videoGetGraphicsOffload ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> m Gtk.Enums.GraphicsOffloadEnabled
    -- ^ __Returns:__ the graphics offload status
videoGetGraphicsOffload self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_video_get_graphics_offload self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data VideoGetGraphicsOffloadMethodInfo
instance (signature ~ (m Gtk.Enums.GraphicsOffloadEnabled), MonadIO m, IsVideo a) => O.OverloadedMethod VideoGetGraphicsOffloadMethodInfo a signature where
    overloadedMethod = videoGetGraphicsOffload

instance O.OverloadedMethodInfo VideoGetGraphicsOffloadMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoGetGraphicsOffload",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoGetGraphicsOffload"
        })


#endif

-- method Video::get_loop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_get_loop" gtk_video_get_loop :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    IO CInt

-- | Returns 'P.True' if videos have been set to loop.
videoGetLoop ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if streams should loop
videoGetLoop self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_video_get_loop self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data VideoGetLoopMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsVideo a) => O.OverloadedMethod VideoGetLoopMethodInfo a signature where
    overloadedMethod = videoGetLoop

instance O.OverloadedMethodInfo VideoGetLoopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoGetLoop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoGetLoop"
        })


#endif

-- method Video::get_media_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "MediaStream" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_get_media_stream" gtk_video_get_media_stream :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    IO (Ptr Gtk.MediaStream.MediaStream)

-- | Gets the media stream managed by /@self@/ or 'P.Nothing' if none.
videoGetMediaStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> m (Maybe Gtk.MediaStream.MediaStream)
    -- ^ __Returns:__ The media stream managed by /@self@/
videoGetMediaStream self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_video_get_media_stream self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.MediaStream.MediaStream) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data VideoGetMediaStreamMethodInfo
instance (signature ~ (m (Maybe Gtk.MediaStream.MediaStream)), MonadIO m, IsVideo a) => O.OverloadedMethod VideoGetMediaStreamMethodInfo a signature where
    overloadedMethod = videoGetMediaStream

instance O.OverloadedMethodInfo VideoGetMediaStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoGetMediaStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoGetMediaStream"
        })


#endif

-- method Video::set_autoplay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "autoplay"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether media streams should autoplay"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_set_autoplay" gtk_video_set_autoplay :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    CInt ->                                 -- autoplay : TBasicType TBoolean
    IO ()

-- | Sets whether /@self@/ automatically starts playback when it
-- becomes visible or when a new file gets loaded.
videoSetAutoplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> Bool
    -- ^ /@autoplay@/: whether media streams should autoplay
    -> m ()
videoSetAutoplay self autoplay = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let autoplay' = (P.fromIntegral . P.fromEnum) autoplay
    gtk_video_set_autoplay self' autoplay'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data VideoSetAutoplayMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsVideo a) => O.OverloadedMethod VideoSetAutoplayMethodInfo a signature where
    overloadedMethod = videoSetAutoplay

instance O.OverloadedMethodInfo VideoSetAutoplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoSetAutoplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoSetAutoplay"
        })


#endif

-- method Video::set_file
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "file"
--           , argType = TInterface Name { namespace = "Gio" , name = "File" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the file to play" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_set_file" gtk_video_set_file :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    Ptr Gio.File.File ->                    -- file : TInterface (Name {namespace = "Gio", name = "File"})
    IO ()

-- | Makes /@self@/ play the given /@file@/.
videoSetFile ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a, Gio.File.IsFile b) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> Maybe (b)
    -- ^ /@file@/: the file to play
    -> m ()
videoSetFile self file = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFile <- case file of
        Nothing -> return FP.nullPtr
        Just jFile -> do
            jFile' <- unsafeManagedPtrCastPtr jFile
            return jFile'
    gtk_video_set_file self' maybeFile
    touchManagedPtr self
    whenJust file touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data VideoSetFileMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsVideo a, Gio.File.IsFile b) => O.OverloadedMethod VideoSetFileMethodInfo a signature where
    overloadedMethod = videoSetFile

instance O.OverloadedMethodInfo VideoSetFileMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoSetFile",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoSetFile"
        })


#endif

-- method Video::set_filename
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "filename"
--           , argType = TBasicType TFileName
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the filename to play"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_set_filename" gtk_video_set_filename :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    CString ->                              -- filename : TBasicType TFileName
    IO ()

-- | Makes /@self@/ play the given /@filename@/.
-- 
-- This is a utility function that calls 'GI.Gtk.Objects.Video.videoSetFile',
videoSetFilename ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> Maybe ([Char])
    -- ^ /@filename@/: the filename to play
    -> m ()
videoSetFilename self filename = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeFilename <- case filename of
        Nothing -> return FP.nullPtr
        Just jFilename -> do
            jFilename' <- stringToCString jFilename
            return jFilename'
    gtk_video_set_filename self' maybeFilename
    touchManagedPtr self
    freeMem maybeFilename
    return ()

#if defined(ENABLE_OVERLOADING)
data VideoSetFilenameMethodInfo
instance (signature ~ (Maybe ([Char]) -> m ()), MonadIO m, IsVideo a) => O.OverloadedMethod VideoSetFilenameMethodInfo a signature where
    overloadedMethod = videoSetFilename

instance O.OverloadedMethodInfo VideoSetFilenameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoSetFilename",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoSetFilename"
        })


#endif

-- method Video::set_graphics_offload
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "enabled"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "GraphicsOffloadEnabled" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new graphics offload status"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_set_graphics_offload" gtk_video_set_graphics_offload :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    CUInt ->                                -- enabled : TInterface (Name {namespace = "Gtk", name = "GraphicsOffloadEnabled"})
    IO ()

-- | Sets whether to enable graphics offload.
-- 
-- See t'GI.Gtk.Objects.GraphicsOffload.GraphicsOffload' for more information on graphics offload.
-- 
-- /Since: 4.14/
videoSetGraphicsOffload ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> Gtk.Enums.GraphicsOffloadEnabled
    -- ^ /@enabled@/: the new graphics offload status
    -> m ()
videoSetGraphicsOffload self enabled = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let enabled' = (fromIntegral . fromEnum) enabled
    gtk_video_set_graphics_offload self' enabled'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data VideoSetGraphicsOffloadMethodInfo
instance (signature ~ (Gtk.Enums.GraphicsOffloadEnabled -> m ()), MonadIO m, IsVideo a) => O.OverloadedMethod VideoSetGraphicsOffloadMethodInfo a signature where
    overloadedMethod = videoSetGraphicsOffload

instance O.OverloadedMethodInfo VideoSetGraphicsOffloadMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoSetGraphicsOffload",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoSetGraphicsOffload"
        })


#endif

-- method Video::set_loop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "loop"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether media streams should loop"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_set_loop" gtk_video_set_loop :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    CInt ->                                 -- loop : TBasicType TBoolean
    IO ()

-- | Sets whether new files loaded by /@self@/ should be set to loop.
videoSetLoop ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> Bool
    -- ^ /@loop@/: whether media streams should loop
    -> m ()
videoSetLoop self loop = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let loop' = (P.fromIntegral . P.fromEnum) loop
    gtk_video_set_loop self' loop'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data VideoSetLoopMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsVideo a) => O.OverloadedMethod VideoSetLoopMethodInfo a signature where
    overloadedMethod = videoSetLoop

instance O.OverloadedMethodInfo VideoSetLoopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoSetLoop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoSetLoop"
        })


#endif

-- method Video::set_media_stream
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "stream"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "MediaStream" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The media stream to play or %NULL to unset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_set_media_stream" gtk_video_set_media_stream :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    Ptr Gtk.MediaStream.MediaStream ->      -- stream : TInterface (Name {namespace = "Gtk", name = "MediaStream"})
    IO ()

-- | Sets the media stream to be played back.
-- 
-- /@self@/ will take full control of managing the media stream. If you
-- want to manage a media stream yourself, consider using a
-- t'GI.Gtk.Objects.Picture.Picture' for display.
-- 
-- If you want to display a file, consider using 'GI.Gtk.Objects.Video.videoSetFile'
-- instead.
videoSetMediaStream ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a, Gtk.MediaStream.IsMediaStream b) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> Maybe (b)
    -- ^ /@stream@/: The media stream to play or 'P.Nothing' to unset
    -> m ()
videoSetMediaStream self stream = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeStream <- case stream of
        Nothing -> return FP.nullPtr
        Just jStream -> do
            jStream' <- unsafeManagedPtrCastPtr jStream
            return jStream'
    gtk_video_set_media_stream self' maybeStream
    touchManagedPtr self
    whenJust stream touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data VideoSetMediaStreamMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsVideo a, Gtk.MediaStream.IsMediaStream b) => O.OverloadedMethod VideoSetMediaStreamMethodInfo a signature where
    overloadedMethod = videoSetMediaStream

instance O.OverloadedMethodInfo VideoSetMediaStreamMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoSetMediaStream",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoSetMediaStream"
        })


#endif

-- method Video::set_resource
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Video" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkVideo`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "resource_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the resource to set"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_video_set_resource" gtk_video_set_resource :: 
    Ptr Video ->                            -- self : TInterface (Name {namespace = "Gtk", name = "Video"})
    CString ->                              -- resource_path : TBasicType TUTF8
    IO ()

-- | Makes /@self@/ play the resource at the given /@resourcePath@/.
-- 
-- This is a utility function that calls 'GI.Gtk.Objects.Video.videoSetFile'.
videoSetResource ::
    (B.CallStack.HasCallStack, MonadIO m, IsVideo a) =>
    a
    -- ^ /@self@/: a @GtkVideo@
    -> Maybe (T.Text)
    -- ^ /@resourcePath@/: the resource to set
    -> m ()
videoSetResource self resourcePath = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeResourcePath <- case resourcePath of
        Nothing -> return FP.nullPtr
        Just jResourcePath -> do
            jResourcePath' <- textToCString jResourcePath
            return jResourcePath'
    gtk_video_set_resource self' maybeResourcePath
    touchManagedPtr self
    freeMem maybeResourcePath
    return ()

#if defined(ENABLE_OVERLOADING)
data VideoSetResourceMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsVideo a) => O.OverloadedMethod VideoSetResourceMethodInfo a signature where
    overloadedMethod = videoSetResource

instance O.OverloadedMethodInfo VideoSetResourceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Video.videoSetResource",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Video.html#v:videoSetResource"
        })


#endif


