{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Asynchronous API to open a uri with an application.
-- 
-- @GtkUriLauncher@ collects the arguments that are needed to open the uri.
-- 
-- Depending on system configuration, user preferences and available APIs, this
-- may or may not show an app chooser dialog or launch the default application
-- right away.
-- 
-- The operation is started with the 'GI.Gtk.Objects.UriLauncher.uriLauncherLaunch' function.
-- 
-- To launch a file, use t'GI.Gtk.Objects.FileLauncher.FileLauncher'.
-- 
-- /Since: 4.10/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.UriLauncher
    ( 

-- * Exported types
    UriLauncher(..)                         ,
    IsUriLauncher                           ,
    toUriLauncher                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [launch]("GI.Gtk.Objects.UriLauncher#g:method:launch"), [launchFinish]("GI.Gtk.Objects.UriLauncher#g:method:launchFinish"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getUri]("GI.Gtk.Objects.UriLauncher#g:method:getUri").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setUri]("GI.Gtk.Objects.UriLauncher#g:method:setUri").

#if defined(ENABLE_OVERLOADING)
    ResolveUriLauncherMethod                ,
#endif

-- ** getUri #method:getUri#

#if defined(ENABLE_OVERLOADING)
    UriLauncherGetUriMethodInfo             ,
#endif
    uriLauncherGetUri                       ,


-- ** launch #method:launch#

#if defined(ENABLE_OVERLOADING)
    UriLauncherLaunchMethodInfo             ,
#endif
    uriLauncherLaunch                       ,


-- ** launchFinish #method:launchFinish#

#if defined(ENABLE_OVERLOADING)
    UriLauncherLaunchFinishMethodInfo       ,
#endif
    uriLauncherLaunchFinish                 ,


-- ** new #method:new#

    uriLauncherNew                          ,


-- ** setUri #method:setUri#

#if defined(ENABLE_OVERLOADING)
    UriLauncherSetUriMethodInfo             ,
#endif
    uriLauncherSetUri                       ,




 -- * Properties


-- ** uri #attr:uri#
-- | The uri to launch.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    UriLauncherUriPropertyInfo              ,
#endif
    clearUriLauncherUri                     ,
    constructUriLauncherUri                 ,
    getUriLauncherUri                       ,
    setUriLauncherUri                       ,
#if defined(ENABLE_OVERLOADING)
    uriLauncherUri                          ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window

#endif

-- | Memory-managed wrapper type.
newtype UriLauncher = UriLauncher (SP.ManagedPtr UriLauncher)
    deriving (Eq)

instance SP.ManagedPtrNewtype UriLauncher where
    toManagedPtr (UriLauncher p) = p

foreign import ccall "gtk_uri_launcher_get_type"
    c_gtk_uri_launcher_get_type :: IO B.Types.GType

instance B.Types.TypedObject UriLauncher where
    glibType = c_gtk_uri_launcher_get_type

instance B.Types.GObject UriLauncher

-- | Type class for types which can be safely cast to `UriLauncher`, for instance with `toUriLauncher`.
class (SP.GObject o, O.IsDescendantOf UriLauncher o) => IsUriLauncher o
instance (SP.GObject o, O.IsDescendantOf UriLauncher o) => IsUriLauncher o

instance O.HasParentTypes UriLauncher
type instance O.ParentTypes UriLauncher = '[GObject.Object.Object]

-- | Cast to `UriLauncher`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toUriLauncher :: (MIO.MonadIO m, IsUriLauncher o) => o -> m UriLauncher
toUriLauncher = MIO.liftIO . B.ManagedPtr.unsafeCastTo UriLauncher

-- | Convert 'UriLauncher' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe UriLauncher) where
    gvalueGType_ = c_gtk_uri_launcher_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr UriLauncher)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr UriLauncher)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject UriLauncher ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveUriLauncherMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveUriLauncherMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveUriLauncherMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveUriLauncherMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveUriLauncherMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveUriLauncherMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveUriLauncherMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveUriLauncherMethod "launch" o = UriLauncherLaunchMethodInfo
    ResolveUriLauncherMethod "launchFinish" o = UriLauncherLaunchFinishMethodInfo
    ResolveUriLauncherMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveUriLauncherMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveUriLauncherMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveUriLauncherMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveUriLauncherMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveUriLauncherMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveUriLauncherMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveUriLauncherMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveUriLauncherMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveUriLauncherMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveUriLauncherMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveUriLauncherMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveUriLauncherMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveUriLauncherMethod "getUri" o = UriLauncherGetUriMethodInfo
    ResolveUriLauncherMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveUriLauncherMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveUriLauncherMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveUriLauncherMethod "setUri" o = UriLauncherSetUriMethodInfo
    ResolveUriLauncherMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveUriLauncherMethod t UriLauncher, O.OverloadedMethod info UriLauncher p) => OL.IsLabel t (UriLauncher -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveUriLauncherMethod t UriLauncher, O.OverloadedMethod info UriLauncher p, R.HasField t UriLauncher p) => R.HasField t UriLauncher p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveUriLauncherMethod t UriLauncher, O.OverloadedMethodInfo info UriLauncher) => OL.IsLabel t (O.MethodProxy info UriLauncher) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@uri@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' uriLauncher #uri
-- @
getUriLauncherUri :: (MonadIO m, IsUriLauncher o) => o -> m (Maybe T.Text)
getUriLauncherUri obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "uri"

-- | Set the value of the “@uri@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' uriLauncher [ #uri 'Data.GI.Base.Attributes.:=' value ]
-- @
setUriLauncherUri :: (MonadIO m, IsUriLauncher o) => o -> T.Text -> m ()
setUriLauncherUri obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "uri" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@uri@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructUriLauncherUri :: (IsUriLauncher o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructUriLauncherUri val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "uri" (P.Just val)

-- | Set the value of the “@uri@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #uri
-- @
clearUriLauncherUri :: (MonadIO m, IsUriLauncher o) => o -> m ()
clearUriLauncherUri obj = liftIO $ B.Properties.setObjectPropertyString obj "uri" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data UriLauncherUriPropertyInfo
instance AttrInfo UriLauncherUriPropertyInfo where
    type AttrAllowedOps UriLauncherUriPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint UriLauncherUriPropertyInfo = IsUriLauncher
    type AttrSetTypeConstraint UriLauncherUriPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint UriLauncherUriPropertyInfo = (~) T.Text
    type AttrTransferType UriLauncherUriPropertyInfo = T.Text
    type AttrGetType UriLauncherUriPropertyInfo = (Maybe T.Text)
    type AttrLabel UriLauncherUriPropertyInfo = "uri"
    type AttrOrigin UriLauncherUriPropertyInfo = UriLauncher
    attrGet = getUriLauncherUri
    attrSet = setUriLauncherUri
    attrTransfer _ v = do
        return v
    attrConstruct = constructUriLauncherUri
    attrClear = clearUriLauncherUri
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.UriLauncher.uri"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-UriLauncher.html#g:attr:uri"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList UriLauncher
type instance O.AttributeList UriLauncher = UriLauncherAttributeList
type UriLauncherAttributeList = ('[ '("uri", UriLauncherUriPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
uriLauncherUri :: AttrLabelProxy "uri"
uriLauncherUri = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList UriLauncher = UriLauncherSignalList
type UriLauncherSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method UriLauncher::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the uri to open" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "UriLauncher" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_uri_launcher_new" gtk_uri_launcher_new :: 
    CString ->                              -- uri : TBasicType TUTF8
    IO (Ptr UriLauncher)

-- | Creates a new @GtkUriLauncher@ object.
-- 
-- /Since: 4.10/
uriLauncherNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@uri@/: the uri to open
    -> m UriLauncher
    -- ^ __Returns:__ the new @GtkUriLauncher@
uriLauncherNew uri = liftIO $ do
    maybeUri <- case uri of
        Nothing -> return FP.nullPtr
        Just jUri -> do
            jUri' <- textToCString jUri
            return jUri'
    result <- gtk_uri_launcher_new maybeUri
    checkUnexpectedReturnNULL "uriLauncherNew" result
    result' <- (wrapObject UriLauncher) result
    freeMem maybeUri
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method UriLauncher::get_uri
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "UriLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an uri launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_uri_launcher_get_uri" gtk_uri_launcher_get_uri :: 
    Ptr UriLauncher ->                      -- self : TInterface (Name {namespace = "Gtk", name = "UriLauncher"})
    IO CString

-- | Gets the uri that will be opened.
-- 
-- /Since: 4.10/
uriLauncherGetUri ::
    (B.CallStack.HasCallStack, MonadIO m, IsUriLauncher a) =>
    a
    -- ^ /@self@/: an uri launcher
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the uri
uriLauncherGetUri self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_uri_launcher_get_uri self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data UriLauncherGetUriMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsUriLauncher a) => O.OverloadedMethod UriLauncherGetUriMethodInfo a signature where
    overloadedMethod = uriLauncherGetUri

instance O.OverloadedMethodInfo UriLauncherGetUriMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.UriLauncher.uriLauncherGetUri",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-UriLauncher.html#v:uriLauncherGetUri"
        })


#endif

-- method UriLauncher::launch
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "UriLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an uri launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the parent window" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a cancellable to cancel the operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a callback to call when the\n  operation is complete"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 4
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_uri_launcher_launch" gtk_uri_launcher_launch :: 
    Ptr UriLauncher ->                      -- self : TInterface (Name {namespace = "Gtk", name = "UriLauncher"})
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Launches an application to open the uri.
-- 
-- This may present an app chooser dialog to the user.
-- 
-- /Since: 4.10/
uriLauncherLaunch ::
    (B.CallStack.HasCallStack, MonadIO m, IsUriLauncher a, Gtk.Window.IsWindow b, Gio.Cancellable.IsCancellable c) =>
    a
    -- ^ /@self@/: an uri launcher
    -> Maybe (b)
    -- ^ /@parent@/: the parent window
    -> Maybe (c)
    -- ^ /@cancellable@/: a cancellable to cancel the operation
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a callback to call when the
    --   operation is complete
    -> m ()
uriLauncherLaunch self parent cancellable callback = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gtk_uri_launcher_launch self' maybeParent maybeCancellable maybeCallback userData
    touchManagedPtr self
    whenJust parent touchManagedPtr
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data UriLauncherLaunchMethodInfo
instance (signature ~ (Maybe (b) -> Maybe (c) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsUriLauncher a, Gtk.Window.IsWindow b, Gio.Cancellable.IsCancellable c) => O.OverloadedMethod UriLauncherLaunchMethodInfo a signature where
    overloadedMethod = uriLauncherLaunch

instance O.OverloadedMethodInfo UriLauncherLaunchMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.UriLauncher.uriLauncherLaunch",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-UriLauncher.html#v:uriLauncherLaunch"
        })


#endif

-- method UriLauncher::launch_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "UriLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an uri launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the result" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gtk_uri_launcher_launch_finish" gtk_uri_launcher_launch_finish :: 
    Ptr UriLauncher ->                      -- self : TInterface (Name {namespace = "Gtk", name = "UriLauncher"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Finishes the 'GI.Gtk.Objects.UriLauncher.uriLauncherLaunch' call and
-- returns the result.
-- 
-- /Since: 4.10/
uriLauncherLaunchFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsUriLauncher a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@self@/: an uri launcher
    -> b
    -- ^ /@result@/: the result
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
uriLauncherLaunchFinish self result_ = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        _ <- propagateGError $ gtk_uri_launcher_launch_finish self' result_'
        touchManagedPtr self
        touchManagedPtr result_
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data UriLauncherLaunchFinishMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsUriLauncher a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod UriLauncherLaunchFinishMethodInfo a signature where
    overloadedMethod = uriLauncherLaunchFinish

instance O.OverloadedMethodInfo UriLauncherLaunchFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.UriLauncher.uriLauncherLaunchFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-UriLauncher.html#v:uriLauncherLaunchFinish"
        })


#endif

-- method UriLauncher::set_uri
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "UriLauncher" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an uri launcher" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "uri"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the uri" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_uri_launcher_set_uri" gtk_uri_launcher_set_uri :: 
    Ptr UriLauncher ->                      -- self : TInterface (Name {namespace = "Gtk", name = "UriLauncher"})
    CString ->                              -- uri : TBasicType TUTF8
    IO ()

-- | Sets the uri that will be opened.
-- 
-- /Since: 4.10/
uriLauncherSetUri ::
    (B.CallStack.HasCallStack, MonadIO m, IsUriLauncher a) =>
    a
    -- ^ /@self@/: an uri launcher
    -> Maybe (T.Text)
    -- ^ /@uri@/: the uri
    -> m ()
uriLauncherSetUri self uri = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeUri <- case uri of
        Nothing -> return FP.nullPtr
        Just jUri -> do
            jUri' <- textToCString jUri
            return jUri'
    gtk_uri_launcher_set_uri self' maybeUri
    touchManagedPtr self
    freeMem maybeUri
    return ()

#if defined(ENABLE_OVERLOADING)
data UriLauncherSetUriMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsUriLauncher a) => O.OverloadedMethod UriLauncherSetUriMethodInfo a signature where
    overloadedMethod = uriLauncherSetUri

instance O.OverloadedMethodInfo UriLauncherSetUriMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.UriLauncher.uriLauncherSetUri",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-UriLauncher.html#v:uriLauncherSetUri"
        })


#endif


