{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Provides an expander for a tree-like list.
-- 
-- It is typically placed as a bottommost child into a @GtkListView@
-- to allow users to expand and collapse children in a list with a
-- t'GI.Gtk.Objects.TreeListModel.TreeListModel'. @GtkTreeExpander@ provides the common UI
-- elements, gestures and keybindings for this purpose.
-- 
-- On top of this, the \"listitem.expand\", \"listitem.collapse\" and
-- \"listitem.toggle-expand\" actions are provided to allow adding custom
-- UI for managing expanded state.
-- 
-- It is important to mention that you want to set the
-- [ListItem:focusable]("GI.Gtk.Objects.ListItem#g:attr:focusable") property to FALSE when using this
-- widget, as you want the keyboard focus to be in the treexpander, and not
-- inside the list to make use of the keybindings.
-- 
-- The @GtkTreeListModel@ must be set to not be passthrough. Then it
-- will provide t'GI.Gtk.Objects.TreeListRow.TreeListRow' items which can be set via
-- 'GI.Gtk.Objects.TreeExpander.treeExpanderSetListRow' on the expander.
-- The expander will then watch that row item automatically.
-- 'GI.Gtk.Objects.TreeExpander.treeExpanderSetChild' sets the widget that displays
-- the actual row contents.
-- 
-- @GtkTreeExpander@ can be modified with properties such as
-- [TreeExpander:indentForIcon]("GI.Gtk.Objects.TreeExpander#g:attr:indentForIcon"),
-- [TreeExpander:indentForDepth]("GI.Gtk.Objects.TreeExpander#g:attr:indentForDepth"), and
-- [TreeExpander:hideExpander]("GI.Gtk.Objects.TreeExpander#g:attr:hideExpander") to achieve a different appearance.
-- This can even be done to influence individual rows, for example by binding
-- the [TreeExpander:hideExpander]("GI.Gtk.Objects.TreeExpander#g:attr:hideExpander") property to the item count of
-- the model of the treelistrow, to hide the expander for rows without children,
-- even if the row is expandable.
-- 
-- == Shortcuts and Gestures
-- 
-- @GtkTreeExpander@ supports the following keyboard shortcuts:
-- 
-- * \<kbd>+\<\/kbd> or \<kbd>*\<\/kbd> expands the expander.
-- * \<kbd>-\<\/kbd> or \<kbd>\/\<\/kbd> collapses the expander.
-- * Left and right arrow keys, when combined with \<kbd>Shift\<\/kbd> or
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Shift\<\/kbd>, will expand or collapse, depending on
-- the locale\'s text direction.
-- * \<kbd>Ctrl\<\/kbd>+\<kbd>␣\<\/kbd> toggles the expander state.
-- 
-- 
-- The row can also expand on drag gestures.
-- 
-- == Actions
-- 
-- @GtkTreeExpander@ defines a set of built-in actions:
-- 
-- * @listitem.expand@ expands the expander if it can be expanded.
-- * @listitem.collapse@ collapses the expander.
-- * @listitem.toggle-expand@ tries to expand the expander if it was collapsed
-- or collapses it if it was expanded.
-- 
-- 
-- == CSS nodes
-- 
-- >treeexpander
-- >├── [indent]*
-- >├── [expander]
-- >╰── <child>
-- 
-- 
-- @GtkTreeExpander@ has zero or one CSS nodes with the name \"expander\" that
-- should display the expander icon. The node will be @:checked@ when it
-- is expanded. If the node is not expandable, an \"indent\" node will be
-- displayed instead.
-- 
-- For every level of depth, another \"indent\" node is prepended.
-- 
-- == Accessibility
-- 
-- Until GTK 4.10, @GtkTreeExpander@ used the [enum/@gtk@/.AccessibleRole.group] role.
-- 
-- Since GTK 4.12, @GtkTreeExpander@ uses the [enum/@gtk@/.AccessibleRole.button] role.
-- Toggling it will change the @GTK_ACCESSIBLE_STATE_EXPANDED@ state.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.TreeExpander
    ( 

-- * Exported types
    TreeExpander(..)                        ,
    IsTreeExpander                          ,
    toTreeExpander                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.TreeExpander#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHideExpander]("GI.Gtk.Objects.TreeExpander#g:method:getHideExpander"), [getIndentForDepth]("GI.Gtk.Objects.TreeExpander#g:method:getIndentForDepth"), [getIndentForIcon]("GI.Gtk.Objects.TreeExpander#g:method:getIndentForIcon"), [getItem]("GI.Gtk.Objects.TreeExpander#g:method:getItem"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getListRow]("GI.Gtk.Objects.TreeExpander#g:method:getListRow"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.TreeExpander#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHideExpander]("GI.Gtk.Objects.TreeExpander#g:method:setHideExpander"), [setIndentForDepth]("GI.Gtk.Objects.TreeExpander#g:method:setIndentForDepth"), [setIndentForIcon]("GI.Gtk.Objects.TreeExpander#g:method:setIndentForIcon"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setListRow]("GI.Gtk.Objects.TreeExpander#g:method:setListRow"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveTreeExpanderMethod               ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    TreeExpanderGetChildMethodInfo          ,
#endif
    treeExpanderGetChild                    ,


-- ** getHideExpander #method:getHideExpander#

#if defined(ENABLE_OVERLOADING)
    TreeExpanderGetHideExpanderMethodInfo   ,
#endif
    treeExpanderGetHideExpander             ,


-- ** getIndentForDepth #method:getIndentForDepth#

#if defined(ENABLE_OVERLOADING)
    TreeExpanderGetIndentForDepthMethodInfo ,
#endif
    treeExpanderGetIndentForDepth           ,


-- ** getIndentForIcon #method:getIndentForIcon#

#if defined(ENABLE_OVERLOADING)
    TreeExpanderGetIndentForIconMethodInfo  ,
#endif
    treeExpanderGetIndentForIcon            ,


-- ** getItem #method:getItem#

#if defined(ENABLE_OVERLOADING)
    TreeExpanderGetItemMethodInfo           ,
#endif
    treeExpanderGetItem                     ,


-- ** getListRow #method:getListRow#

#if defined(ENABLE_OVERLOADING)
    TreeExpanderGetListRowMethodInfo        ,
#endif
    treeExpanderGetListRow                  ,


-- ** new #method:new#

    treeExpanderNew                         ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    TreeExpanderSetChildMethodInfo          ,
#endif
    treeExpanderSetChild                    ,


-- ** setHideExpander #method:setHideExpander#

#if defined(ENABLE_OVERLOADING)
    TreeExpanderSetHideExpanderMethodInfo   ,
#endif
    treeExpanderSetHideExpander             ,


-- ** setIndentForDepth #method:setIndentForDepth#

#if defined(ENABLE_OVERLOADING)
    TreeExpanderSetIndentForDepthMethodInfo ,
#endif
    treeExpanderSetIndentForDepth           ,


-- ** setIndentForIcon #method:setIndentForIcon#

#if defined(ENABLE_OVERLOADING)
    TreeExpanderSetIndentForIconMethodInfo  ,
#endif
    treeExpanderSetIndentForIcon            ,


-- ** setListRow #method:setListRow#

#if defined(ENABLE_OVERLOADING)
    TreeExpanderSetListRowMethodInfo        ,
#endif
    treeExpanderSetListRow                  ,




 -- * Properties


-- ** child #attr:child#
-- | The child widget with the actual contents.

#if defined(ENABLE_OVERLOADING)
    TreeExpanderChildPropertyInfo           ,
#endif
    clearTreeExpanderChild                  ,
    constructTreeExpanderChild              ,
    getTreeExpanderChild                    ,
    setTreeExpanderChild                    ,
#if defined(ENABLE_OVERLOADING)
    treeExpanderChild                       ,
#endif


-- ** hideExpander #attr:hideExpander#
-- | Whether the expander icon should be hidden in a GtkTreeListRow.
-- Note that this property simply hides the icon.  The actions and keybinding
-- (i.e. collapse and expand) are not affected by this property.
-- 
-- A common use for this property would be to bind to the number of children in a
-- GtkTreeListRow\'s model in order to hide the expander when a row has no children.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    TreeExpanderHideExpanderPropertyInfo    ,
#endif
    constructTreeExpanderHideExpander       ,
    getTreeExpanderHideExpander             ,
    setTreeExpanderHideExpander             ,
#if defined(ENABLE_OVERLOADING)
    treeExpanderHideExpander                ,
#endif


-- ** indentForDepth #attr:indentForDepth#
-- | TreeExpander indents the child according to its depth.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    TreeExpanderIndentForDepthPropertyInfo  ,
#endif
    constructTreeExpanderIndentForDepth     ,
    getTreeExpanderIndentForDepth           ,
    setTreeExpanderIndentForDepth           ,
#if defined(ENABLE_OVERLOADING)
    treeExpanderIndentForDepth              ,
#endif


-- ** indentForIcon #attr:indentForIcon#
-- | TreeExpander indents the child by the width of an expander-icon if it is not expandable.
-- 
-- /Since: 4.6/

#if defined(ENABLE_OVERLOADING)
    TreeExpanderIndentForIconPropertyInfo   ,
#endif
    constructTreeExpanderIndentForIcon      ,
    getTreeExpanderIndentForIcon            ,
    setTreeExpanderIndentForIcon            ,
#if defined(ENABLE_OVERLOADING)
    treeExpanderIndentForIcon               ,
#endif


-- ** item #attr:item#
-- | The item held by this expander\'s row.

#if defined(ENABLE_OVERLOADING)
    TreeExpanderItemPropertyInfo            ,
#endif
    getTreeExpanderItem                     ,
#if defined(ENABLE_OVERLOADING)
    treeExpanderItem                        ,
#endif


-- ** listRow #attr:listRow#
-- | The list row to track for expander state.

#if defined(ENABLE_OVERLOADING)
    TreeExpanderListRowPropertyInfo         ,
#endif
    clearTreeExpanderListRow                ,
    constructTreeExpanderListRow            ,
    getTreeExpanderListRow                  ,
    setTreeExpanderListRow                  ,
#if defined(ENABLE_OVERLOADING)
    treeExpanderListRow                     ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.TreeListRow as Gtk.TreeListRow
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.TreeListRow as Gtk.TreeListRow
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype TreeExpander = TreeExpander (SP.ManagedPtr TreeExpander)
    deriving (Eq)

instance SP.ManagedPtrNewtype TreeExpander where
    toManagedPtr (TreeExpander p) = p

foreign import ccall "gtk_tree_expander_get_type"
    c_gtk_tree_expander_get_type :: IO B.Types.GType

instance B.Types.TypedObject TreeExpander where
    glibType = c_gtk_tree_expander_get_type

instance B.Types.GObject TreeExpander

-- | Type class for types which can be safely cast to `TreeExpander`, for instance with `toTreeExpander`.
class (SP.GObject o, O.IsDescendantOf TreeExpander o) => IsTreeExpander o
instance (SP.GObject o, O.IsDescendantOf TreeExpander o) => IsTreeExpander o

instance O.HasParentTypes TreeExpander
type instance O.ParentTypes TreeExpander = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `TreeExpander`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toTreeExpander :: (MIO.MonadIO m, IsTreeExpander o) => o -> m TreeExpander
toTreeExpander = MIO.liftIO . B.ManagedPtr.unsafeCastTo TreeExpander

-- | Convert 'TreeExpander' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TreeExpander) where
    gvalueGType_ = c_gtk_tree_expander_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TreeExpander)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TreeExpander)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TreeExpander ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveTreeExpanderMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTreeExpanderMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveTreeExpanderMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveTreeExpanderMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveTreeExpanderMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveTreeExpanderMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveTreeExpanderMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveTreeExpanderMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveTreeExpanderMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveTreeExpanderMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveTreeExpanderMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveTreeExpanderMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTreeExpanderMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTreeExpanderMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveTreeExpanderMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveTreeExpanderMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveTreeExpanderMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveTreeExpanderMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveTreeExpanderMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveTreeExpanderMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveTreeExpanderMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveTreeExpanderMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveTreeExpanderMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveTreeExpanderMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveTreeExpanderMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTreeExpanderMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTreeExpanderMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTreeExpanderMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveTreeExpanderMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveTreeExpanderMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveTreeExpanderMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveTreeExpanderMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveTreeExpanderMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveTreeExpanderMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveTreeExpanderMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveTreeExpanderMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveTreeExpanderMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveTreeExpanderMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveTreeExpanderMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveTreeExpanderMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveTreeExpanderMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTreeExpanderMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveTreeExpanderMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveTreeExpanderMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveTreeExpanderMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveTreeExpanderMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveTreeExpanderMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveTreeExpanderMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveTreeExpanderMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveTreeExpanderMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTreeExpanderMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTreeExpanderMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveTreeExpanderMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveTreeExpanderMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveTreeExpanderMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveTreeExpanderMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveTreeExpanderMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveTreeExpanderMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveTreeExpanderMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTreeExpanderMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTreeExpanderMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveTreeExpanderMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveTreeExpanderMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveTreeExpanderMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveTreeExpanderMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveTreeExpanderMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveTreeExpanderMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveTreeExpanderMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTreeExpanderMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveTreeExpanderMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveTreeExpanderMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveTreeExpanderMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveTreeExpanderMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTreeExpanderMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTreeExpanderMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTreeExpanderMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveTreeExpanderMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveTreeExpanderMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveTreeExpanderMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveTreeExpanderMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveTreeExpanderMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTreeExpanderMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveTreeExpanderMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveTreeExpanderMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveTreeExpanderMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveTreeExpanderMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveTreeExpanderMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveTreeExpanderMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTreeExpanderMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveTreeExpanderMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveTreeExpanderMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveTreeExpanderMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveTreeExpanderMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveTreeExpanderMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveTreeExpanderMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveTreeExpanderMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveTreeExpanderMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveTreeExpanderMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveTreeExpanderMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveTreeExpanderMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveTreeExpanderMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveTreeExpanderMethod "getChild" o = TreeExpanderGetChildMethodInfo
    ResolveTreeExpanderMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveTreeExpanderMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveTreeExpanderMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveTreeExpanderMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveTreeExpanderMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveTreeExpanderMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveTreeExpanderMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTreeExpanderMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveTreeExpanderMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveTreeExpanderMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveTreeExpanderMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveTreeExpanderMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveTreeExpanderMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveTreeExpanderMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveTreeExpanderMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveTreeExpanderMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveTreeExpanderMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveTreeExpanderMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveTreeExpanderMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveTreeExpanderMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveTreeExpanderMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveTreeExpanderMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveTreeExpanderMethod "getHideExpander" o = TreeExpanderGetHideExpanderMethodInfo
    ResolveTreeExpanderMethod "getIndentForDepth" o = TreeExpanderGetIndentForDepthMethodInfo
    ResolveTreeExpanderMethod "getIndentForIcon" o = TreeExpanderGetIndentForIconMethodInfo
    ResolveTreeExpanderMethod "getItem" o = TreeExpanderGetItemMethodInfo
    ResolveTreeExpanderMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveTreeExpanderMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveTreeExpanderMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveTreeExpanderMethod "getListRow" o = TreeExpanderGetListRowMethodInfo
    ResolveTreeExpanderMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveTreeExpanderMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveTreeExpanderMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveTreeExpanderMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveTreeExpanderMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveTreeExpanderMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveTreeExpanderMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveTreeExpanderMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveTreeExpanderMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveTreeExpanderMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveTreeExpanderMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveTreeExpanderMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveTreeExpanderMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveTreeExpanderMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveTreeExpanderMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveTreeExpanderMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveTreeExpanderMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveTreeExpanderMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTreeExpanderMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTreeExpanderMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveTreeExpanderMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveTreeExpanderMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveTreeExpanderMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveTreeExpanderMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveTreeExpanderMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveTreeExpanderMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveTreeExpanderMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveTreeExpanderMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveTreeExpanderMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveTreeExpanderMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveTreeExpanderMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveTreeExpanderMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveTreeExpanderMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveTreeExpanderMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveTreeExpanderMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveTreeExpanderMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveTreeExpanderMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveTreeExpanderMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveTreeExpanderMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveTreeExpanderMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveTreeExpanderMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveTreeExpanderMethod "setChild" o = TreeExpanderSetChildMethodInfo
    ResolveTreeExpanderMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveTreeExpanderMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveTreeExpanderMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveTreeExpanderMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveTreeExpanderMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTreeExpanderMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTreeExpanderMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveTreeExpanderMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveTreeExpanderMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveTreeExpanderMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveTreeExpanderMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveTreeExpanderMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveTreeExpanderMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveTreeExpanderMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveTreeExpanderMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveTreeExpanderMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveTreeExpanderMethod "setHideExpander" o = TreeExpanderSetHideExpanderMethodInfo
    ResolveTreeExpanderMethod "setIndentForDepth" o = TreeExpanderSetIndentForDepthMethodInfo
    ResolveTreeExpanderMethod "setIndentForIcon" o = TreeExpanderSetIndentForIconMethodInfo
    ResolveTreeExpanderMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveTreeExpanderMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveTreeExpanderMethod "setListRow" o = TreeExpanderSetListRowMethodInfo
    ResolveTreeExpanderMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveTreeExpanderMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveTreeExpanderMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveTreeExpanderMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveTreeExpanderMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveTreeExpanderMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveTreeExpanderMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveTreeExpanderMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveTreeExpanderMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTreeExpanderMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveTreeExpanderMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveTreeExpanderMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveTreeExpanderMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveTreeExpanderMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveTreeExpanderMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveTreeExpanderMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveTreeExpanderMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveTreeExpanderMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveTreeExpanderMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveTreeExpanderMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTreeExpanderMethod t TreeExpander, O.OverloadedMethod info TreeExpander p) => OL.IsLabel t (TreeExpander -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTreeExpanderMethod t TreeExpander, O.OverloadedMethod info TreeExpander p, R.HasField t TreeExpander p) => R.HasField t TreeExpander p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTreeExpanderMethod t TreeExpander, O.OverloadedMethodInfo info TreeExpander) => OL.IsLabel t (O.MethodProxy info TreeExpander) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeExpander #child
-- @
getTreeExpanderChild :: (MonadIO m, IsTreeExpander o) => o -> m (Maybe Gtk.Widget.Widget)
getTreeExpanderChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' treeExpander [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setTreeExpanderChild :: (MonadIO m, IsTreeExpander o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setTreeExpanderChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTreeExpanderChild :: (IsTreeExpander o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructTreeExpanderChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearTreeExpanderChild :: (MonadIO m, IsTreeExpander o) => o -> m ()
clearTreeExpanderChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data TreeExpanderChildPropertyInfo
instance AttrInfo TreeExpanderChildPropertyInfo where
    type AttrAllowedOps TreeExpanderChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TreeExpanderChildPropertyInfo = IsTreeExpander
    type AttrSetTypeConstraint TreeExpanderChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint TreeExpanderChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType TreeExpanderChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType TreeExpanderChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel TreeExpanderChildPropertyInfo = "child"
    type AttrOrigin TreeExpanderChildPropertyInfo = TreeExpander
    attrGet = getTreeExpanderChild
    attrSet = setTreeExpanderChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructTreeExpanderChild
    attrClear = clearTreeExpanderChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#g:attr:child"
        })
#endif

-- VVV Prop "hide-expander"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@hide-expander@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeExpander #hideExpander
-- @
getTreeExpanderHideExpander :: (MonadIO m, IsTreeExpander o) => o -> m Bool
getTreeExpanderHideExpander obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "hide-expander"

-- | Set the value of the “@hide-expander@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' treeExpander [ #hideExpander 'Data.GI.Base.Attributes.:=' value ]
-- @
setTreeExpanderHideExpander :: (MonadIO m, IsTreeExpander o) => o -> Bool -> m ()
setTreeExpanderHideExpander obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "hide-expander" val

-- | Construct a `GValueConstruct` with valid value for the “@hide-expander@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTreeExpanderHideExpander :: (IsTreeExpander o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTreeExpanderHideExpander val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "hide-expander" val

#if defined(ENABLE_OVERLOADING)
data TreeExpanderHideExpanderPropertyInfo
instance AttrInfo TreeExpanderHideExpanderPropertyInfo where
    type AttrAllowedOps TreeExpanderHideExpanderPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TreeExpanderHideExpanderPropertyInfo = IsTreeExpander
    type AttrSetTypeConstraint TreeExpanderHideExpanderPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TreeExpanderHideExpanderPropertyInfo = (~) Bool
    type AttrTransferType TreeExpanderHideExpanderPropertyInfo = Bool
    type AttrGetType TreeExpanderHideExpanderPropertyInfo = Bool
    type AttrLabel TreeExpanderHideExpanderPropertyInfo = "hide-expander"
    type AttrOrigin TreeExpanderHideExpanderPropertyInfo = TreeExpander
    attrGet = getTreeExpanderHideExpander
    attrSet = setTreeExpanderHideExpander
    attrTransfer _ v = do
        return v
    attrConstruct = constructTreeExpanderHideExpander
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.hideExpander"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#g:attr:hideExpander"
        })
#endif

-- VVV Prop "indent-for-depth"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@indent-for-depth@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeExpander #indentForDepth
-- @
getTreeExpanderIndentForDepth :: (MonadIO m, IsTreeExpander o) => o -> m Bool
getTreeExpanderIndentForDepth obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "indent-for-depth"

-- | Set the value of the “@indent-for-depth@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' treeExpander [ #indentForDepth 'Data.GI.Base.Attributes.:=' value ]
-- @
setTreeExpanderIndentForDepth :: (MonadIO m, IsTreeExpander o) => o -> Bool -> m ()
setTreeExpanderIndentForDepth obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "indent-for-depth" val

-- | Construct a `GValueConstruct` with valid value for the “@indent-for-depth@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTreeExpanderIndentForDepth :: (IsTreeExpander o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTreeExpanderIndentForDepth val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "indent-for-depth" val

#if defined(ENABLE_OVERLOADING)
data TreeExpanderIndentForDepthPropertyInfo
instance AttrInfo TreeExpanderIndentForDepthPropertyInfo where
    type AttrAllowedOps TreeExpanderIndentForDepthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TreeExpanderIndentForDepthPropertyInfo = IsTreeExpander
    type AttrSetTypeConstraint TreeExpanderIndentForDepthPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TreeExpanderIndentForDepthPropertyInfo = (~) Bool
    type AttrTransferType TreeExpanderIndentForDepthPropertyInfo = Bool
    type AttrGetType TreeExpanderIndentForDepthPropertyInfo = Bool
    type AttrLabel TreeExpanderIndentForDepthPropertyInfo = "indent-for-depth"
    type AttrOrigin TreeExpanderIndentForDepthPropertyInfo = TreeExpander
    attrGet = getTreeExpanderIndentForDepth
    attrSet = setTreeExpanderIndentForDepth
    attrTransfer _ v = do
        return v
    attrConstruct = constructTreeExpanderIndentForDepth
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.indentForDepth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#g:attr:indentForDepth"
        })
#endif

-- VVV Prop "indent-for-icon"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@indent-for-icon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeExpander #indentForIcon
-- @
getTreeExpanderIndentForIcon :: (MonadIO m, IsTreeExpander o) => o -> m Bool
getTreeExpanderIndentForIcon obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "indent-for-icon"

-- | Set the value of the “@indent-for-icon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' treeExpander [ #indentForIcon 'Data.GI.Base.Attributes.:=' value ]
-- @
setTreeExpanderIndentForIcon :: (MonadIO m, IsTreeExpander o) => o -> Bool -> m ()
setTreeExpanderIndentForIcon obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "indent-for-icon" val

-- | Construct a `GValueConstruct` with valid value for the “@indent-for-icon@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTreeExpanderIndentForIcon :: (IsTreeExpander o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTreeExpanderIndentForIcon val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "indent-for-icon" val

#if defined(ENABLE_OVERLOADING)
data TreeExpanderIndentForIconPropertyInfo
instance AttrInfo TreeExpanderIndentForIconPropertyInfo where
    type AttrAllowedOps TreeExpanderIndentForIconPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TreeExpanderIndentForIconPropertyInfo = IsTreeExpander
    type AttrSetTypeConstraint TreeExpanderIndentForIconPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TreeExpanderIndentForIconPropertyInfo = (~) Bool
    type AttrTransferType TreeExpanderIndentForIconPropertyInfo = Bool
    type AttrGetType TreeExpanderIndentForIconPropertyInfo = Bool
    type AttrLabel TreeExpanderIndentForIconPropertyInfo = "indent-for-icon"
    type AttrOrigin TreeExpanderIndentForIconPropertyInfo = TreeExpander
    attrGet = getTreeExpanderIndentForIcon
    attrSet = setTreeExpanderIndentForIcon
    attrTransfer _ v = do
        return v
    attrConstruct = constructTreeExpanderIndentForIcon
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.indentForIcon"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#g:attr:indentForIcon"
        })
#endif

-- VVV Prop "item"
   -- Type: TInterface (Name {namespace = "GObject", name = "Object"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeExpander #item
-- @
getTreeExpanderItem :: (MonadIO m, IsTreeExpander o) => o -> m (Maybe GObject.Object.Object)
getTreeExpanderItem obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "item" GObject.Object.Object

#if defined(ENABLE_OVERLOADING)
data TreeExpanderItemPropertyInfo
instance AttrInfo TreeExpanderItemPropertyInfo where
    type AttrAllowedOps TreeExpanderItemPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TreeExpanderItemPropertyInfo = IsTreeExpander
    type AttrSetTypeConstraint TreeExpanderItemPropertyInfo = (~) ()
    type AttrTransferTypeConstraint TreeExpanderItemPropertyInfo = (~) ()
    type AttrTransferType TreeExpanderItemPropertyInfo = ()
    type AttrGetType TreeExpanderItemPropertyInfo = (Maybe GObject.Object.Object)
    type AttrLabel TreeExpanderItemPropertyInfo = "item"
    type AttrOrigin TreeExpanderItemPropertyInfo = TreeExpander
    attrGet = getTreeExpanderItem
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.item"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#g:attr:item"
        })
#endif

-- VVV Prop "list-row"
   -- Type: TInterface (Name {namespace = "Gtk", name = "TreeListRow"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@list-row@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' treeExpander #listRow
-- @
getTreeExpanderListRow :: (MonadIO m, IsTreeExpander o) => o -> m (Maybe Gtk.TreeListRow.TreeListRow)
getTreeExpanderListRow obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "list-row" Gtk.TreeListRow.TreeListRow

-- | Set the value of the “@list-row@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' treeExpander [ #listRow 'Data.GI.Base.Attributes.:=' value ]
-- @
setTreeExpanderListRow :: (MonadIO m, IsTreeExpander o, Gtk.TreeListRow.IsTreeListRow a) => o -> a -> m ()
setTreeExpanderListRow obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "list-row" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@list-row@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTreeExpanderListRow :: (IsTreeExpander o, MIO.MonadIO m, Gtk.TreeListRow.IsTreeListRow a) => a -> m (GValueConstruct o)
constructTreeExpanderListRow val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "list-row" (P.Just val)

-- | Set the value of the “@list-row@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #listRow
-- @
clearTreeExpanderListRow :: (MonadIO m, IsTreeExpander o) => o -> m ()
clearTreeExpanderListRow obj = liftIO $ B.Properties.setObjectPropertyObject obj "list-row" (Nothing :: Maybe Gtk.TreeListRow.TreeListRow)

#if defined(ENABLE_OVERLOADING)
data TreeExpanderListRowPropertyInfo
instance AttrInfo TreeExpanderListRowPropertyInfo where
    type AttrAllowedOps TreeExpanderListRowPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TreeExpanderListRowPropertyInfo = IsTreeExpander
    type AttrSetTypeConstraint TreeExpanderListRowPropertyInfo = Gtk.TreeListRow.IsTreeListRow
    type AttrTransferTypeConstraint TreeExpanderListRowPropertyInfo = Gtk.TreeListRow.IsTreeListRow
    type AttrTransferType TreeExpanderListRowPropertyInfo = Gtk.TreeListRow.TreeListRow
    type AttrGetType TreeExpanderListRowPropertyInfo = (Maybe Gtk.TreeListRow.TreeListRow)
    type AttrLabel TreeExpanderListRowPropertyInfo = "list-row"
    type AttrOrigin TreeExpanderListRowPropertyInfo = TreeExpander
    attrGet = getTreeExpanderListRow
    attrSet = setTreeExpanderListRow
    attrTransfer _ v = do
        unsafeCastTo Gtk.TreeListRow.TreeListRow v
    attrConstruct = constructTreeExpanderListRow
    attrClear = clearTreeExpanderListRow
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.listRow"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#g:attr:listRow"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TreeExpander
type instance O.AttributeList TreeExpander = TreeExpanderAttributeList
type TreeExpanderAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", TreeExpanderChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hideExpander", TreeExpanderHideExpanderPropertyInfo), '("indentForDepth", TreeExpanderIndentForDepthPropertyInfo), '("indentForIcon", TreeExpanderIndentForIconPropertyInfo), '("item", TreeExpanderItemPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("listRow", TreeExpanderListRowPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
treeExpanderChild :: AttrLabelProxy "child"
treeExpanderChild = AttrLabelProxy

treeExpanderHideExpander :: AttrLabelProxy "hideExpander"
treeExpanderHideExpander = AttrLabelProxy

treeExpanderIndentForDepth :: AttrLabelProxy "indentForDepth"
treeExpanderIndentForDepth = AttrLabelProxy

treeExpanderIndentForIcon :: AttrLabelProxy "indentForIcon"
treeExpanderIndentForIcon = AttrLabelProxy

treeExpanderItem :: AttrLabelProxy "item"
treeExpanderItem = AttrLabelProxy

treeExpanderListRow :: AttrLabelProxy "listRow"
treeExpanderListRow = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TreeExpander = TreeExpanderSignalList
type TreeExpanderSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method TreeExpander::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "TreeExpander" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_new" gtk_tree_expander_new :: 
    IO (Ptr TreeExpander)

-- | Creates a new @GtkTreeExpander@
treeExpanderNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m TreeExpander
    -- ^ __Returns:__ a new @GtkTreeExpander@
treeExpanderNew  = liftIO $ do
    result <- gtk_tree_expander_new
    checkUnexpectedReturnNULL "treeExpanderNew" result
    result' <- (newObject TreeExpander) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TreeExpander::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeExpander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeExpander`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_get_child" gtk_tree_expander_get_child :: 
    Ptr TreeExpander ->                     -- self : TInterface (Name {namespace = "Gtk", name = "TreeExpander"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget displayed by /@self@/.
treeExpanderGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeExpander a) =>
    a
    -- ^ /@self@/: a @GtkTreeExpander@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ The child displayed by /@self@/
treeExpanderGetChild self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_expander_get_child self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeExpanderGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsTreeExpander a) => O.OverloadedMethod TreeExpanderGetChildMethodInfo a signature where
    overloadedMethod = treeExpanderGetChild

instance O.OverloadedMethodInfo TreeExpanderGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.treeExpanderGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#v:treeExpanderGetChild"
        })


#endif

-- method TreeExpander::get_hide_expander
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeExpander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeExpander`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_get_hide_expander" gtk_tree_expander_get_hide_expander :: 
    Ptr TreeExpander ->                     -- self : TInterface (Name {namespace = "Gtk", name = "TreeExpander"})
    IO CInt

-- | Gets whether the TreeExpander should be hidden in a GtkTreeListRow.
-- 
-- /Since: 4.10/
treeExpanderGetHideExpander ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeExpander a) =>
    a
    -- ^ /@self@/: a @GtkTreeExpander@
    -> m Bool
    -- ^ __Returns:__ TRUE if the expander icon should be hidden. Otherwise FALSE.
treeExpanderGetHideExpander self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_expander_get_hide_expander self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data TreeExpanderGetHideExpanderMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTreeExpander a) => O.OverloadedMethod TreeExpanderGetHideExpanderMethodInfo a signature where
    overloadedMethod = treeExpanderGetHideExpander

instance O.OverloadedMethodInfo TreeExpanderGetHideExpanderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.treeExpanderGetHideExpander",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#v:treeExpanderGetHideExpander"
        })


#endif

-- method TreeExpander::get_indent_for_depth
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeExpander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeExpander`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_get_indent_for_depth" gtk_tree_expander_get_indent_for_depth :: 
    Ptr TreeExpander ->                     -- self : TInterface (Name {namespace = "Gtk", name = "TreeExpander"})
    IO CInt

-- | TreeExpander indents each level of depth with an additional indent.
-- 
-- /Since: 4.10/
treeExpanderGetIndentForDepth ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeExpander a) =>
    a
    -- ^ /@self@/: a @GtkTreeExpander@
    -> m Bool
    -- ^ __Returns:__ TRUE if the child should be indented . Otherwise FALSE.
treeExpanderGetIndentForDepth self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_expander_get_indent_for_depth self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data TreeExpanderGetIndentForDepthMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTreeExpander a) => O.OverloadedMethod TreeExpanderGetIndentForDepthMethodInfo a signature where
    overloadedMethod = treeExpanderGetIndentForDepth

instance O.OverloadedMethodInfo TreeExpanderGetIndentForDepthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.treeExpanderGetIndentForDepth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#v:treeExpanderGetIndentForDepth"
        })


#endif

-- method TreeExpander::get_indent_for_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeExpander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeExpander`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_get_indent_for_icon" gtk_tree_expander_get_indent_for_icon :: 
    Ptr TreeExpander ->                     -- self : TInterface (Name {namespace = "Gtk", name = "TreeExpander"})
    IO CInt

-- | TreeExpander indents the child by the width of an expander-icon if it is not expandable.
-- 
-- /Since: 4.6/
treeExpanderGetIndentForIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeExpander a) =>
    a
    -- ^ /@self@/: a @GtkTreeExpander@
    -> m Bool
    -- ^ __Returns:__ TRUE if the child should be indented when not expandable. Otherwise FALSE.
treeExpanderGetIndentForIcon self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_expander_get_indent_for_icon self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data TreeExpanderGetIndentForIconMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTreeExpander a) => O.OverloadedMethod TreeExpanderGetIndentForIconMethodInfo a signature where
    overloadedMethod = treeExpanderGetIndentForIcon

instance O.OverloadedMethodInfo TreeExpanderGetIndentForIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.treeExpanderGetIndentForIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#v:treeExpanderGetIndentForIcon"
        })


#endif

-- method TreeExpander::get_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeExpander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeExpander`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GObject" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_get_item" gtk_tree_expander_get_item :: 
    Ptr TreeExpander ->                     -- self : TInterface (Name {namespace = "Gtk", name = "TreeExpander"})
    IO (Ptr GObject.Object.Object)

-- | Forwards the item set on the @GtkTreeListRow@ that /@self@/ is managing.
-- 
-- This call is essentially equivalent to calling:
-- 
-- 
-- === /c code/
-- >gtk_tree_list_row_get_item (gtk_tree_expander_get_list_row (@self));
treeExpanderGetItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeExpander a) =>
    a
    -- ^ /@self@/: a @GtkTreeExpander@
    -> m (Maybe GObject.Object.Object)
    -- ^ __Returns:__ The item of the row
treeExpanderGetItem self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_expander_get_item self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject GObject.Object.Object) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeExpanderGetItemMethodInfo
instance (signature ~ (m (Maybe GObject.Object.Object)), MonadIO m, IsTreeExpander a) => O.OverloadedMethod TreeExpanderGetItemMethodInfo a signature where
    overloadedMethod = treeExpanderGetItem

instance O.OverloadedMethodInfo TreeExpanderGetItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.treeExpanderGetItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#v:treeExpanderGetItem"
        })


#endif

-- method TreeExpander::get_list_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeExpander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeExpander`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TreeListRow" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_get_list_row" gtk_tree_expander_get_list_row :: 
    Ptr TreeExpander ->                     -- self : TInterface (Name {namespace = "Gtk", name = "TreeExpander"})
    IO (Ptr Gtk.TreeListRow.TreeListRow)

-- | Gets the list row managed by /@self@/.
treeExpanderGetListRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeExpander a) =>
    a
    -- ^ /@self@/: a @GtkTreeExpander@
    -> m (Maybe Gtk.TreeListRow.TreeListRow)
    -- ^ __Returns:__ The list row displayed by /@self@/
treeExpanderGetListRow self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_tree_expander_get_list_row self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.TreeListRow.TreeListRow) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TreeExpanderGetListRowMethodInfo
instance (signature ~ (m (Maybe Gtk.TreeListRow.TreeListRow)), MonadIO m, IsTreeExpander a) => O.OverloadedMethod TreeExpanderGetListRowMethodInfo a signature where
    overloadedMethod = treeExpanderGetListRow

instance O.OverloadedMethodInfo TreeExpanderGetListRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.treeExpanderGetListRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#v:treeExpanderGetListRow"
        })


#endif

-- method TreeExpander::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeExpander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeExpander`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_set_child" gtk_tree_expander_set_child :: 
    Ptr TreeExpander ->                     -- self : TInterface (Name {namespace = "Gtk", name = "TreeExpander"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the content widget to display.
treeExpanderSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeExpander a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a @GtkTreeExpander@
    -> Maybe (b)
    -- ^ /@child@/: a @GtkWidget@
    -> m ()
treeExpanderSetChild self child = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_tree_expander_set_child self' maybeChild
    touchManagedPtr self
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeExpanderSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsTreeExpander a, Gtk.Widget.IsWidget b) => O.OverloadedMethod TreeExpanderSetChildMethodInfo a signature where
    overloadedMethod = treeExpanderSetChild

instance O.OverloadedMethodInfo TreeExpanderSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.treeExpanderSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#v:treeExpanderSetChild"
        })


#endif

-- method TreeExpander::set_hide_expander
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeExpander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeExpander` widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hide_expander"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "TRUE if the expander should be hidden. Otherwise FALSE."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_set_hide_expander" gtk_tree_expander_set_hide_expander :: 
    Ptr TreeExpander ->                     -- self : TInterface (Name {namespace = "Gtk", name = "TreeExpander"})
    CInt ->                                 -- hide_expander : TBasicType TBoolean
    IO ()

-- | Sets whether the expander icon should be visible in a GtkTreeListRow.
-- 
-- /Since: 4.10/
treeExpanderSetHideExpander ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeExpander a) =>
    a
    -- ^ /@self@/: a @GtkTreeExpander@ widget
    -> Bool
    -- ^ /@hideExpander@/: TRUE if the expander should be hidden. Otherwise FALSE.
    -> m ()
treeExpanderSetHideExpander self hideExpander = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let hideExpander' = (P.fromIntegral . P.fromEnum) hideExpander
    gtk_tree_expander_set_hide_expander self' hideExpander'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeExpanderSetHideExpanderMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTreeExpander a) => O.OverloadedMethod TreeExpanderSetHideExpanderMethodInfo a signature where
    overloadedMethod = treeExpanderSetHideExpander

instance O.OverloadedMethodInfo TreeExpanderSetHideExpanderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.treeExpanderSetHideExpander",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#v:treeExpanderSetHideExpander"
        })


#endif

-- method TreeExpander::set_indent_for_depth
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeExpander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeExpander` widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "indent_for_depth"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "TRUE if the child should be indented. Otherwise FALSE."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_set_indent_for_depth" gtk_tree_expander_set_indent_for_depth :: 
    Ptr TreeExpander ->                     -- self : TInterface (Name {namespace = "Gtk", name = "TreeExpander"})
    CInt ->                                 -- indent_for_depth : TBasicType TBoolean
    IO ()

-- | Sets if the TreeExpander should indent the child according to its depth.
-- 
-- /Since: 4.10/
treeExpanderSetIndentForDepth ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeExpander a) =>
    a
    -- ^ /@self@/: a @GtkTreeExpander@ widget
    -> Bool
    -- ^ /@indentForDepth@/: TRUE if the child should be indented. Otherwise FALSE.
    -> m ()
treeExpanderSetIndentForDepth self indentForDepth = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let indentForDepth' = (P.fromIntegral . P.fromEnum) indentForDepth
    gtk_tree_expander_set_indent_for_depth self' indentForDepth'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeExpanderSetIndentForDepthMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTreeExpander a) => O.OverloadedMethod TreeExpanderSetIndentForDepthMethodInfo a signature where
    overloadedMethod = treeExpanderSetIndentForDepth

instance O.OverloadedMethodInfo TreeExpanderSetIndentForDepthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.treeExpanderSetIndentForDepth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#v:treeExpanderSetIndentForDepth"
        })


#endif

-- method TreeExpander::set_indent_for_icon
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeExpander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeExpander` widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "indent_for_icon"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "TRUE if the child should be indented without expander. Otherwise FALSE."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_set_indent_for_icon" gtk_tree_expander_set_indent_for_icon :: 
    Ptr TreeExpander ->                     -- self : TInterface (Name {namespace = "Gtk", name = "TreeExpander"})
    CInt ->                                 -- indent_for_icon : TBasicType TBoolean
    IO ()

-- | Sets if the TreeExpander should indent the child by the width of an expander-icon when it is not expandable.
-- 
-- /Since: 4.6/
treeExpanderSetIndentForIcon ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeExpander a) =>
    a
    -- ^ /@self@/: a @GtkTreeExpander@ widget
    -> Bool
    -- ^ /@indentForIcon@/: TRUE if the child should be indented without expander. Otherwise FALSE.
    -> m ()
treeExpanderSetIndentForIcon self indentForIcon = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let indentForIcon' = (P.fromIntegral . P.fromEnum) indentForIcon
    gtk_tree_expander_set_indent_for_icon self' indentForIcon'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeExpanderSetIndentForIconMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTreeExpander a) => O.OverloadedMethod TreeExpanderSetIndentForIconMethodInfo a signature where
    overloadedMethod = treeExpanderSetIndentForIcon

instance O.OverloadedMethodInfo TreeExpanderSetIndentForIconMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.treeExpanderSetIndentForIcon",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#v:treeExpanderSetIndentForIcon"
        })


#endif

-- method TreeExpander::set_list_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeExpander" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeExpander` widget"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "list_row"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TreeListRow" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTreeListRow`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_tree_expander_set_list_row" gtk_tree_expander_set_list_row :: 
    Ptr TreeExpander ->                     -- self : TInterface (Name {namespace = "Gtk", name = "TreeExpander"})
    Ptr Gtk.TreeListRow.TreeListRow ->      -- list_row : TInterface (Name {namespace = "Gtk", name = "TreeListRow"})
    IO ()

-- | Sets the tree list row that this expander should manage.
treeExpanderSetListRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsTreeExpander a, Gtk.TreeListRow.IsTreeListRow b) =>
    a
    -- ^ /@self@/: a @GtkTreeExpander@ widget
    -> Maybe (b)
    -- ^ /@listRow@/: a @GtkTreeListRow@
    -> m ()
treeExpanderSetListRow self listRow = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeListRow <- case listRow of
        Nothing -> return FP.nullPtr
        Just jListRow -> do
            jListRow' <- unsafeManagedPtrCastPtr jListRow
            return jListRow'
    gtk_tree_expander_set_list_row self' maybeListRow
    touchManagedPtr self
    whenJust listRow touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data TreeExpanderSetListRowMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsTreeExpander a, Gtk.TreeListRow.IsTreeListRow b) => O.OverloadedMethod TreeExpanderSetListRowMethodInfo a signature where
    overloadedMethod = treeExpanderSetListRow

instance O.OverloadedMethodInfo TreeExpanderSetListRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TreeExpander.treeExpanderSetListRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TreeExpander.html#v:treeExpanderSetListRow"
        })


#endif


