{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Displays the contents of a t'GI.Gtk.Objects.TextBuffer.TextBuffer'.
-- 
-- \<picture>
--   \<source srcset=\"multiline-text-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkTextView\" src=\"multiline-text.png\">
-- \<\/picture>
-- 
-- You may wish to begin by reading the <https://docs.gtk.org/gtk4/section-text-widget.html conceptual overview>,
-- which gives an overview of all the objects and data types related to the
-- text widget and how they work together.
-- 
-- == Shortcuts and Gestures
-- 
-- @GtkTextView@ supports the following keyboard shortcuts:
-- 
-- * \<kbd>Shift\<\/kbd>+\<kbd>F10\<\/kbd> or \<kbd>Menu\<\/kbd> opens the context menu.
-- * \<kbd>Ctrl\<\/kbd>+\<kbd>Z\<\/kbd> undoes the last modification.
-- * \<kbd>Ctrl\<\/kbd>+\<kbd>Y\<\/kbd> or \<kbd>Ctrl\<\/kbd>+\<kbd>Shift\<\/kbd>+\<kbd>Z\<\/kbd>
-- redoes the last undone modification.
-- 
-- 
-- Additionally, the following signals have default keybindings:
-- 
-- * [TextView::backspace]("GI.Gtk.Objects.TextView#g:signal:backspace")
-- * [TextView::copyClipboard]("GI.Gtk.Objects.TextView#g:signal:copyClipboard")
-- * [TextView::cutClipboard]("GI.Gtk.Objects.TextView#g:signal:cutClipboard")
-- * [TextView::deleteFromCursor]("GI.Gtk.Objects.TextView#g:signal:deleteFromCursor")
-- * [TextView::insertEmoji]("GI.Gtk.Objects.TextView#g:signal:insertEmoji")
-- * [TextView::moveCursor]("GI.Gtk.Objects.TextView#g:signal:moveCursor")
-- * [TextView::pasteClipboard]("GI.Gtk.Objects.TextView#g:signal:pasteClipboard")
-- * [TextView::selectAll]("GI.Gtk.Objects.TextView#g:signal:selectAll")
-- * [TextView::toggleCursorVisible]("GI.Gtk.Objects.TextView#g:signal:toggleCursorVisible")
-- * [TextView::toggleOverwrite]("GI.Gtk.Objects.TextView#g:signal:toggleOverwrite")
-- 
-- 
-- == Actions
-- 
-- @GtkTextView@ defines a set of built-in actions:
-- 
-- * @clipboard.copy@ copies the contents to the clipboard.
-- * @clipboard.cut@ copies the contents to the clipboard and deletes it from
-- the widget.
-- * @clipboard.paste@ inserts the contents of the clipboard into the widget.
-- * @menu.popup@ opens the context menu.
-- * @misc.insert-emoji@ opens the Emoji chooser.
-- * @selection.delete@ deletes the current selection.
-- * @selection.select-all@ selects all of the widgets content.
-- * @text.redo@ redoes the last change to the contents.
-- * @text.undo@ undoes the last change to the contents.
-- 
-- 
-- == CSS nodes
-- 
-- >textview.view
-- >├── border.top
-- >├── border.left
-- >├── text
-- >│   ╰── [selection]
-- >├── border.right
-- >├── border.bottom
-- >╰── [window.popup]
-- 
-- 
-- @GtkTextView@ has a main css node with name textview and style class .view,
-- and subnodes for each of the border windows, and the main text area,
-- with names border and text, respectively. The border nodes each get
-- one of the style classes .left, .right, .top or .bottom.
-- 
-- A node representing the selection will appear below the text node.
-- 
-- If a context menu is opened, the window node will appear as a subnode
-- of the main node.
-- 
-- == Accessibility
-- 
-- @GtkTextView@ uses the [enum/@gtk@/.AccessibleRole.text_box] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.TextView
    ( 

-- * Exported types
    TextView(..)                            ,
    IsTextView                              ,
    toTextView                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addChildAtAnchor]("GI.Gtk.Objects.TextView#g:method:addChildAtAnchor"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addOverlay]("GI.Gtk.Objects.TextView#g:method:addOverlay"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [backwardDisplayLine]("GI.Gtk.Objects.TextView#g:method:backwardDisplayLine"), [backwardDisplayLineStart]("GI.Gtk.Objects.TextView#g:method:backwardDisplayLineStart"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [bufferToWindowCoords]("GI.Gtk.Objects.TextView#g:method:bufferToWindowCoords"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [forwardDisplayLine]("GI.Gtk.Objects.TextView#g:method:forwardDisplayLine"), [forwardDisplayLineEnd]("GI.Gtk.Objects.TextView#g:method:forwardDisplayLineEnd"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [imContextFilterKeypress]("GI.Gtk.Objects.TextView#g:method:imContextFilterKeypress"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [moveMarkOnscreen]("GI.Gtk.Objects.TextView#g:method:moveMarkOnscreen"), [moveOverlay]("GI.Gtk.Objects.TextView#g:method:moveOverlay"), [moveVisually]("GI.Gtk.Objects.TextView#g:method:moveVisually"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [placeCursorOnscreen]("GI.Gtk.Objects.TextView#g:method:placeCursorOnscreen"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.TextView#g:method:remove"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetCursorBlink]("GI.Gtk.Objects.TextView#g:method:resetCursorBlink"), [resetImContext]("GI.Gtk.Objects.TextView#g:method:resetImContext"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [scrollMarkOnscreen]("GI.Gtk.Objects.TextView#g:method:scrollMarkOnscreen"), [scrollToIter]("GI.Gtk.Objects.TextView#g:method:scrollToIter"), [scrollToMark]("GI.Gtk.Objects.TextView#g:method:scrollToMark"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [startsDisplayLine]("GI.Gtk.Objects.TextView#g:method:startsDisplayLine"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateCaretPosition]("GI.Gtk.Interfaces.AccessibleText#g:method:updateCaretPosition"), [updateContents]("GI.Gtk.Interfaces.AccessibleText#g:method:updateContents"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateSelectionBound]("GI.Gtk.Interfaces.AccessibleText#g:method:updateSelectionBound"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure"), [windowToBufferCoords]("GI.Gtk.Objects.TextView#g:method:windowToBufferCoords").
-- 
-- ==== Getters
-- [getAcceptsTab]("GI.Gtk.Objects.TextView#g:method:getAcceptsTab"), [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBorder]("GI.Gtk.Interfaces.Scrollable#g:method:getBorder"), [getBottomMargin]("GI.Gtk.Objects.TextView#g:method:getBottomMargin"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuffer]("GI.Gtk.Objects.TextView#g:method:getBuffer"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getCursorLocations]("GI.Gtk.Objects.TextView#g:method:getCursorLocations"), [getCursorVisible]("GI.Gtk.Objects.TextView#g:method:getCursorVisible"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEditable]("GI.Gtk.Objects.TextView#g:method:getEditable"), [getExtraMenu]("GI.Gtk.Objects.TextView#g:method:getExtraMenu"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getGutter]("GI.Gtk.Objects.TextView#g:method:getGutter"), [getHadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:getHadjustment"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:getHscrollPolicy"), [getIndent]("GI.Gtk.Objects.TextView#g:method:getIndent"), [getInputHints]("GI.Gtk.Objects.TextView#g:method:getInputHints"), [getInputPurpose]("GI.Gtk.Objects.TextView#g:method:getInputPurpose"), [getIterAtLocation]("GI.Gtk.Objects.TextView#g:method:getIterAtLocation"), [getIterAtPosition]("GI.Gtk.Objects.TextView#g:method:getIterAtPosition"), [getIterLocation]("GI.Gtk.Objects.TextView#g:method:getIterLocation"), [getJustification]("GI.Gtk.Objects.TextView#g:method:getJustification"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLeftMargin]("GI.Gtk.Objects.TextView#g:method:getLeftMargin"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getLineAtY]("GI.Gtk.Objects.TextView#g:method:getLineAtY"), [getLineYrange]("GI.Gtk.Objects.TextView#g:method:getLineYrange"), [getLtrContext]("GI.Gtk.Objects.TextView#g:method:getLtrContext"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMonospace]("GI.Gtk.Objects.TextView#g:method:getMonospace"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getOverwrite]("GI.Gtk.Objects.TextView#g:method:getOverwrite"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPixelsAboveLines]("GI.Gtk.Objects.TextView#g:method:getPixelsAboveLines"), [getPixelsBelowLines]("GI.Gtk.Objects.TextView#g:method:getPixelsBelowLines"), [getPixelsInsideWrap]("GI.Gtk.Objects.TextView#g:method:getPixelsInsideWrap"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRightMargin]("GI.Gtk.Objects.TextView#g:method:getRightMargin"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getRtlContext]("GI.Gtk.Objects.TextView#g:method:getRtlContext"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTabs]("GI.Gtk.Objects.TextView#g:method:getTabs"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getTopMargin]("GI.Gtk.Objects.TextView#g:method:getTopMargin"), [getVadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:getVadjustment"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getVisibleOffset]("GI.Gtk.Objects.TextView#g:method:getVisibleOffset"), [getVisibleRect]("GI.Gtk.Objects.TextView#g:method:getVisibleRect"), [getVscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:getVscrollPolicy"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth"), [getWrapMode]("GI.Gtk.Objects.TextView#g:method:getWrapMode").
-- 
-- ==== Setters
-- [setAcceptsTab]("GI.Gtk.Objects.TextView#g:method:setAcceptsTab"), [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setBottomMargin]("GI.Gtk.Objects.TextView#g:method:setBottomMargin"), [setBuffer]("GI.Gtk.Objects.TextView#g:method:setBuffer"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setCursorVisible]("GI.Gtk.Objects.TextView#g:method:setCursorVisible"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEditable]("GI.Gtk.Objects.TextView#g:method:setEditable"), [setExtraMenu]("GI.Gtk.Objects.TextView#g:method:setExtraMenu"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setGutter]("GI.Gtk.Objects.TextView#g:method:setGutter"), [setHadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:setHadjustment"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:setHscrollPolicy"), [setIndent]("GI.Gtk.Objects.TextView#g:method:setIndent"), [setInputHints]("GI.Gtk.Objects.TextView#g:method:setInputHints"), [setInputPurpose]("GI.Gtk.Objects.TextView#g:method:setInputPurpose"), [setJustification]("GI.Gtk.Objects.TextView#g:method:setJustification"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLeftMargin]("GI.Gtk.Objects.TextView#g:method:setLeftMargin"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMonospace]("GI.Gtk.Objects.TextView#g:method:setMonospace"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setOverwrite]("GI.Gtk.Objects.TextView#g:method:setOverwrite"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPixelsAboveLines]("GI.Gtk.Objects.TextView#g:method:setPixelsAboveLines"), [setPixelsBelowLines]("GI.Gtk.Objects.TextView#g:method:setPixelsBelowLines"), [setPixelsInsideWrap]("GI.Gtk.Objects.TextView#g:method:setPixelsInsideWrap"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setRightMargin]("GI.Gtk.Objects.TextView#g:method:setRightMargin"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTabs]("GI.Gtk.Objects.TextView#g:method:setTabs"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setTopMargin]("GI.Gtk.Objects.TextView#g:method:setTopMargin"), [setVadjustment]("GI.Gtk.Interfaces.Scrollable#g:method:setVadjustment"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setVscrollPolicy]("GI.Gtk.Interfaces.Scrollable#g:method:setVscrollPolicy"), [setWrapMode]("GI.Gtk.Objects.TextView#g:method:setWrapMode").

#if defined(ENABLE_OVERLOADING)
    ResolveTextViewMethod                   ,
#endif

-- ** addChildAtAnchor #method:addChildAtAnchor#

#if defined(ENABLE_OVERLOADING)
    TextViewAddChildAtAnchorMethodInfo      ,
#endif
    textViewAddChildAtAnchor                ,


-- ** addOverlay #method:addOverlay#

#if defined(ENABLE_OVERLOADING)
    TextViewAddOverlayMethodInfo            ,
#endif
    textViewAddOverlay                      ,


-- ** backwardDisplayLine #method:backwardDisplayLine#

#if defined(ENABLE_OVERLOADING)
    TextViewBackwardDisplayLineMethodInfo   ,
#endif
    textViewBackwardDisplayLine             ,


-- ** backwardDisplayLineStart #method:backwardDisplayLineStart#

#if defined(ENABLE_OVERLOADING)
    TextViewBackwardDisplayLineStartMethodInfo,
#endif
    textViewBackwardDisplayLineStart        ,


-- ** bufferToWindowCoords #method:bufferToWindowCoords#

#if defined(ENABLE_OVERLOADING)
    TextViewBufferToWindowCoordsMethodInfo  ,
#endif
    textViewBufferToWindowCoords            ,


-- ** forwardDisplayLine #method:forwardDisplayLine#

#if defined(ENABLE_OVERLOADING)
    TextViewForwardDisplayLineMethodInfo    ,
#endif
    textViewForwardDisplayLine              ,


-- ** forwardDisplayLineEnd #method:forwardDisplayLineEnd#

#if defined(ENABLE_OVERLOADING)
    TextViewForwardDisplayLineEndMethodInfo ,
#endif
    textViewForwardDisplayLineEnd           ,


-- ** getAcceptsTab #method:getAcceptsTab#

#if defined(ENABLE_OVERLOADING)
    TextViewGetAcceptsTabMethodInfo         ,
#endif
    textViewGetAcceptsTab                   ,


-- ** getBottomMargin #method:getBottomMargin#

#if defined(ENABLE_OVERLOADING)
    TextViewGetBottomMarginMethodInfo       ,
#endif
    textViewGetBottomMargin                 ,


-- ** getBuffer #method:getBuffer#

#if defined(ENABLE_OVERLOADING)
    TextViewGetBufferMethodInfo             ,
#endif
    textViewGetBuffer                       ,


-- ** getCursorLocations #method:getCursorLocations#

#if defined(ENABLE_OVERLOADING)
    TextViewGetCursorLocationsMethodInfo    ,
#endif
    textViewGetCursorLocations              ,


-- ** getCursorVisible #method:getCursorVisible#

#if defined(ENABLE_OVERLOADING)
    TextViewGetCursorVisibleMethodInfo      ,
#endif
    textViewGetCursorVisible                ,


-- ** getEditable #method:getEditable#

#if defined(ENABLE_OVERLOADING)
    TextViewGetEditableMethodInfo           ,
#endif
    textViewGetEditable                     ,


-- ** getExtraMenu #method:getExtraMenu#

#if defined(ENABLE_OVERLOADING)
    TextViewGetExtraMenuMethodInfo          ,
#endif
    textViewGetExtraMenu                    ,


-- ** getGutter #method:getGutter#

#if defined(ENABLE_OVERLOADING)
    TextViewGetGutterMethodInfo             ,
#endif
    textViewGetGutter                       ,


-- ** getIndent #method:getIndent#

#if defined(ENABLE_OVERLOADING)
    TextViewGetIndentMethodInfo             ,
#endif
    textViewGetIndent                       ,


-- ** getInputHints #method:getInputHints#

#if defined(ENABLE_OVERLOADING)
    TextViewGetInputHintsMethodInfo         ,
#endif
    textViewGetInputHints                   ,


-- ** getInputPurpose #method:getInputPurpose#

#if defined(ENABLE_OVERLOADING)
    TextViewGetInputPurposeMethodInfo       ,
#endif
    textViewGetInputPurpose                 ,


-- ** getIterAtLocation #method:getIterAtLocation#

#if defined(ENABLE_OVERLOADING)
    TextViewGetIterAtLocationMethodInfo     ,
#endif
    textViewGetIterAtLocation               ,


-- ** getIterAtPosition #method:getIterAtPosition#

#if defined(ENABLE_OVERLOADING)
    TextViewGetIterAtPositionMethodInfo     ,
#endif
    textViewGetIterAtPosition               ,


-- ** getIterLocation #method:getIterLocation#

#if defined(ENABLE_OVERLOADING)
    TextViewGetIterLocationMethodInfo       ,
#endif
    textViewGetIterLocation                 ,


-- ** getJustification #method:getJustification#

#if defined(ENABLE_OVERLOADING)
    TextViewGetJustificationMethodInfo      ,
#endif
    textViewGetJustification                ,


-- ** getLeftMargin #method:getLeftMargin#

#if defined(ENABLE_OVERLOADING)
    TextViewGetLeftMarginMethodInfo         ,
#endif
    textViewGetLeftMargin                   ,


-- ** getLineAtY #method:getLineAtY#

#if defined(ENABLE_OVERLOADING)
    TextViewGetLineAtYMethodInfo            ,
#endif
    textViewGetLineAtY                      ,


-- ** getLineYrange #method:getLineYrange#

#if defined(ENABLE_OVERLOADING)
    TextViewGetLineYrangeMethodInfo         ,
#endif
    textViewGetLineYrange                   ,


-- ** getLtrContext #method:getLtrContext#

#if defined(ENABLE_OVERLOADING)
    TextViewGetLtrContextMethodInfo         ,
#endif
    textViewGetLtrContext                   ,


-- ** getMonospace #method:getMonospace#

#if defined(ENABLE_OVERLOADING)
    TextViewGetMonospaceMethodInfo          ,
#endif
    textViewGetMonospace                    ,


-- ** getOverwrite #method:getOverwrite#

#if defined(ENABLE_OVERLOADING)
    TextViewGetOverwriteMethodInfo          ,
#endif
    textViewGetOverwrite                    ,


-- ** getPixelsAboveLines #method:getPixelsAboveLines#

#if defined(ENABLE_OVERLOADING)
    TextViewGetPixelsAboveLinesMethodInfo   ,
#endif
    textViewGetPixelsAboveLines             ,


-- ** getPixelsBelowLines #method:getPixelsBelowLines#

#if defined(ENABLE_OVERLOADING)
    TextViewGetPixelsBelowLinesMethodInfo   ,
#endif
    textViewGetPixelsBelowLines             ,


-- ** getPixelsInsideWrap #method:getPixelsInsideWrap#

#if defined(ENABLE_OVERLOADING)
    TextViewGetPixelsInsideWrapMethodInfo   ,
#endif
    textViewGetPixelsInsideWrap             ,


-- ** getRightMargin #method:getRightMargin#

#if defined(ENABLE_OVERLOADING)
    TextViewGetRightMarginMethodInfo        ,
#endif
    textViewGetRightMargin                  ,


-- ** getRtlContext #method:getRtlContext#

#if defined(ENABLE_OVERLOADING)
    TextViewGetRtlContextMethodInfo         ,
#endif
    textViewGetRtlContext                   ,


-- ** getTabs #method:getTabs#

#if defined(ENABLE_OVERLOADING)
    TextViewGetTabsMethodInfo               ,
#endif
    textViewGetTabs                         ,


-- ** getTopMargin #method:getTopMargin#

#if defined(ENABLE_OVERLOADING)
    TextViewGetTopMarginMethodInfo          ,
#endif
    textViewGetTopMargin                    ,


-- ** getVisibleOffset #method:getVisibleOffset#

#if defined(ENABLE_OVERLOADING)
    TextViewGetVisibleOffsetMethodInfo      ,
#endif
    textViewGetVisibleOffset                ,


-- ** getVisibleRect #method:getVisibleRect#

#if defined(ENABLE_OVERLOADING)
    TextViewGetVisibleRectMethodInfo        ,
#endif
    textViewGetVisibleRect                  ,


-- ** getWrapMode #method:getWrapMode#

#if defined(ENABLE_OVERLOADING)
    TextViewGetWrapModeMethodInfo           ,
#endif
    textViewGetWrapMode                     ,


-- ** imContextFilterKeypress #method:imContextFilterKeypress#

#if defined(ENABLE_OVERLOADING)
    TextViewImContextFilterKeypressMethodInfo,
#endif
    textViewImContextFilterKeypress         ,


-- ** moveMarkOnscreen #method:moveMarkOnscreen#

#if defined(ENABLE_OVERLOADING)
    TextViewMoveMarkOnscreenMethodInfo      ,
#endif
    textViewMoveMarkOnscreen                ,


-- ** moveOverlay #method:moveOverlay#

#if defined(ENABLE_OVERLOADING)
    TextViewMoveOverlayMethodInfo           ,
#endif
    textViewMoveOverlay                     ,


-- ** moveVisually #method:moveVisually#

#if defined(ENABLE_OVERLOADING)
    TextViewMoveVisuallyMethodInfo          ,
#endif
    textViewMoveVisually                    ,


-- ** new #method:new#

    textViewNew                             ,


-- ** newWithBuffer #method:newWithBuffer#

    textViewNewWithBuffer                   ,


-- ** placeCursorOnscreen #method:placeCursorOnscreen#

#if defined(ENABLE_OVERLOADING)
    TextViewPlaceCursorOnscreenMethodInfo   ,
#endif
    textViewPlaceCursorOnscreen             ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    TextViewRemoveMethodInfo                ,
#endif
    textViewRemove                          ,


-- ** resetCursorBlink #method:resetCursorBlink#

#if defined(ENABLE_OVERLOADING)
    TextViewResetCursorBlinkMethodInfo      ,
#endif
    textViewResetCursorBlink                ,


-- ** resetImContext #method:resetImContext#

#if defined(ENABLE_OVERLOADING)
    TextViewResetImContextMethodInfo        ,
#endif
    textViewResetImContext                  ,


-- ** scrollMarkOnscreen #method:scrollMarkOnscreen#

#if defined(ENABLE_OVERLOADING)
    TextViewScrollMarkOnscreenMethodInfo    ,
#endif
    textViewScrollMarkOnscreen              ,


-- ** scrollToIter #method:scrollToIter#

#if defined(ENABLE_OVERLOADING)
    TextViewScrollToIterMethodInfo          ,
#endif
    textViewScrollToIter                    ,


-- ** scrollToMark #method:scrollToMark#

#if defined(ENABLE_OVERLOADING)
    TextViewScrollToMarkMethodInfo          ,
#endif
    textViewScrollToMark                    ,


-- ** setAcceptsTab #method:setAcceptsTab#

#if defined(ENABLE_OVERLOADING)
    TextViewSetAcceptsTabMethodInfo         ,
#endif
    textViewSetAcceptsTab                   ,


-- ** setBottomMargin #method:setBottomMargin#

#if defined(ENABLE_OVERLOADING)
    TextViewSetBottomMarginMethodInfo       ,
#endif
    textViewSetBottomMargin                 ,


-- ** setBuffer #method:setBuffer#

#if defined(ENABLE_OVERLOADING)
    TextViewSetBufferMethodInfo             ,
#endif
    textViewSetBuffer                       ,


-- ** setCursorVisible #method:setCursorVisible#

#if defined(ENABLE_OVERLOADING)
    TextViewSetCursorVisibleMethodInfo      ,
#endif
    textViewSetCursorVisible                ,


-- ** setEditable #method:setEditable#

#if defined(ENABLE_OVERLOADING)
    TextViewSetEditableMethodInfo           ,
#endif
    textViewSetEditable                     ,


-- ** setExtraMenu #method:setExtraMenu#

#if defined(ENABLE_OVERLOADING)
    TextViewSetExtraMenuMethodInfo          ,
#endif
    textViewSetExtraMenu                    ,


-- ** setGutter #method:setGutter#

#if defined(ENABLE_OVERLOADING)
    TextViewSetGutterMethodInfo             ,
#endif
    textViewSetGutter                       ,


-- ** setIndent #method:setIndent#

#if defined(ENABLE_OVERLOADING)
    TextViewSetIndentMethodInfo             ,
#endif
    textViewSetIndent                       ,


-- ** setInputHints #method:setInputHints#

#if defined(ENABLE_OVERLOADING)
    TextViewSetInputHintsMethodInfo         ,
#endif
    textViewSetInputHints                   ,


-- ** setInputPurpose #method:setInputPurpose#

#if defined(ENABLE_OVERLOADING)
    TextViewSetInputPurposeMethodInfo       ,
#endif
    textViewSetInputPurpose                 ,


-- ** setJustification #method:setJustification#

#if defined(ENABLE_OVERLOADING)
    TextViewSetJustificationMethodInfo      ,
#endif
    textViewSetJustification                ,


-- ** setLeftMargin #method:setLeftMargin#

#if defined(ENABLE_OVERLOADING)
    TextViewSetLeftMarginMethodInfo         ,
#endif
    textViewSetLeftMargin                   ,


-- ** setMonospace #method:setMonospace#

#if defined(ENABLE_OVERLOADING)
    TextViewSetMonospaceMethodInfo          ,
#endif
    textViewSetMonospace                    ,


-- ** setOverwrite #method:setOverwrite#

#if defined(ENABLE_OVERLOADING)
    TextViewSetOverwriteMethodInfo          ,
#endif
    textViewSetOverwrite                    ,


-- ** setPixelsAboveLines #method:setPixelsAboveLines#

#if defined(ENABLE_OVERLOADING)
    TextViewSetPixelsAboveLinesMethodInfo   ,
#endif
    textViewSetPixelsAboveLines             ,


-- ** setPixelsBelowLines #method:setPixelsBelowLines#

#if defined(ENABLE_OVERLOADING)
    TextViewSetPixelsBelowLinesMethodInfo   ,
#endif
    textViewSetPixelsBelowLines             ,


-- ** setPixelsInsideWrap #method:setPixelsInsideWrap#

#if defined(ENABLE_OVERLOADING)
    TextViewSetPixelsInsideWrapMethodInfo   ,
#endif
    textViewSetPixelsInsideWrap             ,


-- ** setRightMargin #method:setRightMargin#

#if defined(ENABLE_OVERLOADING)
    TextViewSetRightMarginMethodInfo        ,
#endif
    textViewSetRightMargin                  ,


-- ** setTabs #method:setTabs#

#if defined(ENABLE_OVERLOADING)
    TextViewSetTabsMethodInfo               ,
#endif
    textViewSetTabs                         ,


-- ** setTopMargin #method:setTopMargin#

#if defined(ENABLE_OVERLOADING)
    TextViewSetTopMarginMethodInfo          ,
#endif
    textViewSetTopMargin                    ,


-- ** setWrapMode #method:setWrapMode#

#if defined(ENABLE_OVERLOADING)
    TextViewSetWrapModeMethodInfo           ,
#endif
    textViewSetWrapMode                     ,


-- ** startsDisplayLine #method:startsDisplayLine#

#if defined(ENABLE_OVERLOADING)
    TextViewStartsDisplayLineMethodInfo     ,
#endif
    textViewStartsDisplayLine               ,


-- ** windowToBufferCoords #method:windowToBufferCoords#

#if defined(ENABLE_OVERLOADING)
    TextViewWindowToBufferCoordsMethodInfo  ,
#endif
    textViewWindowToBufferCoords            ,




 -- * Properties


-- ** acceptsTab #attr:acceptsTab#
-- | Whether Tab will result in a tab character being entered.

#if defined(ENABLE_OVERLOADING)
    TextViewAcceptsTabPropertyInfo          ,
#endif
    constructTextViewAcceptsTab             ,
    getTextViewAcceptsTab                   ,
    setTextViewAcceptsTab                   ,
#if defined(ENABLE_OVERLOADING)
    textViewAcceptsTab                      ,
#endif


-- ** bottomMargin #attr:bottomMargin#
-- | The bottom margin for text in the text view.
-- 
-- Note that this property is confusingly named. In CSS terms,
-- the value set here is padding, and it is applied in addition
-- to the padding from the theme.
-- 
-- Don\'t confuse this property with [Widget:marginBottom]("GI.Gtk.Objects.Widget#g:attr:marginBottom").

#if defined(ENABLE_OVERLOADING)
    TextViewBottomMarginPropertyInfo        ,
#endif
    constructTextViewBottomMargin           ,
    getTextViewBottomMargin                 ,
    setTextViewBottomMargin                 ,
#if defined(ENABLE_OVERLOADING)
    textViewBottomMargin                    ,
#endif


-- ** buffer #attr:buffer#
-- | The buffer which is displayed.

#if defined(ENABLE_OVERLOADING)
    TextViewBufferPropertyInfo              ,
#endif
    clearTextViewBuffer                     ,
    constructTextViewBuffer                 ,
    getTextViewBuffer                       ,
    setTextViewBuffer                       ,
#if defined(ENABLE_OVERLOADING)
    textViewBuffer                          ,
#endif


-- ** cursorVisible #attr:cursorVisible#
-- | If the insertion cursor is shown.

#if defined(ENABLE_OVERLOADING)
    TextViewCursorVisiblePropertyInfo       ,
#endif
    constructTextViewCursorVisible          ,
    getTextViewCursorVisible                ,
    setTextViewCursorVisible                ,
#if defined(ENABLE_OVERLOADING)
    textViewCursorVisible                   ,
#endif


-- ** editable #attr:editable#
-- | Whether the text can be modified by the user.

#if defined(ENABLE_OVERLOADING)
    TextViewEditablePropertyInfo            ,
#endif
    constructTextViewEditable               ,
    getTextViewEditable                     ,
    setTextViewEditable                     ,
#if defined(ENABLE_OVERLOADING)
    textViewEditable                        ,
#endif


-- ** extraMenu #attr:extraMenu#
-- | A menu model whose contents will be appended to the context menu.

#if defined(ENABLE_OVERLOADING)
    TextViewExtraMenuPropertyInfo           ,
#endif
    clearTextViewExtraMenu                  ,
    constructTextViewExtraMenu              ,
    getTextViewExtraMenu                    ,
    setTextViewExtraMenu                    ,
#if defined(ENABLE_OVERLOADING)
    textViewExtraMenu                       ,
#endif


-- ** imModule #attr:imModule#
-- | Which IM (input method) module should be used for this text_view.
-- 
-- See t'GI.Gtk.Objects.IMMulticontext.IMMulticontext'.
-- 
-- Setting this to a non-'P.Nothing' value overrides the system-wide IM module
-- setting. See the GtkSettings [Settings:gtkImModule]("GI.Gtk.Objects.Settings#g:attr:gtkImModule") property.

#if defined(ENABLE_OVERLOADING)
    TextViewImModulePropertyInfo            ,
#endif
    clearTextViewImModule                   ,
    constructTextViewImModule               ,
    getTextViewImModule                     ,
    setTextViewImModule                     ,
#if defined(ENABLE_OVERLOADING)
    textViewImModule                        ,
#endif


-- ** indent #attr:indent#
-- | Amount to indent the paragraph, in pixels.
-- 
-- A negative value of indent will produce a hanging indentation.
-- That is, the first line will have the full width, and subsequent
-- lines will be indented by the absolute value of indent.

#if defined(ENABLE_OVERLOADING)
    TextViewIndentPropertyInfo              ,
#endif
    constructTextViewIndent                 ,
    getTextViewIndent                       ,
    setTextViewIndent                       ,
#if defined(ENABLE_OVERLOADING)
    textViewIndent                          ,
#endif


-- ** inputHints #attr:inputHints#
-- | Additional hints (beyond [TextView:inputPurpose]("GI.Gtk.Objects.TextView#g:attr:inputPurpose"))
-- that allow input methods to fine-tune their behaviour.

#if defined(ENABLE_OVERLOADING)
    TextViewInputHintsPropertyInfo          ,
#endif
    constructTextViewInputHints             ,
    getTextViewInputHints                   ,
    setTextViewInputHints                   ,
#if defined(ENABLE_OVERLOADING)
    textViewInputHints                      ,
#endif


-- ** inputPurpose #attr:inputPurpose#
-- | The purpose of this text field.
-- 
-- This property can be used by on-screen keyboards and other input
-- methods to adjust their behaviour.

#if defined(ENABLE_OVERLOADING)
    TextViewInputPurposePropertyInfo        ,
#endif
    constructTextViewInputPurpose           ,
    getTextViewInputPurpose                 ,
    setTextViewInputPurpose                 ,
#if defined(ENABLE_OVERLOADING)
    textViewInputPurpose                    ,
#endif


-- ** justification #attr:justification#
-- | Left, right, or center justification.

#if defined(ENABLE_OVERLOADING)
    TextViewJustificationPropertyInfo       ,
#endif
    constructTextViewJustification          ,
    getTextViewJustification                ,
    setTextViewJustification                ,
#if defined(ENABLE_OVERLOADING)
    textViewJustification                   ,
#endif


-- ** leftMargin #attr:leftMargin#
-- | The default left margin for text in the text view.
-- 
-- Tags in the buffer may override the default.
-- 
-- Note that this property is confusingly named. In CSS terms,
-- the value set here is padding, and it is applied in addition
-- to the padding from the theme.

#if defined(ENABLE_OVERLOADING)
    TextViewLeftMarginPropertyInfo          ,
#endif
    constructTextViewLeftMargin             ,
    getTextViewLeftMargin                   ,
    setTextViewLeftMargin                   ,
#if defined(ENABLE_OVERLOADING)
    textViewLeftMargin                      ,
#endif


-- ** monospace #attr:monospace#
-- | Whether text should be displayed in a monospace font.
-- 
-- If 'P.True', set the .monospace style class on the
-- text view to indicate that a monospace font is desired.

#if defined(ENABLE_OVERLOADING)
    TextViewMonospacePropertyInfo           ,
#endif
    constructTextViewMonospace              ,
    getTextViewMonospace                    ,
    setTextViewMonospace                    ,
#if defined(ENABLE_OVERLOADING)
    textViewMonospace                       ,
#endif


-- ** overwrite #attr:overwrite#
-- | Whether entered text overwrites existing contents.

#if defined(ENABLE_OVERLOADING)
    TextViewOverwritePropertyInfo           ,
#endif
    constructTextViewOverwrite              ,
    getTextViewOverwrite                    ,
    setTextViewOverwrite                    ,
#if defined(ENABLE_OVERLOADING)
    textViewOverwrite                       ,
#endif


-- ** pixelsAboveLines #attr:pixelsAboveLines#
-- | Pixels of blank space above paragraphs.

#if defined(ENABLE_OVERLOADING)
    TextViewPixelsAboveLinesPropertyInfo    ,
#endif
    constructTextViewPixelsAboveLines       ,
    getTextViewPixelsAboveLines             ,
    setTextViewPixelsAboveLines             ,
#if defined(ENABLE_OVERLOADING)
    textViewPixelsAboveLines                ,
#endif


-- ** pixelsBelowLines #attr:pixelsBelowLines#
-- | Pixels of blank space below paragraphs.

#if defined(ENABLE_OVERLOADING)
    TextViewPixelsBelowLinesPropertyInfo    ,
#endif
    constructTextViewPixelsBelowLines       ,
    getTextViewPixelsBelowLines             ,
    setTextViewPixelsBelowLines             ,
#if defined(ENABLE_OVERLOADING)
    textViewPixelsBelowLines                ,
#endif


-- ** pixelsInsideWrap #attr:pixelsInsideWrap#
-- | Pixels of blank space between wrapped lines in a paragraph.

#if defined(ENABLE_OVERLOADING)
    TextViewPixelsInsideWrapPropertyInfo    ,
#endif
    constructTextViewPixelsInsideWrap       ,
    getTextViewPixelsInsideWrap             ,
    setTextViewPixelsInsideWrap             ,
#if defined(ENABLE_OVERLOADING)
    textViewPixelsInsideWrap                ,
#endif


-- ** rightMargin #attr:rightMargin#
-- | The default right margin for text in the text view.
-- 
-- Tags in the buffer may override the default.
-- 
-- Note that this property is confusingly named. In CSS terms,
-- the value set here is padding, and it is applied in addition
-- to the padding from the theme.

#if defined(ENABLE_OVERLOADING)
    TextViewRightMarginPropertyInfo         ,
#endif
    constructTextViewRightMargin            ,
    getTextViewRightMargin                  ,
    setTextViewRightMargin                  ,
#if defined(ENABLE_OVERLOADING)
    textViewRightMargin                     ,
#endif


-- ** tabs #attr:tabs#
-- | Custom tabs for this text.

#if defined(ENABLE_OVERLOADING)
    TextViewTabsPropertyInfo                ,
#endif
    constructTextViewTabs                   ,
    getTextViewTabs                         ,
    setTextViewTabs                         ,
#if defined(ENABLE_OVERLOADING)
    textViewTabs                            ,
#endif


-- ** topMargin #attr:topMargin#
-- | The top margin for text in the text view.
-- 
-- Note that this property is confusingly named. In CSS terms,
-- the value set here is padding, and it is applied in addition
-- to the padding from the theme.
-- 
-- Don\'t confuse this property with [Widget:marginTop]("GI.Gtk.Objects.Widget#g:attr:marginTop").

#if defined(ENABLE_OVERLOADING)
    TextViewTopMarginPropertyInfo           ,
#endif
    constructTextViewTopMargin              ,
    getTextViewTopMargin                    ,
    setTextViewTopMargin                    ,
#if defined(ENABLE_OVERLOADING)
    textViewTopMargin                       ,
#endif


-- ** wrapMode #attr:wrapMode#
-- | Whether to wrap lines never, at word boundaries, or at character boundaries.

#if defined(ENABLE_OVERLOADING)
    TextViewWrapModePropertyInfo            ,
#endif
    constructTextViewWrapMode               ,
    getTextViewWrapMode                     ,
    setTextViewWrapMode                     ,
#if defined(ENABLE_OVERLOADING)
    textViewWrapMode                        ,
#endif




 -- * Signals


-- ** backspace #signal:backspace#

    TextViewBackspaceCallback               ,
#if defined(ENABLE_OVERLOADING)
    TextViewBackspaceSignalInfo             ,
#endif
    afterTextViewBackspace                  ,
    onTextViewBackspace                     ,


-- ** copyClipboard #signal:copyClipboard#

    TextViewCopyClipboardCallback           ,
#if defined(ENABLE_OVERLOADING)
    TextViewCopyClipboardSignalInfo         ,
#endif
    afterTextViewCopyClipboard              ,
    onTextViewCopyClipboard                 ,


-- ** cutClipboard #signal:cutClipboard#

    TextViewCutClipboardCallback            ,
#if defined(ENABLE_OVERLOADING)
    TextViewCutClipboardSignalInfo          ,
#endif
    afterTextViewCutClipboard               ,
    onTextViewCutClipboard                  ,


-- ** deleteFromCursor #signal:deleteFromCursor#

    TextViewDeleteFromCursorCallback        ,
#if defined(ENABLE_OVERLOADING)
    TextViewDeleteFromCursorSignalInfo      ,
#endif
    afterTextViewDeleteFromCursor           ,
    onTextViewDeleteFromCursor              ,


-- ** extendSelection #signal:extendSelection#

    TextViewExtendSelectionCallback         ,
#if defined(ENABLE_OVERLOADING)
    TextViewExtendSelectionSignalInfo       ,
#endif
    afterTextViewExtendSelection            ,
    onTextViewExtendSelection               ,


-- ** insertAtCursor #signal:insertAtCursor#

    TextViewInsertAtCursorCallback          ,
#if defined(ENABLE_OVERLOADING)
    TextViewInsertAtCursorSignalInfo        ,
#endif
    afterTextViewInsertAtCursor             ,
    onTextViewInsertAtCursor                ,


-- ** insertEmoji #signal:insertEmoji#

    TextViewInsertEmojiCallback             ,
#if defined(ENABLE_OVERLOADING)
    TextViewInsertEmojiSignalInfo           ,
#endif
    afterTextViewInsertEmoji                ,
    onTextViewInsertEmoji                   ,


-- ** moveCursor #signal:moveCursor#

    TextViewMoveCursorCallback              ,
#if defined(ENABLE_OVERLOADING)
    TextViewMoveCursorSignalInfo            ,
#endif
    afterTextViewMoveCursor                 ,
    onTextViewMoveCursor                    ,


-- ** moveViewport #signal:moveViewport#

    TextViewMoveViewportCallback            ,
#if defined(ENABLE_OVERLOADING)
    TextViewMoveViewportSignalInfo          ,
#endif
    afterTextViewMoveViewport               ,
    onTextViewMoveViewport                  ,


-- ** pasteClipboard #signal:pasteClipboard#

    TextViewPasteClipboardCallback          ,
#if defined(ENABLE_OVERLOADING)
    TextViewPasteClipboardSignalInfo        ,
#endif
    afterTextViewPasteClipboard             ,
    onTextViewPasteClipboard                ,


-- ** preeditChanged #signal:preeditChanged#

    TextViewPreeditChangedCallback          ,
#if defined(ENABLE_OVERLOADING)
    TextViewPreeditChangedSignalInfo        ,
#endif
    afterTextViewPreeditChanged             ,
    onTextViewPreeditChanged                ,


-- ** selectAll #signal:selectAll#

    TextViewSelectAllCallback               ,
#if defined(ENABLE_OVERLOADING)
    TextViewSelectAllSignalInfo             ,
#endif
    afterTextViewSelectAll                  ,
    onTextViewSelectAll                     ,


-- ** setAnchor #signal:setAnchor#

    TextViewSetAnchorCallback               ,
#if defined(ENABLE_OVERLOADING)
    TextViewSetAnchorSignalInfo             ,
#endif
    afterTextViewSetAnchor                  ,
    onTextViewSetAnchor                     ,


-- ** toggleCursorVisible #signal:toggleCursorVisible#

    TextViewToggleCursorVisibleCallback     ,
#if defined(ENABLE_OVERLOADING)
    TextViewToggleCursorVisibleSignalInfo   ,
#endif
    afterTextViewToggleCursorVisible        ,
    onTextViewToggleCursorVisible           ,


-- ** toggleOverwrite #signal:toggleOverwrite#

    TextViewToggleOverwriteCallback         ,
#if defined(ENABLE_OVERLOADING)
    TextViewToggleOverwriteSignalInfo       ,
#endif
    afterTextViewToggleOverwrite            ,
    onTextViewToggleOverwrite               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleText as Gtk.AccessibleText
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextBuffer as Gtk.TextBuffer
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextChildAnchor as Gtk.TextChildAnchor
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextMark as Gtk.TextMark
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTag as Gtk.TextTag
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextTagTable as Gtk.TextTagTable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import {-# SOURCE #-} qualified GI.Gtk.Structs.TextIter as Gtk.TextIter
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Flags as Pango.Flags
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout
import qualified GI.Pango.Structs.FontDescription as Pango.FontDescription
import qualified GI.Pango.Structs.Language as Pango.Language
import qualified GI.Pango.Structs.TabArray as Pango.TabArray

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleText as Gtk.AccessibleText
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Scrollable as Gtk.Scrollable
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextBuffer as Gtk.TextBuffer
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextChildAnchor as Gtk.TextChildAnchor
import {-# SOURCE #-} qualified GI.Gtk.Objects.TextMark as Gtk.TextMark
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.TextIter as Gtk.TextIter
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Structs.TabArray as Pango.TabArray

#endif

-- | Memory-managed wrapper type.
newtype TextView = TextView (SP.ManagedPtr TextView)
    deriving (Eq)

instance SP.ManagedPtrNewtype TextView where
    toManagedPtr (TextView p) = p

foreign import ccall "gtk_text_view_get_type"
    c_gtk_text_view_get_type :: IO B.Types.GType

instance B.Types.TypedObject TextView where
    glibType = c_gtk_text_view_get_type

instance B.Types.GObject TextView

-- | Type class for types which can be safely cast to `TextView`, for instance with `toTextView`.
class (SP.GObject o, O.IsDescendantOf TextView o) => IsTextView o
instance (SP.GObject o, O.IsDescendantOf TextView o) => IsTextView o

instance O.HasParentTypes TextView
type instance O.ParentTypes TextView = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.AccessibleText.AccessibleText, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Scrollable.Scrollable]

-- | Cast to `TextView`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toTextView :: (MIO.MonadIO m, IsTextView o) => o -> m TextView
toTextView = MIO.liftIO . B.ManagedPtr.unsafeCastTo TextView

-- | Convert 'TextView' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe TextView) where
    gvalueGType_ = c_gtk_text_view_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr TextView)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr TextView)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject TextView ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveTextViewMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveTextViewMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveTextViewMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveTextViewMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveTextViewMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveTextViewMethod "addChildAtAnchor" o = TextViewAddChildAtAnchorMethodInfo
    ResolveTextViewMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveTextViewMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveTextViewMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveTextViewMethod "addOverlay" o = TextViewAddOverlayMethodInfo
    ResolveTextViewMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveTextViewMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveTextViewMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveTextViewMethod "backwardDisplayLine" o = TextViewBackwardDisplayLineMethodInfo
    ResolveTextViewMethod "backwardDisplayLineStart" o = TextViewBackwardDisplayLineStartMethodInfo
    ResolveTextViewMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveTextViewMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveTextViewMethod "bufferToWindowCoords" o = TextViewBufferToWindowCoordsMethodInfo
    ResolveTextViewMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveTextViewMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveTextViewMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveTextViewMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveTextViewMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveTextViewMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveTextViewMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveTextViewMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveTextViewMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveTextViewMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveTextViewMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveTextViewMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveTextViewMethod "forwardDisplayLine" o = TextViewForwardDisplayLineMethodInfo
    ResolveTextViewMethod "forwardDisplayLineEnd" o = TextViewForwardDisplayLineEndMethodInfo
    ResolveTextViewMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveTextViewMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveTextViewMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveTextViewMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveTextViewMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveTextViewMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveTextViewMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveTextViewMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveTextViewMethod "imContextFilterKeypress" o = TextViewImContextFilterKeypressMethodInfo
    ResolveTextViewMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveTextViewMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveTextViewMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveTextViewMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveTextViewMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveTextViewMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveTextViewMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveTextViewMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveTextViewMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveTextViewMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveTextViewMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveTextViewMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveTextViewMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveTextViewMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveTextViewMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveTextViewMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveTextViewMethod "moveMarkOnscreen" o = TextViewMoveMarkOnscreenMethodInfo
    ResolveTextViewMethod "moveOverlay" o = TextViewMoveOverlayMethodInfo
    ResolveTextViewMethod "moveVisually" o = TextViewMoveVisuallyMethodInfo
    ResolveTextViewMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveTextViewMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveTextViewMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveTextViewMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveTextViewMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveTextViewMethod "placeCursorOnscreen" o = TextViewPlaceCursorOnscreenMethodInfo
    ResolveTextViewMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveTextViewMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveTextViewMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveTextViewMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveTextViewMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveTextViewMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveTextViewMethod "remove" o = TextViewRemoveMethodInfo
    ResolveTextViewMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveTextViewMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveTextViewMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveTextViewMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveTextViewMethod "resetCursorBlink" o = TextViewResetCursorBlinkMethodInfo
    ResolveTextViewMethod "resetImContext" o = TextViewResetImContextMethodInfo
    ResolveTextViewMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveTextViewMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveTextViewMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveTextViewMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveTextViewMethod "scrollMarkOnscreen" o = TextViewScrollMarkOnscreenMethodInfo
    ResolveTextViewMethod "scrollToIter" o = TextViewScrollToIterMethodInfo
    ResolveTextViewMethod "scrollToMark" o = TextViewScrollToMarkMethodInfo
    ResolveTextViewMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveTextViewMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveTextViewMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveTextViewMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveTextViewMethod "startsDisplayLine" o = TextViewStartsDisplayLineMethodInfo
    ResolveTextViewMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveTextViewMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveTextViewMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveTextViewMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveTextViewMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveTextViewMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveTextViewMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveTextViewMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveTextViewMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveTextViewMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveTextViewMethod "updateCaretPosition" o = Gtk.AccessibleText.AccessibleTextUpdateCaretPositionMethodInfo
    ResolveTextViewMethod "updateContents" o = Gtk.AccessibleText.AccessibleTextUpdateContentsMethodInfo
    ResolveTextViewMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveTextViewMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveTextViewMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveTextViewMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveTextViewMethod "updateSelectionBound" o = Gtk.AccessibleText.AccessibleTextUpdateSelectionBoundMethodInfo
    ResolveTextViewMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveTextViewMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveTextViewMethod "windowToBufferCoords" o = TextViewWindowToBufferCoordsMethodInfo
    ResolveTextViewMethod "getAcceptsTab" o = TextViewGetAcceptsTabMethodInfo
    ResolveTextViewMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveTextViewMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveTextViewMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveTextViewMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveTextViewMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveTextViewMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveTextViewMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveTextViewMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveTextViewMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveTextViewMethod "getBorder" o = Gtk.Scrollable.ScrollableGetBorderMethodInfo
    ResolveTextViewMethod "getBottomMargin" o = TextViewGetBottomMarginMethodInfo
    ResolveTextViewMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveTextViewMethod "getBuffer" o = TextViewGetBufferMethodInfo
    ResolveTextViewMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveTextViewMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveTextViewMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveTextViewMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveTextViewMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveTextViewMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveTextViewMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveTextViewMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveTextViewMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveTextViewMethod "getCursorLocations" o = TextViewGetCursorLocationsMethodInfo
    ResolveTextViewMethod "getCursorVisible" o = TextViewGetCursorVisibleMethodInfo
    ResolveTextViewMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveTextViewMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveTextViewMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveTextViewMethod "getEditable" o = TextViewGetEditableMethodInfo
    ResolveTextViewMethod "getExtraMenu" o = TextViewGetExtraMenuMethodInfo
    ResolveTextViewMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveTextViewMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveTextViewMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveTextViewMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveTextViewMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveTextViewMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveTextViewMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveTextViewMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveTextViewMethod "getGutter" o = TextViewGetGutterMethodInfo
    ResolveTextViewMethod "getHadjustment" o = Gtk.Scrollable.ScrollableGetHadjustmentMethodInfo
    ResolveTextViewMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveTextViewMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveTextViewMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveTextViewMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveTextViewMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveTextViewMethod "getHscrollPolicy" o = Gtk.Scrollable.ScrollableGetHscrollPolicyMethodInfo
    ResolveTextViewMethod "getIndent" o = TextViewGetIndentMethodInfo
    ResolveTextViewMethod "getInputHints" o = TextViewGetInputHintsMethodInfo
    ResolveTextViewMethod "getInputPurpose" o = TextViewGetInputPurposeMethodInfo
    ResolveTextViewMethod "getIterAtLocation" o = TextViewGetIterAtLocationMethodInfo
    ResolveTextViewMethod "getIterAtPosition" o = TextViewGetIterAtPositionMethodInfo
    ResolveTextViewMethod "getIterLocation" o = TextViewGetIterLocationMethodInfo
    ResolveTextViewMethod "getJustification" o = TextViewGetJustificationMethodInfo
    ResolveTextViewMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveTextViewMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveTextViewMethod "getLeftMargin" o = TextViewGetLeftMarginMethodInfo
    ResolveTextViewMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveTextViewMethod "getLineAtY" o = TextViewGetLineAtYMethodInfo
    ResolveTextViewMethod "getLineYrange" o = TextViewGetLineYrangeMethodInfo
    ResolveTextViewMethod "getLtrContext" o = TextViewGetLtrContextMethodInfo
    ResolveTextViewMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveTextViewMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveTextViewMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveTextViewMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveTextViewMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveTextViewMethod "getMonospace" o = TextViewGetMonospaceMethodInfo
    ResolveTextViewMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveTextViewMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveTextViewMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveTextViewMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveTextViewMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveTextViewMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveTextViewMethod "getOverwrite" o = TextViewGetOverwriteMethodInfo
    ResolveTextViewMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveTextViewMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveTextViewMethod "getPixelsAboveLines" o = TextViewGetPixelsAboveLinesMethodInfo
    ResolveTextViewMethod "getPixelsBelowLines" o = TextViewGetPixelsBelowLinesMethodInfo
    ResolveTextViewMethod "getPixelsInsideWrap" o = TextViewGetPixelsInsideWrapMethodInfo
    ResolveTextViewMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveTextViewMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveTextViewMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveTextViewMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveTextViewMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveTextViewMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveTextViewMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveTextViewMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveTextViewMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveTextViewMethod "getRightMargin" o = TextViewGetRightMarginMethodInfo
    ResolveTextViewMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveTextViewMethod "getRtlContext" o = TextViewGetRtlContextMethodInfo
    ResolveTextViewMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveTextViewMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveTextViewMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveTextViewMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveTextViewMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveTextViewMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveTextViewMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveTextViewMethod "getTabs" o = TextViewGetTabsMethodInfo
    ResolveTextViewMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveTextViewMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveTextViewMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveTextViewMethod "getTopMargin" o = TextViewGetTopMarginMethodInfo
    ResolveTextViewMethod "getVadjustment" o = Gtk.Scrollable.ScrollableGetVadjustmentMethodInfo
    ResolveTextViewMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveTextViewMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveTextViewMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveTextViewMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveTextViewMethod "getVisibleOffset" o = TextViewGetVisibleOffsetMethodInfo
    ResolveTextViewMethod "getVisibleRect" o = TextViewGetVisibleRectMethodInfo
    ResolveTextViewMethod "getVscrollPolicy" o = Gtk.Scrollable.ScrollableGetVscrollPolicyMethodInfo
    ResolveTextViewMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveTextViewMethod "getWrapMode" o = TextViewGetWrapModeMethodInfo
    ResolveTextViewMethod "setAcceptsTab" o = TextViewSetAcceptsTabMethodInfo
    ResolveTextViewMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveTextViewMethod "setBottomMargin" o = TextViewSetBottomMarginMethodInfo
    ResolveTextViewMethod "setBuffer" o = TextViewSetBufferMethodInfo
    ResolveTextViewMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveTextViewMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveTextViewMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveTextViewMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveTextViewMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveTextViewMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveTextViewMethod "setCursorVisible" o = TextViewSetCursorVisibleMethodInfo
    ResolveTextViewMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveTextViewMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveTextViewMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveTextViewMethod "setEditable" o = TextViewSetEditableMethodInfo
    ResolveTextViewMethod "setExtraMenu" o = TextViewSetExtraMenuMethodInfo
    ResolveTextViewMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveTextViewMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveTextViewMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveTextViewMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveTextViewMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveTextViewMethod "setGutter" o = TextViewSetGutterMethodInfo
    ResolveTextViewMethod "setHadjustment" o = Gtk.Scrollable.ScrollableSetHadjustmentMethodInfo
    ResolveTextViewMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveTextViewMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveTextViewMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveTextViewMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveTextViewMethod "setHscrollPolicy" o = Gtk.Scrollable.ScrollableSetHscrollPolicyMethodInfo
    ResolveTextViewMethod "setIndent" o = TextViewSetIndentMethodInfo
    ResolveTextViewMethod "setInputHints" o = TextViewSetInputHintsMethodInfo
    ResolveTextViewMethod "setInputPurpose" o = TextViewSetInputPurposeMethodInfo
    ResolveTextViewMethod "setJustification" o = TextViewSetJustificationMethodInfo
    ResolveTextViewMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveTextViewMethod "setLeftMargin" o = TextViewSetLeftMarginMethodInfo
    ResolveTextViewMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveTextViewMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveTextViewMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveTextViewMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveTextViewMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveTextViewMethod "setMonospace" o = TextViewSetMonospaceMethodInfo
    ResolveTextViewMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveTextViewMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveTextViewMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveTextViewMethod "setOverwrite" o = TextViewSetOverwriteMethodInfo
    ResolveTextViewMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveTextViewMethod "setPixelsAboveLines" o = TextViewSetPixelsAboveLinesMethodInfo
    ResolveTextViewMethod "setPixelsBelowLines" o = TextViewSetPixelsBelowLinesMethodInfo
    ResolveTextViewMethod "setPixelsInsideWrap" o = TextViewSetPixelsInsideWrapMethodInfo
    ResolveTextViewMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveTextViewMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveTextViewMethod "setRightMargin" o = TextViewSetRightMarginMethodInfo
    ResolveTextViewMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveTextViewMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveTextViewMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveTextViewMethod "setTabs" o = TextViewSetTabsMethodInfo
    ResolveTextViewMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveTextViewMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveTextViewMethod "setTopMargin" o = TextViewSetTopMarginMethodInfo
    ResolveTextViewMethod "setVadjustment" o = Gtk.Scrollable.ScrollableSetVadjustmentMethodInfo
    ResolveTextViewMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveTextViewMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveTextViewMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveTextViewMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveTextViewMethod "setVscrollPolicy" o = Gtk.Scrollable.ScrollableSetVscrollPolicyMethodInfo
    ResolveTextViewMethod "setWrapMode" o = TextViewSetWrapModeMethodInfo
    ResolveTextViewMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveTextViewMethod t TextView, O.OverloadedMethod info TextView p) => OL.IsLabel t (TextView -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveTextViewMethod t TextView, O.OverloadedMethod info TextView p, R.HasField t TextView p) => R.HasField t TextView p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveTextViewMethod t TextView, O.OverloadedMethodInfo info TextView) => OL.IsLabel t (O.MethodProxy info TextView) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal TextView::backspace
-- | Gets emitted when the user asks for it.
-- 
-- The [backspace](#g:signal:backspace) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default bindings for this signal are
-- \<kbd>Backspace\<\/kbd> and \<kbd>Shift\<\/kbd>+\<kbd>Backspace\<\/kbd>.
type TextViewBackspaceCallback =
    IO ()

type C_TextViewBackspaceCallback =
    Ptr TextView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewBackspaceCallback`.
foreign import ccall "wrapper"
    mk_TextViewBackspaceCallback :: C_TextViewBackspaceCallback -> IO (FunPtr C_TextViewBackspaceCallback)

wrap_TextViewBackspaceCallback :: 
    GObject a => (a -> TextViewBackspaceCallback) ->
    C_TextViewBackspaceCallback
wrap_TextViewBackspaceCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [backspace](#signal:backspace) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #backspace callback
-- @
-- 
-- 
onTextViewBackspace :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewBackspaceCallback) -> m SignalHandlerId
onTextViewBackspace obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewBackspaceCallback wrapped
    wrapped'' <- mk_TextViewBackspaceCallback wrapped'
    connectSignalFunPtr obj "backspace" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [backspace](#signal:backspace) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #backspace callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewBackspace :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewBackspaceCallback) -> m SignalHandlerId
afterTextViewBackspace obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewBackspaceCallback wrapped
    wrapped'' <- mk_TextViewBackspaceCallback wrapped'
    connectSignalFunPtr obj "backspace" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewBackspaceSignalInfo
instance SignalInfo TextViewBackspaceSignalInfo where
    type HaskellCallbackType TextViewBackspaceSignalInfo = TextViewBackspaceCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewBackspaceCallback cb
        cb'' <- mk_TextViewBackspaceCallback cb'
        connectSignalFunPtr obj "backspace" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::backspace"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:backspace"})

#endif

-- signal TextView::copy-clipboard
-- | Gets emitted to copy the selection to the clipboard.
-- 
-- The [copyClipboard](#g:signal:copyClipboard) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default bindings for this signal are
-- \<kbd>Ctrl\<\/kbd>+\<kbd>c\<\/kbd> and
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Insert\<\/kbd>.
type TextViewCopyClipboardCallback =
    IO ()

type C_TextViewCopyClipboardCallback =
    Ptr TextView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewCopyClipboardCallback`.
foreign import ccall "wrapper"
    mk_TextViewCopyClipboardCallback :: C_TextViewCopyClipboardCallback -> IO (FunPtr C_TextViewCopyClipboardCallback)

wrap_TextViewCopyClipboardCallback :: 
    GObject a => (a -> TextViewCopyClipboardCallback) ->
    C_TextViewCopyClipboardCallback
wrap_TextViewCopyClipboardCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [copyClipboard](#signal:copyClipboard) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #copyClipboard callback
-- @
-- 
-- 
onTextViewCopyClipboard :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewCopyClipboardCallback) -> m SignalHandlerId
onTextViewCopyClipboard obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewCopyClipboardCallback wrapped
    wrapped'' <- mk_TextViewCopyClipboardCallback wrapped'
    connectSignalFunPtr obj "copy-clipboard" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [copyClipboard](#signal:copyClipboard) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #copyClipboard callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewCopyClipboard :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewCopyClipboardCallback) -> m SignalHandlerId
afterTextViewCopyClipboard obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewCopyClipboardCallback wrapped
    wrapped'' <- mk_TextViewCopyClipboardCallback wrapped'
    connectSignalFunPtr obj "copy-clipboard" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewCopyClipboardSignalInfo
instance SignalInfo TextViewCopyClipboardSignalInfo where
    type HaskellCallbackType TextViewCopyClipboardSignalInfo = TextViewCopyClipboardCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewCopyClipboardCallback cb
        cb'' <- mk_TextViewCopyClipboardCallback cb'
        connectSignalFunPtr obj "copy-clipboard" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::copy-clipboard"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:copyClipboard"})

#endif

-- signal TextView::cut-clipboard
-- | Gets emitted to cut the selection to the clipboard.
-- 
-- The [cutClipboard](#g:signal:cutClipboard) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default bindings for this signal are
-- \<kbd>Ctrl\<\/kbd>+\<kbd>x\<\/kbd> and
-- \<kbd>Shift\<\/kbd>+\<kbd>Delete\<\/kbd>.
type TextViewCutClipboardCallback =
    IO ()

type C_TextViewCutClipboardCallback =
    Ptr TextView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewCutClipboardCallback`.
foreign import ccall "wrapper"
    mk_TextViewCutClipboardCallback :: C_TextViewCutClipboardCallback -> IO (FunPtr C_TextViewCutClipboardCallback)

wrap_TextViewCutClipboardCallback :: 
    GObject a => (a -> TextViewCutClipboardCallback) ->
    C_TextViewCutClipboardCallback
wrap_TextViewCutClipboardCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [cutClipboard](#signal:cutClipboard) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #cutClipboard callback
-- @
-- 
-- 
onTextViewCutClipboard :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewCutClipboardCallback) -> m SignalHandlerId
onTextViewCutClipboard obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewCutClipboardCallback wrapped
    wrapped'' <- mk_TextViewCutClipboardCallback wrapped'
    connectSignalFunPtr obj "cut-clipboard" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [cutClipboard](#signal:cutClipboard) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #cutClipboard callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewCutClipboard :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewCutClipboardCallback) -> m SignalHandlerId
afterTextViewCutClipboard obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewCutClipboardCallback wrapped
    wrapped'' <- mk_TextViewCutClipboardCallback wrapped'
    connectSignalFunPtr obj "cut-clipboard" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewCutClipboardSignalInfo
instance SignalInfo TextViewCutClipboardSignalInfo where
    type HaskellCallbackType TextViewCutClipboardSignalInfo = TextViewCutClipboardCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewCutClipboardCallback cb
        cb'' <- mk_TextViewCutClipboardCallback cb'
        connectSignalFunPtr obj "cut-clipboard" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::cut-clipboard"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:cutClipboard"})

#endif

-- signal TextView::delete-from-cursor
-- | Gets emitted when the user initiates a text deletion.
-- 
-- The [deleteFromCursor](#g:signal:deleteFromCursor) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- If the /@type@/ is 'GI.Gtk.Enums.DeleteTypeChars', GTK deletes the selection
-- if there is one, otherwise it deletes the requested number
-- of characters.
-- 
-- The default bindings for this signal are \<kbd>Delete\<\/kbd> for
-- deleting a character, \<kbd>Ctrl\<\/kbd>+\<kbd>Delete\<\/kbd> for
-- deleting a word and \<kbd>Ctrl\<\/kbd>+\<kbd>Backspace\<\/kbd> for
-- deleting a word backwards.
type TextViewDeleteFromCursorCallback =
    Gtk.Enums.DeleteType
    -- ^ /@type@/: the granularity of the deletion, as a @GtkDeleteType@
    -> Int32
    -- ^ /@count@/: the number of /@type@/ units to delete
    -> IO ()

type C_TextViewDeleteFromCursorCallback =
    Ptr TextView ->                         -- object
    CUInt ->
    Int32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewDeleteFromCursorCallback`.
foreign import ccall "wrapper"
    mk_TextViewDeleteFromCursorCallback :: C_TextViewDeleteFromCursorCallback -> IO (FunPtr C_TextViewDeleteFromCursorCallback)

wrap_TextViewDeleteFromCursorCallback :: 
    GObject a => (a -> TextViewDeleteFromCursorCallback) ->
    C_TextViewDeleteFromCursorCallback
wrap_TextViewDeleteFromCursorCallback gi'cb gi'selfPtr type_ count _ = do
    let type_' = (toEnum . fromIntegral) type_
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  type_' count


-- | Connect a signal handler for the [deleteFromCursor](#signal:deleteFromCursor) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #deleteFromCursor callback
-- @
-- 
-- 
onTextViewDeleteFromCursor :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewDeleteFromCursorCallback) -> m SignalHandlerId
onTextViewDeleteFromCursor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewDeleteFromCursorCallback wrapped
    wrapped'' <- mk_TextViewDeleteFromCursorCallback wrapped'
    connectSignalFunPtr obj "delete-from-cursor" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [deleteFromCursor](#signal:deleteFromCursor) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #deleteFromCursor callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewDeleteFromCursor :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewDeleteFromCursorCallback) -> m SignalHandlerId
afterTextViewDeleteFromCursor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewDeleteFromCursorCallback wrapped
    wrapped'' <- mk_TextViewDeleteFromCursorCallback wrapped'
    connectSignalFunPtr obj "delete-from-cursor" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewDeleteFromCursorSignalInfo
instance SignalInfo TextViewDeleteFromCursorSignalInfo where
    type HaskellCallbackType TextViewDeleteFromCursorSignalInfo = TextViewDeleteFromCursorCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewDeleteFromCursorCallback cb
        cb'' <- mk_TextViewDeleteFromCursorCallback cb'
        connectSignalFunPtr obj "delete-from-cursor" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::delete-from-cursor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:deleteFromCursor"})

#endif

-- signal TextView::extend-selection
-- | Emitted when the selection needs to be extended at /@location@/.
type TextViewExtendSelectionCallback =
    Gtk.Enums.TextExtendSelection
    -- ^ /@granularity@/: the granularity type
    -> Gtk.TextIter.TextIter
    -- ^ /@location@/: the location where to extend the selection
    -> Gtk.TextIter.TextIter
    -- ^ /@start@/: where the selection should start
    -> Gtk.TextIter.TextIter
    -- ^ /@end@/: where the selection should end
    -> IO Bool
    -- ^ __Returns:__ 'GI.Gdk.Constants.EVENT_STOP' to stop other handlers from being invoked for the
    --   event. 'GI.Gdk.Constants.EVENT_PROPAGATE' to propagate the event further.

type C_TextViewExtendSelectionCallback =
    Ptr TextView ->                         -- object
    CUInt ->
    Ptr Gtk.TextIter.TextIter ->
    Ptr Gtk.TextIter.TextIter ->
    Ptr Gtk.TextIter.TextIter ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_TextViewExtendSelectionCallback`.
foreign import ccall "wrapper"
    mk_TextViewExtendSelectionCallback :: C_TextViewExtendSelectionCallback -> IO (FunPtr C_TextViewExtendSelectionCallback)

wrap_TextViewExtendSelectionCallback :: 
    GObject a => (a -> TextViewExtendSelectionCallback) ->
    C_TextViewExtendSelectionCallback
wrap_TextViewExtendSelectionCallback gi'cb gi'selfPtr granularity location start end _ = do
    let granularity' = (toEnum . fromIntegral) granularity
    B.ManagedPtr.withTransient  location $ \location' -> do
        B.ManagedPtr.withTransient  start $ \start' -> do
            B.ManagedPtr.withTransient  end $ \end' -> do
                result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  granularity' location' start' end'
                let result' = (P.fromIntegral . P.fromEnum) result
                return result'


-- | Connect a signal handler for the [extendSelection](#signal:extendSelection) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #extendSelection callback
-- @
-- 
-- 
onTextViewExtendSelection :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewExtendSelectionCallback) -> m SignalHandlerId
onTextViewExtendSelection obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewExtendSelectionCallback wrapped
    wrapped'' <- mk_TextViewExtendSelectionCallback wrapped'
    connectSignalFunPtr obj "extend-selection" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [extendSelection](#signal:extendSelection) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #extendSelection callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewExtendSelection :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewExtendSelectionCallback) -> m SignalHandlerId
afterTextViewExtendSelection obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewExtendSelectionCallback wrapped
    wrapped'' <- mk_TextViewExtendSelectionCallback wrapped'
    connectSignalFunPtr obj "extend-selection" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewExtendSelectionSignalInfo
instance SignalInfo TextViewExtendSelectionSignalInfo where
    type HaskellCallbackType TextViewExtendSelectionSignalInfo = TextViewExtendSelectionCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewExtendSelectionCallback cb
        cb'' <- mk_TextViewExtendSelectionCallback cb'
        connectSignalFunPtr obj "extend-selection" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::extend-selection"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:extendSelection"})

#endif

-- signal TextView::insert-at-cursor
-- | Gets emitted when the user initiates the insertion of a
-- fixed string at the cursor.
-- 
-- The [insertAtCursor](#g:signal:insertAtCursor) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- This signal has no default bindings.
type TextViewInsertAtCursorCallback =
    T.Text
    -- ^ /@string@/: the string to insert
    -> IO ()

type C_TextViewInsertAtCursorCallback =
    Ptr TextView ->                         -- object
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewInsertAtCursorCallback`.
foreign import ccall "wrapper"
    mk_TextViewInsertAtCursorCallback :: C_TextViewInsertAtCursorCallback -> IO (FunPtr C_TextViewInsertAtCursorCallback)

wrap_TextViewInsertAtCursorCallback :: 
    GObject a => (a -> TextViewInsertAtCursorCallback) ->
    C_TextViewInsertAtCursorCallback
wrap_TextViewInsertAtCursorCallback gi'cb gi'selfPtr string _ = do
    string' <- cstringToText string
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  string'


-- | Connect a signal handler for the [insertAtCursor](#signal:insertAtCursor) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #insertAtCursor callback
-- @
-- 
-- 
onTextViewInsertAtCursor :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewInsertAtCursorCallback) -> m SignalHandlerId
onTextViewInsertAtCursor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewInsertAtCursorCallback wrapped
    wrapped'' <- mk_TextViewInsertAtCursorCallback wrapped'
    connectSignalFunPtr obj "insert-at-cursor" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [insertAtCursor](#signal:insertAtCursor) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #insertAtCursor callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewInsertAtCursor :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewInsertAtCursorCallback) -> m SignalHandlerId
afterTextViewInsertAtCursor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewInsertAtCursorCallback wrapped
    wrapped'' <- mk_TextViewInsertAtCursorCallback wrapped'
    connectSignalFunPtr obj "insert-at-cursor" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewInsertAtCursorSignalInfo
instance SignalInfo TextViewInsertAtCursorSignalInfo where
    type HaskellCallbackType TextViewInsertAtCursorSignalInfo = TextViewInsertAtCursorCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewInsertAtCursorCallback cb
        cb'' <- mk_TextViewInsertAtCursorCallback cb'
        connectSignalFunPtr obj "insert-at-cursor" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::insert-at-cursor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:insertAtCursor"})

#endif

-- signal TextView::insert-emoji
-- | Gets emitted to present the Emoji chooser for the /@textView@/.
-- 
-- The [insertEmoji](#g:signal:insertEmoji) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default bindings for this signal are
-- \<kbd>Ctrl\<\/kbd>+\<kbd>.\<\/kbd> and
-- \<kbd>Ctrl\<\/kbd>+\<kbd>;\<\/kbd>
type TextViewInsertEmojiCallback =
    IO ()

type C_TextViewInsertEmojiCallback =
    Ptr TextView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewInsertEmojiCallback`.
foreign import ccall "wrapper"
    mk_TextViewInsertEmojiCallback :: C_TextViewInsertEmojiCallback -> IO (FunPtr C_TextViewInsertEmojiCallback)

wrap_TextViewInsertEmojiCallback :: 
    GObject a => (a -> TextViewInsertEmojiCallback) ->
    C_TextViewInsertEmojiCallback
wrap_TextViewInsertEmojiCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [insertEmoji](#signal:insertEmoji) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #insertEmoji callback
-- @
-- 
-- 
onTextViewInsertEmoji :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewInsertEmojiCallback) -> m SignalHandlerId
onTextViewInsertEmoji obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewInsertEmojiCallback wrapped
    wrapped'' <- mk_TextViewInsertEmojiCallback wrapped'
    connectSignalFunPtr obj "insert-emoji" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [insertEmoji](#signal:insertEmoji) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #insertEmoji callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewInsertEmoji :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewInsertEmojiCallback) -> m SignalHandlerId
afterTextViewInsertEmoji obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewInsertEmojiCallback wrapped
    wrapped'' <- mk_TextViewInsertEmojiCallback wrapped'
    connectSignalFunPtr obj "insert-emoji" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewInsertEmojiSignalInfo
instance SignalInfo TextViewInsertEmojiSignalInfo where
    type HaskellCallbackType TextViewInsertEmojiSignalInfo = TextViewInsertEmojiCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewInsertEmojiCallback cb
        cb'' <- mk_TextViewInsertEmojiCallback cb'
        connectSignalFunPtr obj "insert-emoji" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::insert-emoji"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:insertEmoji"})

#endif

-- signal TextView::move-cursor
-- | Gets emitted when the user initiates a cursor movement.
-- 
-- The [moveCursor](#g:signal:moveCursor) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- If the cursor is not visible in /@textView@/, this signal causes
-- the viewport to be moved instead.
-- 
-- Applications should not connect to it, but may emit it with
-- @/g_signal_emit_by_name()/@ if they need to control the cursor
-- programmatically.
-- 
-- 
-- The default bindings for this signal come in two variants,
-- the variant with the \<kbd>Shift\<\/kbd> modifier extends the
-- selection, the variant without it does not.
-- There are too many key combinations to list them all here.
-- 
-- * \<kbd>←\<\/kbd>, \<kbd>→\<\/kbd>, \<kbd>↑\<\/kbd>, \<kbd>↓\<\/kbd>
-- move by individual characters\/lines
-- * \<kbd>Ctrl\<\/kbd>+\<kbd>←\<\/kbd>, etc. move by words\/paragraphs
-- * \<kbd>Home\<\/kbd> and \<kbd>End\<\/kbd> move to the ends of the buffer
-- * \<kbd>PgUp\<\/kbd> and \<kbd>PgDn\<\/kbd> move vertically by pages
-- * \<kbd>Ctrl\<\/kbd>+\<kbd>PgUp\<\/kbd> and \<kbd>Ctrl\<\/kbd>+\<kbd>PgDn\<\/kbd>
-- move horizontally by pages
type TextViewMoveCursorCallback =
    Gtk.Enums.MovementStep
    -- ^ /@step@/: the granularity of the move, as a @GtkMovementStep@
    -> Int32
    -- ^ /@count@/: the number of /@step@/ units to move
    -> Bool
    -- ^ /@extendSelection@/: 'P.True' if the move should extend the selection
    -> IO ()

type C_TextViewMoveCursorCallback =
    Ptr TextView ->                         -- object
    CUInt ->
    Int32 ->
    CInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewMoveCursorCallback`.
foreign import ccall "wrapper"
    mk_TextViewMoveCursorCallback :: C_TextViewMoveCursorCallback -> IO (FunPtr C_TextViewMoveCursorCallback)

wrap_TextViewMoveCursorCallback :: 
    GObject a => (a -> TextViewMoveCursorCallback) ->
    C_TextViewMoveCursorCallback
wrap_TextViewMoveCursorCallback gi'cb gi'selfPtr step count extendSelection _ = do
    let step' = (toEnum . fromIntegral) step
    let extendSelection' = (/= 0) extendSelection
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  step' count extendSelection'


-- | Connect a signal handler for the [moveCursor](#signal:moveCursor) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #moveCursor callback
-- @
-- 
-- 
onTextViewMoveCursor :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewMoveCursorCallback) -> m SignalHandlerId
onTextViewMoveCursor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewMoveCursorCallback wrapped
    wrapped'' <- mk_TextViewMoveCursorCallback wrapped'
    connectSignalFunPtr obj "move-cursor" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [moveCursor](#signal:moveCursor) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #moveCursor callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewMoveCursor :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewMoveCursorCallback) -> m SignalHandlerId
afterTextViewMoveCursor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewMoveCursorCallback wrapped
    wrapped'' <- mk_TextViewMoveCursorCallback wrapped'
    connectSignalFunPtr obj "move-cursor" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewMoveCursorSignalInfo
instance SignalInfo TextViewMoveCursorSignalInfo where
    type HaskellCallbackType TextViewMoveCursorSignalInfo = TextViewMoveCursorCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewMoveCursorCallback cb
        cb'' <- mk_TextViewMoveCursorCallback cb'
        connectSignalFunPtr obj "move-cursor" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::move-cursor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:moveCursor"})

#endif

-- signal TextView::move-viewport
-- | Gets emitted to move the viewport.
-- 
-- The [moveViewport](#g:signal:moveViewport) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>,
-- which can be bound to key combinations to allow the user to move the viewport,
-- i.e. change what part of the text view is visible in a containing scrolled
-- window.
-- 
-- There are no default bindings for this signal.
type TextViewMoveViewportCallback =
    Gtk.Enums.ScrollStep
    -- ^ /@step@/: the granularity of the movement, as a @GtkScrollStep@
    -> Int32
    -- ^ /@count@/: the number of /@step@/ units to move
    -> IO ()

type C_TextViewMoveViewportCallback =
    Ptr TextView ->                         -- object
    CUInt ->
    Int32 ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewMoveViewportCallback`.
foreign import ccall "wrapper"
    mk_TextViewMoveViewportCallback :: C_TextViewMoveViewportCallback -> IO (FunPtr C_TextViewMoveViewportCallback)

wrap_TextViewMoveViewportCallback :: 
    GObject a => (a -> TextViewMoveViewportCallback) ->
    C_TextViewMoveViewportCallback
wrap_TextViewMoveViewportCallback gi'cb gi'selfPtr step count _ = do
    let step' = (toEnum . fromIntegral) step
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  step' count


-- | Connect a signal handler for the [moveViewport](#signal:moveViewport) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #moveViewport callback
-- @
-- 
-- 
onTextViewMoveViewport :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewMoveViewportCallback) -> m SignalHandlerId
onTextViewMoveViewport obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewMoveViewportCallback wrapped
    wrapped'' <- mk_TextViewMoveViewportCallback wrapped'
    connectSignalFunPtr obj "move-viewport" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [moveViewport](#signal:moveViewport) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #moveViewport callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewMoveViewport :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewMoveViewportCallback) -> m SignalHandlerId
afterTextViewMoveViewport obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewMoveViewportCallback wrapped
    wrapped'' <- mk_TextViewMoveViewportCallback wrapped'
    connectSignalFunPtr obj "move-viewport" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewMoveViewportSignalInfo
instance SignalInfo TextViewMoveViewportSignalInfo where
    type HaskellCallbackType TextViewMoveViewportSignalInfo = TextViewMoveViewportCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewMoveViewportCallback cb
        cb'' <- mk_TextViewMoveViewportCallback cb'
        connectSignalFunPtr obj "move-viewport" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::move-viewport"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:moveViewport"})

#endif

-- signal TextView::paste-clipboard
-- | Gets emitted to paste the contents of the clipboard
-- into the text view.
-- 
-- The [pasteClipboard](#g:signal:pasteClipboard) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default bindings for this signal are
-- \<kbd>Ctrl\<\/kbd>+\<kbd>v\<\/kbd> and
-- \<kbd>Shift\<\/kbd>+\<kbd>Insert\<\/kbd>.
type TextViewPasteClipboardCallback =
    IO ()

type C_TextViewPasteClipboardCallback =
    Ptr TextView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewPasteClipboardCallback`.
foreign import ccall "wrapper"
    mk_TextViewPasteClipboardCallback :: C_TextViewPasteClipboardCallback -> IO (FunPtr C_TextViewPasteClipboardCallback)

wrap_TextViewPasteClipboardCallback :: 
    GObject a => (a -> TextViewPasteClipboardCallback) ->
    C_TextViewPasteClipboardCallback
wrap_TextViewPasteClipboardCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [pasteClipboard](#signal:pasteClipboard) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #pasteClipboard callback
-- @
-- 
-- 
onTextViewPasteClipboard :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewPasteClipboardCallback) -> m SignalHandlerId
onTextViewPasteClipboard obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewPasteClipboardCallback wrapped
    wrapped'' <- mk_TextViewPasteClipboardCallback wrapped'
    connectSignalFunPtr obj "paste-clipboard" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [pasteClipboard](#signal:pasteClipboard) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #pasteClipboard callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewPasteClipboard :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewPasteClipboardCallback) -> m SignalHandlerId
afterTextViewPasteClipboard obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewPasteClipboardCallback wrapped
    wrapped'' <- mk_TextViewPasteClipboardCallback wrapped'
    connectSignalFunPtr obj "paste-clipboard" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewPasteClipboardSignalInfo
instance SignalInfo TextViewPasteClipboardSignalInfo where
    type HaskellCallbackType TextViewPasteClipboardSignalInfo = TextViewPasteClipboardCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewPasteClipboardCallback cb
        cb'' <- mk_TextViewPasteClipboardCallback cb'
        connectSignalFunPtr obj "paste-clipboard" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::paste-clipboard"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:pasteClipboard"})

#endif

-- signal TextView::preedit-changed
-- | Emitted when preedit text of the active IM changes.
-- 
-- If an input method is used, the typed text will not immediately
-- be committed to the buffer. So if you are interested in the text,
-- connect to this signal.
-- 
-- This signal is only emitted if the text at the given position
-- is actually editable.
type TextViewPreeditChangedCallback =
    T.Text
    -- ^ /@preedit@/: the current preedit string
    -> IO ()

type C_TextViewPreeditChangedCallback =
    Ptr TextView ->                         -- object
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewPreeditChangedCallback`.
foreign import ccall "wrapper"
    mk_TextViewPreeditChangedCallback :: C_TextViewPreeditChangedCallback -> IO (FunPtr C_TextViewPreeditChangedCallback)

wrap_TextViewPreeditChangedCallback :: 
    GObject a => (a -> TextViewPreeditChangedCallback) ->
    C_TextViewPreeditChangedCallback
wrap_TextViewPreeditChangedCallback gi'cb gi'selfPtr preedit _ = do
    preedit' <- cstringToText preedit
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  preedit'


-- | Connect a signal handler for the [preeditChanged](#signal:preeditChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #preeditChanged callback
-- @
-- 
-- 
onTextViewPreeditChanged :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewPreeditChangedCallback) -> m SignalHandlerId
onTextViewPreeditChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewPreeditChangedCallback wrapped
    wrapped'' <- mk_TextViewPreeditChangedCallback wrapped'
    connectSignalFunPtr obj "preedit-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [preeditChanged](#signal:preeditChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #preeditChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewPreeditChanged :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewPreeditChangedCallback) -> m SignalHandlerId
afterTextViewPreeditChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewPreeditChangedCallback wrapped
    wrapped'' <- mk_TextViewPreeditChangedCallback wrapped'
    connectSignalFunPtr obj "preedit-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewPreeditChangedSignalInfo
instance SignalInfo TextViewPreeditChangedSignalInfo where
    type HaskellCallbackType TextViewPreeditChangedSignalInfo = TextViewPreeditChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewPreeditChangedCallback cb
        cb'' <- mk_TextViewPreeditChangedCallback cb'
        connectSignalFunPtr obj "preedit-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::preedit-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:preeditChanged"})

#endif

-- signal TextView::select-all
-- | Gets emitted to select or unselect the complete contents of the text view.
-- 
-- The [selectAll](#g:signal:selectAll) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default bindings for this signal are
-- \<kbd>Ctrl\<\/kbd>+\<kbd>a\<\/kbd> and
-- \<kbd>Ctrl\<\/kbd>+\<kbd>\/\<\/kbd> for selecting and
-- \<kbd>Shift\<\/kbd>+\<kbd>Ctrl\<\/kbd>+\<kbd>a\<\/kbd> and
-- \<kbd>Ctrl\<\/kbd>+\<kbd>\\\<\/kbd> for unselecting.
type TextViewSelectAllCallback =
    Bool
    -- ^ /@select@/: 'P.True' to select, 'P.False' to unselect
    -> IO ()

type C_TextViewSelectAllCallback =
    Ptr TextView ->                         -- object
    CInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewSelectAllCallback`.
foreign import ccall "wrapper"
    mk_TextViewSelectAllCallback :: C_TextViewSelectAllCallback -> IO (FunPtr C_TextViewSelectAllCallback)

wrap_TextViewSelectAllCallback :: 
    GObject a => (a -> TextViewSelectAllCallback) ->
    C_TextViewSelectAllCallback
wrap_TextViewSelectAllCallback gi'cb gi'selfPtr select _ = do
    let select' = (/= 0) select
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  select'


-- | Connect a signal handler for the [selectAll](#signal:selectAll) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #selectAll callback
-- @
-- 
-- 
onTextViewSelectAll :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewSelectAllCallback) -> m SignalHandlerId
onTextViewSelectAll obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewSelectAllCallback wrapped
    wrapped'' <- mk_TextViewSelectAllCallback wrapped'
    connectSignalFunPtr obj "select-all" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [selectAll](#signal:selectAll) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #selectAll callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewSelectAll :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewSelectAllCallback) -> m SignalHandlerId
afterTextViewSelectAll obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewSelectAllCallback wrapped
    wrapped'' <- mk_TextViewSelectAllCallback wrapped'
    connectSignalFunPtr obj "select-all" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewSelectAllSignalInfo
instance SignalInfo TextViewSelectAllSignalInfo where
    type HaskellCallbackType TextViewSelectAllSignalInfo = TextViewSelectAllCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewSelectAllCallback cb
        cb'' <- mk_TextViewSelectAllCallback cb'
        connectSignalFunPtr obj "select-all" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::select-all"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:selectAll"})

#endif

-- signal TextView::set-anchor
-- | Gets emitted when the user initiates settings the \"anchor\" mark.
-- 
-- The [setAnchor](#g:signal:setAnchor) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>
-- which gets emitted when the user initiates setting the \"anchor\"
-- mark. The \"anchor\" mark gets placed at the same position as the
-- \"insert\" mark.
-- 
-- This signal has no default bindings.
type TextViewSetAnchorCallback =
    IO ()

type C_TextViewSetAnchorCallback =
    Ptr TextView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewSetAnchorCallback`.
foreign import ccall "wrapper"
    mk_TextViewSetAnchorCallback :: C_TextViewSetAnchorCallback -> IO (FunPtr C_TextViewSetAnchorCallback)

wrap_TextViewSetAnchorCallback :: 
    GObject a => (a -> TextViewSetAnchorCallback) ->
    C_TextViewSetAnchorCallback
wrap_TextViewSetAnchorCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [setAnchor](#signal:setAnchor) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #setAnchor callback
-- @
-- 
-- 
onTextViewSetAnchor :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewSetAnchorCallback) -> m SignalHandlerId
onTextViewSetAnchor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewSetAnchorCallback wrapped
    wrapped'' <- mk_TextViewSetAnchorCallback wrapped'
    connectSignalFunPtr obj "set-anchor" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [setAnchor](#signal:setAnchor) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #setAnchor callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewSetAnchor :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewSetAnchorCallback) -> m SignalHandlerId
afterTextViewSetAnchor obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewSetAnchorCallback wrapped
    wrapped'' <- mk_TextViewSetAnchorCallback wrapped'
    connectSignalFunPtr obj "set-anchor" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewSetAnchorSignalInfo
instance SignalInfo TextViewSetAnchorSignalInfo where
    type HaskellCallbackType TextViewSetAnchorSignalInfo = TextViewSetAnchorCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewSetAnchorCallback cb
        cb'' <- mk_TextViewSetAnchorCallback cb'
        connectSignalFunPtr obj "set-anchor" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::set-anchor"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:setAnchor"})

#endif

-- signal TextView::toggle-cursor-visible
-- | Gets emitted to toggle the @cursor-visible@ property.
-- 
-- The [toggleCursorVisible](#g:signal:toggleCursorVisible) signal is a
-- <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is \<kbd>F7\<\/kbd>.
type TextViewToggleCursorVisibleCallback =
    IO ()

type C_TextViewToggleCursorVisibleCallback =
    Ptr TextView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewToggleCursorVisibleCallback`.
foreign import ccall "wrapper"
    mk_TextViewToggleCursorVisibleCallback :: C_TextViewToggleCursorVisibleCallback -> IO (FunPtr C_TextViewToggleCursorVisibleCallback)

wrap_TextViewToggleCursorVisibleCallback :: 
    GObject a => (a -> TextViewToggleCursorVisibleCallback) ->
    C_TextViewToggleCursorVisibleCallback
wrap_TextViewToggleCursorVisibleCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [toggleCursorVisible](#signal:toggleCursorVisible) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #toggleCursorVisible callback
-- @
-- 
-- 
onTextViewToggleCursorVisible :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewToggleCursorVisibleCallback) -> m SignalHandlerId
onTextViewToggleCursorVisible obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewToggleCursorVisibleCallback wrapped
    wrapped'' <- mk_TextViewToggleCursorVisibleCallback wrapped'
    connectSignalFunPtr obj "toggle-cursor-visible" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [toggleCursorVisible](#signal:toggleCursorVisible) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #toggleCursorVisible callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewToggleCursorVisible :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewToggleCursorVisibleCallback) -> m SignalHandlerId
afterTextViewToggleCursorVisible obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewToggleCursorVisibleCallback wrapped
    wrapped'' <- mk_TextViewToggleCursorVisibleCallback wrapped'
    connectSignalFunPtr obj "toggle-cursor-visible" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewToggleCursorVisibleSignalInfo
instance SignalInfo TextViewToggleCursorVisibleSignalInfo where
    type HaskellCallbackType TextViewToggleCursorVisibleSignalInfo = TextViewToggleCursorVisibleCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewToggleCursorVisibleCallback cb
        cb'' <- mk_TextViewToggleCursorVisibleCallback cb'
        connectSignalFunPtr obj "toggle-cursor-visible" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::toggle-cursor-visible"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:toggleCursorVisible"})

#endif

-- signal TextView::toggle-overwrite
-- | Gets emitted to toggle the overwrite mode of the text view.
-- 
-- The [toggleOverwrite](#g:signal:toggleOverwrite) signal is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is \<kbd>Insert\<\/kbd>.
type TextViewToggleOverwriteCallback =
    IO ()

type C_TextViewToggleOverwriteCallback =
    Ptr TextView ->                         -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_TextViewToggleOverwriteCallback`.
foreign import ccall "wrapper"
    mk_TextViewToggleOverwriteCallback :: C_TextViewToggleOverwriteCallback -> IO (FunPtr C_TextViewToggleOverwriteCallback)

wrap_TextViewToggleOverwriteCallback :: 
    GObject a => (a -> TextViewToggleOverwriteCallback) ->
    C_TextViewToggleOverwriteCallback
wrap_TextViewToggleOverwriteCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [toggleOverwrite](#signal:toggleOverwrite) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' textView #toggleOverwrite callback
-- @
-- 
-- 
onTextViewToggleOverwrite :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewToggleOverwriteCallback) -> m SignalHandlerId
onTextViewToggleOverwrite obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewToggleOverwriteCallback wrapped
    wrapped'' <- mk_TextViewToggleOverwriteCallback wrapped'
    connectSignalFunPtr obj "toggle-overwrite" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [toggleOverwrite](#signal:toggleOverwrite) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' textView #toggleOverwrite callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterTextViewToggleOverwrite :: (IsTextView a, MonadIO m) => a -> ((?self :: a) => TextViewToggleOverwriteCallback) -> m SignalHandlerId
afterTextViewToggleOverwrite obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_TextViewToggleOverwriteCallback wrapped
    wrapped'' <- mk_TextViewToggleOverwriteCallback wrapped'
    connectSignalFunPtr obj "toggle-overwrite" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data TextViewToggleOverwriteSignalInfo
instance SignalInfo TextViewToggleOverwriteSignalInfo where
    type HaskellCallbackType TextViewToggleOverwriteSignalInfo = TextViewToggleOverwriteCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_TextViewToggleOverwriteCallback cb
        cb'' <- mk_TextViewToggleOverwriteCallback cb'
        connectSignalFunPtr obj "toggle-overwrite" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView::toggle-overwrite"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:signal:toggleOverwrite"})

#endif

-- VVV Prop "accepts-tab"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@accepts-tab@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #acceptsTab
-- @
getTextViewAcceptsTab :: (MonadIO m, IsTextView o) => o -> m Bool
getTextViewAcceptsTab obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "accepts-tab"

-- | Set the value of the “@accepts-tab@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #acceptsTab 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewAcceptsTab :: (MonadIO m, IsTextView o) => o -> Bool -> m ()
setTextViewAcceptsTab obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "accepts-tab" val

-- | Construct a `GValueConstruct` with valid value for the “@accepts-tab@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewAcceptsTab :: (IsTextView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTextViewAcceptsTab val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "accepts-tab" val

#if defined(ENABLE_OVERLOADING)
data TextViewAcceptsTabPropertyInfo
instance AttrInfo TextViewAcceptsTabPropertyInfo where
    type AttrAllowedOps TextViewAcceptsTabPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewAcceptsTabPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewAcceptsTabPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TextViewAcceptsTabPropertyInfo = (~) Bool
    type AttrTransferType TextViewAcceptsTabPropertyInfo = Bool
    type AttrGetType TextViewAcceptsTabPropertyInfo = Bool
    type AttrLabel TextViewAcceptsTabPropertyInfo = "accepts-tab"
    type AttrOrigin TextViewAcceptsTabPropertyInfo = TextView
    attrGet = getTextViewAcceptsTab
    attrSet = setTextViewAcceptsTab
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewAcceptsTab
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.acceptsTab"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:acceptsTab"
        })
#endif

-- VVV Prop "bottom-margin"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@bottom-margin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #bottomMargin
-- @
getTextViewBottomMargin :: (MonadIO m, IsTextView o) => o -> m Int32
getTextViewBottomMargin obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "bottom-margin"

-- | Set the value of the “@bottom-margin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #bottomMargin 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewBottomMargin :: (MonadIO m, IsTextView o) => o -> Int32 -> m ()
setTextViewBottomMargin obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "bottom-margin" val

-- | Construct a `GValueConstruct` with valid value for the “@bottom-margin@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewBottomMargin :: (IsTextView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructTextViewBottomMargin val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "bottom-margin" val

#if defined(ENABLE_OVERLOADING)
data TextViewBottomMarginPropertyInfo
instance AttrInfo TextViewBottomMarginPropertyInfo where
    type AttrAllowedOps TextViewBottomMarginPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewBottomMarginPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewBottomMarginPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint TextViewBottomMarginPropertyInfo = (~) Int32
    type AttrTransferType TextViewBottomMarginPropertyInfo = Int32
    type AttrGetType TextViewBottomMarginPropertyInfo = Int32
    type AttrLabel TextViewBottomMarginPropertyInfo = "bottom-margin"
    type AttrOrigin TextViewBottomMarginPropertyInfo = TextView
    attrGet = getTextViewBottomMargin
    attrSet = setTextViewBottomMargin
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewBottomMargin
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.bottomMargin"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:bottomMargin"
        })
#endif

-- VVV Prop "buffer"
   -- Type: TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just True)

-- | Get the value of the “@buffer@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #buffer
-- @
getTextViewBuffer :: (MonadIO m, IsTextView o) => o -> m Gtk.TextBuffer.TextBuffer
getTextViewBuffer obj = MIO.liftIO $ checkUnexpectedNothing "getTextViewBuffer" $ B.Properties.getObjectPropertyObject obj "buffer" Gtk.TextBuffer.TextBuffer

-- | Set the value of the “@buffer@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #buffer 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewBuffer :: (MonadIO m, IsTextView o, Gtk.TextBuffer.IsTextBuffer a) => o -> a -> m ()
setTextViewBuffer obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "buffer" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@buffer@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewBuffer :: (IsTextView o, MIO.MonadIO m, Gtk.TextBuffer.IsTextBuffer a) => a -> m (GValueConstruct o)
constructTextViewBuffer val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "buffer" (P.Just val)

-- | Set the value of the “@buffer@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #buffer
-- @
clearTextViewBuffer :: (MonadIO m, IsTextView o) => o -> m ()
clearTextViewBuffer obj = liftIO $ B.Properties.setObjectPropertyObject obj "buffer" (Nothing :: Maybe Gtk.TextBuffer.TextBuffer)

#if defined(ENABLE_OVERLOADING)
data TextViewBufferPropertyInfo
instance AttrInfo TextViewBufferPropertyInfo where
    type AttrAllowedOps TextViewBufferPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TextViewBufferPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewBufferPropertyInfo = Gtk.TextBuffer.IsTextBuffer
    type AttrTransferTypeConstraint TextViewBufferPropertyInfo = Gtk.TextBuffer.IsTextBuffer
    type AttrTransferType TextViewBufferPropertyInfo = Gtk.TextBuffer.TextBuffer
    type AttrGetType TextViewBufferPropertyInfo = Gtk.TextBuffer.TextBuffer
    type AttrLabel TextViewBufferPropertyInfo = "buffer"
    type AttrOrigin TextViewBufferPropertyInfo = TextView
    attrGet = getTextViewBuffer
    attrSet = setTextViewBuffer
    attrTransfer _ v = do
        unsafeCastTo Gtk.TextBuffer.TextBuffer v
    attrConstruct = constructTextViewBuffer
    attrClear = clearTextViewBuffer
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.buffer"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:buffer"
        })
#endif

-- VVV Prop "cursor-visible"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@cursor-visible@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #cursorVisible
-- @
getTextViewCursorVisible :: (MonadIO m, IsTextView o) => o -> m Bool
getTextViewCursorVisible obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "cursor-visible"

-- | Set the value of the “@cursor-visible@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #cursorVisible 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewCursorVisible :: (MonadIO m, IsTextView o) => o -> Bool -> m ()
setTextViewCursorVisible obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "cursor-visible" val

-- | Construct a `GValueConstruct` with valid value for the “@cursor-visible@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewCursorVisible :: (IsTextView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTextViewCursorVisible val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "cursor-visible" val

#if defined(ENABLE_OVERLOADING)
data TextViewCursorVisiblePropertyInfo
instance AttrInfo TextViewCursorVisiblePropertyInfo where
    type AttrAllowedOps TextViewCursorVisiblePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewCursorVisiblePropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewCursorVisiblePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TextViewCursorVisiblePropertyInfo = (~) Bool
    type AttrTransferType TextViewCursorVisiblePropertyInfo = Bool
    type AttrGetType TextViewCursorVisiblePropertyInfo = Bool
    type AttrLabel TextViewCursorVisiblePropertyInfo = "cursor-visible"
    type AttrOrigin TextViewCursorVisiblePropertyInfo = TextView
    attrGet = getTextViewCursorVisible
    attrSet = setTextViewCursorVisible
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewCursorVisible
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.cursorVisible"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:cursorVisible"
        })
#endif

-- VVV Prop "editable"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@editable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #editable
-- @
getTextViewEditable :: (MonadIO m, IsTextView o) => o -> m Bool
getTextViewEditable obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "editable"

-- | Set the value of the “@editable@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #editable 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewEditable :: (MonadIO m, IsTextView o) => o -> Bool -> m ()
setTextViewEditable obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "editable" val

-- | Construct a `GValueConstruct` with valid value for the “@editable@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewEditable :: (IsTextView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTextViewEditable val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "editable" val

#if defined(ENABLE_OVERLOADING)
data TextViewEditablePropertyInfo
instance AttrInfo TextViewEditablePropertyInfo where
    type AttrAllowedOps TextViewEditablePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewEditablePropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewEditablePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TextViewEditablePropertyInfo = (~) Bool
    type AttrTransferType TextViewEditablePropertyInfo = Bool
    type AttrGetType TextViewEditablePropertyInfo = Bool
    type AttrLabel TextViewEditablePropertyInfo = "editable"
    type AttrOrigin TextViewEditablePropertyInfo = TextView
    attrGet = getTextViewEditable
    attrSet = setTextViewEditable
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewEditable
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.editable"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:editable"
        })
#endif

-- VVV Prop "extra-menu"
   -- Type: TInterface (Name {namespace = "Gio", name = "MenuModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just True)

-- | Get the value of the “@extra-menu@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #extraMenu
-- @
getTextViewExtraMenu :: (MonadIO m, IsTextView o) => o -> m Gio.MenuModel.MenuModel
getTextViewExtraMenu obj = MIO.liftIO $ checkUnexpectedNothing "getTextViewExtraMenu" $ B.Properties.getObjectPropertyObject obj "extra-menu" Gio.MenuModel.MenuModel

-- | Set the value of the “@extra-menu@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #extraMenu 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewExtraMenu :: (MonadIO m, IsTextView o, Gio.MenuModel.IsMenuModel a) => o -> a -> m ()
setTextViewExtraMenu obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "extra-menu" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@extra-menu@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewExtraMenu :: (IsTextView o, MIO.MonadIO m, Gio.MenuModel.IsMenuModel a) => a -> m (GValueConstruct o)
constructTextViewExtraMenu val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "extra-menu" (P.Just val)

-- | Set the value of the “@extra-menu@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #extraMenu
-- @
clearTextViewExtraMenu :: (MonadIO m, IsTextView o) => o -> m ()
clearTextViewExtraMenu obj = liftIO $ B.Properties.setObjectPropertyObject obj "extra-menu" (Nothing :: Maybe Gio.MenuModel.MenuModel)

#if defined(ENABLE_OVERLOADING)
data TextViewExtraMenuPropertyInfo
instance AttrInfo TextViewExtraMenuPropertyInfo where
    type AttrAllowedOps TextViewExtraMenuPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TextViewExtraMenuPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewExtraMenuPropertyInfo = Gio.MenuModel.IsMenuModel
    type AttrTransferTypeConstraint TextViewExtraMenuPropertyInfo = Gio.MenuModel.IsMenuModel
    type AttrTransferType TextViewExtraMenuPropertyInfo = Gio.MenuModel.MenuModel
    type AttrGetType TextViewExtraMenuPropertyInfo = Gio.MenuModel.MenuModel
    type AttrLabel TextViewExtraMenuPropertyInfo = "extra-menu"
    type AttrOrigin TextViewExtraMenuPropertyInfo = TextView
    attrGet = getTextViewExtraMenu
    attrSet = setTextViewExtraMenu
    attrTransfer _ v = do
        unsafeCastTo Gio.MenuModel.MenuModel v
    attrConstruct = constructTextViewExtraMenu
    attrClear = clearTextViewExtraMenu
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.extraMenu"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:extraMenu"
        })
#endif

-- VVV Prop "im-module"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@im-module@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #imModule
-- @
getTextViewImModule :: (MonadIO m, IsTextView o) => o -> m (Maybe T.Text)
getTextViewImModule obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "im-module"

-- | Set the value of the “@im-module@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #imModule 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewImModule :: (MonadIO m, IsTextView o) => o -> T.Text -> m ()
setTextViewImModule obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "im-module" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@im-module@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewImModule :: (IsTextView o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructTextViewImModule val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "im-module" (P.Just val)

-- | Set the value of the “@im-module@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #imModule
-- @
clearTextViewImModule :: (MonadIO m, IsTextView o) => o -> m ()
clearTextViewImModule obj = liftIO $ B.Properties.setObjectPropertyString obj "im-module" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data TextViewImModulePropertyInfo
instance AttrInfo TextViewImModulePropertyInfo where
    type AttrAllowedOps TextViewImModulePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint TextViewImModulePropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewImModulePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint TextViewImModulePropertyInfo = (~) T.Text
    type AttrTransferType TextViewImModulePropertyInfo = T.Text
    type AttrGetType TextViewImModulePropertyInfo = (Maybe T.Text)
    type AttrLabel TextViewImModulePropertyInfo = "im-module"
    type AttrOrigin TextViewImModulePropertyInfo = TextView
    attrGet = getTextViewImModule
    attrSet = setTextViewImModule
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewImModule
    attrClear = clearTextViewImModule
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.imModule"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:imModule"
        })
#endif

-- VVV Prop "indent"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@indent@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #indent
-- @
getTextViewIndent :: (MonadIO m, IsTextView o) => o -> m Int32
getTextViewIndent obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "indent"

-- | Set the value of the “@indent@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #indent 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewIndent :: (MonadIO m, IsTextView o) => o -> Int32 -> m ()
setTextViewIndent obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "indent" val

-- | Construct a `GValueConstruct` with valid value for the “@indent@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewIndent :: (IsTextView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructTextViewIndent val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "indent" val

#if defined(ENABLE_OVERLOADING)
data TextViewIndentPropertyInfo
instance AttrInfo TextViewIndentPropertyInfo where
    type AttrAllowedOps TextViewIndentPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewIndentPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewIndentPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint TextViewIndentPropertyInfo = (~) Int32
    type AttrTransferType TextViewIndentPropertyInfo = Int32
    type AttrGetType TextViewIndentPropertyInfo = Int32
    type AttrLabel TextViewIndentPropertyInfo = "indent"
    type AttrOrigin TextViewIndentPropertyInfo = TextView
    attrGet = getTextViewIndent
    attrSet = setTextViewIndent
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewIndent
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.indent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:indent"
        })
#endif

-- VVV Prop "input-hints"
   -- Type: TInterface (Name {namespace = "Gtk", name = "InputHints"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@input-hints@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #inputHints
-- @
getTextViewInputHints :: (MonadIO m, IsTextView o) => o -> m [Gtk.Flags.InputHints]
getTextViewInputHints obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "input-hints"

-- | Set the value of the “@input-hints@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #inputHints 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewInputHints :: (MonadIO m, IsTextView o) => o -> [Gtk.Flags.InputHints] -> m ()
setTextViewInputHints obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "input-hints" val

-- | Construct a `GValueConstruct` with valid value for the “@input-hints@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewInputHints :: (IsTextView o, MIO.MonadIO m) => [Gtk.Flags.InputHints] -> m (GValueConstruct o)
constructTextViewInputHints val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "input-hints" val

#if defined(ENABLE_OVERLOADING)
data TextViewInputHintsPropertyInfo
instance AttrInfo TextViewInputHintsPropertyInfo where
    type AttrAllowedOps TextViewInputHintsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewInputHintsPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewInputHintsPropertyInfo = (~) [Gtk.Flags.InputHints]
    type AttrTransferTypeConstraint TextViewInputHintsPropertyInfo = (~) [Gtk.Flags.InputHints]
    type AttrTransferType TextViewInputHintsPropertyInfo = [Gtk.Flags.InputHints]
    type AttrGetType TextViewInputHintsPropertyInfo = [Gtk.Flags.InputHints]
    type AttrLabel TextViewInputHintsPropertyInfo = "input-hints"
    type AttrOrigin TextViewInputHintsPropertyInfo = TextView
    attrGet = getTextViewInputHints
    attrSet = setTextViewInputHints
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewInputHints
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.inputHints"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:inputHints"
        })
#endif

-- VVV Prop "input-purpose"
   -- Type: TInterface (Name {namespace = "Gtk", name = "InputPurpose"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@input-purpose@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #inputPurpose
-- @
getTextViewInputPurpose :: (MonadIO m, IsTextView o) => o -> m Gtk.Enums.InputPurpose
getTextViewInputPurpose obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "input-purpose"

-- | Set the value of the “@input-purpose@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #inputPurpose 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewInputPurpose :: (MonadIO m, IsTextView o) => o -> Gtk.Enums.InputPurpose -> m ()
setTextViewInputPurpose obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "input-purpose" val

-- | Construct a `GValueConstruct` with valid value for the “@input-purpose@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewInputPurpose :: (IsTextView o, MIO.MonadIO m) => Gtk.Enums.InputPurpose -> m (GValueConstruct o)
constructTextViewInputPurpose val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "input-purpose" val

#if defined(ENABLE_OVERLOADING)
data TextViewInputPurposePropertyInfo
instance AttrInfo TextViewInputPurposePropertyInfo where
    type AttrAllowedOps TextViewInputPurposePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewInputPurposePropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewInputPurposePropertyInfo = (~) Gtk.Enums.InputPurpose
    type AttrTransferTypeConstraint TextViewInputPurposePropertyInfo = (~) Gtk.Enums.InputPurpose
    type AttrTransferType TextViewInputPurposePropertyInfo = Gtk.Enums.InputPurpose
    type AttrGetType TextViewInputPurposePropertyInfo = Gtk.Enums.InputPurpose
    type AttrLabel TextViewInputPurposePropertyInfo = "input-purpose"
    type AttrOrigin TextViewInputPurposePropertyInfo = TextView
    attrGet = getTextViewInputPurpose
    attrSet = setTextViewInputPurpose
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewInputPurpose
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.inputPurpose"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:inputPurpose"
        })
#endif

-- VVV Prop "justification"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Justification"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@justification@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #justification
-- @
getTextViewJustification :: (MonadIO m, IsTextView o) => o -> m Gtk.Enums.Justification
getTextViewJustification obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "justification"

-- | Set the value of the “@justification@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #justification 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewJustification :: (MonadIO m, IsTextView o) => o -> Gtk.Enums.Justification -> m ()
setTextViewJustification obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "justification" val

-- | Construct a `GValueConstruct` with valid value for the “@justification@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewJustification :: (IsTextView o, MIO.MonadIO m) => Gtk.Enums.Justification -> m (GValueConstruct o)
constructTextViewJustification val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "justification" val

#if defined(ENABLE_OVERLOADING)
data TextViewJustificationPropertyInfo
instance AttrInfo TextViewJustificationPropertyInfo where
    type AttrAllowedOps TextViewJustificationPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewJustificationPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewJustificationPropertyInfo = (~) Gtk.Enums.Justification
    type AttrTransferTypeConstraint TextViewJustificationPropertyInfo = (~) Gtk.Enums.Justification
    type AttrTransferType TextViewJustificationPropertyInfo = Gtk.Enums.Justification
    type AttrGetType TextViewJustificationPropertyInfo = Gtk.Enums.Justification
    type AttrLabel TextViewJustificationPropertyInfo = "justification"
    type AttrOrigin TextViewJustificationPropertyInfo = TextView
    attrGet = getTextViewJustification
    attrSet = setTextViewJustification
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewJustification
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.justification"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:justification"
        })
#endif

-- VVV Prop "left-margin"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@left-margin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #leftMargin
-- @
getTextViewLeftMargin :: (MonadIO m, IsTextView o) => o -> m Int32
getTextViewLeftMargin obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "left-margin"

-- | Set the value of the “@left-margin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #leftMargin 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewLeftMargin :: (MonadIO m, IsTextView o) => o -> Int32 -> m ()
setTextViewLeftMargin obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "left-margin" val

-- | Construct a `GValueConstruct` with valid value for the “@left-margin@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewLeftMargin :: (IsTextView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructTextViewLeftMargin val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "left-margin" val

#if defined(ENABLE_OVERLOADING)
data TextViewLeftMarginPropertyInfo
instance AttrInfo TextViewLeftMarginPropertyInfo where
    type AttrAllowedOps TextViewLeftMarginPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewLeftMarginPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewLeftMarginPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint TextViewLeftMarginPropertyInfo = (~) Int32
    type AttrTransferType TextViewLeftMarginPropertyInfo = Int32
    type AttrGetType TextViewLeftMarginPropertyInfo = Int32
    type AttrLabel TextViewLeftMarginPropertyInfo = "left-margin"
    type AttrOrigin TextViewLeftMarginPropertyInfo = TextView
    attrGet = getTextViewLeftMargin
    attrSet = setTextViewLeftMargin
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewLeftMargin
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.leftMargin"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:leftMargin"
        })
#endif

-- VVV Prop "monospace"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@monospace@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #monospace
-- @
getTextViewMonospace :: (MonadIO m, IsTextView o) => o -> m Bool
getTextViewMonospace obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "monospace"

-- | Set the value of the “@monospace@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #monospace 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewMonospace :: (MonadIO m, IsTextView o) => o -> Bool -> m ()
setTextViewMonospace obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "monospace" val

-- | Construct a `GValueConstruct` with valid value for the “@monospace@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewMonospace :: (IsTextView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTextViewMonospace val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "monospace" val

#if defined(ENABLE_OVERLOADING)
data TextViewMonospacePropertyInfo
instance AttrInfo TextViewMonospacePropertyInfo where
    type AttrAllowedOps TextViewMonospacePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewMonospacePropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewMonospacePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TextViewMonospacePropertyInfo = (~) Bool
    type AttrTransferType TextViewMonospacePropertyInfo = Bool
    type AttrGetType TextViewMonospacePropertyInfo = Bool
    type AttrLabel TextViewMonospacePropertyInfo = "monospace"
    type AttrOrigin TextViewMonospacePropertyInfo = TextView
    attrGet = getTextViewMonospace
    attrSet = setTextViewMonospace
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewMonospace
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.monospace"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:monospace"
        })
#endif

-- VVV Prop "overwrite"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@overwrite@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #overwrite
-- @
getTextViewOverwrite :: (MonadIO m, IsTextView o) => o -> m Bool
getTextViewOverwrite obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "overwrite"

-- | Set the value of the “@overwrite@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #overwrite 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewOverwrite :: (MonadIO m, IsTextView o) => o -> Bool -> m ()
setTextViewOverwrite obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "overwrite" val

-- | Construct a `GValueConstruct` with valid value for the “@overwrite@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewOverwrite :: (IsTextView o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructTextViewOverwrite val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "overwrite" val

#if defined(ENABLE_OVERLOADING)
data TextViewOverwritePropertyInfo
instance AttrInfo TextViewOverwritePropertyInfo where
    type AttrAllowedOps TextViewOverwritePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewOverwritePropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewOverwritePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint TextViewOverwritePropertyInfo = (~) Bool
    type AttrTransferType TextViewOverwritePropertyInfo = Bool
    type AttrGetType TextViewOverwritePropertyInfo = Bool
    type AttrLabel TextViewOverwritePropertyInfo = "overwrite"
    type AttrOrigin TextViewOverwritePropertyInfo = TextView
    attrGet = getTextViewOverwrite
    attrSet = setTextViewOverwrite
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewOverwrite
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.overwrite"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:overwrite"
        })
#endif

-- VVV Prop "pixels-above-lines"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@pixels-above-lines@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #pixelsAboveLines
-- @
getTextViewPixelsAboveLines :: (MonadIO m, IsTextView o) => o -> m Int32
getTextViewPixelsAboveLines obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "pixels-above-lines"

-- | Set the value of the “@pixels-above-lines@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #pixelsAboveLines 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewPixelsAboveLines :: (MonadIO m, IsTextView o) => o -> Int32 -> m ()
setTextViewPixelsAboveLines obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "pixels-above-lines" val

-- | Construct a `GValueConstruct` with valid value for the “@pixels-above-lines@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewPixelsAboveLines :: (IsTextView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructTextViewPixelsAboveLines val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "pixels-above-lines" val

#if defined(ENABLE_OVERLOADING)
data TextViewPixelsAboveLinesPropertyInfo
instance AttrInfo TextViewPixelsAboveLinesPropertyInfo where
    type AttrAllowedOps TextViewPixelsAboveLinesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewPixelsAboveLinesPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewPixelsAboveLinesPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint TextViewPixelsAboveLinesPropertyInfo = (~) Int32
    type AttrTransferType TextViewPixelsAboveLinesPropertyInfo = Int32
    type AttrGetType TextViewPixelsAboveLinesPropertyInfo = Int32
    type AttrLabel TextViewPixelsAboveLinesPropertyInfo = "pixels-above-lines"
    type AttrOrigin TextViewPixelsAboveLinesPropertyInfo = TextView
    attrGet = getTextViewPixelsAboveLines
    attrSet = setTextViewPixelsAboveLines
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewPixelsAboveLines
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.pixelsAboveLines"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:pixelsAboveLines"
        })
#endif

-- VVV Prop "pixels-below-lines"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@pixels-below-lines@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #pixelsBelowLines
-- @
getTextViewPixelsBelowLines :: (MonadIO m, IsTextView o) => o -> m Int32
getTextViewPixelsBelowLines obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "pixels-below-lines"

-- | Set the value of the “@pixels-below-lines@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #pixelsBelowLines 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewPixelsBelowLines :: (MonadIO m, IsTextView o) => o -> Int32 -> m ()
setTextViewPixelsBelowLines obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "pixels-below-lines" val

-- | Construct a `GValueConstruct` with valid value for the “@pixels-below-lines@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewPixelsBelowLines :: (IsTextView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructTextViewPixelsBelowLines val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "pixels-below-lines" val

#if defined(ENABLE_OVERLOADING)
data TextViewPixelsBelowLinesPropertyInfo
instance AttrInfo TextViewPixelsBelowLinesPropertyInfo where
    type AttrAllowedOps TextViewPixelsBelowLinesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewPixelsBelowLinesPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewPixelsBelowLinesPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint TextViewPixelsBelowLinesPropertyInfo = (~) Int32
    type AttrTransferType TextViewPixelsBelowLinesPropertyInfo = Int32
    type AttrGetType TextViewPixelsBelowLinesPropertyInfo = Int32
    type AttrLabel TextViewPixelsBelowLinesPropertyInfo = "pixels-below-lines"
    type AttrOrigin TextViewPixelsBelowLinesPropertyInfo = TextView
    attrGet = getTextViewPixelsBelowLines
    attrSet = setTextViewPixelsBelowLines
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewPixelsBelowLines
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.pixelsBelowLines"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:pixelsBelowLines"
        })
#endif

-- VVV Prop "pixels-inside-wrap"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@pixels-inside-wrap@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #pixelsInsideWrap
-- @
getTextViewPixelsInsideWrap :: (MonadIO m, IsTextView o) => o -> m Int32
getTextViewPixelsInsideWrap obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "pixels-inside-wrap"

-- | Set the value of the “@pixels-inside-wrap@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #pixelsInsideWrap 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewPixelsInsideWrap :: (MonadIO m, IsTextView o) => o -> Int32 -> m ()
setTextViewPixelsInsideWrap obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "pixels-inside-wrap" val

-- | Construct a `GValueConstruct` with valid value for the “@pixels-inside-wrap@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewPixelsInsideWrap :: (IsTextView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructTextViewPixelsInsideWrap val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "pixels-inside-wrap" val

#if defined(ENABLE_OVERLOADING)
data TextViewPixelsInsideWrapPropertyInfo
instance AttrInfo TextViewPixelsInsideWrapPropertyInfo where
    type AttrAllowedOps TextViewPixelsInsideWrapPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewPixelsInsideWrapPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewPixelsInsideWrapPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint TextViewPixelsInsideWrapPropertyInfo = (~) Int32
    type AttrTransferType TextViewPixelsInsideWrapPropertyInfo = Int32
    type AttrGetType TextViewPixelsInsideWrapPropertyInfo = Int32
    type AttrLabel TextViewPixelsInsideWrapPropertyInfo = "pixels-inside-wrap"
    type AttrOrigin TextViewPixelsInsideWrapPropertyInfo = TextView
    attrGet = getTextViewPixelsInsideWrap
    attrSet = setTextViewPixelsInsideWrap
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewPixelsInsideWrap
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.pixelsInsideWrap"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:pixelsInsideWrap"
        })
#endif

-- VVV Prop "right-margin"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@right-margin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #rightMargin
-- @
getTextViewRightMargin :: (MonadIO m, IsTextView o) => o -> m Int32
getTextViewRightMargin obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "right-margin"

-- | Set the value of the “@right-margin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #rightMargin 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewRightMargin :: (MonadIO m, IsTextView o) => o -> Int32 -> m ()
setTextViewRightMargin obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "right-margin" val

-- | Construct a `GValueConstruct` with valid value for the “@right-margin@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewRightMargin :: (IsTextView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructTextViewRightMargin val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "right-margin" val

#if defined(ENABLE_OVERLOADING)
data TextViewRightMarginPropertyInfo
instance AttrInfo TextViewRightMarginPropertyInfo where
    type AttrAllowedOps TextViewRightMarginPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewRightMarginPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewRightMarginPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint TextViewRightMarginPropertyInfo = (~) Int32
    type AttrTransferType TextViewRightMarginPropertyInfo = Int32
    type AttrGetType TextViewRightMarginPropertyInfo = Int32
    type AttrLabel TextViewRightMarginPropertyInfo = "right-margin"
    type AttrOrigin TextViewRightMarginPropertyInfo = TextView
    attrGet = getTextViewRightMargin
    attrSet = setTextViewRightMargin
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewRightMargin
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.rightMargin"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:rightMargin"
        })
#endif

-- VVV Prop "tabs"
   -- Type: TInterface (Name {namespace = "Pango", name = "TabArray"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@tabs@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #tabs
-- @
getTextViewTabs :: (MonadIO m, IsTextView o) => o -> m (Maybe Pango.TabArray.TabArray)
getTextViewTabs obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "tabs" Pango.TabArray.TabArray

-- | Set the value of the “@tabs@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #tabs 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewTabs :: (MonadIO m, IsTextView o) => o -> Pango.TabArray.TabArray -> m ()
setTextViewTabs obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "tabs" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@tabs@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewTabs :: (IsTextView o, MIO.MonadIO m) => Pango.TabArray.TabArray -> m (GValueConstruct o)
constructTextViewTabs val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "tabs" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data TextViewTabsPropertyInfo
instance AttrInfo TextViewTabsPropertyInfo where
    type AttrAllowedOps TextViewTabsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewTabsPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewTabsPropertyInfo = (~) Pango.TabArray.TabArray
    type AttrTransferTypeConstraint TextViewTabsPropertyInfo = (~) Pango.TabArray.TabArray
    type AttrTransferType TextViewTabsPropertyInfo = Pango.TabArray.TabArray
    type AttrGetType TextViewTabsPropertyInfo = (Maybe Pango.TabArray.TabArray)
    type AttrLabel TextViewTabsPropertyInfo = "tabs"
    type AttrOrigin TextViewTabsPropertyInfo = TextView
    attrGet = getTextViewTabs
    attrSet = setTextViewTabs
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewTabs
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.tabs"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:tabs"
        })
#endif

-- VVV Prop "top-margin"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@top-margin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #topMargin
-- @
getTextViewTopMargin :: (MonadIO m, IsTextView o) => o -> m Int32
getTextViewTopMargin obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "top-margin"

-- | Set the value of the “@top-margin@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #topMargin 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewTopMargin :: (MonadIO m, IsTextView o) => o -> Int32 -> m ()
setTextViewTopMargin obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "top-margin" val

-- | Construct a `GValueConstruct` with valid value for the “@top-margin@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewTopMargin :: (IsTextView o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructTextViewTopMargin val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "top-margin" val

#if defined(ENABLE_OVERLOADING)
data TextViewTopMarginPropertyInfo
instance AttrInfo TextViewTopMarginPropertyInfo where
    type AttrAllowedOps TextViewTopMarginPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewTopMarginPropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewTopMarginPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint TextViewTopMarginPropertyInfo = (~) Int32
    type AttrTransferType TextViewTopMarginPropertyInfo = Int32
    type AttrGetType TextViewTopMarginPropertyInfo = Int32
    type AttrLabel TextViewTopMarginPropertyInfo = "top-margin"
    type AttrOrigin TextViewTopMarginPropertyInfo = TextView
    attrGet = getTextViewTopMargin
    attrSet = setTextViewTopMargin
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewTopMargin
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.topMargin"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:topMargin"
        })
#endif

-- VVV Prop "wrap-mode"
   -- Type: TInterface (Name {namespace = "Gtk", name = "WrapMode"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@wrap-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' textView #wrapMode
-- @
getTextViewWrapMode :: (MonadIO m, IsTextView o) => o -> m Gtk.Enums.WrapMode
getTextViewWrapMode obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "wrap-mode"

-- | Set the value of the “@wrap-mode@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' textView [ #wrapMode 'Data.GI.Base.Attributes.:=' value ]
-- @
setTextViewWrapMode :: (MonadIO m, IsTextView o) => o -> Gtk.Enums.WrapMode -> m ()
setTextViewWrapMode obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "wrap-mode" val

-- | Construct a `GValueConstruct` with valid value for the “@wrap-mode@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructTextViewWrapMode :: (IsTextView o, MIO.MonadIO m) => Gtk.Enums.WrapMode -> m (GValueConstruct o)
constructTextViewWrapMode val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "wrap-mode" val

#if defined(ENABLE_OVERLOADING)
data TextViewWrapModePropertyInfo
instance AttrInfo TextViewWrapModePropertyInfo where
    type AttrAllowedOps TextViewWrapModePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint TextViewWrapModePropertyInfo = IsTextView
    type AttrSetTypeConstraint TextViewWrapModePropertyInfo = (~) Gtk.Enums.WrapMode
    type AttrTransferTypeConstraint TextViewWrapModePropertyInfo = (~) Gtk.Enums.WrapMode
    type AttrTransferType TextViewWrapModePropertyInfo = Gtk.Enums.WrapMode
    type AttrGetType TextViewWrapModePropertyInfo = Gtk.Enums.WrapMode
    type AttrLabel TextViewWrapModePropertyInfo = "wrap-mode"
    type AttrOrigin TextViewWrapModePropertyInfo = TextView
    attrGet = getTextViewWrapMode
    attrSet = setTextViewWrapMode
    attrTransfer _ v = do
        return v
    attrConstruct = constructTextViewWrapMode
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.wrapMode"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#g:attr:wrapMode"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList TextView
type instance O.AttributeList TextView = TextViewAttributeList
type TextViewAttributeList = ('[ '("acceptsTab", TextViewAcceptsTabPropertyInfo), '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("bottomMargin", TextViewBottomMarginPropertyInfo), '("buffer", TextViewBufferPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("cursorVisible", TextViewCursorVisiblePropertyInfo), '("editable", TextViewEditablePropertyInfo), '("extraMenu", TextViewExtraMenuPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("hadjustment", Gtk.Scrollable.ScrollableHadjustmentPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hscrollPolicy", Gtk.Scrollable.ScrollableHscrollPolicyPropertyInfo), '("imModule", TextViewImModulePropertyInfo), '("indent", TextViewIndentPropertyInfo), '("inputHints", TextViewInputHintsPropertyInfo), '("inputPurpose", TextViewInputPurposePropertyInfo), '("justification", TextViewJustificationPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("leftMargin", TextViewLeftMarginPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("monospace", TextViewMonospacePropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("overwrite", TextViewOverwritePropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("pixelsAboveLines", TextViewPixelsAboveLinesPropertyInfo), '("pixelsBelowLines", TextViewPixelsBelowLinesPropertyInfo), '("pixelsInsideWrap", TextViewPixelsInsideWrapPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("rightMargin", TextViewRightMarginPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tabs", TextViewTabsPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("topMargin", TextViewTopMarginPropertyInfo), '("vadjustment", Gtk.Scrollable.ScrollableVadjustmentPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("vscrollPolicy", Gtk.Scrollable.ScrollableVscrollPolicyPropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo), '("wrapMode", TextViewWrapModePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
textViewAcceptsTab :: AttrLabelProxy "acceptsTab"
textViewAcceptsTab = AttrLabelProxy

textViewBottomMargin :: AttrLabelProxy "bottomMargin"
textViewBottomMargin = AttrLabelProxy

textViewBuffer :: AttrLabelProxy "buffer"
textViewBuffer = AttrLabelProxy

textViewCursorVisible :: AttrLabelProxy "cursorVisible"
textViewCursorVisible = AttrLabelProxy

textViewEditable :: AttrLabelProxy "editable"
textViewEditable = AttrLabelProxy

textViewExtraMenu :: AttrLabelProxy "extraMenu"
textViewExtraMenu = AttrLabelProxy

textViewImModule :: AttrLabelProxy "imModule"
textViewImModule = AttrLabelProxy

textViewIndent :: AttrLabelProxy "indent"
textViewIndent = AttrLabelProxy

textViewInputHints :: AttrLabelProxy "inputHints"
textViewInputHints = AttrLabelProxy

textViewInputPurpose :: AttrLabelProxy "inputPurpose"
textViewInputPurpose = AttrLabelProxy

textViewJustification :: AttrLabelProxy "justification"
textViewJustification = AttrLabelProxy

textViewLeftMargin :: AttrLabelProxy "leftMargin"
textViewLeftMargin = AttrLabelProxy

textViewMonospace :: AttrLabelProxy "monospace"
textViewMonospace = AttrLabelProxy

textViewOverwrite :: AttrLabelProxy "overwrite"
textViewOverwrite = AttrLabelProxy

textViewPixelsAboveLines :: AttrLabelProxy "pixelsAboveLines"
textViewPixelsAboveLines = AttrLabelProxy

textViewPixelsBelowLines :: AttrLabelProxy "pixelsBelowLines"
textViewPixelsBelowLines = AttrLabelProxy

textViewPixelsInsideWrap :: AttrLabelProxy "pixelsInsideWrap"
textViewPixelsInsideWrap = AttrLabelProxy

textViewRightMargin :: AttrLabelProxy "rightMargin"
textViewRightMargin = AttrLabelProxy

textViewTabs :: AttrLabelProxy "tabs"
textViewTabs = AttrLabelProxy

textViewTopMargin :: AttrLabelProxy "topMargin"
textViewTopMargin = AttrLabelProxy

textViewWrapMode :: AttrLabelProxy "wrapMode"
textViewWrapMode = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList TextView = TextViewSignalList
type TextViewSignalList = ('[ '("backspace", TextViewBackspaceSignalInfo), '("copyClipboard", TextViewCopyClipboardSignalInfo), '("cutClipboard", TextViewCutClipboardSignalInfo), '("deleteFromCursor", TextViewDeleteFromCursorSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("extendSelection", TextViewExtendSelectionSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("insertAtCursor", TextViewInsertAtCursorSignalInfo), '("insertEmoji", TextViewInsertEmojiSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveCursor", TextViewMoveCursorSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("moveViewport", TextViewMoveViewportSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("pasteClipboard", TextViewPasteClipboardSignalInfo), '("preeditChanged", TextViewPreeditChangedSignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("selectAll", TextViewSelectAllSignalInfo), '("setAnchor", TextViewSetAnchorSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("toggleCursorVisible", TextViewToggleCursorVisibleSignalInfo), '("toggleOverwrite", TextViewToggleOverwriteSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method TextView::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TextView" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_new" gtk_text_view_new :: 
    IO (Ptr TextView)

-- | Creates a new @GtkTextView@.
-- 
-- If you don’t call 'GI.Gtk.Objects.TextView.textViewSetBuffer' before using the
-- text view, an empty default buffer will be created for you. Get the
-- buffer with 'GI.Gtk.Objects.TextView.textViewGetBuffer'. If you want to specify
-- your own buffer, consider 'GI.Gtk.Objects.TextView.textViewNewWithBuffer'.
textViewNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m TextView
    -- ^ __Returns:__ a new @GtkTextView@
textViewNew  = liftIO $ do
    result <- gtk_text_view_new
    checkUnexpectedReturnNULL "textViewNew" result
    result' <- (newObject TextView) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TextView::new_with_buffer
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TextView" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_new_with_buffer" gtk_text_view_new_with_buffer :: 
    Ptr Gtk.TextBuffer.TextBuffer ->        -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO (Ptr TextView)

-- | Creates a new @GtkTextView@ widget displaying the buffer /@buffer@/.
-- 
-- One buffer can be shared among many widgets. /@buffer@/ may be 'P.Nothing'
-- to create a default buffer, in which case this function is equivalent
-- to 'GI.Gtk.Objects.TextView.textViewNew'. The text view adds its own reference count
-- to the buffer; it does not take over an existing reference.
textViewNewWithBuffer ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.TextBuffer.IsTextBuffer a) =>
    a
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m TextView
    -- ^ __Returns:__ a new @GtkTextView@.
textViewNewWithBuffer buffer = liftIO $ do
    buffer' <- unsafeManagedPtrCastPtr buffer
    result <- gtk_text_view_new_with_buffer buffer'
    checkUnexpectedReturnNULL "textViewNewWithBuffer" result
    result' <- (newObject TextView) result
    touchManagedPtr buffer
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method TextView::add_child_at_anchor
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "anchor"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextChildAnchor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GtkTextChildAnchor` in the `GtkTextBuffer` for @text_view"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_add_child_at_anchor" gtk_text_view_add_child_at_anchor :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.TextChildAnchor.TextChildAnchor -> -- anchor : TInterface (Name {namespace = "Gtk", name = "TextChildAnchor"})
    IO ()

-- | Adds a child widget in the text buffer, at the given /@anchor@/.
textViewAddChildAtAnchor ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a, Gtk.Widget.IsWidget b, Gtk.TextChildAnchor.IsTextChildAnchor c) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> b
    -- ^ /@child@/: a @GtkWidget@
    -> c
    -- ^ /@anchor@/: a @GtkTextChildAnchor@ in the @GtkTextBuffer@ for /@textView@/
    -> m ()
textViewAddChildAtAnchor textView child anchor = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    child' <- unsafeManagedPtrCastPtr child
    anchor' <- unsafeManagedPtrCastPtr anchor
    gtk_text_view_add_child_at_anchor textView' child' anchor'
    touchManagedPtr textView
    touchManagedPtr child
    touchManagedPtr anchor
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewAddChildAtAnchorMethodInfo
instance (signature ~ (b -> c -> m ()), MonadIO m, IsTextView a, Gtk.Widget.IsWidget b, Gtk.TextChildAnchor.IsTextChildAnchor c) => O.OverloadedMethod TextViewAddChildAtAnchorMethodInfo a signature where
    overloadedMethod = textViewAddChildAtAnchor

instance O.OverloadedMethodInfo TextViewAddChildAtAnchorMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewAddChildAtAnchor",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewAddChildAtAnchor"
        })


#endif

-- method TextView::add_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xpos"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "X position of child in window coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ypos"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Y position of child in window coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_add_overlay" gtk_text_view_add_overlay :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Int32 ->                                -- xpos : TBasicType TInt
    Int32 ->                                -- ypos : TBasicType TInt
    IO ()

-- | Adds /@child@/ at a fixed coordinate in the @GtkTextView@\'s text window.
-- 
-- The /@xpos@/ and /@ypos@/ must be in buffer coordinates (see
-- 'GI.Gtk.Objects.TextView.textViewGetIterLocation' to convert to
-- buffer coordinates).
-- 
-- /@child@/ will scroll with the text view.
-- 
-- If instead you want a widget that will not move with the
-- @GtkTextView@ contents see @GtkOverlay@.
textViewAddOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> b
    -- ^ /@child@/: a @GtkWidget@
    -> Int32
    -- ^ /@xpos@/: X position of child in window coordinates
    -> Int32
    -- ^ /@ypos@/: Y position of child in window coordinates
    -> m ()
textViewAddOverlay textView child xpos ypos = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    child' <- unsafeManagedPtrCastPtr child
    gtk_text_view_add_overlay textView' child' xpos ypos
    touchManagedPtr textView
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewAddOverlayMethodInfo
instance (signature ~ (b -> Int32 -> Int32 -> m ()), MonadIO m, IsTextView a, Gtk.Widget.IsWidget b) => O.OverloadedMethod TextViewAddOverlayMethodInfo a signature where
    overloadedMethod = textViewAddOverlay

instance O.OverloadedMethodInfo TextViewAddOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewAddOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewAddOverlay"
        })


#endif

-- method TextView::backward_display_line
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_backward_display_line" gtk_text_view_backward_display_line :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO CInt

-- | Moves the given /@iter@/ backward by one display (wrapped) line.
-- 
-- A display line is different from a paragraph. Paragraphs are
-- separated by newlines or other paragraph separator characters.
-- Display lines are created by line-wrapping a paragraph. If
-- wrapping is turned off, display lines and paragraphs will be the
-- same. Display lines are divided differently for each view, since
-- they depend on the view’s width; paragraphs are the same in all
-- views, since they depend on the contents of the @GtkTextBuffer@.
textViewBackwardDisplayLine ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a @GtkTextIter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@iter@/ was moved and is not on the end iterator
textViewBackwardDisplayLine textView iter = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    iter' <- unsafeManagedPtrGetPtr iter
    result <- gtk_text_view_backward_display_line textView' iter'
    let result' = (/= 0) result
    touchManagedPtr textView
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewBackwardDisplayLineMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewBackwardDisplayLineMethodInfo a signature where
    overloadedMethod = textViewBackwardDisplayLine

instance O.OverloadedMethodInfo TextViewBackwardDisplayLineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewBackwardDisplayLine",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewBackwardDisplayLine"
        })


#endif

-- method TextView::backward_display_line_start
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_backward_display_line_start" gtk_text_view_backward_display_line_start :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO CInt

-- | Moves the given /@iter@/ backward to the next display line start.
-- 
-- A display line is different from a paragraph. Paragraphs are
-- separated by newlines or other paragraph separator characters.
-- Display lines are created by line-wrapping a paragraph. If
-- wrapping is turned off, display lines and paragraphs will be the
-- same. Display lines are divided differently for each view, since
-- they depend on the view’s width; paragraphs are the same in all
-- views, since they depend on the contents of the @GtkTextBuffer@.
textViewBackwardDisplayLineStart ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a @GtkTextIter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@iter@/ was moved and is not on the end iterator
textViewBackwardDisplayLineStart textView iter = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    iter' <- unsafeManagedPtrGetPtr iter
    result <- gtk_text_view_backward_display_line_start textView' iter'
    let result' = (/= 0) result
    touchManagedPtr textView
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewBackwardDisplayLineStartMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewBackwardDisplayLineStartMethodInfo a signature where
    overloadedMethod = textViewBackwardDisplayLineStart

instance O.OverloadedMethodInfo TextViewBackwardDisplayLineStartMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewBackwardDisplayLineStart",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewBackwardDisplayLineStart"
        })


#endif

-- method TextView::buffer_to_window_coords
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "win"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextWindowType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextWindowType`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "buffer x coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "buffer y coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window_x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "window x coordinate return location"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "window_y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "window y coordinate return location"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_buffer_to_window_coords" gtk_text_view_buffer_to_window_coords :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CUInt ->                                -- win : TInterface (Name {namespace = "Gtk", name = "TextWindowType"})
    Int32 ->                                -- buffer_x : TBasicType TInt
    Int32 ->                                -- buffer_y : TBasicType TInt
    Ptr Int32 ->                            -- window_x : TBasicType TInt
    Ptr Int32 ->                            -- window_y : TBasicType TInt
    IO ()

-- | Converts buffer coordinates to window coordinates.
textViewBufferToWindowCoords ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.Enums.TextWindowType
    -- ^ /@win@/: a @GtkTextWindowType@
    -> Int32
    -- ^ /@bufferX@/: buffer x coordinate
    -> Int32
    -- ^ /@bufferY@/: buffer y coordinate
    -> m ((Int32, Int32))
textViewBufferToWindowCoords textView win bufferX bufferY = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let win' = (fromIntegral . fromEnum) win
    windowX <- allocMem :: IO (Ptr Int32)
    windowY <- allocMem :: IO (Ptr Int32)
    gtk_text_view_buffer_to_window_coords textView' win' bufferX bufferY windowX windowY
    windowX' <- peek windowX
    windowY' <- peek windowY
    touchManagedPtr textView
    freeMem windowX
    freeMem windowY
    return (windowX', windowY')

#if defined(ENABLE_OVERLOADING)
data TextViewBufferToWindowCoordsMethodInfo
instance (signature ~ (Gtk.Enums.TextWindowType -> Int32 -> Int32 -> m ((Int32, Int32))), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewBufferToWindowCoordsMethodInfo a signature where
    overloadedMethod = textViewBufferToWindowCoords

instance O.OverloadedMethodInfo TextViewBufferToWindowCoordsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewBufferToWindowCoords",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewBufferToWindowCoords"
        })


#endif

-- method TextView::forward_display_line
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_forward_display_line" gtk_text_view_forward_display_line :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO CInt

-- | Moves the given /@iter@/ forward by one display (wrapped) line.
-- 
-- A display line is different from a paragraph. Paragraphs are
-- separated by newlines or other paragraph separator characters.
-- Display lines are created by line-wrapping a paragraph. If
-- wrapping is turned off, display lines and paragraphs will be the
-- same. Display lines are divided differently for each view, since
-- they depend on the view’s width; paragraphs are the same in all
-- views, since they depend on the contents of the @GtkTextBuffer@.
textViewForwardDisplayLine ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a @GtkTextIter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@iter@/ was moved and is not on the end iterator
textViewForwardDisplayLine textView iter = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    iter' <- unsafeManagedPtrGetPtr iter
    result <- gtk_text_view_forward_display_line textView' iter'
    let result' = (/= 0) result
    touchManagedPtr textView
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewForwardDisplayLineMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewForwardDisplayLineMethodInfo a signature where
    overloadedMethod = textViewForwardDisplayLine

instance O.OverloadedMethodInfo TextViewForwardDisplayLineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewForwardDisplayLine",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewForwardDisplayLine"
        })


#endif

-- method TextView::forward_display_line_end
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_forward_display_line_end" gtk_text_view_forward_display_line_end :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO CInt

-- | Moves the given /@iter@/ forward to the next display line end.
-- 
-- A display line is different from a paragraph. Paragraphs are
-- separated by newlines or other paragraph separator characters.
-- Display lines are created by line-wrapping a paragraph. If
-- wrapping is turned off, display lines and paragraphs will be the
-- same. Display lines are divided differently for each view, since
-- they depend on the view’s width; paragraphs are the same in all
-- views, since they depend on the contents of the @GtkTextBuffer@.
textViewForwardDisplayLineEnd ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a @GtkTextIter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@iter@/ was moved and is not on the end iterator
textViewForwardDisplayLineEnd textView iter = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    iter' <- unsafeManagedPtrGetPtr iter
    result <- gtk_text_view_forward_display_line_end textView' iter'
    let result' = (/= 0) result
    touchManagedPtr textView
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewForwardDisplayLineEndMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewForwardDisplayLineEndMethodInfo a signature where
    overloadedMethod = textViewForwardDisplayLineEnd

instance O.OverloadedMethodInfo TextViewForwardDisplayLineEndMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewForwardDisplayLineEnd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewForwardDisplayLineEnd"
        })


#endif

-- method TextView::get_accepts_tab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_accepts_tab" gtk_text_view_get_accepts_tab :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO CInt

-- | Returns whether pressing the \<kbd>Tab\<\/kbd> key inserts a tab characters.
-- 
-- See 'GI.Gtk.Objects.TextView.textViewSetAcceptsTab'.
textViewGetAcceptsTab ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: A @GtkTextView@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if pressing the Tab key inserts a tab character,
    --   'P.False' if pressing the Tab key moves the keyboard focus.
textViewGetAcceptsTab textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_accepts_tab textView'
    let result' = (/= 0) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetAcceptsTabMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetAcceptsTabMethodInfo a signature where
    overloadedMethod = textViewGetAcceptsTab

instance O.OverloadedMethodInfo TextViewGetAcceptsTabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetAcceptsTab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetAcceptsTab"
        })


#endif

-- method TextView::get_bottom_margin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_bottom_margin" gtk_text_view_get_bottom_margin :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO Int32

-- | Gets the bottom margin for text in the /@textView@/.
textViewGetBottomMargin ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Int32
    -- ^ __Returns:__ bottom margin in pixels
textViewGetBottomMargin textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_bottom_margin textView'
    touchManagedPtr textView
    return result

#if defined(ENABLE_OVERLOADING)
data TextViewGetBottomMarginMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetBottomMarginMethodInfo a signature where
    overloadedMethod = textViewGetBottomMargin

instance O.OverloadedMethodInfo TextViewGetBottomMarginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetBottomMargin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetBottomMargin"
        })


#endif

-- method TextView::get_buffer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "TextBuffer" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_buffer" gtk_text_view_get_buffer :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO (Ptr Gtk.TextBuffer.TextBuffer)

-- | Returns the @GtkTextBuffer@ being displayed by this text view.
-- 
-- The reference count on the buffer is not incremented; the caller
-- of this function won’t own a new reference.
textViewGetBuffer ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Gtk.TextBuffer.TextBuffer
    -- ^ __Returns:__ a @GtkTextBuffer@
textViewGetBuffer textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_buffer textView'
    checkUnexpectedReturnNULL "textViewGetBuffer" result
    result' <- (newObject Gtk.TextBuffer.TextBuffer) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetBufferMethodInfo
instance (signature ~ (m Gtk.TextBuffer.TextBuffer), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetBufferMethodInfo a signature where
    overloadedMethod = textViewGetBuffer

instance O.OverloadedMethodInfo TextViewGetBufferMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetBuffer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetBuffer"
        })


#endif

-- method TextView::get_cursor_locations
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "strong"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the strong cursor position"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "weak"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the weak cursor position"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_cursor_locations" gtk_text_view_get_cursor_locations :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gdk.Rectangle.Rectangle ->          -- strong : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    Ptr Gdk.Rectangle.Rectangle ->          -- weak : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | Determine the positions of the strong and weak cursors if the
-- insertion point is at /@iter@/.
-- 
-- The position of each cursor is stored as a zero-width rectangle.
-- The strong cursor location is the location where characters of
-- the directionality equal to the base direction of the paragraph
-- are inserted. The weak cursor location is the location where
-- characters of the directionality opposite to the base direction
-- of the paragraph are inserted.
-- 
-- If /@iter@/ is 'P.Nothing', the actual cursor position is used.
-- 
-- Note that if /@iter@/ happens to be the actual cursor position, and
-- there is currently an IM preedit sequence being entered, the
-- returned locations will be adjusted to account for the preedit
-- cursor’s offset within the preedit sequence.
-- 
-- The rectangle position is in buffer coordinates; use
-- 'GI.Gtk.Objects.TextView.textViewBufferToWindowCoords' to convert these
-- coordinates to coordinates for one of the windows in the text view.
textViewGetCursorLocations ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Maybe (Gtk.TextIter.TextIter)
    -- ^ /@iter@/: a @GtkTextIter@
    -> m ((Gdk.Rectangle.Rectangle, Gdk.Rectangle.Rectangle))
textViewGetCursorLocations textView iter = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    maybeIter <- case iter of
        Nothing -> return FP.nullPtr
        Just jIter -> do
            jIter' <- unsafeManagedPtrGetPtr jIter
            return jIter'
    strong <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    weak <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    gtk_text_view_get_cursor_locations textView' maybeIter strong weak
    strong' <- (wrapBoxed Gdk.Rectangle.Rectangle) strong
    weak' <- (wrapBoxed Gdk.Rectangle.Rectangle) weak
    touchManagedPtr textView
    whenJust iter touchManagedPtr
    return (strong', weak')

#if defined(ENABLE_OVERLOADING)
data TextViewGetCursorLocationsMethodInfo
instance (signature ~ (Maybe (Gtk.TextIter.TextIter) -> m ((Gdk.Rectangle.Rectangle, Gdk.Rectangle.Rectangle))), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetCursorLocationsMethodInfo a signature where
    overloadedMethod = textViewGetCursorLocations

instance O.OverloadedMethodInfo TextViewGetCursorLocationsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetCursorLocations",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetCursorLocations"
        })


#endif

-- method TextView::get_cursor_visible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_cursor_visible" gtk_text_view_get_cursor_visible :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO CInt

-- | Find out whether the cursor should be displayed.
textViewGetCursorVisible ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Bool
    -- ^ __Returns:__ whether the insertion mark is visible
textViewGetCursorVisible textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_cursor_visible textView'
    let result' = (/= 0) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetCursorVisibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetCursorVisibleMethodInfo a signature where
    overloadedMethod = textViewGetCursorVisible

instance O.OverloadedMethodInfo TextViewGetCursorVisibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetCursorVisible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetCursorVisible"
        })


#endif

-- method TextView::get_editable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_editable" gtk_text_view_get_editable :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO CInt

-- | Returns the default editability of the @GtkTextView@.
-- 
-- Tags in the buffer may override this setting for some ranges of text.
textViewGetEditable ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Bool
    -- ^ __Returns:__ whether text is editable by default
textViewGetEditable textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_editable textView'
    let result' = (/= 0) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetEditableMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetEditableMethodInfo a signature where
    overloadedMethod = textViewGetEditable

instance O.OverloadedMethodInfo TextViewGetEditableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetEditable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetEditable"
        })


#endif

-- method TextView::get_extra_menu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "MenuModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_extra_menu" gtk_text_view_get_extra_menu :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO (Ptr Gio.MenuModel.MenuModel)

-- | Gets the menu model that gets added to the context menu
-- or 'P.Nothing' if none has been set.
textViewGetExtraMenu ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Gio.MenuModel.MenuModel
    -- ^ __Returns:__ the menu model
textViewGetExtraMenu textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_extra_menu textView'
    checkUnexpectedReturnNULL "textViewGetExtraMenu" result
    result' <- (newObject Gio.MenuModel.MenuModel) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetExtraMenuMethodInfo
instance (signature ~ (m Gio.MenuModel.MenuModel), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetExtraMenuMethodInfo a signature where
    overloadedMethod = textViewGetExtraMenu

instance O.OverloadedMethodInfo TextViewGetExtraMenuMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetExtraMenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetExtraMenu"
        })


#endif

-- method TextView::get_gutter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "win"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextWindowType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextWindowType`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_gutter" gtk_text_view_get_gutter :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CUInt ->                                -- win : TInterface (Name {namespace = "Gtk", name = "TextWindowType"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets a @GtkWidget@ that has previously been set as gutter.
-- 
-- See 'GI.Gtk.Objects.TextView.textViewSetGutter'.
-- 
-- /@win@/ must be one of 'GI.Gtk.Enums.TextWindowTypeLeft', 'GI.Gtk.Enums.TextWindowTypeRight',
-- 'GI.Gtk.Enums.TextWindowTypeTop', or 'GI.Gtk.Enums.TextWindowTypeBottom'.
textViewGetGutter ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.Enums.TextWindowType
    -- ^ /@win@/: a @GtkTextWindowType@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ a @GtkWidget@
textViewGetGutter textView win = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let win' = (fromIntegral . fromEnum) win
    result <- gtk_text_view_get_gutter textView' win'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr textView
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TextViewGetGutterMethodInfo
instance (signature ~ (Gtk.Enums.TextWindowType -> m (Maybe Gtk.Widget.Widget)), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetGutterMethodInfo a signature where
    overloadedMethod = textViewGetGutter

instance O.OverloadedMethodInfo TextViewGetGutterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetGutter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetGutter"
        })


#endif

-- method TextView::get_indent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_indent" gtk_text_view_get_indent :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO Int32

-- | Gets the default indentation of paragraphs in /@textView@/.
-- 
-- Tags in the view’s buffer may override the default.
-- The indentation may be negative.
textViewGetIndent ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Int32
    -- ^ __Returns:__ number of pixels of indentation
textViewGetIndent textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_indent textView'
    touchManagedPtr textView
    return result

#if defined(ENABLE_OVERLOADING)
data TextViewGetIndentMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetIndentMethodInfo a signature where
    overloadedMethod = textViewGetIndent

instance O.OverloadedMethodInfo TextViewGetIndentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetIndent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetIndent"
        })


#endif

-- method TextView::get_input_hints
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "InputHints" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_input_hints" gtk_text_view_get_input_hints :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO CUInt

-- | Gets the @input-hints@ of the @GtkTextView@.
textViewGetInputHints ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m [Gtk.Flags.InputHints]
    -- ^ __Returns:__ the input hints
textViewGetInputHints textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_input_hints textView'
    let result' = wordToGFlags result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetInputHintsMethodInfo
instance (signature ~ (m [Gtk.Flags.InputHints]), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetInputHintsMethodInfo a signature where
    overloadedMethod = textViewGetInputHints

instance O.OverloadedMethodInfo TextViewGetInputHintsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetInputHints",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetInputHints"
        })


#endif

-- method TextView::get_input_purpose
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "InputPurpose" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_input_purpose" gtk_text_view_get_input_purpose :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO CUInt

-- | Gets the @input-purpose@ of the @GtkTextView@.
textViewGetInputPurpose ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Gtk.Enums.InputPurpose
    -- ^ __Returns:__ the input purpose
textViewGetInputPurpose textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_input_purpose textView'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetInputPurposeMethodInfo
instance (signature ~ (m Gtk.Enums.InputPurpose), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetInputPurposeMethodInfo a signature where
    overloadedMethod = textViewGetInputPurpose

instance O.OverloadedMethodInfo TextViewGetInputPurposeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetInputPurpose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetInputPurpose"
        })


#endif

-- method TextView::get_iter_at_location
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "x position, in buffer coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "y position, in buffer coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_iter_at_location" gtk_text_view_get_iter_at_location :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    IO CInt

-- | Retrieves the iterator at buffer coordinates /@x@/ and /@y@/.
-- 
-- Buffer coordinates are coordinates for the entire buffer, not just
-- the currently-displayed portion. If you have coordinates from an
-- event, you have to convert those to buffer coordinates with
-- 'GI.Gtk.Objects.TextView.textViewWindowToBufferCoords'.
textViewGetIterAtLocation ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Int32
    -- ^ /@x@/: x position, in buffer coordinates
    -> Int32
    -- ^ /@y@/: y position, in buffer coordinates
    -> m ((Bool, Gtk.TextIter.TextIter))
    -- ^ __Returns:__ 'P.True' if the position is over text
textViewGetIterAtLocation textView x y = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    iter <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    result <- gtk_text_view_get_iter_at_location textView' iter x y
    let result' = (/= 0) result
    iter' <- (wrapBoxed Gtk.TextIter.TextIter) iter
    touchManagedPtr textView
    return (result', iter')

#if defined(ENABLE_OVERLOADING)
data TextViewGetIterAtLocationMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ((Bool, Gtk.TextIter.TextIter))), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetIterAtLocationMethodInfo a signature where
    overloadedMethod = textViewGetIterAtLocation

instance O.OverloadedMethodInfo TextViewGetIterAtLocationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetIterAtLocation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetIterAtLocation"
        })


#endif

-- method TextView::get_iter_at_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "trailing"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "if non-%NULL, location to store\n   an integer indicating where in the grapheme the user clicked.\n   It will either be zero, or the number of characters in the grapheme.\n   0 represents the trailing edge of the grapheme."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "x position, in buffer coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "y position, in buffer coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_iter_at_position" gtk_text_view_get_iter_at_position :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Int32 ->                            -- trailing : TBasicType TInt
    Int32 ->                                -- x : TBasicType TInt
    Int32 ->                                -- y : TBasicType TInt
    IO CInt

-- | Retrieves the iterator pointing to the character at buffer
-- coordinates /@x@/ and /@y@/.
-- 
-- Buffer coordinates are coordinates for the entire buffer, not just
-- the currently-displayed portion. If you have coordinates from an event,
-- you have to convert those to buffer coordinates with
-- 'GI.Gtk.Objects.TextView.textViewWindowToBufferCoords'.
-- 
-- Note that this is different from 'GI.Gtk.Objects.TextView.textViewGetIterAtLocation',
-- which returns cursor locations, i.e. positions between characters.
textViewGetIterAtPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Int32
    -- ^ /@x@/: x position, in buffer coordinates
    -> Int32
    -- ^ /@y@/: y position, in buffer coordinates
    -> m ((Bool, Gtk.TextIter.TextIter, Int32))
    -- ^ __Returns:__ 'P.True' if the position is over text
textViewGetIterAtPosition textView x y = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    iter <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    trailing <- allocMem :: IO (Ptr Int32)
    result <- gtk_text_view_get_iter_at_position textView' iter trailing x y
    let result' = (/= 0) result
    iter' <- (wrapBoxed Gtk.TextIter.TextIter) iter
    trailing' <- peek trailing
    touchManagedPtr textView
    freeMem trailing
    return (result', iter', trailing')

#if defined(ENABLE_OVERLOADING)
data TextViewGetIterAtPositionMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ((Bool, Gtk.TextIter.TextIter, Int32))), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetIterAtPositionMethodInfo a signature where
    overloadedMethod = textViewGetIterAtPosition

instance O.OverloadedMethodInfo TextViewGetIterAtPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetIterAtPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetIterAtPosition"
        })


#endif

-- method TextView::get_iter_location
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "location"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "bounds of the character at @iter"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_iter_location" gtk_text_view_get_iter_location :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Gdk.Rectangle.Rectangle ->          -- location : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | Gets a rectangle which roughly contains the character at /@iter@/.
-- 
-- The rectangle position is in buffer coordinates; use
-- 'GI.Gtk.Objects.TextView.textViewBufferToWindowCoords' to convert these
-- coordinates to coordinates for one of the windows in the text view.
textViewGetIterLocation ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a @GtkTextIter@
    -> m (Gdk.Rectangle.Rectangle)
textViewGetIterLocation textView iter = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    iter' <- unsafeManagedPtrGetPtr iter
    location <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    gtk_text_view_get_iter_location textView' iter' location
    location' <- (wrapBoxed Gdk.Rectangle.Rectangle) location
    touchManagedPtr textView
    touchManagedPtr iter
    return location'

#if defined(ENABLE_OVERLOADING)
data TextViewGetIterLocationMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> m (Gdk.Rectangle.Rectangle)), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetIterLocationMethodInfo a signature where
    overloadedMethod = textViewGetIterLocation

instance O.OverloadedMethodInfo TextViewGetIterLocationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetIterLocation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetIterLocation"
        })


#endif

-- method TextView::get_justification
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "Justification" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_justification" gtk_text_view_get_justification :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO CUInt

-- | Gets the default justification of paragraphs in /@textView@/.
-- 
-- Tags in the buffer may override the default.
textViewGetJustification ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Gtk.Enums.Justification
    -- ^ __Returns:__ default justification
textViewGetJustification textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_justification textView'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetJustificationMethodInfo
instance (signature ~ (m Gtk.Enums.Justification), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetJustificationMethodInfo a signature where
    overloadedMethod = textViewGetJustification

instance O.OverloadedMethodInfo TextViewGetJustificationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetJustification",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetJustification"
        })


#endif

-- method TextView::get_left_margin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_left_margin" gtk_text_view_get_left_margin :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO Int32

-- | Gets the default left margin size of paragraphs in the /@textView@/.
-- 
-- Tags in the buffer may override the default.
textViewGetLeftMargin ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Int32
    -- ^ __Returns:__ left margin in pixels
textViewGetLeftMargin textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_left_margin textView'
    touchManagedPtr textView
    return result

#if defined(ENABLE_OVERLOADING)
data TextViewGetLeftMarginMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetLeftMarginMethodInfo a signature where
    overloadedMethod = textViewGetLeftMargin

instance O.OverloadedMethodInfo TextViewGetLeftMarginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetLeftMargin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetLeftMargin"
        })


#endif

-- method TextView::get_line_at_y
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "target_iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a y coordinate" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "line_top"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for top coordinate of the line"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_line_at_y" gtk_text_view_get_line_at_y :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- target_iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Int32 ->                                -- y : TBasicType TInt
    Ptr Int32 ->                            -- line_top : TBasicType TInt
    IO ()

-- | Gets the @GtkTextIter@ at the start of the line containing
-- the coordinate /@y@/.
-- 
-- /@y@/ is in buffer coordinates, convert from window coordinates with
-- 'GI.Gtk.Objects.TextView.textViewWindowToBufferCoords'. If non-'P.Nothing',
-- /@lineTop@/ will be filled with the coordinate of the top edge
-- of the line.
textViewGetLineAtY ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Int32
    -- ^ /@y@/: a y coordinate
    -> m ((Gtk.TextIter.TextIter, Int32))
textViewGetLineAtY textView y = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    targetIter <- SP.callocBoxedBytes 80 :: IO (Ptr Gtk.TextIter.TextIter)
    lineTop <- allocMem :: IO (Ptr Int32)
    gtk_text_view_get_line_at_y textView' targetIter y lineTop
    targetIter' <- (wrapBoxed Gtk.TextIter.TextIter) targetIter
    lineTop' <- peek lineTop
    touchManagedPtr textView
    freeMem lineTop
    return (targetIter', lineTop')

#if defined(ENABLE_OVERLOADING)
data TextViewGetLineAtYMethodInfo
instance (signature ~ (Int32 -> m ((Gtk.TextIter.TextIter, Int32))), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetLineAtYMethodInfo a signature where
    overloadedMethod = textViewGetLineAtY

instance O.OverloadedMethodInfo TextViewGetLineAtYMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetLineAtY",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetLineAtY"
        })


#endif

-- method TextView::get_line_yrange
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a y coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a height"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_line_yrange" gtk_text_view_get_line_yrange :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Ptr Int32 ->                            -- y : TBasicType TInt
    Ptr Int32 ->                            -- height : TBasicType TInt
    IO ()

-- | Gets the y coordinate of the top of the line containing /@iter@/,
-- and the height of the line.
-- 
-- The coordinate is a buffer coordinate; convert to window
-- coordinates with 'GI.Gtk.Objects.TextView.textViewBufferToWindowCoords'.
textViewGetLineYrange ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a @GtkTextIter@
    -> m ((Int32, Int32))
textViewGetLineYrange textView iter = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    iter' <- unsafeManagedPtrGetPtr iter
    y <- allocMem :: IO (Ptr Int32)
    height <- allocMem :: IO (Ptr Int32)
    gtk_text_view_get_line_yrange textView' iter' y height
    y' <- peek y
    height' <- peek height
    touchManagedPtr textView
    touchManagedPtr iter
    freeMem y
    freeMem height
    return (y', height')

#if defined(ENABLE_OVERLOADING)
data TextViewGetLineYrangeMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> m ((Int32, Int32))), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetLineYrangeMethodInfo a signature where
    overloadedMethod = textViewGetLineYrange

instance O.OverloadedMethodInfo TextViewGetLineYrangeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetLineYrange",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetLineYrange"
        })


#endif

-- method TextView::get_ltr_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Context" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_ltr_context" gtk_text_view_get_ltr_context :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO (Ptr Pango.Context.Context)

-- | Gets the @PangoContext@ that is used for rendering LTR directed
-- text layouts.
-- 
-- The context may be replaced when CSS changes occur.
-- 
-- /Since: 4.4/
textViewGetLtrContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Pango.Context.Context
    -- ^ __Returns:__ a @PangoContext@
textViewGetLtrContext textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_ltr_context textView'
    checkUnexpectedReturnNULL "textViewGetLtrContext" result
    result' <- (newObject Pango.Context.Context) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetLtrContextMethodInfo
instance (signature ~ (m Pango.Context.Context), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetLtrContextMethodInfo a signature where
    overloadedMethod = textViewGetLtrContext

instance O.OverloadedMethodInfo TextViewGetLtrContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetLtrContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetLtrContext"
        })


#endif

-- method TextView::get_monospace
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_monospace" gtk_text_view_get_monospace :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO CInt

-- | Gets whether the @GtkTextView@ uses monospace styling.
textViewGetMonospace ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if monospace fonts are desired
textViewGetMonospace textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_monospace textView'
    let result' = (/= 0) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetMonospaceMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetMonospaceMethodInfo a signature where
    overloadedMethod = textViewGetMonospace

instance O.OverloadedMethodInfo TextViewGetMonospaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetMonospace",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetMonospace"
        })


#endif

-- method TextView::get_overwrite
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_overwrite" gtk_text_view_get_overwrite :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO CInt

-- | Returns whether the @GtkTextView@ is in overwrite mode or not.
textViewGetOverwrite ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Bool
    -- ^ __Returns:__ whether /@textView@/ is in overwrite mode or not.
textViewGetOverwrite textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_overwrite textView'
    let result' = (/= 0) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetOverwriteMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetOverwriteMethodInfo a signature where
    overloadedMethod = textViewGetOverwrite

instance O.OverloadedMethodInfo TextViewGetOverwriteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetOverwrite",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetOverwrite"
        })


#endif

-- method TextView::get_pixels_above_lines
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_pixels_above_lines" gtk_text_view_get_pixels_above_lines :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO Int32

-- | Gets the default number of pixels to put above paragraphs.
-- 
-- Adding this function with 'GI.Gtk.Objects.TextView.textViewGetPixelsBelowLines'
-- is equal to the line space between each paragraph.
textViewGetPixelsAboveLines ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Int32
    -- ^ __Returns:__ default number of pixels above paragraphs
textViewGetPixelsAboveLines textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_pixels_above_lines textView'
    touchManagedPtr textView
    return result

#if defined(ENABLE_OVERLOADING)
data TextViewGetPixelsAboveLinesMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetPixelsAboveLinesMethodInfo a signature where
    overloadedMethod = textViewGetPixelsAboveLines

instance O.OverloadedMethodInfo TextViewGetPixelsAboveLinesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetPixelsAboveLines",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetPixelsAboveLines"
        })


#endif

-- method TextView::get_pixels_below_lines
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_pixels_below_lines" gtk_text_view_get_pixels_below_lines :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO Int32

-- | Gets the default number of pixels to put below paragraphs.
-- 
-- The line space is the sum of the value returned by this function and
-- the value returned by 'GI.Gtk.Objects.TextView.textViewGetPixelsAboveLines'.
textViewGetPixelsBelowLines ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Int32
    -- ^ __Returns:__ default number of blank pixels below paragraphs
textViewGetPixelsBelowLines textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_pixels_below_lines textView'
    touchManagedPtr textView
    return result

#if defined(ENABLE_OVERLOADING)
data TextViewGetPixelsBelowLinesMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetPixelsBelowLinesMethodInfo a signature where
    overloadedMethod = textViewGetPixelsBelowLines

instance O.OverloadedMethodInfo TextViewGetPixelsBelowLinesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetPixelsBelowLines",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetPixelsBelowLines"
        })


#endif

-- method TextView::get_pixels_inside_wrap
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_pixels_inside_wrap" gtk_text_view_get_pixels_inside_wrap :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO Int32

-- | Gets the default number of pixels to put between wrapped lines
-- inside a paragraph.
textViewGetPixelsInsideWrap ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Int32
    -- ^ __Returns:__ default number of pixels of blank space between wrapped lines
textViewGetPixelsInsideWrap textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_pixels_inside_wrap textView'
    touchManagedPtr textView
    return result

#if defined(ENABLE_OVERLOADING)
data TextViewGetPixelsInsideWrapMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetPixelsInsideWrapMethodInfo a signature where
    overloadedMethod = textViewGetPixelsInsideWrap

instance O.OverloadedMethodInfo TextViewGetPixelsInsideWrapMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetPixelsInsideWrap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetPixelsInsideWrap"
        })


#endif

-- method TextView::get_right_margin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_right_margin" gtk_text_view_get_right_margin :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO Int32

-- | Gets the default right margin for text in /@textView@/.
-- 
-- Tags in the buffer may override the default.
textViewGetRightMargin ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Int32
    -- ^ __Returns:__ right margin in pixels
textViewGetRightMargin textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_right_margin textView'
    touchManagedPtr textView
    return result

#if defined(ENABLE_OVERLOADING)
data TextViewGetRightMarginMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetRightMarginMethodInfo a signature where
    overloadedMethod = textViewGetRightMargin

instance O.OverloadedMethodInfo TextViewGetRightMarginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetRightMargin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetRightMargin"
        })


#endif

-- method TextView::get_rtl_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "Context" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_rtl_context" gtk_text_view_get_rtl_context :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO (Ptr Pango.Context.Context)

-- | Gets the @PangoContext@ that is used for rendering RTL directed
-- text layouts.
-- 
-- The context may be replaced when CSS changes occur.
-- 
-- /Since: 4.4/
textViewGetRtlContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Pango.Context.Context
    -- ^ __Returns:__ a @PangoContext@
textViewGetRtlContext textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_rtl_context textView'
    checkUnexpectedReturnNULL "textViewGetRtlContext" result
    result' <- (newObject Pango.Context.Context) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetRtlContextMethodInfo
instance (signature ~ (m Pango.Context.Context), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetRtlContextMethodInfo a signature where
    overloadedMethod = textViewGetRtlContext

instance O.OverloadedMethodInfo TextViewGetRtlContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetRtlContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetRtlContext"
        })


#endif

-- method TextView::get_tabs
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Pango" , name = "TabArray" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_tabs" gtk_text_view_get_tabs :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO (Ptr Pango.TabArray.TabArray)

-- | Gets the default tabs for /@textView@/.
-- 
-- Tags in the buffer may override the defaults. The returned array
-- will be 'P.Nothing' if “standard” (8-space) tabs are used. Free the
-- return value with 'GI.Pango.Structs.TabArray.tabArrayFree'.
textViewGetTabs ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m (Maybe Pango.TabArray.TabArray)
    -- ^ __Returns:__ copy of default tab array,
    --   or 'P.Nothing' if standard tabs are used; must be freed with
    --   'GI.Pango.Structs.TabArray.tabArrayFree'.
textViewGetTabs textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_tabs textView'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapBoxed Pango.TabArray.TabArray) result'
        return result''
    touchManagedPtr textView
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data TextViewGetTabsMethodInfo
instance (signature ~ (m (Maybe Pango.TabArray.TabArray)), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetTabsMethodInfo a signature where
    overloadedMethod = textViewGetTabs

instance O.OverloadedMethodInfo TextViewGetTabsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetTabs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetTabs"
        })


#endif

-- method TextView::get_top_margin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_top_margin" gtk_text_view_get_top_margin :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO Int32

-- | Gets the top margin for text in the /@textView@/.
textViewGetTopMargin ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Int32
    -- ^ __Returns:__ top margin in pixels
textViewGetTopMargin textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_top_margin textView'
    touchManagedPtr textView
    return result

#if defined(ENABLE_OVERLOADING)
data TextViewGetTopMarginMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetTopMarginMethodInfo a signature where
    overloadedMethod = textViewGetTopMargin

instance O.OverloadedMethodInfo TextViewGetTopMarginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetTopMargin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetTopMargin"
        })


#endif

-- method TextView::get_visible_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_offset"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location for the X offset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y_offset"
--           , argType = TBasicType TDouble
--           , direction = DirectionOut
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location for the Y offset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_visible_offset" gtk_text_view_get_visible_offset :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr CDouble ->                          -- x_offset : TBasicType TDouble
    Ptr CDouble ->                          -- y_offset : TBasicType TDouble
    IO ()

-- | Gets the X,Y offset in buffer coordinates of the top-left corner of
-- the textview\'s text contents.
-- 
-- This allows for more-precise positioning than what is provided by
-- [method/@gtk@/.TextView.@/get_visible_rect()/@] as you can discover what
-- device pixel is being quantized for text positioning.
-- 
-- You might want this when making ulterior widgets align with quantized
-- device pixels of the textview contents such as line numbers.
-- 
-- /Since: 4.18/
textViewGetVisibleOffset ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m ((Double, Double))
textViewGetVisibleOffset textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    xOffset <- allocMem :: IO (Ptr CDouble)
    yOffset <- allocMem :: IO (Ptr CDouble)
    gtk_text_view_get_visible_offset textView' xOffset yOffset
    xOffset' <- peek xOffset
    let xOffset'' = realToFrac xOffset'
    yOffset' <- peek yOffset
    let yOffset'' = realToFrac yOffset'
    touchManagedPtr textView
    freeMem xOffset
    freeMem yOffset
    return (xOffset'', yOffset'')

#if defined(ENABLE_OVERLOADING)
data TextViewGetVisibleOffsetMethodInfo
instance (signature ~ (m ((Double, Double))), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetVisibleOffsetMethodInfo a signature where
    overloadedMethod = textViewGetVisibleOffset

instance O.OverloadedMethodInfo TextViewGetVisibleOffsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetVisibleOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetVisibleOffset"
        })


#endif

-- method TextView::get_visible_rect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "visible_rect"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to fill" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_visible_rect" gtk_text_view_get_visible_rect :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gdk.Rectangle.Rectangle ->          -- visible_rect : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | Fills /@visibleRect@/ with the currently-visible
-- region of the buffer, in buffer coordinates.
-- 
-- Convert to window coordinates with
-- 'GI.Gtk.Objects.TextView.textViewBufferToWindowCoords'.
textViewGetVisibleRect ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m (Gdk.Rectangle.Rectangle)
textViewGetVisibleRect textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    visibleRect <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    gtk_text_view_get_visible_rect textView' visibleRect
    visibleRect' <- (wrapBoxed Gdk.Rectangle.Rectangle) visibleRect
    touchManagedPtr textView
    return visibleRect'

#if defined(ENABLE_OVERLOADING)
data TextViewGetVisibleRectMethodInfo
instance (signature ~ (m (Gdk.Rectangle.Rectangle)), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetVisibleRectMethodInfo a signature where
    overloadedMethod = textViewGetVisibleRect

instance O.OverloadedMethodInfo TextViewGetVisibleRectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetVisibleRect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetVisibleRect"
        })


#endif

-- method TextView::get_wrap_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "WrapMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_get_wrap_mode" gtk_text_view_get_wrap_mode :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO CUInt

-- | Gets the line wrapping for the view.
textViewGetWrapMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Gtk.Enums.WrapMode
    -- ^ __Returns:__ the line wrap setting
textViewGetWrapMode textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_get_wrap_mode textView'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewGetWrapModeMethodInfo
instance (signature ~ (m Gtk.Enums.WrapMode), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewGetWrapModeMethodInfo a signature where
    overloadedMethod = textViewGetWrapMode

instance O.OverloadedMethodInfo TextViewGetWrapModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewGetWrapMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewGetWrapMode"
        })


#endif

-- method TextView::im_context_filter_keypress
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the key event" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_im_context_filter_keypress" gtk_text_view_im_context_filter_keypress :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gdk.Event.Event ->                  -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO CInt

-- | Allow the @GtkTextView@ input method to internally handle key press
-- and release events.
-- 
-- If this function returns 'P.True', then no further processing should be
-- done for this key event. See 'GI.Gtk.Objects.IMContext.iMContextFilterKeypress'.
-- 
-- Note that you are expected to call this function from your handler
-- when overriding key event handling. This is needed in the case when
-- you need to insert your own key handling between the input method
-- and the default key event handling of the @GtkTextView@.
-- 
-- 
-- === /c code/
-- >static gboolean
-- >gtk_foo_bar_key_press_event (GtkWidget *widget,
-- >                             GdkEvent  *event)
-- >{
-- >  guint keyval;
-- >
-- >  gdk_event_get_keyval ((GdkEvent*)event, &keyval);
-- >
-- >  if (keyval == GDK_KEY_Return || keyval == GDK_KEY_KP_Enter)
-- >    {
-- >      if (gtk_text_view_im_context_filter_keypress (GTK_TEXT_VIEW (widget), event))
-- >        return TRUE;
-- >    }
-- >
-- >  // Do some stuff
-- >
-- >  return GTK_WIDGET_CLASS (gtk_foo_bar_parent_class)->key_press_event (widget, event);
-- >}
textViewImContextFilterKeypress ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a, Gdk.Event.IsEvent b) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> b
    -- ^ /@event@/: the key event
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the input method handled the key event.
textViewImContextFilterKeypress textView event = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    event' <- unsafeManagedPtrCastPtr event
    result <- gtk_text_view_im_context_filter_keypress textView' event'
    let result' = (/= 0) result
    touchManagedPtr textView
    touchManagedPtr event
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewImContextFilterKeypressMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsTextView a, Gdk.Event.IsEvent b) => O.OverloadedMethod TextViewImContextFilterKeypressMethodInfo a signature where
    overloadedMethod = textViewImContextFilterKeypress

instance O.OverloadedMethodInfo TextViewImContextFilterKeypressMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewImContextFilterKeypress",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewImContextFilterKeypress"
        })


#endif

-- method TextView::move_mark_onscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mark"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextMark" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextMark`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_move_mark_onscreen" gtk_text_view_move_mark_onscreen :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextMark.TextMark ->            -- mark : TInterface (Name {namespace = "Gtk", name = "TextMark"})
    IO CInt

-- | Moves a mark within the buffer so that it\'s
-- located within the currently-visible text area.
textViewMoveMarkOnscreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a, Gtk.TextMark.IsTextMark b) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> b
    -- ^ /@mark@/: a @GtkTextMark@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the mark moved (wasn’t already onscreen)
textViewMoveMarkOnscreen textView mark = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    mark' <- unsafeManagedPtrCastPtr mark
    result <- gtk_text_view_move_mark_onscreen textView' mark'
    let result' = (/= 0) result
    touchManagedPtr textView
    touchManagedPtr mark
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewMoveMarkOnscreenMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsTextView a, Gtk.TextMark.IsTextMark b) => O.OverloadedMethod TextViewMoveMarkOnscreenMethodInfo a signature where
    overloadedMethod = textViewMoveMarkOnscreen

instance O.OverloadedMethodInfo TextViewMoveMarkOnscreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewMoveMarkOnscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewMoveMarkOnscreen"
        })


#endif

-- method TextView::move_overlay
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a widget already added with [method@Gtk.TextView.add_overlay]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xpos"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new X position in buffer coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "ypos"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new Y position in buffer coordinates"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_move_overlay" gtk_text_view_move_overlay :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Int32 ->                                -- xpos : TBasicType TInt
    Int32 ->                                -- ypos : TBasicType TInt
    IO ()

-- | Updates the position of a child.
-- 
-- See 'GI.Gtk.Objects.TextView.textViewAddOverlay'.
textViewMoveOverlay ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> b
    -- ^ /@child@/: a widget already added with 'GI.Gtk.Objects.TextView.textViewAddOverlay'
    -> Int32
    -- ^ /@xpos@/: new X position in buffer coordinates
    -> Int32
    -- ^ /@ypos@/: new Y position in buffer coordinates
    -> m ()
textViewMoveOverlay textView child xpos ypos = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    child' <- unsafeManagedPtrCastPtr child
    gtk_text_view_move_overlay textView' child' xpos ypos
    touchManagedPtr textView
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewMoveOverlayMethodInfo
instance (signature ~ (b -> Int32 -> Int32 -> m ()), MonadIO m, IsTextView a, Gtk.Widget.IsWidget b) => O.OverloadedMethod TextViewMoveOverlayMethodInfo a signature where
    overloadedMethod = textViewMoveOverlay

instance O.OverloadedMethodInfo TextViewMoveOverlayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewMoveOverlay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewMoveOverlay"
        })


#endif

-- method TextView::move_visually
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "count"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "number of characters to move (negative moves left,\n   positive moves right)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_move_visually" gtk_text_view_move_visually :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    Int32 ->                                -- count : TBasicType TInt
    IO CInt

-- | Move the iterator a given number of characters visually, treating
-- it as the strong cursor position.
-- 
-- If /@count@/ is positive, then the new strong cursor position will
-- be /@count@/ positions to the right of the old cursor position.
-- If /@count@/ is negative then the new strong cursor position will
-- be /@count@/ positions to the left of the old cursor position.
-- 
-- In the presence of bi-directional text, the correspondence
-- between logical and visual order will depend on the direction
-- of the current run, and there may be jumps when the cursor
-- is moved off of the end of a run.
textViewMoveVisually ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a @GtkTextIter@
    -> Int32
    -- ^ /@count@/: number of characters to move (negative moves left,
    --    positive moves right)
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@iter@/ moved and is not on the end iterator
textViewMoveVisually textView iter count = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    iter' <- unsafeManagedPtrGetPtr iter
    result <- gtk_text_view_move_visually textView' iter' count
    let result' = (/= 0) result
    touchManagedPtr textView
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewMoveVisuallyMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> Int32 -> m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewMoveVisuallyMethodInfo a signature where
    overloadedMethod = textViewMoveVisually

instance O.OverloadedMethodInfo TextViewMoveVisuallyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewMoveVisually",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewMoveVisually"
        })


#endif

-- method TextView::place_cursor_onscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_place_cursor_onscreen" gtk_text_view_place_cursor_onscreen :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO CInt

-- | Moves the cursor to the currently visible region of the
-- buffer.
textViewPlaceCursorOnscreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the cursor had to be moved.
textViewPlaceCursorOnscreen textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    result <- gtk_text_view_place_cursor_onscreen textView'
    let result' = (/= 0) result
    touchManagedPtr textView
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewPlaceCursorOnscreenMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewPlaceCursorOnscreenMethodInfo a signature where
    overloadedMethod = textViewPlaceCursorOnscreen

instance O.OverloadedMethodInfo TextViewPlaceCursorOnscreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewPlaceCursorOnscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewPlaceCursorOnscreen"
        })


#endif

-- method TextView::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_remove" gtk_text_view_remove :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Removes a child widget from /@textView@/.
textViewRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> b
    -- ^ /@child@/: the child to remove
    -> m ()
textViewRemove textView child = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    child' <- unsafeManagedPtrCastPtr child
    gtk_text_view_remove textView' child'
    touchManagedPtr textView
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewRemoveMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsTextView a, Gtk.Widget.IsWidget b) => O.OverloadedMethod TextViewRemoveMethodInfo a signature where
    overloadedMethod = textViewRemove

instance O.OverloadedMethodInfo TextViewRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewRemove"
        })


#endif

-- method TextView::reset_cursor_blink
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_reset_cursor_blink" gtk_text_view_reset_cursor_blink :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO ()

-- | Ensures that the cursor is shown.
-- 
-- This also resets the time that it will stay blinking (or
-- visible, in case blinking is disabled).
-- 
-- This function should be called in response to user input
-- (e.g. from derived classes that override the textview\'s
-- event handlers).
textViewResetCursorBlink ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m ()
textViewResetCursorBlink textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    gtk_text_view_reset_cursor_blink textView'
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewResetCursorBlinkMethodInfo
instance (signature ~ (m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewResetCursorBlinkMethodInfo a signature where
    overloadedMethod = textViewResetCursorBlink

instance O.OverloadedMethodInfo TextViewResetCursorBlinkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewResetCursorBlink",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewResetCursorBlink"
        })


#endif

-- method TextView::reset_im_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_reset_im_context" gtk_text_view_reset_im_context :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    IO ()

-- | Reset the input method context of the text view if needed.
-- 
-- This can be necessary in the case where modifying the buffer
-- would confuse on-going input method behavior.
textViewResetImContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> m ()
textViewResetImContext textView = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    gtk_text_view_reset_im_context textView'
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewResetImContextMethodInfo
instance (signature ~ (m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewResetImContextMethodInfo a signature where
    overloadedMethod = textViewResetImContext

instance O.OverloadedMethodInfo TextViewResetImContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewResetImContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewResetImContext"
        })


#endif

-- method TextView::scroll_mark_onscreen
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mark"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextMark" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a mark in the buffer for @text_view"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_scroll_mark_onscreen" gtk_text_view_scroll_mark_onscreen :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextMark.TextMark ->            -- mark : TInterface (Name {namespace = "Gtk", name = "TextMark"})
    IO ()

-- | Scrolls /@textView@/ the minimum distance such that /@mark@/ is contained
-- within the visible area of the widget.
textViewScrollMarkOnscreen ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a, Gtk.TextMark.IsTextMark b) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> b
    -- ^ /@mark@/: a mark in the buffer for /@textView@/
    -> m ()
textViewScrollMarkOnscreen textView mark = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    mark' <- unsafeManagedPtrCastPtr mark
    gtk_text_view_scroll_mark_onscreen textView' mark'
    touchManagedPtr textView
    touchManagedPtr mark
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewScrollMarkOnscreenMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsTextView a, Gtk.TextMark.IsTextMark b) => O.OverloadedMethod TextViewScrollMarkOnscreenMethodInfo a signature where
    overloadedMethod = textViewScrollMarkOnscreen

instance O.OverloadedMethodInfo TextViewScrollMarkOnscreenMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewScrollMarkOnscreen",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewScrollMarkOnscreen"
        })


#endif

-- method TextView::scroll_to_iter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "within_margin"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "margin as a [0.0,0.5) fraction of screen size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_align"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether to use alignment arguments (if %FALSE,\n   just get the mark onscreen)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xalign"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "horizontal alignment of mark within visible area"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "yalign"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "vertical alignment of mark within visible area"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_scroll_to_iter" gtk_text_view_scroll_to_iter :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    CDouble ->                              -- within_margin : TBasicType TDouble
    CInt ->                                 -- use_align : TBasicType TBoolean
    CDouble ->                              -- xalign : TBasicType TDouble
    CDouble ->                              -- yalign : TBasicType TDouble
    IO CInt

-- | Scrolls /@textView@/ so that /@iter@/ is on the screen in the position
-- indicated by /@xalign@/ and /@yalign@/.
-- 
-- An alignment of 0.0 indicates left or top, 1.0 indicates right or
-- bottom, 0.5 means center. If /@useAlign@/ is 'P.False', the text scrolls
-- the minimal distance to get the mark onscreen, possibly not scrolling
-- at all. The effective screen for purposes of this function is reduced
-- by a margin of size /@withinMargin@/.
-- 
-- Note that this function uses the currently-computed height of the
-- lines in the text buffer. Line heights are computed in an idle
-- handler; so this function may not have the desired effect if it’s
-- called before the height computations. To avoid oddness, consider
-- using 'GI.Gtk.Objects.TextView.textViewScrollToMark' which saves a point to be
-- scrolled to after line validation.
textViewScrollToIter ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a @GtkTextIter@
    -> Double
    -- ^ /@withinMargin@/: margin as a [0.0,0.5) fraction of screen size
    -> Bool
    -- ^ /@useAlign@/: whether to use alignment arguments (if 'P.False',
    --    just get the mark onscreen)
    -> Double
    -- ^ /@xalign@/: horizontal alignment of mark within visible area
    -> Double
    -- ^ /@yalign@/: vertical alignment of mark within visible area
    -> m Bool
    -- ^ __Returns:__ 'P.True' if scrolling occurred
textViewScrollToIter textView iter withinMargin useAlign xalign yalign = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    iter' <- unsafeManagedPtrGetPtr iter
    let withinMargin' = realToFrac withinMargin
    let useAlign' = (P.fromIntegral . P.fromEnum) useAlign
    let xalign' = realToFrac xalign
    let yalign' = realToFrac yalign
    result <- gtk_text_view_scroll_to_iter textView' iter' withinMargin' useAlign' xalign' yalign'
    let result' = (/= 0) result
    touchManagedPtr textView
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewScrollToIterMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> Double -> Bool -> Double -> Double -> m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewScrollToIterMethodInfo a signature where
    overloadedMethod = textViewScrollToIter

instance O.OverloadedMethodInfo TextViewScrollToIterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewScrollToIter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewScrollToIter"
        })


#endif

-- method TextView::scroll_to_mark
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mark"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextMark" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextMark`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "within_margin"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "margin as a [0.0,0.5) fraction of screen size"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "use_align"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "whether to use alignment arguments (if %FALSE, just\n   get the mark onscreen)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "xalign"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "horizontal alignment of mark within visible area"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "yalign"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "vertical alignment of mark within visible area"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_scroll_to_mark" gtk_text_view_scroll_to_mark :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextMark.TextMark ->            -- mark : TInterface (Name {namespace = "Gtk", name = "TextMark"})
    CDouble ->                              -- within_margin : TBasicType TDouble
    CInt ->                                 -- use_align : TBasicType TBoolean
    CDouble ->                              -- xalign : TBasicType TDouble
    CDouble ->                              -- yalign : TBasicType TDouble
    IO ()

-- | Scrolls /@textView@/ so that /@mark@/ is on the screen in the position
-- indicated by /@xalign@/ and /@yalign@/.
-- 
-- An alignment of 0.0 indicates left or top, 1.0 indicates right or
-- bottom, 0.5 means center. If /@useAlign@/ is 'P.False', the text scrolls
-- the minimal distance to get the mark onscreen, possibly not scrolling
-- at all. The effective screen for purposes of this function is reduced
-- by a margin of size /@withinMargin@/.
textViewScrollToMark ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a, Gtk.TextMark.IsTextMark b) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> b
    -- ^ /@mark@/: a @GtkTextMark@
    -> Double
    -- ^ /@withinMargin@/: margin as a [0.0,0.5) fraction of screen size
    -> Bool
    -- ^ /@useAlign@/: whether to use alignment arguments (if 'P.False', just
    --    get the mark onscreen)
    -> Double
    -- ^ /@xalign@/: horizontal alignment of mark within visible area
    -> Double
    -- ^ /@yalign@/: vertical alignment of mark within visible area
    -> m ()
textViewScrollToMark textView mark withinMargin useAlign xalign yalign = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    mark' <- unsafeManagedPtrCastPtr mark
    let withinMargin' = realToFrac withinMargin
    let useAlign' = (P.fromIntegral . P.fromEnum) useAlign
    let xalign' = realToFrac xalign
    let yalign' = realToFrac yalign
    gtk_text_view_scroll_to_mark textView' mark' withinMargin' useAlign' xalign' yalign'
    touchManagedPtr textView
    touchManagedPtr mark
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewScrollToMarkMethodInfo
instance (signature ~ (b -> Double -> Bool -> Double -> Double -> m ()), MonadIO m, IsTextView a, Gtk.TextMark.IsTextMark b) => O.OverloadedMethod TextViewScrollToMarkMethodInfo a signature where
    overloadedMethod = textViewScrollToMark

instance O.OverloadedMethodInfo TextViewScrollToMarkMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewScrollToMark",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewScrollToMark"
        })


#endif

-- method TextView::set_accepts_tab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "accepts_tab"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "%TRUE if pressing the Tab key should insert a tab\n   character, %FALSE, if pressing the Tab key should move the\n   keyboard focus."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_accepts_tab" gtk_text_view_set_accepts_tab :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CInt ->                                 -- accepts_tab : TBasicType TBoolean
    IO ()

-- | Sets the behavior of the text widget when the \<kbd>Tab\<\/kbd> key is pressed.
-- 
-- If /@acceptsTab@/ is 'P.True', a tab character is inserted. If /@acceptsTab@/
-- is 'P.False' the keyboard focus is moved to the next widget in the focus
-- chain.
-- 
-- Focus can always be moved using \<kbd>Ctrl\<\/kbd>+\<kbd>Tab\<\/kbd>.
textViewSetAcceptsTab ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: A @GtkTextView@
    -> Bool
    -- ^ /@acceptsTab@/: 'P.True' if pressing the Tab key should insert a tab
    --    character, 'P.False', if pressing the Tab key should move the
    --    keyboard focus.
    -> m ()
textViewSetAcceptsTab textView acceptsTab = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let acceptsTab' = (P.fromIntegral . P.fromEnum) acceptsTab
    gtk_text_view_set_accepts_tab textView' acceptsTab'
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetAcceptsTabMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetAcceptsTabMethodInfo a signature where
    overloadedMethod = textViewSetAcceptsTab

instance O.OverloadedMethodInfo TextViewSetAcceptsTabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetAcceptsTab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetAcceptsTab"
        })


#endif

-- method TextView::set_bottom_margin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "bottom_margin"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "bottom margin in pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_bottom_margin" gtk_text_view_set_bottom_margin :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Int32 ->                                -- bottom_margin : TBasicType TInt
    IO ()

-- | Sets the bottom margin for text in /@textView@/.
-- 
-- Note that this function is confusingly named.
-- In CSS terms, the value set here is padding.
textViewSetBottomMargin ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Int32
    -- ^ /@bottomMargin@/: bottom margin in pixels
    -> m ()
textViewSetBottomMargin textView bottomMargin = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    gtk_text_view_set_bottom_margin textView' bottomMargin
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetBottomMarginMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetBottomMarginMethodInfo a signature where
    overloadedMethod = textViewSetBottomMargin

instance O.OverloadedMethodInfo TextViewSetBottomMarginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetBottomMargin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetBottomMargin"
        })


#endif

-- method TextView::set_buffer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextBuffer" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextBuffer`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_buffer" gtk_text_view_set_buffer :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextBuffer.TextBuffer ->        -- buffer : TInterface (Name {namespace = "Gtk", name = "TextBuffer"})
    IO ()

-- | Sets /@buffer@/ as the buffer being displayed by /@textView@/.
-- 
-- The previous buffer displayed by the text view is unreferenced, and
-- a reference is added to /@buffer@/. If you owned a reference to /@buffer@/
-- before passing it to this function, you must remove that reference
-- yourself; @GtkTextView@ will not “adopt” it.
textViewSetBuffer ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a, Gtk.TextBuffer.IsTextBuffer b) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Maybe (b)
    -- ^ /@buffer@/: a @GtkTextBuffer@
    -> m ()
textViewSetBuffer textView buffer = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    maybeBuffer <- case buffer of
        Nothing -> return FP.nullPtr
        Just jBuffer -> do
            jBuffer' <- unsafeManagedPtrCastPtr jBuffer
            return jBuffer'
    gtk_text_view_set_buffer textView' maybeBuffer
    touchManagedPtr textView
    whenJust buffer touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetBufferMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsTextView a, Gtk.TextBuffer.IsTextBuffer b) => O.OverloadedMethod TextViewSetBufferMethodInfo a signature where
    overloadedMethod = textViewSetBuffer

instance O.OverloadedMethodInfo TextViewSetBufferMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetBuffer",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetBuffer"
        })


#endif

-- method TextView::set_cursor_visible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to show the insertion cursor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_cursor_visible" gtk_text_view_set_cursor_visible :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Toggles whether the insertion point should be displayed.
-- 
-- A buffer with no editable text probably shouldn’t have a visible
-- cursor, so you may want to turn the cursor off.
-- 
-- Note that this property may be overridden by the
-- [Settings:gtkKeynavUseCaret]("GI.Gtk.Objects.Settings#g:attr:gtkKeynavUseCaret") setting.
textViewSetCursorVisible ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Bool
    -- ^ /@setting@/: whether to show the insertion cursor
    -> m ()
textViewSetCursorVisible textView setting = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_text_view_set_cursor_visible textView' setting'
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetCursorVisibleMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetCursorVisibleMethodInfo a signature where
    overloadedMethod = textViewSetCursorVisible

instance O.OverloadedMethodInfo TextViewSetCursorVisibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetCursorVisible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetCursorVisible"
        })


#endif

-- method TextView::set_editable
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "setting"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether it\8217s editable"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_editable" gtk_text_view_set_editable :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CInt ->                                 -- setting : TBasicType TBoolean
    IO ()

-- | Sets the default editability of the @GtkTextView@.
-- 
-- You can override this default setting with tags in the buffer,
-- using the “editable” attribute of tags.
textViewSetEditable ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Bool
    -- ^ /@setting@/: whether it’s editable
    -> m ()
textViewSetEditable textView setting = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let setting' = (P.fromIntegral . P.fromEnum) setting
    gtk_text_view_set_editable textView' setting'
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetEditableMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetEditableMethodInfo a signature where
    overloadedMethod = textViewSetEditable

instance O.OverloadedMethodInfo TextViewSetEditableMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetEditable",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetEditable"
        })


#endif

-- method TextView::set_extra_menu
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GMenuModel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_extra_menu" gtk_text_view_set_extra_menu :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gio.MenuModel.MenuModel ->          -- model : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    IO ()

-- | Sets a menu model to add when constructing the context
-- menu for /@textView@/.
-- 
-- You can pass 'P.Nothing' to remove a previously set extra menu.
textViewSetExtraMenu ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a, Gio.MenuModel.IsMenuModel b) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Maybe (b)
    -- ^ /@model@/: a @GMenuModel@
    -> m ()
textViewSetExtraMenu textView model = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_text_view_set_extra_menu textView' maybeModel
    touchManagedPtr textView
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetExtraMenuMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsTextView a, Gio.MenuModel.IsMenuModel b) => O.OverloadedMethod TextViewSetExtraMenuMethodInfo a signature where
    overloadedMethod = textViewSetExtraMenu

instance O.OverloadedMethodInfo TextViewSetExtraMenuMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetExtraMenu",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetExtraMenu"
        })


#endif

-- method TextView::set_gutter
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "win"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextWindowType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextWindowType`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWidget`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_gutter" gtk_text_view_set_gutter :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CUInt ->                                -- win : TInterface (Name {namespace = "Gtk", name = "TextWindowType"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Places /@widget@/ into the gutter specified by /@win@/.
-- 
-- /@win@/ must be one of 'GI.Gtk.Enums.TextWindowTypeLeft', 'GI.Gtk.Enums.TextWindowTypeRight',
-- 'GI.Gtk.Enums.TextWindowTypeTop', or 'GI.Gtk.Enums.TextWindowTypeBottom'.
textViewSetGutter ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.Enums.TextWindowType
    -- ^ /@win@/: a @GtkTextWindowType@
    -> Maybe (b)
    -- ^ /@widget@/: a @GtkWidget@
    -> m ()
textViewSetGutter textView win widget = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let win' = (fromIntegral . fromEnum) win
    maybeWidget <- case widget of
        Nothing -> return FP.nullPtr
        Just jWidget -> do
            jWidget' <- unsafeManagedPtrCastPtr jWidget
            return jWidget'
    gtk_text_view_set_gutter textView' win' maybeWidget
    touchManagedPtr textView
    whenJust widget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetGutterMethodInfo
instance (signature ~ (Gtk.Enums.TextWindowType -> Maybe (b) -> m ()), MonadIO m, IsTextView a, Gtk.Widget.IsWidget b) => O.OverloadedMethod TextViewSetGutterMethodInfo a signature where
    overloadedMethod = textViewSetGutter

instance O.OverloadedMethodInfo TextViewSetGutterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetGutter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetGutter"
        })


#endif

-- method TextView::set_indent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "indent"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "indentation in pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_indent" gtk_text_view_set_indent :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Int32 ->                                -- indent : TBasicType TInt
    IO ()

-- | Sets the default indentation for paragraphs in /@textView@/.
-- 
-- Tags in the buffer may override the default.
textViewSetIndent ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Int32
    -- ^ /@indent@/: indentation in pixels
    -> m ()
textViewSetIndent textView indent = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    gtk_text_view_set_indent textView' indent
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetIndentMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetIndentMethodInfo a signature where
    overloadedMethod = textViewSetIndent

instance O.OverloadedMethodInfo TextViewSetIndentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetIndent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetIndent"
        })


#endif

-- method TextView::set_input_hints
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hints"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InputHints" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the hints" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_input_hints" gtk_text_view_set_input_hints :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CUInt ->                                -- hints : TInterface (Name {namespace = "Gtk", name = "InputHints"})
    IO ()

-- | Sets the @input-hints@ of the @GtkTextView@.
-- 
-- The @input-hints@ allow input methods to fine-tune
-- their behaviour.
textViewSetInputHints ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> [Gtk.Flags.InputHints]
    -- ^ /@hints@/: the hints
    -> m ()
textViewSetInputHints textView hints = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let hints' = gflagsToWord hints
    gtk_text_view_set_input_hints textView' hints'
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetInputHintsMethodInfo
instance (signature ~ ([Gtk.Flags.InputHints] -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetInputHintsMethodInfo a signature where
    overloadedMethod = textViewSetInputHints

instance O.OverloadedMethodInfo TextViewSetInputHintsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetInputHints",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetInputHints"
        })


#endif

-- method TextView::set_input_purpose
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "purpose"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "InputPurpose" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the purpose" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_input_purpose" gtk_text_view_set_input_purpose :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CUInt ->                                -- purpose : TInterface (Name {namespace = "Gtk", name = "InputPurpose"})
    IO ()

-- | Sets the @input-purpose@ of the @GtkTextView@.
-- 
-- The @input-purpose@ can be used by on-screen keyboards
-- and other input methods to adjust their behaviour.
textViewSetInputPurpose ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.Enums.InputPurpose
    -- ^ /@purpose@/: the purpose
    -> m ()
textViewSetInputPurpose textView purpose = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let purpose' = (fromIntegral . fromEnum) purpose
    gtk_text_view_set_input_purpose textView' purpose'
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetInputPurposeMethodInfo
instance (signature ~ (Gtk.Enums.InputPurpose -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetInputPurposeMethodInfo a signature where
    overloadedMethod = textViewSetInputPurpose

instance O.OverloadedMethodInfo TextViewSetInputPurposeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetInputPurpose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetInputPurpose"
        })


#endif

-- method TextView::set_justification
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "justification"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Justification" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "justification" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_justification" gtk_text_view_set_justification :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CUInt ->                                -- justification : TInterface (Name {namespace = "Gtk", name = "Justification"})
    IO ()

-- | Sets the default justification of text in /@textView@/.
-- 
-- Tags in the view’s buffer may override the default.
textViewSetJustification ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.Enums.Justification
    -- ^ /@justification@/: justification
    -> m ()
textViewSetJustification textView justification = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let justification' = (fromIntegral . fromEnum) justification
    gtk_text_view_set_justification textView' justification'
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetJustificationMethodInfo
instance (signature ~ (Gtk.Enums.Justification -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetJustificationMethodInfo a signature where
    overloadedMethod = textViewSetJustification

instance O.OverloadedMethodInfo TextViewSetJustificationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetJustification",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetJustification"
        })


#endif

-- method TextView::set_left_margin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "left_margin"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "left margin in pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_left_margin" gtk_text_view_set_left_margin :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Int32 ->                                -- left_margin : TBasicType TInt
    IO ()

-- | Sets the default left margin for text in /@textView@/.
-- 
-- Tags in the buffer may override the default.
-- 
-- Note that this function is confusingly named.
-- In CSS terms, the value set here is padding.
textViewSetLeftMargin ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Int32
    -- ^ /@leftMargin@/: left margin in pixels
    -> m ()
textViewSetLeftMargin textView leftMargin = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    gtk_text_view_set_left_margin textView' leftMargin
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetLeftMarginMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetLeftMarginMethodInfo a signature where
    overloadedMethod = textViewSetLeftMargin

instance O.OverloadedMethodInfo TextViewSetLeftMarginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetLeftMargin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetLeftMargin"
        })


#endif

-- method TextView::set_monospace
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "monospace"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to request monospace styling"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_monospace" gtk_text_view_set_monospace :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CInt ->                                 -- monospace : TBasicType TBoolean
    IO ()

-- | Sets whether the @GtkTextView@ should display text in
-- monospace styling.
textViewSetMonospace ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Bool
    -- ^ /@monospace@/: 'P.True' to request monospace styling
    -> m ()
textViewSetMonospace textView monospace = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let monospace' = (P.fromIntegral . P.fromEnum) monospace
    gtk_text_view_set_monospace textView' monospace'
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetMonospaceMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetMonospaceMethodInfo a signature where
    overloadedMethod = textViewSetMonospace

instance O.OverloadedMethodInfo TextViewSetMonospaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetMonospace",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetMonospace"
        })


#endif

-- method TextView::set_overwrite
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "overwrite"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE to turn on overwrite mode, %FALSE to turn it off"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_overwrite" gtk_text_view_set_overwrite :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CInt ->                                 -- overwrite : TBasicType TBoolean
    IO ()

-- | Changes the @GtkTextView@ overwrite mode.
textViewSetOverwrite ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Bool
    -- ^ /@overwrite@/: 'P.True' to turn on overwrite mode, 'P.False' to turn it off
    -> m ()
textViewSetOverwrite textView overwrite = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let overwrite' = (P.fromIntegral . P.fromEnum) overwrite
    gtk_text_view_set_overwrite textView' overwrite'
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetOverwriteMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetOverwriteMethodInfo a signature where
    overloadedMethod = textViewSetOverwrite

instance O.OverloadedMethodInfo TextViewSetOverwriteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetOverwrite",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetOverwrite"
        })


#endif

-- method TextView::set_pixels_above_lines
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixels_above_lines"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pixels above paragraphs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_pixels_above_lines" gtk_text_view_set_pixels_above_lines :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Int32 ->                                -- pixels_above_lines : TBasicType TInt
    IO ()

-- | Sets the default number of blank pixels above paragraphs in /@textView@/.
-- 
-- Tags in the buffer for /@textView@/ may override the defaults.
textViewSetPixelsAboveLines ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Int32
    -- ^ /@pixelsAboveLines@/: pixels above paragraphs
    -> m ()
textViewSetPixelsAboveLines textView pixelsAboveLines = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    gtk_text_view_set_pixels_above_lines textView' pixelsAboveLines
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetPixelsAboveLinesMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetPixelsAboveLinesMethodInfo a signature where
    overloadedMethod = textViewSetPixelsAboveLines

instance O.OverloadedMethodInfo TextViewSetPixelsAboveLinesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetPixelsAboveLines",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetPixelsAboveLines"
        })


#endif

-- method TextView::set_pixels_below_lines
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixels_below_lines"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pixels below paragraphs"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_pixels_below_lines" gtk_text_view_set_pixels_below_lines :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Int32 ->                                -- pixels_below_lines : TBasicType TInt
    IO ()

-- | Sets the default number of pixels of blank space
-- to put below paragraphs in /@textView@/.
-- 
-- May be overridden by tags applied to /@textView@/’s buffer.
textViewSetPixelsBelowLines ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Int32
    -- ^ /@pixelsBelowLines@/: pixels below paragraphs
    -> m ()
textViewSetPixelsBelowLines textView pixelsBelowLines = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    gtk_text_view_set_pixels_below_lines textView' pixelsBelowLines
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetPixelsBelowLinesMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetPixelsBelowLinesMethodInfo a signature where
    overloadedMethod = textViewSetPixelsBelowLines

instance O.OverloadedMethodInfo TextViewSetPixelsBelowLinesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetPixelsBelowLines",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetPixelsBelowLines"
        })


#endif

-- method TextView::set_pixels_inside_wrap
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pixels_inside_wrap"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "default number of pixels between wrapped lines"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_pixels_inside_wrap" gtk_text_view_set_pixels_inside_wrap :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Int32 ->                                -- pixels_inside_wrap : TBasicType TInt
    IO ()

-- | Sets the default number of pixels of blank space to leave between
-- display\/wrapped lines within a paragraph.
-- 
-- May be overridden by tags in /@textView@/’s buffer.
textViewSetPixelsInsideWrap ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Int32
    -- ^ /@pixelsInsideWrap@/: default number of pixels between wrapped lines
    -> m ()
textViewSetPixelsInsideWrap textView pixelsInsideWrap = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    gtk_text_view_set_pixels_inside_wrap textView' pixelsInsideWrap
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetPixelsInsideWrapMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetPixelsInsideWrapMethodInfo a signature where
    overloadedMethod = textViewSetPixelsInsideWrap

instance O.OverloadedMethodInfo TextViewSetPixelsInsideWrapMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetPixelsInsideWrap",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetPixelsInsideWrap"
        })


#endif

-- method TextView::set_right_margin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "right_margin"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "right margin in pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_right_margin" gtk_text_view_set_right_margin :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Int32 ->                                -- right_margin : TBasicType TInt
    IO ()

-- | Sets the default right margin for text in the text view.
-- 
-- Tags in the buffer may override the default.
-- 
-- Note that this function is confusingly named.
-- In CSS terms, the value set here is padding.
textViewSetRightMargin ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Int32
    -- ^ /@rightMargin@/: right margin in pixels
    -> m ()
textViewSetRightMargin textView rightMargin = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    gtk_text_view_set_right_margin textView' rightMargin
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetRightMarginMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetRightMarginMethodInfo a signature where
    overloadedMethod = textViewSetRightMargin

instance O.OverloadedMethodInfo TextViewSetRightMarginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetRightMargin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetRightMargin"
        })


#endif

-- method TextView::set_tabs
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tabs"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "TabArray" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "tabs as a `PangoTabArray`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_tabs" gtk_text_view_set_tabs :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Pango.TabArray.TabArray ->          -- tabs : TInterface (Name {namespace = "Pango", name = "TabArray"})
    IO ()

-- | Sets the default tab stops for paragraphs in /@textView@/.
-- 
-- Tags in the buffer may override the default.
textViewSetTabs ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Pango.TabArray.TabArray
    -- ^ /@tabs@/: tabs as a @PangoTabArray@
    -> m ()
textViewSetTabs textView tabs = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    tabs' <- unsafeManagedPtrGetPtr tabs
    gtk_text_view_set_tabs textView' tabs'
    touchManagedPtr textView
    touchManagedPtr tabs
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetTabsMethodInfo
instance (signature ~ (Pango.TabArray.TabArray -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetTabsMethodInfo a signature where
    overloadedMethod = textViewSetTabs

instance O.OverloadedMethodInfo TextViewSetTabsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetTabs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetTabs"
        })


#endif

-- method TextView::set_top_margin
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "top_margin"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "top margin in pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_top_margin" gtk_text_view_set_top_margin :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Int32 ->                                -- top_margin : TBasicType TInt
    IO ()

-- | Sets the top margin for text in /@textView@/.
-- 
-- Note that this function is confusingly named.
-- In CSS terms, the value set here is padding.
textViewSetTopMargin ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Int32
    -- ^ /@topMargin@/: top margin in pixels
    -> m ()
textViewSetTopMargin textView topMargin = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    gtk_text_view_set_top_margin textView' topMargin
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetTopMarginMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetTopMarginMethodInfo a signature where
    overloadedMethod = textViewSetTopMargin

instance O.OverloadedMethodInfo TextViewSetTopMarginMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetTopMargin",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetTopMargin"
        })


#endif

-- method TextView::set_wrap_mode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "wrap_mode"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WrapMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWrapMode`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_set_wrap_mode" gtk_text_view_set_wrap_mode :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CUInt ->                                -- wrap_mode : TInterface (Name {namespace = "Gtk", name = "WrapMode"})
    IO ()

-- | Sets the line wrapping for the view.
textViewSetWrapMode ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.Enums.WrapMode
    -- ^ /@wrapMode@/: a @GtkWrapMode@
    -> m ()
textViewSetWrapMode textView wrapMode = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let wrapMode' = (fromIntegral . fromEnum) wrapMode
    gtk_text_view_set_wrap_mode textView' wrapMode'
    touchManagedPtr textView
    return ()

#if defined(ENABLE_OVERLOADING)
data TextViewSetWrapModeMethodInfo
instance (signature ~ (Gtk.Enums.WrapMode -> m ()), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewSetWrapModeMethodInfo a signature where
    overloadedMethod = textViewSetWrapMode

instance O.OverloadedMethodInfo TextViewSetWrapModeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewSetWrapMode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewSetWrapMode"
        })


#endif

-- method TextView::starts_display_line
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "iter"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextIter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextIter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_starts_display_line" gtk_text_view_starts_display_line :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    Ptr Gtk.TextIter.TextIter ->            -- iter : TInterface (Name {namespace = "Gtk", name = "TextIter"})
    IO CInt

-- | Determines whether /@iter@/ is at the start of a display line.
-- 
-- See 'GI.Gtk.Objects.TextView.textViewForwardDisplayLine' for an
-- explanation of display lines vs. paragraphs.
textViewStartsDisplayLine ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.TextIter.TextIter
    -- ^ /@iter@/: a @GtkTextIter@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@iter@/ begins a wrapped line
textViewStartsDisplayLine textView iter = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    iter' <- unsafeManagedPtrGetPtr iter
    result <- gtk_text_view_starts_display_line textView' iter'
    let result' = (/= 0) result
    touchManagedPtr textView
    touchManagedPtr iter
    return result'

#if defined(ENABLE_OVERLOADING)
data TextViewStartsDisplayLineMethodInfo
instance (signature ~ (Gtk.TextIter.TextIter -> m Bool), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewStartsDisplayLineMethodInfo a signature where
    overloadedMethod = textViewStartsDisplayLine

instance O.OverloadedMethodInfo TextViewStartsDisplayLineMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewStartsDisplayLine",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewStartsDisplayLine"
        })


#endif

-- method TextView::window_to_buffer_coords
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "text_view"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextView" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextView`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "win"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "TextWindowType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkTextWindowType`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window_x"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "window x coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window_y"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "window y coordinate"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "buffer_x"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "buffer x coordinate return location"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "buffer_y"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "buffer y coordinate return location"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_text_view_window_to_buffer_coords" gtk_text_view_window_to_buffer_coords :: 
    Ptr TextView ->                         -- text_view : TInterface (Name {namespace = "Gtk", name = "TextView"})
    CUInt ->                                -- win : TInterface (Name {namespace = "Gtk", name = "TextWindowType"})
    Int32 ->                                -- window_x : TBasicType TInt
    Int32 ->                                -- window_y : TBasicType TInt
    Ptr Int32 ->                            -- buffer_x : TBasicType TInt
    Ptr Int32 ->                            -- buffer_y : TBasicType TInt
    IO ()

-- | Converts coordinates on the window identified by /@win@/ to buffer
-- coordinates.
textViewWindowToBufferCoords ::
    (B.CallStack.HasCallStack, MonadIO m, IsTextView a) =>
    a
    -- ^ /@textView@/: a @GtkTextView@
    -> Gtk.Enums.TextWindowType
    -- ^ /@win@/: a @GtkTextWindowType@
    -> Int32
    -- ^ /@windowX@/: window x coordinate
    -> Int32
    -- ^ /@windowY@/: window y coordinate
    -> m ((Int32, Int32))
textViewWindowToBufferCoords textView win windowX windowY = liftIO $ do
    textView' <- unsafeManagedPtrCastPtr textView
    let win' = (fromIntegral . fromEnum) win
    bufferX <- allocMem :: IO (Ptr Int32)
    bufferY <- allocMem :: IO (Ptr Int32)
    gtk_text_view_window_to_buffer_coords textView' win' windowX windowY bufferX bufferY
    bufferX' <- peek bufferX
    bufferY' <- peek bufferY
    touchManagedPtr textView
    freeMem bufferX
    freeMem bufferY
    return (bufferX', bufferY')

#if defined(ENABLE_OVERLOADING)
data TextViewWindowToBufferCoordsMethodInfo
instance (signature ~ (Gtk.Enums.TextWindowType -> Int32 -> Int32 -> m ((Int32, Int32))), MonadIO m, IsTextView a) => O.OverloadedMethod TextViewWindowToBufferCoordsMethodInfo a signature where
    overloadedMethod = textViewWindowToBufferCoords

instance O.OverloadedMethodInfo TextViewWindowToBufferCoordsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.TextView.textViewWindowToBufferCoords",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-TextView.html#v:textViewWindowToBufferCoords"
        })


#endif


