{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Shows a \"light switch\" that has two states: on or off.
-- 
-- \<picture>
--   \<source srcset=\"switch-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkSwitch\" src=\"switch.png\">
-- \<\/picture>
-- 
-- The user can control which state should be active by clicking the
-- empty area, or by dragging the slider.
-- 
-- @GtkSwitch@ can also express situations where the underlying state changes
-- with a delay. In this case, the slider position indicates the user\'s recent
-- change (represented by the [Switch:active]("GI.Gtk.Objects.Switch#g:attr:active") property), while the
-- trough color indicates the present underlying state (represented by the
-- [Switch:state]("GI.Gtk.Objects.Switch#g:attr:state") property).
-- 
-- \<picture>
--   \<source srcset=\"switch-state-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"GtkSwitch with delayed state change\" src=\"switch-state.png\">
-- \<\/picture>
-- 
-- See [Switch::stateSet]("GI.Gtk.Objects.Switch#g:signal:stateSet") for details.
-- 
-- = Shortcuts and Gestures
-- 
-- @GtkSwitch@ supports pan and drag gestures to move the slider.
-- 
-- = CSS nodes
-- 
-- >switch
-- >├── image
-- >├── image
-- >╰── slider
-- 
-- 
-- @GtkSwitch@ has four css nodes, the main node with the name switch and
-- subnodes for the slider and the on and off images. Neither of them is
-- using any style classes.
-- 
-- = Accessibility
-- 
-- @GtkSwitch@ uses the [enum/@gtk@/.AccessibleRole.switch] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Switch
    ( 

-- * Exported types
    Switch(..)                              ,
    IsSwitch                                ,
    toSwitch                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActionName]("GI.Gtk.Interfaces.Actionable#g:method:getActionName"), [getActionTargetValue]("GI.Gtk.Interfaces.Actionable#g:method:getActionTargetValue"), [getActive]("GI.Gtk.Objects.Switch#g:method:getActive"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getState]("GI.Gtk.Objects.Switch#g:method:getState"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setActionName]("GI.Gtk.Interfaces.Actionable#g:method:setActionName"), [setActionTargetValue]("GI.Gtk.Interfaces.Actionable#g:method:setActionTargetValue"), [setActive]("GI.Gtk.Objects.Switch#g:method:setActive"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDetailedActionName]("GI.Gtk.Interfaces.Actionable#g:method:setDetailedActionName"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setState]("GI.Gtk.Objects.Switch#g:method:setState"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveSwitchMethod                     ,
#endif

-- ** getActive #method:getActive#

#if defined(ENABLE_OVERLOADING)
    SwitchGetActiveMethodInfo               ,
#endif
    switchGetActive                         ,


-- ** getState #method:getState#

#if defined(ENABLE_OVERLOADING)
    SwitchGetStateMethodInfo                ,
#endif
    switchGetState                          ,


-- ** new #method:new#

    switchNew                               ,


-- ** setActive #method:setActive#

#if defined(ENABLE_OVERLOADING)
    SwitchSetActiveMethodInfo               ,
#endif
    switchSetActive                         ,


-- ** setState #method:setState#

#if defined(ENABLE_OVERLOADING)
    SwitchSetStateMethodInfo                ,
#endif
    switchSetState                          ,




 -- * Properties


-- ** active #attr:active#
-- | Whether the @GtkSwitch@ widget is in its on or off state.

#if defined(ENABLE_OVERLOADING)
    SwitchActivePropertyInfo                ,
#endif
    constructSwitchActive                   ,
    getSwitchActive                         ,
    setSwitchActive                         ,
#if defined(ENABLE_OVERLOADING)
    switchActive                            ,
#endif


-- ** state #attr:state#
-- | The backend state that is controlled by the switch.
-- 
-- Applications should usually set the [Switch:active]("GI.Gtk.Objects.Switch#g:attr:active") property,
-- except when indicating a change to the backend state which occurs
-- separately from the user\'s interaction.
-- 
-- See [Switch::stateSet]("GI.Gtk.Objects.Switch#g:signal:stateSet") for details.

#if defined(ENABLE_OVERLOADING)
    SwitchStatePropertyInfo                 ,
#endif
    constructSwitchState                    ,
    getSwitchState                          ,
    setSwitchState                          ,
#if defined(ENABLE_OVERLOADING)
    switchState                             ,
#endif




 -- * Signals


-- ** activate #signal:activate#

    SwitchActivateCallback                  ,
#if defined(ENABLE_OVERLOADING)
    SwitchActivateSignalInfo                ,
#endif
    afterSwitchActivate                     ,
    onSwitchActivate                        ,


-- ** stateSet #signal:stateSet#

    SwitchStateSetCallback                  ,
#if defined(ENABLE_OVERLOADING)
    SwitchStateSetSignalInfo                ,
#endif
    afterSwitchStateSet                     ,
    onSwitchStateSet                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Switch = Switch (SP.ManagedPtr Switch)
    deriving (Eq)

instance SP.ManagedPtrNewtype Switch where
    toManagedPtr (Switch p) = p

foreign import ccall "gtk_switch_get_type"
    c_gtk_switch_get_type :: IO B.Types.GType

instance B.Types.TypedObject Switch where
    glibType = c_gtk_switch_get_type

instance B.Types.GObject Switch

-- | Type class for types which can be safely cast to `Switch`, for instance with `toSwitch`.
class (SP.GObject o, O.IsDescendantOf Switch o) => IsSwitch o
instance (SP.GObject o, O.IsDescendantOf Switch o) => IsSwitch o

instance O.HasParentTypes Switch
type instance O.ParentTypes Switch = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Actionable.Actionable, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `Switch`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSwitch :: (MIO.MonadIO m, IsSwitch o) => o -> m Switch
toSwitch = MIO.liftIO . B.ManagedPtr.unsafeCastTo Switch

-- | Convert 'Switch' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Switch) where
    gvalueGType_ = c_gtk_switch_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Switch)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Switch)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Switch ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSwitchMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSwitchMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveSwitchMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveSwitchMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveSwitchMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveSwitchMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveSwitchMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveSwitchMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveSwitchMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveSwitchMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveSwitchMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveSwitchMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSwitchMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSwitchMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveSwitchMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveSwitchMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveSwitchMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveSwitchMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveSwitchMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveSwitchMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveSwitchMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveSwitchMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveSwitchMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveSwitchMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveSwitchMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSwitchMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSwitchMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSwitchMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveSwitchMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveSwitchMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveSwitchMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveSwitchMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveSwitchMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveSwitchMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveSwitchMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveSwitchMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveSwitchMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveSwitchMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveSwitchMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveSwitchMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveSwitchMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSwitchMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveSwitchMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveSwitchMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveSwitchMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveSwitchMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveSwitchMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveSwitchMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveSwitchMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveSwitchMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSwitchMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSwitchMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveSwitchMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveSwitchMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveSwitchMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveSwitchMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveSwitchMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveSwitchMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveSwitchMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSwitchMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSwitchMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveSwitchMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveSwitchMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveSwitchMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveSwitchMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveSwitchMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveSwitchMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveSwitchMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSwitchMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveSwitchMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveSwitchMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveSwitchMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveSwitchMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSwitchMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSwitchMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSwitchMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveSwitchMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveSwitchMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveSwitchMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveSwitchMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveSwitchMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSwitchMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveSwitchMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveSwitchMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveSwitchMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveSwitchMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveSwitchMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveSwitchMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSwitchMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveSwitchMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveSwitchMethod "getActionName" o = Gtk.Actionable.ActionableGetActionNameMethodInfo
    ResolveSwitchMethod "getActionTargetValue" o = Gtk.Actionable.ActionableGetActionTargetValueMethodInfo
    ResolveSwitchMethod "getActive" o = SwitchGetActiveMethodInfo
    ResolveSwitchMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveSwitchMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveSwitchMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveSwitchMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveSwitchMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveSwitchMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveSwitchMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveSwitchMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveSwitchMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveSwitchMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveSwitchMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveSwitchMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveSwitchMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveSwitchMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveSwitchMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveSwitchMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveSwitchMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveSwitchMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSwitchMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveSwitchMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveSwitchMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveSwitchMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveSwitchMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveSwitchMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveSwitchMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveSwitchMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveSwitchMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveSwitchMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveSwitchMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveSwitchMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveSwitchMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveSwitchMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveSwitchMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveSwitchMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveSwitchMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveSwitchMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveSwitchMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveSwitchMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveSwitchMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveSwitchMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveSwitchMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveSwitchMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveSwitchMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveSwitchMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveSwitchMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveSwitchMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveSwitchMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveSwitchMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveSwitchMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveSwitchMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveSwitchMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveSwitchMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveSwitchMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveSwitchMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSwitchMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSwitchMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveSwitchMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveSwitchMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveSwitchMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveSwitchMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveSwitchMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveSwitchMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveSwitchMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveSwitchMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveSwitchMethod "getState" o = SwitchGetStateMethodInfo
    ResolveSwitchMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveSwitchMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveSwitchMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveSwitchMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveSwitchMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveSwitchMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveSwitchMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveSwitchMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveSwitchMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveSwitchMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveSwitchMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveSwitchMethod "setActionName" o = Gtk.Actionable.ActionableSetActionNameMethodInfo
    ResolveSwitchMethod "setActionTargetValue" o = Gtk.Actionable.ActionableSetActionTargetValueMethodInfo
    ResolveSwitchMethod "setActive" o = SwitchSetActiveMethodInfo
    ResolveSwitchMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveSwitchMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveSwitchMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveSwitchMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveSwitchMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveSwitchMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveSwitchMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSwitchMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSwitchMethod "setDetailedActionName" o = Gtk.Actionable.ActionableSetDetailedActionNameMethodInfo
    ResolveSwitchMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveSwitchMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveSwitchMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveSwitchMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveSwitchMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveSwitchMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveSwitchMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveSwitchMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveSwitchMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveSwitchMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveSwitchMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveSwitchMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveSwitchMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveSwitchMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveSwitchMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveSwitchMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveSwitchMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveSwitchMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveSwitchMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveSwitchMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveSwitchMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSwitchMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveSwitchMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveSwitchMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveSwitchMethod "setState" o = SwitchSetStateMethodInfo
    ResolveSwitchMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveSwitchMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveSwitchMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveSwitchMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveSwitchMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveSwitchMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveSwitchMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveSwitchMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSwitchMethod t Switch, O.OverloadedMethod info Switch p) => OL.IsLabel t (Switch -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSwitchMethod t Switch, O.OverloadedMethod info Switch p, R.HasField t Switch p) => R.HasField t Switch p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSwitchMethod t Switch, O.OverloadedMethodInfo info Switch) => OL.IsLabel t (O.MethodProxy info Switch) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Switch::activate
-- | Emitted to animate the switch.
-- 
-- Applications should never connect to this signal,
-- but use the [Switch:active]("GI.Gtk.Objects.Switch#g:attr:active") property.
type SwitchActivateCallback =
    IO ()

type C_SwitchActivateCallback =
    Ptr Switch ->                           -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SwitchActivateCallback`.
foreign import ccall "wrapper"
    mk_SwitchActivateCallback :: C_SwitchActivateCallback -> IO (FunPtr C_SwitchActivateCallback)

wrap_SwitchActivateCallback :: 
    GObject a => (a -> SwitchActivateCallback) ->
    C_SwitchActivateCallback
wrap_SwitchActivateCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' switch #activate callback
-- @
-- 
-- 
onSwitchActivate :: (IsSwitch a, MonadIO m) => a -> ((?self :: a) => SwitchActivateCallback) -> m SignalHandlerId
onSwitchActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SwitchActivateCallback wrapped
    wrapped'' <- mk_SwitchActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activate](#signal:activate) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' switch #activate callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSwitchActivate :: (IsSwitch a, MonadIO m) => a -> ((?self :: a) => SwitchActivateCallback) -> m SignalHandlerId
afterSwitchActivate obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SwitchActivateCallback wrapped
    wrapped'' <- mk_SwitchActivateCallback wrapped'
    connectSignalFunPtr obj "activate" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SwitchActivateSignalInfo
instance SignalInfo SwitchActivateSignalInfo where
    type HaskellCallbackType SwitchActivateSignalInfo = SwitchActivateCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SwitchActivateCallback cb
        cb'' <- mk_SwitchActivateCallback cb'
        connectSignalFunPtr obj "activate" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Switch::activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Switch.html#g:signal:activate"})

#endif

-- signal Switch::state-set
-- | Emitted to change the underlying state.
-- 
-- The [stateSet](#g:signal:stateSet) signal is emitted when the user changes the switch
-- position. The default handler calls 'GI.Gtk.Objects.Switch.switchSetState' with the
-- value of /@state@/.
-- 
-- To implement delayed state change, applications can connect to this
-- signal, initiate the change of the underlying state, and call
-- 'GI.Gtk.Objects.Switch.switchSetState' when the underlying state change is
-- complete. The signal handler should return 'P.True' to prevent the
-- default handler from running.
type SwitchStateSetCallback =
    Bool
    -- ^ /@state@/: the new state of the switch
    -> IO Bool
    -- ^ __Returns:__ 'P.True' to stop the signal emission

type C_SwitchStateSetCallback =
    Ptr Switch ->                           -- object
    CInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_SwitchStateSetCallback`.
foreign import ccall "wrapper"
    mk_SwitchStateSetCallback :: C_SwitchStateSetCallback -> IO (FunPtr C_SwitchStateSetCallback)

wrap_SwitchStateSetCallback :: 
    GObject a => (a -> SwitchStateSetCallback) ->
    C_SwitchStateSetCallback
wrap_SwitchStateSetCallback gi'cb gi'selfPtr state _ = do
    let state' = (/= 0) state
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  state'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [stateSet](#signal:stateSet) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' switch #stateSet callback
-- @
-- 
-- 
onSwitchStateSet :: (IsSwitch a, MonadIO m) => a -> ((?self :: a) => SwitchStateSetCallback) -> m SignalHandlerId
onSwitchStateSet obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SwitchStateSetCallback wrapped
    wrapped'' <- mk_SwitchStateSetCallback wrapped'
    connectSignalFunPtr obj "state-set" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [stateSet](#signal:stateSet) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' switch #stateSet callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSwitchStateSet :: (IsSwitch a, MonadIO m) => a -> ((?self :: a) => SwitchStateSetCallback) -> m SignalHandlerId
afterSwitchStateSet obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SwitchStateSetCallback wrapped
    wrapped'' <- mk_SwitchStateSetCallback wrapped'
    connectSignalFunPtr obj "state-set" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SwitchStateSetSignalInfo
instance SignalInfo SwitchStateSetSignalInfo where
    type HaskellCallbackType SwitchStateSetSignalInfo = SwitchStateSetCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SwitchStateSetCallback cb
        cb'' <- mk_SwitchStateSetCallback cb'
        connectSignalFunPtr obj "state-set" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Switch::state-set"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Switch.html#g:signal:stateSet"})

#endif

-- VVV Prop "active"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' switch #active
-- @
getSwitchActive :: (MonadIO m, IsSwitch o) => o -> m Bool
getSwitchActive obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "active"

-- | Set the value of the “@active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' switch [ #active 'Data.GI.Base.Attributes.:=' value ]
-- @
setSwitchActive :: (MonadIO m, IsSwitch o) => o -> Bool -> m ()
setSwitchActive obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "active" val

-- | Construct a `GValueConstruct` with valid value for the “@active@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSwitchActive :: (IsSwitch o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSwitchActive val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "active" val

#if defined(ENABLE_OVERLOADING)
data SwitchActivePropertyInfo
instance AttrInfo SwitchActivePropertyInfo where
    type AttrAllowedOps SwitchActivePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SwitchActivePropertyInfo = IsSwitch
    type AttrSetTypeConstraint SwitchActivePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SwitchActivePropertyInfo = (~) Bool
    type AttrTransferType SwitchActivePropertyInfo = Bool
    type AttrGetType SwitchActivePropertyInfo = Bool
    type AttrLabel SwitchActivePropertyInfo = "active"
    type AttrOrigin SwitchActivePropertyInfo = Switch
    attrGet = getSwitchActive
    attrSet = setSwitchActive
    attrTransfer _ v = do
        return v
    attrConstruct = constructSwitchActive
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Switch.active"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Switch.html#g:attr:active"
        })
#endif

-- VVV Prop "state"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' switch #state
-- @
getSwitchState :: (MonadIO m, IsSwitch o) => o -> m Bool
getSwitchState obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "state"

-- | Set the value of the “@state@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' switch [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setSwitchState :: (MonadIO m, IsSwitch o) => o -> Bool -> m ()
setSwitchState obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "state" val

-- | Construct a `GValueConstruct` with valid value for the “@state@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSwitchState :: (IsSwitch o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSwitchState val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "state" val

#if defined(ENABLE_OVERLOADING)
data SwitchStatePropertyInfo
instance AttrInfo SwitchStatePropertyInfo where
    type AttrAllowedOps SwitchStatePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SwitchStatePropertyInfo = IsSwitch
    type AttrSetTypeConstraint SwitchStatePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SwitchStatePropertyInfo = (~) Bool
    type AttrTransferType SwitchStatePropertyInfo = Bool
    type AttrGetType SwitchStatePropertyInfo = Bool
    type AttrLabel SwitchStatePropertyInfo = "state"
    type AttrOrigin SwitchStatePropertyInfo = Switch
    attrGet = getSwitchState
    attrSet = setSwitchState
    attrTransfer _ v = do
        return v
    attrConstruct = constructSwitchState
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Switch.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Switch.html#g:attr:state"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Switch
type instance O.AttributeList Switch = SwitchAttributeList
type SwitchAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("actionName", Gtk.Actionable.ActionableActionNamePropertyInfo), '("actionTarget", Gtk.Actionable.ActionableActionTargetPropertyInfo), '("active", SwitchActivePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("state", SwitchStatePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
switchActive :: AttrLabelProxy "active"
switchActive = AttrLabelProxy

switchState :: AttrLabelProxy "state"
switchState = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Switch = SwitchSignalList
type SwitchSignalList = ('[ '("activate", SwitchActivateSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("stateSet", SwitchStateSetSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Switch::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Switch" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_switch_new" gtk_switch_new :: 
    IO (Ptr Switch)

-- | Creates a new @GtkSwitch@ widget.
switchNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Switch
    -- ^ __Returns:__ the newly created @GtkSwitch@ instance
switchNew  = liftIO $ do
    result <- gtk_switch_new
    checkUnexpectedReturnNULL "switchNew" result
    result' <- (newObject Switch) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Switch::get_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Switch" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSwitch`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_switch_get_active" gtk_switch_get_active :: 
    Ptr Switch ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Switch"})
    IO CInt

-- | Gets whether the @GtkSwitch@ is in its “on” or “off” state.
switchGetActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsSwitch a) =>
    a
    -- ^ /@self@/: a @GtkSwitch@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the @GtkSwitch@ is active, and 'P.False' otherwise
switchGetActive self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_switch_get_active self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data SwitchGetActiveMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSwitch a) => O.OverloadedMethod SwitchGetActiveMethodInfo a signature where
    overloadedMethod = switchGetActive

instance O.OverloadedMethodInfo SwitchGetActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Switch.switchGetActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Switch.html#v:switchGetActive"
        })


#endif

-- method Switch::get_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Switch" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSwitch`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_switch_get_state" gtk_switch_get_state :: 
    Ptr Switch ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Switch"})
    IO CInt

-- | Gets the underlying state of the @GtkSwitch@.
switchGetState ::
    (B.CallStack.HasCallStack, MonadIO m, IsSwitch a) =>
    a
    -- ^ /@self@/: a @GtkSwitch@
    -> m Bool
    -- ^ __Returns:__ the underlying state
switchGetState self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_switch_get_state self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data SwitchGetStateMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSwitch a) => O.OverloadedMethod SwitchGetStateMethodInfo a signature where
    overloadedMethod = switchGetState

instance O.OverloadedMethodInfo SwitchGetStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Switch.switchGetState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Switch.html#v:switchGetState"
        })


#endif

-- method Switch::set_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Switch" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSwitch`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "is_active"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if @self should be active, and %FALSE otherwise"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_switch_set_active" gtk_switch_set_active :: 
    Ptr Switch ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Switch"})
    CInt ->                                 -- is_active : TBasicType TBoolean
    IO ()

-- | Changes the state of /@self@/ to the desired one.
switchSetActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsSwitch a) =>
    a
    -- ^ /@self@/: a @GtkSwitch@
    -> Bool
    -- ^ /@isActive@/: 'P.True' if /@self@/ should be active, and 'P.False' otherwise
    -> m ()
switchSetActive self isActive = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let isActive' = (P.fromIntegral . P.fromEnum) isActive
    gtk_switch_set_active self' isActive'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data SwitchSetActiveMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSwitch a) => O.OverloadedMethod SwitchSetActiveMethodInfo a signature where
    overloadedMethod = switchSetActive

instance O.OverloadedMethodInfo SwitchSetActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Switch.switchSetActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Switch.html#v:switchSetActive"
        })


#endif

-- method Switch::set_state
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Switch" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSwitch`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "state"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new state" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_switch_set_state" gtk_switch_set_state :: 
    Ptr Switch ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Switch"})
    CInt ->                                 -- state : TBasicType TBoolean
    IO ()

-- | Sets the underlying state of the @GtkSwitch@.
-- 
-- This function is typically called from a [Switch::stateSet]("GI.Gtk.Objects.Switch#g:signal:stateSet")
-- signal handler in order to set up delayed state changes.
-- 
-- See [Switch::stateSet]("GI.Gtk.Objects.Switch#g:signal:stateSet") for details.
switchSetState ::
    (B.CallStack.HasCallStack, MonadIO m, IsSwitch a) =>
    a
    -- ^ /@self@/: a @GtkSwitch@
    -> Bool
    -- ^ /@state@/: the new state
    -> m ()
switchSetState self state = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let state' = (P.fromIntegral . P.fromEnum) state
    gtk_switch_set_state self' state'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data SwitchSetStateMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSwitch a) => O.OverloadedMethod SwitchSetStateMethodInfo a signature where
    overloadedMethod = switchSetState

instance O.OverloadedMethodInfo SwitchSetStateMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Switch.switchSetState",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Switch.html#v:switchSetState"
        })


#endif


