{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GtkStatusbar@ widget is usually placed along the bottom of an application\'s
-- main t'GI.Gtk.Objects.Window.Window'.
-- 
-- picture>
--   \<source srcset=\"statusbar-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkStatusbar\" src=\"statusbar.png\">
-- \<\/picture>
-- 
-- A @GtkStatusBar@ may provide a regular commentary of the application\'s
-- status (as is usually the case in a web browser, for example), or may be
-- used to simply output a message when the status changes, (when an upload
-- is complete in an FTP client, for example).
-- 
-- Status bars in GTK maintain a stack of messages. The message at
-- the top of the each bar’s stack is the one that will currently be displayed.
-- 
-- Any messages added to a statusbar’s stack must specify a context id that
-- is used to uniquely identify the source of a message. This context id can
-- be generated by 'GI.Gtk.Objects.Statusbar.statusbarGetContextId', given a message and
-- the statusbar that it will be added to. Note that messages are stored in a
-- stack, and when choosing which message to display, the stack structure is
-- adhered to, regardless of the context identifier of a message.
-- 
-- One could say that a statusbar maintains one stack of messages for
-- display purposes, but allows multiple message producers to maintain
-- sub-stacks of the messages they produced (via context ids).
-- 
-- Status bars are created using 'GI.Gtk.Objects.Statusbar.statusbarNew'.
-- 
-- Messages are added to the bar’s stack with 'GI.Gtk.Objects.Statusbar.statusbarPush'.
-- 
-- The message at the top of the stack can be removed using
-- 'GI.Gtk.Objects.Statusbar.statusbarPop'. A message can be removed from anywhere in the
-- stack if its message id was recorded at the time it was added. This is done
-- using 'GI.Gtk.Objects.Statusbar.statusbarRemove'.
-- 
-- == CSS node
-- 
-- @GtkStatusbar@ has a single CSS node with name @statusbar@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Statusbar
    ( 

-- * Exported types
    Statusbar(..)                           ,
    IsStatusbar                             ,
    toStatusbar                             ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [pop]("GI.Gtk.Objects.Statusbar#g:method:pop"), [push]("GI.Gtk.Objects.Statusbar#g:method:push"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.Statusbar#g:method:remove"), [removeAll]("GI.Gtk.Objects.Statusbar#g:method:removeAll"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getContextId]("GI.Gtk.Objects.Statusbar#g:method:getContextId"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveStatusbarMethod                  ,
#endif

-- ** getContextId #method:getContextId#

#if defined(ENABLE_OVERLOADING)
    StatusbarGetContextIdMethodInfo         ,
#endif
    statusbarGetContextId                   ,


-- ** new #method:new#

    statusbarNew                            ,


-- ** pop #method:pop#

#if defined(ENABLE_OVERLOADING)
    StatusbarPopMethodInfo                  ,
#endif
    statusbarPop                            ,


-- ** push #method:push#

#if defined(ENABLE_OVERLOADING)
    StatusbarPushMethodInfo                 ,
#endif
    statusbarPush                           ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    StatusbarRemoveMethodInfo               ,
#endif
    statusbarRemove                         ,


-- ** removeAll #method:removeAll#

#if defined(ENABLE_OVERLOADING)
    StatusbarRemoveAllMethodInfo            ,
#endif
    statusbarRemoveAll                      ,




 -- * Signals


-- ** textPopped #signal:textPopped#

    StatusbarTextPoppedCallback             ,
#if defined(ENABLE_OVERLOADING)
    StatusbarTextPoppedSignalInfo           ,
#endif
    afterStatusbarTextPopped                ,
    onStatusbarTextPopped                   ,


-- ** textPushed #signal:textPushed#

    StatusbarTextPushedCallback             ,
#if defined(ENABLE_OVERLOADING)
    StatusbarTextPushedSignalInfo           ,
#endif
    afterStatusbarTextPushed                ,
    onStatusbarTextPushed                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Statusbar = Statusbar (SP.ManagedPtr Statusbar)
    deriving (Eq)

instance SP.ManagedPtrNewtype Statusbar where
    toManagedPtr (Statusbar p) = p

foreign import ccall "gtk_statusbar_get_type"
    c_gtk_statusbar_get_type :: IO B.Types.GType

instance B.Types.TypedObject Statusbar where
    glibType = c_gtk_statusbar_get_type

instance B.Types.GObject Statusbar

-- | Type class for types which can be safely cast to `Statusbar`, for instance with `toStatusbar`.
class (SP.GObject o, O.IsDescendantOf Statusbar o) => IsStatusbar o
instance (SP.GObject o, O.IsDescendantOf Statusbar o) => IsStatusbar o

instance O.HasParentTypes Statusbar
type instance O.ParentTypes Statusbar = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `Statusbar`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toStatusbar :: (MIO.MonadIO m, IsStatusbar o) => o -> m Statusbar
toStatusbar = MIO.liftIO . B.ManagedPtr.unsafeCastTo Statusbar

-- | Convert 'Statusbar' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Statusbar) where
    gvalueGType_ = c_gtk_statusbar_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Statusbar)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Statusbar)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Statusbar ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveStatusbarMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStatusbarMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveStatusbarMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveStatusbarMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveStatusbarMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveStatusbarMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveStatusbarMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveStatusbarMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveStatusbarMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveStatusbarMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveStatusbarMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveStatusbarMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveStatusbarMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveStatusbarMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveStatusbarMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveStatusbarMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveStatusbarMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveStatusbarMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveStatusbarMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveStatusbarMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveStatusbarMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveStatusbarMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveStatusbarMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveStatusbarMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveStatusbarMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveStatusbarMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveStatusbarMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveStatusbarMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveStatusbarMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveStatusbarMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveStatusbarMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveStatusbarMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveStatusbarMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveStatusbarMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveStatusbarMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveStatusbarMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveStatusbarMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveStatusbarMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveStatusbarMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveStatusbarMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveStatusbarMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveStatusbarMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveStatusbarMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveStatusbarMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveStatusbarMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveStatusbarMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveStatusbarMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveStatusbarMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveStatusbarMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveStatusbarMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveStatusbarMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveStatusbarMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveStatusbarMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveStatusbarMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveStatusbarMethod "pop" o = StatusbarPopMethodInfo
    ResolveStatusbarMethod "push" o = StatusbarPushMethodInfo
    ResolveStatusbarMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveStatusbarMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveStatusbarMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveStatusbarMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveStatusbarMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveStatusbarMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveStatusbarMethod "remove" o = StatusbarRemoveMethodInfo
    ResolveStatusbarMethod "removeAll" o = StatusbarRemoveAllMethodInfo
    ResolveStatusbarMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveStatusbarMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveStatusbarMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveStatusbarMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveStatusbarMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveStatusbarMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveStatusbarMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveStatusbarMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveStatusbarMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveStatusbarMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveStatusbarMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveStatusbarMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveStatusbarMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveStatusbarMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveStatusbarMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveStatusbarMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveStatusbarMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveStatusbarMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveStatusbarMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveStatusbarMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveStatusbarMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveStatusbarMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveStatusbarMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveStatusbarMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveStatusbarMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveStatusbarMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveStatusbarMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveStatusbarMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveStatusbarMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveStatusbarMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveStatusbarMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveStatusbarMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveStatusbarMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveStatusbarMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveStatusbarMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveStatusbarMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveStatusbarMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveStatusbarMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveStatusbarMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveStatusbarMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveStatusbarMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveStatusbarMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveStatusbarMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveStatusbarMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveStatusbarMethod "getContextId" o = StatusbarGetContextIdMethodInfo
    ResolveStatusbarMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveStatusbarMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveStatusbarMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveStatusbarMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveStatusbarMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveStatusbarMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveStatusbarMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveStatusbarMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveStatusbarMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveStatusbarMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveStatusbarMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveStatusbarMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveStatusbarMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveStatusbarMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveStatusbarMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveStatusbarMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveStatusbarMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveStatusbarMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveStatusbarMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveStatusbarMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveStatusbarMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveStatusbarMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveStatusbarMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveStatusbarMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveStatusbarMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveStatusbarMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveStatusbarMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveStatusbarMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveStatusbarMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveStatusbarMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveStatusbarMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveStatusbarMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveStatusbarMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveStatusbarMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveStatusbarMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveStatusbarMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveStatusbarMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveStatusbarMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveStatusbarMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveStatusbarMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveStatusbarMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveStatusbarMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveStatusbarMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveStatusbarMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveStatusbarMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveStatusbarMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveStatusbarMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveStatusbarMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveStatusbarMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveStatusbarMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveStatusbarMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveStatusbarMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveStatusbarMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveStatusbarMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveStatusbarMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveStatusbarMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveStatusbarMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveStatusbarMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveStatusbarMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveStatusbarMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveStatusbarMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveStatusbarMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveStatusbarMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveStatusbarMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveStatusbarMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveStatusbarMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveStatusbarMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveStatusbarMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveStatusbarMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveStatusbarMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveStatusbarMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveStatusbarMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveStatusbarMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveStatusbarMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveStatusbarMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveStatusbarMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveStatusbarMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveStatusbarMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveStatusbarMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveStatusbarMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveStatusbarMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveStatusbarMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveStatusbarMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveStatusbarMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveStatusbarMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveStatusbarMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveStatusbarMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveStatusbarMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveStatusbarMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveStatusbarMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveStatusbarMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveStatusbarMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveStatusbarMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveStatusbarMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveStatusbarMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveStatusbarMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveStatusbarMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveStatusbarMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveStatusbarMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveStatusbarMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveStatusbarMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStatusbarMethod t Statusbar, O.OverloadedMethod info Statusbar p) => OL.IsLabel t (Statusbar -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStatusbarMethod t Statusbar, O.OverloadedMethod info Statusbar p, R.HasField t Statusbar p) => R.HasField t Statusbar p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStatusbarMethod t Statusbar, O.OverloadedMethodInfo info Statusbar) => OL.IsLabel t (O.MethodProxy info Statusbar) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Statusbar::text-popped
{-# DEPRECATED StatusbarTextPoppedCallback ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Emitted whenever a new message is popped off a statusbar\'s stack.
type StatusbarTextPoppedCallback =
    Word32
    -- ^ /@contextId@/: the context id of the relevant message\/statusbar
    -> T.Text
    -- ^ /@text@/: the message that was just popped
    -> IO ()

type C_StatusbarTextPoppedCallback =
    Ptr Statusbar ->                        -- object
    Word32 ->
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_StatusbarTextPoppedCallback`.
foreign import ccall "wrapper"
    mk_StatusbarTextPoppedCallback :: C_StatusbarTextPoppedCallback -> IO (FunPtr C_StatusbarTextPoppedCallback)

wrap_StatusbarTextPoppedCallback :: 
    GObject a => (a -> StatusbarTextPoppedCallback) ->
    C_StatusbarTextPoppedCallback
wrap_StatusbarTextPoppedCallback gi'cb gi'selfPtr contextId text _ = do
    text' <- cstringToText text
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  contextId text'


-- | Connect a signal handler for the [textPopped](#signal:textPopped) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' statusbar #textPopped callback
-- @
-- 
-- 
onStatusbarTextPopped :: (IsStatusbar a, MonadIO m) => a -> ((?self :: a) => StatusbarTextPoppedCallback) -> m SignalHandlerId
onStatusbarTextPopped obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_StatusbarTextPoppedCallback wrapped
    wrapped'' <- mk_StatusbarTextPoppedCallback wrapped'
    connectSignalFunPtr obj "text-popped" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [textPopped](#signal:textPopped) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' statusbar #textPopped callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterStatusbarTextPopped :: (IsStatusbar a, MonadIO m) => a -> ((?self :: a) => StatusbarTextPoppedCallback) -> m SignalHandlerId
afterStatusbarTextPopped obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_StatusbarTextPoppedCallback wrapped
    wrapped'' <- mk_StatusbarTextPoppedCallback wrapped'
    connectSignalFunPtr obj "text-popped" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data StatusbarTextPoppedSignalInfo
instance SignalInfo StatusbarTextPoppedSignalInfo where
    type HaskellCallbackType StatusbarTextPoppedSignalInfo = StatusbarTextPoppedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_StatusbarTextPoppedCallback cb
        cb'' <- mk_StatusbarTextPoppedCallback cb'
        connectSignalFunPtr obj "text-popped" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Statusbar::text-popped"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Statusbar.html#g:signal:textPopped"})

#endif

-- signal Statusbar::text-pushed
{-# DEPRECATED StatusbarTextPushedCallback ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Emitted whenever a new message gets pushed onto a statusbar\'s stack.
type StatusbarTextPushedCallback =
    Word32
    -- ^ /@contextId@/: the context id of the relevant message\/statusbar
    -> T.Text
    -- ^ /@text@/: the message that was pushed
    -> IO ()

type C_StatusbarTextPushedCallback =
    Ptr Statusbar ->                        -- object
    Word32 ->
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_StatusbarTextPushedCallback`.
foreign import ccall "wrapper"
    mk_StatusbarTextPushedCallback :: C_StatusbarTextPushedCallback -> IO (FunPtr C_StatusbarTextPushedCallback)

wrap_StatusbarTextPushedCallback :: 
    GObject a => (a -> StatusbarTextPushedCallback) ->
    C_StatusbarTextPushedCallback
wrap_StatusbarTextPushedCallback gi'cb gi'selfPtr contextId text _ = do
    text' <- cstringToText text
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  contextId text'


-- | Connect a signal handler for the [textPushed](#signal:textPushed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' statusbar #textPushed callback
-- @
-- 
-- 
onStatusbarTextPushed :: (IsStatusbar a, MonadIO m) => a -> ((?self :: a) => StatusbarTextPushedCallback) -> m SignalHandlerId
onStatusbarTextPushed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_StatusbarTextPushedCallback wrapped
    wrapped'' <- mk_StatusbarTextPushedCallback wrapped'
    connectSignalFunPtr obj "text-pushed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [textPushed](#signal:textPushed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' statusbar #textPushed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterStatusbarTextPushed :: (IsStatusbar a, MonadIO m) => a -> ((?self :: a) => StatusbarTextPushedCallback) -> m SignalHandlerId
afterStatusbarTextPushed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_StatusbarTextPushedCallback wrapped
    wrapped'' <- mk_StatusbarTextPushedCallback wrapped'
    connectSignalFunPtr obj "text-pushed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data StatusbarTextPushedSignalInfo
instance SignalInfo StatusbarTextPushedSignalInfo where
    type HaskellCallbackType StatusbarTextPushedSignalInfo = StatusbarTextPushedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_StatusbarTextPushedCallback cb
        cb'' <- mk_StatusbarTextPushedCallback cb'
        connectSignalFunPtr obj "text-pushed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Statusbar::text-pushed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Statusbar.html#g:signal:textPushed"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Statusbar
type instance O.AttributeList Statusbar = StatusbarAttributeList
type StatusbarAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Statusbar = StatusbarSignalList
type StatusbarSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("textPopped", StatusbarTextPoppedSignalInfo), '("textPushed", StatusbarTextPushedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Statusbar::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Statusbar" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_statusbar_new" gtk_statusbar_new :: 
    IO (Ptr Statusbar)

{-# DEPRECATED statusbarNew ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Creates a new @GtkStatusbar@ ready for messages.
statusbarNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Statusbar
    -- ^ __Returns:__ the new @GtkStatusbar@
statusbarNew  = liftIO $ do
    result <- gtk_statusbar_new
    checkUnexpectedReturnNULL "statusbarNew" result
    result' <- (newObject Statusbar) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Statusbar::get_context_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "statusbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Statusbar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStatusbar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context_description"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "textual description of what context\n  the new message is being used in"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_statusbar_get_context_id" gtk_statusbar_get_context_id :: 
    Ptr Statusbar ->                        -- statusbar : TInterface (Name {namespace = "Gtk", name = "Statusbar"})
    CString ->                              -- context_description : TBasicType TUTF8
    IO Word32

{-# DEPRECATED statusbarGetContextId ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Returns a new context identifier, given a description
-- of the actual context.
-- 
-- Note that the description is not shown in the UI.
statusbarGetContextId ::
    (B.CallStack.HasCallStack, MonadIO m, IsStatusbar a) =>
    a
    -- ^ /@statusbar@/: a @GtkStatusbar@
    -> T.Text
    -- ^ /@contextDescription@/: textual description of what context
    --   the new message is being used in
    -> m Word32
    -- ^ __Returns:__ an integer id
statusbarGetContextId statusbar contextDescription = liftIO $ do
    statusbar' <- unsafeManagedPtrCastPtr statusbar
    contextDescription' <- textToCString contextDescription
    result <- gtk_statusbar_get_context_id statusbar' contextDescription'
    touchManagedPtr statusbar
    freeMem contextDescription'
    return result

#if defined(ENABLE_OVERLOADING)
data StatusbarGetContextIdMethodInfo
instance (signature ~ (T.Text -> m Word32), MonadIO m, IsStatusbar a) => O.OverloadedMethod StatusbarGetContextIdMethodInfo a signature where
    overloadedMethod = statusbarGetContextId

instance O.OverloadedMethodInfo StatusbarGetContextIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Statusbar.statusbarGetContextId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Statusbar.html#v:statusbarGetContextId"
        })


#endif

-- method Statusbar::pop
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "statusbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Statusbar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStatusbar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a context identifier"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_statusbar_pop" gtk_statusbar_pop :: 
    Ptr Statusbar ->                        -- statusbar : TInterface (Name {namespace = "Gtk", name = "Statusbar"})
    Word32 ->                               -- context_id : TBasicType TUInt
    IO ()

{-# DEPRECATED statusbarPop ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Removes the first message in the @GtkStatusbar@’s stack
-- with the given context id.
-- 
-- Note that this may not change the displayed message,
-- if the message at the top of the stack has a different
-- context id.
statusbarPop ::
    (B.CallStack.HasCallStack, MonadIO m, IsStatusbar a) =>
    a
    -- ^ /@statusbar@/: a @GtkStatusbar@
    -> Word32
    -- ^ /@contextId@/: a context identifier
    -> m ()
statusbarPop statusbar contextId = liftIO $ do
    statusbar' <- unsafeManagedPtrCastPtr statusbar
    gtk_statusbar_pop statusbar' contextId
    touchManagedPtr statusbar
    return ()

#if defined(ENABLE_OVERLOADING)
data StatusbarPopMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsStatusbar a) => O.OverloadedMethod StatusbarPopMethodInfo a signature where
    overloadedMethod = statusbarPop

instance O.OverloadedMethodInfo StatusbarPopMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Statusbar.statusbarPop",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Statusbar.html#v:statusbarPop"
        })


#endif

-- method Statusbar::push
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "statusbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Statusbar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStatusbar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the message\8217s context id, as returned by\n   gtk_statusbar_get_context_id()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the message to add to the statusbar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_statusbar_push" gtk_statusbar_push :: 
    Ptr Statusbar ->                        -- statusbar : TInterface (Name {namespace = "Gtk", name = "Statusbar"})
    Word32 ->                               -- context_id : TBasicType TUInt
    CString ->                              -- text : TBasicType TUTF8
    IO Word32

{-# DEPRECATED statusbarPush ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Pushes a new message onto a statusbar’s stack.
statusbarPush ::
    (B.CallStack.HasCallStack, MonadIO m, IsStatusbar a) =>
    a
    -- ^ /@statusbar@/: a @GtkStatusbar@
    -> Word32
    -- ^ /@contextId@/: the message’s context id, as returned by
    --    'GI.Gtk.Objects.Statusbar.statusbarGetContextId'
    -> T.Text
    -- ^ /@text@/: the message to add to the statusbar
    -> m Word32
    -- ^ __Returns:__ a message id that can be used with
    --   'GI.Gtk.Objects.Statusbar.statusbarRemove'.
statusbarPush statusbar contextId text = liftIO $ do
    statusbar' <- unsafeManagedPtrCastPtr statusbar
    text' <- textToCString text
    result <- gtk_statusbar_push statusbar' contextId text'
    touchManagedPtr statusbar
    freeMem text'
    return result

#if defined(ENABLE_OVERLOADING)
data StatusbarPushMethodInfo
instance (signature ~ (Word32 -> T.Text -> m Word32), MonadIO m, IsStatusbar a) => O.OverloadedMethod StatusbarPushMethodInfo a signature where
    overloadedMethod = statusbarPush

instance O.OverloadedMethodInfo StatusbarPushMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Statusbar.statusbarPush",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Statusbar.html#v:statusbarPush"
        })


#endif

-- method Statusbar::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "statusbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Statusbar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStatusbar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a context identifier"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "message_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a message identifier, as returned by [method@Gtk.Statusbar.push]"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_statusbar_remove" gtk_statusbar_remove :: 
    Ptr Statusbar ->                        -- statusbar : TInterface (Name {namespace = "Gtk", name = "Statusbar"})
    Word32 ->                               -- context_id : TBasicType TUInt
    Word32 ->                               -- message_id : TBasicType TUInt
    IO ()

{-# DEPRECATED statusbarRemove ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Forces the removal of a message from a statusbar’s stack.
-- The exact /@contextId@/ and /@messageId@/ must be specified.
statusbarRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsStatusbar a) =>
    a
    -- ^ /@statusbar@/: a @GtkStatusbar@
    -> Word32
    -- ^ /@contextId@/: a context identifier
    -> Word32
    -- ^ /@messageId@/: a message identifier, as returned by 'GI.Gtk.Objects.Statusbar.statusbarPush'
    -> m ()
statusbarRemove statusbar contextId messageId = liftIO $ do
    statusbar' <- unsafeManagedPtrCastPtr statusbar
    gtk_statusbar_remove statusbar' contextId messageId
    touchManagedPtr statusbar
    return ()

#if defined(ENABLE_OVERLOADING)
data StatusbarRemoveMethodInfo
instance (signature ~ (Word32 -> Word32 -> m ()), MonadIO m, IsStatusbar a) => O.OverloadedMethod StatusbarRemoveMethodInfo a signature where
    overloadedMethod = statusbarRemove

instance O.OverloadedMethodInfo StatusbarRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Statusbar.statusbarRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Statusbar.html#v:statusbarRemove"
        })


#endif

-- method Statusbar::remove_all
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "statusbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Statusbar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStatusbar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "context_id"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a context identifier"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_statusbar_remove_all" gtk_statusbar_remove_all :: 
    Ptr Statusbar ->                        -- statusbar : TInterface (Name {namespace = "Gtk", name = "Statusbar"})
    Word32 ->                               -- context_id : TBasicType TUInt
    IO ()

{-# DEPRECATED statusbarRemoveAll ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Forces the removal of all messages from a statusbar\'s
-- stack with the exact /@contextId@/.
statusbarRemoveAll ::
    (B.CallStack.HasCallStack, MonadIO m, IsStatusbar a) =>
    a
    -- ^ /@statusbar@/: a @GtkStatusbar@
    -> Word32
    -- ^ /@contextId@/: a context identifier
    -> m ()
statusbarRemoveAll statusbar contextId = liftIO $ do
    statusbar' <- unsafeManagedPtrCastPtr statusbar
    gtk_statusbar_remove_all statusbar' contextId
    touchManagedPtr statusbar
    return ()

#if defined(ENABLE_OVERLOADING)
data StatusbarRemoveAllMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsStatusbar a) => O.OverloadedMethod StatusbarRemoveAllMethodInfo a signature where
    overloadedMethod = statusbarRemoveAll

instance O.OverloadedMethodInfo StatusbarRemoveAllMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Statusbar.statusbarRemoveAll",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Statusbar.html#v:statusbarRemoveAll"
        })


#endif


