{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Shows one of its children at a time.
-- 
-- \<picture>
--   \<source srcset=\"stack-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkStack\" src=\"stack.png\">
-- \<\/picture>
-- 
-- In contrast to @GtkNotebook@, @GtkStack@ does not provide a means
-- for users to change the visible child. Instead, a separate widget
-- such as t'GI.Gtk.Objects.StackSwitcher.StackSwitcher' or t'GI.Gtk.Objects.StackSidebar.StackSidebar' can
-- be used with @GtkStack@ to provide this functionality.
-- 
-- Transitions between pages can be animated as slides or fades. This
-- can be controlled with 'GI.Gtk.Objects.Stack.stackSetTransitionType'.
-- These animations respect the [Settings:gtkEnableAnimations]("GI.Gtk.Objects.Settings#g:attr:gtkEnableAnimations")
-- setting.
-- 
-- @GtkStack@ maintains a t'GI.Gtk.Objects.StackPage.StackPage' object for each added
-- child, which holds additional per-child properties. You
-- obtain the @GtkStackPage@ for a child with 'GI.Gtk.Objects.Stack.stackGetPage'
-- and you can obtain a @GtkSelectionModel@ containing all the pages
-- with 'GI.Gtk.Objects.Stack.stackGetPages'.
-- 
-- = GtkStack as GtkBuildable
-- 
-- To set child-specific properties in a .ui file, create @GtkStackPage@
-- objects explicitly, and set the child widget as a property on it:
-- 
-- 
-- === /xml code/
-- >  <object class="GtkStack" id="stack">
-- >    <child>
-- >      <object class="GtkStackPage">
-- >        <property name="name">page1</property>
-- >        <property name="title">In the beginning…</property>
-- >        <property name="child">
-- >          <object class="GtkLabel">
-- >            <property name="label">It was dark</property>
-- >          </object>
-- >        </property>
-- >      </object>
-- >    </child>
-- 
-- 
-- = CSS nodes
-- 
-- @GtkStack@ has a single CSS node named stack.
-- 
-- = Accessibility
-- 
-- @GtkStack@ uses the [enum/@gtk@/.AccessibleRole.tab_panel] role for the stack
-- pages, which are the accessible parent objects of the child widgets.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Stack
    ( 

-- * Exported types
    Stack(..)                               ,
    IsStack                                 ,
    toStack                                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addChild]("GI.Gtk.Objects.Stack#g:method:addChild"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addNamed]("GI.Gtk.Objects.Stack#g:method:addNamed"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [addTitled]("GI.Gtk.Objects.Stack#g:method:addTitled"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.Stack#g:method:remove"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildByName]("GI.Gtk.Objects.Stack#g:method:getChildByName"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHhomogeneous]("GI.Gtk.Objects.Stack#g:method:getHhomogeneous"), [getInterpolateSize]("GI.Gtk.Objects.Stack#g:method:getInterpolateSize"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPage]("GI.Gtk.Objects.Stack#g:method:getPage"), [getPages]("GI.Gtk.Objects.Stack#g:method:getPages"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getTransitionDuration]("GI.Gtk.Objects.Stack#g:method:getTransitionDuration"), [getTransitionRunning]("GI.Gtk.Objects.Stack#g:method:getTransitionRunning"), [getTransitionType]("GI.Gtk.Objects.Stack#g:method:getTransitionType"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVhomogeneous]("GI.Gtk.Objects.Stack#g:method:getVhomogeneous"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getVisibleChild]("GI.Gtk.Objects.Stack#g:method:getVisibleChild"), [getVisibleChildName]("GI.Gtk.Objects.Stack#g:method:getVisibleChildName"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHhomogeneous]("GI.Gtk.Objects.Stack#g:method:setHhomogeneous"), [setInterpolateSize]("GI.Gtk.Objects.Stack#g:method:setInterpolateSize"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setTransitionDuration]("GI.Gtk.Objects.Stack#g:method:setTransitionDuration"), [setTransitionType]("GI.Gtk.Objects.Stack#g:method:setTransitionType"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVhomogeneous]("GI.Gtk.Objects.Stack#g:method:setVhomogeneous"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setVisibleChild]("GI.Gtk.Objects.Stack#g:method:setVisibleChild"), [setVisibleChildFull]("GI.Gtk.Objects.Stack#g:method:setVisibleChildFull"), [setVisibleChildName]("GI.Gtk.Objects.Stack#g:method:setVisibleChildName").

#if defined(ENABLE_OVERLOADING)
    ResolveStackMethod                      ,
#endif

-- ** addChild #method:addChild#

#if defined(ENABLE_OVERLOADING)
    StackAddChildMethodInfo                 ,
#endif
    stackAddChild                           ,


-- ** addNamed #method:addNamed#

#if defined(ENABLE_OVERLOADING)
    StackAddNamedMethodInfo                 ,
#endif
    stackAddNamed                           ,


-- ** addTitled #method:addTitled#

#if defined(ENABLE_OVERLOADING)
    StackAddTitledMethodInfo                ,
#endif
    stackAddTitled                          ,


-- ** getChildByName #method:getChildByName#

#if defined(ENABLE_OVERLOADING)
    StackGetChildByNameMethodInfo           ,
#endif
    stackGetChildByName                     ,


-- ** getHhomogeneous #method:getHhomogeneous#

#if defined(ENABLE_OVERLOADING)
    StackGetHhomogeneousMethodInfo          ,
#endif
    stackGetHhomogeneous                    ,


-- ** getInterpolateSize #method:getInterpolateSize#

#if defined(ENABLE_OVERLOADING)
    StackGetInterpolateSizeMethodInfo       ,
#endif
    stackGetInterpolateSize                 ,


-- ** getPage #method:getPage#

#if defined(ENABLE_OVERLOADING)
    StackGetPageMethodInfo                  ,
#endif
    stackGetPage                            ,


-- ** getPages #method:getPages#

#if defined(ENABLE_OVERLOADING)
    StackGetPagesMethodInfo                 ,
#endif
    stackGetPages                           ,


-- ** getTransitionDuration #method:getTransitionDuration#

#if defined(ENABLE_OVERLOADING)
    StackGetTransitionDurationMethodInfo    ,
#endif
    stackGetTransitionDuration              ,


-- ** getTransitionRunning #method:getTransitionRunning#

#if defined(ENABLE_OVERLOADING)
    StackGetTransitionRunningMethodInfo     ,
#endif
    stackGetTransitionRunning               ,


-- ** getTransitionType #method:getTransitionType#

#if defined(ENABLE_OVERLOADING)
    StackGetTransitionTypeMethodInfo        ,
#endif
    stackGetTransitionType                  ,


-- ** getVhomogeneous #method:getVhomogeneous#

#if defined(ENABLE_OVERLOADING)
    StackGetVhomogeneousMethodInfo          ,
#endif
    stackGetVhomogeneous                    ,


-- ** getVisibleChild #method:getVisibleChild#

#if defined(ENABLE_OVERLOADING)
    StackGetVisibleChildMethodInfo          ,
#endif
    stackGetVisibleChild                    ,


-- ** getVisibleChildName #method:getVisibleChildName#

#if defined(ENABLE_OVERLOADING)
    StackGetVisibleChildNameMethodInfo      ,
#endif
    stackGetVisibleChildName                ,


-- ** new #method:new#

    stackNew                                ,


-- ** remove #method:remove#

#if defined(ENABLE_OVERLOADING)
    StackRemoveMethodInfo                   ,
#endif
    stackRemove                             ,


-- ** setHhomogeneous #method:setHhomogeneous#

#if defined(ENABLE_OVERLOADING)
    StackSetHhomogeneousMethodInfo          ,
#endif
    stackSetHhomogeneous                    ,


-- ** setInterpolateSize #method:setInterpolateSize#

#if defined(ENABLE_OVERLOADING)
    StackSetInterpolateSizeMethodInfo       ,
#endif
    stackSetInterpolateSize                 ,


-- ** setTransitionDuration #method:setTransitionDuration#

#if defined(ENABLE_OVERLOADING)
    StackSetTransitionDurationMethodInfo    ,
#endif
    stackSetTransitionDuration              ,


-- ** setTransitionType #method:setTransitionType#

#if defined(ENABLE_OVERLOADING)
    StackSetTransitionTypeMethodInfo        ,
#endif
    stackSetTransitionType                  ,


-- ** setVhomogeneous #method:setVhomogeneous#

#if defined(ENABLE_OVERLOADING)
    StackSetVhomogeneousMethodInfo          ,
#endif
    stackSetVhomogeneous                    ,


-- ** setVisibleChild #method:setVisibleChild#

#if defined(ENABLE_OVERLOADING)
    StackSetVisibleChildMethodInfo          ,
#endif
    stackSetVisibleChild                    ,


-- ** setVisibleChildFull #method:setVisibleChildFull#

#if defined(ENABLE_OVERLOADING)
    StackSetVisibleChildFullMethodInfo      ,
#endif
    stackSetVisibleChildFull                ,


-- ** setVisibleChildName #method:setVisibleChildName#

#if defined(ENABLE_OVERLOADING)
    StackSetVisibleChildNameMethodInfo      ,
#endif
    stackSetVisibleChildName                ,




 -- * Properties


-- ** hhomogeneous #attr:hhomogeneous#
-- | 'P.True' if the stack allocates the same width for all children.

#if defined(ENABLE_OVERLOADING)
    StackHhomogeneousPropertyInfo           ,
#endif
    constructStackHhomogeneous              ,
    getStackHhomogeneous                    ,
    setStackHhomogeneous                    ,
#if defined(ENABLE_OVERLOADING)
    stackHhomogeneous                       ,
#endif


-- ** interpolateSize #attr:interpolateSize#
-- | Whether or not the size should smoothly change during the transition.

#if defined(ENABLE_OVERLOADING)
    StackInterpolateSizePropertyInfo        ,
#endif
    constructStackInterpolateSize           ,
    getStackInterpolateSize                 ,
    setStackInterpolateSize                 ,
#if defined(ENABLE_OVERLOADING)
    stackInterpolateSize                    ,
#endif


-- ** pages #attr:pages#
-- | A selection model with the stack pages.

#if defined(ENABLE_OVERLOADING)
    StackPagesPropertyInfo                  ,
#endif
    getStackPages                           ,
#if defined(ENABLE_OVERLOADING)
    stackPages                              ,
#endif


-- ** transitionDuration #attr:transitionDuration#
-- | The animation duration, in milliseconds.

#if defined(ENABLE_OVERLOADING)
    StackTransitionDurationPropertyInfo     ,
#endif
    constructStackTransitionDuration        ,
    getStackTransitionDuration              ,
    setStackTransitionDuration              ,
#if defined(ENABLE_OVERLOADING)
    stackTransitionDuration                 ,
#endif


-- ** transitionRunning #attr:transitionRunning#
-- | Whether or not the transition is currently running.

#if defined(ENABLE_OVERLOADING)
    StackTransitionRunningPropertyInfo      ,
#endif
    getStackTransitionRunning               ,
#if defined(ENABLE_OVERLOADING)
    stackTransitionRunning                  ,
#endif


-- ** transitionType #attr:transitionType#
-- | The type of animation used to transition.

#if defined(ENABLE_OVERLOADING)
    StackTransitionTypePropertyInfo         ,
#endif
    constructStackTransitionType            ,
    getStackTransitionType                  ,
    setStackTransitionType                  ,
#if defined(ENABLE_OVERLOADING)
    stackTransitionType                     ,
#endif


-- ** vhomogeneous #attr:vhomogeneous#
-- | 'P.True' if the stack allocates the same height for all children.

#if defined(ENABLE_OVERLOADING)
    StackVhomogeneousPropertyInfo           ,
#endif
    constructStackVhomogeneous              ,
    getStackVhomogeneous                    ,
    setStackVhomogeneous                    ,
#if defined(ENABLE_OVERLOADING)
    stackVhomogeneous                       ,
#endif


-- ** visibleChild #attr:visibleChild#
-- | The widget currently visible in the stack.

#if defined(ENABLE_OVERLOADING)
    StackVisibleChildPropertyInfo           ,
#endif
    constructStackVisibleChild              ,
    getStackVisibleChild                    ,
    setStackVisibleChild                    ,
#if defined(ENABLE_OVERLOADING)
    stackVisibleChild                       ,
#endif


-- ** visibleChildName #attr:visibleChildName#
-- | The name of the widget currently visible in the stack.

#if defined(ENABLE_OVERLOADING)
    StackVisibleChildNamePropertyInfo       ,
#endif
    constructStackVisibleChildName          ,
    getStackVisibleChildName                ,
    setStackVisibleChildName                ,
#if defined(ENABLE_OVERLOADING)
    stackVisibleChildName                   ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StackPage as Gtk.StackPage
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Bitset as Gtk.Bitset
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Objects.StackPage as Gtk.StackPage
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Stack = Stack (SP.ManagedPtr Stack)
    deriving (Eq)

instance SP.ManagedPtrNewtype Stack where
    toManagedPtr (Stack p) = p

foreign import ccall "gtk_stack_get_type"
    c_gtk_stack_get_type :: IO B.Types.GType

instance B.Types.TypedObject Stack where
    glibType = c_gtk_stack_get_type

instance B.Types.GObject Stack

-- | Type class for types which can be safely cast to `Stack`, for instance with `toStack`.
class (SP.GObject o, O.IsDescendantOf Stack o) => IsStack o
instance (SP.GObject o, O.IsDescendantOf Stack o) => IsStack o

instance O.HasParentTypes Stack
type instance O.ParentTypes Stack = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to `Stack`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toStack :: (MIO.MonadIO m, IsStack o) => o -> m Stack
toStack = MIO.liftIO . B.ManagedPtr.unsafeCastTo Stack

-- | Convert 'Stack' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Stack) where
    gvalueGType_ = c_gtk_stack_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Stack)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Stack)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Stack ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveStackMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveStackMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveStackMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveStackMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveStackMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveStackMethod "addChild" o = StackAddChildMethodInfo
    ResolveStackMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveStackMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveStackMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveStackMethod "addNamed" o = StackAddNamedMethodInfo
    ResolveStackMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveStackMethod "addTitled" o = StackAddTitledMethodInfo
    ResolveStackMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveStackMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveStackMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveStackMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveStackMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveStackMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveStackMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveStackMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveStackMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveStackMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveStackMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveStackMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveStackMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveStackMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveStackMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveStackMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveStackMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveStackMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveStackMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveStackMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveStackMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveStackMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveStackMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveStackMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveStackMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveStackMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveStackMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveStackMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveStackMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveStackMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveStackMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveStackMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveStackMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveStackMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveStackMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveStackMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveStackMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveStackMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveStackMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveStackMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveStackMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveStackMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveStackMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveStackMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveStackMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveStackMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveStackMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveStackMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveStackMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveStackMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveStackMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveStackMethod "remove" o = StackRemoveMethodInfo
    ResolveStackMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveStackMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveStackMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveStackMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveStackMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveStackMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveStackMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveStackMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveStackMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveStackMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveStackMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveStackMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveStackMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveStackMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveStackMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveStackMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveStackMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveStackMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveStackMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveStackMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveStackMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveStackMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveStackMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveStackMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveStackMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveStackMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveStackMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveStackMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveStackMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveStackMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveStackMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveStackMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveStackMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveStackMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveStackMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveStackMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveStackMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveStackMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveStackMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveStackMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveStackMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveStackMethod "getChildByName" o = StackGetChildByNameMethodInfo
    ResolveStackMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveStackMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveStackMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveStackMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveStackMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveStackMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveStackMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveStackMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveStackMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveStackMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveStackMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveStackMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveStackMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveStackMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveStackMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveStackMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveStackMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveStackMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveStackMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveStackMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveStackMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveStackMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveStackMethod "getHhomogeneous" o = StackGetHhomogeneousMethodInfo
    ResolveStackMethod "getInterpolateSize" o = StackGetInterpolateSizeMethodInfo
    ResolveStackMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveStackMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveStackMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveStackMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveStackMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveStackMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveStackMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveStackMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveStackMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveStackMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveStackMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveStackMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveStackMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveStackMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveStackMethod "getPage" o = StackGetPageMethodInfo
    ResolveStackMethod "getPages" o = StackGetPagesMethodInfo
    ResolveStackMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveStackMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveStackMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveStackMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveStackMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveStackMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveStackMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveStackMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveStackMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveStackMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveStackMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveStackMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveStackMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveStackMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveStackMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveStackMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveStackMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveStackMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveStackMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveStackMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveStackMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveStackMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveStackMethod "getTransitionDuration" o = StackGetTransitionDurationMethodInfo
    ResolveStackMethod "getTransitionRunning" o = StackGetTransitionRunningMethodInfo
    ResolveStackMethod "getTransitionType" o = StackGetTransitionTypeMethodInfo
    ResolveStackMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveStackMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveStackMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveStackMethod "getVhomogeneous" o = StackGetVhomogeneousMethodInfo
    ResolveStackMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveStackMethod "getVisibleChild" o = StackGetVisibleChildMethodInfo
    ResolveStackMethod "getVisibleChildName" o = StackGetVisibleChildNameMethodInfo
    ResolveStackMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveStackMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveStackMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveStackMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveStackMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveStackMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveStackMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveStackMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveStackMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveStackMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveStackMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveStackMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveStackMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveStackMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveStackMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveStackMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveStackMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveStackMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveStackMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveStackMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveStackMethod "setHhomogeneous" o = StackSetHhomogeneousMethodInfo
    ResolveStackMethod "setInterpolateSize" o = StackSetInterpolateSizeMethodInfo
    ResolveStackMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveStackMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveStackMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveStackMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveStackMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveStackMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveStackMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveStackMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveStackMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveStackMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveStackMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveStackMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveStackMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveStackMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveStackMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveStackMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveStackMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveStackMethod "setTransitionDuration" o = StackSetTransitionDurationMethodInfo
    ResolveStackMethod "setTransitionType" o = StackSetTransitionTypeMethodInfo
    ResolveStackMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveStackMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveStackMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveStackMethod "setVhomogeneous" o = StackSetVhomogeneousMethodInfo
    ResolveStackMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveStackMethod "setVisibleChild" o = StackSetVisibleChildMethodInfo
    ResolveStackMethod "setVisibleChildFull" o = StackSetVisibleChildFullMethodInfo
    ResolveStackMethod "setVisibleChildName" o = StackSetVisibleChildNameMethodInfo
    ResolveStackMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveStackMethod t Stack, O.OverloadedMethod info Stack p) => OL.IsLabel t (Stack -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveStackMethod t Stack, O.OverloadedMethod info Stack p, R.HasField t Stack p) => R.HasField t Stack p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveStackMethod t Stack, O.OverloadedMethodInfo info Stack) => OL.IsLabel t (O.MethodProxy info Stack) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "hhomogeneous"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@hhomogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stack #hhomogeneous
-- @
getStackHhomogeneous :: (MonadIO m, IsStack o) => o -> m Bool
getStackHhomogeneous obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "hhomogeneous"

-- | Set the value of the “@hhomogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stack [ #hhomogeneous 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackHhomogeneous :: (MonadIO m, IsStack o) => o -> Bool -> m ()
setStackHhomogeneous obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "hhomogeneous" val

-- | Construct a `GValueConstruct` with valid value for the “@hhomogeneous@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackHhomogeneous :: (IsStack o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructStackHhomogeneous val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "hhomogeneous" val

#if defined(ENABLE_OVERLOADING)
data StackHhomogeneousPropertyInfo
instance AttrInfo StackHhomogeneousPropertyInfo where
    type AttrAllowedOps StackHhomogeneousPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StackHhomogeneousPropertyInfo = IsStack
    type AttrSetTypeConstraint StackHhomogeneousPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint StackHhomogeneousPropertyInfo = (~) Bool
    type AttrTransferType StackHhomogeneousPropertyInfo = Bool
    type AttrGetType StackHhomogeneousPropertyInfo = Bool
    type AttrLabel StackHhomogeneousPropertyInfo = "hhomogeneous"
    type AttrOrigin StackHhomogeneousPropertyInfo = Stack
    attrGet = getStackHhomogeneous
    attrSet = setStackHhomogeneous
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackHhomogeneous
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.hhomogeneous"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#g:attr:hhomogeneous"
        })
#endif

-- VVV Prop "interpolate-size"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@interpolate-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stack #interpolateSize
-- @
getStackInterpolateSize :: (MonadIO m, IsStack o) => o -> m Bool
getStackInterpolateSize obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "interpolate-size"

-- | Set the value of the “@interpolate-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stack [ #interpolateSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackInterpolateSize :: (MonadIO m, IsStack o) => o -> Bool -> m ()
setStackInterpolateSize obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "interpolate-size" val

-- | Construct a `GValueConstruct` with valid value for the “@interpolate-size@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackInterpolateSize :: (IsStack o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructStackInterpolateSize val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "interpolate-size" val

#if defined(ENABLE_OVERLOADING)
data StackInterpolateSizePropertyInfo
instance AttrInfo StackInterpolateSizePropertyInfo where
    type AttrAllowedOps StackInterpolateSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StackInterpolateSizePropertyInfo = IsStack
    type AttrSetTypeConstraint StackInterpolateSizePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint StackInterpolateSizePropertyInfo = (~) Bool
    type AttrTransferType StackInterpolateSizePropertyInfo = Bool
    type AttrGetType StackInterpolateSizePropertyInfo = Bool
    type AttrLabel StackInterpolateSizePropertyInfo = "interpolate-size"
    type AttrOrigin StackInterpolateSizePropertyInfo = Stack
    attrGet = getStackInterpolateSize
    attrSet = setStackInterpolateSize
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackInterpolateSize
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.interpolateSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#g:attr:interpolateSize"
        })
#endif

-- VVV Prop "pages"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SelectionModel"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@pages@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stack #pages
-- @
getStackPages :: (MonadIO m, IsStack o) => o -> m (Maybe Gtk.SelectionModel.SelectionModel)
getStackPages obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "pages" Gtk.SelectionModel.SelectionModel

#if defined(ENABLE_OVERLOADING)
data StackPagesPropertyInfo
instance AttrInfo StackPagesPropertyInfo where
    type AttrAllowedOps StackPagesPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint StackPagesPropertyInfo = IsStack
    type AttrSetTypeConstraint StackPagesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint StackPagesPropertyInfo = (~) ()
    type AttrTransferType StackPagesPropertyInfo = ()
    type AttrGetType StackPagesPropertyInfo = (Maybe Gtk.SelectionModel.SelectionModel)
    type AttrLabel StackPagesPropertyInfo = "pages"
    type AttrOrigin StackPagesPropertyInfo = Stack
    attrGet = getStackPages
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.pages"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#g:attr:pages"
        })
#endif

-- VVV Prop "transition-duration"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@transition-duration@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stack #transitionDuration
-- @
getStackTransitionDuration :: (MonadIO m, IsStack o) => o -> m Word32
getStackTransitionDuration obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "transition-duration"

-- | Set the value of the “@transition-duration@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stack [ #transitionDuration 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackTransitionDuration :: (MonadIO m, IsStack o) => o -> Word32 -> m ()
setStackTransitionDuration obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "transition-duration" val

-- | Construct a `GValueConstruct` with valid value for the “@transition-duration@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackTransitionDuration :: (IsStack o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructStackTransitionDuration val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "transition-duration" val

#if defined(ENABLE_OVERLOADING)
data StackTransitionDurationPropertyInfo
instance AttrInfo StackTransitionDurationPropertyInfo where
    type AttrAllowedOps StackTransitionDurationPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StackTransitionDurationPropertyInfo = IsStack
    type AttrSetTypeConstraint StackTransitionDurationPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint StackTransitionDurationPropertyInfo = (~) Word32
    type AttrTransferType StackTransitionDurationPropertyInfo = Word32
    type AttrGetType StackTransitionDurationPropertyInfo = Word32
    type AttrLabel StackTransitionDurationPropertyInfo = "transition-duration"
    type AttrOrigin StackTransitionDurationPropertyInfo = Stack
    attrGet = getStackTransitionDuration
    attrSet = setStackTransitionDuration
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackTransitionDuration
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.transitionDuration"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#g:attr:transitionDuration"
        })
#endif

-- VVV Prop "transition-running"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@transition-running@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stack #transitionRunning
-- @
getStackTransitionRunning :: (MonadIO m, IsStack o) => o -> m Bool
getStackTransitionRunning obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "transition-running"

#if defined(ENABLE_OVERLOADING)
data StackTransitionRunningPropertyInfo
instance AttrInfo StackTransitionRunningPropertyInfo where
    type AttrAllowedOps StackTransitionRunningPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint StackTransitionRunningPropertyInfo = IsStack
    type AttrSetTypeConstraint StackTransitionRunningPropertyInfo = (~) ()
    type AttrTransferTypeConstraint StackTransitionRunningPropertyInfo = (~) ()
    type AttrTransferType StackTransitionRunningPropertyInfo = ()
    type AttrGetType StackTransitionRunningPropertyInfo = Bool
    type AttrLabel StackTransitionRunningPropertyInfo = "transition-running"
    type AttrOrigin StackTransitionRunningPropertyInfo = Stack
    attrGet = getStackTransitionRunning
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.transitionRunning"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#g:attr:transitionRunning"
        })
#endif

-- VVV Prop "transition-type"
   -- Type: TInterface (Name {namespace = "Gtk", name = "StackTransitionType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@transition-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stack #transitionType
-- @
getStackTransitionType :: (MonadIO m, IsStack o) => o -> m Gtk.Enums.StackTransitionType
getStackTransitionType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "transition-type"

-- | Set the value of the “@transition-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stack [ #transitionType 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackTransitionType :: (MonadIO m, IsStack o) => o -> Gtk.Enums.StackTransitionType -> m ()
setStackTransitionType obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "transition-type" val

-- | Construct a `GValueConstruct` with valid value for the “@transition-type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackTransitionType :: (IsStack o, MIO.MonadIO m) => Gtk.Enums.StackTransitionType -> m (GValueConstruct o)
constructStackTransitionType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "transition-type" val

#if defined(ENABLE_OVERLOADING)
data StackTransitionTypePropertyInfo
instance AttrInfo StackTransitionTypePropertyInfo where
    type AttrAllowedOps StackTransitionTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StackTransitionTypePropertyInfo = IsStack
    type AttrSetTypeConstraint StackTransitionTypePropertyInfo = (~) Gtk.Enums.StackTransitionType
    type AttrTransferTypeConstraint StackTransitionTypePropertyInfo = (~) Gtk.Enums.StackTransitionType
    type AttrTransferType StackTransitionTypePropertyInfo = Gtk.Enums.StackTransitionType
    type AttrGetType StackTransitionTypePropertyInfo = Gtk.Enums.StackTransitionType
    type AttrLabel StackTransitionTypePropertyInfo = "transition-type"
    type AttrOrigin StackTransitionTypePropertyInfo = Stack
    attrGet = getStackTransitionType
    attrSet = setStackTransitionType
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackTransitionType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.transitionType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#g:attr:transitionType"
        })
#endif

-- VVV Prop "vhomogeneous"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@vhomogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stack #vhomogeneous
-- @
getStackVhomogeneous :: (MonadIO m, IsStack o) => o -> m Bool
getStackVhomogeneous obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "vhomogeneous"

-- | Set the value of the “@vhomogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stack [ #vhomogeneous 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackVhomogeneous :: (MonadIO m, IsStack o) => o -> Bool -> m ()
setStackVhomogeneous obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "vhomogeneous" val

-- | Construct a `GValueConstruct` with valid value for the “@vhomogeneous@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackVhomogeneous :: (IsStack o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructStackVhomogeneous val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "vhomogeneous" val

#if defined(ENABLE_OVERLOADING)
data StackVhomogeneousPropertyInfo
instance AttrInfo StackVhomogeneousPropertyInfo where
    type AttrAllowedOps StackVhomogeneousPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StackVhomogeneousPropertyInfo = IsStack
    type AttrSetTypeConstraint StackVhomogeneousPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint StackVhomogeneousPropertyInfo = (~) Bool
    type AttrTransferType StackVhomogeneousPropertyInfo = Bool
    type AttrGetType StackVhomogeneousPropertyInfo = Bool
    type AttrLabel StackVhomogeneousPropertyInfo = "vhomogeneous"
    type AttrOrigin StackVhomogeneousPropertyInfo = Stack
    attrGet = getStackVhomogeneous
    attrSet = setStackVhomogeneous
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackVhomogeneous
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.vhomogeneous"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#g:attr:vhomogeneous"
        })
#endif

-- VVV Prop "visible-child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@visible-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stack #visibleChild
-- @
getStackVisibleChild :: (MonadIO m, IsStack o) => o -> m (Maybe Gtk.Widget.Widget)
getStackVisibleChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "visible-child" Gtk.Widget.Widget

-- | Set the value of the “@visible-child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stack [ #visibleChild 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackVisibleChild :: (MonadIO m, IsStack o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setStackVisibleChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "visible-child" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@visible-child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackVisibleChild :: (IsStack o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructStackVisibleChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "visible-child" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data StackVisibleChildPropertyInfo
instance AttrInfo StackVisibleChildPropertyInfo where
    type AttrAllowedOps StackVisibleChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StackVisibleChildPropertyInfo = IsStack
    type AttrSetTypeConstraint StackVisibleChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint StackVisibleChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType StackVisibleChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType StackVisibleChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel StackVisibleChildPropertyInfo = "visible-child"
    type AttrOrigin StackVisibleChildPropertyInfo = Stack
    attrGet = getStackVisibleChild
    attrSet = setStackVisibleChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructStackVisibleChild
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.visibleChild"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#g:attr:visibleChild"
        })
#endif

-- VVV Prop "visible-child-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@visible-child-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' stack #visibleChildName
-- @
getStackVisibleChildName :: (MonadIO m, IsStack o) => o -> m (Maybe T.Text)
getStackVisibleChildName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "visible-child-name"

-- | Set the value of the “@visible-child-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' stack [ #visibleChildName 'Data.GI.Base.Attributes.:=' value ]
-- @
setStackVisibleChildName :: (MonadIO m, IsStack o) => o -> T.Text -> m ()
setStackVisibleChildName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "visible-child-name" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@visible-child-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructStackVisibleChildName :: (IsStack o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructStackVisibleChildName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "visible-child-name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data StackVisibleChildNamePropertyInfo
instance AttrInfo StackVisibleChildNamePropertyInfo where
    type AttrAllowedOps StackVisibleChildNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint StackVisibleChildNamePropertyInfo = IsStack
    type AttrSetTypeConstraint StackVisibleChildNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint StackVisibleChildNamePropertyInfo = (~) T.Text
    type AttrTransferType StackVisibleChildNamePropertyInfo = T.Text
    type AttrGetType StackVisibleChildNamePropertyInfo = (Maybe T.Text)
    type AttrLabel StackVisibleChildNamePropertyInfo = "visible-child-name"
    type AttrOrigin StackVisibleChildNamePropertyInfo = Stack
    attrGet = getStackVisibleChildName
    attrSet = setStackVisibleChildName
    attrTransfer _ v = do
        return v
    attrConstruct = constructStackVisibleChildName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.visibleChildName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#g:attr:visibleChildName"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Stack
type instance O.AttributeList Stack = StackAttributeList
type StackAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hhomogeneous", StackHhomogeneousPropertyInfo), '("interpolateSize", StackInterpolateSizePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("pages", StackPagesPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("transitionDuration", StackTransitionDurationPropertyInfo), '("transitionRunning", StackTransitionRunningPropertyInfo), '("transitionType", StackTransitionTypePropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("vhomogeneous", StackVhomogeneousPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("visibleChild", StackVisibleChildPropertyInfo), '("visibleChildName", StackVisibleChildNamePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
stackHhomogeneous :: AttrLabelProxy "hhomogeneous"
stackHhomogeneous = AttrLabelProxy

stackInterpolateSize :: AttrLabelProxy "interpolateSize"
stackInterpolateSize = AttrLabelProxy

stackPages :: AttrLabelProxy "pages"
stackPages = AttrLabelProxy

stackTransitionDuration :: AttrLabelProxy "transitionDuration"
stackTransitionDuration = AttrLabelProxy

stackTransitionRunning :: AttrLabelProxy "transitionRunning"
stackTransitionRunning = AttrLabelProxy

stackTransitionType :: AttrLabelProxy "transitionType"
stackTransitionType = AttrLabelProxy

stackVhomogeneous :: AttrLabelProxy "vhomogeneous"
stackVhomogeneous = AttrLabelProxy

stackVisibleChild :: AttrLabelProxy "visibleChild"
stackVisibleChild = AttrLabelProxy

stackVisibleChildName :: AttrLabelProxy "visibleChildName"
stackVisibleChildName = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Stack = StackSignalList
type StackSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Stack::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Stack" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_new" gtk_stack_new :: 
    IO (Ptr Stack)

-- | Creates a new @GtkStack@.
stackNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Stack
    -- ^ __Returns:__ a new @GtkStack@
stackNew  = liftIO $ do
    result <- gtk_stack_new
    checkUnexpectedReturnNULL "stackNew" result
    result' <- (newObject Stack) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Stack::add_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "StackPage" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_add_child" gtk_stack_add_child :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO (Ptr Gtk.StackPage.StackPage)

-- | Adds a child to /@stack@/.
stackAddChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> b
    -- ^ /@child@/: the widget to add
    -> m Gtk.StackPage.StackPage
    -- ^ __Returns:__ the @GtkStackPage@ for /@child@/
stackAddChild stack child = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_stack_add_child stack' child'
    checkUnexpectedReturnNULL "stackAddChild" result
    result' <- (newObject Gtk.StackPage.StackPage) result
    touchManagedPtr stack
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data StackAddChildMethodInfo
instance (signature ~ (b -> m Gtk.StackPage.StackPage), MonadIO m, IsStack a, Gtk.Widget.IsWidget b) => O.OverloadedMethod StackAddChildMethodInfo a signature where
    overloadedMethod = stackAddChild

instance O.OverloadedMethodInfo StackAddChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackAddChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackAddChild"
        })


#endif

-- method Stack::add_named
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name for @child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "StackPage" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_add_named" gtk_stack_add_named :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr Gtk.StackPage.StackPage)

-- | Adds a child to /@stack@/.
-- 
-- The child is identified by the /@name@/.
stackAddNamed ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> b
    -- ^ /@child@/: the widget to add
    -> Maybe (T.Text)
    -- ^ /@name@/: the name for /@child@/
    -> m Gtk.StackPage.StackPage
    -- ^ __Returns:__ the @GtkStackPage@ for /@child@/
stackAddNamed stack child name = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    child' <- unsafeManagedPtrCastPtr child
    maybeName <- case name of
        Nothing -> return FP.nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    result <- gtk_stack_add_named stack' child' maybeName
    checkUnexpectedReturnNULL "stackAddNamed" result
    result' <- (newObject Gtk.StackPage.StackPage) result
    touchManagedPtr stack
    touchManagedPtr child
    freeMem maybeName
    return result'

#if defined(ENABLE_OVERLOADING)
data StackAddNamedMethodInfo
instance (signature ~ (b -> Maybe (T.Text) -> m Gtk.StackPage.StackPage), MonadIO m, IsStack a, Gtk.Widget.IsWidget b) => O.OverloadedMethod StackAddNamedMethodInfo a signature where
    overloadedMethod = stackAddNamed

instance O.OverloadedMethodInfo StackAddNamedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackAddNamed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackAddNamed"
        })


#endif

-- method Stack::add_titled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to add" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name for @child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "title"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a human-readable title for @child"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "StackPage" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_add_titled" gtk_stack_add_titled :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CString ->                              -- name : TBasicType TUTF8
    CString ->                              -- title : TBasicType TUTF8
    IO (Ptr Gtk.StackPage.StackPage)

-- | Adds a child to /@stack@/.
-- 
-- The child is identified by the /@name@/. The /@title@/
-- will be used by @GtkStackSwitcher@ to represent
-- /@child@/ in a tab bar, so it should be short.
stackAddTitled ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> b
    -- ^ /@child@/: the widget to add
    -> Maybe (T.Text)
    -- ^ /@name@/: the name for /@child@/
    -> T.Text
    -- ^ /@title@/: a human-readable title for /@child@/
    -> m Gtk.StackPage.StackPage
    -- ^ __Returns:__ the @GtkStackPage@ for /@child@/
stackAddTitled stack child name title = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    child' <- unsafeManagedPtrCastPtr child
    maybeName <- case name of
        Nothing -> return FP.nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    title' <- textToCString title
    result <- gtk_stack_add_titled stack' child' maybeName title'
    checkUnexpectedReturnNULL "stackAddTitled" result
    result' <- (newObject Gtk.StackPage.StackPage) result
    touchManagedPtr stack
    touchManagedPtr child
    freeMem maybeName
    freeMem title'
    return result'

#if defined(ENABLE_OVERLOADING)
data StackAddTitledMethodInfo
instance (signature ~ (b -> Maybe (T.Text) -> T.Text -> m Gtk.StackPage.StackPage), MonadIO m, IsStack a, Gtk.Widget.IsWidget b) => O.OverloadedMethod StackAddTitledMethodInfo a signature where
    overloadedMethod = stackAddTitled

instance O.OverloadedMethodInfo StackAddTitledMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackAddTitled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackAddTitled"
        })


#endif

-- method Stack::get_child_by_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the child to find"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_get_child_by_name" gtk_stack_get_child_by_name :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    CString ->                              -- name : TBasicType TUTF8
    IO (Ptr Gtk.Widget.Widget)

-- | Finds the child with the name given as the argument.
-- 
-- Returns 'P.Nothing' if there is no child with this name.
stackGetChildByName ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> T.Text
    -- ^ /@name@/: the name of the child to find
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the requested child
    --   of the @GtkStack@
stackGetChildByName stack name = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    name' <- textToCString name
    result <- gtk_stack_get_child_by_name stack' name'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr stack
    freeMem name'
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StackGetChildByNameMethodInfo
instance (signature ~ (T.Text -> m (Maybe Gtk.Widget.Widget)), MonadIO m, IsStack a) => O.OverloadedMethod StackGetChildByNameMethodInfo a signature where
    overloadedMethod = stackGetChildByName

instance O.OverloadedMethodInfo StackGetChildByNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackGetChildByName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackGetChildByName"
        })


#endif

-- method Stack::get_hhomogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_get_hhomogeneous" gtk_stack_get_hhomogeneous :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    IO CInt

-- | Gets whether /@stack@/ is horizontally homogeneous.
stackGetHhomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> m Bool
    -- ^ __Returns:__ whether /@stack@/ is horizontally homogeneous.
stackGetHhomogeneous stack = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    result <- gtk_stack_get_hhomogeneous stack'
    let result' = (/= 0) result
    touchManagedPtr stack
    return result'

#if defined(ENABLE_OVERLOADING)
data StackGetHhomogeneousMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsStack a) => O.OverloadedMethod StackGetHhomogeneousMethodInfo a signature where
    overloadedMethod = stackGetHhomogeneous

instance O.OverloadedMethodInfo StackGetHhomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackGetHhomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackGetHhomogeneous"
        })


#endif

-- method Stack::get_interpolate_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_get_interpolate_size" gtk_stack_get_interpolate_size :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    IO CInt

-- | Returns whether the @GtkStack@ is set up to interpolate between
-- the sizes of children on page switch.
stackGetInterpolateSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: A @GtkStack@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if child sizes are interpolated
stackGetInterpolateSize stack = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    result <- gtk_stack_get_interpolate_size stack'
    let result' = (/= 0) result
    touchManagedPtr stack
    return result'

#if defined(ENABLE_OVERLOADING)
data StackGetInterpolateSizeMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsStack a) => O.OverloadedMethod StackGetInterpolateSizeMethodInfo a signature where
    overloadedMethod = stackGetInterpolateSize

instance O.OverloadedMethodInfo StackGetInterpolateSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackGetInterpolateSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackGetInterpolateSize"
        })


#endif

-- method Stack::get_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child of @stack" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "StackPage" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_get_page" gtk_stack_get_page :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO (Ptr Gtk.StackPage.StackPage)

-- | Returns the @GtkStackPage@ object for /@child@/.
stackGetPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> b
    -- ^ /@child@/: a child of /@stack@/
    -> m Gtk.StackPage.StackPage
    -- ^ __Returns:__ the @GtkStackPage@ for /@child@/
stackGetPage stack child = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_stack_get_page stack' child'
    checkUnexpectedReturnNULL "stackGetPage" result
    result' <- (newObject Gtk.StackPage.StackPage) result
    touchManagedPtr stack
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data StackGetPageMethodInfo
instance (signature ~ (b -> m Gtk.StackPage.StackPage), MonadIO m, IsStack a, Gtk.Widget.IsWidget b) => O.OverloadedMethod StackGetPageMethodInfo a signature where
    overloadedMethod = stackGetPage

instance O.OverloadedMethodInfo StackGetPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackGetPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackGetPage"
        })


#endif

-- method Stack::get_pages
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SelectionModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_get_pages" gtk_stack_get_pages :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    IO (Ptr Gtk.SelectionModel.SelectionModel)

-- | Returns a @GListModel@ that contains the pages of the stack.
-- 
-- This can be used to keep an up-to-date view. The model also
-- implements t'GI.Gtk.Interfaces.SelectionModel.SelectionModel' and can be used to track
-- and modify the visible page.
stackGetPages ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> m Gtk.SelectionModel.SelectionModel
    -- ^ __Returns:__ a @GtkSelectionModel@ for the stack\'s children
stackGetPages stack = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    result <- gtk_stack_get_pages stack'
    checkUnexpectedReturnNULL "stackGetPages" result
    result' <- (wrapObject Gtk.SelectionModel.SelectionModel) result
    touchManagedPtr stack
    return result'

#if defined(ENABLE_OVERLOADING)
data StackGetPagesMethodInfo
instance (signature ~ (m Gtk.SelectionModel.SelectionModel), MonadIO m, IsStack a) => O.OverloadedMethod StackGetPagesMethodInfo a signature where
    overloadedMethod = stackGetPages

instance O.OverloadedMethodInfo StackGetPagesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackGetPages",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackGetPages"
        })


#endif

-- method Stack::get_transition_duration
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_get_transition_duration" gtk_stack_get_transition_duration :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    IO Word32

-- | Returns the amount of time (in milliseconds) that
-- transitions between pages in /@stack@/ will take.
stackGetTransitionDuration ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> m Word32
    -- ^ __Returns:__ the transition duration
stackGetTransitionDuration stack = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    result <- gtk_stack_get_transition_duration stack'
    touchManagedPtr stack
    return result

#if defined(ENABLE_OVERLOADING)
data StackGetTransitionDurationMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsStack a) => O.OverloadedMethod StackGetTransitionDurationMethodInfo a signature where
    overloadedMethod = stackGetTransitionDuration

instance O.OverloadedMethodInfo StackGetTransitionDurationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackGetTransitionDuration",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackGetTransitionDuration"
        })


#endif

-- method Stack::get_transition_running
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_get_transition_running" gtk_stack_get_transition_running :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    IO CInt

-- | Returns whether the /@stack@/ is currently in a transition from one page to
-- another.
stackGetTransitionRunning ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the transition is currently running, 'P.False' otherwise.
stackGetTransitionRunning stack = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    result <- gtk_stack_get_transition_running stack'
    let result' = (/= 0) result
    touchManagedPtr stack
    return result'

#if defined(ENABLE_OVERLOADING)
data StackGetTransitionRunningMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsStack a) => O.OverloadedMethod StackGetTransitionRunningMethodInfo a signature where
    overloadedMethod = stackGetTransitionRunning

instance O.OverloadedMethodInfo StackGetTransitionRunningMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackGetTransitionRunning",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackGetTransitionRunning"
        })


#endif

-- method Stack::get_transition_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "StackTransitionType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_get_transition_type" gtk_stack_get_transition_type :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    IO CUInt

-- | Gets the type of animation that will be used
-- for transitions between pages in /@stack@/.
stackGetTransitionType ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> m Gtk.Enums.StackTransitionType
    -- ^ __Returns:__ the current transition type of /@stack@/
stackGetTransitionType stack = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    result <- gtk_stack_get_transition_type stack'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr stack
    return result'

#if defined(ENABLE_OVERLOADING)
data StackGetTransitionTypeMethodInfo
instance (signature ~ (m Gtk.Enums.StackTransitionType), MonadIO m, IsStack a) => O.OverloadedMethod StackGetTransitionTypeMethodInfo a signature where
    overloadedMethod = stackGetTransitionType

instance O.OverloadedMethodInfo StackGetTransitionTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackGetTransitionType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackGetTransitionType"
        })


#endif

-- method Stack::get_vhomogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_get_vhomogeneous" gtk_stack_get_vhomogeneous :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    IO CInt

-- | Gets whether /@stack@/ is vertically homogeneous.
stackGetVhomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> m Bool
    -- ^ __Returns:__ whether /@stack@/ is vertically homogeneous.
stackGetVhomogeneous stack = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    result <- gtk_stack_get_vhomogeneous stack'
    let result' = (/= 0) result
    touchManagedPtr stack
    return result'

#if defined(ENABLE_OVERLOADING)
data StackGetVhomogeneousMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsStack a) => O.OverloadedMethod StackGetVhomogeneousMethodInfo a signature where
    overloadedMethod = stackGetVhomogeneous

instance O.OverloadedMethodInfo StackGetVhomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackGetVhomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackGetVhomogeneous"
        })


#endif

-- method Stack::get_visible_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_get_visible_child" gtk_stack_get_visible_child :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the currently visible child of /@stack@/.
-- 
-- Returns 'P.Nothing' if there are no visible children.
stackGetVisibleChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the visible child of the @GtkStack@
stackGetVisibleChild stack = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    result <- gtk_stack_get_visible_child stack'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr stack
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StackGetVisibleChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsStack a) => O.OverloadedMethod StackGetVisibleChildMethodInfo a signature where
    overloadedMethod = stackGetVisibleChild

instance O.OverloadedMethodInfo StackGetVisibleChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackGetVisibleChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackGetVisibleChild"
        })


#endif

-- method Stack::get_visible_child_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_get_visible_child_name" gtk_stack_get_visible_child_name :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    IO CString

-- | Returns the name of the currently visible child of /@stack@/.
-- 
-- Returns 'P.Nothing' if there is no visible child.
stackGetVisibleChildName ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the name of the visible child
    --   of the @GtkStack@
stackGetVisibleChildName stack = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    result <- gtk_stack_get_visible_child_name stack'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr stack
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data StackGetVisibleChildNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsStack a) => O.OverloadedMethod StackGetVisibleChildNameMethodInfo a signature where
    overloadedMethod = stackGetVisibleChildName

instance O.OverloadedMethodInfo StackGetVisibleChildNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackGetVisibleChildName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackGetVisibleChildName"
        })


#endif

-- method Stack::remove
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_remove" gtk_stack_remove :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Removes a child widget from /@stack@/.
stackRemove ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> b
    -- ^ /@child@/: the child to remove
    -> m ()
stackRemove stack child = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    child' <- unsafeManagedPtrCastPtr child
    gtk_stack_remove stack' child'
    touchManagedPtr stack
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data StackRemoveMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsStack a, Gtk.Widget.IsWidget b) => O.OverloadedMethod StackRemoveMethodInfo a signature where
    overloadedMethod = stackRemove

instance O.OverloadedMethodInfo StackRemoveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackRemove",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackRemove"
        })


#endif

-- method Stack::set_hhomogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hhomogeneous"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to make @stack horizontally homogeneous"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_set_hhomogeneous" gtk_stack_set_hhomogeneous :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    CInt ->                                 -- hhomogeneous : TBasicType TBoolean
    IO ()

-- | Sets the @GtkStack@ to be horizontally homogeneous or not.
-- 
-- If it is homogeneous, the @GtkStack@ will request the same
-- width for all its children. If it isn\'t, the stack
-- may change width when a different child becomes visible.
stackSetHhomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> Bool
    -- ^ /@hhomogeneous@/: 'P.True' to make /@stack@/ horizontally homogeneous
    -> m ()
stackSetHhomogeneous stack hhomogeneous = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    let hhomogeneous' = (P.fromIntegral . P.fromEnum) hhomogeneous
    gtk_stack_set_hhomogeneous stack' hhomogeneous'
    touchManagedPtr stack
    return ()

#if defined(ENABLE_OVERLOADING)
data StackSetHhomogeneousMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsStack a) => O.OverloadedMethod StackSetHhomogeneousMethodInfo a signature where
    overloadedMethod = stackSetHhomogeneous

instance O.OverloadedMethodInfo StackSetHhomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackSetHhomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackSetHhomogeneous"
        })


#endif

-- method Stack::set_interpolate_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interpolate_size"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_set_interpolate_size" gtk_stack_set_interpolate_size :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    CInt ->                                 -- interpolate_size : TBasicType TBoolean
    IO ()

-- | Sets whether or not /@stack@/ will interpolate its size when
-- changing the visible child.
-- 
-- If the [Stack:interpolateSize]("GI.Gtk.Objects.Stack#g:attr:interpolateSize") property is set
-- to 'P.True', /@stack@/ will interpolate its size between the current
-- one and the one it\'ll take after changing the visible child,
-- according to the set transition duration.
stackSetInterpolateSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: A @GtkStack@
    -> Bool
    -- ^ /@interpolateSize@/: the new value
    -> m ()
stackSetInterpolateSize stack interpolateSize = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    let interpolateSize' = (P.fromIntegral . P.fromEnum) interpolateSize
    gtk_stack_set_interpolate_size stack' interpolateSize'
    touchManagedPtr stack
    return ()

#if defined(ENABLE_OVERLOADING)
data StackSetInterpolateSizeMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsStack a) => O.OverloadedMethod StackSetInterpolateSizeMethodInfo a signature where
    overloadedMethod = stackSetInterpolateSize

instance O.OverloadedMethodInfo StackSetInterpolateSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackSetInterpolateSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackSetInterpolateSize"
        })


#endif

-- method Stack::set_transition_duration
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "duration"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new duration, in milliseconds"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_set_transition_duration" gtk_stack_set_transition_duration :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    Word32 ->                               -- duration : TBasicType TUInt
    IO ()

-- | Sets the duration that transitions between pages in /@stack@/
-- will take.
stackSetTransitionDuration ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> Word32
    -- ^ /@duration@/: the new duration, in milliseconds
    -> m ()
stackSetTransitionDuration stack duration = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    gtk_stack_set_transition_duration stack' duration
    touchManagedPtr stack
    return ()

#if defined(ENABLE_OVERLOADING)
data StackSetTransitionDurationMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsStack a) => O.OverloadedMethod StackSetTransitionDurationMethodInfo a signature where
    overloadedMethod = stackSetTransitionDuration

instance O.OverloadedMethodInfo StackSetTransitionDurationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackSetTransitionDuration",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackSetTransitionDuration"
        })


#endif

-- method Stack::set_transition_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "transition"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "StackTransitionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new transition type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_set_transition_type" gtk_stack_set_transition_type :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    CUInt ->                                -- transition : TInterface (Name {namespace = "Gtk", name = "StackTransitionType"})
    IO ()

-- | Sets the type of animation that will be used for
-- transitions between pages in /@stack@/.
-- 
-- Available types include various kinds of fades and slides.
-- 
-- The transition type can be changed without problems
-- at runtime, so it is possible to change the animation
-- based on the page that is about to become current.
stackSetTransitionType ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> Gtk.Enums.StackTransitionType
    -- ^ /@transition@/: the new transition type
    -> m ()
stackSetTransitionType stack transition = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    let transition' = (fromIntegral . fromEnum) transition
    gtk_stack_set_transition_type stack' transition'
    touchManagedPtr stack
    return ()

#if defined(ENABLE_OVERLOADING)
data StackSetTransitionTypeMethodInfo
instance (signature ~ (Gtk.Enums.StackTransitionType -> m ()), MonadIO m, IsStack a) => O.OverloadedMethod StackSetTransitionTypeMethodInfo a signature where
    overloadedMethod = stackSetTransitionType

instance O.OverloadedMethodInfo StackSetTransitionTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackSetTransitionType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackSetTransitionType"
        })


#endif

-- method Stack::set_vhomogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vhomogeneous"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to make @stack vertically homogeneous"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_set_vhomogeneous" gtk_stack_set_vhomogeneous :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    CInt ->                                 -- vhomogeneous : TBasicType TBoolean
    IO ()

-- | Sets the @GtkStack@ to be vertically homogeneous or not.
-- 
-- If it is homogeneous, the @GtkStack@ will request the same
-- height for all its children. If it isn\'t, the stack
-- may change height when a different child becomes visible.
stackSetVhomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> Bool
    -- ^ /@vhomogeneous@/: 'P.True' to make /@stack@/ vertically homogeneous
    -> m ()
stackSetVhomogeneous stack vhomogeneous = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    let vhomogeneous' = (P.fromIntegral . P.fromEnum) vhomogeneous
    gtk_stack_set_vhomogeneous stack' vhomogeneous'
    touchManagedPtr stack
    return ()

#if defined(ENABLE_OVERLOADING)
data StackSetVhomogeneousMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsStack a) => O.OverloadedMethod StackSetVhomogeneousMethodInfo a signature where
    overloadedMethod = stackSetVhomogeneous

instance O.OverloadedMethodInfo StackSetVhomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackSetVhomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackSetVhomogeneous"
        })


#endif

-- method Stack::set_visible_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a child of @stack" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_set_visible_child" gtk_stack_set_visible_child :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Makes /@child@/ the visible child of /@stack@/.
-- 
-- If /@child@/ is different from the currently visible child,
-- the transition between the two will be animated with the
-- current transition type of /@stack@/.
-- 
-- Note that the /@child@/ widget has to be visible itself
-- (see 'GI.Gtk.Objects.Widget.widgetShow') in order to become the visible
-- child of /@stack@/.
stackSetVisibleChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> b
    -- ^ /@child@/: a child of /@stack@/
    -> m ()
stackSetVisibleChild stack child = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    child' <- unsafeManagedPtrCastPtr child
    gtk_stack_set_visible_child stack' child'
    touchManagedPtr stack
    touchManagedPtr child
    return ()

#if defined(ENABLE_OVERLOADING)
data StackSetVisibleChildMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsStack a, Gtk.Widget.IsWidget b) => O.OverloadedMethod StackSetVisibleChildMethodInfo a signature where
    overloadedMethod = stackSetVisibleChild

instance O.OverloadedMethodInfo StackSetVisibleChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackSetVisibleChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackSetVisibleChild"
        })


#endif

-- method Stack::set_visible_child_full
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the child to make visible"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "transition"
--           , argType =
--               TInterface
--                 Name { namespace = "Gtk" , name = "StackTransitionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the transition type to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_set_visible_child_full" gtk_stack_set_visible_child_full :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    CString ->                              -- name : TBasicType TUTF8
    CUInt ->                                -- transition : TInterface (Name {namespace = "Gtk", name = "StackTransitionType"})
    IO ()

-- | Makes the child with the given name visible.
-- 
-- Note that the child widget has to be visible itself
-- (see 'GI.Gtk.Objects.Widget.widgetShow') in order to become the visible
-- child of /@stack@/.
stackSetVisibleChildFull ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> T.Text
    -- ^ /@name@/: the name of the child to make visible
    -> Gtk.Enums.StackTransitionType
    -- ^ /@transition@/: the transition type to use
    -> m ()
stackSetVisibleChildFull stack name transition = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    name' <- textToCString name
    let transition' = (fromIntegral . fromEnum) transition
    gtk_stack_set_visible_child_full stack' name' transition'
    touchManagedPtr stack
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data StackSetVisibleChildFullMethodInfo
instance (signature ~ (T.Text -> Gtk.Enums.StackTransitionType -> m ()), MonadIO m, IsStack a) => O.OverloadedMethod StackSetVisibleChildFullMethodInfo a signature where
    overloadedMethod = stackSetVisibleChildFull

instance O.OverloadedMethodInfo StackSetVisibleChildFullMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackSetVisibleChildFull",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackSetVisibleChildFull"
        })


#endif

-- method Stack::set_visible_child_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "stack"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Stack" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkStack`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the child to make visible"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_stack_set_visible_child_name" gtk_stack_set_visible_child_name :: 
    Ptr Stack ->                            -- stack : TInterface (Name {namespace = "Gtk", name = "Stack"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Makes the child with the given name visible.
-- 
-- If /@child@/ is different from the currently visible child,
-- the transition between the two will be animated with the
-- current transition type of /@stack@/.
-- 
-- Note that the child widget has to be visible itself
-- (see 'GI.Gtk.Objects.Widget.widgetShow') in order to become the visible
-- child of /@stack@/.
stackSetVisibleChildName ::
    (B.CallStack.HasCallStack, MonadIO m, IsStack a) =>
    a
    -- ^ /@stack@/: a @GtkStack@
    -> T.Text
    -- ^ /@name@/: the name of the child to make visible
    -> m ()
stackSetVisibleChildName stack name = liftIO $ do
    stack' <- unsafeManagedPtrCastPtr stack
    name' <- textToCString name
    gtk_stack_set_visible_child_name stack' name'
    touchManagedPtr stack
    freeMem name'
    return ()

#if defined(ENABLE_OVERLOADING)
data StackSetVisibleChildNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsStack a) => O.OverloadedMethod StackSetVisibleChildNameMethodInfo a signature where
    overloadedMethod = stackSetVisibleChildName

instance O.OverloadedMethodInfo StackSetVisibleChildNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Stack.stackSetVisibleChildName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Stack.html#v:stackSetVisibleChildName"
        })


#endif


