{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Describes sorting criteria for a t'GI.Gtk.Objects.SortListModel.SortListModel'.
-- 
-- Its primary user is t'GI.Gtk.Objects.SortListModel.SortListModel'
-- 
-- The model will use a sorter to determine the order in which
-- its items should appear by calling 'GI.Gtk.Objects.Sorter.sorterCompare'
-- for pairs of items.
-- 
-- Sorters may change their sorting behavior through their lifetime.
-- In that case, they will emit the [Sorter::changed]("GI.Gtk.Objects.Sorter#g:signal:changed") signal
-- to notify that the sort order is no longer valid and should be updated
-- by calling 'GI.Gtk.Objects.Sorter.sorterCompare' again.
-- 
-- GTK provides various pre-made sorter implementations for common sorting
-- operations. t'GI.Gtk.Objects.ColumnView.ColumnView' has built-in support for sorting lists
-- via the [ColumnViewColumn:sorter]("GI.Gtk.Objects.ColumnViewColumn#g:attr:sorter") property, where the user can
-- change the sorting by clicking on list headers.
-- 
-- Of course, in particular for large lists, it is also possible to subclass
-- @GtkSorter@ and provide one\'s own sorter.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Sorter
    ( 

-- * Exported types
    Sorter(..)                              ,
    IsSorter                                ,
    toSorter                                ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [changed]("GI.Gtk.Objects.Sorter#g:method:changed"), [compare]("GI.Gtk.Objects.Sorter#g:method:compare"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getOrder]("GI.Gtk.Objects.Sorter#g:method:getOrder"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSorterMethod                     ,
#endif

-- ** changed #method:changed#

#if defined(ENABLE_OVERLOADING)
    SorterChangedMethodInfo                 ,
#endif
    sorterChanged                           ,


-- ** compare #method:compare#

#if defined(ENABLE_OVERLOADING)
    SorterCompareMethodInfo                 ,
#endif
    sorterCompare                           ,


-- ** getOrder #method:getOrder#

#if defined(ENABLE_OVERLOADING)
    SorterGetOrderMethodInfo                ,
#endif
    sorterGetOrder                          ,




 -- * Signals


-- ** changed #signal:changed#

    SorterChangedCallback                   ,
#if defined(ENABLE_OVERLOADING)
    SorterChangedSignalInfo                 ,
#endif
    afterSorterChanged                      ,
    onSorterChanged                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums

#endif

-- | Memory-managed wrapper type.
newtype Sorter = Sorter (SP.ManagedPtr Sorter)
    deriving (Eq)

instance SP.ManagedPtrNewtype Sorter where
    toManagedPtr (Sorter p) = p

foreign import ccall "gtk_sorter_get_type"
    c_gtk_sorter_get_type :: IO B.Types.GType

instance B.Types.TypedObject Sorter where
    glibType = c_gtk_sorter_get_type

instance B.Types.GObject Sorter

-- | Type class for types which can be safely cast to `Sorter`, for instance with `toSorter`.
class (SP.GObject o, O.IsDescendantOf Sorter o) => IsSorter o
instance (SP.GObject o, O.IsDescendantOf Sorter o) => IsSorter o

instance O.HasParentTypes Sorter
type instance O.ParentTypes Sorter = '[GObject.Object.Object]

-- | Cast to `Sorter`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSorter :: (MIO.MonadIO m, IsSorter o) => o -> m Sorter
toSorter = MIO.liftIO . B.ManagedPtr.unsafeCastTo Sorter

-- | Convert 'Sorter' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Sorter) where
    gvalueGType_ = c_gtk_sorter_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Sorter)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Sorter)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Sorter ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSorterMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSorterMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSorterMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSorterMethod "changed" o = SorterChangedMethodInfo
    ResolveSorterMethod "compare" o = SorterCompareMethodInfo
    ResolveSorterMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSorterMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSorterMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSorterMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSorterMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSorterMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSorterMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSorterMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSorterMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSorterMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSorterMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSorterMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSorterMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSorterMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSorterMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSorterMethod "getOrder" o = SorterGetOrderMethodInfo
    ResolveSorterMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSorterMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSorterMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSorterMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSorterMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSorterMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSorterMethod t Sorter, O.OverloadedMethod info Sorter p) => OL.IsLabel t (Sorter -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSorterMethod t Sorter, O.OverloadedMethod info Sorter p, R.HasField t Sorter p) => R.HasField t Sorter p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSorterMethod t Sorter, O.OverloadedMethodInfo info Sorter) => OL.IsLabel t (O.MethodProxy info Sorter) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Sorter::changed
-- | Emitted whenever the sorter changed.
-- 
-- Users of the sorter should then update the sort order
-- again via 'GI.Gtk.Objects.Sorter.sorterCompare'.
-- 
-- t'GI.Gtk.Objects.SortListModel.SortListModel' handles this signal automatically.
-- 
-- Depending on the /@change@/ parameter, it may be possible to update
-- the sort order without a full resorting. Refer to the
-- t'GI.Gtk.Enums.SorterChange' documentation for details.
type SorterChangedCallback =
    Gtk.Enums.SorterChange
    -- ^ /@change@/: how the sorter changed
    -> IO ()

type C_SorterChangedCallback =
    Ptr Sorter ->                           -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SorterChangedCallback`.
foreign import ccall "wrapper"
    mk_SorterChangedCallback :: C_SorterChangedCallback -> IO (FunPtr C_SorterChangedCallback)

wrap_SorterChangedCallback :: 
    GObject a => (a -> SorterChangedCallback) ->
    C_SorterChangedCallback
wrap_SorterChangedCallback gi'cb gi'selfPtr change _ = do
    let change' = (toEnum . fromIntegral) change
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  change'


-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' sorter #changed callback
-- @
-- 
-- 
onSorterChanged :: (IsSorter a, MonadIO m) => a -> ((?self :: a) => SorterChangedCallback) -> m SignalHandlerId
onSorterChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SorterChangedCallback wrapped
    wrapped'' <- mk_SorterChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [changed](#signal:changed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' sorter #changed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSorterChanged :: (IsSorter a, MonadIO m) => a -> ((?self :: a) => SorterChangedCallback) -> m SignalHandlerId
afterSorterChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SorterChangedCallback wrapped
    wrapped'' <- mk_SorterChangedCallback wrapped'
    connectSignalFunPtr obj "changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SorterChangedSignalInfo
instance SignalInfo SorterChangedSignalInfo where
    type HaskellCallbackType SorterChangedSignalInfo = SorterChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SorterChangedCallback cb
        cb'' <- mk_SorterChangedCallback cb'
        connectSignalFunPtr obj "changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Sorter::changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Sorter.html#g:signal:changed"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Sorter
type instance O.AttributeList Sorter = SorterAttributeList
type SorterAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Sorter = SorterSignalList
type SorterSignalList = ('[ '("changed", SorterChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Sorter::changed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Sorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSorter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "change"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SorterChange" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "How the sorter changed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_sorter_changed" gtk_sorter_changed :: 
    Ptr Sorter ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Sorter"})
    CUInt ->                                -- change : TInterface (Name {namespace = "Gtk", name = "SorterChange"})
    IO ()

-- | Notifies all users of the sorter that it has changed.
-- 
-- This emits the [Sorter::changed]("GI.Gtk.Objects.Sorter#g:signal:changed") signal. Users
-- of the sorter should then update the sort order via
-- 'GI.Gtk.Objects.Sorter.sorterCompare'.
-- 
-- Depending on the /@change@/ parameter, it may be possible to
-- update the sort order without a full resorting. Refer to
-- the t'GI.Gtk.Enums.SorterChange' documentation for details.
-- 
-- This function is intended for implementers of @GtkSorter@
-- subclasses and should not be called from other functions.
sorterChanged ::
    (B.CallStack.HasCallStack, MonadIO m, IsSorter a) =>
    a
    -- ^ /@self@/: a @GtkSorter@
    -> Gtk.Enums.SorterChange
    -- ^ /@change@/: How the sorter changed
    -> m ()
sorterChanged self change = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let change' = (fromIntegral . fromEnum) change
    gtk_sorter_changed self' change'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data SorterChangedMethodInfo
instance (signature ~ (Gtk.Enums.SorterChange -> m ()), MonadIO m, IsSorter a) => O.OverloadedMethod SorterChangedMethodInfo a signature where
    overloadedMethod = sorterChanged

instance O.OverloadedMethodInfo SorterChangedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Sorter.sorterChanged",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Sorter.html#v:sorterChanged"
        })


#endif

-- method Sorter::compare
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Sorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSorter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item1"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "first item to compare"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "item2"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "second item to compare"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Ordering" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_sorter_compare" gtk_sorter_compare :: 
    Ptr Sorter ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Sorter"})
    Ptr GObject.Object.Object ->            -- item1 : TInterface (Name {namespace = "GObject", name = "Object"})
    Ptr GObject.Object.Object ->            -- item2 : TInterface (Name {namespace = "GObject", name = "Object"})
    IO CInt

-- | Compares two given items according to the sort order implemented
-- by the sorter.
-- 
-- Sorters implement a partial order:
-- 
-- * It is reflexive, ie a = a
-- * It is antisymmetric, ie if a \< b and b \< a, then a = b
-- * It is transitive, ie given any 3 items with a ≤ b and b ≤ c,
--   then a ≤ c
-- 
-- The sorter may signal it conforms to additional constraints
-- via the return value of 'GI.Gtk.Objects.Sorter.sorterGetOrder'.
sorterCompare ::
    (B.CallStack.HasCallStack, MonadIO m, IsSorter a, GObject.Object.IsObject b, GObject.Object.IsObject c) =>
    a
    -- ^ /@self@/: a @GtkSorter@
    -> b
    -- ^ /@item1@/: first item to compare
    -> c
    -- ^ /@item2@/: second item to compare
    -> m Gtk.Enums.Ordering
    -- ^ __Returns:__ 'GI.Gtk.Enums.OrderingEqual' if /@item1@/ == /@item2@/,
    --   'GI.Gtk.Enums.OrderingSmaller' if /@item1@/ \< /@item2@/,
    --   'GI.Gtk.Enums.OrderingLarger' if /@item1@/ > /@item2@/
sorterCompare self item1 item2 = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    item1' <- unsafeManagedPtrCastPtr item1
    item2' <- unsafeManagedPtrCastPtr item2
    result <- gtk_sorter_compare self' item1' item2'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    touchManagedPtr item1
    touchManagedPtr item2
    return result'

#if defined(ENABLE_OVERLOADING)
data SorterCompareMethodInfo
instance (signature ~ (b -> c -> m Gtk.Enums.Ordering), MonadIO m, IsSorter a, GObject.Object.IsObject b, GObject.Object.IsObject c) => O.OverloadedMethod SorterCompareMethodInfo a signature where
    overloadedMethod = sorterCompare

instance O.OverloadedMethodInfo SorterCompareMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Sorter.sorterCompare",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Sorter.html#v:sorterCompare"
        })


#endif

-- method Sorter::get_order
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Sorter" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSorter`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "SorterOrder" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_sorter_get_order" gtk_sorter_get_order :: 
    Ptr Sorter ->                           -- self : TInterface (Name {namespace = "Gtk", name = "Sorter"})
    IO CUInt

-- | Gets the order that /@self@/ conforms to.
-- 
-- See t'GI.Gtk.Enums.SorterOrder' for details
-- of the possible return values.
-- 
-- This function is intended to allow optimizations.
sorterGetOrder ::
    (B.CallStack.HasCallStack, MonadIO m, IsSorter a) =>
    a
    -- ^ /@self@/: a @GtkSorter@
    -> m Gtk.Enums.SorterOrder
    -- ^ __Returns:__ The order
sorterGetOrder self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_sorter_get_order self'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data SorterGetOrderMethodInfo
instance (signature ~ (m Gtk.Enums.SorterOrder), MonadIO m, IsSorter a) => O.OverloadedMethod SorterGetOrderMethodInfo a signature where
    overloadedMethod = sorterGetOrder

instance O.OverloadedMethodInfo SorterGetOrderMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Sorter.sorterGetOrder",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Sorter.html#v:sorterGetOrder"
        })


#endif


