{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A list model that presents a slice of another model.
-- 
-- This is useful when implementing paging by setting the size to the number
-- of elements per page and updating the offset whenever a different page is
-- opened.
-- 
-- @GtkSliceListModel@ passes through sections from the underlying model.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.SliceListModel
    ( 

-- * Exported types
    SliceListModel(..)                      ,
    IsSliceListModel                        ,
    toSliceListModel                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [sectionsChanged]("GI.Gtk.Interfaces.SectionModel#g:method:sectionsChanged"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getModel]("GI.Gtk.Objects.SliceListModel#g:method:getModel"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getOffset]("GI.Gtk.Objects.SliceListModel#g:method:getOffset"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSection]("GI.Gtk.Interfaces.SectionModel#g:method:getSection"), [getSize]("GI.Gtk.Objects.SliceListModel#g:method:getSize").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setModel]("GI.Gtk.Objects.SliceListModel#g:method:setModel"), [setOffset]("GI.Gtk.Objects.SliceListModel#g:method:setOffset"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSize]("GI.Gtk.Objects.SliceListModel#g:method:setSize").

#if defined(ENABLE_OVERLOADING)
    ResolveSliceListModelMethod             ,
#endif

-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    SliceListModelGetModelMethodInfo        ,
#endif
    sliceListModelGetModel                  ,


-- ** getOffset #method:getOffset#

#if defined(ENABLE_OVERLOADING)
    SliceListModelGetOffsetMethodInfo       ,
#endif
    sliceListModelGetOffset                 ,


-- ** getSize #method:getSize#

#if defined(ENABLE_OVERLOADING)
    SliceListModelGetSizeMethodInfo         ,
#endif
    sliceListModelGetSize                   ,


-- ** new #method:new#

    sliceListModelNew                       ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    SliceListModelSetModelMethodInfo        ,
#endif
    sliceListModelSetModel                  ,


-- ** setOffset #method:setOffset#

#if defined(ENABLE_OVERLOADING)
    SliceListModelSetOffsetMethodInfo       ,
#endif
    sliceListModelSetOffset                 ,


-- ** setSize #method:setSize#

#if defined(ENABLE_OVERLOADING)
    SliceListModelSetSizeMethodInfo         ,
#endif
    sliceListModelSetSize                   ,




 -- * Properties


-- ** itemType #attr:itemType#
-- | The type of items. See 'GI.Gio.Interfaces.ListModel.listModelGetItemType'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    SliceListModelItemTypePropertyInfo      ,
#endif
    getSliceListModelItemType               ,
#if defined(ENABLE_OVERLOADING)
    sliceListModelItemType                  ,
#endif


-- ** model #attr:model#
-- | Child model to take slice from.

#if defined(ENABLE_OVERLOADING)
    SliceListModelModelPropertyInfo         ,
#endif
    clearSliceListModelModel                ,
    constructSliceListModelModel            ,
    getSliceListModelModel                  ,
    setSliceListModelModel                  ,
#if defined(ENABLE_OVERLOADING)
    sliceListModelModel                     ,
#endif


-- ** nItems #attr:nItems#
-- | The number of items. See 'GI.Gio.Interfaces.ListModel.listModelGetNItems'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    SliceListModelNItemsPropertyInfo        ,
#endif
    getSliceListModelNItems                 ,
#if defined(ENABLE_OVERLOADING)
    sliceListModelNItems                    ,
#endif


-- ** offset #attr:offset#
-- | Offset of slice.

#if defined(ENABLE_OVERLOADING)
    SliceListModelOffsetPropertyInfo        ,
#endif
    constructSliceListModelOffset           ,
    getSliceListModelOffset                 ,
    setSliceListModelOffset                 ,
#if defined(ENABLE_OVERLOADING)
    sliceListModelOffset                    ,
#endif


-- ** size #attr:size#
-- | Maximum size of slice.

#if defined(ENABLE_OVERLOADING)
    SliceListModelSizePropertyInfo          ,
#endif
    constructSliceListModelSize             ,
    getSliceListModelSize                   ,
    setSliceListModelSize                   ,
#if defined(ENABLE_OVERLOADING)
    sliceListModelSize                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SectionModel as Gtk.SectionModel

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SectionModel as Gtk.SectionModel

#endif

-- | Memory-managed wrapper type.
newtype SliceListModel = SliceListModel (SP.ManagedPtr SliceListModel)
    deriving (Eq)

instance SP.ManagedPtrNewtype SliceListModel where
    toManagedPtr (SliceListModel p) = p

foreign import ccall "gtk_slice_list_model_get_type"
    c_gtk_slice_list_model_get_type :: IO B.Types.GType

instance B.Types.TypedObject SliceListModel where
    glibType = c_gtk_slice_list_model_get_type

instance B.Types.GObject SliceListModel

-- | Type class for types which can be safely cast to `SliceListModel`, for instance with `toSliceListModel`.
class (SP.GObject o, O.IsDescendantOf SliceListModel o) => IsSliceListModel o
instance (SP.GObject o, O.IsDescendantOf SliceListModel o) => IsSliceListModel o

instance O.HasParentTypes SliceListModel
type instance O.ParentTypes SliceListModel = '[GObject.Object.Object, Gio.ListModel.ListModel, Gtk.SectionModel.SectionModel]

-- | Cast to `SliceListModel`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSliceListModel :: (MIO.MonadIO m, IsSliceListModel o) => o -> m SliceListModel
toSliceListModel = MIO.liftIO . B.ManagedPtr.unsafeCastTo SliceListModel

-- | Convert 'SliceListModel' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SliceListModel) where
    gvalueGType_ = c_gtk_slice_list_model_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SliceListModel)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SliceListModel)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SliceListModel ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSliceListModelMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSliceListModelMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSliceListModelMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSliceListModelMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSliceListModelMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSliceListModelMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSliceListModelMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSliceListModelMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveSliceListModelMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSliceListModelMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSliceListModelMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSliceListModelMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSliceListModelMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSliceListModelMethod "sectionsChanged" o = Gtk.SectionModel.SectionModelSectionsChangedMethodInfo
    ResolveSliceListModelMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSliceListModelMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSliceListModelMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSliceListModelMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSliceListModelMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSliceListModelMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSliceListModelMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveSliceListModelMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveSliceListModelMethod "getModel" o = SliceListModelGetModelMethodInfo
    ResolveSliceListModelMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveSliceListModelMethod "getOffset" o = SliceListModelGetOffsetMethodInfo
    ResolveSliceListModelMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSliceListModelMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSliceListModelMethod "getSection" o = Gtk.SectionModel.SectionModelGetSectionMethodInfo
    ResolveSliceListModelMethod "getSize" o = SliceListModelGetSizeMethodInfo
    ResolveSliceListModelMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSliceListModelMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSliceListModelMethod "setModel" o = SliceListModelSetModelMethodInfo
    ResolveSliceListModelMethod "setOffset" o = SliceListModelSetOffsetMethodInfo
    ResolveSliceListModelMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSliceListModelMethod "setSize" o = SliceListModelSetSizeMethodInfo
    ResolveSliceListModelMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSliceListModelMethod t SliceListModel, O.OverloadedMethod info SliceListModel p) => OL.IsLabel t (SliceListModel -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSliceListModelMethod t SliceListModel, O.OverloadedMethod info SliceListModel p, R.HasField t SliceListModel p) => R.HasField t SliceListModel p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSliceListModelMethod t SliceListModel, O.OverloadedMethodInfo info SliceListModel) => OL.IsLabel t (O.MethodProxy info SliceListModel) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' sliceListModel #itemType
-- @
getSliceListModelItemType :: (MonadIO m, IsSliceListModel o) => o -> m GType
getSliceListModelItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data SliceListModelItemTypePropertyInfo
instance AttrInfo SliceListModelItemTypePropertyInfo where
    type AttrAllowedOps SliceListModelItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint SliceListModelItemTypePropertyInfo = IsSliceListModel
    type AttrSetTypeConstraint SliceListModelItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint SliceListModelItemTypePropertyInfo = (~) ()
    type AttrTransferType SliceListModelItemTypePropertyInfo = ()
    type AttrGetType SliceListModelItemTypePropertyInfo = GType
    type AttrLabel SliceListModelItemTypePropertyInfo = "item-type"
    type AttrOrigin SliceListModelItemTypePropertyInfo = SliceListModel
    attrGet = getSliceListModelItemType
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SliceListModel.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SliceListModel.html#g:attr:itemType"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' sliceListModel #model
-- @
getSliceListModelModel :: (MonadIO m, IsSliceListModel o) => o -> m (Maybe Gio.ListModel.ListModel)
getSliceListModelModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gio.ListModel.ListModel

-- | Set the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' sliceListModel [ #model 'Data.GI.Base.Attributes.:=' value ]
-- @
setSliceListModelModel :: (MonadIO m, IsSliceListModel o, Gio.ListModel.IsListModel a) => o -> a -> m ()
setSliceListModelModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "model" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSliceListModelModel :: (IsSliceListModel o, MIO.MonadIO m, Gio.ListModel.IsListModel a) => a -> m (GValueConstruct o)
constructSliceListModelModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

-- | Set the value of the “@model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #model
-- @
clearSliceListModelModel :: (MonadIO m, IsSliceListModel o) => o -> m ()
clearSliceListModelModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "model" (Nothing :: Maybe Gio.ListModel.ListModel)

#if defined(ENABLE_OVERLOADING)
data SliceListModelModelPropertyInfo
instance AttrInfo SliceListModelModelPropertyInfo where
    type AttrAllowedOps SliceListModelModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SliceListModelModelPropertyInfo = IsSliceListModel
    type AttrSetTypeConstraint SliceListModelModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferTypeConstraint SliceListModelModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferType SliceListModelModelPropertyInfo = Gio.ListModel.ListModel
    type AttrGetType SliceListModelModelPropertyInfo = (Maybe Gio.ListModel.ListModel)
    type AttrLabel SliceListModelModelPropertyInfo = "model"
    type AttrOrigin SliceListModelModelPropertyInfo = SliceListModel
    attrGet = getSliceListModelModel
    attrSet = setSliceListModelModel
    attrTransfer _ v = do
        unsafeCastTo Gio.ListModel.ListModel v
    attrConstruct = constructSliceListModelModel
    attrClear = clearSliceListModelModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SliceListModel.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SliceListModel.html#g:attr:model"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' sliceListModel #nItems
-- @
getSliceListModelNItems :: (MonadIO m, IsSliceListModel o) => o -> m Word32
getSliceListModelNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data SliceListModelNItemsPropertyInfo
instance AttrInfo SliceListModelNItemsPropertyInfo where
    type AttrAllowedOps SliceListModelNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint SliceListModelNItemsPropertyInfo = IsSliceListModel
    type AttrSetTypeConstraint SliceListModelNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint SliceListModelNItemsPropertyInfo = (~) ()
    type AttrTransferType SliceListModelNItemsPropertyInfo = ()
    type AttrGetType SliceListModelNItemsPropertyInfo = Word32
    type AttrLabel SliceListModelNItemsPropertyInfo = "n-items"
    type AttrOrigin SliceListModelNItemsPropertyInfo = SliceListModel
    attrGet = getSliceListModelNItems
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SliceListModel.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SliceListModel.html#g:attr:nItems"
        })
#endif

-- VVV Prop "offset"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@offset@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' sliceListModel #offset
-- @
getSliceListModelOffset :: (MonadIO m, IsSliceListModel o) => o -> m Word32
getSliceListModelOffset obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "offset"

-- | Set the value of the “@offset@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' sliceListModel [ #offset 'Data.GI.Base.Attributes.:=' value ]
-- @
setSliceListModelOffset :: (MonadIO m, IsSliceListModel o) => o -> Word32 -> m ()
setSliceListModelOffset obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "offset" val

-- | Construct a `GValueConstruct` with valid value for the “@offset@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSliceListModelOffset :: (IsSliceListModel o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructSliceListModelOffset val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "offset" val

#if defined(ENABLE_OVERLOADING)
data SliceListModelOffsetPropertyInfo
instance AttrInfo SliceListModelOffsetPropertyInfo where
    type AttrAllowedOps SliceListModelOffsetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SliceListModelOffsetPropertyInfo = IsSliceListModel
    type AttrSetTypeConstraint SliceListModelOffsetPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint SliceListModelOffsetPropertyInfo = (~) Word32
    type AttrTransferType SliceListModelOffsetPropertyInfo = Word32
    type AttrGetType SliceListModelOffsetPropertyInfo = Word32
    type AttrLabel SliceListModelOffsetPropertyInfo = "offset"
    type AttrOrigin SliceListModelOffsetPropertyInfo = SliceListModel
    attrGet = getSliceListModelOffset
    attrSet = setSliceListModelOffset
    attrTransfer _ v = do
        return v
    attrConstruct = constructSliceListModelOffset
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SliceListModel.offset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SliceListModel.html#g:attr:offset"
        })
#endif

-- VVV Prop "size"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' sliceListModel #size
-- @
getSliceListModelSize :: (MonadIO m, IsSliceListModel o) => o -> m Word32
getSliceListModelSize obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "size"

-- | Set the value of the “@size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' sliceListModel [ #size 'Data.GI.Base.Attributes.:=' value ]
-- @
setSliceListModelSize :: (MonadIO m, IsSliceListModel o) => o -> Word32 -> m ()
setSliceListModelSize obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "size" val

-- | Construct a `GValueConstruct` with valid value for the “@size@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSliceListModelSize :: (IsSliceListModel o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructSliceListModelSize val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "size" val

#if defined(ENABLE_OVERLOADING)
data SliceListModelSizePropertyInfo
instance AttrInfo SliceListModelSizePropertyInfo where
    type AttrAllowedOps SliceListModelSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SliceListModelSizePropertyInfo = IsSliceListModel
    type AttrSetTypeConstraint SliceListModelSizePropertyInfo = (~) Word32
    type AttrTransferTypeConstraint SliceListModelSizePropertyInfo = (~) Word32
    type AttrTransferType SliceListModelSizePropertyInfo = Word32
    type AttrGetType SliceListModelSizePropertyInfo = Word32
    type AttrLabel SliceListModelSizePropertyInfo = "size"
    type AttrOrigin SliceListModelSizePropertyInfo = SliceListModel
    attrGet = getSliceListModelSize
    attrSet = setSliceListModelSize
    attrTransfer _ v = do
        return v
    attrConstruct = constructSliceListModelSize
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SliceListModel.size"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SliceListModel.html#g:attr:size"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SliceListModel
type instance O.AttributeList SliceListModel = SliceListModelAttributeList
type SliceListModelAttributeList = ('[ '("itemType", SliceListModelItemTypePropertyInfo), '("model", SliceListModelModelPropertyInfo), '("nItems", SliceListModelNItemsPropertyInfo), '("offset", SliceListModelOffsetPropertyInfo), '("size", SliceListModelSizePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
sliceListModelItemType :: AttrLabelProxy "itemType"
sliceListModelItemType = AttrLabelProxy

sliceListModelModel :: AttrLabelProxy "model"
sliceListModelModel = AttrLabelProxy

sliceListModelNItems :: AttrLabelProxy "nItems"
sliceListModelNItems = AttrLabelProxy

sliceListModelOffset :: AttrLabelProxy "offset"
sliceListModelOffset = AttrLabelProxy

sliceListModelSize :: AttrLabelProxy "size"
sliceListModelSize = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SliceListModel = SliceListModelSignalList
type SliceListModelSignalList = ('[ '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("sectionsChanged", Gtk.SectionModel.SectionModelSectionsChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SliceListModel::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The model to use" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "offset"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the offset of the slice"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "maximum size of the slice"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SliceListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_slice_list_model_new" gtk_slice_list_model_new :: 
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    Word32 ->                               -- offset : TBasicType TUInt
    Word32 ->                               -- size : TBasicType TUInt
    IO (Ptr SliceListModel)

-- | Creates a new slice model.
-- 
-- It presents the slice from /@offset@/ to offset + /@size@/
-- of the given /@model@/.
sliceListModelNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.ListModel.IsListModel a) =>
    Maybe (a)
    -- ^ /@model@/: The model to use
    -> Word32
    -- ^ /@offset@/: the offset of the slice
    -> Word32
    -- ^ /@size@/: maximum size of the slice
    -> m SliceListModel
    -- ^ __Returns:__ A new @GtkSliceListModel@
sliceListModelNew model offset size = liftIO $ do
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- B.ManagedPtr.disownObject jModel
            return jModel'
    result <- gtk_slice_list_model_new maybeModel offset size
    checkUnexpectedReturnNULL "sliceListModelNew" result
    result' <- (wrapObject SliceListModel) result
    whenJust model touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SliceListModel::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SliceListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSliceListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_slice_list_model_get_model" gtk_slice_list_model_get_model :: 
    Ptr SliceListModel ->                   -- self : TInterface (Name {namespace = "Gtk", name = "SliceListModel"})
    IO (Ptr Gio.ListModel.ListModel)

-- | Gets the model that is currently being used or 'P.Nothing' if none.
sliceListModelGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsSliceListModel a) =>
    a
    -- ^ /@self@/: a @GtkSliceListModel@
    -> m (Maybe Gio.ListModel.ListModel)
    -- ^ __Returns:__ The model in use
sliceListModelGetModel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_slice_list_model_get_model self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.ListModel.ListModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SliceListModelGetModelMethodInfo
instance (signature ~ (m (Maybe Gio.ListModel.ListModel)), MonadIO m, IsSliceListModel a) => O.OverloadedMethod SliceListModelGetModelMethodInfo a signature where
    overloadedMethod = sliceListModelGetModel

instance O.OverloadedMethodInfo SliceListModelGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SliceListModel.sliceListModelGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SliceListModel.html#v:sliceListModelGetModel"
        })


#endif

-- method SliceListModel::get_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SliceListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSliceListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_slice_list_model_get_offset" gtk_slice_list_model_get_offset :: 
    Ptr SliceListModel ->                   -- self : TInterface (Name {namespace = "Gtk", name = "SliceListModel"})
    IO Word32

-- | Gets the offset set via 'GI.Gtk.Objects.SliceListModel.sliceListModelSetOffset'.
sliceListModelGetOffset ::
    (B.CallStack.HasCallStack, MonadIO m, IsSliceListModel a) =>
    a
    -- ^ /@self@/: a @GtkSliceListModel@
    -> m Word32
    -- ^ __Returns:__ The offset
sliceListModelGetOffset self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_slice_list_model_get_offset self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data SliceListModelGetOffsetMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsSliceListModel a) => O.OverloadedMethod SliceListModelGetOffsetMethodInfo a signature where
    overloadedMethod = sliceListModelGetOffset

instance O.OverloadedMethodInfo SliceListModelGetOffsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SliceListModel.sliceListModelGetOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SliceListModel.html#v:sliceListModelGetOffset"
        })


#endif

-- method SliceListModel::get_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SliceListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSliceListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_slice_list_model_get_size" gtk_slice_list_model_get_size :: 
    Ptr SliceListModel ->                   -- self : TInterface (Name {namespace = "Gtk", name = "SliceListModel"})
    IO Word32

-- | Gets the size set via 'GI.Gtk.Objects.SliceListModel.sliceListModelSetSize'.
sliceListModelGetSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsSliceListModel a) =>
    a
    -- ^ /@self@/: a @GtkSliceListModel@
    -> m Word32
    -- ^ __Returns:__ The size
sliceListModelGetSize self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_slice_list_model_get_size self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data SliceListModelGetSizeMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsSliceListModel a) => O.OverloadedMethod SliceListModelGetSizeMethodInfo a signature where
    overloadedMethod = sliceListModelGetSize

instance O.OverloadedMethodInfo SliceListModelGetSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SliceListModel.sliceListModelGetSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SliceListModel.html#v:sliceListModelGetSize"
        })


#endif

-- method SliceListModel::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SliceListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSliceListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The model to be sliced"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_slice_list_model_set_model" gtk_slice_list_model_set_model :: 
    Ptr SliceListModel ->                   -- self : TInterface (Name {namespace = "Gtk", name = "SliceListModel"})
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    IO ()

-- | Sets the model to show a slice of.
-- 
-- The model\'s item type must conform to /@self@/\'s item type.
sliceListModelSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsSliceListModel a, Gio.ListModel.IsListModel b) =>
    a
    -- ^ /@self@/: a @GtkSliceListModel@
    -> Maybe (b)
    -- ^ /@model@/: The model to be sliced
    -> m ()
sliceListModelSetModel self model = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_slice_list_model_set_model self' maybeModel
    touchManagedPtr self
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SliceListModelSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsSliceListModel a, Gio.ListModel.IsListModel b) => O.OverloadedMethod SliceListModelSetModelMethodInfo a signature where
    overloadedMethod = sliceListModelSetModel

instance O.OverloadedMethodInfo SliceListModelSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SliceListModel.sliceListModelSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SliceListModel.html#v:sliceListModelSetModel"
        })


#endif

-- method SliceListModel::set_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SliceListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSliceListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "offset"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new offset to use"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_slice_list_model_set_offset" gtk_slice_list_model_set_offset :: 
    Ptr SliceListModel ->                   -- self : TInterface (Name {namespace = "Gtk", name = "SliceListModel"})
    Word32 ->                               -- offset : TBasicType TUInt
    IO ()

-- | Sets the offset into the original model for this slice.
-- 
-- If the offset is too large for the sliced model,
-- /@self@/ will end up empty.
sliceListModelSetOffset ::
    (B.CallStack.HasCallStack, MonadIO m, IsSliceListModel a) =>
    a
    -- ^ /@self@/: a @GtkSliceListModel@
    -> Word32
    -- ^ /@offset@/: the new offset to use
    -> m ()
sliceListModelSetOffset self offset = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_slice_list_model_set_offset self' offset
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data SliceListModelSetOffsetMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsSliceListModel a) => O.OverloadedMethod SliceListModelSetOffsetMethodInfo a signature where
    overloadedMethod = sliceListModelSetOffset

instance O.OverloadedMethodInfo SliceListModelSetOffsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SliceListModel.sliceListModelSetOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SliceListModel.html#v:sliceListModelSetOffset"
        })


#endif

-- method SliceListModel::set_size
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SliceListModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSliceListModel`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "size"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the maximum size" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_slice_list_model_set_size" gtk_slice_list_model_set_size :: 
    Ptr SliceListModel ->                   -- self : TInterface (Name {namespace = "Gtk", name = "SliceListModel"})
    Word32 ->                               -- size : TBasicType TUInt
    IO ()

-- | Sets the maximum size. /@self@/ will never have more items
-- than /@size@/.
-- 
-- It can however have fewer items if the offset is too large
-- or the model sliced from doesn\'t have enough items.
sliceListModelSetSize ::
    (B.CallStack.HasCallStack, MonadIO m, IsSliceListModel a) =>
    a
    -- ^ /@self@/: a @GtkSliceListModel@
    -> Word32
    -- ^ /@size@/: the maximum size
    -> m ()
sliceListModelSetSize self size = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_slice_list_model_set_size self' size
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data SliceListModelSetSizeMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsSliceListModel a) => O.OverloadedMethod SliceListModelSetSizeMethodInfo a signature where
    overloadedMethod = sliceListModelSetSize

instance O.OverloadedMethodInfo SliceListModelSetSizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SliceListModel.sliceListModelSetSize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SliceListModel.html#v:sliceListModelSetSize"
        })


#endif


