{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A selection model that allows selecting a single item.
-- 
-- Note that the selection is *persistent* -- if the selected item is removed
-- and re-added in the same [ListModel::itemsChanged]("GI.Gio.Interfaces.ListModel#g:signal:itemsChanged") emission, it
-- stays selected. In particular, this means that changing the sort order of an
-- underlying sort model will preserve the selection.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.SingleSelection
    ( 

-- * Exported types
    SingleSelection(..)                     ,
    IsSingleSelection                       ,
    toSingleSelection                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isSelected]("GI.Gtk.Interfaces.SelectionModel#g:method:isSelected"), [itemsChanged]("GI.Gio.Interfaces.ListModel#g:method:itemsChanged"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [sectionsChanged]("GI.Gtk.Interfaces.SectionModel#g:method:sectionsChanged"), [selectAll]("GI.Gtk.Interfaces.SelectionModel#g:method:selectAll"), [selectItem]("GI.Gtk.Interfaces.SelectionModel#g:method:selectItem"), [selectRange]("GI.Gtk.Interfaces.SelectionModel#g:method:selectRange"), [selectionChanged]("GI.Gtk.Interfaces.SelectionModel#g:method:selectionChanged"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unselectAll]("GI.Gtk.Interfaces.SelectionModel#g:method:unselectAll"), [unselectItem]("GI.Gtk.Interfaces.SelectionModel#g:method:unselectItem"), [unselectRange]("GI.Gtk.Interfaces.SelectionModel#g:method:unselectRange"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAutoselect]("GI.Gtk.Objects.SingleSelection#g:method:getAutoselect"), [getCanUnselect]("GI.Gtk.Objects.SingleSelection#g:method:getCanUnselect"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getItem]("GI.Gio.Interfaces.ListModel#g:method:getItem"), [getItemType]("GI.Gio.Interfaces.ListModel#g:method:getItemType"), [getModel]("GI.Gtk.Objects.SingleSelection#g:method:getModel"), [getNItems]("GI.Gio.Interfaces.ListModel#g:method:getNItems"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSection]("GI.Gtk.Interfaces.SectionModel#g:method:getSection"), [getSelected]("GI.Gtk.Objects.SingleSelection#g:method:getSelected"), [getSelectedItem]("GI.Gtk.Objects.SingleSelection#g:method:getSelectedItem"), [getSelection]("GI.Gtk.Interfaces.SelectionModel#g:method:getSelection"), [getSelectionInRange]("GI.Gtk.Interfaces.SelectionModel#g:method:getSelectionInRange").
-- 
-- ==== Setters
-- [setAutoselect]("GI.Gtk.Objects.SingleSelection#g:method:setAutoselect"), [setCanUnselect]("GI.Gtk.Objects.SingleSelection#g:method:setCanUnselect"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setModel]("GI.Gtk.Objects.SingleSelection#g:method:setModel"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSelected]("GI.Gtk.Objects.SingleSelection#g:method:setSelected"), [setSelection]("GI.Gtk.Interfaces.SelectionModel#g:method:setSelection").

#if defined(ENABLE_OVERLOADING)
    ResolveSingleSelectionMethod            ,
#endif

-- ** getAutoselect #method:getAutoselect#

#if defined(ENABLE_OVERLOADING)
    SingleSelectionGetAutoselectMethodInfo  ,
#endif
    singleSelectionGetAutoselect            ,


-- ** getCanUnselect #method:getCanUnselect#

#if defined(ENABLE_OVERLOADING)
    SingleSelectionGetCanUnselectMethodInfo ,
#endif
    singleSelectionGetCanUnselect           ,


-- ** getModel #method:getModel#

#if defined(ENABLE_OVERLOADING)
    SingleSelectionGetModelMethodInfo       ,
#endif
    singleSelectionGetModel                 ,


-- ** getSelected #method:getSelected#

#if defined(ENABLE_OVERLOADING)
    SingleSelectionGetSelectedMethodInfo    ,
#endif
    singleSelectionGetSelected              ,


-- ** getSelectedItem #method:getSelectedItem#

#if defined(ENABLE_OVERLOADING)
    SingleSelectionGetSelectedItemMethodInfo,
#endif
    singleSelectionGetSelectedItem          ,


-- ** new #method:new#

    singleSelectionNew                      ,


-- ** setAutoselect #method:setAutoselect#

#if defined(ENABLE_OVERLOADING)
    SingleSelectionSetAutoselectMethodInfo  ,
#endif
    singleSelectionSetAutoselect            ,


-- ** setCanUnselect #method:setCanUnselect#

#if defined(ENABLE_OVERLOADING)
    SingleSelectionSetCanUnselectMethodInfo ,
#endif
    singleSelectionSetCanUnselect           ,


-- ** setModel #method:setModel#

#if defined(ENABLE_OVERLOADING)
    SingleSelectionSetModelMethodInfo       ,
#endif
    singleSelectionSetModel                 ,


-- ** setSelected #method:setSelected#

#if defined(ENABLE_OVERLOADING)
    SingleSelectionSetSelectedMethodInfo    ,
#endif
    singleSelectionSetSelected              ,




 -- * Properties


-- ** autoselect #attr:autoselect#
-- | If the selection will always select an item.

#if defined(ENABLE_OVERLOADING)
    SingleSelectionAutoselectPropertyInfo   ,
#endif
    constructSingleSelectionAutoselect      ,
    getSingleSelectionAutoselect            ,
    setSingleSelectionAutoselect            ,
#if defined(ENABLE_OVERLOADING)
    singleSelectionAutoselect               ,
#endif


-- ** canUnselect #attr:canUnselect#
-- | If unselecting the selected item is allowed.

#if defined(ENABLE_OVERLOADING)
    SingleSelectionCanUnselectPropertyInfo  ,
#endif
    constructSingleSelectionCanUnselect     ,
    getSingleSelectionCanUnselect           ,
    setSingleSelectionCanUnselect           ,
#if defined(ENABLE_OVERLOADING)
    singleSelectionCanUnselect              ,
#endif


-- ** itemType #attr:itemType#
-- | The type of items. See 'GI.Gio.Interfaces.ListModel.listModelGetItemType'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    SingleSelectionItemTypePropertyInfo     ,
#endif
    getSingleSelectionItemType              ,
#if defined(ENABLE_OVERLOADING)
    singleSelectionItemType                 ,
#endif


-- ** model #attr:model#
-- | The model being managed.

#if defined(ENABLE_OVERLOADING)
    SingleSelectionModelPropertyInfo        ,
#endif
    clearSingleSelectionModel               ,
    constructSingleSelectionModel           ,
    getSingleSelectionModel                 ,
    setSingleSelectionModel                 ,
#if defined(ENABLE_OVERLOADING)
    singleSelectionModel                    ,
#endif


-- ** nItems #attr:nItems#
-- | The number of items. See 'GI.Gio.Interfaces.ListModel.listModelGetNItems'.
-- 
-- /Since: 4.8/

#if defined(ENABLE_OVERLOADING)
    SingleSelectionNItemsPropertyInfo       ,
#endif
    getSingleSelectionNItems                ,
#if defined(ENABLE_OVERLOADING)
    singleSelectionNItems                   ,
#endif


-- ** selected #attr:selected#
-- | Position of the selected item.

#if defined(ENABLE_OVERLOADING)
    SingleSelectionSelectedPropertyInfo     ,
#endif
    constructSingleSelectionSelected        ,
    getSingleSelectionSelected              ,
    setSingleSelectionSelected              ,
#if defined(ENABLE_OVERLOADING)
    singleSelectionSelected                 ,
#endif


-- ** selectedItem #attr:selectedItem#
-- | The selected item.

#if defined(ENABLE_OVERLOADING)
    SingleSelectionSelectedItemPropertyInfo ,
#endif
    getSingleSelectionSelectedItem          ,
#if defined(ENABLE_OVERLOADING)
    singleSelectionSelectedItem             ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SectionModel as Gtk.SectionModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel
import {-# SOURCE #-} qualified GI.Gtk.Structs.Bitset as Gtk.Bitset

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SectionModel as Gtk.SectionModel
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.SelectionModel as Gtk.SelectionModel

#endif

-- | Memory-managed wrapper type.
newtype SingleSelection = SingleSelection (SP.ManagedPtr SingleSelection)
    deriving (Eq)

instance SP.ManagedPtrNewtype SingleSelection where
    toManagedPtr (SingleSelection p) = p

foreign import ccall "gtk_single_selection_get_type"
    c_gtk_single_selection_get_type :: IO B.Types.GType

instance B.Types.TypedObject SingleSelection where
    glibType = c_gtk_single_selection_get_type

instance B.Types.GObject SingleSelection

-- | Type class for types which can be safely cast to `SingleSelection`, for instance with `toSingleSelection`.
class (SP.GObject o, O.IsDescendantOf SingleSelection o) => IsSingleSelection o
instance (SP.GObject o, O.IsDescendantOf SingleSelection o) => IsSingleSelection o

instance O.HasParentTypes SingleSelection
type instance O.ParentTypes SingleSelection = '[GObject.Object.Object, Gio.ListModel.ListModel, Gtk.SectionModel.SectionModel, Gtk.SelectionModel.SelectionModel]

-- | Cast to `SingleSelection`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSingleSelection :: (MIO.MonadIO m, IsSingleSelection o) => o -> m SingleSelection
toSingleSelection = MIO.liftIO . B.ManagedPtr.unsafeCastTo SingleSelection

-- | Convert 'SingleSelection' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SingleSelection) where
    gvalueGType_ = c_gtk_single_selection_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SingleSelection)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SingleSelection)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SingleSelection ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSingleSelectionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSingleSelectionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSingleSelectionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSingleSelectionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSingleSelectionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSingleSelectionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSingleSelectionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSingleSelectionMethod "isSelected" o = Gtk.SelectionModel.SelectionModelIsSelectedMethodInfo
    ResolveSingleSelectionMethod "itemsChanged" o = Gio.ListModel.ListModelItemsChangedMethodInfo
    ResolveSingleSelectionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSingleSelectionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSingleSelectionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSingleSelectionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSingleSelectionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSingleSelectionMethod "sectionsChanged" o = Gtk.SectionModel.SectionModelSectionsChangedMethodInfo
    ResolveSingleSelectionMethod "selectAll" o = Gtk.SelectionModel.SelectionModelSelectAllMethodInfo
    ResolveSingleSelectionMethod "selectItem" o = Gtk.SelectionModel.SelectionModelSelectItemMethodInfo
    ResolveSingleSelectionMethod "selectRange" o = Gtk.SelectionModel.SelectionModelSelectRangeMethodInfo
    ResolveSingleSelectionMethod "selectionChanged" o = Gtk.SelectionModel.SelectionModelSelectionChangedMethodInfo
    ResolveSingleSelectionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSingleSelectionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSingleSelectionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSingleSelectionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSingleSelectionMethod "unselectAll" o = Gtk.SelectionModel.SelectionModelUnselectAllMethodInfo
    ResolveSingleSelectionMethod "unselectItem" o = Gtk.SelectionModel.SelectionModelUnselectItemMethodInfo
    ResolveSingleSelectionMethod "unselectRange" o = Gtk.SelectionModel.SelectionModelUnselectRangeMethodInfo
    ResolveSingleSelectionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSingleSelectionMethod "getAutoselect" o = SingleSelectionGetAutoselectMethodInfo
    ResolveSingleSelectionMethod "getCanUnselect" o = SingleSelectionGetCanUnselectMethodInfo
    ResolveSingleSelectionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSingleSelectionMethod "getItem" o = Gio.ListModel.ListModelGetItemMethodInfo
    ResolveSingleSelectionMethod "getItemType" o = Gio.ListModel.ListModelGetItemTypeMethodInfo
    ResolveSingleSelectionMethod "getModel" o = SingleSelectionGetModelMethodInfo
    ResolveSingleSelectionMethod "getNItems" o = Gio.ListModel.ListModelGetNItemsMethodInfo
    ResolveSingleSelectionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSingleSelectionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSingleSelectionMethod "getSection" o = Gtk.SectionModel.SectionModelGetSectionMethodInfo
    ResolveSingleSelectionMethod "getSelected" o = SingleSelectionGetSelectedMethodInfo
    ResolveSingleSelectionMethod "getSelectedItem" o = SingleSelectionGetSelectedItemMethodInfo
    ResolveSingleSelectionMethod "getSelection" o = Gtk.SelectionModel.SelectionModelGetSelectionMethodInfo
    ResolveSingleSelectionMethod "getSelectionInRange" o = Gtk.SelectionModel.SelectionModelGetSelectionInRangeMethodInfo
    ResolveSingleSelectionMethod "setAutoselect" o = SingleSelectionSetAutoselectMethodInfo
    ResolveSingleSelectionMethod "setCanUnselect" o = SingleSelectionSetCanUnselectMethodInfo
    ResolveSingleSelectionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSingleSelectionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSingleSelectionMethod "setModel" o = SingleSelectionSetModelMethodInfo
    ResolveSingleSelectionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSingleSelectionMethod "setSelected" o = SingleSelectionSetSelectedMethodInfo
    ResolveSingleSelectionMethod "setSelection" o = Gtk.SelectionModel.SelectionModelSetSelectionMethodInfo
    ResolveSingleSelectionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSingleSelectionMethod t SingleSelection, O.OverloadedMethod info SingleSelection p) => OL.IsLabel t (SingleSelection -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSingleSelectionMethod t SingleSelection, O.OverloadedMethod info SingleSelection p, R.HasField t SingleSelection p) => R.HasField t SingleSelection p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSingleSelectionMethod t SingleSelection, O.OverloadedMethodInfo info SingleSelection) => OL.IsLabel t (O.MethodProxy info SingleSelection) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "autoselect"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@autoselect@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' singleSelection #autoselect
-- @
getSingleSelectionAutoselect :: (MonadIO m, IsSingleSelection o) => o -> m Bool
getSingleSelectionAutoselect obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "autoselect"

-- | Set the value of the “@autoselect@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' singleSelection [ #autoselect 'Data.GI.Base.Attributes.:=' value ]
-- @
setSingleSelectionAutoselect :: (MonadIO m, IsSingleSelection o) => o -> Bool -> m ()
setSingleSelectionAutoselect obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "autoselect" val

-- | Construct a `GValueConstruct` with valid value for the “@autoselect@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSingleSelectionAutoselect :: (IsSingleSelection o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSingleSelectionAutoselect val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "autoselect" val

#if defined(ENABLE_OVERLOADING)
data SingleSelectionAutoselectPropertyInfo
instance AttrInfo SingleSelectionAutoselectPropertyInfo where
    type AttrAllowedOps SingleSelectionAutoselectPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SingleSelectionAutoselectPropertyInfo = IsSingleSelection
    type AttrSetTypeConstraint SingleSelectionAutoselectPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SingleSelectionAutoselectPropertyInfo = (~) Bool
    type AttrTransferType SingleSelectionAutoselectPropertyInfo = Bool
    type AttrGetType SingleSelectionAutoselectPropertyInfo = Bool
    type AttrLabel SingleSelectionAutoselectPropertyInfo = "autoselect"
    type AttrOrigin SingleSelectionAutoselectPropertyInfo = SingleSelection
    attrGet = getSingleSelectionAutoselect
    attrSet = setSingleSelectionAutoselect
    attrTransfer _ v = do
        return v
    attrConstruct = constructSingleSelectionAutoselect
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.autoselect"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#g:attr:autoselect"
        })
#endif

-- VVV Prop "can-unselect"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@can-unselect@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' singleSelection #canUnselect
-- @
getSingleSelectionCanUnselect :: (MonadIO m, IsSingleSelection o) => o -> m Bool
getSingleSelectionCanUnselect obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "can-unselect"

-- | Set the value of the “@can-unselect@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' singleSelection [ #canUnselect 'Data.GI.Base.Attributes.:=' value ]
-- @
setSingleSelectionCanUnselect :: (MonadIO m, IsSingleSelection o) => o -> Bool -> m ()
setSingleSelectionCanUnselect obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "can-unselect" val

-- | Construct a `GValueConstruct` with valid value for the “@can-unselect@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSingleSelectionCanUnselect :: (IsSingleSelection o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructSingleSelectionCanUnselect val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "can-unselect" val

#if defined(ENABLE_OVERLOADING)
data SingleSelectionCanUnselectPropertyInfo
instance AttrInfo SingleSelectionCanUnselectPropertyInfo where
    type AttrAllowedOps SingleSelectionCanUnselectPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SingleSelectionCanUnselectPropertyInfo = IsSingleSelection
    type AttrSetTypeConstraint SingleSelectionCanUnselectPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint SingleSelectionCanUnselectPropertyInfo = (~) Bool
    type AttrTransferType SingleSelectionCanUnselectPropertyInfo = Bool
    type AttrGetType SingleSelectionCanUnselectPropertyInfo = Bool
    type AttrLabel SingleSelectionCanUnselectPropertyInfo = "can-unselect"
    type AttrOrigin SingleSelectionCanUnselectPropertyInfo = SingleSelection
    attrGet = getSingleSelectionCanUnselect
    attrSet = setSingleSelectionCanUnselect
    attrTransfer _ v = do
        return v
    attrConstruct = constructSingleSelectionCanUnselect
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.canUnselect"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#g:attr:canUnselect"
        })
#endif

-- VVV Prop "item-type"
   -- Type: TBasicType TGType
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@item-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' singleSelection #itemType
-- @
getSingleSelectionItemType :: (MonadIO m, IsSingleSelection o) => o -> m GType
getSingleSelectionItemType obj = MIO.liftIO $ B.Properties.getObjectPropertyGType obj "item-type"

#if defined(ENABLE_OVERLOADING)
data SingleSelectionItemTypePropertyInfo
instance AttrInfo SingleSelectionItemTypePropertyInfo where
    type AttrAllowedOps SingleSelectionItemTypePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint SingleSelectionItemTypePropertyInfo = IsSingleSelection
    type AttrSetTypeConstraint SingleSelectionItemTypePropertyInfo = (~) ()
    type AttrTransferTypeConstraint SingleSelectionItemTypePropertyInfo = (~) ()
    type AttrTransferType SingleSelectionItemTypePropertyInfo = ()
    type AttrGetType SingleSelectionItemTypePropertyInfo = GType
    type AttrLabel SingleSelectionItemTypePropertyInfo = "item-type"
    type AttrOrigin SingleSelectionItemTypePropertyInfo = SingleSelection
    attrGet = getSingleSelectionItemType
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.itemType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#g:attr:itemType"
        })
#endif

-- VVV Prop "model"
   -- Type: TInterface (Name {namespace = "Gio", name = "ListModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' singleSelection #model
-- @
getSingleSelectionModel :: (MonadIO m, IsSingleSelection o) => o -> m (Maybe Gio.ListModel.ListModel)
getSingleSelectionModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "model" Gio.ListModel.ListModel

-- | Set the value of the “@model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' singleSelection [ #model 'Data.GI.Base.Attributes.:=' value ]
-- @
setSingleSelectionModel :: (MonadIO m, IsSingleSelection o, Gio.ListModel.IsListModel a) => o -> a -> m ()
setSingleSelectionModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "model" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSingleSelectionModel :: (IsSingleSelection o, MIO.MonadIO m, Gio.ListModel.IsListModel a) => a -> m (GValueConstruct o)
constructSingleSelectionModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "model" (P.Just val)

-- | Set the value of the “@model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #model
-- @
clearSingleSelectionModel :: (MonadIO m, IsSingleSelection o) => o -> m ()
clearSingleSelectionModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "model" (Nothing :: Maybe Gio.ListModel.ListModel)

#if defined(ENABLE_OVERLOADING)
data SingleSelectionModelPropertyInfo
instance AttrInfo SingleSelectionModelPropertyInfo where
    type AttrAllowedOps SingleSelectionModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SingleSelectionModelPropertyInfo = IsSingleSelection
    type AttrSetTypeConstraint SingleSelectionModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferTypeConstraint SingleSelectionModelPropertyInfo = Gio.ListModel.IsListModel
    type AttrTransferType SingleSelectionModelPropertyInfo = Gio.ListModel.ListModel
    type AttrGetType SingleSelectionModelPropertyInfo = (Maybe Gio.ListModel.ListModel)
    type AttrLabel SingleSelectionModelPropertyInfo = "model"
    type AttrOrigin SingleSelectionModelPropertyInfo = SingleSelection
    attrGet = getSingleSelectionModel
    attrSet = setSingleSelectionModel
    attrTransfer _ v = do
        unsafeCastTo Gio.ListModel.ListModel v
    attrConstruct = constructSingleSelectionModel
    attrClear = clearSingleSelectionModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.model"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#g:attr:model"
        })
#endif

-- VVV Prop "n-items"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@n-items@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' singleSelection #nItems
-- @
getSingleSelectionNItems :: (MonadIO m, IsSingleSelection o) => o -> m Word32
getSingleSelectionNItems obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "n-items"

#if defined(ENABLE_OVERLOADING)
data SingleSelectionNItemsPropertyInfo
instance AttrInfo SingleSelectionNItemsPropertyInfo where
    type AttrAllowedOps SingleSelectionNItemsPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint SingleSelectionNItemsPropertyInfo = IsSingleSelection
    type AttrSetTypeConstraint SingleSelectionNItemsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint SingleSelectionNItemsPropertyInfo = (~) ()
    type AttrTransferType SingleSelectionNItemsPropertyInfo = ()
    type AttrGetType SingleSelectionNItemsPropertyInfo = Word32
    type AttrLabel SingleSelectionNItemsPropertyInfo = "n-items"
    type AttrOrigin SingleSelectionNItemsPropertyInfo = SingleSelection
    attrGet = getSingleSelectionNItems
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.nItems"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#g:attr:nItems"
        })
#endif

-- VVV Prop "selected"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@selected@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' singleSelection #selected
-- @
getSingleSelectionSelected :: (MonadIO m, IsSingleSelection o) => o -> m Word32
getSingleSelectionSelected obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "selected"

-- | Set the value of the “@selected@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' singleSelection [ #selected 'Data.GI.Base.Attributes.:=' value ]
-- @
setSingleSelectionSelected :: (MonadIO m, IsSingleSelection o) => o -> Word32 -> m ()
setSingleSelectionSelected obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyUInt32 obj "selected" val

-- | Construct a `GValueConstruct` with valid value for the “@selected@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSingleSelectionSelected :: (IsSingleSelection o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructSingleSelectionSelected val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "selected" val

#if defined(ENABLE_OVERLOADING)
data SingleSelectionSelectedPropertyInfo
instance AttrInfo SingleSelectionSelectedPropertyInfo where
    type AttrAllowedOps SingleSelectionSelectedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint SingleSelectionSelectedPropertyInfo = IsSingleSelection
    type AttrSetTypeConstraint SingleSelectionSelectedPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint SingleSelectionSelectedPropertyInfo = (~) Word32
    type AttrTransferType SingleSelectionSelectedPropertyInfo = Word32
    type AttrGetType SingleSelectionSelectedPropertyInfo = Word32
    type AttrLabel SingleSelectionSelectedPropertyInfo = "selected"
    type AttrOrigin SingleSelectionSelectedPropertyInfo = SingleSelection
    attrGet = getSingleSelectionSelected
    attrSet = setSingleSelectionSelected
    attrTransfer _ v = do
        return v
    attrConstruct = constructSingleSelectionSelected
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.selected"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#g:attr:selected"
        })
#endif

-- VVV Prop "selected-item"
   -- Type: TInterface (Name {namespace = "GObject", name = "Object"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@selected-item@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' singleSelection #selectedItem
-- @
getSingleSelectionSelectedItem :: (MonadIO m, IsSingleSelection o) => o -> m (Maybe GObject.Object.Object)
getSingleSelectionSelectedItem obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "selected-item" GObject.Object.Object

#if defined(ENABLE_OVERLOADING)
data SingleSelectionSelectedItemPropertyInfo
instance AttrInfo SingleSelectionSelectedItemPropertyInfo where
    type AttrAllowedOps SingleSelectionSelectedItemPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SingleSelectionSelectedItemPropertyInfo = IsSingleSelection
    type AttrSetTypeConstraint SingleSelectionSelectedItemPropertyInfo = (~) ()
    type AttrTransferTypeConstraint SingleSelectionSelectedItemPropertyInfo = (~) ()
    type AttrTransferType SingleSelectionSelectedItemPropertyInfo = ()
    type AttrGetType SingleSelectionSelectedItemPropertyInfo = (Maybe GObject.Object.Object)
    type AttrLabel SingleSelectionSelectedItemPropertyInfo = "selected-item"
    type AttrOrigin SingleSelectionSelectedItemPropertyInfo = SingleSelection
    attrGet = getSingleSelectionSelectedItem
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.selectedItem"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#g:attr:selectedItem"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SingleSelection
type instance O.AttributeList SingleSelection = SingleSelectionAttributeList
type SingleSelectionAttributeList = ('[ '("autoselect", SingleSelectionAutoselectPropertyInfo), '("canUnselect", SingleSelectionCanUnselectPropertyInfo), '("itemType", SingleSelectionItemTypePropertyInfo), '("model", SingleSelectionModelPropertyInfo), '("nItems", SingleSelectionNItemsPropertyInfo), '("selected", SingleSelectionSelectedPropertyInfo), '("selectedItem", SingleSelectionSelectedItemPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
singleSelectionAutoselect :: AttrLabelProxy "autoselect"
singleSelectionAutoselect = AttrLabelProxy

singleSelectionCanUnselect :: AttrLabelProxy "canUnselect"
singleSelectionCanUnselect = AttrLabelProxy

singleSelectionItemType :: AttrLabelProxy "itemType"
singleSelectionItemType = AttrLabelProxy

singleSelectionModel :: AttrLabelProxy "model"
singleSelectionModel = AttrLabelProxy

singleSelectionNItems :: AttrLabelProxy "nItems"
singleSelectionNItems = AttrLabelProxy

singleSelectionSelected :: AttrLabelProxy "selected"
singleSelectionSelected = AttrLabelProxy

singleSelectionSelectedItem :: AttrLabelProxy "selectedItem"
singleSelectionSelectedItem = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SingleSelection = SingleSelectionSignalList
type SingleSelectionSignalList = ('[ '("itemsChanged", Gio.ListModel.ListModelItemsChangedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("sectionsChanged", Gtk.SectionModel.SectionModelSectionsChangedSignalInfo), '("selectionChanged", Gtk.SelectionModel.SelectionModelSelectionChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SingleSelection::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GListModel` to manage"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SingleSelection" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_single_selection_new" gtk_single_selection_new :: 
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    IO (Ptr SingleSelection)

-- | Creates a new selection to handle /@model@/.
singleSelectionNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.ListModel.IsListModel a) =>
    Maybe (a)
    -- ^ /@model@/: the @GListModel@ to manage
    -> m SingleSelection
    -- ^ __Returns:__ a new @GtkSingleSelection@
singleSelectionNew model = liftIO $ do
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- B.ManagedPtr.disownObject jModel
            return jModel'
    result <- gtk_single_selection_new maybeModel
    checkUnexpectedReturnNULL "singleSelectionNew" result
    result' <- (wrapObject SingleSelection) result
    whenJust model touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SingleSelection::get_autoselect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SingleSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSingleSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_single_selection_get_autoselect" gtk_single_selection_get_autoselect :: 
    Ptr SingleSelection ->                  -- self : TInterface (Name {namespace = "Gtk", name = "SingleSelection"})
    IO CInt

-- | Checks if autoselect has been enabled or disabled via
-- 'GI.Gtk.Objects.SingleSelection.singleSelectionSetAutoselect'.
singleSelectionGetAutoselect ::
    (B.CallStack.HasCallStack, MonadIO m, IsSingleSelection a) =>
    a
    -- ^ /@self@/: a @GtkSingleSelection@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if autoselect is enabled
singleSelectionGetAutoselect self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_single_selection_get_autoselect self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data SingleSelectionGetAutoselectMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSingleSelection a) => O.OverloadedMethod SingleSelectionGetAutoselectMethodInfo a signature where
    overloadedMethod = singleSelectionGetAutoselect

instance O.OverloadedMethodInfo SingleSelectionGetAutoselectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.singleSelectionGetAutoselect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#v:singleSelectionGetAutoselect"
        })


#endif

-- method SingleSelection::get_can_unselect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SingleSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSingleSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_single_selection_get_can_unselect" gtk_single_selection_get_can_unselect :: 
    Ptr SingleSelection ->                  -- self : TInterface (Name {namespace = "Gtk", name = "SingleSelection"})
    IO CInt

-- | If 'P.True', 'GI.Gtk.Interfaces.SelectionModel.selectionModelUnselectItem' is supported and allows
-- unselecting the selected item.
singleSelectionGetCanUnselect ::
    (B.CallStack.HasCallStack, MonadIO m, IsSingleSelection a) =>
    a
    -- ^ /@self@/: a @GtkSingleSelection@
    -> m Bool
    -- ^ __Returns:__ 'P.True' to support unselecting
singleSelectionGetCanUnselect self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_single_selection_get_can_unselect self'
    let result' = (/= 0) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data SingleSelectionGetCanUnselectMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsSingleSelection a) => O.OverloadedMethod SingleSelectionGetCanUnselectMethodInfo a signature where
    overloadedMethod = singleSelectionGetCanUnselect

instance O.OverloadedMethodInfo SingleSelectionGetCanUnselectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.singleSelectionGetCanUnselect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#v:singleSelectionGetCanUnselect"
        })


#endif

-- method SingleSelection::get_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SingleSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSingleSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_single_selection_get_model" gtk_single_selection_get_model :: 
    Ptr SingleSelection ->                  -- self : TInterface (Name {namespace = "Gtk", name = "SingleSelection"})
    IO (Ptr Gio.ListModel.ListModel)

-- | Gets the model that /@self@/ is wrapping.
singleSelectionGetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsSingleSelection a) =>
    a
    -- ^ /@self@/: a @GtkSingleSelection@
    -> m (Maybe Gio.ListModel.ListModel)
    -- ^ __Returns:__ The model being wrapped
singleSelectionGetModel self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_single_selection_get_model self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.ListModel.ListModel) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SingleSelectionGetModelMethodInfo
instance (signature ~ (m (Maybe Gio.ListModel.ListModel)), MonadIO m, IsSingleSelection a) => O.OverloadedMethod SingleSelectionGetModelMethodInfo a signature where
    overloadedMethod = singleSelectionGetModel

instance O.OverloadedMethodInfo SingleSelectionGetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.singleSelectionGetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#v:singleSelectionGetModel"
        })


#endif

-- method SingleSelection::get_selected
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SingleSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSingleSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_single_selection_get_selected" gtk_single_selection_get_selected :: 
    Ptr SingleSelection ->                  -- self : TInterface (Name {namespace = "Gtk", name = "SingleSelection"})
    IO Word32

-- | Gets the position of the selected item.
-- 
-- If no item is selected, 'GI.Gtk.Constants.INVALID_LIST_POSITION' is returned.
singleSelectionGetSelected ::
    (B.CallStack.HasCallStack, MonadIO m, IsSingleSelection a) =>
    a
    -- ^ /@self@/: a @GtkSingleSelection@
    -> m Word32
    -- ^ __Returns:__ The position of the selected item
singleSelectionGetSelected self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_single_selection_get_selected self'
    touchManagedPtr self
    return result

#if defined(ENABLE_OVERLOADING)
data SingleSelectionGetSelectedMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsSingleSelection a) => O.OverloadedMethod SingleSelectionGetSelectedMethodInfo a signature where
    overloadedMethod = singleSelectionGetSelected

instance O.OverloadedMethodInfo SingleSelectionGetSelectedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.singleSelectionGetSelected",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#v:singleSelectionGetSelected"
        })


#endif

-- method SingleSelection::get_selected_item
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SingleSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSingleSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GObject" , name = "Object" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_single_selection_get_selected_item" gtk_single_selection_get_selected_item :: 
    Ptr SingleSelection ->                  -- self : TInterface (Name {namespace = "Gtk", name = "SingleSelection"})
    IO (Ptr GObject.Object.Object)

-- | Gets the selected item.
-- 
-- If no item is selected, 'P.Nothing' is returned.
singleSelectionGetSelectedItem ::
    (B.CallStack.HasCallStack, MonadIO m, IsSingleSelection a) =>
    a
    -- ^ /@self@/: a @GtkSingleSelection@
    -> m (Maybe GObject.Object.Object)
    -- ^ __Returns:__ The selected item
singleSelectionGetSelectedItem self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_single_selection_get_selected_item self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject GObject.Object.Object) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data SingleSelectionGetSelectedItemMethodInfo
instance (signature ~ (m (Maybe GObject.Object.Object)), MonadIO m, IsSingleSelection a) => O.OverloadedMethod SingleSelectionGetSelectedItemMethodInfo a signature where
    overloadedMethod = singleSelectionGetSelectedItem

instance O.OverloadedMethodInfo SingleSelectionGetSelectedItemMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.singleSelectionGetSelectedItem",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#v:singleSelectionGetSelectedItem"
        })


#endif

-- method SingleSelection::set_autoselect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SingleSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSingleSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "autoselect"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to always select an item"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_single_selection_set_autoselect" gtk_single_selection_set_autoselect :: 
    Ptr SingleSelection ->                  -- self : TInterface (Name {namespace = "Gtk", name = "SingleSelection"})
    CInt ->                                 -- autoselect : TBasicType TBoolean
    IO ()

-- | Enables or disables autoselect.
-- 
-- If /@autoselect@/ is 'P.True', /@self@/ will enforce that an item is always
-- selected. It will select a new item when the currently selected
-- item is deleted and it will disallow unselecting the current item.
singleSelectionSetAutoselect ::
    (B.CallStack.HasCallStack, MonadIO m, IsSingleSelection a) =>
    a
    -- ^ /@self@/: a @GtkSingleSelection@
    -> Bool
    -- ^ /@autoselect@/: 'P.True' to always select an item
    -> m ()
singleSelectionSetAutoselect self autoselect = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let autoselect' = (P.fromIntegral . P.fromEnum) autoselect
    gtk_single_selection_set_autoselect self' autoselect'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data SingleSelectionSetAutoselectMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSingleSelection a) => O.OverloadedMethod SingleSelectionSetAutoselectMethodInfo a signature where
    overloadedMethod = singleSelectionSetAutoselect

instance O.OverloadedMethodInfo SingleSelectionSetAutoselectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.singleSelectionSetAutoselect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#v:singleSelectionSetAutoselect"
        })


#endif

-- method SingleSelection::set_can_unselect
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SingleSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSingleSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "can_unselect"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to allow unselecting"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_single_selection_set_can_unselect" gtk_single_selection_set_can_unselect :: 
    Ptr SingleSelection ->                  -- self : TInterface (Name {namespace = "Gtk", name = "SingleSelection"})
    CInt ->                                 -- can_unselect : TBasicType TBoolean
    IO ()

-- | If 'P.True', unselecting the current item via
-- 'GI.Gtk.Interfaces.SelectionModel.selectionModelUnselectItem' is supported.
-- 
-- Note that setting [SingleSelection:autoselect]("GI.Gtk.Objects.SingleSelection#g:attr:autoselect") will
-- cause unselecting to not work, so it practically makes no sense
-- to set both at the same time.
singleSelectionSetCanUnselect ::
    (B.CallStack.HasCallStack, MonadIO m, IsSingleSelection a) =>
    a
    -- ^ /@self@/: a @GtkSingleSelection@
    -> Bool
    -- ^ /@canUnselect@/: 'P.True' to allow unselecting
    -> m ()
singleSelectionSetCanUnselect self canUnselect = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let canUnselect' = (P.fromIntegral . P.fromEnum) canUnselect
    gtk_single_selection_set_can_unselect self' canUnselect'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data SingleSelectionSetCanUnselectMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsSingleSelection a) => O.OverloadedMethod SingleSelectionSetCanUnselectMethodInfo a signature where
    overloadedMethod = singleSelectionSetCanUnselect

instance O.OverloadedMethodInfo SingleSelectionSetCanUnselectMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.singleSelectionSetCanUnselect",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#v:singleSelectionSetCanUnselect"
        })


#endif

-- method SingleSelection::set_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SingleSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSingleSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ListModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GListModel` to wrap"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_single_selection_set_model" gtk_single_selection_set_model :: 
    Ptr SingleSelection ->                  -- self : TInterface (Name {namespace = "Gtk", name = "SingleSelection"})
    Ptr Gio.ListModel.ListModel ->          -- model : TInterface (Name {namespace = "Gio", name = "ListModel"})
    IO ()

-- | Sets the model that /@self@/ should wrap.
-- 
-- If /@model@/ is 'P.Nothing', /@self@/ will be empty.
singleSelectionSetModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsSingleSelection a, Gio.ListModel.IsListModel b) =>
    a
    -- ^ /@self@/: a @GtkSingleSelection@
    -> Maybe (b)
    -- ^ /@model@/: A @GListModel@ to wrap
    -> m ()
singleSelectionSetModel self model = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_single_selection_set_model self' maybeModel
    touchManagedPtr self
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data SingleSelectionSetModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsSingleSelection a, Gio.ListModel.IsListModel b) => O.OverloadedMethod SingleSelectionSetModelMethodInfo a signature where
    overloadedMethod = singleSelectionSetModel

instance O.OverloadedMethodInfo SingleSelectionSetModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.singleSelectionSetModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#v:singleSelectionSetModel"
        })


#endif

-- method SingleSelection::set_selected
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SingleSelection" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkSingleSelection`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the item to select or %GTK_INVALID_LIST_POSITION"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_single_selection_set_selected" gtk_single_selection_set_selected :: 
    Ptr SingleSelection ->                  -- self : TInterface (Name {namespace = "Gtk", name = "SingleSelection"})
    Word32 ->                               -- position : TBasicType TUInt
    IO ()

-- | Selects the item at the given position.
-- 
-- If the list does not have an item at /@position@/ or
-- 'GI.Gtk.Constants.INVALID_LIST_POSITION' is given, the behavior depends on the
-- value of the [SingleSelection:autoselect]("GI.Gtk.Objects.SingleSelection#g:attr:autoselect") property:
-- If it is set, no change will occur and the old item will stay
-- selected. If it is unset, the selection will be unset and no item
-- will be selected. This also applies if [SingleSelection:canUnselect]("GI.Gtk.Objects.SingleSelection#g:attr:canUnselect")
-- is set to 'P.False'.
singleSelectionSetSelected ::
    (B.CallStack.HasCallStack, MonadIO m, IsSingleSelection a) =>
    a
    -- ^ /@self@/: a @GtkSingleSelection@
    -> Word32
    -- ^ /@position@/: the item to select or 'GI.Gtk.Constants.INVALID_LIST_POSITION'
    -> m ()
singleSelectionSetSelected self position = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    gtk_single_selection_set_selected self' position
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data SingleSelectionSetSelectedMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsSingleSelection a) => O.OverloadedMethod SingleSelectionSetSelectedMethodInfo a signature where
    overloadedMethod = singleSelectionSetSelected

instance O.OverloadedMethodInfo SingleSelectionSetSelectedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SingleSelection.singleSelectionSetSelected",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SingleSelection.html#v:singleSelectionSetSelected"
        })


#endif


