{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Emits signals to manage listitems.
-- 
-- Signals are emitted for every listitem in the same order:
-- 
--  1. [SignalListItemFactory::setup]("GI.Gtk.Objects.SignalListItemFactory#g:signal:setup") is emitted to set up permanent
--  things on the listitem. This usually means constructing the widgets used in
--  the row and adding them to the listitem.
-- 
--  2. [SignalListItemFactory::bind]("GI.Gtk.Objects.SignalListItemFactory#g:signal:bind") is emitted to bind the item passed
--  via [ListItem:item]("GI.Gtk.Objects.ListItem#g:attr:item") to the widgets that have been created in
--  step 1 or to add item-specific widgets. Signals are connected to listen to
--  changes - both to changes in the item to update the widgets or to changes
--  in the widgets to update the item. After this signal has been called, the
--  listitem may be shown in a list widget.
-- 
--  3. [SignalListItemFactory::unbind]("GI.Gtk.Objects.SignalListItemFactory#g:signal:unbind") is emitted to undo everything
--  done in step 2. Usually this means disconnecting signal handlers. Once this
--  signal has been called, the listitem will no longer be used in a list
--  widget.
-- 
--  4. [SignalListItemFactory::bind]("GI.Gtk.Objects.SignalListItemFactory#g:signal:bind") and
--  [SignalListItemFactory::unbind]("GI.Gtk.Objects.SignalListItemFactory#g:signal:unbind") may be emitted multiple times
--  again to bind the listitem for use with new items. By reusing listitems,
--  potentially costly setup can be avoided. However, it means code needs to
--  make sure to properly clean up the listitem in step 3 so that no information
--  from the previous use leaks into the next one.
-- 
--  5. [SignalListItemFactory::teardown]("GI.Gtk.Objects.SignalListItemFactory#g:signal:teardown") is emitted to allow undoing
--  the effects of [SignalListItemFactory::setup]("GI.Gtk.Objects.SignalListItemFactory#g:signal:setup"). After this signal
--  was emitted on a listitem, the listitem will be destroyed and not be used again.
-- 
-- Note that during the signal emissions, changing properties on the listitems
-- passed will not trigger notify signals as the listitem\'s notifications are
-- frozen. See [method/@gObject@/.Object.@/freeze_notify()/@] for details.
-- 
-- For tracking changes in other properties in the listitem, the
-- [notify](#g:signal:notify) signal is recommended. The signal can be connected in the
-- [SignalListItemFactory::setup]("GI.Gtk.Objects.SignalListItemFactory#g:signal:setup") signal and removed again during
-- [SignalListItemFactory::teardown]("GI.Gtk.Objects.SignalListItemFactory#g:signal:teardown").

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.SignalListItemFactory
    ( 

-- * Exported types
    SignalListItemFactory(..)               ,
    IsSignalListItemFactory                 ,
    toSignalListItemFactory                 ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSignalListItemFactoryMethod      ,
#endif

-- ** new #method:new#

    signalListItemFactoryNew                ,




 -- * Signals


-- ** bind #signal:bind#

    SignalListItemFactoryBindCallback       ,
#if defined(ENABLE_OVERLOADING)
    SignalListItemFactoryBindSignalInfo     ,
#endif
    afterSignalListItemFactoryBind          ,
    onSignalListItemFactoryBind             ,


-- ** setup #signal:setup#

    SignalListItemFactorySetupCallback      ,
#if defined(ENABLE_OVERLOADING)
    SignalListItemFactorySetupSignalInfo    ,
#endif
    afterSignalListItemFactorySetup         ,
    onSignalListItemFactorySetup            ,


-- ** teardown #signal:teardown#

    SignalListItemFactoryTeardownCallback   ,
#if defined(ENABLE_OVERLOADING)
    SignalListItemFactoryTeardownSignalInfo ,
#endif
    afterSignalListItemFactoryTeardown      ,
    onSignalListItemFactoryTeardown         ,


-- ** unbind #signal:unbind#

    SignalListItemFactoryUnbindCallback     ,
#if defined(ENABLE_OVERLOADING)
    SignalListItemFactoryUnbindSignalInfo   ,
#endif
    afterSignalListItemFactoryUnbind        ,
    onSignalListItemFactoryUnbind           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.ListItemFactory as Gtk.ListItemFactory

#endif

-- | Memory-managed wrapper type.
newtype SignalListItemFactory = SignalListItemFactory (SP.ManagedPtr SignalListItemFactory)
    deriving (Eq)

instance SP.ManagedPtrNewtype SignalListItemFactory where
    toManagedPtr (SignalListItemFactory p) = p

foreign import ccall "gtk_signal_list_item_factory_get_type"
    c_gtk_signal_list_item_factory_get_type :: IO B.Types.GType

instance B.Types.TypedObject SignalListItemFactory where
    glibType = c_gtk_signal_list_item_factory_get_type

instance B.Types.GObject SignalListItemFactory

-- | Type class for types which can be safely cast to `SignalListItemFactory`, for instance with `toSignalListItemFactory`.
class (SP.GObject o, O.IsDescendantOf SignalListItemFactory o) => IsSignalListItemFactory o
instance (SP.GObject o, O.IsDescendantOf SignalListItemFactory o) => IsSignalListItemFactory o

instance O.HasParentTypes SignalListItemFactory
type instance O.ParentTypes SignalListItemFactory = '[Gtk.ListItemFactory.ListItemFactory, GObject.Object.Object]

-- | Cast to `SignalListItemFactory`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSignalListItemFactory :: (MIO.MonadIO m, IsSignalListItemFactory o) => o -> m SignalListItemFactory
toSignalListItemFactory = MIO.liftIO . B.ManagedPtr.unsafeCastTo SignalListItemFactory

-- | Convert 'SignalListItemFactory' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SignalListItemFactory) where
    gvalueGType_ = c_gtk_signal_list_item_factory_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SignalListItemFactory)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SignalListItemFactory)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SignalListItemFactory ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSignalListItemFactoryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSignalListItemFactoryMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSignalListItemFactoryMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSignalListItemFactoryMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSignalListItemFactoryMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSignalListItemFactoryMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSignalListItemFactoryMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSignalListItemFactoryMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSignalListItemFactoryMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSignalListItemFactoryMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSignalListItemFactoryMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSignalListItemFactoryMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSignalListItemFactoryMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSignalListItemFactoryMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSignalListItemFactoryMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSignalListItemFactoryMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSignalListItemFactoryMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSignalListItemFactoryMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSignalListItemFactoryMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSignalListItemFactoryMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSignalListItemFactoryMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSignalListItemFactoryMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSignalListItemFactoryMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSignalListItemFactoryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSignalListItemFactoryMethod t SignalListItemFactory, O.OverloadedMethod info SignalListItemFactory p) => OL.IsLabel t (SignalListItemFactory -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSignalListItemFactoryMethod t SignalListItemFactory, O.OverloadedMethod info SignalListItemFactory p, R.HasField t SignalListItemFactory p) => R.HasField t SignalListItemFactory p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSignalListItemFactoryMethod t SignalListItemFactory, O.OverloadedMethodInfo info SignalListItemFactory) => OL.IsLabel t (O.MethodProxy info SignalListItemFactory) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal SignalListItemFactory::bind
-- | Emitted when an object has been bound to an item.
-- 
-- The handler for this signal must set
-- to populate the listitem with widgets.
-- 
-- After this signal was emitted, the object might be shown in
-- a t'GI.Gtk.Objects.ListView.ListView' or other widget.
-- 
-- The [SignalListItemFactory::unbind]("GI.Gtk.Objects.SignalListItemFactory#g:signal:unbind") signal is the
-- opposite of this signal and can be used to undo everything done
-- in this signal.
type SignalListItemFactoryBindCallback =
    GObject.Object.Object
    -- ^ /@object@/: The @GObject@ to bind
    -> IO ()

type C_SignalListItemFactoryBindCallback =
    Ptr SignalListItemFactory ->            -- object
    Ptr GObject.Object.Object ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SignalListItemFactoryBindCallback`.
foreign import ccall "wrapper"
    mk_SignalListItemFactoryBindCallback :: C_SignalListItemFactoryBindCallback -> IO (FunPtr C_SignalListItemFactoryBindCallback)

wrap_SignalListItemFactoryBindCallback :: 
    GObject a => (a -> SignalListItemFactoryBindCallback) ->
    C_SignalListItemFactoryBindCallback
wrap_SignalListItemFactoryBindCallback gi'cb gi'selfPtr object _ = do
    object' <- (newObject GObject.Object.Object) object
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  object'


-- | Connect a signal handler for the [bind](#signal:bind) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' signalListItemFactory #bind callback
-- @
-- 
-- 
onSignalListItemFactoryBind :: (IsSignalListItemFactory a, MonadIO m) => a -> ((?self :: a) => SignalListItemFactoryBindCallback) -> m SignalHandlerId
onSignalListItemFactoryBind obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalListItemFactoryBindCallback wrapped
    wrapped'' <- mk_SignalListItemFactoryBindCallback wrapped'
    connectSignalFunPtr obj "bind" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [bind](#signal:bind) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' signalListItemFactory #bind callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSignalListItemFactoryBind :: (IsSignalListItemFactory a, MonadIO m) => a -> ((?self :: a) => SignalListItemFactoryBindCallback) -> m SignalHandlerId
afterSignalListItemFactoryBind obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalListItemFactoryBindCallback wrapped
    wrapped'' <- mk_SignalListItemFactoryBindCallback wrapped'
    connectSignalFunPtr obj "bind" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SignalListItemFactoryBindSignalInfo
instance SignalInfo SignalListItemFactoryBindSignalInfo where
    type HaskellCallbackType SignalListItemFactoryBindSignalInfo = SignalListItemFactoryBindCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SignalListItemFactoryBindCallback cb
        cb'' <- mk_SignalListItemFactoryBindCallback cb'
        connectSignalFunPtr obj "bind" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SignalListItemFactory::bind"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SignalListItemFactory.html#g:signal:bind"})

#endif

-- signal SignalListItemFactory::setup
-- | Emitted when a newly created listitem needs to be prepared for use.
-- 
-- It is the first signal emitted for every listitem.
-- 
-- The handler for this signal must call 'GI.Gtk.Objects.ListItem.listItemSetChild'
-- to populate the listitem with widgets.
-- 
-- The [SignalListItemFactory::teardown]("GI.Gtk.Objects.SignalListItemFactory#g:signal:teardown") signal is the opposite
-- of this signal and can be used to undo everything done in this signal.
type SignalListItemFactorySetupCallback =
    GObject.Object.Object
    -- ^ /@object@/: the @GObject@ to set up
    -> IO ()

type C_SignalListItemFactorySetupCallback =
    Ptr SignalListItemFactory ->            -- object
    Ptr GObject.Object.Object ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SignalListItemFactorySetupCallback`.
foreign import ccall "wrapper"
    mk_SignalListItemFactorySetupCallback :: C_SignalListItemFactorySetupCallback -> IO (FunPtr C_SignalListItemFactorySetupCallback)

wrap_SignalListItemFactorySetupCallback :: 
    GObject a => (a -> SignalListItemFactorySetupCallback) ->
    C_SignalListItemFactorySetupCallback
wrap_SignalListItemFactorySetupCallback gi'cb gi'selfPtr object _ = do
    object' <- (newObject GObject.Object.Object) object
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  object'


-- | Connect a signal handler for the [setup](#signal:setup) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' signalListItemFactory #setup callback
-- @
-- 
-- 
onSignalListItemFactorySetup :: (IsSignalListItemFactory a, MonadIO m) => a -> ((?self :: a) => SignalListItemFactorySetupCallback) -> m SignalHandlerId
onSignalListItemFactorySetup obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalListItemFactorySetupCallback wrapped
    wrapped'' <- mk_SignalListItemFactorySetupCallback wrapped'
    connectSignalFunPtr obj "setup" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [setup](#signal:setup) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' signalListItemFactory #setup callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSignalListItemFactorySetup :: (IsSignalListItemFactory a, MonadIO m) => a -> ((?self :: a) => SignalListItemFactorySetupCallback) -> m SignalHandlerId
afterSignalListItemFactorySetup obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalListItemFactorySetupCallback wrapped
    wrapped'' <- mk_SignalListItemFactorySetupCallback wrapped'
    connectSignalFunPtr obj "setup" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SignalListItemFactorySetupSignalInfo
instance SignalInfo SignalListItemFactorySetupSignalInfo where
    type HaskellCallbackType SignalListItemFactorySetupSignalInfo = SignalListItemFactorySetupCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SignalListItemFactorySetupCallback cb
        cb'' <- mk_SignalListItemFactorySetupCallback cb'
        connectSignalFunPtr obj "setup" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SignalListItemFactory::setup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SignalListItemFactory.html#g:signal:setup"})

#endif

-- signal SignalListItemFactory::teardown
-- | Emitted when an object is about to be destroyed.
-- 
-- It is the last signal ever emitted for this /@object@/.
-- 
-- This signal is the opposite of the [SignalListItemFactory::setup]("GI.Gtk.Objects.SignalListItemFactory#g:signal:setup")
-- signal and should be used to undo everything done in that signal.
type SignalListItemFactoryTeardownCallback =
    GObject.Object.Object
    -- ^ /@object@/: The @GObject@ to tear down
    -> IO ()

type C_SignalListItemFactoryTeardownCallback =
    Ptr SignalListItemFactory ->            -- object
    Ptr GObject.Object.Object ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SignalListItemFactoryTeardownCallback`.
foreign import ccall "wrapper"
    mk_SignalListItemFactoryTeardownCallback :: C_SignalListItemFactoryTeardownCallback -> IO (FunPtr C_SignalListItemFactoryTeardownCallback)

wrap_SignalListItemFactoryTeardownCallback :: 
    GObject a => (a -> SignalListItemFactoryTeardownCallback) ->
    C_SignalListItemFactoryTeardownCallback
wrap_SignalListItemFactoryTeardownCallback gi'cb gi'selfPtr object _ = do
    object' <- (newObject GObject.Object.Object) object
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  object'


-- | Connect a signal handler for the [teardown](#signal:teardown) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' signalListItemFactory #teardown callback
-- @
-- 
-- 
onSignalListItemFactoryTeardown :: (IsSignalListItemFactory a, MonadIO m) => a -> ((?self :: a) => SignalListItemFactoryTeardownCallback) -> m SignalHandlerId
onSignalListItemFactoryTeardown obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalListItemFactoryTeardownCallback wrapped
    wrapped'' <- mk_SignalListItemFactoryTeardownCallback wrapped'
    connectSignalFunPtr obj "teardown" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [teardown](#signal:teardown) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' signalListItemFactory #teardown callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSignalListItemFactoryTeardown :: (IsSignalListItemFactory a, MonadIO m) => a -> ((?self :: a) => SignalListItemFactoryTeardownCallback) -> m SignalHandlerId
afterSignalListItemFactoryTeardown obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalListItemFactoryTeardownCallback wrapped
    wrapped'' <- mk_SignalListItemFactoryTeardownCallback wrapped'
    connectSignalFunPtr obj "teardown" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SignalListItemFactoryTeardownSignalInfo
instance SignalInfo SignalListItemFactoryTeardownSignalInfo where
    type HaskellCallbackType SignalListItemFactoryTeardownSignalInfo = SignalListItemFactoryTeardownCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SignalListItemFactoryTeardownCallback cb
        cb'' <- mk_SignalListItemFactoryTeardownCallback cb'
        connectSignalFunPtr obj "teardown" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SignalListItemFactory::teardown"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SignalListItemFactory.html#g:signal:teardown"})

#endif

-- signal SignalListItemFactory::unbind
-- | Emitted when an object has been unbound from its item.
-- 
-- This happens for example when a listitem was removed from use
-- in a list widget and its [ListItem:item]("GI.Gtk.Objects.ListItem#g:attr:item") is about
-- to be unset.
-- 
-- This signal is the opposite of the [SignalListItemFactory::bind]("GI.Gtk.Objects.SignalListItemFactory#g:signal:bind")
-- signal and should be used to undo everything done in that signal.
type SignalListItemFactoryUnbindCallback =
    GObject.Object.Object
    -- ^ /@object@/: The @GObject@ to unbind
    -> IO ()

type C_SignalListItemFactoryUnbindCallback =
    Ptr SignalListItemFactory ->            -- object
    Ptr GObject.Object.Object ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_SignalListItemFactoryUnbindCallback`.
foreign import ccall "wrapper"
    mk_SignalListItemFactoryUnbindCallback :: C_SignalListItemFactoryUnbindCallback -> IO (FunPtr C_SignalListItemFactoryUnbindCallback)

wrap_SignalListItemFactoryUnbindCallback :: 
    GObject a => (a -> SignalListItemFactoryUnbindCallback) ->
    C_SignalListItemFactoryUnbindCallback
wrap_SignalListItemFactoryUnbindCallback gi'cb gi'selfPtr object _ = do
    object' <- (newObject GObject.Object.Object) object
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  object'


-- | Connect a signal handler for the [unbind](#signal:unbind) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' signalListItemFactory #unbind callback
-- @
-- 
-- 
onSignalListItemFactoryUnbind :: (IsSignalListItemFactory a, MonadIO m) => a -> ((?self :: a) => SignalListItemFactoryUnbindCallback) -> m SignalHandlerId
onSignalListItemFactoryUnbind obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalListItemFactoryUnbindCallback wrapped
    wrapped'' <- mk_SignalListItemFactoryUnbindCallback wrapped'
    connectSignalFunPtr obj "unbind" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [unbind](#signal:unbind) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' signalListItemFactory #unbind callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterSignalListItemFactoryUnbind :: (IsSignalListItemFactory a, MonadIO m) => a -> ((?self :: a) => SignalListItemFactoryUnbindCallback) -> m SignalHandlerId
afterSignalListItemFactoryUnbind obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_SignalListItemFactoryUnbindCallback wrapped
    wrapped'' <- mk_SignalListItemFactoryUnbindCallback wrapped'
    connectSignalFunPtr obj "unbind" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data SignalListItemFactoryUnbindSignalInfo
instance SignalInfo SignalListItemFactoryUnbindSignalInfo where
    type HaskellCallbackType SignalListItemFactoryUnbindSignalInfo = SignalListItemFactoryUnbindCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_SignalListItemFactoryUnbindCallback cb
        cb'' <- mk_SignalListItemFactoryUnbindCallback cb'
        connectSignalFunPtr obj "unbind" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SignalListItemFactory::unbind"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SignalListItemFactory.html#g:signal:unbind"})

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SignalListItemFactory
type instance O.AttributeList SignalListItemFactory = SignalListItemFactoryAttributeList
type SignalListItemFactoryAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SignalListItemFactory = SignalListItemFactorySignalList
type SignalListItemFactorySignalList = ('[ '("bind", SignalListItemFactoryBindSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("setup", SignalListItemFactorySetupSignalInfo), '("teardown", SignalListItemFactoryTeardownSignalInfo), '("unbind", SignalListItemFactoryUnbindSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SignalListItemFactory::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "SignalListItemFactory" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_signal_list_item_factory_new" gtk_signal_list_item_factory_new :: 
    IO (Ptr SignalListItemFactory)

-- | Creates a new @GtkSignalListItemFactory@.
-- 
-- You need to connect signal handlers before you use it.
signalListItemFactoryNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m SignalListItemFactory
    -- ^ __Returns:__ a new @GtkSignalListItemFactory@
signalListItemFactoryNew  = liftIO $ do
    result <- gtk_signal_list_item_factory_new
    checkUnexpectedReturnNULL "signalListItemFactoryNew" result
    result' <- (wrapObject SignalListItemFactory) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


