{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Emits a signal on a widget.
-- 
-- Signals that are used in this way are referred to as keybinding signals,
-- and they are expected to be defined with the @G_SIGNAL_ACTION@ flag.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.SignalAction
    ( 

-- * Exported types
    SignalAction(..)                        ,
    IsSignalAction                          ,
    toSignalAction                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [activate]("GI.Gtk.Objects.ShortcutAction#g:method:activate"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [print]("GI.Gtk.Objects.ShortcutAction#g:method:print"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gtk.Objects.ShortcutAction#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSignalName]("GI.Gtk.Objects.SignalAction#g:method:getSignalName").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveSignalActionMethod               ,
#endif

-- ** getSignalName #method:getSignalName#

#if defined(ENABLE_OVERLOADING)
    SignalActionGetSignalNameMethodInfo     ,
#endif
    signalActionGetSignalName               ,


-- ** new #method:new#

    signalActionNew                         ,




 -- * Properties


-- ** signalName #attr:signalName#
-- | The name of the signal to emit.

#if defined(ENABLE_OVERLOADING)
    SignalActionSignalNamePropertyInfo      ,
#endif
    constructSignalActionSignalName         ,
    getSignalActionSignalName               ,
#if defined(ENABLE_OVERLOADING)
    signalActionSignalName                  ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutAction as Gtk.ShortcutAction
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutAction as Gtk.ShortcutAction

#endif

-- | Memory-managed wrapper type.
newtype SignalAction = SignalAction (SP.ManagedPtr SignalAction)
    deriving (Eq)

instance SP.ManagedPtrNewtype SignalAction where
    toManagedPtr (SignalAction p) = p

foreign import ccall "gtk_signal_action_get_type"
    c_gtk_signal_action_get_type :: IO B.Types.GType

instance B.Types.TypedObject SignalAction where
    glibType = c_gtk_signal_action_get_type

instance B.Types.GObject SignalAction

-- | Type class for types which can be safely cast to `SignalAction`, for instance with `toSignalAction`.
class (SP.GObject o, O.IsDescendantOf SignalAction o) => IsSignalAction o
instance (SP.GObject o, O.IsDescendantOf SignalAction o) => IsSignalAction o

instance O.HasParentTypes SignalAction
type instance O.ParentTypes SignalAction = '[Gtk.ShortcutAction.ShortcutAction, GObject.Object.Object]

-- | Cast to `SignalAction`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toSignalAction :: (MIO.MonadIO m, IsSignalAction o) => o -> m SignalAction
toSignalAction = MIO.liftIO . B.ManagedPtr.unsafeCastTo SignalAction

-- | Convert 'SignalAction' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe SignalAction) where
    gvalueGType_ = c_gtk_signal_action_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr SignalAction)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr SignalAction)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject SignalAction ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveSignalActionMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveSignalActionMethod "activate" o = Gtk.ShortcutAction.ShortcutActionActivateMethodInfo
    ResolveSignalActionMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveSignalActionMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveSignalActionMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveSignalActionMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveSignalActionMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveSignalActionMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveSignalActionMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveSignalActionMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveSignalActionMethod "print" o = Gtk.ShortcutAction.ShortcutActionPrintMethodInfo
    ResolveSignalActionMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveSignalActionMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveSignalActionMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveSignalActionMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveSignalActionMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveSignalActionMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveSignalActionMethod "toString" o = Gtk.ShortcutAction.ShortcutActionToStringMethodInfo
    ResolveSignalActionMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveSignalActionMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveSignalActionMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveSignalActionMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveSignalActionMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveSignalActionMethod "getSignalName" o = SignalActionGetSignalNameMethodInfo
    ResolveSignalActionMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveSignalActionMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveSignalActionMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveSignalActionMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveSignalActionMethod t SignalAction, O.OverloadedMethod info SignalAction p) => OL.IsLabel t (SignalAction -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveSignalActionMethod t SignalAction, O.OverloadedMethod info SignalAction p, R.HasField t SignalAction p) => R.HasField t SignalAction p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveSignalActionMethod t SignalAction, O.OverloadedMethodInfo info SignalAction) => OL.IsLabel t (O.MethodProxy info SignalAction) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "signal-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@signal-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' signalAction #signalName
-- @
getSignalActionSignalName :: (MonadIO m, IsSignalAction o) => o -> m T.Text
getSignalActionSignalName obj = MIO.liftIO $ checkUnexpectedNothing "getSignalActionSignalName" $ B.Properties.getObjectPropertyString obj "signal-name"

-- | Construct a `GValueConstruct` with valid value for the “@signal-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructSignalActionSignalName :: (IsSignalAction o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructSignalActionSignalName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "signal-name" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data SignalActionSignalNamePropertyInfo
instance AttrInfo SignalActionSignalNamePropertyInfo where
    type AttrAllowedOps SignalActionSignalNamePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint SignalActionSignalNamePropertyInfo = IsSignalAction
    type AttrSetTypeConstraint SignalActionSignalNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint SignalActionSignalNamePropertyInfo = (~) T.Text
    type AttrTransferType SignalActionSignalNamePropertyInfo = T.Text
    type AttrGetType SignalActionSignalNamePropertyInfo = T.Text
    type AttrLabel SignalActionSignalNamePropertyInfo = "signal-name"
    type AttrOrigin SignalActionSignalNamePropertyInfo = SignalAction
    attrGet = getSignalActionSignalName
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructSignalActionSignalName
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SignalAction.signalName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SignalAction.html#g:attr:signalName"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList SignalAction
type instance O.AttributeList SignalAction = SignalActionAttributeList
type SignalActionAttributeList = ('[ '("signalName", SignalActionSignalNamePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
signalActionSignalName :: AttrLabelProxy "signalName"
signalActionSignalName = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList SignalAction = SignalActionSignalList
type SignalActionSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method SignalAction::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "signal_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "name of the signal to emit"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "SignalAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_signal_action_new" gtk_signal_action_new :: 
    CString ->                              -- signal_name : TBasicType TUTF8
    IO (Ptr SignalAction)

-- | Creates an action that when activated, emits the given action signal
-- on the provided widget.
-- 
-- It will also unpack the args into arguments passed to the signal.
signalActionNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@signalName@/: name of the signal to emit
    -> m SignalAction
    -- ^ __Returns:__ a new @GtkShortcutAction@
signalActionNew signalName = liftIO $ do
    signalName' <- textToCString signalName
    result <- gtk_signal_action_new signalName'
    checkUnexpectedReturnNULL "signalActionNew" result
    result' <- (wrapObject SignalAction) result
    freeMem signalName'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method SignalAction::get_signal_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "SignalAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a signal action" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_signal_action_get_signal_name" gtk_signal_action_get_signal_name :: 
    Ptr SignalAction ->                     -- self : TInterface (Name {namespace = "Gtk", name = "SignalAction"})
    IO CString

-- | Returns the name of the signal that will be emitted.
signalActionGetSignalName ::
    (B.CallStack.HasCallStack, MonadIO m, IsSignalAction a) =>
    a
    -- ^ /@self@/: a signal action
    -> m T.Text
    -- ^ __Returns:__ the name of the signal to emit
signalActionGetSignalName self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_signal_action_get_signal_name self'
    checkUnexpectedReturnNULL "signalActionGetSignalName" result
    result' <- cstringToText result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data SignalActionGetSignalNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsSignalAction a) => O.OverloadedMethod SignalActionGetSignalNameMethodInfo a signature where
    overloadedMethod = signalActionGetSignalName

instance O.OverloadedMethodInfo SignalActionGetSignalNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.SignalAction.signalActionGetSignalName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-SignalAction.html#v:signalActionGetSignalName"
        })


#endif


