{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GtkShortcutsGroup@ represents a group of related keyboard shortcuts
-- or gestures.
-- 
-- The group has a title. It may optionally be associated with a view
-- of the application, which can be used to show only relevant shortcuts
-- depending on the application context.
-- 
-- This widget is only meant to be used with t'GI.Gtk.Objects.ShortcutsWindow.ShortcutsWindow'.
-- 
-- The recommended way to construct a @GtkShortcutsGroup@ is with
-- t'GI.Gtk.Objects.Builder.Builder', by using the @\<child>@ tag to populate a
-- @GtkShortcutsGroup@ with one or more t'GI.Gtk.Objects.ShortcutsShortcut.ShortcutsShortcut'
-- instances.
-- 
-- If you need to add a shortcut programmatically, use
-- 'GI.Gtk.Objects.ShortcutsGroup.shortcutsGroupAddShortcut'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ShortcutsGroup
    ( 

-- * Exported types
    ShortcutsGroup(..)                      ,
    IsShortcutsGroup                        ,
    toShortcutsGroup                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addShortcut]("GI.Gtk.Objects.ShortcutsGroup#g:method:addShortcut"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [append]("GI.Gtk.Objects.Box#g:method:append"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [insertChildAfter]("GI.Gtk.Objects.Box#g:method:insertChildAfter"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [prepend]("GI.Gtk.Objects.Box#g:method:prepend"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [remove]("GI.Gtk.Objects.Box#g:method:remove"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [reorderChildAfter]("GI.Gtk.Objects.Box#g:method:reorderChildAfter"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBaselineChild]("GI.Gtk.Objects.Box#g:method:getBaselineChild"), [getBaselinePosition]("GI.Gtk.Objects.Box#g:method:getBaselinePosition"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHomogeneous]("GI.Gtk.Objects.Box#g:method:getHomogeneous"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getSpacing]("GI.Gtk.Objects.Box#g:method:getSpacing"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setBaselineChild]("GI.Gtk.Objects.Box#g:method:setBaselineChild"), [setBaselinePosition]("GI.Gtk.Objects.Box#g:method:setBaselinePosition"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHomogeneous]("GI.Gtk.Objects.Box#g:method:setHomogeneous"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setSpacing]("GI.Gtk.Objects.Box#g:method:setSpacing"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveShortcutsGroupMethod             ,
#endif

-- ** addShortcut #method:addShortcut#

#if defined(ENABLE_OVERLOADING)
    ShortcutsGroupAddShortcutMethodInfo     ,
#endif
    shortcutsGroupAddShortcut               ,




 -- * Properties


-- ** accelSizeGroup #attr:accelSizeGroup#
-- | The size group for the accelerator portion of shortcuts in this group.
-- 
-- This is used internally by GTK, and must not be modified by applications.

#if defined(ENABLE_OVERLOADING)
    ShortcutsGroupAccelSizeGroupPropertyInfo,
#endif
    clearShortcutsGroupAccelSizeGroup       ,
    constructShortcutsGroupAccelSizeGroup   ,
    setShortcutsGroupAccelSizeGroup         ,
#if defined(ENABLE_OVERLOADING)
    shortcutsGroupAccelSizeGroup            ,
#endif


-- ** height #attr:height#
-- | A rough measure for the number of lines in this group.
-- 
-- This is used internally by GTK, and is not useful for applications.

#if defined(ENABLE_OVERLOADING)
    ShortcutsGroupHeightPropertyInfo        ,
#endif
    getShortcutsGroupHeight                 ,
#if defined(ENABLE_OVERLOADING)
    shortcutsGroupHeight                    ,
#endif


-- ** title #attr:title#
-- | The title for this group of shortcuts.

#if defined(ENABLE_OVERLOADING)
    ShortcutsGroupTitlePropertyInfo         ,
#endif
    clearShortcutsGroupTitle                ,
    constructShortcutsGroupTitle            ,
    getShortcutsGroupTitle                  ,
    setShortcutsGroupTitle                  ,
#if defined(ENABLE_OVERLOADING)
    shortcutsGroupTitle                     ,
#endif


-- ** titleSizeGroup #attr:titleSizeGroup#
-- | The size group for the textual portion of shortcuts in this group.
-- 
-- This is used internally by GTK, and must not be modified by applications.

#if defined(ENABLE_OVERLOADING)
    ShortcutsGroupTitleSizeGroupPropertyInfo,
#endif
    clearShortcutsGroupTitleSizeGroup       ,
    constructShortcutsGroupTitleSizeGroup   ,
    setShortcutsGroupTitleSizeGroup         ,
#if defined(ENABLE_OVERLOADING)
    shortcutsGroupTitleSizeGroup            ,
#endif


-- ** view #attr:view#
-- | An optional view that the shortcuts in this group are relevant for.
-- 
-- The group will be hidden if the [ShortcutsWindow:viewName]("GI.Gtk.Objects.ShortcutsWindow#g:attr:viewName")
-- property does not match the view of this group.
-- 
-- Set this to 'P.Nothing' to make the group always visible.

#if defined(ENABLE_OVERLOADING)
    ShortcutsGroupViewPropertyInfo          ,
#endif
    clearShortcutsGroupView                 ,
    constructShortcutsGroupView             ,
    getShortcutsGroupView                   ,
    setShortcutsGroupView                   ,
#if defined(ENABLE_OVERLOADING)
    shortcutsGroupView                      ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Box as Gtk.Box
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutsShortcut as Gtk.ShortcutsShortcut
import {-# SOURCE #-} qualified GI.Gtk.Objects.SizeGroup as Gtk.SizeGroup
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Box as Gtk.Box
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutsShortcut as Gtk.ShortcutsShortcut
import {-# SOURCE #-} qualified GI.Gtk.Objects.SizeGroup as Gtk.SizeGroup
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype ShortcutsGroup = ShortcutsGroup (SP.ManagedPtr ShortcutsGroup)
    deriving (Eq)

instance SP.ManagedPtrNewtype ShortcutsGroup where
    toManagedPtr (ShortcutsGroup p) = p

foreign import ccall "gtk_shortcuts_group_get_type"
    c_gtk_shortcuts_group_get_type :: IO B.Types.GType

instance B.Types.TypedObject ShortcutsGroup where
    glibType = c_gtk_shortcuts_group_get_type

instance B.Types.GObject ShortcutsGroup

-- | Type class for types which can be safely cast to `ShortcutsGroup`, for instance with `toShortcutsGroup`.
class (SP.GObject o, O.IsDescendantOf ShortcutsGroup o) => IsShortcutsGroup o
instance (SP.GObject o, O.IsDescendantOf ShortcutsGroup o) => IsShortcutsGroup o

instance O.HasParentTypes ShortcutsGroup
type instance O.ParentTypes ShortcutsGroup = '[Gtk.Box.Box, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Orientable.Orientable]

-- | Cast to `ShortcutsGroup`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toShortcutsGroup :: (MIO.MonadIO m, IsShortcutsGroup o) => o -> m ShortcutsGroup
toShortcutsGroup = MIO.liftIO . B.ManagedPtr.unsafeCastTo ShortcutsGroup

-- | Convert 'ShortcutsGroup' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ShortcutsGroup) where
    gvalueGType_ = c_gtk_shortcuts_group_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ShortcutsGroup)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ShortcutsGroup)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ShortcutsGroup ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveShortcutsGroupMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveShortcutsGroupMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveShortcutsGroupMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveShortcutsGroupMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveShortcutsGroupMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveShortcutsGroupMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveShortcutsGroupMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveShortcutsGroupMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveShortcutsGroupMethod "addShortcut" o = ShortcutsGroupAddShortcutMethodInfo
    ResolveShortcutsGroupMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveShortcutsGroupMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveShortcutsGroupMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveShortcutsGroupMethod "append" o = Gtk.Box.BoxAppendMethodInfo
    ResolveShortcutsGroupMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveShortcutsGroupMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveShortcutsGroupMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveShortcutsGroupMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveShortcutsGroupMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveShortcutsGroupMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveShortcutsGroupMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveShortcutsGroupMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveShortcutsGroupMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveShortcutsGroupMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveShortcutsGroupMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveShortcutsGroupMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveShortcutsGroupMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveShortcutsGroupMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveShortcutsGroupMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveShortcutsGroupMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveShortcutsGroupMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveShortcutsGroupMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveShortcutsGroupMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveShortcutsGroupMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveShortcutsGroupMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveShortcutsGroupMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveShortcutsGroupMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveShortcutsGroupMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveShortcutsGroupMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveShortcutsGroupMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveShortcutsGroupMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveShortcutsGroupMethod "insertChildAfter" o = Gtk.Box.BoxInsertChildAfterMethodInfo
    ResolveShortcutsGroupMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveShortcutsGroupMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveShortcutsGroupMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveShortcutsGroupMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveShortcutsGroupMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveShortcutsGroupMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveShortcutsGroupMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveShortcutsGroupMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveShortcutsGroupMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveShortcutsGroupMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveShortcutsGroupMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveShortcutsGroupMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveShortcutsGroupMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveShortcutsGroupMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveShortcutsGroupMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveShortcutsGroupMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveShortcutsGroupMethod "prepend" o = Gtk.Box.BoxPrependMethodInfo
    ResolveShortcutsGroupMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveShortcutsGroupMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveShortcutsGroupMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveShortcutsGroupMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveShortcutsGroupMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveShortcutsGroupMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveShortcutsGroupMethod "remove" o = Gtk.Box.BoxRemoveMethodInfo
    ResolveShortcutsGroupMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveShortcutsGroupMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveShortcutsGroupMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveShortcutsGroupMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveShortcutsGroupMethod "reorderChildAfter" o = Gtk.Box.BoxReorderChildAfterMethodInfo
    ResolveShortcutsGroupMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveShortcutsGroupMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveShortcutsGroupMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveShortcutsGroupMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveShortcutsGroupMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveShortcutsGroupMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveShortcutsGroupMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveShortcutsGroupMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveShortcutsGroupMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveShortcutsGroupMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveShortcutsGroupMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveShortcutsGroupMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveShortcutsGroupMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveShortcutsGroupMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveShortcutsGroupMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveShortcutsGroupMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveShortcutsGroupMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveShortcutsGroupMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveShortcutsGroupMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveShortcutsGroupMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveShortcutsGroupMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveShortcutsGroupMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveShortcutsGroupMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveShortcutsGroupMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveShortcutsGroupMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveShortcutsGroupMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveShortcutsGroupMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveShortcutsGroupMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveShortcutsGroupMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveShortcutsGroupMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveShortcutsGroupMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveShortcutsGroupMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveShortcutsGroupMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveShortcutsGroupMethod "getBaselineChild" o = Gtk.Box.BoxGetBaselineChildMethodInfo
    ResolveShortcutsGroupMethod "getBaselinePosition" o = Gtk.Box.BoxGetBaselinePositionMethodInfo
    ResolveShortcutsGroupMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveShortcutsGroupMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveShortcutsGroupMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveShortcutsGroupMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveShortcutsGroupMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveShortcutsGroupMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveShortcutsGroupMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveShortcutsGroupMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveShortcutsGroupMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveShortcutsGroupMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveShortcutsGroupMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveShortcutsGroupMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveShortcutsGroupMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveShortcutsGroupMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveShortcutsGroupMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveShortcutsGroupMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveShortcutsGroupMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveShortcutsGroupMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveShortcutsGroupMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveShortcutsGroupMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveShortcutsGroupMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveShortcutsGroupMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveShortcutsGroupMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveShortcutsGroupMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveShortcutsGroupMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveShortcutsGroupMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveShortcutsGroupMethod "getHomogeneous" o = Gtk.Box.BoxGetHomogeneousMethodInfo
    ResolveShortcutsGroupMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveShortcutsGroupMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveShortcutsGroupMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveShortcutsGroupMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveShortcutsGroupMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveShortcutsGroupMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveShortcutsGroupMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveShortcutsGroupMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveShortcutsGroupMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveShortcutsGroupMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveShortcutsGroupMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveShortcutsGroupMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveShortcutsGroupMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveShortcutsGroupMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveShortcutsGroupMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveShortcutsGroupMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveShortcutsGroupMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveShortcutsGroupMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveShortcutsGroupMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveShortcutsGroupMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveShortcutsGroupMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveShortcutsGroupMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveShortcutsGroupMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveShortcutsGroupMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveShortcutsGroupMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveShortcutsGroupMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveShortcutsGroupMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveShortcutsGroupMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveShortcutsGroupMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveShortcutsGroupMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveShortcutsGroupMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveShortcutsGroupMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveShortcutsGroupMethod "getSpacing" o = Gtk.Box.BoxGetSpacingMethodInfo
    ResolveShortcutsGroupMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveShortcutsGroupMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveShortcutsGroupMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveShortcutsGroupMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveShortcutsGroupMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveShortcutsGroupMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveShortcutsGroupMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveShortcutsGroupMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveShortcutsGroupMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveShortcutsGroupMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveShortcutsGroupMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveShortcutsGroupMethod "setBaselineChild" o = Gtk.Box.BoxSetBaselineChildMethodInfo
    ResolveShortcutsGroupMethod "setBaselinePosition" o = Gtk.Box.BoxSetBaselinePositionMethodInfo
    ResolveShortcutsGroupMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveShortcutsGroupMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveShortcutsGroupMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveShortcutsGroupMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveShortcutsGroupMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveShortcutsGroupMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveShortcutsGroupMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveShortcutsGroupMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveShortcutsGroupMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveShortcutsGroupMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveShortcutsGroupMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveShortcutsGroupMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveShortcutsGroupMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveShortcutsGroupMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveShortcutsGroupMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveShortcutsGroupMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveShortcutsGroupMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveShortcutsGroupMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveShortcutsGroupMethod "setHomogeneous" o = Gtk.Box.BoxSetHomogeneousMethodInfo
    ResolveShortcutsGroupMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveShortcutsGroupMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveShortcutsGroupMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveShortcutsGroupMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveShortcutsGroupMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveShortcutsGroupMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveShortcutsGroupMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveShortcutsGroupMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveShortcutsGroupMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveShortcutsGroupMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveShortcutsGroupMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveShortcutsGroupMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveShortcutsGroupMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveShortcutsGroupMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveShortcutsGroupMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveShortcutsGroupMethod "setSpacing" o = Gtk.Box.BoxSetSpacingMethodInfo
    ResolveShortcutsGroupMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveShortcutsGroupMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveShortcutsGroupMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveShortcutsGroupMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveShortcutsGroupMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveShortcutsGroupMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveShortcutsGroupMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveShortcutsGroupMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveShortcutsGroupMethod t ShortcutsGroup, O.OverloadedMethod info ShortcutsGroup p) => OL.IsLabel t (ShortcutsGroup -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveShortcutsGroupMethod t ShortcutsGroup, O.OverloadedMethod info ShortcutsGroup p, R.HasField t ShortcutsGroup p) => R.HasField t ShortcutsGroup p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveShortcutsGroupMethod t ShortcutsGroup, O.OverloadedMethodInfo info ShortcutsGroup) => OL.IsLabel t (O.MethodProxy info ShortcutsGroup) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "accel-size-group"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SizeGroup"})
   -- Flags: [PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Set the value of the “@accel-size-group@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsGroup [ #accelSizeGroup 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsGroupAccelSizeGroup :: (MonadIO m, IsShortcutsGroup o, Gtk.SizeGroup.IsSizeGroup a) => o -> a -> m ()
setShortcutsGroupAccelSizeGroup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "accel-size-group" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@accel-size-group@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsGroupAccelSizeGroup :: (IsShortcutsGroup o, MIO.MonadIO m, Gtk.SizeGroup.IsSizeGroup a) => a -> m (GValueConstruct o)
constructShortcutsGroupAccelSizeGroup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "accel-size-group" (P.Just val)

-- | Set the value of the “@accel-size-group@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #accelSizeGroup
-- @
clearShortcutsGroupAccelSizeGroup :: (MonadIO m, IsShortcutsGroup o) => o -> m ()
clearShortcutsGroupAccelSizeGroup obj = liftIO $ B.Properties.setObjectPropertyObject obj "accel-size-group" (Nothing :: Maybe Gtk.SizeGroup.SizeGroup)

#if defined(ENABLE_OVERLOADING)
data ShortcutsGroupAccelSizeGroupPropertyInfo
instance AttrInfo ShortcutsGroupAccelSizeGroupPropertyInfo where
    type AttrAllowedOps ShortcutsGroupAccelSizeGroupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutsGroupAccelSizeGroupPropertyInfo = IsShortcutsGroup
    type AttrSetTypeConstraint ShortcutsGroupAccelSizeGroupPropertyInfo = Gtk.SizeGroup.IsSizeGroup
    type AttrTransferTypeConstraint ShortcutsGroupAccelSizeGroupPropertyInfo = Gtk.SizeGroup.IsSizeGroup
    type AttrTransferType ShortcutsGroupAccelSizeGroupPropertyInfo = Gtk.SizeGroup.SizeGroup
    type AttrGetType ShortcutsGroupAccelSizeGroupPropertyInfo = ()
    type AttrLabel ShortcutsGroupAccelSizeGroupPropertyInfo = "accel-size-group"
    type AttrOrigin ShortcutsGroupAccelSizeGroupPropertyInfo = ShortcutsGroup
    attrGet = undefined
    attrSet = setShortcutsGroupAccelSizeGroup
    attrTransfer _ v = do
        unsafeCastTo Gtk.SizeGroup.SizeGroup v
    attrConstruct = constructShortcutsGroupAccelSizeGroup
    attrClear = clearShortcutsGroupAccelSizeGroup
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsGroup.accelSizeGroup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ShortcutsGroup.html#g:attr:accelSizeGroup"
        })
#endif

-- VVV Prop "height"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsGroup #height
-- @
getShortcutsGroupHeight :: (MonadIO m, IsShortcutsGroup o) => o -> m Word32
getShortcutsGroupHeight obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "height"

#if defined(ENABLE_OVERLOADING)
data ShortcutsGroupHeightPropertyInfo
instance AttrInfo ShortcutsGroupHeightPropertyInfo where
    type AttrAllowedOps ShortcutsGroupHeightPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ShortcutsGroupHeightPropertyInfo = IsShortcutsGroup
    type AttrSetTypeConstraint ShortcutsGroupHeightPropertyInfo = (~) ()
    type AttrTransferTypeConstraint ShortcutsGroupHeightPropertyInfo = (~) ()
    type AttrTransferType ShortcutsGroupHeightPropertyInfo = ()
    type AttrGetType ShortcutsGroupHeightPropertyInfo = Word32
    type AttrLabel ShortcutsGroupHeightPropertyInfo = "height"
    type AttrOrigin ShortcutsGroupHeightPropertyInfo = ShortcutsGroup
    attrGet = getShortcutsGroupHeight
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsGroup.height"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ShortcutsGroup.html#g:attr:height"
        })
#endif

-- VVV Prop "title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsGroup #title
-- @
getShortcutsGroupTitle :: (MonadIO m, IsShortcutsGroup o) => o -> m (Maybe T.Text)
getShortcutsGroupTitle obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "title"

-- | Set the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsGroup [ #title 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsGroupTitle :: (MonadIO m, IsShortcutsGroup o) => o -> T.Text -> m ()
setShortcutsGroupTitle obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "title" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@title@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsGroupTitle :: (IsShortcutsGroup o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructShortcutsGroupTitle val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "title" (P.Just val)

-- | Set the value of the “@title@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #title
-- @
clearShortcutsGroupTitle :: (MonadIO m, IsShortcutsGroup o) => o -> m ()
clearShortcutsGroupTitle obj = liftIO $ B.Properties.setObjectPropertyString obj "title" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ShortcutsGroupTitlePropertyInfo
instance AttrInfo ShortcutsGroupTitlePropertyInfo where
    type AttrAllowedOps ShortcutsGroupTitlePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutsGroupTitlePropertyInfo = IsShortcutsGroup
    type AttrSetTypeConstraint ShortcutsGroupTitlePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ShortcutsGroupTitlePropertyInfo = (~) T.Text
    type AttrTransferType ShortcutsGroupTitlePropertyInfo = T.Text
    type AttrGetType ShortcutsGroupTitlePropertyInfo = (Maybe T.Text)
    type AttrLabel ShortcutsGroupTitlePropertyInfo = "title"
    type AttrOrigin ShortcutsGroupTitlePropertyInfo = ShortcutsGroup
    attrGet = getShortcutsGroupTitle
    attrSet = setShortcutsGroupTitle
    attrTransfer _ v = do
        return v
    attrConstruct = constructShortcutsGroupTitle
    attrClear = clearShortcutsGroupTitle
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsGroup.title"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ShortcutsGroup.html#g:attr:title"
        })
#endif

-- VVV Prop "title-size-group"
   -- Type: TInterface (Name {namespace = "Gtk", name = "SizeGroup"})
   -- Flags: [PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Set the value of the “@title-size-group@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsGroup [ #titleSizeGroup 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsGroupTitleSizeGroup :: (MonadIO m, IsShortcutsGroup o, Gtk.SizeGroup.IsSizeGroup a) => o -> a -> m ()
setShortcutsGroupTitleSizeGroup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "title-size-group" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@title-size-group@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsGroupTitleSizeGroup :: (IsShortcutsGroup o, MIO.MonadIO m, Gtk.SizeGroup.IsSizeGroup a) => a -> m (GValueConstruct o)
constructShortcutsGroupTitleSizeGroup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "title-size-group" (P.Just val)

-- | Set the value of the “@title-size-group@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #titleSizeGroup
-- @
clearShortcutsGroupTitleSizeGroup :: (MonadIO m, IsShortcutsGroup o) => o -> m ()
clearShortcutsGroupTitleSizeGroup obj = liftIO $ B.Properties.setObjectPropertyObject obj "title-size-group" (Nothing :: Maybe Gtk.SizeGroup.SizeGroup)

#if defined(ENABLE_OVERLOADING)
data ShortcutsGroupTitleSizeGroupPropertyInfo
instance AttrInfo ShortcutsGroupTitleSizeGroupPropertyInfo where
    type AttrAllowedOps ShortcutsGroupTitleSizeGroupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutsGroupTitleSizeGroupPropertyInfo = IsShortcutsGroup
    type AttrSetTypeConstraint ShortcutsGroupTitleSizeGroupPropertyInfo = Gtk.SizeGroup.IsSizeGroup
    type AttrTransferTypeConstraint ShortcutsGroupTitleSizeGroupPropertyInfo = Gtk.SizeGroup.IsSizeGroup
    type AttrTransferType ShortcutsGroupTitleSizeGroupPropertyInfo = Gtk.SizeGroup.SizeGroup
    type AttrGetType ShortcutsGroupTitleSizeGroupPropertyInfo = ()
    type AttrLabel ShortcutsGroupTitleSizeGroupPropertyInfo = "title-size-group"
    type AttrOrigin ShortcutsGroupTitleSizeGroupPropertyInfo = ShortcutsGroup
    attrGet = undefined
    attrSet = setShortcutsGroupTitleSizeGroup
    attrTransfer _ v = do
        unsafeCastTo Gtk.SizeGroup.SizeGroup v
    attrConstruct = constructShortcutsGroupTitleSizeGroup
    attrClear = clearShortcutsGroupTitleSizeGroup
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsGroup.titleSizeGroup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ShortcutsGroup.html#g:attr:titleSizeGroup"
        })
#endif

-- VVV Prop "view"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@view@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcutsGroup #view
-- @
getShortcutsGroupView :: (MonadIO m, IsShortcutsGroup o) => o -> m (Maybe T.Text)
getShortcutsGroupView obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "view"

-- | Set the value of the “@view@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcutsGroup [ #view 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutsGroupView :: (MonadIO m, IsShortcutsGroup o) => o -> T.Text -> m ()
setShortcutsGroupView obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "view" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@view@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutsGroupView :: (IsShortcutsGroup o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructShortcutsGroupView val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "view" (P.Just val)

-- | Set the value of the “@view@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #view
-- @
clearShortcutsGroupView :: (MonadIO m, IsShortcutsGroup o) => o -> m ()
clearShortcutsGroupView obj = liftIO $ B.Properties.setObjectPropertyString obj "view" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ShortcutsGroupViewPropertyInfo
instance AttrInfo ShortcutsGroupViewPropertyInfo where
    type AttrAllowedOps ShortcutsGroupViewPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutsGroupViewPropertyInfo = IsShortcutsGroup
    type AttrSetTypeConstraint ShortcutsGroupViewPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ShortcutsGroupViewPropertyInfo = (~) T.Text
    type AttrTransferType ShortcutsGroupViewPropertyInfo = T.Text
    type AttrGetType ShortcutsGroupViewPropertyInfo = (Maybe T.Text)
    type AttrLabel ShortcutsGroupViewPropertyInfo = "view"
    type AttrOrigin ShortcutsGroupViewPropertyInfo = ShortcutsGroup
    attrGet = getShortcutsGroupView
    attrSet = setShortcutsGroupView
    attrTransfer _ v = do
        return v
    attrConstruct = constructShortcutsGroupView
    attrClear = clearShortcutsGroupView
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsGroup.view"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ShortcutsGroup.html#g:attr:view"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ShortcutsGroup
type instance O.AttributeList ShortcutsGroup = ShortcutsGroupAttributeList
type ShortcutsGroupAttributeList = ('[ '("accelSizeGroup", ShortcutsGroupAccelSizeGroupPropertyInfo), '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("baselineChild", Gtk.Box.BoxBaselineChildPropertyInfo), '("baselinePosition", Gtk.Box.BoxBaselinePositionPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("height", ShortcutsGroupHeightPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("homogeneous", Gtk.Box.BoxHomogeneousPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.Orientable.OrientableOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("spacing", Gtk.Box.BoxSpacingPropertyInfo), '("title", ShortcutsGroupTitlePropertyInfo), '("titleSizeGroup", ShortcutsGroupTitleSizeGroupPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("view", ShortcutsGroupViewPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
shortcutsGroupAccelSizeGroup :: AttrLabelProxy "accelSizeGroup"
shortcutsGroupAccelSizeGroup = AttrLabelProxy

shortcutsGroupHeight :: AttrLabelProxy "height"
shortcutsGroupHeight = AttrLabelProxy

shortcutsGroupTitle :: AttrLabelProxy "title"
shortcutsGroupTitle = AttrLabelProxy

shortcutsGroupTitleSizeGroup :: AttrLabelProxy "titleSizeGroup"
shortcutsGroupTitleSizeGroup = AttrLabelProxy

shortcutsGroupView :: AttrLabelProxy "view"
shortcutsGroupView = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ShortcutsGroup = ShortcutsGroupSignalList
type ShortcutsGroupSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ShortcutsGroup::add_shortcut
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ShortcutsGroup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkShortcutsGroup`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "shortcut"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ShortcutsShortcut" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkShortcutsShortcut` to add"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_shortcuts_group_add_shortcut" gtk_shortcuts_group_add_shortcut :: 
    Ptr ShortcutsGroup ->                   -- self : TInterface (Name {namespace = "Gtk", name = "ShortcutsGroup"})
    Ptr Gtk.ShortcutsShortcut.ShortcutsShortcut -> -- shortcut : TInterface (Name {namespace = "Gtk", name = "ShortcutsShortcut"})
    IO ()

{-# DEPRECATED shortcutsGroupAddShortcut ["(Since version 4.18)","This widget will be removed in GTK 5"] #-}
-- | Adds a shortcut to the shortcuts group.
-- 
-- This is the programmatic equivalent to using t'GI.Gtk.Objects.Builder.Builder' and a
-- @\<child>@ tag to add the child. Adding children with other API is not
-- appropriate as @GtkShortcutsGroup@ manages its children internally.
-- 
-- /Since: 4.14/
shortcutsGroupAddShortcut ::
    (B.CallStack.HasCallStack, MonadIO m, IsShortcutsGroup a, Gtk.ShortcutsShortcut.IsShortcutsShortcut b) =>
    a
    -- ^ /@self@/: a @GtkShortcutsGroup@
    -> b
    -- ^ /@shortcut@/: the @GtkShortcutsShortcut@ to add
    -> m ()
shortcutsGroupAddShortcut self shortcut = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    shortcut' <- unsafeManagedPtrCastPtr shortcut
    gtk_shortcuts_group_add_shortcut self' shortcut'
    touchManagedPtr self
    touchManagedPtr shortcut
    return ()

#if defined(ENABLE_OVERLOADING)
data ShortcutsGroupAddShortcutMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsShortcutsGroup a, Gtk.ShortcutsShortcut.IsShortcutsShortcut b) => O.OverloadedMethod ShortcutsGroupAddShortcutMethodInfo a signature where
    overloadedMethod = shortcutsGroupAddShortcut

instance O.OverloadedMethodInfo ShortcutsGroupAddShortcutMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ShortcutsGroup.shortcutsGroupAddShortcut",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ShortcutsGroup.html#v:shortcutsGroupAddShortcut"
        })


#endif


