{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Describes a keyboard shortcut.
-- 
-- It contains a description of how to trigger the shortcut via a
-- t'GI.Gtk.Objects.ShortcutTrigger.ShortcutTrigger' and a way to activate the shortcut
-- on a widget via a t'GI.Gtk.Objects.ShortcutAction.ShortcutAction'.
-- 
-- The actual work is usually done via t'GI.Gtk.Objects.ShortcutController.ShortcutController',
-- which decides if and when to activate a shortcut. Using that controller
-- directly however is rarely necessary as various higher level
-- convenience APIs exist on @GtkWidget@s that make it easier to use
-- shortcuts in GTK.
-- 
-- @GtkShortcut@ does provide functionality to make it easy for users
-- to work with shortcuts, either by providing informational strings
-- for display purposes or by allowing shortcuts to be configured.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Shortcut
    ( 

-- * Exported types
    Shortcut(..)                            ,
    IsShortcut                              ,
    toShortcut                              ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAction]("GI.Gtk.Objects.Shortcut#g:method:getAction"), [getArguments]("GI.Gtk.Objects.Shortcut#g:method:getArguments"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getTrigger]("GI.Gtk.Objects.Shortcut#g:method:getTrigger").
-- 
-- ==== Setters
-- [setAction]("GI.Gtk.Objects.Shortcut#g:method:setAction"), [setArguments]("GI.Gtk.Objects.Shortcut#g:method:setArguments"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setTrigger]("GI.Gtk.Objects.Shortcut#g:method:setTrigger").

#if defined(ENABLE_OVERLOADING)
    ResolveShortcutMethod                   ,
#endif

-- ** getAction #method:getAction#

#if defined(ENABLE_OVERLOADING)
    ShortcutGetActionMethodInfo             ,
#endif
    shortcutGetAction                       ,


-- ** getArguments #method:getArguments#

#if defined(ENABLE_OVERLOADING)
    ShortcutGetArgumentsMethodInfo          ,
#endif
    shortcutGetArguments                    ,


-- ** getTrigger #method:getTrigger#

#if defined(ENABLE_OVERLOADING)
    ShortcutGetTriggerMethodInfo            ,
#endif
    shortcutGetTrigger                      ,


-- ** new #method:new#

    shortcutNew                             ,


-- ** setAction #method:setAction#

#if defined(ENABLE_OVERLOADING)
    ShortcutSetActionMethodInfo             ,
#endif
    shortcutSetAction                       ,


-- ** setArguments #method:setArguments#

#if defined(ENABLE_OVERLOADING)
    ShortcutSetArgumentsMethodInfo          ,
#endif
    shortcutSetArguments                    ,


-- ** setTrigger #method:setTrigger#

#if defined(ENABLE_OVERLOADING)
    ShortcutSetTriggerMethodInfo            ,
#endif
    shortcutSetTrigger                      ,




 -- * Properties


-- ** action #attr:action#
-- | The action that gets activated by this shortcut.

#if defined(ENABLE_OVERLOADING)
    ShortcutActionPropertyInfo              ,
#endif
    clearShortcutAction                     ,
    constructShortcutAction                 ,
    getShortcutAction                       ,
    setShortcutAction                       ,
#if defined(ENABLE_OVERLOADING)
    shortcutAction                          ,
#endif


-- ** arguments #attr:arguments#
-- | Arguments passed to activation.

#if defined(ENABLE_OVERLOADING)
    ShortcutArgumentsPropertyInfo           ,
#endif
    clearShortcutArguments                  ,
    constructShortcutArguments              ,
    getShortcutArguments                    ,
    setShortcutArguments                    ,
#if defined(ENABLE_OVERLOADING)
    shortcutArguments                       ,
#endif


-- ** trigger #attr:trigger#
-- | The trigger that triggers this shortcut.

#if defined(ENABLE_OVERLOADING)
    ShortcutTriggerPropertyInfo             ,
#endif
    clearShortcutTrigger                    ,
    constructShortcutTrigger                ,
    getShortcutTrigger                      ,
    setShortcutTrigger                      ,
#if defined(ENABLE_OVERLOADING)
    shortcutTrigger                         ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Enums as Gdk.Enums
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutAction as Gtk.ShortcutAction
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutTrigger as Gtk.ShortcutTrigger
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutAction as Gtk.ShortcutAction
import {-# SOURCE #-} qualified GI.Gtk.Objects.ShortcutTrigger as Gtk.ShortcutTrigger

#endif

-- | Memory-managed wrapper type.
newtype Shortcut = Shortcut (SP.ManagedPtr Shortcut)
    deriving (Eq)

instance SP.ManagedPtrNewtype Shortcut where
    toManagedPtr (Shortcut p) = p

foreign import ccall "gtk_shortcut_get_type"
    c_gtk_shortcut_get_type :: IO B.Types.GType

instance B.Types.TypedObject Shortcut where
    glibType = c_gtk_shortcut_get_type

instance B.Types.GObject Shortcut

-- | Type class for types which can be safely cast to `Shortcut`, for instance with `toShortcut`.
class (SP.GObject o, O.IsDescendantOf Shortcut o) => IsShortcut o
instance (SP.GObject o, O.IsDescendantOf Shortcut o) => IsShortcut o

instance O.HasParentTypes Shortcut
type instance O.ParentTypes Shortcut = '[GObject.Object.Object]

-- | Cast to `Shortcut`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toShortcut :: (MIO.MonadIO m, IsShortcut o) => o -> m Shortcut
toShortcut = MIO.liftIO . B.ManagedPtr.unsafeCastTo Shortcut

-- | Convert 'Shortcut' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Shortcut) where
    gvalueGType_ = c_gtk_shortcut_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Shortcut)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Shortcut)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Shortcut ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveShortcutMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveShortcutMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveShortcutMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveShortcutMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveShortcutMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveShortcutMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveShortcutMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveShortcutMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveShortcutMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveShortcutMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveShortcutMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveShortcutMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveShortcutMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveShortcutMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveShortcutMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveShortcutMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveShortcutMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveShortcutMethod "getAction" o = ShortcutGetActionMethodInfo
    ResolveShortcutMethod "getArguments" o = ShortcutGetArgumentsMethodInfo
    ResolveShortcutMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveShortcutMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveShortcutMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveShortcutMethod "getTrigger" o = ShortcutGetTriggerMethodInfo
    ResolveShortcutMethod "setAction" o = ShortcutSetActionMethodInfo
    ResolveShortcutMethod "setArguments" o = ShortcutSetArgumentsMethodInfo
    ResolveShortcutMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveShortcutMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveShortcutMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveShortcutMethod "setTrigger" o = ShortcutSetTriggerMethodInfo
    ResolveShortcutMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveShortcutMethod t Shortcut, O.OverloadedMethod info Shortcut p) => OL.IsLabel t (Shortcut -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveShortcutMethod t Shortcut, O.OverloadedMethod info Shortcut p, R.HasField t Shortcut p) => R.HasField t Shortcut p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveShortcutMethod t Shortcut, O.OverloadedMethodInfo info Shortcut) => OL.IsLabel t (O.MethodProxy info Shortcut) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "action"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ShortcutAction"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@action@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcut #action
-- @
getShortcutAction :: (MonadIO m, IsShortcut o) => o -> m (Maybe Gtk.ShortcutAction.ShortcutAction)
getShortcutAction obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "action" Gtk.ShortcutAction.ShortcutAction

-- | Set the value of the “@action@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcut [ #action 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutAction :: (MonadIO m, IsShortcut o, Gtk.ShortcutAction.IsShortcutAction a) => o -> a -> m ()
setShortcutAction obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "action" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@action@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutAction :: (IsShortcut o, MIO.MonadIO m, Gtk.ShortcutAction.IsShortcutAction a) => a -> m (GValueConstruct o)
constructShortcutAction val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "action" (P.Just val)

-- | Set the value of the “@action@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #action
-- @
clearShortcutAction :: (MonadIO m, IsShortcut o) => o -> m ()
clearShortcutAction obj = liftIO $ B.Properties.setObjectPropertyObject obj "action" (Nothing :: Maybe Gtk.ShortcutAction.ShortcutAction)

#if defined(ENABLE_OVERLOADING)
data ShortcutActionPropertyInfo
instance AttrInfo ShortcutActionPropertyInfo where
    type AttrAllowedOps ShortcutActionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutActionPropertyInfo = IsShortcut
    type AttrSetTypeConstraint ShortcutActionPropertyInfo = Gtk.ShortcutAction.IsShortcutAction
    type AttrTransferTypeConstraint ShortcutActionPropertyInfo = Gtk.ShortcutAction.IsShortcutAction
    type AttrTransferType ShortcutActionPropertyInfo = Gtk.ShortcutAction.ShortcutAction
    type AttrGetType ShortcutActionPropertyInfo = (Maybe Gtk.ShortcutAction.ShortcutAction)
    type AttrLabel ShortcutActionPropertyInfo = "action"
    type AttrOrigin ShortcutActionPropertyInfo = Shortcut
    attrGet = getShortcutAction
    attrSet = setShortcutAction
    attrTransfer _ v = do
        unsafeCastTo Gtk.ShortcutAction.ShortcutAction v
    attrConstruct = constructShortcutAction
    attrClear = clearShortcutAction
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Shortcut.action"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Shortcut.html#g:attr:action"
        })
#endif

-- VVV Prop "arguments"
   -- Type: TVariant
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@arguments@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcut #arguments
-- @
getShortcutArguments :: (MonadIO m, IsShortcut o) => o -> m (Maybe GVariant)
getShortcutArguments obj = MIO.liftIO $ B.Properties.getObjectPropertyVariant obj "arguments"

-- | Set the value of the “@arguments@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcut [ #arguments 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutArguments :: (MonadIO m, IsShortcut o) => o -> GVariant -> m ()
setShortcutArguments obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyVariant obj "arguments" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@arguments@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutArguments :: (IsShortcut o, MIO.MonadIO m) => GVariant -> m (GValueConstruct o)
constructShortcutArguments val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyVariant "arguments" (P.Just val)

-- | Set the value of the “@arguments@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #arguments
-- @
clearShortcutArguments :: (MonadIO m, IsShortcut o) => o -> m ()
clearShortcutArguments obj = liftIO $ B.Properties.setObjectPropertyVariant obj "arguments" (Nothing :: Maybe GVariant)

#if defined(ENABLE_OVERLOADING)
data ShortcutArgumentsPropertyInfo
instance AttrInfo ShortcutArgumentsPropertyInfo where
    type AttrAllowedOps ShortcutArgumentsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutArgumentsPropertyInfo = IsShortcut
    type AttrSetTypeConstraint ShortcutArgumentsPropertyInfo = (~) GVariant
    type AttrTransferTypeConstraint ShortcutArgumentsPropertyInfo = (~) GVariant
    type AttrTransferType ShortcutArgumentsPropertyInfo = GVariant
    type AttrGetType ShortcutArgumentsPropertyInfo = (Maybe GVariant)
    type AttrLabel ShortcutArgumentsPropertyInfo = "arguments"
    type AttrOrigin ShortcutArgumentsPropertyInfo = Shortcut
    attrGet = getShortcutArguments
    attrSet = setShortcutArguments
    attrTransfer _ v = do
        return v
    attrConstruct = constructShortcutArguments
    attrClear = clearShortcutArguments
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Shortcut.arguments"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Shortcut.html#g:attr:arguments"
        })
#endif

-- VVV Prop "trigger"
   -- Type: TInterface (Name {namespace = "Gtk", name = "ShortcutTrigger"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@trigger@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' shortcut #trigger
-- @
getShortcutTrigger :: (MonadIO m, IsShortcut o) => o -> m (Maybe Gtk.ShortcutTrigger.ShortcutTrigger)
getShortcutTrigger obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "trigger" Gtk.ShortcutTrigger.ShortcutTrigger

-- | Set the value of the “@trigger@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' shortcut [ #trigger 'Data.GI.Base.Attributes.:=' value ]
-- @
setShortcutTrigger :: (MonadIO m, IsShortcut o, Gtk.ShortcutTrigger.IsShortcutTrigger a) => o -> a -> m ()
setShortcutTrigger obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "trigger" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@trigger@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructShortcutTrigger :: (IsShortcut o, MIO.MonadIO m, Gtk.ShortcutTrigger.IsShortcutTrigger a) => a -> m (GValueConstruct o)
constructShortcutTrigger val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "trigger" (P.Just val)

-- | Set the value of the “@trigger@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #trigger
-- @
clearShortcutTrigger :: (MonadIO m, IsShortcut o) => o -> m ()
clearShortcutTrigger obj = liftIO $ B.Properties.setObjectPropertyObject obj "trigger" (Nothing :: Maybe Gtk.ShortcutTrigger.ShortcutTrigger)

#if defined(ENABLE_OVERLOADING)
data ShortcutTriggerPropertyInfo
instance AttrInfo ShortcutTriggerPropertyInfo where
    type AttrAllowedOps ShortcutTriggerPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ShortcutTriggerPropertyInfo = IsShortcut
    type AttrSetTypeConstraint ShortcutTriggerPropertyInfo = Gtk.ShortcutTrigger.IsShortcutTrigger
    type AttrTransferTypeConstraint ShortcutTriggerPropertyInfo = Gtk.ShortcutTrigger.IsShortcutTrigger
    type AttrTransferType ShortcutTriggerPropertyInfo = Gtk.ShortcutTrigger.ShortcutTrigger
    type AttrGetType ShortcutTriggerPropertyInfo = (Maybe Gtk.ShortcutTrigger.ShortcutTrigger)
    type AttrLabel ShortcutTriggerPropertyInfo = "trigger"
    type AttrOrigin ShortcutTriggerPropertyInfo = Shortcut
    attrGet = getShortcutTrigger
    attrSet = setShortcutTrigger
    attrTransfer _ v = do
        unsafeCastTo Gtk.ShortcutTrigger.ShortcutTrigger v
    attrConstruct = constructShortcutTrigger
    attrClear = clearShortcutTrigger
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Shortcut.trigger"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Shortcut.html#g:attr:trigger"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Shortcut
type instance O.AttributeList Shortcut = ShortcutAttributeList
type ShortcutAttributeList = ('[ '("action", ShortcutActionPropertyInfo), '("arguments", ShortcutArgumentsPropertyInfo), '("trigger", ShortcutTriggerPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
shortcutAction :: AttrLabelProxy "action"
shortcutAction = AttrLabelProxy

shortcutArguments :: AttrLabelProxy "arguments"
shortcutArguments = AttrLabelProxy

shortcutTrigger :: AttrLabelProxy "trigger"
shortcutTrigger = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Shortcut = ShortcutSignalList
type ShortcutSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Shortcut::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "trigger"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ShortcutTrigger" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The trigger that will trigger the shortcut"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "action"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ShortcutAction" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The action that will be activated upon\n   triggering"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Shortcut" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_shortcut_new" gtk_shortcut_new :: 
    Ptr Gtk.ShortcutTrigger.ShortcutTrigger -> -- trigger : TInterface (Name {namespace = "Gtk", name = "ShortcutTrigger"})
    Ptr Gtk.ShortcutAction.ShortcutAction -> -- action : TInterface (Name {namespace = "Gtk", name = "ShortcutAction"})
    IO (Ptr Shortcut)

-- | Creates a new @GtkShortcut@ that is triggered by
-- /@trigger@/ and then activates /@action@/.
shortcutNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.ShortcutTrigger.IsShortcutTrigger a, Gtk.ShortcutAction.IsShortcutAction b) =>
    Maybe (a)
    -- ^ /@trigger@/: The trigger that will trigger the shortcut
    -> Maybe (b)
    -- ^ /@action@/: The action that will be activated upon
    --    triggering
    -> m Shortcut
    -- ^ __Returns:__ a new @GtkShortcut@
shortcutNew trigger action = liftIO $ do
    maybeTrigger <- case trigger of
        Nothing -> return FP.nullPtr
        Just jTrigger -> do
            jTrigger' <- B.ManagedPtr.disownObject jTrigger
            return jTrigger'
    maybeAction <- case action of
        Nothing -> return FP.nullPtr
        Just jAction -> do
            jAction' <- B.ManagedPtr.disownObject jAction
            return jAction'
    result <- gtk_shortcut_new maybeTrigger maybeAction
    checkUnexpectedReturnNULL "shortcutNew" result
    result' <- (wrapObject Shortcut) result
    whenJust trigger touchManagedPtr
    whenJust action touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Shortcut::get_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Shortcut" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkShortcut`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ShortcutAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_shortcut_get_action" gtk_shortcut_get_action :: 
    Ptr Shortcut ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Shortcut"})
    IO (Ptr Gtk.ShortcutAction.ShortcutAction)

-- | Gets the action that is activated by this shortcut.
shortcutGetAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsShortcut a) =>
    a
    -- ^ /@self@/: a @GtkShortcut@
    -> m (Maybe Gtk.ShortcutAction.ShortcutAction)
    -- ^ __Returns:__ the action
shortcutGetAction self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_shortcut_get_action self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ShortcutAction.ShortcutAction) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ShortcutGetActionMethodInfo
instance (signature ~ (m (Maybe Gtk.ShortcutAction.ShortcutAction)), MonadIO m, IsShortcut a) => O.OverloadedMethod ShortcutGetActionMethodInfo a signature where
    overloadedMethod = shortcutGetAction

instance O.OverloadedMethodInfo ShortcutGetActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Shortcut.shortcutGetAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Shortcut.html#v:shortcutGetAction"
        })


#endif

-- method Shortcut::get_arguments
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Shortcut" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkShortcut`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TVariant
-- throws : False
-- Skip return : False

foreign import ccall "gtk_shortcut_get_arguments" gtk_shortcut_get_arguments :: 
    Ptr Shortcut ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Shortcut"})
    IO (Ptr GVariant)

-- | Gets the arguments that are passed when activating the shortcut.
shortcutGetArguments ::
    (B.CallStack.HasCallStack, MonadIO m, IsShortcut a) =>
    a
    -- ^ /@self@/: a @GtkShortcut@
    -> m (Maybe GVariant)
    -- ^ __Returns:__ the arguments
shortcutGetArguments self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_shortcut_get_arguments self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- B.GVariant.newGVariantFromPtr result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ShortcutGetArgumentsMethodInfo
instance (signature ~ (m (Maybe GVariant)), MonadIO m, IsShortcut a) => O.OverloadedMethod ShortcutGetArgumentsMethodInfo a signature where
    overloadedMethod = shortcutGetArguments

instance O.OverloadedMethodInfo ShortcutGetArgumentsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Shortcut.shortcutGetArguments",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Shortcut.html#v:shortcutGetArguments"
        })


#endif

-- method Shortcut::get_trigger
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Shortcut" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkShortcut`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ShortcutTrigger" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_shortcut_get_trigger" gtk_shortcut_get_trigger :: 
    Ptr Shortcut ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Shortcut"})
    IO (Ptr Gtk.ShortcutTrigger.ShortcutTrigger)

-- | Gets the trigger used to trigger /@self@/.
shortcutGetTrigger ::
    (B.CallStack.HasCallStack, MonadIO m, IsShortcut a) =>
    a
    -- ^ /@self@/: a @GtkShortcut@
    -> m (Maybe Gtk.ShortcutTrigger.ShortcutTrigger)
    -- ^ __Returns:__ the trigger used
shortcutGetTrigger self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_shortcut_get_trigger self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.ShortcutTrigger.ShortcutTrigger) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ShortcutGetTriggerMethodInfo
instance (signature ~ (m (Maybe Gtk.ShortcutTrigger.ShortcutTrigger)), MonadIO m, IsShortcut a) => O.OverloadedMethod ShortcutGetTriggerMethodInfo a signature where
    overloadedMethod = shortcutGetTrigger

instance O.OverloadedMethodInfo ShortcutGetTriggerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Shortcut.shortcutGetTrigger",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Shortcut.html#v:shortcutGetTrigger"
        })


#endif

-- method Shortcut::set_action
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Shortcut" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkShortcut`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ShortcutAction" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The new action.\n  If the @action is %NULL, the nothing action will be used."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_shortcut_set_action" gtk_shortcut_set_action :: 
    Ptr Shortcut ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Shortcut"})
    Ptr Gtk.ShortcutAction.ShortcutAction -> -- action : TInterface (Name {namespace = "Gtk", name = "ShortcutAction"})
    IO ()

-- | Sets the new action for /@self@/ to be /@action@/.
shortcutSetAction ::
    (B.CallStack.HasCallStack, MonadIO m, IsShortcut a, Gtk.ShortcutAction.IsShortcutAction b) =>
    a
    -- ^ /@self@/: a @GtkShortcut@
    -> Maybe (b)
    -- ^ /@action@/: The new action.
    --   If the /@action@/ is 'P.Nothing', the nothing action will be used.
    -> m ()
shortcutSetAction self action = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeAction <- case action of
        Nothing -> return FP.nullPtr
        Just jAction -> do
            jAction' <- B.ManagedPtr.disownObject jAction
            return jAction'
    gtk_shortcut_set_action self' maybeAction
    touchManagedPtr self
    whenJust action touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ShortcutSetActionMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsShortcut a, Gtk.ShortcutAction.IsShortcutAction b) => O.OverloadedMethod ShortcutSetActionMethodInfo a signature where
    overloadedMethod = shortcutSetAction

instance O.OverloadedMethodInfo ShortcutSetActionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Shortcut.shortcutSetAction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Shortcut.html#v:shortcutSetAction"
        })


#endif

-- method Shortcut::set_arguments
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Shortcut" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkShortcut`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "args"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "arguments to pass when activating @self"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_shortcut_set_arguments" gtk_shortcut_set_arguments :: 
    Ptr Shortcut ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Shortcut"})
    Ptr GVariant ->                         -- args : TVariant
    IO ()

-- | Sets the arguments to pass when activating the shortcut.
shortcutSetArguments ::
    (B.CallStack.HasCallStack, MonadIO m, IsShortcut a) =>
    a
    -- ^ /@self@/: a @GtkShortcut@
    -> Maybe (GVariant)
    -- ^ /@args@/: arguments to pass when activating /@self@/
    -> m ()
shortcutSetArguments self args = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeArgs <- case args of
        Nothing -> return FP.nullPtr
        Just jArgs -> do
            jArgs' <- unsafeManagedPtrGetPtr jArgs
            return jArgs'
    gtk_shortcut_set_arguments self' maybeArgs
    touchManagedPtr self
    whenJust args touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ShortcutSetArgumentsMethodInfo
instance (signature ~ (Maybe (GVariant) -> m ()), MonadIO m, IsShortcut a) => O.OverloadedMethod ShortcutSetArgumentsMethodInfo a signature where
    overloadedMethod = shortcutSetArguments

instance O.OverloadedMethodInfo ShortcutSetArgumentsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Shortcut.shortcutSetArguments",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Shortcut.html#v:shortcutSetArguments"
        })


#endif

-- method Shortcut::set_trigger
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Shortcut" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkShortcut`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "trigger"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ShortcutTrigger" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The new trigger.\n  If the @trigger is %NULL, the never trigger will be used."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_shortcut_set_trigger" gtk_shortcut_set_trigger :: 
    Ptr Shortcut ->                         -- self : TInterface (Name {namespace = "Gtk", name = "Shortcut"})
    Ptr Gtk.ShortcutTrigger.ShortcutTrigger -> -- trigger : TInterface (Name {namespace = "Gtk", name = "ShortcutTrigger"})
    IO ()

-- | Sets the new trigger for /@self@/ to be /@trigger@/.
shortcutSetTrigger ::
    (B.CallStack.HasCallStack, MonadIO m, IsShortcut a, Gtk.ShortcutTrigger.IsShortcutTrigger b) =>
    a
    -- ^ /@self@/: a @GtkShortcut@
    -> Maybe (b)
    -- ^ /@trigger@/: The new trigger.
    --   If the /@trigger@/ is 'P.Nothing', the never trigger will be used.
    -> m ()
shortcutSetTrigger self trigger = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeTrigger <- case trigger of
        Nothing -> return FP.nullPtr
        Just jTrigger -> do
            jTrigger' <- B.ManagedPtr.disownObject jTrigger
            return jTrigger'
    gtk_shortcut_set_trigger self' maybeTrigger
    touchManagedPtr self
    whenJust trigger touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ShortcutSetTriggerMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsShortcut a, Gtk.ShortcutTrigger.IsShortcutTrigger b) => O.OverloadedMethod ShortcutSetTriggerMethodInfo a signature where
    overloadedMethod = shortcutSetTrigger

instance O.OverloadedMethodInfo ShortcutSetTriggerMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Shortcut.shortcutSetTrigger",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Shortcut.html#v:shortcutSetTrigger"
        })


#endif


