{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Provides a button which pops up a scale widget.
-- 
-- This kind of widget is commonly used for volume controls in multimedia
-- applications, and GTK provides a t'GI.Gtk.Objects.VolumeButton.VolumeButton' subclass that
-- is tailored for this use case.
-- 
-- = Shortcuts and Gestures
-- 
-- The following signals have default keybindings:
-- 
-- * [ScaleButton::popup]("GI.Gtk.Objects.ScaleButton#g:signal:popup")
-- 
-- 
-- = CSS nodes
-- 
-- >scalebutton.scale
-- >╰── button.toggle
-- >    ╰── <icon>
-- 
-- 
-- @GtkScaleButton@ has a single CSS node with name scalebutton and @.scale@
-- style class, and contains a @button@ node with a @.toggle@ style class.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ScaleButton
    ( 

-- * Exported types
    ScaleButton(..)                         ,
    IsScaleButton                           ,
    toScaleButton                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getActive]("GI.Gtk.Objects.ScaleButton#g:method:getActive"), [getAdjustment]("GI.Gtk.Objects.ScaleButton#g:method:getAdjustment"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasFrame]("GI.Gtk.Objects.ScaleButton#g:method:getHasFrame"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMinusButton]("GI.Gtk.Objects.ScaleButton#g:method:getMinusButton"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPlusButton]("GI.Gtk.Objects.ScaleButton#g:method:getPlusButton"), [getPopup]("GI.Gtk.Objects.ScaleButton#g:method:getPopup"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getValue]("GI.Gtk.Objects.ScaleButton#g:method:getValue"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAdjustment]("GI.Gtk.Objects.ScaleButton#g:method:setAdjustment"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasFrame]("GI.Gtk.Objects.ScaleButton#g:method:setHasFrame"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setIcons]("GI.Gtk.Objects.ScaleButton#g:method:setIcons"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setValue]("GI.Gtk.Objects.ScaleButton#g:method:setValue"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveScaleButtonMethod                ,
#endif

-- ** getActive #method:getActive#

#if defined(ENABLE_OVERLOADING)
    ScaleButtonGetActiveMethodInfo          ,
#endif
    scaleButtonGetActive                    ,


-- ** getAdjustment #method:getAdjustment#

#if defined(ENABLE_OVERLOADING)
    ScaleButtonGetAdjustmentMethodInfo      ,
#endif
    scaleButtonGetAdjustment                ,


-- ** getHasFrame #method:getHasFrame#

#if defined(ENABLE_OVERLOADING)
    ScaleButtonGetHasFrameMethodInfo        ,
#endif
    scaleButtonGetHasFrame                  ,


-- ** getMinusButton #method:getMinusButton#

#if defined(ENABLE_OVERLOADING)
    ScaleButtonGetMinusButtonMethodInfo     ,
#endif
    scaleButtonGetMinusButton               ,


-- ** getPlusButton #method:getPlusButton#

#if defined(ENABLE_OVERLOADING)
    ScaleButtonGetPlusButtonMethodInfo      ,
#endif
    scaleButtonGetPlusButton                ,


-- ** getPopup #method:getPopup#

#if defined(ENABLE_OVERLOADING)
    ScaleButtonGetPopupMethodInfo           ,
#endif
    scaleButtonGetPopup                     ,


-- ** getValue #method:getValue#

#if defined(ENABLE_OVERLOADING)
    ScaleButtonGetValueMethodInfo           ,
#endif
    scaleButtonGetValue                     ,


-- ** new #method:new#

    scaleButtonNew                          ,


-- ** setAdjustment #method:setAdjustment#

#if defined(ENABLE_OVERLOADING)
    ScaleButtonSetAdjustmentMethodInfo      ,
#endif
    scaleButtonSetAdjustment                ,


-- ** setHasFrame #method:setHasFrame#

#if defined(ENABLE_OVERLOADING)
    ScaleButtonSetHasFrameMethodInfo        ,
#endif
    scaleButtonSetHasFrame                  ,


-- ** setIcons #method:setIcons#

#if defined(ENABLE_OVERLOADING)
    ScaleButtonSetIconsMethodInfo           ,
#endif
    scaleButtonSetIcons                     ,


-- ** setValue #method:setValue#

#if defined(ENABLE_OVERLOADING)
    ScaleButtonSetValueMethodInfo           ,
#endif
    scaleButtonSetValue                     ,




 -- * Properties


-- ** active #attr:active#
-- | If the scale button should be pressed in.
-- 
-- /Since: 4.10/

#if defined(ENABLE_OVERLOADING)
    ScaleButtonActivePropertyInfo           ,
#endif
    getScaleButtonActive                    ,
#if defined(ENABLE_OVERLOADING)
    scaleButtonActive                       ,
#endif


-- ** adjustment #attr:adjustment#
-- | The @GtkAdjustment@ that is used as the model.

#if defined(ENABLE_OVERLOADING)
    ScaleButtonAdjustmentPropertyInfo       ,
#endif
    constructScaleButtonAdjustment          ,
    getScaleButtonAdjustment                ,
#if defined(ENABLE_OVERLOADING)
    scaleButtonAdjustment                   ,
#endif
    setScaleButtonAdjustment                ,


-- ** hasFrame #attr:hasFrame#
-- | If the scale button has a frame.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    ScaleButtonHasFramePropertyInfo         ,
#endif
    constructScaleButtonHasFrame            ,
    getScaleButtonHasFrame                  ,
#if defined(ENABLE_OVERLOADING)
    scaleButtonHasFrame                     ,
#endif
    setScaleButtonHasFrame                  ,


-- ** icons #attr:icons#
-- | The names of the icons to be used by the scale button.
-- 
-- The first item in the array will be used in the button
-- when the current value is the lowest value, the second
-- item for the highest value. All the subsequent icons will
-- be used for all the other values, spread evenly over the
-- range of values.
-- 
-- If there\'s only one icon name in the /@icons@/ array, it will
-- be used for all the values. If only two icon names are in
-- the /@icons@/ array, the first one will be used for the bottom
-- 50% of the scale, and the second one for the top 50%.
-- 
-- It is recommended to use at least 3 icons so that the
-- @GtkScaleButton@ reflects the current value of the scale
-- better for the users.

#if defined(ENABLE_OVERLOADING)
    ScaleButtonIconsPropertyInfo            ,
#endif
    constructScaleButtonIcons               ,
    getScaleButtonIcons                     ,
#if defined(ENABLE_OVERLOADING)
    scaleButtonIcons                        ,
#endif
    setScaleButtonIcons                     ,


-- ** value #attr:value#
-- | The value of the scale.

#if defined(ENABLE_OVERLOADING)
    ScaleButtonValuePropertyInfo            ,
#endif
    constructScaleButtonValue               ,
    getScaleButtonValue                     ,
#if defined(ENABLE_OVERLOADING)
    scaleButtonValue                        ,
#endif
    setScaleButtonValue                     ,




 -- * Signals


-- ** popdown #signal:popdown#

    ScaleButtonPopdownCallback              ,
#if defined(ENABLE_OVERLOADING)
    ScaleButtonPopdownSignalInfo            ,
#endif
    afterScaleButtonPopdown                 ,
    onScaleButtonPopdown                    ,


-- ** popup #signal:popup#

    ScaleButtonPopupCallback                ,
#if defined(ENABLE_OVERLOADING)
    ScaleButtonPopupSignalInfo              ,
#endif
    afterScaleButtonPopup                   ,
    onScaleButtonPopup                      ,


-- ** valueChanged #signal:valueChanged#

    ScaleButtonValueChangedCallback         ,
#if defined(ENABLE_OVERLOADING)
    ScaleButtonValueChangedSignalInfo       ,
#endif
    afterScaleButtonValueChanged            ,
    onScaleButtonValueChanged               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Actionable as Gtk.Actionable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.Button as Gtk.Button
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.Button as Gtk.Button
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype ScaleButton = ScaleButton (SP.ManagedPtr ScaleButton)
    deriving (Eq)

instance SP.ManagedPtrNewtype ScaleButton where
    toManagedPtr (ScaleButton p) = p

foreign import ccall "gtk_scale_button_get_type"
    c_gtk_scale_button_get_type :: IO B.Types.GType

instance B.Types.TypedObject ScaleButton where
    glibType = c_gtk_scale_button_get_type

instance B.Types.GObject ScaleButton

-- | Type class for types which can be safely cast to `ScaleButton`, for instance with `toScaleButton`.
class (SP.GObject o, O.IsDescendantOf ScaleButton o) => IsScaleButton o
instance (SP.GObject o, O.IsDescendantOf ScaleButton o) => IsScaleButton o

instance O.HasParentTypes ScaleButton
type instance O.ParentTypes ScaleButton = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.AccessibleRange.AccessibleRange, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Orientable.Orientable]

-- | Cast to `ScaleButton`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toScaleButton :: (MIO.MonadIO m, IsScaleButton o) => o -> m ScaleButton
toScaleButton = MIO.liftIO . B.ManagedPtr.unsafeCastTo ScaleButton

-- | Convert 'ScaleButton' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ScaleButton) where
    gvalueGType_ = c_gtk_scale_button_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ScaleButton)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ScaleButton)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ScaleButton ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveScaleButtonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveScaleButtonMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveScaleButtonMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveScaleButtonMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveScaleButtonMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveScaleButtonMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveScaleButtonMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveScaleButtonMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveScaleButtonMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveScaleButtonMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveScaleButtonMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveScaleButtonMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveScaleButtonMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveScaleButtonMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveScaleButtonMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveScaleButtonMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveScaleButtonMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveScaleButtonMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveScaleButtonMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveScaleButtonMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveScaleButtonMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveScaleButtonMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveScaleButtonMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveScaleButtonMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveScaleButtonMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveScaleButtonMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveScaleButtonMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveScaleButtonMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveScaleButtonMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveScaleButtonMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveScaleButtonMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveScaleButtonMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveScaleButtonMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveScaleButtonMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveScaleButtonMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveScaleButtonMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveScaleButtonMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveScaleButtonMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveScaleButtonMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveScaleButtonMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveScaleButtonMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveScaleButtonMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveScaleButtonMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveScaleButtonMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveScaleButtonMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveScaleButtonMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveScaleButtonMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveScaleButtonMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveScaleButtonMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveScaleButtonMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveScaleButtonMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveScaleButtonMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveScaleButtonMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveScaleButtonMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveScaleButtonMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveScaleButtonMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveScaleButtonMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveScaleButtonMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveScaleButtonMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveScaleButtonMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveScaleButtonMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveScaleButtonMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveScaleButtonMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveScaleButtonMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveScaleButtonMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveScaleButtonMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveScaleButtonMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveScaleButtonMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveScaleButtonMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveScaleButtonMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveScaleButtonMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveScaleButtonMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveScaleButtonMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveScaleButtonMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveScaleButtonMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveScaleButtonMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveScaleButtonMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveScaleButtonMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveScaleButtonMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveScaleButtonMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveScaleButtonMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveScaleButtonMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveScaleButtonMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveScaleButtonMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveScaleButtonMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveScaleButtonMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveScaleButtonMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveScaleButtonMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveScaleButtonMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveScaleButtonMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveScaleButtonMethod "getActive" o = ScaleButtonGetActiveMethodInfo
    ResolveScaleButtonMethod "getAdjustment" o = ScaleButtonGetAdjustmentMethodInfo
    ResolveScaleButtonMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveScaleButtonMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveScaleButtonMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveScaleButtonMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveScaleButtonMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveScaleButtonMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveScaleButtonMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveScaleButtonMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveScaleButtonMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveScaleButtonMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveScaleButtonMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveScaleButtonMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveScaleButtonMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveScaleButtonMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveScaleButtonMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveScaleButtonMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveScaleButtonMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveScaleButtonMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveScaleButtonMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveScaleButtonMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveScaleButtonMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveScaleButtonMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveScaleButtonMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveScaleButtonMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveScaleButtonMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveScaleButtonMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveScaleButtonMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveScaleButtonMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveScaleButtonMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveScaleButtonMethod "getHasFrame" o = ScaleButtonGetHasFrameMethodInfo
    ResolveScaleButtonMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveScaleButtonMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveScaleButtonMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveScaleButtonMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveScaleButtonMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveScaleButtonMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveScaleButtonMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveScaleButtonMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveScaleButtonMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveScaleButtonMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveScaleButtonMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveScaleButtonMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveScaleButtonMethod "getMinusButton" o = ScaleButtonGetMinusButtonMethodInfo
    ResolveScaleButtonMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveScaleButtonMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveScaleButtonMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveScaleButtonMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveScaleButtonMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveScaleButtonMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveScaleButtonMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveScaleButtonMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveScaleButtonMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveScaleButtonMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveScaleButtonMethod "getPlusButton" o = ScaleButtonGetPlusButtonMethodInfo
    ResolveScaleButtonMethod "getPopup" o = ScaleButtonGetPopupMethodInfo
    ResolveScaleButtonMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveScaleButtonMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveScaleButtonMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveScaleButtonMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveScaleButtonMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveScaleButtonMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveScaleButtonMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveScaleButtonMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveScaleButtonMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveScaleButtonMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveScaleButtonMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveScaleButtonMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveScaleButtonMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveScaleButtonMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveScaleButtonMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveScaleButtonMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveScaleButtonMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveScaleButtonMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveScaleButtonMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveScaleButtonMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveScaleButtonMethod "getValue" o = ScaleButtonGetValueMethodInfo
    ResolveScaleButtonMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveScaleButtonMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveScaleButtonMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveScaleButtonMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveScaleButtonMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveScaleButtonMethod "setAdjustment" o = ScaleButtonSetAdjustmentMethodInfo
    ResolveScaleButtonMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveScaleButtonMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveScaleButtonMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveScaleButtonMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveScaleButtonMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveScaleButtonMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveScaleButtonMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveScaleButtonMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveScaleButtonMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveScaleButtonMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveScaleButtonMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveScaleButtonMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveScaleButtonMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveScaleButtonMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveScaleButtonMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveScaleButtonMethod "setHasFrame" o = ScaleButtonSetHasFrameMethodInfo
    ResolveScaleButtonMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveScaleButtonMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveScaleButtonMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveScaleButtonMethod "setIcons" o = ScaleButtonSetIconsMethodInfo
    ResolveScaleButtonMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveScaleButtonMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveScaleButtonMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveScaleButtonMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveScaleButtonMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveScaleButtonMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveScaleButtonMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveScaleButtonMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveScaleButtonMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveScaleButtonMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveScaleButtonMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveScaleButtonMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveScaleButtonMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveScaleButtonMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveScaleButtonMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveScaleButtonMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveScaleButtonMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveScaleButtonMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveScaleButtonMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveScaleButtonMethod "setValue" o = ScaleButtonSetValueMethodInfo
    ResolveScaleButtonMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveScaleButtonMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveScaleButtonMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveScaleButtonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveScaleButtonMethod t ScaleButton, O.OverloadedMethod info ScaleButton p) => OL.IsLabel t (ScaleButton -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveScaleButtonMethod t ScaleButton, O.OverloadedMethod info ScaleButton p, R.HasField t ScaleButton p) => R.HasField t ScaleButton p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveScaleButtonMethod t ScaleButton, O.OverloadedMethodInfo info ScaleButton) => OL.IsLabel t (O.MethodProxy info ScaleButton) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal ScaleButton::popdown
-- | Emitted to dismiss the popup.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is \<kbd>Escape\<\/kbd>.
type ScaleButtonPopdownCallback =
    IO ()

type C_ScaleButtonPopdownCallback =
    Ptr ScaleButton ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ScaleButtonPopdownCallback`.
foreign import ccall "wrapper"
    mk_ScaleButtonPopdownCallback :: C_ScaleButtonPopdownCallback -> IO (FunPtr C_ScaleButtonPopdownCallback)

wrap_ScaleButtonPopdownCallback :: 
    GObject a => (a -> ScaleButtonPopdownCallback) ->
    C_ScaleButtonPopdownCallback
wrap_ScaleButtonPopdownCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [popdown](#signal:popdown) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' scaleButton #popdown callback
-- @
-- 
-- 
onScaleButtonPopdown :: (IsScaleButton a, MonadIO m) => a -> ((?self :: a) => ScaleButtonPopdownCallback) -> m SignalHandlerId
onScaleButtonPopdown obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScaleButtonPopdownCallback wrapped
    wrapped'' <- mk_ScaleButtonPopdownCallback wrapped'
    connectSignalFunPtr obj "popdown" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [popdown](#signal:popdown) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' scaleButton #popdown callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterScaleButtonPopdown :: (IsScaleButton a, MonadIO m) => a -> ((?self :: a) => ScaleButtonPopdownCallback) -> m SignalHandlerId
afterScaleButtonPopdown obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScaleButtonPopdownCallback wrapped
    wrapped'' <- mk_ScaleButtonPopdownCallback wrapped'
    connectSignalFunPtr obj "popdown" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ScaleButtonPopdownSignalInfo
instance SignalInfo ScaleButtonPopdownSignalInfo where
    type HaskellCallbackType ScaleButtonPopdownSignalInfo = ScaleButtonPopdownCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ScaleButtonPopdownCallback cb
        cb'' <- mk_ScaleButtonPopdownCallback cb'
        connectSignalFunPtr obj "popdown" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton::popdown"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#g:signal:popdown"})

#endif

-- signal ScaleButton::popup
-- | Emitted to popup the scale widget.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default bindings for this signal are \<kbd>Space\<\/kbd>,
-- \<kbd>Enter\<\/kbd> and \<kbd>Return\<\/kbd>.
type ScaleButtonPopupCallback =
    IO ()

type C_ScaleButtonPopupCallback =
    Ptr ScaleButton ->                      -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ScaleButtonPopupCallback`.
foreign import ccall "wrapper"
    mk_ScaleButtonPopupCallback :: C_ScaleButtonPopupCallback -> IO (FunPtr C_ScaleButtonPopupCallback)

wrap_ScaleButtonPopupCallback :: 
    GObject a => (a -> ScaleButtonPopupCallback) ->
    C_ScaleButtonPopupCallback
wrap_ScaleButtonPopupCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [popup](#signal:popup) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' scaleButton #popup callback
-- @
-- 
-- 
onScaleButtonPopup :: (IsScaleButton a, MonadIO m) => a -> ((?self :: a) => ScaleButtonPopupCallback) -> m SignalHandlerId
onScaleButtonPopup obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScaleButtonPopupCallback wrapped
    wrapped'' <- mk_ScaleButtonPopupCallback wrapped'
    connectSignalFunPtr obj "popup" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [popup](#signal:popup) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' scaleButton #popup callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterScaleButtonPopup :: (IsScaleButton a, MonadIO m) => a -> ((?self :: a) => ScaleButtonPopupCallback) -> m SignalHandlerId
afterScaleButtonPopup obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScaleButtonPopupCallback wrapped
    wrapped'' <- mk_ScaleButtonPopupCallback wrapped'
    connectSignalFunPtr obj "popup" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ScaleButtonPopupSignalInfo
instance SignalInfo ScaleButtonPopupSignalInfo where
    type HaskellCallbackType ScaleButtonPopupSignalInfo = ScaleButtonPopupCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ScaleButtonPopupCallback cb
        cb'' <- mk_ScaleButtonPopupCallback cb'
        connectSignalFunPtr obj "popup" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton::popup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#g:signal:popup"})

#endif

-- signal ScaleButton::value-changed
-- | Emitted when the value field has changed.
type ScaleButtonValueChangedCallback =
    Double
    -- ^ /@value@/: the new value
    -> IO ()

type C_ScaleButtonValueChangedCallback =
    Ptr ScaleButton ->                      -- object
    CDouble ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ScaleButtonValueChangedCallback`.
foreign import ccall "wrapper"
    mk_ScaleButtonValueChangedCallback :: C_ScaleButtonValueChangedCallback -> IO (FunPtr C_ScaleButtonValueChangedCallback)

wrap_ScaleButtonValueChangedCallback :: 
    GObject a => (a -> ScaleButtonValueChangedCallback) ->
    C_ScaleButtonValueChangedCallback
wrap_ScaleButtonValueChangedCallback gi'cb gi'selfPtr value _ = do
    let value' = realToFrac value
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  value'


-- | Connect a signal handler for the [valueChanged](#signal:valueChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' scaleButton #valueChanged callback
-- @
-- 
-- 
onScaleButtonValueChanged :: (IsScaleButton a, MonadIO m) => a -> ((?self :: a) => ScaleButtonValueChangedCallback) -> m SignalHandlerId
onScaleButtonValueChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScaleButtonValueChangedCallback wrapped
    wrapped'' <- mk_ScaleButtonValueChangedCallback wrapped'
    connectSignalFunPtr obj "value-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [valueChanged](#signal:valueChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' scaleButton #valueChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterScaleButtonValueChanged :: (IsScaleButton a, MonadIO m) => a -> ((?self :: a) => ScaleButtonValueChangedCallback) -> m SignalHandlerId
afterScaleButtonValueChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScaleButtonValueChangedCallback wrapped
    wrapped'' <- mk_ScaleButtonValueChangedCallback wrapped'
    connectSignalFunPtr obj "value-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ScaleButtonValueChangedSignalInfo
instance SignalInfo ScaleButtonValueChangedSignalInfo where
    type HaskellCallbackType ScaleButtonValueChangedSignalInfo = ScaleButtonValueChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ScaleButtonValueChangedCallback cb
        cb'' <- mk_ScaleButtonValueChangedCallback cb'
        connectSignalFunPtr obj "value-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton::value-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#g:signal:valueChanged"})

#endif

-- VVV Prop "active"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@active@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scaleButton #active
-- @
getScaleButtonActive :: (MonadIO m, IsScaleButton o) => o -> m Bool
getScaleButtonActive obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "active"

#if defined(ENABLE_OVERLOADING)
data ScaleButtonActivePropertyInfo
instance AttrInfo ScaleButtonActivePropertyInfo where
    type AttrAllowedOps ScaleButtonActivePropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint ScaleButtonActivePropertyInfo = IsScaleButton
    type AttrSetTypeConstraint ScaleButtonActivePropertyInfo = (~) ()
    type AttrTransferTypeConstraint ScaleButtonActivePropertyInfo = (~) ()
    type AttrTransferType ScaleButtonActivePropertyInfo = ()
    type AttrGetType ScaleButtonActivePropertyInfo = Bool
    type AttrLabel ScaleButtonActivePropertyInfo = "active"
    type AttrOrigin ScaleButtonActivePropertyInfo = ScaleButton
    attrGet = getScaleButtonActive
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.active"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#g:attr:active"
        })
#endif

-- VVV Prop "adjustment"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Adjustment"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@adjustment@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scaleButton #adjustment
-- @
getScaleButtonAdjustment :: (MonadIO m, IsScaleButton o) => o -> m Gtk.Adjustment.Adjustment
getScaleButtonAdjustment obj = MIO.liftIO $ checkUnexpectedNothing "getScaleButtonAdjustment" $ B.Properties.getObjectPropertyObject obj "adjustment" Gtk.Adjustment.Adjustment

-- | Set the value of the “@adjustment@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scaleButton [ #adjustment 'Data.GI.Base.Attributes.:=' value ]
-- @
setScaleButtonAdjustment :: (MonadIO m, IsScaleButton o, Gtk.Adjustment.IsAdjustment a) => o -> a -> m ()
setScaleButtonAdjustment obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "adjustment" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@adjustment@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScaleButtonAdjustment :: (IsScaleButton o, MIO.MonadIO m, Gtk.Adjustment.IsAdjustment a) => a -> m (GValueConstruct o)
constructScaleButtonAdjustment val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "adjustment" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ScaleButtonAdjustmentPropertyInfo
instance AttrInfo ScaleButtonAdjustmentPropertyInfo where
    type AttrAllowedOps ScaleButtonAdjustmentPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScaleButtonAdjustmentPropertyInfo = IsScaleButton
    type AttrSetTypeConstraint ScaleButtonAdjustmentPropertyInfo = Gtk.Adjustment.IsAdjustment
    type AttrTransferTypeConstraint ScaleButtonAdjustmentPropertyInfo = Gtk.Adjustment.IsAdjustment
    type AttrTransferType ScaleButtonAdjustmentPropertyInfo = Gtk.Adjustment.Adjustment
    type AttrGetType ScaleButtonAdjustmentPropertyInfo = Gtk.Adjustment.Adjustment
    type AttrLabel ScaleButtonAdjustmentPropertyInfo = "adjustment"
    type AttrOrigin ScaleButtonAdjustmentPropertyInfo = ScaleButton
    attrGet = getScaleButtonAdjustment
    attrSet = setScaleButtonAdjustment
    attrTransfer _ v = do
        unsafeCastTo Gtk.Adjustment.Adjustment v
    attrConstruct = constructScaleButtonAdjustment
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.adjustment"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#g:attr:adjustment"
        })
#endif

-- VVV Prop "has-frame"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@has-frame@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scaleButton #hasFrame
-- @
getScaleButtonHasFrame :: (MonadIO m, IsScaleButton o) => o -> m Bool
getScaleButtonHasFrame obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-frame"

-- | Set the value of the “@has-frame@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scaleButton [ #hasFrame 'Data.GI.Base.Attributes.:=' value ]
-- @
setScaleButtonHasFrame :: (MonadIO m, IsScaleButton o) => o -> Bool -> m ()
setScaleButtonHasFrame obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "has-frame" val

-- | Construct a `GValueConstruct` with valid value for the “@has-frame@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScaleButtonHasFrame :: (IsScaleButton o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructScaleButtonHasFrame val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-frame" val

#if defined(ENABLE_OVERLOADING)
data ScaleButtonHasFramePropertyInfo
instance AttrInfo ScaleButtonHasFramePropertyInfo where
    type AttrAllowedOps ScaleButtonHasFramePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScaleButtonHasFramePropertyInfo = IsScaleButton
    type AttrSetTypeConstraint ScaleButtonHasFramePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ScaleButtonHasFramePropertyInfo = (~) Bool
    type AttrTransferType ScaleButtonHasFramePropertyInfo = Bool
    type AttrGetType ScaleButtonHasFramePropertyInfo = Bool
    type AttrLabel ScaleButtonHasFramePropertyInfo = "has-frame"
    type AttrOrigin ScaleButtonHasFramePropertyInfo = ScaleButton
    attrGet = getScaleButtonHasFrame
    attrSet = setScaleButtonHasFrame
    attrTransfer _ v = do
        return v
    attrConstruct = constructScaleButtonHasFrame
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.hasFrame"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#g:attr:hasFrame"
        })
#endif

-- VVV Prop "icons"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just False)

-- | Get the value of the “@icons@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scaleButton #icons
-- @
getScaleButtonIcons :: (MonadIO m, IsScaleButton o) => o -> m (Maybe [T.Text])
getScaleButtonIcons obj = MIO.liftIO $ B.Properties.getObjectPropertyStringArray obj "icons"

-- | Set the value of the “@icons@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scaleButton [ #icons 'Data.GI.Base.Attributes.:=' value ]
-- @
setScaleButtonIcons :: (MonadIO m, IsScaleButton o) => o -> [T.Text] -> m ()
setScaleButtonIcons obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyStringArray obj "icons" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@icons@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScaleButtonIcons :: (IsScaleButton o, MIO.MonadIO m) => [T.Text] -> m (GValueConstruct o)
constructScaleButtonIcons val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyStringArray "icons" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ScaleButtonIconsPropertyInfo
instance AttrInfo ScaleButtonIconsPropertyInfo where
    type AttrAllowedOps ScaleButtonIconsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScaleButtonIconsPropertyInfo = IsScaleButton
    type AttrSetTypeConstraint ScaleButtonIconsPropertyInfo = (~) [T.Text]
    type AttrTransferTypeConstraint ScaleButtonIconsPropertyInfo = (~) [T.Text]
    type AttrTransferType ScaleButtonIconsPropertyInfo = [T.Text]
    type AttrGetType ScaleButtonIconsPropertyInfo = (Maybe [T.Text])
    type AttrLabel ScaleButtonIconsPropertyInfo = "icons"
    type AttrOrigin ScaleButtonIconsPropertyInfo = ScaleButton
    attrGet = getScaleButtonIcons
    attrSet = setScaleButtonIcons
    attrTransfer _ v = do
        return v
    attrConstruct = constructScaleButtonIcons
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.icons"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#g:attr:icons"
        })
#endif

-- VVV Prop "value"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scaleButton #value
-- @
getScaleButtonValue :: (MonadIO m, IsScaleButton o) => o -> m Double
getScaleButtonValue obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "value"

-- | Set the value of the “@value@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scaleButton [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setScaleButtonValue :: (MonadIO m, IsScaleButton o) => o -> Double -> m ()
setScaleButtonValue obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "value" val

-- | Construct a `GValueConstruct` with valid value for the “@value@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScaleButtonValue :: (IsScaleButton o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructScaleButtonValue val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "value" val

#if defined(ENABLE_OVERLOADING)
data ScaleButtonValuePropertyInfo
instance AttrInfo ScaleButtonValuePropertyInfo where
    type AttrAllowedOps ScaleButtonValuePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScaleButtonValuePropertyInfo = IsScaleButton
    type AttrSetTypeConstraint ScaleButtonValuePropertyInfo = (~) Double
    type AttrTransferTypeConstraint ScaleButtonValuePropertyInfo = (~) Double
    type AttrTransferType ScaleButtonValuePropertyInfo = Double
    type AttrGetType ScaleButtonValuePropertyInfo = Double
    type AttrLabel ScaleButtonValuePropertyInfo = "value"
    type AttrOrigin ScaleButtonValuePropertyInfo = ScaleButton
    attrGet = getScaleButtonValue
    attrSet = setScaleButtonValue
    attrTransfer _ v = do
        return v
    attrConstruct = constructScaleButtonValue
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#g:attr:value"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ScaleButton
type instance O.AttributeList ScaleButton = ScaleButtonAttributeList
type ScaleButtonAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("active", ScaleButtonActivePropertyInfo), '("adjustment", ScaleButtonAdjustmentPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasFrame", ScaleButtonHasFramePropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("icons", ScaleButtonIconsPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.Orientable.OrientableOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("value", ScaleButtonValuePropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
scaleButtonActive :: AttrLabelProxy "active"
scaleButtonActive = AttrLabelProxy

scaleButtonAdjustment :: AttrLabelProxy "adjustment"
scaleButtonAdjustment = AttrLabelProxy

scaleButtonHasFrame :: AttrLabelProxy "hasFrame"
scaleButtonHasFrame = AttrLabelProxy

scaleButtonIcons :: AttrLabelProxy "icons"
scaleButtonIcons = AttrLabelProxy

scaleButtonValue :: AttrLabelProxy "value"
scaleButtonValue = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ScaleButton = ScaleButtonSignalList
type ScaleButtonSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("popdown", ScaleButtonPopdownSignalInfo), '("popup", ScaleButtonPopupSignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo), '("valueChanged", ScaleButtonValueChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ScaleButton::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "min"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the minimum value of the scale (usually 0)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "max"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the maximum value of the scale (usually 100)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "step"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the stepping of value when a scroll-wheel event,\n  or up/down arrow event occurs (usually 2)"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icons"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a %NULL-terminated\n  array of icon names, or %NULL if you want to set the list\n  later with gtk_scale_button_set_icons()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ScaleButton" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_new" gtk_scale_button_new :: 
    CDouble ->                              -- min : TBasicType TDouble
    CDouble ->                              -- max : TBasicType TDouble
    CDouble ->                              -- step : TBasicType TDouble
    Ptr CString ->                          -- icons : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO (Ptr ScaleButton)

-- | Creates a @GtkScaleButton@.
-- 
-- The new scale button has a range between /@min@/ and /@max@/,
-- with a stepping of /@step@/.
scaleButtonNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Double
    -- ^ /@min@/: the minimum value of the scale (usually 0)
    -> Double
    -- ^ /@max@/: the maximum value of the scale (usually 100)
    -> Double
    -- ^ /@step@/: the stepping of value when a scroll-wheel event,
    --   or up\/down arrow event occurs (usually 2)
    -> Maybe ([T.Text])
    -- ^ /@icons@/: a 'P.Nothing'-terminated
    --   array of icon names, or 'P.Nothing' if you want to set the list
    --   later with 'GI.Gtk.Objects.ScaleButton.scaleButtonSetIcons'
    -> m ScaleButton
    -- ^ __Returns:__ a new @GtkScaleButton@
scaleButtonNew min max step icons = liftIO $ do
    let min' = realToFrac min
    let max' = realToFrac max
    let step' = realToFrac step
    maybeIcons <- case icons of
        Nothing -> return FP.nullPtr
        Just jIcons -> do
            jIcons' <- packZeroTerminatedUTF8CArray jIcons
            return jIcons'
    result <- gtk_scale_button_new min' max' step' maybeIcons
    checkUnexpectedReturnNULL "scaleButtonNew" result
    result' <- (newObject ScaleButton) result
    mapZeroTerminatedCArray freeMem maybeIcons
    freeMem maybeIcons
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ScaleButton::get_active
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScaleButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScaleButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_get_active" gtk_scale_button_get_active :: 
    Ptr ScaleButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "ScaleButton"})
    IO CInt

-- | Queries a @GtkScaleButton@ and returns its current state.
-- 
-- Returns 'P.True' if the scale button is pressed in and 'P.False'
-- if it is raised.
-- 
-- /Since: 4.10/
scaleButtonGetActive ::
    (B.CallStack.HasCallStack, MonadIO m, IsScaleButton a) =>
    a
    -- ^ /@button@/: a @GtkScaleButton@
    -> m Bool
    -- ^ __Returns:__ whether the button is pressed
scaleButtonGetActive button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_scale_button_get_active button'
    let result' = (/= 0) result
    touchManagedPtr button
    return result'

#if defined(ENABLE_OVERLOADING)
data ScaleButtonGetActiveMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsScaleButton a) => O.OverloadedMethod ScaleButtonGetActiveMethodInfo a signature where
    overloadedMethod = scaleButtonGetActive

instance O.OverloadedMethodInfo ScaleButtonGetActiveMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.scaleButtonGetActive",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#v:scaleButtonGetActive"
        })


#endif

-- method ScaleButton::get_adjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScaleButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScaleButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Adjustment" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_get_adjustment" gtk_scale_button_get_adjustment :: 
    Ptr ScaleButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "ScaleButton"})
    IO (Ptr Gtk.Adjustment.Adjustment)

-- | Gets the @GtkAdjustment@ associated with the @GtkScaleButton@’s scale.
-- 
-- See 'GI.Gtk.Objects.Range.rangeGetAdjustment' for details.
scaleButtonGetAdjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsScaleButton a) =>
    a
    -- ^ /@button@/: a @GtkScaleButton@
    -> m Gtk.Adjustment.Adjustment
    -- ^ __Returns:__ the adjustment associated with the scale
scaleButtonGetAdjustment button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_scale_button_get_adjustment button'
    checkUnexpectedReturnNULL "scaleButtonGetAdjustment" result
    result' <- (newObject Gtk.Adjustment.Adjustment) result
    touchManagedPtr button
    return result'

#if defined(ENABLE_OVERLOADING)
data ScaleButtonGetAdjustmentMethodInfo
instance (signature ~ (m Gtk.Adjustment.Adjustment), MonadIO m, IsScaleButton a) => O.OverloadedMethod ScaleButtonGetAdjustmentMethodInfo a signature where
    overloadedMethod = scaleButtonGetAdjustment

instance O.OverloadedMethodInfo ScaleButtonGetAdjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.scaleButtonGetAdjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#v:scaleButtonGetAdjustment"
        })


#endif

-- method ScaleButton::get_has_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScaleButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScaleButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_get_has_frame" gtk_scale_button_get_has_frame :: 
    Ptr ScaleButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "ScaleButton"})
    IO CInt

-- | Returns whether the button has a frame.
-- 
-- /Since: 4.14/
scaleButtonGetHasFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsScaleButton a) =>
    a
    -- ^ /@button@/: a @GtkScaleButton@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the button has a frame
scaleButtonGetHasFrame button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_scale_button_get_has_frame button'
    let result' = (/= 0) result
    touchManagedPtr button
    return result'

#if defined(ENABLE_OVERLOADING)
data ScaleButtonGetHasFrameMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsScaleButton a) => O.OverloadedMethod ScaleButtonGetHasFrameMethodInfo a signature where
    overloadedMethod = scaleButtonGetHasFrame

instance O.OverloadedMethodInfo ScaleButtonGetHasFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.scaleButtonGetHasFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#v:scaleButtonGetHasFrame"
        })


#endif

-- method ScaleButton::get_minus_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScaleButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScaleButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Button" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_get_minus_button" gtk_scale_button_get_minus_button :: 
    Ptr ScaleButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "ScaleButton"})
    IO (Ptr Gtk.Button.Button)

-- | Retrieves the minus button of the @GtkScaleButton@.
scaleButtonGetMinusButton ::
    (B.CallStack.HasCallStack, MonadIO m, IsScaleButton a) =>
    a
    -- ^ /@button@/: a @GtkScaleButton@
    -> m Gtk.Button.Button
    -- ^ __Returns:__ the minus button
    --   of the @GtkScaleButton@
scaleButtonGetMinusButton button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_scale_button_get_minus_button button'
    checkUnexpectedReturnNULL "scaleButtonGetMinusButton" result
    result' <- (newObject Gtk.Button.Button) result
    touchManagedPtr button
    return result'

#if defined(ENABLE_OVERLOADING)
data ScaleButtonGetMinusButtonMethodInfo
instance (signature ~ (m Gtk.Button.Button), MonadIO m, IsScaleButton a) => O.OverloadedMethod ScaleButtonGetMinusButtonMethodInfo a signature where
    overloadedMethod = scaleButtonGetMinusButton

instance O.OverloadedMethodInfo ScaleButtonGetMinusButtonMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.scaleButtonGetMinusButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#v:scaleButtonGetMinusButton"
        })


#endif

-- method ScaleButton::get_plus_button
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScaleButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScaleButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Button" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_get_plus_button" gtk_scale_button_get_plus_button :: 
    Ptr ScaleButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "ScaleButton"})
    IO (Ptr Gtk.Button.Button)

-- | Retrieves the plus button of the @GtkScaleButton.@
scaleButtonGetPlusButton ::
    (B.CallStack.HasCallStack, MonadIO m, IsScaleButton a) =>
    a
    -- ^ /@button@/: a @GtkScaleButton@
    -> m Gtk.Button.Button
    -- ^ __Returns:__ the plus button
    --   of the @GtkScaleButton@
scaleButtonGetPlusButton button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_scale_button_get_plus_button button'
    checkUnexpectedReturnNULL "scaleButtonGetPlusButton" result
    result' <- (newObject Gtk.Button.Button) result
    touchManagedPtr button
    return result'

#if defined(ENABLE_OVERLOADING)
data ScaleButtonGetPlusButtonMethodInfo
instance (signature ~ (m Gtk.Button.Button), MonadIO m, IsScaleButton a) => O.OverloadedMethod ScaleButtonGetPlusButtonMethodInfo a signature where
    overloadedMethod = scaleButtonGetPlusButton

instance O.OverloadedMethodInfo ScaleButtonGetPlusButtonMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.scaleButtonGetPlusButton",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#v:scaleButtonGetPlusButton"
        })


#endif

-- method ScaleButton::get_popup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScaleButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScaleButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_get_popup" gtk_scale_button_get_popup :: 
    Ptr ScaleButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "ScaleButton"})
    IO (Ptr Gtk.Widget.Widget)

-- | Retrieves the popup of the @GtkScaleButton@.
scaleButtonGetPopup ::
    (B.CallStack.HasCallStack, MonadIO m, IsScaleButton a) =>
    a
    -- ^ /@button@/: a @GtkScaleButton@
    -> m Gtk.Widget.Widget
    -- ^ __Returns:__ the popup of the @GtkScaleButton@
scaleButtonGetPopup button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_scale_button_get_popup button'
    checkUnexpectedReturnNULL "scaleButtonGetPopup" result
    result' <- (newObject Gtk.Widget.Widget) result
    touchManagedPtr button
    return result'

#if defined(ENABLE_OVERLOADING)
data ScaleButtonGetPopupMethodInfo
instance (signature ~ (m Gtk.Widget.Widget), MonadIO m, IsScaleButton a) => O.OverloadedMethod ScaleButtonGetPopupMethodInfo a signature where
    overloadedMethod = scaleButtonGetPopup

instance O.OverloadedMethodInfo ScaleButtonGetPopupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.scaleButtonGetPopup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#v:scaleButtonGetPopup"
        })


#endif

-- method ScaleButton::get_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScaleButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScaleButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_get_value" gtk_scale_button_get_value :: 
    Ptr ScaleButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "ScaleButton"})
    IO CDouble

-- | Gets the current value of the scale button.
scaleButtonGetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsScaleButton a) =>
    a
    -- ^ /@button@/: a @GtkScaleButton@
    -> m Double
    -- ^ __Returns:__ current value of the scale button
scaleButtonGetValue button = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    result <- gtk_scale_button_get_value button'
    let result' = realToFrac result
    touchManagedPtr button
    return result'

#if defined(ENABLE_OVERLOADING)
data ScaleButtonGetValueMethodInfo
instance (signature ~ (m Double), MonadIO m, IsScaleButton a) => O.OverloadedMethod ScaleButtonGetValueMethodInfo a signature where
    overloadedMethod = scaleButtonGetValue

instance O.OverloadedMethodInfo ScaleButtonGetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.scaleButtonGetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#v:scaleButtonGetValue"
        })


#endif

-- method ScaleButton::set_adjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScaleButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScaleButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "adjustment"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Adjustment" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAdjustment`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_set_adjustment" gtk_scale_button_set_adjustment :: 
    Ptr ScaleButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "ScaleButton"})
    Ptr Gtk.Adjustment.Adjustment ->        -- adjustment : TInterface (Name {namespace = "Gtk", name = "Adjustment"})
    IO ()

-- | Sets the @GtkAdjustment@ to be used as a model
-- for the @GtkScaleButton@’s scale.
-- 
-- See 'GI.Gtk.Objects.Range.rangeSetAdjustment' for details.
scaleButtonSetAdjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsScaleButton a, Gtk.Adjustment.IsAdjustment b) =>
    a
    -- ^ /@button@/: a @GtkScaleButton@
    -> b
    -- ^ /@adjustment@/: a @GtkAdjustment@
    -> m ()
scaleButtonSetAdjustment button adjustment = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    adjustment' <- unsafeManagedPtrCastPtr adjustment
    gtk_scale_button_set_adjustment button' adjustment'
    touchManagedPtr button
    touchManagedPtr adjustment
    return ()

#if defined(ENABLE_OVERLOADING)
data ScaleButtonSetAdjustmentMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsScaleButton a, Gtk.Adjustment.IsAdjustment b) => O.OverloadedMethod ScaleButtonSetAdjustmentMethodInfo a signature where
    overloadedMethod = scaleButtonSetAdjustment

instance O.OverloadedMethodInfo ScaleButtonSetAdjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.scaleButtonSetAdjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#v:scaleButtonSetAdjustment"
        })


#endif

-- method ScaleButton::set_has_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScaleButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScaleButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "has_frame"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether the button should have a visible frame"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_set_has_frame" gtk_scale_button_set_has_frame :: 
    Ptr ScaleButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "ScaleButton"})
    CInt ->                                 -- has_frame : TBasicType TBoolean
    IO ()

-- | Sets the style of the button.
-- 
-- /Since: 4.14/
scaleButtonSetHasFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsScaleButton a) =>
    a
    -- ^ /@button@/: a @GtkScaleButton@
    -> Bool
    -- ^ /@hasFrame@/: whether the button should have a visible frame
    -> m ()
scaleButtonSetHasFrame button hasFrame = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    let hasFrame' = (P.fromIntegral . P.fromEnum) hasFrame
    gtk_scale_button_set_has_frame button' hasFrame'
    touchManagedPtr button
    return ()

#if defined(ENABLE_OVERLOADING)
data ScaleButtonSetHasFrameMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsScaleButton a) => O.OverloadedMethod ScaleButtonSetHasFrameMethodInfo a signature where
    overloadedMethod = scaleButtonSetHasFrame

instance O.OverloadedMethodInfo ScaleButtonSetHasFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.scaleButtonSetHasFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#v:scaleButtonSetHasFrame"
        })


#endif

-- method ScaleButton::set_icons
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScaleButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScaleButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icons"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a %NULL-terminated array of icon names"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_set_icons" gtk_scale_button_set_icons :: 
    Ptr ScaleButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "ScaleButton"})
    Ptr CString ->                          -- icons : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Sets the icons to be used by the scale button.
scaleButtonSetIcons ::
    (B.CallStack.HasCallStack, MonadIO m, IsScaleButton a) =>
    a
    -- ^ /@button@/: a @GtkScaleButton@
    -> [T.Text]
    -- ^ /@icons@/: a 'P.Nothing'-terminated array of icon names
    -> m ()
scaleButtonSetIcons button icons = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    icons' <- packZeroTerminatedUTF8CArray icons
    gtk_scale_button_set_icons button' icons'
    touchManagedPtr button
    mapZeroTerminatedCArray freeMem icons'
    freeMem icons'
    return ()

#if defined(ENABLE_OVERLOADING)
data ScaleButtonSetIconsMethodInfo
instance (signature ~ ([T.Text] -> m ()), MonadIO m, IsScaleButton a) => O.OverloadedMethod ScaleButtonSetIconsMethodInfo a signature where
    overloadedMethod = scaleButtonSetIcons

instance O.OverloadedMethodInfo ScaleButtonSetIconsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.scaleButtonSetIcons",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#v:scaleButtonSetIcons"
        })


#endif

-- method ScaleButton::set_value
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "button"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScaleButton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScaleButton`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "new value of the scale button"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scale_button_set_value" gtk_scale_button_set_value :: 
    Ptr ScaleButton ->                      -- button : TInterface (Name {namespace = "Gtk", name = "ScaleButton"})
    CDouble ->                              -- value : TBasicType TDouble
    IO ()

-- | Sets the current value of the scale.
-- 
-- If the value is outside the minimum or maximum range values,
-- it will be clamped to fit inside them.
-- 
-- The scale button emits the [ScaleButton::valueChanged]("GI.Gtk.Objects.ScaleButton#g:signal:valueChanged")
-- signal if the value changes.
scaleButtonSetValue ::
    (B.CallStack.HasCallStack, MonadIO m, IsScaleButton a) =>
    a
    -- ^ /@button@/: a @GtkScaleButton@
    -> Double
    -- ^ /@value@/: new value of the scale button
    -> m ()
scaleButtonSetValue button value = liftIO $ do
    button' <- unsafeManagedPtrCastPtr button
    let value' = realToFrac value
    gtk_scale_button_set_value button' value'
    touchManagedPtr button
    return ()

#if defined(ENABLE_OVERLOADING)
data ScaleButtonSetValueMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsScaleButton a) => O.OverloadedMethod ScaleButtonSetValueMethodInfo a signature where
    overloadedMethod = scaleButtonSetValue

instance O.OverloadedMethodInfo ScaleButtonSetValueMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScaleButton.scaleButtonSetValue",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ScaleButton.html#v:scaleButtonSetValue"
        })


#endif


