{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Displays the progress of a long-running operation.
-- 
-- @GtkProgressBar@ provides a visual clue that processing is underway.
-- It can be used in two different modes: percentage mode and activity mode.
-- 
-- \<picture>
--   \<source srcset=\"progressbar-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkProgressBar\" src=\"progressbar.png\">
-- \<\/picture>
-- 
-- When an application can determine how much work needs to take place
-- (e.g. read a fixed number of bytes from a file) and can monitor its
-- progress, it can use the @GtkProgressBar@ in percentage mode and the
-- user sees a growing bar indicating the percentage of the work that
-- has been completed. In this mode, the application is required to call
-- 'GI.Gtk.Objects.ProgressBar.progressBarSetFraction' periodically to update the progress bar.
-- 
-- When an application has no accurate way of knowing the amount of work
-- to do, it can use the @GtkProgressBar@ in activity mode, which shows
-- activity by a block moving back and forth within the progress area. In
-- this mode, the application is required to call 'GI.Gtk.Objects.ProgressBar.progressBarPulse'
-- periodically to update the progress bar.
-- 
-- There is quite a bit of flexibility provided to control the appearance
-- of the @GtkProgressBar@. Functions are provided to control the orientation
-- of the bar, optional text can be displayed along with the bar, and the
-- step size used in activity mode can be set.
-- 
-- = CSS nodes
-- 
-- >progressbar[.osd]
-- >├── [text]
-- >╰── trough[.empty][.full]
-- >    ╰── progress[.pulse]
-- 
-- 
-- @GtkProgressBar@ has a main CSS node with name progressbar and subnodes with
-- names text and trough, of which the latter has a subnode named progress. The
-- text subnode is only present if text is shown. The progress subnode has the
-- style class .pulse when in activity mode. It gets the style classes .left,
-- .right, .top or .bottom added when the progress \'touches\' the corresponding
-- end of the GtkProgressBar. The .osd class on the progressbar node is for use
-- in overlays like the one Epiphany has for page loading progress.
-- 
-- = Accessibility
-- 
-- @GtkProgressBar@ uses the [enum/@gtk@/.AccessibleRole.progress_bar] role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ProgressBar
    ( 

-- * Exported types
    ProgressBar(..)                         ,
    IsProgressBar                           ,
    toProgressBar                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [pulse]("GI.Gtk.Objects.ProgressBar#g:method:pulse"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEllipsize]("GI.Gtk.Objects.ProgressBar#g:method:getEllipsize"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFraction]("GI.Gtk.Objects.ProgressBar#g:method:getFraction"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getInverted]("GI.Gtk.Objects.ProgressBar#g:method:getInverted"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOrientation]("GI.Gtk.Interfaces.Orientable#g:method:getOrientation"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getPulseStep]("GI.Gtk.Objects.ProgressBar#g:method:getPulseStep"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getShowText]("GI.Gtk.Objects.ProgressBar#g:method:getShowText"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getText]("GI.Gtk.Objects.ProgressBar#g:method:getText"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setEllipsize]("GI.Gtk.Objects.ProgressBar#g:method:setEllipsize"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setFraction]("GI.Gtk.Objects.ProgressBar#g:method:setFraction"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setInverted]("GI.Gtk.Objects.ProgressBar#g:method:setInverted"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOrientation]("GI.Gtk.Interfaces.Orientable#g:method:setOrientation"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setPulseStep]("GI.Gtk.Objects.ProgressBar#g:method:setPulseStep"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setShowText]("GI.Gtk.Objects.ProgressBar#g:method:setShowText"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setText]("GI.Gtk.Objects.ProgressBar#g:method:setText"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveProgressBarMethod                ,
#endif

-- ** getEllipsize #method:getEllipsize#

#if defined(ENABLE_OVERLOADING)
    ProgressBarGetEllipsizeMethodInfo       ,
#endif
    progressBarGetEllipsize                 ,


-- ** getFraction #method:getFraction#

#if defined(ENABLE_OVERLOADING)
    ProgressBarGetFractionMethodInfo        ,
#endif
    progressBarGetFraction                  ,


-- ** getInverted #method:getInverted#

#if defined(ENABLE_OVERLOADING)
    ProgressBarGetInvertedMethodInfo        ,
#endif
    progressBarGetInverted                  ,


-- ** getPulseStep #method:getPulseStep#

#if defined(ENABLE_OVERLOADING)
    ProgressBarGetPulseStepMethodInfo       ,
#endif
    progressBarGetPulseStep                 ,


-- ** getShowText #method:getShowText#

#if defined(ENABLE_OVERLOADING)
    ProgressBarGetShowTextMethodInfo        ,
#endif
    progressBarGetShowText                  ,


-- ** getText #method:getText#

#if defined(ENABLE_OVERLOADING)
    ProgressBarGetTextMethodInfo            ,
#endif
    progressBarGetText                      ,


-- ** new #method:new#

    progressBarNew                          ,


-- ** pulse #method:pulse#

#if defined(ENABLE_OVERLOADING)
    ProgressBarPulseMethodInfo              ,
#endif
    progressBarPulse                        ,


-- ** setEllipsize #method:setEllipsize#

#if defined(ENABLE_OVERLOADING)
    ProgressBarSetEllipsizeMethodInfo       ,
#endif
    progressBarSetEllipsize                 ,


-- ** setFraction #method:setFraction#

#if defined(ENABLE_OVERLOADING)
    ProgressBarSetFractionMethodInfo        ,
#endif
    progressBarSetFraction                  ,


-- ** setInverted #method:setInverted#

#if defined(ENABLE_OVERLOADING)
    ProgressBarSetInvertedMethodInfo        ,
#endif
    progressBarSetInverted                  ,


-- ** setPulseStep #method:setPulseStep#

#if defined(ENABLE_OVERLOADING)
    ProgressBarSetPulseStepMethodInfo       ,
#endif
    progressBarSetPulseStep                 ,


-- ** setShowText #method:setShowText#

#if defined(ENABLE_OVERLOADING)
    ProgressBarSetShowTextMethodInfo        ,
#endif
    progressBarSetShowText                  ,


-- ** setText #method:setText#

#if defined(ENABLE_OVERLOADING)
    ProgressBarSetTextMethodInfo            ,
#endif
    progressBarSetText                      ,




 -- * Properties


-- ** ellipsize #attr:ellipsize#
-- | The preferred place to ellipsize the string.
-- 
-- The text will be ellipsized if the progress bar does not have enough room
-- to display the entire string, specified as a @PangoEllipsizeMode@.
-- 
-- Note that setting this property to a value other than
-- 'GI.Pango.Enums.EllipsizeModeNone' has the side-effect that the progress bar requests
-- only enough space to display the ellipsis (\"...\"). Another means to set a
-- progress bar\'s width is 'GI.Gtk.Objects.Widget.widgetSetSizeRequest'.

#if defined(ENABLE_OVERLOADING)
    ProgressBarEllipsizePropertyInfo        ,
#endif
    constructProgressBarEllipsize           ,
    getProgressBarEllipsize                 ,
#if defined(ENABLE_OVERLOADING)
    progressBarEllipsize                    ,
#endif
    setProgressBarEllipsize                 ,


-- ** fraction #attr:fraction#
-- | The fraction of total work that has been completed.

#if defined(ENABLE_OVERLOADING)
    ProgressBarFractionPropertyInfo         ,
#endif
    constructProgressBarFraction            ,
    getProgressBarFraction                  ,
#if defined(ENABLE_OVERLOADING)
    progressBarFraction                     ,
#endif
    setProgressBarFraction                  ,


-- ** inverted #attr:inverted#
-- | Invert the direction in which the progress bar grows.

#if defined(ENABLE_OVERLOADING)
    ProgressBarInvertedPropertyInfo         ,
#endif
    constructProgressBarInverted            ,
    getProgressBarInverted                  ,
#if defined(ENABLE_OVERLOADING)
    progressBarInverted                     ,
#endif
    setProgressBarInverted                  ,


-- ** pulseStep #attr:pulseStep#
-- | The fraction of total progress to move the bounding block when pulsed.

#if defined(ENABLE_OVERLOADING)
    ProgressBarPulseStepPropertyInfo        ,
#endif
    constructProgressBarPulseStep           ,
    getProgressBarPulseStep                 ,
#if defined(ENABLE_OVERLOADING)
    progressBarPulseStep                    ,
#endif
    setProgressBarPulseStep                 ,


-- ** showText #attr:showText#
-- | Sets whether the progress bar will show a text in addition
-- to the bar itself.
-- 
-- The shown text is either the value of the [ProgressBar:text]("GI.Gtk.Objects.ProgressBar#g:attr:text")
-- property or, if that is 'P.Nothing', the [ProgressBar:fraction]("GI.Gtk.Objects.ProgressBar#g:attr:fraction")
-- value, as a percentage.
-- 
-- To make a progress bar that is styled and sized suitably for showing text
-- (even if the actual text is blank), set [ProgressBar:showText]("GI.Gtk.Objects.ProgressBar#g:attr:showText")
-- to 'P.True' and [ProgressBar:text]("GI.Gtk.Objects.ProgressBar#g:attr:text") to the empty string (not 'P.Nothing').

#if defined(ENABLE_OVERLOADING)
    ProgressBarShowTextPropertyInfo         ,
#endif
    constructProgressBarShowText            ,
    getProgressBarShowText                  ,
#if defined(ENABLE_OVERLOADING)
    progressBarShowText                     ,
#endif
    setProgressBarShowText                  ,


-- ** text #attr:text#
-- | Text to be displayed in the progress bar.

#if defined(ENABLE_OVERLOADING)
    ProgressBarTextPropertyInfo             ,
#endif
    clearProgressBarText                    ,
    constructProgressBarText                ,
    getProgressBarText                      ,
#if defined(ENABLE_OVERLOADING)
    progressBarText                         ,
#endif
    setProgressBarText                      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.AccessibleRange as Gtk.AccessibleRange
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import qualified GI.Pango.Enums as Pango.Enums

#endif

-- | Memory-managed wrapper type.
newtype ProgressBar = ProgressBar (SP.ManagedPtr ProgressBar)
    deriving (Eq)

instance SP.ManagedPtrNewtype ProgressBar where
    toManagedPtr (ProgressBar p) = p

foreign import ccall "gtk_progress_bar_get_type"
    c_gtk_progress_bar_get_type :: IO B.Types.GType

instance B.Types.TypedObject ProgressBar where
    glibType = c_gtk_progress_bar_get_type

instance B.Types.GObject ProgressBar

-- | Type class for types which can be safely cast to `ProgressBar`, for instance with `toProgressBar`.
class (SP.GObject o, O.IsDescendantOf ProgressBar o) => IsProgressBar o
instance (SP.GObject o, O.IsDescendantOf ProgressBar o) => IsProgressBar o

instance O.HasParentTypes ProgressBar
type instance O.ParentTypes ProgressBar = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.AccessibleRange.AccessibleRange, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Orientable.Orientable]

-- | Cast to `ProgressBar`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toProgressBar :: (MIO.MonadIO m, IsProgressBar o) => o -> m ProgressBar
toProgressBar = MIO.liftIO . B.ManagedPtr.unsafeCastTo ProgressBar

-- | Convert 'ProgressBar' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ProgressBar) where
    gvalueGType_ = c_gtk_progress_bar_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ProgressBar)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ProgressBar)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ProgressBar ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveProgressBarMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveProgressBarMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveProgressBarMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveProgressBarMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveProgressBarMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveProgressBarMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveProgressBarMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveProgressBarMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveProgressBarMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveProgressBarMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveProgressBarMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveProgressBarMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveProgressBarMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveProgressBarMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveProgressBarMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveProgressBarMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveProgressBarMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveProgressBarMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveProgressBarMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveProgressBarMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveProgressBarMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveProgressBarMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveProgressBarMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveProgressBarMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveProgressBarMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveProgressBarMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveProgressBarMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveProgressBarMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveProgressBarMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveProgressBarMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveProgressBarMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveProgressBarMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveProgressBarMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveProgressBarMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveProgressBarMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveProgressBarMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveProgressBarMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveProgressBarMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveProgressBarMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveProgressBarMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveProgressBarMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveProgressBarMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveProgressBarMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveProgressBarMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveProgressBarMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveProgressBarMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveProgressBarMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveProgressBarMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveProgressBarMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveProgressBarMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveProgressBarMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveProgressBarMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveProgressBarMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveProgressBarMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveProgressBarMethod "pulse" o = ProgressBarPulseMethodInfo
    ResolveProgressBarMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveProgressBarMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveProgressBarMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveProgressBarMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveProgressBarMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveProgressBarMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveProgressBarMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveProgressBarMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveProgressBarMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveProgressBarMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveProgressBarMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveProgressBarMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveProgressBarMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveProgressBarMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveProgressBarMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveProgressBarMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveProgressBarMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveProgressBarMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveProgressBarMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveProgressBarMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveProgressBarMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveProgressBarMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveProgressBarMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveProgressBarMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveProgressBarMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveProgressBarMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveProgressBarMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveProgressBarMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveProgressBarMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveProgressBarMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveProgressBarMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveProgressBarMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveProgressBarMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveProgressBarMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveProgressBarMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveProgressBarMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveProgressBarMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveProgressBarMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveProgressBarMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveProgressBarMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveProgressBarMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveProgressBarMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveProgressBarMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveProgressBarMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveProgressBarMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveProgressBarMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveProgressBarMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveProgressBarMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveProgressBarMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveProgressBarMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveProgressBarMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveProgressBarMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveProgressBarMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveProgressBarMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveProgressBarMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveProgressBarMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveProgressBarMethod "getEllipsize" o = ProgressBarGetEllipsizeMethodInfo
    ResolveProgressBarMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveProgressBarMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveProgressBarMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveProgressBarMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveProgressBarMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveProgressBarMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveProgressBarMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveProgressBarMethod "getFraction" o = ProgressBarGetFractionMethodInfo
    ResolveProgressBarMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveProgressBarMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveProgressBarMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveProgressBarMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveProgressBarMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveProgressBarMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveProgressBarMethod "getInverted" o = ProgressBarGetInvertedMethodInfo
    ResolveProgressBarMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveProgressBarMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveProgressBarMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveProgressBarMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveProgressBarMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveProgressBarMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveProgressBarMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveProgressBarMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveProgressBarMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveProgressBarMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveProgressBarMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveProgressBarMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveProgressBarMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveProgressBarMethod "getOrientation" o = Gtk.Orientable.OrientableGetOrientationMethodInfo
    ResolveProgressBarMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveProgressBarMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveProgressBarMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveProgressBarMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveProgressBarMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveProgressBarMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveProgressBarMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveProgressBarMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveProgressBarMethod "getPulseStep" o = ProgressBarGetPulseStepMethodInfo
    ResolveProgressBarMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveProgressBarMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveProgressBarMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveProgressBarMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveProgressBarMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveProgressBarMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveProgressBarMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveProgressBarMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveProgressBarMethod "getShowText" o = ProgressBarGetShowTextMethodInfo
    ResolveProgressBarMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveProgressBarMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveProgressBarMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveProgressBarMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveProgressBarMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveProgressBarMethod "getText" o = ProgressBarGetTextMethodInfo
    ResolveProgressBarMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveProgressBarMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveProgressBarMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveProgressBarMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveProgressBarMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveProgressBarMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveProgressBarMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveProgressBarMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveProgressBarMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveProgressBarMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveProgressBarMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveProgressBarMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveProgressBarMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveProgressBarMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveProgressBarMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveProgressBarMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveProgressBarMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveProgressBarMethod "setEllipsize" o = ProgressBarSetEllipsizeMethodInfo
    ResolveProgressBarMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveProgressBarMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveProgressBarMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveProgressBarMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveProgressBarMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveProgressBarMethod "setFraction" o = ProgressBarSetFractionMethodInfo
    ResolveProgressBarMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveProgressBarMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveProgressBarMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveProgressBarMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveProgressBarMethod "setInverted" o = ProgressBarSetInvertedMethodInfo
    ResolveProgressBarMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveProgressBarMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveProgressBarMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveProgressBarMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveProgressBarMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveProgressBarMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveProgressBarMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveProgressBarMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveProgressBarMethod "setOrientation" o = Gtk.Orientable.OrientableSetOrientationMethodInfo
    ResolveProgressBarMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveProgressBarMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveProgressBarMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveProgressBarMethod "setPulseStep" o = ProgressBarSetPulseStepMethodInfo
    ResolveProgressBarMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveProgressBarMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveProgressBarMethod "setShowText" o = ProgressBarSetShowTextMethodInfo
    ResolveProgressBarMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveProgressBarMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveProgressBarMethod "setText" o = ProgressBarSetTextMethodInfo
    ResolveProgressBarMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveProgressBarMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveProgressBarMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveProgressBarMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveProgressBarMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveProgressBarMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveProgressBarMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveProgressBarMethod t ProgressBar, O.OverloadedMethod info ProgressBar p) => OL.IsLabel t (ProgressBar -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveProgressBarMethod t ProgressBar, O.OverloadedMethod info ProgressBar p, R.HasField t ProgressBar p) => R.HasField t ProgressBar p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveProgressBarMethod t ProgressBar, O.OverloadedMethodInfo info ProgressBar) => OL.IsLabel t (O.MethodProxy info ProgressBar) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "ellipsize"
   -- Type: TInterface (Name {namespace = "Pango", name = "EllipsizeMode"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@ellipsize@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' progressBar #ellipsize
-- @
getProgressBarEllipsize :: (MonadIO m, IsProgressBar o) => o -> m Pango.Enums.EllipsizeMode
getProgressBarEllipsize obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "ellipsize"

-- | Set the value of the “@ellipsize@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' progressBar [ #ellipsize 'Data.GI.Base.Attributes.:=' value ]
-- @
setProgressBarEllipsize :: (MonadIO m, IsProgressBar o) => o -> Pango.Enums.EllipsizeMode -> m ()
setProgressBarEllipsize obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "ellipsize" val

-- | Construct a `GValueConstruct` with valid value for the “@ellipsize@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProgressBarEllipsize :: (IsProgressBar o, MIO.MonadIO m) => Pango.Enums.EllipsizeMode -> m (GValueConstruct o)
constructProgressBarEllipsize val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "ellipsize" val

#if defined(ENABLE_OVERLOADING)
data ProgressBarEllipsizePropertyInfo
instance AttrInfo ProgressBarEllipsizePropertyInfo where
    type AttrAllowedOps ProgressBarEllipsizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ProgressBarEllipsizePropertyInfo = IsProgressBar
    type AttrSetTypeConstraint ProgressBarEllipsizePropertyInfo = (~) Pango.Enums.EllipsizeMode
    type AttrTransferTypeConstraint ProgressBarEllipsizePropertyInfo = (~) Pango.Enums.EllipsizeMode
    type AttrTransferType ProgressBarEllipsizePropertyInfo = Pango.Enums.EllipsizeMode
    type AttrGetType ProgressBarEllipsizePropertyInfo = Pango.Enums.EllipsizeMode
    type AttrLabel ProgressBarEllipsizePropertyInfo = "ellipsize"
    type AttrOrigin ProgressBarEllipsizePropertyInfo = ProgressBar
    attrGet = getProgressBarEllipsize
    attrSet = setProgressBarEllipsize
    attrTransfer _ v = do
        return v
    attrConstruct = constructProgressBarEllipsize
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.ellipsize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#g:attr:ellipsize"
        })
#endif

-- VVV Prop "fraction"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@fraction@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' progressBar #fraction
-- @
getProgressBarFraction :: (MonadIO m, IsProgressBar o) => o -> m Double
getProgressBarFraction obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "fraction"

-- | Set the value of the “@fraction@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' progressBar [ #fraction 'Data.GI.Base.Attributes.:=' value ]
-- @
setProgressBarFraction :: (MonadIO m, IsProgressBar o) => o -> Double -> m ()
setProgressBarFraction obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "fraction" val

-- | Construct a `GValueConstruct` with valid value for the “@fraction@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProgressBarFraction :: (IsProgressBar o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructProgressBarFraction val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "fraction" val

#if defined(ENABLE_OVERLOADING)
data ProgressBarFractionPropertyInfo
instance AttrInfo ProgressBarFractionPropertyInfo where
    type AttrAllowedOps ProgressBarFractionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ProgressBarFractionPropertyInfo = IsProgressBar
    type AttrSetTypeConstraint ProgressBarFractionPropertyInfo = (~) Double
    type AttrTransferTypeConstraint ProgressBarFractionPropertyInfo = (~) Double
    type AttrTransferType ProgressBarFractionPropertyInfo = Double
    type AttrGetType ProgressBarFractionPropertyInfo = Double
    type AttrLabel ProgressBarFractionPropertyInfo = "fraction"
    type AttrOrigin ProgressBarFractionPropertyInfo = ProgressBar
    attrGet = getProgressBarFraction
    attrSet = setProgressBarFraction
    attrTransfer _ v = do
        return v
    attrConstruct = constructProgressBarFraction
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.fraction"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#g:attr:fraction"
        })
#endif

-- VVV Prop "inverted"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@inverted@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' progressBar #inverted
-- @
getProgressBarInverted :: (MonadIO m, IsProgressBar o) => o -> m Bool
getProgressBarInverted obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "inverted"

-- | Set the value of the “@inverted@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' progressBar [ #inverted 'Data.GI.Base.Attributes.:=' value ]
-- @
setProgressBarInverted :: (MonadIO m, IsProgressBar o) => o -> Bool -> m ()
setProgressBarInverted obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "inverted" val

-- | Construct a `GValueConstruct` with valid value for the “@inverted@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProgressBarInverted :: (IsProgressBar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructProgressBarInverted val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "inverted" val

#if defined(ENABLE_OVERLOADING)
data ProgressBarInvertedPropertyInfo
instance AttrInfo ProgressBarInvertedPropertyInfo where
    type AttrAllowedOps ProgressBarInvertedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ProgressBarInvertedPropertyInfo = IsProgressBar
    type AttrSetTypeConstraint ProgressBarInvertedPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ProgressBarInvertedPropertyInfo = (~) Bool
    type AttrTransferType ProgressBarInvertedPropertyInfo = Bool
    type AttrGetType ProgressBarInvertedPropertyInfo = Bool
    type AttrLabel ProgressBarInvertedPropertyInfo = "inverted"
    type AttrOrigin ProgressBarInvertedPropertyInfo = ProgressBar
    attrGet = getProgressBarInverted
    attrSet = setProgressBarInverted
    attrTransfer _ v = do
        return v
    attrConstruct = constructProgressBarInverted
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.inverted"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#g:attr:inverted"
        })
#endif

-- VVV Prop "pulse-step"
   -- Type: TBasicType TDouble
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@pulse-step@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' progressBar #pulseStep
-- @
getProgressBarPulseStep :: (MonadIO m, IsProgressBar o) => o -> m Double
getProgressBarPulseStep obj = MIO.liftIO $ B.Properties.getObjectPropertyDouble obj "pulse-step"

-- | Set the value of the “@pulse-step@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' progressBar [ #pulseStep 'Data.GI.Base.Attributes.:=' value ]
-- @
setProgressBarPulseStep :: (MonadIO m, IsProgressBar o) => o -> Double -> m ()
setProgressBarPulseStep obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyDouble obj "pulse-step" val

-- | Construct a `GValueConstruct` with valid value for the “@pulse-step@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProgressBarPulseStep :: (IsProgressBar o, MIO.MonadIO m) => Double -> m (GValueConstruct o)
constructProgressBarPulseStep val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyDouble "pulse-step" val

#if defined(ENABLE_OVERLOADING)
data ProgressBarPulseStepPropertyInfo
instance AttrInfo ProgressBarPulseStepPropertyInfo where
    type AttrAllowedOps ProgressBarPulseStepPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ProgressBarPulseStepPropertyInfo = IsProgressBar
    type AttrSetTypeConstraint ProgressBarPulseStepPropertyInfo = (~) Double
    type AttrTransferTypeConstraint ProgressBarPulseStepPropertyInfo = (~) Double
    type AttrTransferType ProgressBarPulseStepPropertyInfo = Double
    type AttrGetType ProgressBarPulseStepPropertyInfo = Double
    type AttrLabel ProgressBarPulseStepPropertyInfo = "pulse-step"
    type AttrOrigin ProgressBarPulseStepPropertyInfo = ProgressBar
    attrGet = getProgressBarPulseStep
    attrSet = setProgressBarPulseStep
    attrTransfer _ v = do
        return v
    attrConstruct = constructProgressBarPulseStep
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.pulseStep"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#g:attr:pulseStep"
        })
#endif

-- VVV Prop "show-text"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@show-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' progressBar #showText
-- @
getProgressBarShowText :: (MonadIO m, IsProgressBar o) => o -> m Bool
getProgressBarShowText obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "show-text"

-- | Set the value of the “@show-text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' progressBar [ #showText 'Data.GI.Base.Attributes.:=' value ]
-- @
setProgressBarShowText :: (MonadIO m, IsProgressBar o) => o -> Bool -> m ()
setProgressBarShowText obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "show-text" val

-- | Construct a `GValueConstruct` with valid value for the “@show-text@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProgressBarShowText :: (IsProgressBar o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructProgressBarShowText val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "show-text" val

#if defined(ENABLE_OVERLOADING)
data ProgressBarShowTextPropertyInfo
instance AttrInfo ProgressBarShowTextPropertyInfo where
    type AttrAllowedOps ProgressBarShowTextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ProgressBarShowTextPropertyInfo = IsProgressBar
    type AttrSetTypeConstraint ProgressBarShowTextPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ProgressBarShowTextPropertyInfo = (~) Bool
    type AttrTransferType ProgressBarShowTextPropertyInfo = Bool
    type AttrGetType ProgressBarShowTextPropertyInfo = Bool
    type AttrLabel ProgressBarShowTextPropertyInfo = "show-text"
    type AttrOrigin ProgressBarShowTextPropertyInfo = ProgressBar
    attrGet = getProgressBarShowText
    attrSet = setProgressBarShowText
    attrTransfer _ v = do
        return v
    attrConstruct = constructProgressBarShowText
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.showText"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#g:attr:showText"
        })
#endif

-- VVV Prop "text"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' progressBar #text
-- @
getProgressBarText :: (MonadIO m, IsProgressBar o) => o -> m (Maybe T.Text)
getProgressBarText obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "text"

-- | Set the value of the “@text@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' progressBar [ #text 'Data.GI.Base.Attributes.:=' value ]
-- @
setProgressBarText :: (MonadIO m, IsProgressBar o) => o -> T.Text -> m ()
setProgressBarText obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "text" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@text@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProgressBarText :: (IsProgressBar o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructProgressBarText val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "text" (P.Just val)

-- | Set the value of the “@text@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #text
-- @
clearProgressBarText :: (MonadIO m, IsProgressBar o) => o -> m ()
clearProgressBarText obj = liftIO $ B.Properties.setObjectPropertyString obj "text" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data ProgressBarTextPropertyInfo
instance AttrInfo ProgressBarTextPropertyInfo where
    type AttrAllowedOps ProgressBarTextPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ProgressBarTextPropertyInfo = IsProgressBar
    type AttrSetTypeConstraint ProgressBarTextPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ProgressBarTextPropertyInfo = (~) T.Text
    type AttrTransferType ProgressBarTextPropertyInfo = T.Text
    type AttrGetType ProgressBarTextPropertyInfo = (Maybe T.Text)
    type AttrLabel ProgressBarTextPropertyInfo = "text"
    type AttrOrigin ProgressBarTextPropertyInfo = ProgressBar
    attrGet = getProgressBarText
    attrSet = setProgressBarText
    attrTransfer _ v = do
        return v
    attrConstruct = constructProgressBarText
    attrClear = clearProgressBarText
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.text"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#g:attr:text"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ProgressBar
type instance O.AttributeList ProgressBar = ProgressBarAttributeList
type ProgressBarAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("ellipsize", ProgressBarEllipsizePropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("fraction", ProgressBarFractionPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("inverted", ProgressBarInvertedPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("orientation", Gtk.Orientable.OrientableOrientationPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("pulseStep", ProgressBarPulseStepPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("showText", ProgressBarShowTextPropertyInfo), '("text", ProgressBarTextPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
progressBarEllipsize :: AttrLabelProxy "ellipsize"
progressBarEllipsize = AttrLabelProxy

progressBarFraction :: AttrLabelProxy "fraction"
progressBarFraction = AttrLabelProxy

progressBarInverted :: AttrLabelProxy "inverted"
progressBarInverted = AttrLabelProxy

progressBarPulseStep :: AttrLabelProxy "pulseStep"
progressBarPulseStep = AttrLabelProxy

progressBarShowText :: AttrLabelProxy "showText"
progressBarShowText = AttrLabelProxy

progressBarText :: AttrLabelProxy "text"
progressBarText = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ProgressBar = ProgressBarSignalList
type ProgressBarSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ProgressBar::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "ProgressBar" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_new" gtk_progress_bar_new :: 
    IO (Ptr ProgressBar)

-- | Creates a new @GtkProgressBar@.
progressBarNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ProgressBar
    -- ^ __Returns:__ a @GtkProgressBar@.
progressBarNew  = liftIO $ do
    result <- gtk_progress_bar_new
    checkUnexpectedReturnNULL "progressBarNew" result
    result' <- (newObject ProgressBar) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ProgressBar::get_ellipsize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Pango" , name = "EllipsizeMode" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_get_ellipsize" gtk_progress_bar_get_ellipsize :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    IO CUInt

-- | Returns the ellipsizing position of the progress bar.
-- 
-- See 'GI.Gtk.Objects.ProgressBar.progressBarSetEllipsize'.
progressBarGetEllipsize ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> m Pango.Enums.EllipsizeMode
    -- ^ __Returns:__ @PangoEllipsizeMode@
progressBarGetEllipsize pbar = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    result <- gtk_progress_bar_get_ellipsize pbar'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr pbar
    return result'

#if defined(ENABLE_OVERLOADING)
data ProgressBarGetEllipsizeMethodInfo
instance (signature ~ (m Pango.Enums.EllipsizeMode), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarGetEllipsizeMethodInfo a signature where
    overloadedMethod = progressBarGetEllipsize

instance O.OverloadedMethodInfo ProgressBarGetEllipsizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarGetEllipsize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarGetEllipsize"
        })


#endif

-- method ProgressBar::get_fraction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_get_fraction" gtk_progress_bar_get_fraction :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    IO CDouble

-- | Returns the current fraction of the task that’s been completed.
progressBarGetFraction ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> m Double
    -- ^ __Returns:__ a fraction from 0.0 to 1.0
progressBarGetFraction pbar = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    result <- gtk_progress_bar_get_fraction pbar'
    let result' = realToFrac result
    touchManagedPtr pbar
    return result'

#if defined(ENABLE_OVERLOADING)
data ProgressBarGetFractionMethodInfo
instance (signature ~ (m Double), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarGetFractionMethodInfo a signature where
    overloadedMethod = progressBarGetFraction

instance O.OverloadedMethodInfo ProgressBarGetFractionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarGetFraction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarGetFraction"
        })


#endif

-- method ProgressBar::get_inverted
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_get_inverted" gtk_progress_bar_get_inverted :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    IO CInt

-- | Returns whether the progress bar is inverted.
progressBarGetInverted ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the progress bar is inverted
progressBarGetInverted pbar = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    result <- gtk_progress_bar_get_inverted pbar'
    let result' = (/= 0) result
    touchManagedPtr pbar
    return result'

#if defined(ENABLE_OVERLOADING)
data ProgressBarGetInvertedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarGetInvertedMethodInfo a signature where
    overloadedMethod = progressBarGetInverted

instance O.OverloadedMethodInfo ProgressBarGetInvertedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarGetInverted",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarGetInverted"
        })


#endif

-- method ProgressBar::get_pulse_step
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TDouble)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_get_pulse_step" gtk_progress_bar_get_pulse_step :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    IO CDouble

-- | Retrieves the pulse step.
-- 
-- See 'GI.Gtk.Objects.ProgressBar.progressBarSetPulseStep'.
progressBarGetPulseStep ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> m Double
    -- ^ __Returns:__ a fraction from 0.0 to 1.0
progressBarGetPulseStep pbar = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    result <- gtk_progress_bar_get_pulse_step pbar'
    let result' = realToFrac result
    touchManagedPtr pbar
    return result'

#if defined(ENABLE_OVERLOADING)
data ProgressBarGetPulseStepMethodInfo
instance (signature ~ (m Double), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarGetPulseStepMethodInfo a signature where
    overloadedMethod = progressBarGetPulseStep

instance O.OverloadedMethodInfo ProgressBarGetPulseStepMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarGetPulseStep",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarGetPulseStep"
        })


#endif

-- method ProgressBar::get_show_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_get_show_text" gtk_progress_bar_get_show_text :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    IO CInt

-- | Returns whether the @GtkProgressBar@ shows text.
-- 
-- See 'GI.Gtk.Objects.ProgressBar.progressBarSetShowText'.
progressBarGetShowText ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if text is shown in the progress bar
progressBarGetShowText pbar = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    result <- gtk_progress_bar_get_show_text pbar'
    let result' = (/= 0) result
    touchManagedPtr pbar
    return result'

#if defined(ENABLE_OVERLOADING)
data ProgressBarGetShowTextMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarGetShowTextMethodInfo a signature where
    overloadedMethod = progressBarGetShowText

instance O.OverloadedMethodInfo ProgressBarGetShowTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarGetShowText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarGetShowText"
        })


#endif

-- method ProgressBar::get_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_get_text" gtk_progress_bar_get_text :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    IO CString

-- | Retrieves the text that is displayed with the progress bar.
-- 
-- The return value is a reference to the text, not a copy of it,
-- so will become invalid if you change the text in the progress bar.
progressBarGetText ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the text
progressBarGetText pbar = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    result <- gtk_progress_bar_get_text pbar'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr pbar
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ProgressBarGetTextMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarGetTextMethodInfo a signature where
    overloadedMethod = progressBarGetText

instance O.OverloadedMethodInfo ProgressBarGetTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarGetText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarGetText"
        })


#endif

-- method ProgressBar::pulse
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_pulse" gtk_progress_bar_pulse :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    IO ()

-- | Indicates that some progress has been made, but you don’t know how much.
-- 
-- Causes the progress bar to enter “activity mode,” where a block
-- bounces back and forth. Each call to 'GI.Gtk.Objects.ProgressBar.progressBarPulse'
-- causes the block to move by a little bit (the amount of movement
-- per pulse is determined by 'GI.Gtk.Objects.ProgressBar.progressBarSetPulseStep').
progressBarPulse ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> m ()
progressBarPulse pbar = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    gtk_progress_bar_pulse pbar'
    touchManagedPtr pbar
    return ()

#if defined(ENABLE_OVERLOADING)
data ProgressBarPulseMethodInfo
instance (signature ~ (m ()), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarPulseMethodInfo a signature where
    overloadedMethod = progressBarPulse

instance O.OverloadedMethodInfo ProgressBarPulseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarPulse",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarPulse"
        })


#endif

-- method ProgressBar::set_ellipsize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mode"
--           , argType =
--               TInterface Name { namespace = "Pango" , name = "EllipsizeMode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `PangoEllipsizeMode`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_set_ellipsize" gtk_progress_bar_set_ellipsize :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    CUInt ->                                -- mode : TInterface (Name {namespace = "Pango", name = "EllipsizeMode"})
    IO ()

-- | Sets the mode used to ellipsize the text.
-- 
-- The text is ellipsized if there is not enough space
-- to render the entire string.
progressBarSetEllipsize ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> Pango.Enums.EllipsizeMode
    -- ^ /@mode@/: a @PangoEllipsizeMode@
    -> m ()
progressBarSetEllipsize pbar mode = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    let mode' = (fromIntegral . fromEnum) mode
    gtk_progress_bar_set_ellipsize pbar' mode'
    touchManagedPtr pbar
    return ()

#if defined(ENABLE_OVERLOADING)
data ProgressBarSetEllipsizeMethodInfo
instance (signature ~ (Pango.Enums.EllipsizeMode -> m ()), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarSetEllipsizeMethodInfo a signature where
    overloadedMethod = progressBarSetEllipsize

instance O.OverloadedMethodInfo ProgressBarSetEllipsizeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarSetEllipsize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarSetEllipsize"
        })


#endif

-- method ProgressBar::set_fraction
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fraction"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "fraction of the task that\8217s been completed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_set_fraction" gtk_progress_bar_set_fraction :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    CDouble ->                              -- fraction : TBasicType TDouble
    IO ()

-- | Causes the progress bar to “fill in” the given fraction
-- of the bar.
-- 
-- The fraction should be between 0.0 and 1.0, inclusive.
progressBarSetFraction ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> Double
    -- ^ /@fraction@/: fraction of the task that’s been completed
    -> m ()
progressBarSetFraction pbar fraction = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    let fraction' = realToFrac fraction
    gtk_progress_bar_set_fraction pbar' fraction'
    touchManagedPtr pbar
    return ()

#if defined(ENABLE_OVERLOADING)
data ProgressBarSetFractionMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarSetFractionMethodInfo a signature where
    overloadedMethod = progressBarSetFraction

instance O.OverloadedMethodInfo ProgressBarSetFractionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarSetFraction",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarSetFraction"
        })


#endif

-- method ProgressBar::set_inverted
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "inverted"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to invert the progress bar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_set_inverted" gtk_progress_bar_set_inverted :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    CInt ->                                 -- inverted : TBasicType TBoolean
    IO ()

-- | Sets whether the progress bar is inverted.
-- 
-- Progress bars normally grow from top to bottom or left to right.
-- Inverted progress bars grow in the opposite direction.
progressBarSetInverted ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> Bool
    -- ^ /@inverted@/: 'P.True' to invert the progress bar
    -> m ()
progressBarSetInverted pbar inverted = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    let inverted' = (P.fromIntegral . P.fromEnum) inverted
    gtk_progress_bar_set_inverted pbar' inverted'
    touchManagedPtr pbar
    return ()

#if defined(ENABLE_OVERLOADING)
data ProgressBarSetInvertedMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarSetInvertedMethodInfo a signature where
    overloadedMethod = progressBarSetInverted

instance O.OverloadedMethodInfo ProgressBarSetInvertedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarSetInverted",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarSetInverted"
        })


#endif

-- method ProgressBar::set_pulse_step
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "fraction"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "fraction between 0.0 and 1.0"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_set_pulse_step" gtk_progress_bar_set_pulse_step :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    CDouble ->                              -- fraction : TBasicType TDouble
    IO ()

-- | Sets the fraction of total progress bar length to move the
-- bouncing block.
-- 
-- The bouncing block is moved when 'GI.Gtk.Objects.ProgressBar.progressBarPulse'
-- is called.
progressBarSetPulseStep ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> Double
    -- ^ /@fraction@/: fraction between 0.0 and 1.0
    -> m ()
progressBarSetPulseStep pbar fraction = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    let fraction' = realToFrac fraction
    gtk_progress_bar_set_pulse_step pbar' fraction'
    touchManagedPtr pbar
    return ()

#if defined(ENABLE_OVERLOADING)
data ProgressBarSetPulseStepMethodInfo
instance (signature ~ (Double -> m ()), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarSetPulseStepMethodInfo a signature where
    overloadedMethod = progressBarSetPulseStep

instance O.OverloadedMethodInfo ProgressBarSetPulseStepMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarSetPulseStep",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarSetPulseStep"
        })


#endif

-- method ProgressBar::set_show_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "show_text"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to show text"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_set_show_text" gtk_progress_bar_set_show_text :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    CInt ->                                 -- show_text : TBasicType TBoolean
    IO ()

-- | Sets whether the progress bar will show text next to the bar.
-- 
-- The shown text is either the value of the [ProgressBar:text]("GI.Gtk.Objects.ProgressBar#g:attr:text")
-- property or, if that is 'P.Nothing', the [ProgressBar:fraction]("GI.Gtk.Objects.ProgressBar#g:attr:fraction") value,
-- as a percentage.
-- 
-- To make a progress bar that is styled and sized suitably for containing
-- text (even if the actual text is blank), set [ProgressBar:showText]("GI.Gtk.Objects.ProgressBar#g:attr:showText")
-- to 'P.True' and [ProgressBar:text]("GI.Gtk.Objects.ProgressBar#g:attr:text") to the empty string (not 'P.Nothing').
progressBarSetShowText ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> Bool
    -- ^ /@showText@/: whether to show text
    -> m ()
progressBarSetShowText pbar showText = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    let showText' = (P.fromIntegral . P.fromEnum) showText
    gtk_progress_bar_set_show_text pbar' showText'
    touchManagedPtr pbar
    return ()

#if defined(ENABLE_OVERLOADING)
data ProgressBarSetShowTextMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarSetShowTextMethodInfo a signature where
    overloadedMethod = progressBarSetShowText

instance O.OverloadedMethodInfo ProgressBarSetShowTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarSetShowText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarSetShowText"
        })


#endif

-- method ProgressBar::set_text
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "pbar"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ProgressBar" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkProgressBar`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "text"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a UTF-8 string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_progress_bar_set_text" gtk_progress_bar_set_text :: 
    Ptr ProgressBar ->                      -- pbar : TInterface (Name {namespace = "Gtk", name = "ProgressBar"})
    CString ->                              -- text : TBasicType TUTF8
    IO ()

-- | Causes the given /@text@/ to appear next to the progress bar.
-- 
-- If /@text@/ is 'P.Nothing' and [ProgressBar:showText]("GI.Gtk.Objects.ProgressBar#g:attr:showText") is 'P.True',
-- the current value of [ProgressBar:fraction]("GI.Gtk.Objects.ProgressBar#g:attr:fraction") will be displayed
-- as a percentage.
-- 
-- If /@text@/ is non-'P.Nothing' and [ProgressBar:showText]("GI.Gtk.Objects.ProgressBar#g:attr:showText") is 'P.True',
-- the text will be displayed. In this case, it will not display the progress
-- percentage. If /@text@/ is the empty string, the progress bar will still
-- be styled and sized suitably for containing text, as long as
-- [ProgressBar:showText]("GI.Gtk.Objects.ProgressBar#g:attr:showText") is 'P.True'.
progressBarSetText ::
    (B.CallStack.HasCallStack, MonadIO m, IsProgressBar a) =>
    a
    -- ^ /@pbar@/: a @GtkProgressBar@
    -> Maybe (T.Text)
    -- ^ /@text@/: a UTF-8 string
    -> m ()
progressBarSetText pbar text = liftIO $ do
    pbar' <- unsafeManagedPtrCastPtr pbar
    maybeText <- case text of
        Nothing -> return FP.nullPtr
        Just jText -> do
            jText' <- textToCString jText
            return jText'
    gtk_progress_bar_set_text pbar' maybeText
    touchManagedPtr pbar
    freeMem maybeText
    return ()

#if defined(ENABLE_OVERLOADING)
data ProgressBarSetTextMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsProgressBar a) => O.OverloadedMethod ProgressBarSetTextMethodInfo a signature where
    overloadedMethod = progressBarSetText

instance O.OverloadedMethodInfo ProgressBarSetTextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ProgressBar.progressBarSetText",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-ProgressBar.html#v:progressBarSetText"
        })


#endif


