{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A print dialog for platforms which don’t provide a native
-- print dialog, like Unix.
-- 
-- \<picture>
--   \<source srcset=\"printdialog-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkPrintUnixDialog\" src=\"printdialog.png\">
-- \<\/picture>
-- 
-- It can be used very much like any other GTK dialog, at the cost of
-- the portability offered by the high-level printing API with
-- t'GI.Gtk.Objects.PrintOperation.PrintOperation'.
-- 
-- In order to print something with @GtkPrintUnixDialog@, you need to
-- use 'GI.Gtk.Objects.PrintUnixDialog.printUnixDialogGetSelectedPrinter' to obtain a
-- t'GI.Gtk.Objects.Printer.Printer' object and use it to construct a t'GI.Gtk.Objects.PrintJob.PrintJob'
-- using 'GI.Gtk.Objects.PrintJob.printJobNew'.
-- 
-- @GtkPrintUnixDialog@ uses the following response values:
-- 
-- * 'GI.Gtk.Enums.ResponseTypeOk': for the “Print” button
-- * 'GI.Gtk.Enums.ResponseTypeApply': for the “Preview” button
-- * 'GI.Gtk.Enums.ResponseTypeCancel': for the “Cancel” button
-- 
-- 
-- = GtkPrintUnixDialog as GtkBuildable
-- 
-- The @GtkPrintUnixDialog@ implementation of the @GtkBuildable@ interface
-- exposes its /@notebook@/ internal children with the name “notebook”.
-- 
-- An example of a @GtkPrintUnixDialog@ UI definition fragment:
-- 
-- 
-- === /xml code/
-- ><object class="GtkPrintUnixDialog" id="dialog1">
-- >  <child internal-child="notebook">
-- >    <object class="GtkNotebook" id="notebook">
-- >      <child>
-- >        <object type="GtkNotebookPage">
-- >          <property name="tab_expand">False</property>
-- >          <property name="tab_fill">False</property>
-- >          <property name="tab">
-- >            <object class="GtkLabel" id="tablabel">
-- >              <property name="label">Tab label</property>
-- >            </object>
-- >          </property>
-- >          <property name="child">
-- >            <object class="GtkLabel" id="tabcontent">
-- >              <property name="label">Content on notebook tab</property>
-- >            </object>
-- >          </property>
-- >        </object>
-- >      </child>
-- >    </object>
-- >  </child>
-- ></object>
-- 
-- 
-- = CSS nodes
-- 
-- @GtkPrintUnixDialog@ has a single CSS node with name window. The style classes
-- dialog and print are added.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.PrintUnixDialog
    ( 

-- * Exported types
    PrintUnixDialog(..)                     ,
    IsPrintUnixDialog                       ,
    toPrintUnixDialog                       ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addActionWidget]("GI.Gtk.Objects.Dialog#g:method:addActionWidget"), [addButton]("GI.Gtk.Objects.Dialog#g:method:addButton"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addCustomTab]("GI.Gtk.Objects.PrintUnixDialog#g:method:addCustomTab"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [close]("GI.Gtk.Objects.Window#g:method:close"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [destroy]("GI.Gtk.Objects.Window#g:method:destroy"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [fullscreen]("GI.Gtk.Objects.Window#g:method:fullscreen"), [fullscreenOnMonitor]("GI.Gtk.Objects.Window#g:method:fullscreenOnMonitor"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasGroup]("GI.Gtk.Objects.Window#g:method:hasGroup"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isActive]("GI.Gtk.Objects.Window#g:method:isActive"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isFullscreen]("GI.Gtk.Objects.Window#g:method:isFullscreen"), [isMaximized]("GI.Gtk.Objects.Window#g:method:isMaximized"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isSuspended]("GI.Gtk.Objects.Window#g:method:isSuspended"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [maximize]("GI.Gtk.Objects.Window#g:method:maximize"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [minimize]("GI.Gtk.Objects.Window#g:method:minimize"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [present]("GI.Gtk.Objects.Window#g:method:present"), [presentWithTime]("GI.Gtk.Objects.Window#g:method:presentWithTime"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [response]("GI.Gtk.Objects.Dialog#g:method:response"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unfullscreen]("GI.Gtk.Objects.Window#g:method:unfullscreen"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unmaximize]("GI.Gtk.Objects.Window#g:method:unmaximize"), [unminimize]("GI.Gtk.Objects.Window#g:method:unminimize"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getApplication]("GI.Gtk.Objects.Window#g:method:getApplication"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Window#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getContentArea]("GI.Gtk.Objects.Dialog#g:method:getContentArea"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCurrentPage]("GI.Gtk.Objects.PrintUnixDialog#g:method:getCurrentPage"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDecorated]("GI.Gtk.Objects.Window#g:method:getDecorated"), [getDefaultSize]("GI.Gtk.Objects.Window#g:method:getDefaultSize"), [getDefaultWidget]("GI.Gtk.Objects.Window#g:method:getDefaultWidget"), [getDeletable]("GI.Gtk.Objects.Window#g:method:getDeletable"), [getDestroyWithParent]("GI.Gtk.Objects.Window#g:method:getDestroyWithParent"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getEmbedPageSetup]("GI.Gtk.Objects.PrintUnixDialog#g:method:getEmbedPageSetup"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocus]("GI.Gtk.Objects.Window#g:method:getFocus"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusVisible]("GI.Gtk.Objects.Window#g:method:getFocusVisible"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getGroup]("GI.Gtk.Objects.Window#g:method:getGroup"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:getHandleMenubarAccel"), [getHasSelection]("GI.Gtk.Objects.PrintUnixDialog#g:method:getHasSelection"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeaderBar]("GI.Gtk.Objects.Dialog#g:method:getHeaderBar"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHideOnClose]("GI.Gtk.Objects.Window#g:method:getHideOnClose"), [getIconName]("GI.Gtk.Objects.Window#g:method:getIconName"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getManualCapabilities]("GI.Gtk.Objects.PrintUnixDialog#g:method:getManualCapabilities"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:getMnemonicsVisible"), [getModal]("GI.Gtk.Objects.Window#g:method:getModal"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPageSetup]("GI.Gtk.Objects.PrintUnixDialog#g:method:getPageSetup"), [getPageSetupSet]("GI.Gtk.Objects.PrintUnixDialog#g:method:getPageSetupSet"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getResizable]("GI.Gtk.Objects.Window#g:method:getResizable"), [getResponseForWidget]("GI.Gtk.Objects.Dialog#g:method:getResponseForWidget"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSelectedPrinter]("GI.Gtk.Objects.PrintUnixDialog#g:method:getSelectedPrinter"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.PrintUnixDialog#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSupportSelection]("GI.Gtk.Objects.PrintUnixDialog#g:method:getSupportSelection"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTitle]("GI.Gtk.Objects.Window#g:method:getTitle"), [getTitlebar]("GI.Gtk.Objects.Window#g:method:getTitlebar"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getTransientFor]("GI.Gtk.Objects.Window#g:method:getTransientFor"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidgetForResponse]("GI.Gtk.Objects.Dialog#g:method:getWidgetForResponse"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setApplication]("GI.Gtk.Objects.Window#g:method:setApplication"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Window#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCurrentPage]("GI.Gtk.Objects.PrintUnixDialog#g:method:setCurrentPage"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorated]("GI.Gtk.Objects.Window#g:method:setDecorated"), [setDefaultResponse]("GI.Gtk.Objects.Dialog#g:method:setDefaultResponse"), [setDefaultSize]("GI.Gtk.Objects.Window#g:method:setDefaultSize"), [setDefaultWidget]("GI.Gtk.Objects.Window#g:method:setDefaultWidget"), [setDeletable]("GI.Gtk.Objects.Window#g:method:setDeletable"), [setDestroyWithParent]("GI.Gtk.Objects.Window#g:method:setDestroyWithParent"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setDisplay]("GI.Gtk.Objects.Window#g:method:setDisplay"), [setEmbedPageSetup]("GI.Gtk.Objects.PrintUnixDialog#g:method:setEmbedPageSetup"), [setFocus]("GI.Gtk.Objects.Window#g:method:setFocus"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusVisible]("GI.Gtk.Objects.Window#g:method:setFocusVisible"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:setHandleMenubarAccel"), [setHasSelection]("GI.Gtk.Objects.PrintUnixDialog#g:method:setHasSelection"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHideOnClose]("GI.Gtk.Objects.Window#g:method:setHideOnClose"), [setIconName]("GI.Gtk.Objects.Window#g:method:setIconName"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setManualCapabilities]("GI.Gtk.Objects.PrintUnixDialog#g:method:setManualCapabilities"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:setMnemonicsVisible"), [setModal]("GI.Gtk.Objects.Window#g:method:setModal"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setPageSetup]("GI.Gtk.Objects.PrintUnixDialog#g:method:setPageSetup"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResizable]("GI.Gtk.Objects.Window#g:method:setResizable"), [setResponseSensitive]("GI.Gtk.Objects.Dialog#g:method:setResponseSensitive"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSettings]("GI.Gtk.Objects.PrintUnixDialog#g:method:setSettings"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStartupId]("GI.Gtk.Objects.Window#g:method:setStartupId"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setSupportSelection]("GI.Gtk.Objects.PrintUnixDialog#g:method:setSupportSelection"), [setTitle]("GI.Gtk.Objects.Window#g:method:setTitle"), [setTitlebar]("GI.Gtk.Objects.Window#g:method:setTitlebar"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setTransientFor]("GI.Gtk.Objects.Window#g:method:setTransientFor"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolvePrintUnixDialogMethod            ,
#endif

-- ** addCustomTab #method:addCustomTab#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogAddCustomTabMethodInfo   ,
#endif
    printUnixDialogAddCustomTab             ,


-- ** getCurrentPage #method:getCurrentPage#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogGetCurrentPageMethodInfo ,
#endif
    printUnixDialogGetCurrentPage           ,


-- ** getEmbedPageSetup #method:getEmbedPageSetup#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogGetEmbedPageSetupMethodInfo,
#endif
    printUnixDialogGetEmbedPageSetup        ,


-- ** getHasSelection #method:getHasSelection#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogGetHasSelectionMethodInfo,
#endif
    printUnixDialogGetHasSelection          ,


-- ** getManualCapabilities #method:getManualCapabilities#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogGetManualCapabilitiesMethodInfo,
#endif
    printUnixDialogGetManualCapabilities    ,


-- ** getPageSetup #method:getPageSetup#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogGetPageSetupMethodInfo   ,
#endif
    printUnixDialogGetPageSetup             ,


-- ** getPageSetupSet #method:getPageSetupSet#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogGetPageSetupSetMethodInfo,
#endif
    printUnixDialogGetPageSetupSet          ,


-- ** getSelectedPrinter #method:getSelectedPrinter#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogGetSelectedPrinterMethodInfo,
#endif
    printUnixDialogGetSelectedPrinter       ,


-- ** getSettings #method:getSettings#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogGetSettingsMethodInfo    ,
#endif
    printUnixDialogGetSettings              ,


-- ** getSupportSelection #method:getSupportSelection#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogGetSupportSelectionMethodInfo,
#endif
    printUnixDialogGetSupportSelection      ,


-- ** new #method:new#

    printUnixDialogNew                      ,


-- ** setCurrentPage #method:setCurrentPage#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogSetCurrentPageMethodInfo ,
#endif
    printUnixDialogSetCurrentPage           ,


-- ** setEmbedPageSetup #method:setEmbedPageSetup#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogSetEmbedPageSetupMethodInfo,
#endif
    printUnixDialogSetEmbedPageSetup        ,


-- ** setHasSelection #method:setHasSelection#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogSetHasSelectionMethodInfo,
#endif
    printUnixDialogSetHasSelection          ,


-- ** setManualCapabilities #method:setManualCapabilities#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogSetManualCapabilitiesMethodInfo,
#endif
    printUnixDialogSetManualCapabilities    ,


-- ** setPageSetup #method:setPageSetup#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogSetPageSetupMethodInfo   ,
#endif
    printUnixDialogSetPageSetup             ,


-- ** setSettings #method:setSettings#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogSetSettingsMethodInfo    ,
#endif
    printUnixDialogSetSettings              ,


-- ** setSupportSelection #method:setSupportSelection#

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogSetSupportSelectionMethodInfo,
#endif
    printUnixDialogSetSupportSelection      ,




 -- * Properties


-- ** currentPage #attr:currentPage#
-- | The current page in the document.

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogCurrentPagePropertyInfo  ,
#endif
    constructPrintUnixDialogCurrentPage     ,
    getPrintUnixDialogCurrentPage           ,
#if defined(ENABLE_OVERLOADING)
    printUnixDialogCurrentPage              ,
#endif
    setPrintUnixDialogCurrentPage           ,


-- ** embedPageSetup #attr:embedPageSetup#
-- | 'P.True' if the page setup controls are embedded.

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogEmbedPageSetupPropertyInfo,
#endif
    constructPrintUnixDialogEmbedPageSetup  ,
    getPrintUnixDialogEmbedPageSetup        ,
#if defined(ENABLE_OVERLOADING)
    printUnixDialogEmbedPageSetup           ,
#endif
    setPrintUnixDialogEmbedPageSetup        ,


-- ** hasSelection #attr:hasSelection#
-- | Whether the application has a selection.

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogHasSelectionPropertyInfo ,
#endif
    constructPrintUnixDialogHasSelection    ,
    getPrintUnixDialogHasSelection          ,
#if defined(ENABLE_OVERLOADING)
    printUnixDialogHasSelection             ,
#endif
    setPrintUnixDialogHasSelection          ,


-- ** manualCapabilities #attr:manualCapabilities#
-- | Capabilities the application can handle.

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogManualCapabilitiesPropertyInfo,
#endif
    constructPrintUnixDialogManualCapabilities,
    getPrintUnixDialogManualCapabilities    ,
#if defined(ENABLE_OVERLOADING)
    printUnixDialogManualCapabilities       ,
#endif
    setPrintUnixDialogManualCapabilities    ,


-- ** pageSetup #attr:pageSetup#
-- | The @GtkPageSetup@ object to use.

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogPageSetupPropertyInfo    ,
#endif
    constructPrintUnixDialogPageSetup       ,
    getPrintUnixDialogPageSetup             ,
#if defined(ENABLE_OVERLOADING)
    printUnixDialogPageSetup                ,
#endif
    setPrintUnixDialogPageSetup             ,


-- ** printSettings #attr:printSettings#
-- | The @GtkPrintSettings@ object used for this dialog.

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogPrintSettingsPropertyInfo,
#endif
    clearPrintUnixDialogPrintSettings       ,
    constructPrintUnixDialogPrintSettings   ,
    getPrintUnixDialogPrintSettings         ,
#if defined(ENABLE_OVERLOADING)
    printUnixDialogPrintSettings            ,
#endif
    setPrintUnixDialogPrintSettings         ,


-- ** selectedPrinter #attr:selectedPrinter#
-- | The @GtkPrinter@ which is selected.

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogSelectedPrinterPropertyInfo,
#endif
    getPrintUnixDialogSelectedPrinter       ,
#if defined(ENABLE_OVERLOADING)
    printUnixDialogSelectedPrinter          ,
#endif


-- ** supportSelection #attr:supportSelection#
-- | Whether the dialog supports selection.

#if defined(ENABLE_OVERLOADING)
    PrintUnixDialogSupportSelectionPropertyInfo,
#endif
    constructPrintUnixDialogSupportSelection,
    getPrintUnixDialogSupportSelection      ,
#if defined(ENABLE_OVERLOADING)
    printUnixDialogSupportSelection         ,
#endif
    setPrintUnixDialogSupportSelection      ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.KeyFile as GLib.KeyFile
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Orientable as Gtk.Orientable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.Box as Gtk.Box
import {-# SOURCE #-} qualified GI.Gtk.Objects.Dialog as Gtk.Dialog
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.HeaderBar as Gtk.HeaderBar
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Objects.PrintSettings as Gtk.PrintSettings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Printer as Gtk.Printer
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.PageRange as Gtk.PageRange
import {-# SOURCE #-} qualified GI.Gtk.Structs.PaperSize as Gtk.PaperSize
import {-# SOURCE #-} qualified GI.Gtk.Structs.PrintBackend as Gtk.PrintBackend
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Dialog as Gtk.Dialog
import {-# SOURCE #-} qualified GI.Gtk.Objects.PageSetup as Gtk.PageSetup
import {-# SOURCE #-} qualified GI.Gtk.Objects.PrintSettings as Gtk.PrintSettings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Printer as Gtk.Printer
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window

#endif

-- | Memory-managed wrapper type.
newtype PrintUnixDialog = PrintUnixDialog (SP.ManagedPtr PrintUnixDialog)
    deriving (Eq)

instance SP.ManagedPtrNewtype PrintUnixDialog where
    toManagedPtr (PrintUnixDialog p) = p

foreign import ccall "gtk_print_unix_dialog_get_type"
    c_gtk_print_unix_dialog_get_type :: IO B.Types.GType

instance B.Types.TypedObject PrintUnixDialog where
    glibType = c_gtk_print_unix_dialog_get_type

instance B.Types.GObject PrintUnixDialog

-- | Type class for types which can be safely cast to `PrintUnixDialog`, for instance with `toPrintUnixDialog`.
class (SP.GObject o, O.IsDescendantOf PrintUnixDialog o) => IsPrintUnixDialog o
instance (SP.GObject o, O.IsDescendantOf PrintUnixDialog o) => IsPrintUnixDialog o

instance O.HasParentTypes PrintUnixDialog
type instance O.ParentTypes PrintUnixDialog = '[Gtk.Dialog.Dialog, Gtk.Window.Window, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Native.Native, Gtk.Root.Root, Gtk.ShortcutManager.ShortcutManager]

-- | Cast to `PrintUnixDialog`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toPrintUnixDialog :: (MIO.MonadIO m, IsPrintUnixDialog o) => o -> m PrintUnixDialog
toPrintUnixDialog = MIO.liftIO . B.ManagedPtr.unsafeCastTo PrintUnixDialog

-- | Convert 'PrintUnixDialog' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PrintUnixDialog) where
    gvalueGType_ = c_gtk_print_unix_dialog_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PrintUnixDialog)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PrintUnixDialog)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PrintUnixDialog ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePrintUnixDialogMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePrintUnixDialogMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolvePrintUnixDialogMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolvePrintUnixDialogMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolvePrintUnixDialogMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolvePrintUnixDialogMethod "addActionWidget" o = Gtk.Dialog.DialogAddActionWidgetMethodInfo
    ResolvePrintUnixDialogMethod "addButton" o = Gtk.Dialog.DialogAddButtonMethodInfo
    ResolvePrintUnixDialogMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolvePrintUnixDialogMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolvePrintUnixDialogMethod "addCustomTab" o = PrintUnixDialogAddCustomTabMethodInfo
    ResolvePrintUnixDialogMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolvePrintUnixDialogMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolvePrintUnixDialogMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolvePrintUnixDialogMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolvePrintUnixDialogMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePrintUnixDialogMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePrintUnixDialogMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolvePrintUnixDialogMethod "close" o = Gtk.Window.WindowCloseMethodInfo
    ResolvePrintUnixDialogMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolvePrintUnixDialogMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolvePrintUnixDialogMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolvePrintUnixDialogMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolvePrintUnixDialogMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolvePrintUnixDialogMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolvePrintUnixDialogMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolvePrintUnixDialogMethod "destroy" o = Gtk.Window.WindowDestroyMethodInfo
    ResolvePrintUnixDialogMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolvePrintUnixDialogMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolvePrintUnixDialogMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolvePrintUnixDialogMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePrintUnixDialogMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePrintUnixDialogMethod "fullscreen" o = Gtk.Window.WindowFullscreenMethodInfo
    ResolvePrintUnixDialogMethod "fullscreenOnMonitor" o = Gtk.Window.WindowFullscreenOnMonitorMethodInfo
    ResolvePrintUnixDialogMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePrintUnixDialogMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolvePrintUnixDialogMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolvePrintUnixDialogMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolvePrintUnixDialogMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolvePrintUnixDialogMethod "hasGroup" o = Gtk.Window.WindowHasGroupMethodInfo
    ResolvePrintUnixDialogMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolvePrintUnixDialogMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolvePrintUnixDialogMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolvePrintUnixDialogMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolvePrintUnixDialogMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolvePrintUnixDialogMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolvePrintUnixDialogMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolvePrintUnixDialogMethod "isActive" o = Gtk.Window.WindowIsActiveMethodInfo
    ResolvePrintUnixDialogMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolvePrintUnixDialogMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolvePrintUnixDialogMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePrintUnixDialogMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolvePrintUnixDialogMethod "isFullscreen" o = Gtk.Window.WindowIsFullscreenMethodInfo
    ResolvePrintUnixDialogMethod "isMaximized" o = Gtk.Window.WindowIsMaximizedMethodInfo
    ResolvePrintUnixDialogMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolvePrintUnixDialogMethod "isSuspended" o = Gtk.Window.WindowIsSuspendedMethodInfo
    ResolvePrintUnixDialogMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolvePrintUnixDialogMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolvePrintUnixDialogMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolvePrintUnixDialogMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolvePrintUnixDialogMethod "maximize" o = Gtk.Window.WindowMaximizeMethodInfo
    ResolvePrintUnixDialogMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolvePrintUnixDialogMethod "minimize" o = Gtk.Window.WindowMinimizeMethodInfo
    ResolvePrintUnixDialogMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolvePrintUnixDialogMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePrintUnixDialogMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePrintUnixDialogMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolvePrintUnixDialogMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolvePrintUnixDialogMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolvePrintUnixDialogMethod "present" o = Gtk.Window.WindowPresentMethodInfo
    ResolvePrintUnixDialogMethod "presentWithTime" o = Gtk.Window.WindowPresentWithTimeMethodInfo
    ResolvePrintUnixDialogMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolvePrintUnixDialogMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolvePrintUnixDialogMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolvePrintUnixDialogMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolvePrintUnixDialogMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePrintUnixDialogMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePrintUnixDialogMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolvePrintUnixDialogMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolvePrintUnixDialogMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolvePrintUnixDialogMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolvePrintUnixDialogMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolvePrintUnixDialogMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolvePrintUnixDialogMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolvePrintUnixDialogMethod "response" o = Gtk.Dialog.DialogResponseMethodInfo
    ResolvePrintUnixDialogMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePrintUnixDialogMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolvePrintUnixDialogMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolvePrintUnixDialogMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolvePrintUnixDialogMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolvePrintUnixDialogMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePrintUnixDialogMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePrintUnixDialogMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePrintUnixDialogMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolvePrintUnixDialogMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolvePrintUnixDialogMethod "unfullscreen" o = Gtk.Window.WindowUnfullscreenMethodInfo
    ResolvePrintUnixDialogMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolvePrintUnixDialogMethod "unmaximize" o = Gtk.Window.WindowUnmaximizeMethodInfo
    ResolvePrintUnixDialogMethod "unminimize" o = Gtk.Window.WindowUnminimizeMethodInfo
    ResolvePrintUnixDialogMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolvePrintUnixDialogMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolvePrintUnixDialogMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePrintUnixDialogMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolvePrintUnixDialogMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolvePrintUnixDialogMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolvePrintUnixDialogMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolvePrintUnixDialogMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolvePrintUnixDialogMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolvePrintUnixDialogMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePrintUnixDialogMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolvePrintUnixDialogMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolvePrintUnixDialogMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolvePrintUnixDialogMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolvePrintUnixDialogMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolvePrintUnixDialogMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolvePrintUnixDialogMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolvePrintUnixDialogMethod "getApplication" o = Gtk.Window.WindowGetApplicationMethodInfo
    ResolvePrintUnixDialogMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolvePrintUnixDialogMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolvePrintUnixDialogMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolvePrintUnixDialogMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolvePrintUnixDialogMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolvePrintUnixDialogMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolvePrintUnixDialogMethod "getChild" o = Gtk.Window.WindowGetChildMethodInfo
    ResolvePrintUnixDialogMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolvePrintUnixDialogMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolvePrintUnixDialogMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolvePrintUnixDialogMethod "getContentArea" o = Gtk.Dialog.DialogGetContentAreaMethodInfo
    ResolvePrintUnixDialogMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolvePrintUnixDialogMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolvePrintUnixDialogMethod "getCurrentPage" o = PrintUnixDialogGetCurrentPageMethodInfo
    ResolvePrintUnixDialogMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolvePrintUnixDialogMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePrintUnixDialogMethod "getDecorated" o = Gtk.Window.WindowGetDecoratedMethodInfo
    ResolvePrintUnixDialogMethod "getDefaultSize" o = Gtk.Window.WindowGetDefaultSizeMethodInfo
    ResolvePrintUnixDialogMethod "getDefaultWidget" o = Gtk.Window.WindowGetDefaultWidgetMethodInfo
    ResolvePrintUnixDialogMethod "getDeletable" o = Gtk.Window.WindowGetDeletableMethodInfo
    ResolvePrintUnixDialogMethod "getDestroyWithParent" o = Gtk.Window.WindowGetDestroyWithParentMethodInfo
    ResolvePrintUnixDialogMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolvePrintUnixDialogMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolvePrintUnixDialogMethod "getEmbedPageSetup" o = PrintUnixDialogGetEmbedPageSetupMethodInfo
    ResolvePrintUnixDialogMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolvePrintUnixDialogMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolvePrintUnixDialogMethod "getFocus" o = Gtk.Window.WindowGetFocusMethodInfo
    ResolvePrintUnixDialogMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolvePrintUnixDialogMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolvePrintUnixDialogMethod "getFocusVisible" o = Gtk.Window.WindowGetFocusVisibleMethodInfo
    ResolvePrintUnixDialogMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolvePrintUnixDialogMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolvePrintUnixDialogMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolvePrintUnixDialogMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolvePrintUnixDialogMethod "getGroup" o = Gtk.Window.WindowGetGroupMethodInfo
    ResolvePrintUnixDialogMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolvePrintUnixDialogMethod "getHandleMenubarAccel" o = Gtk.Window.WindowGetHandleMenubarAccelMethodInfo
    ResolvePrintUnixDialogMethod "getHasSelection" o = PrintUnixDialogGetHasSelectionMethodInfo
    ResolvePrintUnixDialogMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolvePrintUnixDialogMethod "getHeaderBar" o = Gtk.Dialog.DialogGetHeaderBarMethodInfo
    ResolvePrintUnixDialogMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolvePrintUnixDialogMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolvePrintUnixDialogMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolvePrintUnixDialogMethod "getHideOnClose" o = Gtk.Window.WindowGetHideOnCloseMethodInfo
    ResolvePrintUnixDialogMethod "getIconName" o = Gtk.Window.WindowGetIconNameMethodInfo
    ResolvePrintUnixDialogMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolvePrintUnixDialogMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolvePrintUnixDialogMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolvePrintUnixDialogMethod "getManualCapabilities" o = PrintUnixDialogGetManualCapabilitiesMethodInfo
    ResolvePrintUnixDialogMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolvePrintUnixDialogMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolvePrintUnixDialogMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolvePrintUnixDialogMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolvePrintUnixDialogMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolvePrintUnixDialogMethod "getMnemonicsVisible" o = Gtk.Window.WindowGetMnemonicsVisibleMethodInfo
    ResolvePrintUnixDialogMethod "getModal" o = Gtk.Window.WindowGetModalMethodInfo
    ResolvePrintUnixDialogMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolvePrintUnixDialogMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolvePrintUnixDialogMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolvePrintUnixDialogMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolvePrintUnixDialogMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolvePrintUnixDialogMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolvePrintUnixDialogMethod "getPageSetup" o = PrintUnixDialogGetPageSetupMethodInfo
    ResolvePrintUnixDialogMethod "getPageSetupSet" o = PrintUnixDialogGetPageSetupSetMethodInfo
    ResolvePrintUnixDialogMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolvePrintUnixDialogMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolvePrintUnixDialogMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolvePrintUnixDialogMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolvePrintUnixDialogMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolvePrintUnixDialogMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolvePrintUnixDialogMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePrintUnixDialogMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePrintUnixDialogMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolvePrintUnixDialogMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolvePrintUnixDialogMethod "getRenderer" o = Gtk.Native.NativeGetRendererMethodInfo
    ResolvePrintUnixDialogMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolvePrintUnixDialogMethod "getResizable" o = Gtk.Window.WindowGetResizableMethodInfo
    ResolvePrintUnixDialogMethod "getResponseForWidget" o = Gtk.Dialog.DialogGetResponseForWidgetMethodInfo
    ResolvePrintUnixDialogMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolvePrintUnixDialogMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolvePrintUnixDialogMethod "getSelectedPrinter" o = PrintUnixDialogGetSelectedPrinterMethodInfo
    ResolvePrintUnixDialogMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolvePrintUnixDialogMethod "getSettings" o = PrintUnixDialogGetSettingsMethodInfo
    ResolvePrintUnixDialogMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolvePrintUnixDialogMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolvePrintUnixDialogMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolvePrintUnixDialogMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolvePrintUnixDialogMethod "getSupportSelection" o = PrintUnixDialogGetSupportSelectionMethodInfo
    ResolvePrintUnixDialogMethod "getSurface" o = Gtk.Native.NativeGetSurfaceMethodInfo
    ResolvePrintUnixDialogMethod "getSurfaceTransform" o = Gtk.Native.NativeGetSurfaceTransformMethodInfo
    ResolvePrintUnixDialogMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolvePrintUnixDialogMethod "getTitle" o = Gtk.Window.WindowGetTitleMethodInfo
    ResolvePrintUnixDialogMethod "getTitlebar" o = Gtk.Window.WindowGetTitlebarMethodInfo
    ResolvePrintUnixDialogMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolvePrintUnixDialogMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolvePrintUnixDialogMethod "getTransientFor" o = Gtk.Window.WindowGetTransientForMethodInfo
    ResolvePrintUnixDialogMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolvePrintUnixDialogMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolvePrintUnixDialogMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolvePrintUnixDialogMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolvePrintUnixDialogMethod "getWidgetForResponse" o = Gtk.Dialog.DialogGetWidgetForResponseMethodInfo
    ResolvePrintUnixDialogMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolvePrintUnixDialogMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolvePrintUnixDialogMethod "setApplication" o = Gtk.Window.WindowSetApplicationMethodInfo
    ResolvePrintUnixDialogMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolvePrintUnixDialogMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolvePrintUnixDialogMethod "setChild" o = Gtk.Window.WindowSetChildMethodInfo
    ResolvePrintUnixDialogMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolvePrintUnixDialogMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolvePrintUnixDialogMethod "setCurrentPage" o = PrintUnixDialogSetCurrentPageMethodInfo
    ResolvePrintUnixDialogMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolvePrintUnixDialogMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolvePrintUnixDialogMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePrintUnixDialogMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePrintUnixDialogMethod "setDecorated" o = Gtk.Window.WindowSetDecoratedMethodInfo
    ResolvePrintUnixDialogMethod "setDefaultResponse" o = Gtk.Dialog.DialogSetDefaultResponseMethodInfo
    ResolvePrintUnixDialogMethod "setDefaultSize" o = Gtk.Window.WindowSetDefaultSizeMethodInfo
    ResolvePrintUnixDialogMethod "setDefaultWidget" o = Gtk.Window.WindowSetDefaultWidgetMethodInfo
    ResolvePrintUnixDialogMethod "setDeletable" o = Gtk.Window.WindowSetDeletableMethodInfo
    ResolvePrintUnixDialogMethod "setDestroyWithParent" o = Gtk.Window.WindowSetDestroyWithParentMethodInfo
    ResolvePrintUnixDialogMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolvePrintUnixDialogMethod "setDisplay" o = Gtk.Window.WindowSetDisplayMethodInfo
    ResolvePrintUnixDialogMethod "setEmbedPageSetup" o = PrintUnixDialogSetEmbedPageSetupMethodInfo
    ResolvePrintUnixDialogMethod "setFocus" o = Gtk.Window.WindowSetFocusMethodInfo
    ResolvePrintUnixDialogMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolvePrintUnixDialogMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolvePrintUnixDialogMethod "setFocusVisible" o = Gtk.Window.WindowSetFocusVisibleMethodInfo
    ResolvePrintUnixDialogMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolvePrintUnixDialogMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolvePrintUnixDialogMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolvePrintUnixDialogMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolvePrintUnixDialogMethod "setHandleMenubarAccel" o = Gtk.Window.WindowSetHandleMenubarAccelMethodInfo
    ResolvePrintUnixDialogMethod "setHasSelection" o = PrintUnixDialogSetHasSelectionMethodInfo
    ResolvePrintUnixDialogMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolvePrintUnixDialogMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolvePrintUnixDialogMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolvePrintUnixDialogMethod "setHideOnClose" o = Gtk.Window.WindowSetHideOnCloseMethodInfo
    ResolvePrintUnixDialogMethod "setIconName" o = Gtk.Window.WindowSetIconNameMethodInfo
    ResolvePrintUnixDialogMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolvePrintUnixDialogMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolvePrintUnixDialogMethod "setManualCapabilities" o = PrintUnixDialogSetManualCapabilitiesMethodInfo
    ResolvePrintUnixDialogMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolvePrintUnixDialogMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolvePrintUnixDialogMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolvePrintUnixDialogMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolvePrintUnixDialogMethod "setMnemonicsVisible" o = Gtk.Window.WindowSetMnemonicsVisibleMethodInfo
    ResolvePrintUnixDialogMethod "setModal" o = Gtk.Window.WindowSetModalMethodInfo
    ResolvePrintUnixDialogMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolvePrintUnixDialogMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolvePrintUnixDialogMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolvePrintUnixDialogMethod "setPageSetup" o = PrintUnixDialogSetPageSetupMethodInfo
    ResolvePrintUnixDialogMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolvePrintUnixDialogMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePrintUnixDialogMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolvePrintUnixDialogMethod "setResizable" o = Gtk.Window.WindowSetResizableMethodInfo
    ResolvePrintUnixDialogMethod "setResponseSensitive" o = Gtk.Dialog.DialogSetResponseSensitiveMethodInfo
    ResolvePrintUnixDialogMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolvePrintUnixDialogMethod "setSettings" o = PrintUnixDialogSetSettingsMethodInfo
    ResolvePrintUnixDialogMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolvePrintUnixDialogMethod "setStartupId" o = Gtk.Window.WindowSetStartupIdMethodInfo
    ResolvePrintUnixDialogMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolvePrintUnixDialogMethod "setSupportSelection" o = PrintUnixDialogSetSupportSelectionMethodInfo
    ResolvePrintUnixDialogMethod "setTitle" o = Gtk.Window.WindowSetTitleMethodInfo
    ResolvePrintUnixDialogMethod "setTitlebar" o = Gtk.Window.WindowSetTitlebarMethodInfo
    ResolvePrintUnixDialogMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolvePrintUnixDialogMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolvePrintUnixDialogMethod "setTransientFor" o = Gtk.Window.WindowSetTransientForMethodInfo
    ResolvePrintUnixDialogMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolvePrintUnixDialogMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolvePrintUnixDialogMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolvePrintUnixDialogMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolvePrintUnixDialogMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePrintUnixDialogMethod t PrintUnixDialog, O.OverloadedMethod info PrintUnixDialog p) => OL.IsLabel t (PrintUnixDialog -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePrintUnixDialogMethod t PrintUnixDialog, O.OverloadedMethod info PrintUnixDialog p, R.HasField t PrintUnixDialog p) => R.HasField t PrintUnixDialog p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePrintUnixDialogMethod t PrintUnixDialog, O.OverloadedMethodInfo info PrintUnixDialog) => OL.IsLabel t (O.MethodProxy info PrintUnixDialog) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "current-page"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@current-page@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printUnixDialog #currentPage
-- @
getPrintUnixDialogCurrentPage :: (MonadIO m, IsPrintUnixDialog o) => o -> m Int32
getPrintUnixDialogCurrentPage obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "current-page"

-- | Set the value of the “@current-page@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' printUnixDialog [ #currentPage 'Data.GI.Base.Attributes.:=' value ]
-- @
setPrintUnixDialogCurrentPage :: (MonadIO m, IsPrintUnixDialog o) => o -> Int32 -> m ()
setPrintUnixDialogCurrentPage obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "current-page" val

-- | Construct a `GValueConstruct` with valid value for the “@current-page@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintUnixDialogCurrentPage :: (IsPrintUnixDialog o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructPrintUnixDialogCurrentPage val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "current-page" val

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogCurrentPagePropertyInfo
instance AttrInfo PrintUnixDialogCurrentPagePropertyInfo where
    type AttrAllowedOps PrintUnixDialogCurrentPagePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PrintUnixDialogCurrentPagePropertyInfo = IsPrintUnixDialog
    type AttrSetTypeConstraint PrintUnixDialogCurrentPagePropertyInfo = (~) Int32
    type AttrTransferTypeConstraint PrintUnixDialogCurrentPagePropertyInfo = (~) Int32
    type AttrTransferType PrintUnixDialogCurrentPagePropertyInfo = Int32
    type AttrGetType PrintUnixDialogCurrentPagePropertyInfo = Int32
    type AttrLabel PrintUnixDialogCurrentPagePropertyInfo = "current-page"
    type AttrOrigin PrintUnixDialogCurrentPagePropertyInfo = PrintUnixDialog
    attrGet = getPrintUnixDialogCurrentPage
    attrSet = setPrintUnixDialogCurrentPage
    attrTransfer _ v = do
        return v
    attrConstruct = constructPrintUnixDialogCurrentPage
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.currentPage"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#g:attr:currentPage"
        })
#endif

-- VVV Prop "embed-page-setup"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@embed-page-setup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printUnixDialog #embedPageSetup
-- @
getPrintUnixDialogEmbedPageSetup :: (MonadIO m, IsPrintUnixDialog o) => o -> m Bool
getPrintUnixDialogEmbedPageSetup obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "embed-page-setup"

-- | Set the value of the “@embed-page-setup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' printUnixDialog [ #embedPageSetup 'Data.GI.Base.Attributes.:=' value ]
-- @
setPrintUnixDialogEmbedPageSetup :: (MonadIO m, IsPrintUnixDialog o) => o -> Bool -> m ()
setPrintUnixDialogEmbedPageSetup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "embed-page-setup" val

-- | Construct a `GValueConstruct` with valid value for the “@embed-page-setup@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintUnixDialogEmbedPageSetup :: (IsPrintUnixDialog o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPrintUnixDialogEmbedPageSetup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "embed-page-setup" val

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogEmbedPageSetupPropertyInfo
instance AttrInfo PrintUnixDialogEmbedPageSetupPropertyInfo where
    type AttrAllowedOps PrintUnixDialogEmbedPageSetupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PrintUnixDialogEmbedPageSetupPropertyInfo = IsPrintUnixDialog
    type AttrSetTypeConstraint PrintUnixDialogEmbedPageSetupPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PrintUnixDialogEmbedPageSetupPropertyInfo = (~) Bool
    type AttrTransferType PrintUnixDialogEmbedPageSetupPropertyInfo = Bool
    type AttrGetType PrintUnixDialogEmbedPageSetupPropertyInfo = Bool
    type AttrLabel PrintUnixDialogEmbedPageSetupPropertyInfo = "embed-page-setup"
    type AttrOrigin PrintUnixDialogEmbedPageSetupPropertyInfo = PrintUnixDialog
    attrGet = getPrintUnixDialogEmbedPageSetup
    attrSet = setPrintUnixDialogEmbedPageSetup
    attrTransfer _ v = do
        return v
    attrConstruct = constructPrintUnixDialogEmbedPageSetup
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.embedPageSetup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#g:attr:embedPageSetup"
        })
#endif

-- VVV Prop "has-selection"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@has-selection@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printUnixDialog #hasSelection
-- @
getPrintUnixDialogHasSelection :: (MonadIO m, IsPrintUnixDialog o) => o -> m Bool
getPrintUnixDialogHasSelection obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-selection"

-- | Set the value of the “@has-selection@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' printUnixDialog [ #hasSelection 'Data.GI.Base.Attributes.:=' value ]
-- @
setPrintUnixDialogHasSelection :: (MonadIO m, IsPrintUnixDialog o) => o -> Bool -> m ()
setPrintUnixDialogHasSelection obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "has-selection" val

-- | Construct a `GValueConstruct` with valid value for the “@has-selection@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintUnixDialogHasSelection :: (IsPrintUnixDialog o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPrintUnixDialogHasSelection val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-selection" val

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogHasSelectionPropertyInfo
instance AttrInfo PrintUnixDialogHasSelectionPropertyInfo where
    type AttrAllowedOps PrintUnixDialogHasSelectionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PrintUnixDialogHasSelectionPropertyInfo = IsPrintUnixDialog
    type AttrSetTypeConstraint PrintUnixDialogHasSelectionPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PrintUnixDialogHasSelectionPropertyInfo = (~) Bool
    type AttrTransferType PrintUnixDialogHasSelectionPropertyInfo = Bool
    type AttrGetType PrintUnixDialogHasSelectionPropertyInfo = Bool
    type AttrLabel PrintUnixDialogHasSelectionPropertyInfo = "has-selection"
    type AttrOrigin PrintUnixDialogHasSelectionPropertyInfo = PrintUnixDialog
    attrGet = getPrintUnixDialogHasSelection
    attrSet = setPrintUnixDialogHasSelection
    attrTransfer _ v = do
        return v
    attrConstruct = constructPrintUnixDialogHasSelection
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.hasSelection"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#g:attr:hasSelection"
        })
#endif

-- VVV Prop "manual-capabilities"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PrintCapabilities"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@manual-capabilities@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printUnixDialog #manualCapabilities
-- @
getPrintUnixDialogManualCapabilities :: (MonadIO m, IsPrintUnixDialog o) => o -> m [Gtk.Flags.PrintCapabilities]
getPrintUnixDialogManualCapabilities obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "manual-capabilities"

-- | Set the value of the “@manual-capabilities@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' printUnixDialog [ #manualCapabilities 'Data.GI.Base.Attributes.:=' value ]
-- @
setPrintUnixDialogManualCapabilities :: (MonadIO m, IsPrintUnixDialog o) => o -> [Gtk.Flags.PrintCapabilities] -> m ()
setPrintUnixDialogManualCapabilities obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "manual-capabilities" val

-- | Construct a `GValueConstruct` with valid value for the “@manual-capabilities@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintUnixDialogManualCapabilities :: (IsPrintUnixDialog o, MIO.MonadIO m) => [Gtk.Flags.PrintCapabilities] -> m (GValueConstruct o)
constructPrintUnixDialogManualCapabilities val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "manual-capabilities" val

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogManualCapabilitiesPropertyInfo
instance AttrInfo PrintUnixDialogManualCapabilitiesPropertyInfo where
    type AttrAllowedOps PrintUnixDialogManualCapabilitiesPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PrintUnixDialogManualCapabilitiesPropertyInfo = IsPrintUnixDialog
    type AttrSetTypeConstraint PrintUnixDialogManualCapabilitiesPropertyInfo = (~) [Gtk.Flags.PrintCapabilities]
    type AttrTransferTypeConstraint PrintUnixDialogManualCapabilitiesPropertyInfo = (~) [Gtk.Flags.PrintCapabilities]
    type AttrTransferType PrintUnixDialogManualCapabilitiesPropertyInfo = [Gtk.Flags.PrintCapabilities]
    type AttrGetType PrintUnixDialogManualCapabilitiesPropertyInfo = [Gtk.Flags.PrintCapabilities]
    type AttrLabel PrintUnixDialogManualCapabilitiesPropertyInfo = "manual-capabilities"
    type AttrOrigin PrintUnixDialogManualCapabilitiesPropertyInfo = PrintUnixDialog
    attrGet = getPrintUnixDialogManualCapabilities
    attrSet = setPrintUnixDialogManualCapabilities
    attrTransfer _ v = do
        return v
    attrConstruct = constructPrintUnixDialogManualCapabilities
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.manualCapabilities"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#g:attr:manualCapabilities"
        })
#endif

-- VVV Prop "page-setup"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PageSetup"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@page-setup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printUnixDialog #pageSetup
-- @
getPrintUnixDialogPageSetup :: (MonadIO m, IsPrintUnixDialog o) => o -> m Gtk.PageSetup.PageSetup
getPrintUnixDialogPageSetup obj = MIO.liftIO $ checkUnexpectedNothing "getPrintUnixDialogPageSetup" $ B.Properties.getObjectPropertyObject obj "page-setup" Gtk.PageSetup.PageSetup

-- | Set the value of the “@page-setup@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' printUnixDialog [ #pageSetup 'Data.GI.Base.Attributes.:=' value ]
-- @
setPrintUnixDialogPageSetup :: (MonadIO m, IsPrintUnixDialog o, Gtk.PageSetup.IsPageSetup a) => o -> a -> m ()
setPrintUnixDialogPageSetup obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "page-setup" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@page-setup@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintUnixDialogPageSetup :: (IsPrintUnixDialog o, MIO.MonadIO m, Gtk.PageSetup.IsPageSetup a) => a -> m (GValueConstruct o)
constructPrintUnixDialogPageSetup val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "page-setup" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogPageSetupPropertyInfo
instance AttrInfo PrintUnixDialogPageSetupPropertyInfo where
    type AttrAllowedOps PrintUnixDialogPageSetupPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PrintUnixDialogPageSetupPropertyInfo = IsPrintUnixDialog
    type AttrSetTypeConstraint PrintUnixDialogPageSetupPropertyInfo = Gtk.PageSetup.IsPageSetup
    type AttrTransferTypeConstraint PrintUnixDialogPageSetupPropertyInfo = Gtk.PageSetup.IsPageSetup
    type AttrTransferType PrintUnixDialogPageSetupPropertyInfo = Gtk.PageSetup.PageSetup
    type AttrGetType PrintUnixDialogPageSetupPropertyInfo = Gtk.PageSetup.PageSetup
    type AttrLabel PrintUnixDialogPageSetupPropertyInfo = "page-setup"
    type AttrOrigin PrintUnixDialogPageSetupPropertyInfo = PrintUnixDialog
    attrGet = getPrintUnixDialogPageSetup
    attrSet = setPrintUnixDialogPageSetup
    attrTransfer _ v = do
        unsafeCastTo Gtk.PageSetup.PageSetup v
    attrConstruct = constructPrintUnixDialogPageSetup
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.pageSetup"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#g:attr:pageSetup"
        })
#endif

-- VVV Prop "print-settings"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PrintSettings"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@print-settings@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printUnixDialog #printSettings
-- @
getPrintUnixDialogPrintSettings :: (MonadIO m, IsPrintUnixDialog o) => o -> m (Maybe Gtk.PrintSettings.PrintSettings)
getPrintUnixDialogPrintSettings obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "print-settings" Gtk.PrintSettings.PrintSettings

-- | Set the value of the “@print-settings@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' printUnixDialog [ #printSettings 'Data.GI.Base.Attributes.:=' value ]
-- @
setPrintUnixDialogPrintSettings :: (MonadIO m, IsPrintUnixDialog o, Gtk.PrintSettings.IsPrintSettings a) => o -> a -> m ()
setPrintUnixDialogPrintSettings obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "print-settings" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@print-settings@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintUnixDialogPrintSettings :: (IsPrintUnixDialog o, MIO.MonadIO m, Gtk.PrintSettings.IsPrintSettings a) => a -> m (GValueConstruct o)
constructPrintUnixDialogPrintSettings val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "print-settings" (P.Just val)

-- | Set the value of the “@print-settings@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #printSettings
-- @
clearPrintUnixDialogPrintSettings :: (MonadIO m, IsPrintUnixDialog o) => o -> m ()
clearPrintUnixDialogPrintSettings obj = liftIO $ B.Properties.setObjectPropertyObject obj "print-settings" (Nothing :: Maybe Gtk.PrintSettings.PrintSettings)

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogPrintSettingsPropertyInfo
instance AttrInfo PrintUnixDialogPrintSettingsPropertyInfo where
    type AttrAllowedOps PrintUnixDialogPrintSettingsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PrintUnixDialogPrintSettingsPropertyInfo = IsPrintUnixDialog
    type AttrSetTypeConstraint PrintUnixDialogPrintSettingsPropertyInfo = Gtk.PrintSettings.IsPrintSettings
    type AttrTransferTypeConstraint PrintUnixDialogPrintSettingsPropertyInfo = Gtk.PrintSettings.IsPrintSettings
    type AttrTransferType PrintUnixDialogPrintSettingsPropertyInfo = Gtk.PrintSettings.PrintSettings
    type AttrGetType PrintUnixDialogPrintSettingsPropertyInfo = (Maybe Gtk.PrintSettings.PrintSettings)
    type AttrLabel PrintUnixDialogPrintSettingsPropertyInfo = "print-settings"
    type AttrOrigin PrintUnixDialogPrintSettingsPropertyInfo = PrintUnixDialog
    attrGet = getPrintUnixDialogPrintSettings
    attrSet = setPrintUnixDialogPrintSettings
    attrTransfer _ v = do
        unsafeCastTo Gtk.PrintSettings.PrintSettings v
    attrConstruct = constructPrintUnixDialogPrintSettings
    attrClear = clearPrintUnixDialogPrintSettings
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printSettings"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#g:attr:printSettings"
        })
#endif

-- VVV Prop "selected-printer"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Printer"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@selected-printer@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printUnixDialog #selectedPrinter
-- @
getPrintUnixDialogSelectedPrinter :: (MonadIO m, IsPrintUnixDialog o) => o -> m (Maybe Gtk.Printer.Printer)
getPrintUnixDialogSelectedPrinter obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "selected-printer" Gtk.Printer.Printer

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogSelectedPrinterPropertyInfo
instance AttrInfo PrintUnixDialogSelectedPrinterPropertyInfo where
    type AttrAllowedOps PrintUnixDialogSelectedPrinterPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PrintUnixDialogSelectedPrinterPropertyInfo = IsPrintUnixDialog
    type AttrSetTypeConstraint PrintUnixDialogSelectedPrinterPropertyInfo = (~) ()
    type AttrTransferTypeConstraint PrintUnixDialogSelectedPrinterPropertyInfo = (~) ()
    type AttrTransferType PrintUnixDialogSelectedPrinterPropertyInfo = ()
    type AttrGetType PrintUnixDialogSelectedPrinterPropertyInfo = (Maybe Gtk.Printer.Printer)
    type AttrLabel PrintUnixDialogSelectedPrinterPropertyInfo = "selected-printer"
    type AttrOrigin PrintUnixDialogSelectedPrinterPropertyInfo = PrintUnixDialog
    attrGet = getPrintUnixDialogSelectedPrinter
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.selectedPrinter"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#g:attr:selectedPrinter"
        })
#endif

-- VVV Prop "support-selection"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@support-selection@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' printUnixDialog #supportSelection
-- @
getPrintUnixDialogSupportSelection :: (MonadIO m, IsPrintUnixDialog o) => o -> m Bool
getPrintUnixDialogSupportSelection obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "support-selection"

-- | Set the value of the “@support-selection@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' printUnixDialog [ #supportSelection 'Data.GI.Base.Attributes.:=' value ]
-- @
setPrintUnixDialogSupportSelection :: (MonadIO m, IsPrintUnixDialog o) => o -> Bool -> m ()
setPrintUnixDialogSupportSelection obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "support-selection" val

-- | Construct a `GValueConstruct` with valid value for the “@support-selection@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPrintUnixDialogSupportSelection :: (IsPrintUnixDialog o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPrintUnixDialogSupportSelection val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "support-selection" val

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogSupportSelectionPropertyInfo
instance AttrInfo PrintUnixDialogSupportSelectionPropertyInfo where
    type AttrAllowedOps PrintUnixDialogSupportSelectionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PrintUnixDialogSupportSelectionPropertyInfo = IsPrintUnixDialog
    type AttrSetTypeConstraint PrintUnixDialogSupportSelectionPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PrintUnixDialogSupportSelectionPropertyInfo = (~) Bool
    type AttrTransferType PrintUnixDialogSupportSelectionPropertyInfo = Bool
    type AttrGetType PrintUnixDialogSupportSelectionPropertyInfo = Bool
    type AttrLabel PrintUnixDialogSupportSelectionPropertyInfo = "support-selection"
    type AttrOrigin PrintUnixDialogSupportSelectionPropertyInfo = PrintUnixDialog
    attrGet = getPrintUnixDialogSupportSelection
    attrSet = setPrintUnixDialogSupportSelection
    attrTransfer _ v = do
        return v
    attrConstruct = constructPrintUnixDialogSupportSelection
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.supportSelection"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#g:attr:supportSelection"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PrintUnixDialog
type instance O.AttributeList PrintUnixDialog = PrintUnixDialogAttributeList
type PrintUnixDialogAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("application", Gtk.Window.WindowApplicationPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", Gtk.Window.WindowChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("currentPage", PrintUnixDialogCurrentPagePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("decorated", Gtk.Window.WindowDecoratedPropertyInfo), '("defaultHeight", Gtk.Window.WindowDefaultHeightPropertyInfo), '("defaultWidget", Gtk.Window.WindowDefaultWidgetPropertyInfo), '("defaultWidth", Gtk.Window.WindowDefaultWidthPropertyInfo), '("deletable", Gtk.Window.WindowDeletablePropertyInfo), '("destroyWithParent", Gtk.Window.WindowDestroyWithParentPropertyInfo), '("display", Gtk.Window.WindowDisplayPropertyInfo), '("embedPageSetup", PrintUnixDialogEmbedPageSetupPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusVisible", Gtk.Window.WindowFocusVisiblePropertyInfo), '("focusWidget", Gtk.Window.WindowFocusWidgetPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("fullscreened", Gtk.Window.WindowFullscreenedPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("handleMenubarAccel", Gtk.Window.WindowHandleMenubarAccelPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasSelection", PrintUnixDialogHasSelectionPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hideOnClose", Gtk.Window.WindowHideOnClosePropertyInfo), '("iconName", Gtk.Window.WindowIconNamePropertyInfo), '("isActive", Gtk.Window.WindowIsActivePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("manualCapabilities", PrintUnixDialogManualCapabilitiesPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maximized", Gtk.Window.WindowMaximizedPropertyInfo), '("mnemonicsVisible", Gtk.Window.WindowMnemonicsVisiblePropertyInfo), '("modal", Gtk.Window.WindowModalPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("pageSetup", PrintUnixDialogPageSetupPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("printSettings", PrintUnixDialogPrintSettingsPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("resizable", Gtk.Window.WindowResizablePropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("selectedPrinter", PrintUnixDialogSelectedPrinterPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("startupId", Gtk.Window.WindowStartupIdPropertyInfo), '("supportSelection", PrintUnixDialogSupportSelectionPropertyInfo), '("suspended", Gtk.Window.WindowSuspendedPropertyInfo), '("title", Gtk.Window.WindowTitlePropertyInfo), '("titlebar", Gtk.Window.WindowTitlebarPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("transientFor", Gtk.Window.WindowTransientForPropertyInfo), '("useHeaderBar", Gtk.Dialog.DialogUseHeaderBarPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
printUnixDialogCurrentPage :: AttrLabelProxy "currentPage"
printUnixDialogCurrentPage = AttrLabelProxy

printUnixDialogEmbedPageSetup :: AttrLabelProxy "embedPageSetup"
printUnixDialogEmbedPageSetup = AttrLabelProxy

printUnixDialogHasSelection :: AttrLabelProxy "hasSelection"
printUnixDialogHasSelection = AttrLabelProxy

printUnixDialogManualCapabilities :: AttrLabelProxy "manualCapabilities"
printUnixDialogManualCapabilities = AttrLabelProxy

printUnixDialogPageSetup :: AttrLabelProxy "pageSetup"
printUnixDialogPageSetup = AttrLabelProxy

printUnixDialogPrintSettings :: AttrLabelProxy "printSettings"
printUnixDialogPrintSettings = AttrLabelProxy

printUnixDialogSelectedPrinter :: AttrLabelProxy "selectedPrinter"
printUnixDialogSelectedPrinter = AttrLabelProxy

printUnixDialogSupportSelection :: AttrLabelProxy "supportSelection"
printUnixDialogSupportSelection = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PrintUnixDialog = PrintUnixDialogSignalList
type PrintUnixDialogSignalList = ('[ '("activateDefault", Gtk.Window.WindowActivateDefaultSignalInfo), '("activateFocus", Gtk.Window.WindowActivateFocusSignalInfo), '("close", Gtk.Dialog.DialogCloseSignalInfo), '("closeRequest", Gtk.Window.WindowCloseRequestSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("enableDebugging", Gtk.Window.WindowEnableDebuggingSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("keysChanged", Gtk.Window.WindowKeysChangedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("response", Gtk.Dialog.DialogResponseSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method PrintUnixDialog::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "title"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Title of the dialog"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "parent"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Window" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "Transient parent of the dialog"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_new" gtk_print_unix_dialog_new :: 
    CString ->                              -- title : TBasicType TUTF8
    Ptr Gtk.Window.Window ->                -- parent : TInterface (Name {namespace = "Gtk", name = "Window"})
    IO (Ptr PrintUnixDialog)

-- | Creates a new @GtkPrintUnixDialog@.
printUnixDialogNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gtk.Window.IsWindow a) =>
    Maybe (T.Text)
    -- ^ /@title@/: Title of the dialog
    -> Maybe (a)
    -- ^ /@parent@/: Transient parent of the dialog
    -> m PrintUnixDialog
    -- ^ __Returns:__ a new @GtkPrintUnixDialog@
printUnixDialogNew title parent = liftIO $ do
    maybeTitle <- case title of
        Nothing -> return FP.nullPtr
        Just jTitle -> do
            jTitle' <- textToCString jTitle
            return jTitle'
    maybeParent <- case parent of
        Nothing -> return FP.nullPtr
        Just jParent -> do
            jParent' <- unsafeManagedPtrCastPtr jParent
            return jParent'
    result <- gtk_print_unix_dialog_new maybeTitle maybeParent
    checkUnexpectedReturnNULL "printUnixDialogNew" result
    result' <- (newObject PrintUnixDialog) result
    whenJust parent touchManagedPtr
    freeMem maybeTitle
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method PrintUnixDialog::add_custom_tab
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to put in the custom tab"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "tab_label"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the widget to use as tab label"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_add_custom_tab" gtk_print_unix_dialog_add_custom_tab :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    Ptr Gtk.Widget.Widget ->                -- tab_label : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Adds a custom tab to the print dialog.
printUnixDialogAddCustomTab ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> b
    -- ^ /@child@/: the widget to put in the custom tab
    -> c
    -- ^ /@tabLabel@/: the widget to use as tab label
    -> m ()
printUnixDialogAddCustomTab dialog child tabLabel = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    child' <- unsafeManagedPtrCastPtr child
    tabLabel' <- unsafeManagedPtrCastPtr tabLabel
    gtk_print_unix_dialog_add_custom_tab dialog' child' tabLabel'
    touchManagedPtr dialog
    touchManagedPtr child
    touchManagedPtr tabLabel
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogAddCustomTabMethodInfo
instance (signature ~ (b -> c -> m ()), MonadIO m, IsPrintUnixDialog a, Gtk.Widget.IsWidget b, Gtk.Widget.IsWidget c) => O.OverloadedMethod PrintUnixDialogAddCustomTabMethodInfo a signature where
    overloadedMethod = printUnixDialogAddCustomTab

instance O.OverloadedMethodInfo PrintUnixDialogAddCustomTabMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogAddCustomTab",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogAddCustomTab"
        })


#endif

-- method PrintUnixDialog::get_current_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_get_current_page" gtk_print_unix_dialog_get_current_page :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    IO Int32

-- | Gets the current page of the @GtkPrintUnixDialog@.
printUnixDialogGetCurrentPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> m Int32
    -- ^ __Returns:__ the current page of /@dialog@/
printUnixDialogGetCurrentPage dialog = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    result <- gtk_print_unix_dialog_get_current_page dialog'
    touchManagedPtr dialog
    return result

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogGetCurrentPageMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogGetCurrentPageMethodInfo a signature where
    overloadedMethod = printUnixDialogGetCurrentPage

instance O.OverloadedMethodInfo PrintUnixDialogGetCurrentPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogGetCurrentPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogGetCurrentPage"
        })


#endif

-- method PrintUnixDialog::get_embed_page_setup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_get_embed_page_setup" gtk_print_unix_dialog_get_embed_page_setup :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    IO CInt

-- | Gets whether to embed the page setup.
printUnixDialogGetEmbedPageSetup ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> m Bool
    -- ^ __Returns:__ whether to embed the page setup
printUnixDialogGetEmbedPageSetup dialog = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    result <- gtk_print_unix_dialog_get_embed_page_setup dialog'
    let result' = (/= 0) result
    touchManagedPtr dialog
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogGetEmbedPageSetupMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogGetEmbedPageSetupMethodInfo a signature where
    overloadedMethod = printUnixDialogGetEmbedPageSetup

instance O.OverloadedMethodInfo PrintUnixDialogGetEmbedPageSetupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogGetEmbedPageSetup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogGetEmbedPageSetup"
        })


#endif

-- method PrintUnixDialog::get_has_selection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_get_has_selection" gtk_print_unix_dialog_get_has_selection :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    IO CInt

-- | Gets whether there is a selection.
printUnixDialogGetHasSelection ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> m Bool
    -- ^ __Returns:__ whether there is a selection
printUnixDialogGetHasSelection dialog = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    result <- gtk_print_unix_dialog_get_has_selection dialog'
    let result' = (/= 0) result
    touchManagedPtr dialog
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogGetHasSelectionMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogGetHasSelectionMethodInfo a signature where
    overloadedMethod = printUnixDialogGetHasSelection

instance O.OverloadedMethodInfo PrintUnixDialogGetHasSelectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogGetHasSelection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogGetHasSelection"
        })


#endif

-- method PrintUnixDialog::get_manual_capabilities
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "PrintCapabilities" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_get_manual_capabilities" gtk_print_unix_dialog_get_manual_capabilities :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    IO CUInt

-- | Gets the capabilities that have been set on this @GtkPrintUnixDialog@.
printUnixDialogGetManualCapabilities ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> m [Gtk.Flags.PrintCapabilities]
    -- ^ __Returns:__ the printing capabilities
printUnixDialogGetManualCapabilities dialog = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    result <- gtk_print_unix_dialog_get_manual_capabilities dialog'
    let result' = wordToGFlags result
    touchManagedPtr dialog
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogGetManualCapabilitiesMethodInfo
instance (signature ~ (m [Gtk.Flags.PrintCapabilities]), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogGetManualCapabilitiesMethodInfo a signature where
    overloadedMethod = printUnixDialogGetManualCapabilities

instance O.OverloadedMethodInfo PrintUnixDialogGetManualCapabilitiesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogGetManualCapabilities",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogGetManualCapabilities"
        })


#endif

-- method PrintUnixDialog::get_page_setup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "PageSetup" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_get_page_setup" gtk_print_unix_dialog_get_page_setup :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    IO (Ptr Gtk.PageSetup.PageSetup)

-- | Gets the page setup that is used by the @GtkPrintUnixDialog@.
printUnixDialogGetPageSetup ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> m Gtk.PageSetup.PageSetup
    -- ^ __Returns:__ the page setup of /@dialog@/.
printUnixDialogGetPageSetup dialog = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    result <- gtk_print_unix_dialog_get_page_setup dialog'
    checkUnexpectedReturnNULL "printUnixDialogGetPageSetup" result
    result' <- (newObject Gtk.PageSetup.PageSetup) result
    touchManagedPtr dialog
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogGetPageSetupMethodInfo
instance (signature ~ (m Gtk.PageSetup.PageSetup), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogGetPageSetupMethodInfo a signature where
    overloadedMethod = printUnixDialogGetPageSetup

instance O.OverloadedMethodInfo PrintUnixDialogGetPageSetupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogGetPageSetup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogGetPageSetup"
        })


#endif

-- method PrintUnixDialog::get_page_setup_set
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_get_page_setup_set" gtk_print_unix_dialog_get_page_setup_set :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    IO CInt

-- | Gets whether a page setup was set by the user.
printUnixDialogGetPageSetupSet ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> m Bool
    -- ^ __Returns:__ whether a page setup was set by user.
printUnixDialogGetPageSetupSet dialog = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    result <- gtk_print_unix_dialog_get_page_setup_set dialog'
    let result' = (/= 0) result
    touchManagedPtr dialog
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogGetPageSetupSetMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogGetPageSetupSetMethodInfo a signature where
    overloadedMethod = printUnixDialogGetPageSetupSet

instance O.OverloadedMethodInfo PrintUnixDialogGetPageSetupSetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogGetPageSetupSet",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogGetPageSetupSet"
        })


#endif

-- method PrintUnixDialog::get_selected_printer
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Printer" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_get_selected_printer" gtk_print_unix_dialog_get_selected_printer :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    IO (Ptr Gtk.Printer.Printer)

-- | Gets the currently selected printer.
printUnixDialogGetSelectedPrinter ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> m (Maybe Gtk.Printer.Printer)
    -- ^ __Returns:__ the currently selected printer
printUnixDialogGetSelectedPrinter dialog = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    result <- gtk_print_unix_dialog_get_selected_printer dialog'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Printer.Printer) result'
        return result''
    touchManagedPtr dialog
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogGetSelectedPrinterMethodInfo
instance (signature ~ (m (Maybe Gtk.Printer.Printer)), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogGetSelectedPrinterMethodInfo a signature where
    overloadedMethod = printUnixDialogGetSelectedPrinter

instance O.OverloadedMethodInfo PrintUnixDialogGetSelectedPrinterMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogGetSelectedPrinter",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogGetSelectedPrinter"
        })


#endif

-- method PrintUnixDialog::get_settings
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PrintSettings" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_get_settings" gtk_print_unix_dialog_get_settings :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    IO (Ptr Gtk.PrintSettings.PrintSettings)

-- | Gets a new @GtkPrintSettings@ object that represents the
-- current values in the print dialog.
-- 
-- Note that this creates a new object, and you need to unref
-- it if don’t want to keep it.
printUnixDialogGetSettings ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> m Gtk.PrintSettings.PrintSettings
    -- ^ __Returns:__ a new @GtkPrintSettings@ object with the values from /@dialog@/
printUnixDialogGetSettings dialog = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    result <- gtk_print_unix_dialog_get_settings dialog'
    checkUnexpectedReturnNULL "printUnixDialogGetSettings" result
    result' <- (wrapObject Gtk.PrintSettings.PrintSettings) result
    touchManagedPtr dialog
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogGetSettingsMethodInfo
instance (signature ~ (m Gtk.PrintSettings.PrintSettings), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogGetSettingsMethodInfo a signature where
    overloadedMethod = printUnixDialogGetSettings

instance O.OverloadedMethodInfo PrintUnixDialogGetSettingsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogGetSettings",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogGetSettings"
        })


#endif

-- method PrintUnixDialog::get_support_selection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_get_support_selection" gtk_print_unix_dialog_get_support_selection :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    IO CInt

-- | Gets whether the print dialog allows user to print a selection.
printUnixDialogGetSupportSelection ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> m Bool
    -- ^ __Returns:__ whether the application supports print of selection
printUnixDialogGetSupportSelection dialog = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    result <- gtk_print_unix_dialog_get_support_selection dialog'
    let result' = (/= 0) result
    touchManagedPtr dialog
    return result'

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogGetSupportSelectionMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogGetSupportSelectionMethodInfo a signature where
    overloadedMethod = printUnixDialogGetSupportSelection

instance O.OverloadedMethodInfo PrintUnixDialogGetSupportSelectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogGetSupportSelection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogGetSupportSelection"
        })


#endif

-- method PrintUnixDialog::set_current_page
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "current_page"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the current page number."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_set_current_page" gtk_print_unix_dialog_set_current_page :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    Int32 ->                                -- current_page : TBasicType TInt
    IO ()

-- | Sets the current page number.
-- 
-- If /@currentPage@/ is not -1, this enables the current page choice
-- for the range of pages to print.
printUnixDialogSetCurrentPage ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> Int32
    -- ^ /@currentPage@/: the current page number.
    -> m ()
printUnixDialogSetCurrentPage dialog currentPage = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    gtk_print_unix_dialog_set_current_page dialog' currentPage
    touchManagedPtr dialog
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogSetCurrentPageMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogSetCurrentPageMethodInfo a signature where
    overloadedMethod = printUnixDialogSetCurrentPage

instance O.OverloadedMethodInfo PrintUnixDialogSetCurrentPageMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogSetCurrentPage",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogSetCurrentPage"
        })


#endif

-- method PrintUnixDialog::set_embed_page_setup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "embed"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "embed page setup selection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_set_embed_page_setup" gtk_print_unix_dialog_set_embed_page_setup :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    CInt ->                                 -- embed : TBasicType TBoolean
    IO ()

-- | Embed page size combo box and orientation combo box into page setup page.
printUnixDialogSetEmbedPageSetup ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> Bool
    -- ^ /@embed@/: embed page setup selection
    -> m ()
printUnixDialogSetEmbedPageSetup dialog embed = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    let embed' = (P.fromIntegral . P.fromEnum) embed
    gtk_print_unix_dialog_set_embed_page_setup dialog' embed'
    touchManagedPtr dialog
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogSetEmbedPageSetupMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogSetEmbedPageSetupMethodInfo a signature where
    overloadedMethod = printUnixDialogSetEmbedPageSetup

instance O.OverloadedMethodInfo PrintUnixDialogSetEmbedPageSetupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogSetEmbedPageSetup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogSetEmbedPageSetup"
        })


#endif

-- method PrintUnixDialog::set_has_selection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "has_selection"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE indicates that a selection exists"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_set_has_selection" gtk_print_unix_dialog_set_has_selection :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    CInt ->                                 -- has_selection : TBasicType TBoolean
    IO ()

-- | Sets whether a selection exists.
printUnixDialogSetHasSelection ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> Bool
    -- ^ /@hasSelection@/: 'P.True' indicates that a selection exists
    -> m ()
printUnixDialogSetHasSelection dialog hasSelection = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    let hasSelection' = (P.fromIntegral . P.fromEnum) hasSelection
    gtk_print_unix_dialog_set_has_selection dialog' hasSelection'
    touchManagedPtr dialog
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogSetHasSelectionMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogSetHasSelectionMethodInfo a signature where
    overloadedMethod = printUnixDialogSetHasSelection

instance O.OverloadedMethodInfo PrintUnixDialogSetHasSelectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogSetHasSelection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogSetHasSelection"
        })


#endif

-- method PrintUnixDialog::set_manual_capabilities
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "capabilities"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintCapabilities" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the printing capabilities of your application"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_set_manual_capabilities" gtk_print_unix_dialog_set_manual_capabilities :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    CUInt ->                                -- capabilities : TInterface (Name {namespace = "Gtk", name = "PrintCapabilities"})
    IO ()

-- | This lets you specify the printing capabilities your application
-- supports.
-- 
-- For instance, if you can handle scaling the output then you pass
-- 'GI.Gtk.Flags.PrintCapabilitiesScale'. If you don’t pass that, then the dialog
-- will only let you select the scale if the printing system automatically
-- handles scaling.
printUnixDialogSetManualCapabilities ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> [Gtk.Flags.PrintCapabilities]
    -- ^ /@capabilities@/: the printing capabilities of your application
    -> m ()
printUnixDialogSetManualCapabilities dialog capabilities = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    let capabilities' = gflagsToWord capabilities
    gtk_print_unix_dialog_set_manual_capabilities dialog' capabilities'
    touchManagedPtr dialog
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogSetManualCapabilitiesMethodInfo
instance (signature ~ ([Gtk.Flags.PrintCapabilities] -> m ()), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogSetManualCapabilitiesMethodInfo a signature where
    overloadedMethod = printUnixDialogSetManualCapabilities

instance O.OverloadedMethodInfo PrintUnixDialogSetManualCapabilitiesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogSetManualCapabilities",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogSetManualCapabilities"
        })


#endif

-- method PrintUnixDialog::set_page_setup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "page_setup"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PageSetup" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPageSetup`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_set_page_setup" gtk_print_unix_dialog_set_page_setup :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    Ptr Gtk.PageSetup.PageSetup ->          -- page_setup : TInterface (Name {namespace = "Gtk", name = "PageSetup"})
    IO ()

-- | Sets the page setup of the @GtkPrintUnixDialog@.
printUnixDialogSetPageSetup ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a, Gtk.PageSetup.IsPageSetup b) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> b
    -- ^ /@pageSetup@/: a @GtkPageSetup@
    -> m ()
printUnixDialogSetPageSetup dialog pageSetup = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    pageSetup' <- unsafeManagedPtrCastPtr pageSetup
    gtk_print_unix_dialog_set_page_setup dialog' pageSetup'
    touchManagedPtr dialog
    touchManagedPtr pageSetup
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogSetPageSetupMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsPrintUnixDialog a, Gtk.PageSetup.IsPageSetup b) => O.OverloadedMethod PrintUnixDialogSetPageSetupMethodInfo a signature where
    overloadedMethod = printUnixDialogSetPageSetup

instance O.OverloadedMethodInfo PrintUnixDialogSetPageSetupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogSetPageSetup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogSetPageSetup"
        })


#endif

-- method PrintUnixDialog::set_settings
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "settings"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintSettings" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintSettings`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_set_settings" gtk_print_unix_dialog_set_settings :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    Ptr Gtk.PrintSettings.PrintSettings ->  -- settings : TInterface (Name {namespace = "Gtk", name = "PrintSettings"})
    IO ()

-- | Sets the @GtkPrintSettings@ for the @GtkPrintUnixDialog@.
-- 
-- Typically, this is used to restore saved print settings
-- from a previous print operation before the print dialog
-- is shown.
printUnixDialogSetSettings ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a, Gtk.PrintSettings.IsPrintSettings b) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> Maybe (b)
    -- ^ /@settings@/: a @GtkPrintSettings@
    -> m ()
printUnixDialogSetSettings dialog settings = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    maybeSettings <- case settings of
        Nothing -> return FP.nullPtr
        Just jSettings -> do
            jSettings' <- unsafeManagedPtrCastPtr jSettings
            return jSettings'
    gtk_print_unix_dialog_set_settings dialog' maybeSettings
    touchManagedPtr dialog
    whenJust settings touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogSetSettingsMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsPrintUnixDialog a, Gtk.PrintSettings.IsPrintSettings b) => O.OverloadedMethod PrintUnixDialogSetSettingsMethodInfo a signature where
    overloadedMethod = printUnixDialogSetSettings

instance O.OverloadedMethodInfo PrintUnixDialogSetSettingsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogSetSettings",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogSetSettings"
        })


#endif

-- method PrintUnixDialog::set_support_selection
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "dialog"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PrintUnixDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPrintUnixDialog`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "support_selection"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to allow print selection"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_print_unix_dialog_set_support_selection" gtk_print_unix_dialog_set_support_selection :: 
    Ptr PrintUnixDialog ->                  -- dialog : TInterface (Name {namespace = "Gtk", name = "PrintUnixDialog"})
    CInt ->                                 -- support_selection : TBasicType TBoolean
    IO ()

-- | Sets whether the print dialog allows user to print a selection.
printUnixDialogSetSupportSelection ::
    (B.CallStack.HasCallStack, MonadIO m, IsPrintUnixDialog a) =>
    a
    -- ^ /@dialog@/: a @GtkPrintUnixDialog@
    -> Bool
    -- ^ /@supportSelection@/: 'P.True' to allow print selection
    -> m ()
printUnixDialogSetSupportSelection dialog supportSelection = liftIO $ do
    dialog' <- unsafeManagedPtrCastPtr dialog
    let supportSelection' = (P.fromIntegral . P.fromEnum) supportSelection
    gtk_print_unix_dialog_set_support_selection dialog' supportSelection'
    touchManagedPtr dialog
    return ()

#if defined(ENABLE_OVERLOADING)
data PrintUnixDialogSetSupportSelectionMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPrintUnixDialog a) => O.OverloadedMethod PrintUnixDialogSetSupportSelectionMethodInfo a signature where
    overloadedMethod = printUnixDialogSetSupportSelection

instance O.OverloadedMethodInfo PrintUnixDialogSetSupportSelectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PrintUnixDialog.printUnixDialogSetSupportSelection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PrintUnixDialog.html#v:printUnixDialogSetSupportSelection"
        })


#endif


