{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A subclass of @GtkPopover@ that implements menu behavior.
-- 
-- \<picture>
--   \<source srcset=\"menu-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkPopoverMenu\" src=\"menu.png\">
-- \<\/picture>
-- 
-- @GtkPopoverMenu@ treats its children like menus and allows switching
-- between them. It can open submenus as traditional, nested submenus,
-- or in a more touch-friendly sliding fashion.
-- The property [PopoverMenu:flags]("GI.Gtk.Objects.PopoverMenu#g:attr:flags") controls this appearance.
-- 
-- @GtkPopoverMenu@ is meant to be used primarily with menu models,
-- using 'GI.Gtk.Objects.PopoverMenu.popoverMenuNewFromModel'. If you need to put
-- other widgets such as a @GtkSpinButton@ or a @GtkSwitch@ into a popover,
-- you can use 'GI.Gtk.Objects.PopoverMenu.popoverMenuAddChild'.
-- 
-- For more dialog-like behavior, use a plain @GtkPopover@.
-- 
-- == Menu models
-- 
-- The XML format understood by @GtkBuilder@ for @GMenuModel@ consists
-- of a toplevel @\<menu>@ element, which contains one or more @\<item>@
-- elements. Each @\<item>@ element contains @\<attribute>@ and @\<link>@
-- elements with a mandatory name attribute. @\<link>@ elements have the
-- same content model as @\<menu>@. Instead of @\<link name=\"submenu\">@
-- or @\<link name=\"section\">@, you can use @\<submenu>@ or @\<section>@
-- elements.
-- 
-- 
-- === /xml code/
-- ><menu id='app-menu'>
-- >  <section>
-- >    <item>
-- >      <attribute name='label' translatable='yes'>_New Window</attribute>
-- >      <attribute name='action'>app.new</attribute>
-- >    </item>
-- >    <item>
-- >      <attribute name='label' translatable='yes'>_About Sunny</attribute>
-- >      <attribute name='action'>app.about</attribute>
-- >    </item>
-- >    <item>
-- >      <attribute name='label' translatable='yes'>_Quit</attribute>
-- >      <attribute name='action'>app.quit</attribute>
-- >    </item>
-- >  </section>
-- ></menu>
-- 
-- 
-- Attribute values can be translated using gettext, like other @GtkBuilder@
-- content. @\<attribute>@ elements can be marked for translation with a
-- @translatable=\"yes\"@ attribute. It is also possible to specify message
-- context and translator comments, using the context and comments attributes.
-- To make use of this, the @GtkBuilder@ must have been given the gettext
-- domain to use.
-- 
-- The following attributes are used when constructing menu items:
-- 
-- * \"label\": a user-visible string to display
-- * \"use-markup\": whether the text in the menu item includes <https://docs.gtk.org/Pango/pango_markup.html Pango markup>
-- * \"action\": the prefixed name of the action to trigger
-- * \"target\": the parameter to use when activating the action
-- * \"icon\" and \"verb-icon\": names of icons that may be displayed
-- * \"submenu-action\": name of an action that may be used to track
--    whether a submenu is open
-- * \"hidden-when\": a string used to determine when the item will be hidden.
--    Possible values include \"action-disabled\", \"action-missing\", \"macos-menubar\".
--    This is mainly useful for exported menus, see 'GI.Gtk.Objects.Application.applicationSetMenubar'.
-- * \"custom\": a string used to match against the ID of a custom child added with
--    'GI.Gtk.Objects.PopoverMenu.popoverMenuAddChild', 'GI.Gtk.Objects.PopoverMenuBar.popoverMenuBarAddChild',
--    or in the ui file with @\<child type=\"ID\">@.
-- 
-- 
-- The following attributes are used when constructing sections:
-- 
-- * \"label\": a user-visible string to use as section heading
-- * \"display-hint\": a string used to determine special formatting for the section.
--   Possible values include \"horizontal-buttons\", \"circular-buttons\" and
--   \"inline-buttons\". They all indicate that section should be
--   displayed as a horizontal row of buttons.
-- * \"text-direction\": a string used to determine the @GtkTextDirection@ to use
--   when \"display-hint\" is set to \"horizontal-buttons\". Possible values
--   include \"rtl\", \"ltr\", and \"none\".
-- 
-- 
-- The following attributes are used when constructing submenus:
-- 
-- * \"label\": a user-visible string to display
-- * \"icon\": icon name to display
-- 
-- 
-- Menu items will also show accelerators, which are usually associated
-- with actions via 'GI.Gtk.Objects.Application.applicationSetAccelsForAction',
-- [method/@widgetClass@/.add_binding_action] or
-- 'GI.Gtk.Objects.ShortcutController.shortcutControllerAddShortcut'.
-- 
-- = Shortcuts and Gestures
-- 
-- @GtkPopoverMenu@ supports the following keyboard shortcuts:
-- 
-- * \<kbd>Space\<\/kbd> activates the default widget.
-- 
-- 
-- = CSS Nodes
-- 
-- @GtkPopoverMenu@ is just a subclass of @GtkPopover@ that adds custom content
-- to it, therefore it has the same CSS nodes. It is one of the cases that add
-- a @.menu@ style class to the main @popover@ node.
-- 
-- Menu items have nodes with name @button@ and class @.model@. If a section
-- display-hint is set, the section gets a node @box@ with class @horizontal@
-- plus a class with the same text as the display hint. Note that said box may
-- not be the direct ancestor of the item @button@s. Thus, for example, to style
-- items in an @inline-buttons@ section, select @.inline-buttons button.model@.
-- Other things that may be of interest to style in menus include @label@ nodes.
-- 
-- = Accessibility
-- 
-- @GtkPopoverMenu@ uses the [enum/@gtk@/.AccessibleRole.menu] role, and its
-- items use the [enum/@gtk@/.AccessibleRole.menu_item],
-- [enum/@gtk@/.AccessibleRole.checkbox] or [enum/@gtk@/.AccessibleRole.menu_item_radio]
-- roles, depending on the action they are connected to.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.PopoverMenu
    ( 

-- * Exported types
    PopoverMenu(..)                         ,
    IsPopoverMenu                           ,
    toPopoverMenu                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addChild]("GI.Gtk.Objects.PopoverMenu#g:method:addChild"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [popdown]("GI.Gtk.Objects.Popover#g:method:popdown"), [popup]("GI.Gtk.Objects.Popover#g:method:popup"), [present]("GI.Gtk.Objects.Popover#g:method:present"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeChild]("GI.Gtk.Objects.PopoverMenu#g:method:removeChild"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getAutohide]("GI.Gtk.Objects.Popover#g:method:getAutohide"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getCascadePopdown]("GI.Gtk.Objects.Popover#g:method:getCascadePopdown"), [getChild]("GI.Gtk.Objects.Popover#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFlags]("GI.Gtk.Objects.PopoverMenu#g:method:getFlags"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasArrow]("GI.Gtk.Objects.Popover#g:method:getHasArrow"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMenuModel]("GI.Gtk.Objects.PopoverMenu#g:method:getMenuModel"), [getMnemonicsVisible]("GI.Gtk.Objects.Popover#g:method:getMnemonicsVisible"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOffset]("GI.Gtk.Objects.Popover#g:method:getOffset"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPointingTo]("GI.Gtk.Objects.Popover#g:method:getPointingTo"), [getPosition]("GI.Gtk.Objects.Popover#g:method:getPosition"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAutohide]("GI.Gtk.Objects.Popover#g:method:setAutohide"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setCascadePopdown]("GI.Gtk.Objects.Popover#g:method:setCascadePopdown"), [setChild]("GI.Gtk.Objects.Popover#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDefaultWidget]("GI.Gtk.Objects.Popover#g:method:setDefaultWidget"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFlags]("GI.Gtk.Objects.PopoverMenu#g:method:setFlags"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasArrow]("GI.Gtk.Objects.Popover#g:method:setHasArrow"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMenuModel]("GI.Gtk.Objects.PopoverMenu#g:method:setMenuModel"), [setMnemonicsVisible]("GI.Gtk.Objects.Popover#g:method:setMnemonicsVisible"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOffset]("GI.Gtk.Objects.Popover#g:method:setOffset"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPointingTo]("GI.Gtk.Objects.Popover#g:method:setPointingTo"), [setPosition]("GI.Gtk.Objects.Popover#g:method:setPosition"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolvePopoverMenuMethod                ,
#endif

-- ** addChild #method:addChild#

#if defined(ENABLE_OVERLOADING)
    PopoverMenuAddChildMethodInfo           ,
#endif
    popoverMenuAddChild                     ,


-- ** getFlags #method:getFlags#

#if defined(ENABLE_OVERLOADING)
    PopoverMenuGetFlagsMethodInfo           ,
#endif
    popoverMenuGetFlags                     ,


-- ** getMenuModel #method:getMenuModel#

#if defined(ENABLE_OVERLOADING)
    PopoverMenuGetMenuModelMethodInfo       ,
#endif
    popoverMenuGetMenuModel                 ,


-- ** newFromModel #method:newFromModel#

    popoverMenuNewFromModel                 ,


-- ** newFromModelFull #method:newFromModelFull#

    popoverMenuNewFromModelFull             ,


-- ** removeChild #method:removeChild#

#if defined(ENABLE_OVERLOADING)
    PopoverMenuRemoveChildMethodInfo        ,
#endif
    popoverMenuRemoveChild                  ,


-- ** setFlags #method:setFlags#

#if defined(ENABLE_OVERLOADING)
    PopoverMenuSetFlagsMethodInfo           ,
#endif
    popoverMenuSetFlags                     ,


-- ** setMenuModel #method:setMenuModel#

#if defined(ENABLE_OVERLOADING)
    PopoverMenuSetMenuModelMethodInfo       ,
#endif
    popoverMenuSetMenuModel                 ,




 -- * Properties


-- ** flags #attr:flags#
-- | The flags that /@popover@/ uses to create\/display a menu from its model.
-- 
-- If a model is set and the flags change, contents are rebuilt, so if setting
-- properties individually, set flags before model to avoid a redundant rebuild.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    PopoverMenuFlagsPropertyInfo            ,
#endif
    constructPopoverMenuFlags               ,
    getPopoverMenuFlags                     ,
#if defined(ENABLE_OVERLOADING)
    popoverMenuFlags                        ,
#endif
    setPopoverMenuFlags                     ,


-- ** menuModel #attr:menuModel#
-- | The model from which the menu is made.

#if defined(ENABLE_OVERLOADING)
    PopoverMenuMenuModelPropertyInfo        ,
#endif
    clearPopoverMenuMenuModel               ,
    constructPopoverMenuMenuModel           ,
    getPopoverMenuMenuModel                 ,
#if defined(ENABLE_OVERLOADING)
    popoverMenuMenuModel                    ,
#endif
    setPopoverMenuMenuModel                 ,


-- ** visibleSubmenu #attr:visibleSubmenu#
-- | The name of the visible submenu.

#if defined(ENABLE_OVERLOADING)
    PopoverMenuVisibleSubmenuPropertyInfo   ,
#endif
    clearPopoverMenuVisibleSubmenu          ,
    constructPopoverMenuVisibleSubmenu      ,
    getPopoverMenuVisibleSubmenu            ,
#if defined(ENABLE_OVERLOADING)
    popoverMenuVisibleSubmenu               ,
#endif
    setPopoverMenuVisibleSubmenu            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Popover as Gtk.Popover
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Popover as Gtk.Popover
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype PopoverMenu = PopoverMenu (SP.ManagedPtr PopoverMenu)
    deriving (Eq)

instance SP.ManagedPtrNewtype PopoverMenu where
    toManagedPtr (PopoverMenu p) = p

foreign import ccall "gtk_popover_menu_get_type"
    c_gtk_popover_menu_get_type :: IO B.Types.GType

instance B.Types.TypedObject PopoverMenu where
    glibType = c_gtk_popover_menu_get_type

instance B.Types.GObject PopoverMenu

-- | Type class for types which can be safely cast to `PopoverMenu`, for instance with `toPopoverMenu`.
class (SP.GObject o, O.IsDescendantOf PopoverMenu o) => IsPopoverMenu o
instance (SP.GObject o, O.IsDescendantOf PopoverMenu o) => IsPopoverMenu o

instance O.HasParentTypes PopoverMenu
type instance O.ParentTypes PopoverMenu = '[Gtk.Popover.Popover, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Native.Native, Gtk.ShortcutManager.ShortcutManager]

-- | Cast to `PopoverMenu`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toPopoverMenu :: (MIO.MonadIO m, IsPopoverMenu o) => o -> m PopoverMenu
toPopoverMenu = MIO.liftIO . B.ManagedPtr.unsafeCastTo PopoverMenu

-- | Convert 'PopoverMenu' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PopoverMenu) where
    gvalueGType_ = c_gtk_popover_menu_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PopoverMenu)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PopoverMenu)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PopoverMenu ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePopoverMenuMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePopoverMenuMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolvePopoverMenuMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolvePopoverMenuMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolvePopoverMenuMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolvePopoverMenuMethod "addChild" o = PopoverMenuAddChildMethodInfo
    ResolvePopoverMenuMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolvePopoverMenuMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolvePopoverMenuMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolvePopoverMenuMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolvePopoverMenuMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolvePopoverMenuMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolvePopoverMenuMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePopoverMenuMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePopoverMenuMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolvePopoverMenuMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolvePopoverMenuMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolvePopoverMenuMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolvePopoverMenuMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolvePopoverMenuMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolvePopoverMenuMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolvePopoverMenuMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolvePopoverMenuMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolvePopoverMenuMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolvePopoverMenuMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolvePopoverMenuMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePopoverMenuMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePopoverMenuMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePopoverMenuMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolvePopoverMenuMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolvePopoverMenuMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolvePopoverMenuMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolvePopoverMenuMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolvePopoverMenuMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolvePopoverMenuMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolvePopoverMenuMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolvePopoverMenuMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolvePopoverMenuMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolvePopoverMenuMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolvePopoverMenuMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolvePopoverMenuMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolvePopoverMenuMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePopoverMenuMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolvePopoverMenuMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolvePopoverMenuMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolvePopoverMenuMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolvePopoverMenuMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolvePopoverMenuMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolvePopoverMenuMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolvePopoverMenuMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolvePopoverMenuMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePopoverMenuMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePopoverMenuMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolvePopoverMenuMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolvePopoverMenuMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolvePopoverMenuMethod "popdown" o = Gtk.Popover.PopoverPopdownMethodInfo
    ResolvePopoverMenuMethod "popup" o = Gtk.Popover.PopoverPopupMethodInfo
    ResolvePopoverMenuMethod "present" o = Gtk.Popover.PopoverPresentMethodInfo
    ResolvePopoverMenuMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolvePopoverMenuMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolvePopoverMenuMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolvePopoverMenuMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolvePopoverMenuMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePopoverMenuMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePopoverMenuMethod "removeChild" o = PopoverMenuRemoveChildMethodInfo
    ResolvePopoverMenuMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolvePopoverMenuMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolvePopoverMenuMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolvePopoverMenuMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolvePopoverMenuMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolvePopoverMenuMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolvePopoverMenuMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolvePopoverMenuMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePopoverMenuMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolvePopoverMenuMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolvePopoverMenuMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolvePopoverMenuMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolvePopoverMenuMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePopoverMenuMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePopoverMenuMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePopoverMenuMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolvePopoverMenuMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolvePopoverMenuMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolvePopoverMenuMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolvePopoverMenuMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolvePopoverMenuMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePopoverMenuMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolvePopoverMenuMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolvePopoverMenuMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolvePopoverMenuMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolvePopoverMenuMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolvePopoverMenuMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolvePopoverMenuMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePopoverMenuMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolvePopoverMenuMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolvePopoverMenuMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolvePopoverMenuMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolvePopoverMenuMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolvePopoverMenuMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolvePopoverMenuMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolvePopoverMenuMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolvePopoverMenuMethod "getAutohide" o = Gtk.Popover.PopoverGetAutohideMethodInfo
    ResolvePopoverMenuMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolvePopoverMenuMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolvePopoverMenuMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolvePopoverMenuMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolvePopoverMenuMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolvePopoverMenuMethod "getCascadePopdown" o = Gtk.Popover.PopoverGetCascadePopdownMethodInfo
    ResolvePopoverMenuMethod "getChild" o = Gtk.Popover.PopoverGetChildMethodInfo
    ResolvePopoverMenuMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolvePopoverMenuMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolvePopoverMenuMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolvePopoverMenuMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolvePopoverMenuMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolvePopoverMenuMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolvePopoverMenuMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePopoverMenuMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolvePopoverMenuMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolvePopoverMenuMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolvePopoverMenuMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolvePopoverMenuMethod "getFlags" o = PopoverMenuGetFlagsMethodInfo
    ResolvePopoverMenuMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolvePopoverMenuMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolvePopoverMenuMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolvePopoverMenuMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolvePopoverMenuMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolvePopoverMenuMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolvePopoverMenuMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolvePopoverMenuMethod "getHasArrow" o = Gtk.Popover.PopoverGetHasArrowMethodInfo
    ResolvePopoverMenuMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolvePopoverMenuMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolvePopoverMenuMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolvePopoverMenuMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolvePopoverMenuMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolvePopoverMenuMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolvePopoverMenuMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolvePopoverMenuMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolvePopoverMenuMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolvePopoverMenuMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolvePopoverMenuMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolvePopoverMenuMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolvePopoverMenuMethod "getMenuModel" o = PopoverMenuGetMenuModelMethodInfo
    ResolvePopoverMenuMethod "getMnemonicsVisible" o = Gtk.Popover.PopoverGetMnemonicsVisibleMethodInfo
    ResolvePopoverMenuMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolvePopoverMenuMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolvePopoverMenuMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolvePopoverMenuMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolvePopoverMenuMethod "getOffset" o = Gtk.Popover.PopoverGetOffsetMethodInfo
    ResolvePopoverMenuMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolvePopoverMenuMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolvePopoverMenuMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolvePopoverMenuMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolvePopoverMenuMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolvePopoverMenuMethod "getPointingTo" o = Gtk.Popover.PopoverGetPointingToMethodInfo
    ResolvePopoverMenuMethod "getPosition" o = Gtk.Popover.PopoverGetPositionMethodInfo
    ResolvePopoverMenuMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolvePopoverMenuMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolvePopoverMenuMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolvePopoverMenuMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePopoverMenuMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePopoverMenuMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolvePopoverMenuMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolvePopoverMenuMethod "getRenderer" o = Gtk.Native.NativeGetRendererMethodInfo
    ResolvePopoverMenuMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolvePopoverMenuMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolvePopoverMenuMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolvePopoverMenuMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolvePopoverMenuMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolvePopoverMenuMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolvePopoverMenuMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolvePopoverMenuMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolvePopoverMenuMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolvePopoverMenuMethod "getSurface" o = Gtk.Native.NativeGetSurfaceMethodInfo
    ResolvePopoverMenuMethod "getSurfaceTransform" o = Gtk.Native.NativeGetSurfaceTransformMethodInfo
    ResolvePopoverMenuMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolvePopoverMenuMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolvePopoverMenuMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolvePopoverMenuMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolvePopoverMenuMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolvePopoverMenuMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolvePopoverMenuMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolvePopoverMenuMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolvePopoverMenuMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolvePopoverMenuMethod "setAutohide" o = Gtk.Popover.PopoverSetAutohideMethodInfo
    ResolvePopoverMenuMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolvePopoverMenuMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolvePopoverMenuMethod "setCascadePopdown" o = Gtk.Popover.PopoverSetCascadePopdownMethodInfo
    ResolvePopoverMenuMethod "setChild" o = Gtk.Popover.PopoverSetChildMethodInfo
    ResolvePopoverMenuMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolvePopoverMenuMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolvePopoverMenuMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolvePopoverMenuMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolvePopoverMenuMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePopoverMenuMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePopoverMenuMethod "setDefaultWidget" o = Gtk.Popover.PopoverSetDefaultWidgetMethodInfo
    ResolvePopoverMenuMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolvePopoverMenuMethod "setFlags" o = PopoverMenuSetFlagsMethodInfo
    ResolvePopoverMenuMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolvePopoverMenuMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolvePopoverMenuMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolvePopoverMenuMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolvePopoverMenuMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolvePopoverMenuMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolvePopoverMenuMethod "setHasArrow" o = Gtk.Popover.PopoverSetHasArrowMethodInfo
    ResolvePopoverMenuMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolvePopoverMenuMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolvePopoverMenuMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolvePopoverMenuMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolvePopoverMenuMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolvePopoverMenuMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolvePopoverMenuMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolvePopoverMenuMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolvePopoverMenuMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolvePopoverMenuMethod "setMenuModel" o = PopoverMenuSetMenuModelMethodInfo
    ResolvePopoverMenuMethod "setMnemonicsVisible" o = Gtk.Popover.PopoverSetMnemonicsVisibleMethodInfo
    ResolvePopoverMenuMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolvePopoverMenuMethod "setOffset" o = Gtk.Popover.PopoverSetOffsetMethodInfo
    ResolvePopoverMenuMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolvePopoverMenuMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolvePopoverMenuMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolvePopoverMenuMethod "setPointingTo" o = Gtk.Popover.PopoverSetPointingToMethodInfo
    ResolvePopoverMenuMethod "setPosition" o = Gtk.Popover.PopoverSetPositionMethodInfo
    ResolvePopoverMenuMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePopoverMenuMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolvePopoverMenuMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolvePopoverMenuMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolvePopoverMenuMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolvePopoverMenuMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolvePopoverMenuMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolvePopoverMenuMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolvePopoverMenuMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolvePopoverMenuMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolvePopoverMenuMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolvePopoverMenuMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePopoverMenuMethod t PopoverMenu, O.OverloadedMethod info PopoverMenu p) => OL.IsLabel t (PopoverMenu -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePopoverMenuMethod t PopoverMenu, O.OverloadedMethod info PopoverMenu p, R.HasField t PopoverMenu p) => R.HasField t PopoverMenu p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePopoverMenuMethod t PopoverMenu, O.OverloadedMethodInfo info PopoverMenu) => OL.IsLabel t (O.MethodProxy info PopoverMenu) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "flags"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PopoverMenuFlags"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@flags@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' popoverMenu #flags
-- @
getPopoverMenuFlags :: (MonadIO m, IsPopoverMenu o) => o -> m [Gtk.Flags.PopoverMenuFlags]
getPopoverMenuFlags obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "flags"

-- | Set the value of the “@flags@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' popoverMenu [ #flags 'Data.GI.Base.Attributes.:=' value ]
-- @
setPopoverMenuFlags :: (MonadIO m, IsPopoverMenu o) => o -> [Gtk.Flags.PopoverMenuFlags] -> m ()
setPopoverMenuFlags obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyFlags obj "flags" val

-- | Construct a `GValueConstruct` with valid value for the “@flags@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPopoverMenuFlags :: (IsPopoverMenu o, MIO.MonadIO m) => [Gtk.Flags.PopoverMenuFlags] -> m (GValueConstruct o)
constructPopoverMenuFlags val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "flags" val

#if defined(ENABLE_OVERLOADING)
data PopoverMenuFlagsPropertyInfo
instance AttrInfo PopoverMenuFlagsPropertyInfo where
    type AttrAllowedOps PopoverMenuFlagsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PopoverMenuFlagsPropertyInfo = IsPopoverMenu
    type AttrSetTypeConstraint PopoverMenuFlagsPropertyInfo = (~) [Gtk.Flags.PopoverMenuFlags]
    type AttrTransferTypeConstraint PopoverMenuFlagsPropertyInfo = (~) [Gtk.Flags.PopoverMenuFlags]
    type AttrTransferType PopoverMenuFlagsPropertyInfo = [Gtk.Flags.PopoverMenuFlags]
    type AttrGetType PopoverMenuFlagsPropertyInfo = [Gtk.Flags.PopoverMenuFlags]
    type AttrLabel PopoverMenuFlagsPropertyInfo = "flags"
    type AttrOrigin PopoverMenuFlagsPropertyInfo = PopoverMenu
    attrGet = getPopoverMenuFlags
    attrSet = setPopoverMenuFlags
    attrTransfer _ v = do
        return v
    attrConstruct = constructPopoverMenuFlags
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PopoverMenu.flags"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PopoverMenu.html#g:attr:flags"
        })
#endif

-- VVV Prop "menu-model"
   -- Type: TInterface (Name {namespace = "Gio", name = "MenuModel"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@menu-model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' popoverMenu #menuModel
-- @
getPopoverMenuMenuModel :: (MonadIO m, IsPopoverMenu o) => o -> m (Maybe Gio.MenuModel.MenuModel)
getPopoverMenuMenuModel obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "menu-model" Gio.MenuModel.MenuModel

-- | Set the value of the “@menu-model@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' popoverMenu [ #menuModel 'Data.GI.Base.Attributes.:=' value ]
-- @
setPopoverMenuMenuModel :: (MonadIO m, IsPopoverMenu o, Gio.MenuModel.IsMenuModel a) => o -> a -> m ()
setPopoverMenuMenuModel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "menu-model" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@menu-model@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPopoverMenuMenuModel :: (IsPopoverMenu o, MIO.MonadIO m, Gio.MenuModel.IsMenuModel a) => a -> m (GValueConstruct o)
constructPopoverMenuMenuModel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "menu-model" (P.Just val)

-- | Set the value of the “@menu-model@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #menuModel
-- @
clearPopoverMenuMenuModel :: (MonadIO m, IsPopoverMenu o) => o -> m ()
clearPopoverMenuMenuModel obj = liftIO $ B.Properties.setObjectPropertyObject obj "menu-model" (Nothing :: Maybe Gio.MenuModel.MenuModel)

#if defined(ENABLE_OVERLOADING)
data PopoverMenuMenuModelPropertyInfo
instance AttrInfo PopoverMenuMenuModelPropertyInfo where
    type AttrAllowedOps PopoverMenuMenuModelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PopoverMenuMenuModelPropertyInfo = IsPopoverMenu
    type AttrSetTypeConstraint PopoverMenuMenuModelPropertyInfo = Gio.MenuModel.IsMenuModel
    type AttrTransferTypeConstraint PopoverMenuMenuModelPropertyInfo = Gio.MenuModel.IsMenuModel
    type AttrTransferType PopoverMenuMenuModelPropertyInfo = Gio.MenuModel.MenuModel
    type AttrGetType PopoverMenuMenuModelPropertyInfo = (Maybe Gio.MenuModel.MenuModel)
    type AttrLabel PopoverMenuMenuModelPropertyInfo = "menu-model"
    type AttrOrigin PopoverMenuMenuModelPropertyInfo = PopoverMenu
    attrGet = getPopoverMenuMenuModel
    attrSet = setPopoverMenuMenuModel
    attrTransfer _ v = do
        unsafeCastTo Gio.MenuModel.MenuModel v
    attrConstruct = constructPopoverMenuMenuModel
    attrClear = clearPopoverMenuMenuModel
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PopoverMenu.menuModel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PopoverMenu.html#g:attr:menuModel"
        })
#endif

-- VVV Prop "visible-submenu"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@visible-submenu@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' popoverMenu #visibleSubmenu
-- @
getPopoverMenuVisibleSubmenu :: (MonadIO m, IsPopoverMenu o) => o -> m (Maybe T.Text)
getPopoverMenuVisibleSubmenu obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "visible-submenu"

-- | Set the value of the “@visible-submenu@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' popoverMenu [ #visibleSubmenu 'Data.GI.Base.Attributes.:=' value ]
-- @
setPopoverMenuVisibleSubmenu :: (MonadIO m, IsPopoverMenu o) => o -> T.Text -> m ()
setPopoverMenuVisibleSubmenu obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "visible-submenu" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@visible-submenu@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPopoverMenuVisibleSubmenu :: (IsPopoverMenu o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructPopoverMenuVisibleSubmenu val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "visible-submenu" (P.Just val)

-- | Set the value of the “@visible-submenu@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #visibleSubmenu
-- @
clearPopoverMenuVisibleSubmenu :: (MonadIO m, IsPopoverMenu o) => o -> m ()
clearPopoverMenuVisibleSubmenu obj = liftIO $ B.Properties.setObjectPropertyString obj "visible-submenu" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data PopoverMenuVisibleSubmenuPropertyInfo
instance AttrInfo PopoverMenuVisibleSubmenuPropertyInfo where
    type AttrAllowedOps PopoverMenuVisibleSubmenuPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PopoverMenuVisibleSubmenuPropertyInfo = IsPopoverMenu
    type AttrSetTypeConstraint PopoverMenuVisibleSubmenuPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint PopoverMenuVisibleSubmenuPropertyInfo = (~) T.Text
    type AttrTransferType PopoverMenuVisibleSubmenuPropertyInfo = T.Text
    type AttrGetType PopoverMenuVisibleSubmenuPropertyInfo = (Maybe T.Text)
    type AttrLabel PopoverMenuVisibleSubmenuPropertyInfo = "visible-submenu"
    type AttrOrigin PopoverMenuVisibleSubmenuPropertyInfo = PopoverMenu
    attrGet = getPopoverMenuVisibleSubmenu
    attrSet = setPopoverMenuVisibleSubmenu
    attrTransfer _ v = do
        return v
    attrConstruct = constructPopoverMenuVisibleSubmenu
    attrClear = clearPopoverMenuVisibleSubmenu
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PopoverMenu.visibleSubmenu"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PopoverMenu.html#g:attr:visibleSubmenu"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PopoverMenu
type instance O.AttributeList PopoverMenu = PopoverMenuAttributeList
type PopoverMenuAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("autohide", Gtk.Popover.PopoverAutohidePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cascadePopdown", Gtk.Popover.PopoverCascadePopdownPropertyInfo), '("child", Gtk.Popover.PopoverChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("defaultWidget", Gtk.Popover.PopoverDefaultWidgetPropertyInfo), '("flags", PopoverMenuFlagsPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasArrow", Gtk.Popover.PopoverHasArrowPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("menuModel", PopoverMenuMenuModelPropertyInfo), '("mnemonicsVisible", Gtk.Popover.PopoverMnemonicsVisiblePropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("pointingTo", Gtk.Popover.PopoverPointingToPropertyInfo), '("position", Gtk.Popover.PopoverPositionPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("visibleSubmenu", PopoverMenuVisibleSubmenuPropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
popoverMenuFlags :: AttrLabelProxy "flags"
popoverMenuFlags = AttrLabelProxy

popoverMenuMenuModel :: AttrLabelProxy "menuModel"
popoverMenuMenuModel = AttrLabelProxy

popoverMenuVisibleSubmenu :: AttrLabelProxy "visibleSubmenu"
popoverMenuVisibleSubmenu = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PopoverMenu = PopoverMenuSignalList
type PopoverMenuSignalList = ('[ '("activateDefault", Gtk.Popover.PopoverActivateDefaultSignalInfo), '("closed", Gtk.Popover.PopoverClosedSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method PopoverMenu::new_from_model
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GMenuModel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "PopoverMenu" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_menu_new_from_model" gtk_popover_menu_new_from_model :: 
    Ptr Gio.MenuModel.MenuModel ->          -- model : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    IO (Ptr PopoverMenu)

-- | Creates a @GtkPopoverMenu@ and populates it according to /@model@/.
-- 
-- The created buttons are connected to actions found in the
-- @GtkApplicationWindow@ to which the popover belongs - typically
-- by means of being attached to a widget that is contained within
-- the @GtkApplicationWindow@s widget hierarchy.
-- 
-- Actions can also be added using 'GI.Gtk.Objects.Widget.widgetInsertActionGroup'
-- on the menus attach widget or on any of its parent widgets.
-- 
-- This function creates menus with sliding submenus.
-- See 'GI.Gtk.Objects.PopoverMenu.popoverMenuNewFromModelFull' for a way
-- to control this.
popoverMenuNewFromModel ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.MenuModel.IsMenuModel a) =>
    Maybe (a)
    -- ^ /@model@/: a @GMenuModel@
    -> m PopoverMenu
    -- ^ __Returns:__ the new @GtkPopoverMenu@
popoverMenuNewFromModel model = liftIO $ do
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    result <- gtk_popover_menu_new_from_model maybeModel
    checkUnexpectedReturnNULL "popoverMenuNewFromModel" result
    result' <- (newObject PopoverMenu) result
    whenJust model touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method PopoverMenu::new_from_model_full
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GMenuModel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PopoverMenuFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "flags that affect how the menu is created"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "PopoverMenu" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_menu_new_from_model_full" gtk_popover_menu_new_from_model_full :: 
    Ptr Gio.MenuModel.MenuModel ->          -- model : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gtk", name = "PopoverMenuFlags"})
    IO (Ptr PopoverMenu)

-- | Creates a @GtkPopoverMenu@ and populates it according to /@model@/.
-- 
-- The created buttons are connected to actions found in the
-- action groups that are accessible from the parent widget.
-- This includes the @GtkApplicationWindow@ to which the popover
-- belongs. Actions can also be added using 'GI.Gtk.Objects.Widget.widgetInsertActionGroup'
-- on the parent widget or on any of its parent widgets.
popoverMenuNewFromModelFull ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.MenuModel.IsMenuModel a) =>
    a
    -- ^ /@model@/: a @GMenuModel@
    -> [Gtk.Flags.PopoverMenuFlags]
    -- ^ /@flags@/: flags that affect how the menu is created
    -> m PopoverMenu
    -- ^ __Returns:__ the new @GtkPopoverMenu@
popoverMenuNewFromModelFull model flags = liftIO $ do
    model' <- unsafeManagedPtrCastPtr model
    let flags' = gflagsToWord flags
    result <- gtk_popover_menu_new_from_model_full model' flags'
    checkUnexpectedReturnNULL "popoverMenuNewFromModelFull" result
    result' <- (newObject PopoverMenu) result
    touchManagedPtr model
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method PopoverMenu::add_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PopoverMenu" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopoverMenu`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkWidget` to add"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the ID to insert @child at"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_menu_add_child" gtk_popover_menu_add_child :: 
    Ptr PopoverMenu ->                      -- popover : TInterface (Name {namespace = "Gtk", name = "PopoverMenu"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    CString ->                              -- id : TBasicType TUTF8
    IO CInt

-- | Adds a custom widget to a generated menu.
-- 
-- For this to work, the menu model of /@popover@/ must have
-- an item with a @custom@ attribute that matches /@id@/.
popoverMenuAddChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopoverMenu a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@popover@/: a @GtkPopoverMenu@
    -> b
    -- ^ /@child@/: the @GtkWidget@ to add
    -> T.Text
    -- ^ /@id@/: the ID to insert /@child@/ at
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@id@/ was found and the widget added
popoverMenuAddChild popover child id = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    child' <- unsafeManagedPtrCastPtr child
    id' <- textToCString id
    result <- gtk_popover_menu_add_child popover' child' id'
    let result' = (/= 0) result
    touchManagedPtr popover
    touchManagedPtr child
    freeMem id'
    return result'

#if defined(ENABLE_OVERLOADING)
data PopoverMenuAddChildMethodInfo
instance (signature ~ (b -> T.Text -> m Bool), MonadIO m, IsPopoverMenu a, Gtk.Widget.IsWidget b) => O.OverloadedMethod PopoverMenuAddChildMethodInfo a signature where
    overloadedMethod = popoverMenuAddChild

instance O.OverloadedMethodInfo PopoverMenuAddChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PopoverMenu.popoverMenuAddChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PopoverMenu.html#v:popoverMenuAddChild"
        })


#endif

-- method PopoverMenu::get_flags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PopoverMenu" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopoverMenu`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PopoverMenuFlags" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_menu_get_flags" gtk_popover_menu_get_flags :: 
    Ptr PopoverMenu ->                      -- popover : TInterface (Name {namespace = "Gtk", name = "PopoverMenu"})
    IO CUInt

-- | Returns the flags that /@popover@/ uses to create\/display a menu from its model.
-- 
-- /Since: 4.14/
popoverMenuGetFlags ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopoverMenu a) =>
    a
    -- ^ /@popover@/: a @GtkPopoverMenu@
    -> m [Gtk.Flags.PopoverMenuFlags]
    -- ^ __Returns:__ the @GtkPopoverMenuFlags@
popoverMenuGetFlags popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    result <- gtk_popover_menu_get_flags popover'
    let result' = wordToGFlags result
    touchManagedPtr popover
    return result'

#if defined(ENABLE_OVERLOADING)
data PopoverMenuGetFlagsMethodInfo
instance (signature ~ (m [Gtk.Flags.PopoverMenuFlags]), MonadIO m, IsPopoverMenu a) => O.OverloadedMethod PopoverMenuGetFlagsMethodInfo a signature where
    overloadedMethod = popoverMenuGetFlags

instance O.OverloadedMethodInfo PopoverMenuGetFlagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PopoverMenu.popoverMenuGetFlags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PopoverMenu.html#v:popoverMenuGetFlags"
        })


#endif

-- method PopoverMenu::get_menu_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PopoverMenu" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopoverMenu`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "MenuModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_menu_get_menu_model" gtk_popover_menu_get_menu_model :: 
    Ptr PopoverMenu ->                      -- popover : TInterface (Name {namespace = "Gtk", name = "PopoverMenu"})
    IO (Ptr Gio.MenuModel.MenuModel)

-- | Returns the menu model used to populate the popover.
popoverMenuGetMenuModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopoverMenu a) =>
    a
    -- ^ /@popover@/: a @GtkPopoverMenu@
    -> m (Maybe Gio.MenuModel.MenuModel)
    -- ^ __Returns:__ the menu model of /@popover@/
popoverMenuGetMenuModel popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    result <- gtk_popover_menu_get_menu_model popover'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gio.MenuModel.MenuModel) result'
        return result''
    touchManagedPtr popover
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PopoverMenuGetMenuModelMethodInfo
instance (signature ~ (m (Maybe Gio.MenuModel.MenuModel)), MonadIO m, IsPopoverMenu a) => O.OverloadedMethod PopoverMenuGetMenuModelMethodInfo a signature where
    overloadedMethod = popoverMenuGetMenuModel

instance O.OverloadedMethodInfo PopoverMenuGetMenuModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PopoverMenu.popoverMenuGetMenuModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PopoverMenu.html#v:popoverMenuGetMenuModel"
        })


#endif

-- method PopoverMenu::remove_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PopoverMenu" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopoverMenu`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the `GtkWidget` to remove"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_menu_remove_child" gtk_popover_menu_remove_child :: 
    Ptr PopoverMenu ->                      -- popover : TInterface (Name {namespace = "Gtk", name = "PopoverMenu"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO CInt

-- | Removes a widget that has previously been added with
-- [method/@gtk@/.PopoverMenu.@/add_child()/@]
popoverMenuRemoveChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopoverMenu a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@popover@/: a @GtkPopoverMenu@
    -> b
    -- ^ /@child@/: the @GtkWidget@ to remove
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the widget was removed
popoverMenuRemoveChild popover child = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    child' <- unsafeManagedPtrCastPtr child
    result <- gtk_popover_menu_remove_child popover' child'
    let result' = (/= 0) result
    touchManagedPtr popover
    touchManagedPtr child
    return result'

#if defined(ENABLE_OVERLOADING)
data PopoverMenuRemoveChildMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsPopoverMenu a, Gtk.Widget.IsWidget b) => O.OverloadedMethod PopoverMenuRemoveChildMethodInfo a signature where
    overloadedMethod = popoverMenuRemoveChild

instance O.OverloadedMethodInfo PopoverMenuRemoveChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PopoverMenu.popoverMenuRemoveChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PopoverMenu.html#v:popoverMenuRemoveChild"
        })


#endif

-- method PopoverMenu::set_flags
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PopoverMenu" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopoverMenu`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "flags"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PopoverMenuFlags" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a set of `GtkPopoverMenuFlags`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_menu_set_flags" gtk_popover_menu_set_flags :: 
    Ptr PopoverMenu ->                      -- popover : TInterface (Name {namespace = "Gtk", name = "PopoverMenu"})
    CUInt ->                                -- flags : TInterface (Name {namespace = "Gtk", name = "PopoverMenuFlags"})
    IO ()

-- | Sets the flags that /@popover@/ uses to create\/display a menu from its model.
-- 
-- If a model is set and the flags change, contents are rebuilt, so if setting
-- properties individually, set flags before model to avoid a redundant rebuild.
-- 
-- /Since: 4.14/
popoverMenuSetFlags ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopoverMenu a) =>
    a
    -- ^ /@popover@/: a @GtkPopoverMenu@
    -> [Gtk.Flags.PopoverMenuFlags]
    -- ^ /@flags@/: a set of @GtkPopoverMenuFlags@
    -> m ()
popoverMenuSetFlags popover flags = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    let flags' = gflagsToWord flags
    gtk_popover_menu_set_flags popover' flags'
    touchManagedPtr popover
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverMenuSetFlagsMethodInfo
instance (signature ~ ([Gtk.Flags.PopoverMenuFlags] -> m ()), MonadIO m, IsPopoverMenu a) => O.OverloadedMethod PopoverMenuSetFlagsMethodInfo a signature where
    overloadedMethod = popoverMenuSetFlags

instance O.OverloadedMethodInfo PopoverMenuSetFlagsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PopoverMenu.popoverMenuSetFlags",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PopoverMenu.html#v:popoverMenuSetFlags"
        })


#endif

-- method PopoverMenu::set_menu_model
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PopoverMenu" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopoverMenu`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "model"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "MenuModel" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GMenuModel`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_menu_set_menu_model" gtk_popover_menu_set_menu_model :: 
    Ptr PopoverMenu ->                      -- popover : TInterface (Name {namespace = "Gtk", name = "PopoverMenu"})
    Ptr Gio.MenuModel.MenuModel ->          -- model : TInterface (Name {namespace = "Gio", name = "MenuModel"})
    IO ()

-- | Sets a new menu model on /@popover@/.
-- 
-- The existing contents of /@popover@/ are removed, and
-- the /@popover@/ is populated with new contents according
-- to /@model@/.
popoverMenuSetMenuModel ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopoverMenu a, Gio.MenuModel.IsMenuModel b) =>
    a
    -- ^ /@popover@/: a @GtkPopoverMenu@
    -> Maybe (b)
    -- ^ /@model@/: a @GMenuModel@
    -> m ()
popoverMenuSetMenuModel popover model = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    maybeModel <- case model of
        Nothing -> return FP.nullPtr
        Just jModel -> do
            jModel' <- unsafeManagedPtrCastPtr jModel
            return jModel'
    gtk_popover_menu_set_menu_model popover' maybeModel
    touchManagedPtr popover
    whenJust model touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverMenuSetMenuModelMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsPopoverMenu a, Gio.MenuModel.IsMenuModel b) => O.OverloadedMethod PopoverMenuSetMenuModelMethodInfo a signature where
    overloadedMethod = popoverMenuSetMenuModel

instance O.OverloadedMethodInfo PopoverMenuSetMenuModelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.PopoverMenu.popoverMenuSetMenuModel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-PopoverMenu.html#v:popoverMenuSetMenuModel"
        })


#endif


