{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Presents a bubble-like popup.
-- 
-- \<picture>
--   \<source srcset=\"popover-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkPopover\" src=\"popover.png\">
-- \<\/picture>
-- 
-- It is primarily meant to provide context-dependent information
-- or options. Popovers are attached to a parent widget. By default,
-- they point to the whole widget area, although this behavior can be
-- changed with 'GI.Gtk.Objects.Popover.popoverSetPointingTo'.
-- 
-- The position of a popover relative to the widget it is attached to
-- can also be changed with 'GI.Gtk.Objects.Popover.popoverSetPosition'
-- 
-- By default, @GtkPopover@ performs a grab, in order to ensure input
-- events get redirected to it while it is shown, and also so the popover
-- is dismissed in the expected situations (clicks outside the popover,
-- or the Escape key being pressed). If no such modal behavior is desired
-- on a popover, 'GI.Gtk.Objects.Popover.popoverSetAutohide' may be called on it to
-- tweak its behavior.
-- 
-- == GtkPopover as menu replacement
-- 
-- @GtkPopover@ is often used to replace menus. The best way to do this
-- is to use the t'GI.Gtk.Objects.PopoverMenu.PopoverMenu' subclass which supports being
-- populated from a @GMenuModel@ with 'GI.Gtk.Objects.PopoverMenu.popoverMenuNewFromModel'.
-- 
-- 
-- === /xml code/
-- ><section>
-- >  <attribute name="display-hint">horizontal-buttons</attribute>
-- >  <item>
-- >    <attribute name="label">Cut</attribute>
-- >    <attribute name="action">app.cut</attribute>
-- >    <attribute name="verb-icon">edit-cut-symbolic</attribute>
-- >  </item>
-- >  <item>
-- >    <attribute name="label">Copy</attribute>
-- >    <attribute name="action">app.copy</attribute>
-- >    <attribute name="verb-icon">edit-copy-symbolic</attribute>
-- >  </item>
-- >  <item>
-- >    <attribute name="label">Paste</attribute>
-- >    <attribute name="action">app.paste</attribute>
-- >    <attribute name="verb-icon">edit-paste-symbolic</attribute>
-- >  </item>
-- ></section>
-- 
-- 
-- = Shortcuts and Gestures
-- 
-- @GtkPopover@ supports the following keyboard shortcuts:
-- 
-- * \<kbd>Escape\<\/kbd> closes the popover.
-- * \<kbd>Alt\<\/kbd> makes the mnemonics visible.
-- 
-- 
-- The following signals have default keybindings:
-- 
-- * [Popover::activateDefault]("GI.Gtk.Objects.Popover#g:signal:activateDefault")
-- 
-- 
-- = CSS nodes
-- 
-- >popover.background[.menu]
-- >├── arrow
-- >╰── contents
-- >    ╰── <child>
-- 
-- 
-- @GtkPopover@ has a main node with name @popover@, an arrow with name @arrow@,
-- and another node for the content named @contents@. The @popover@ node always
-- gets the @.background@ style class. It also gets the @.menu@ style class
-- if the popover is menu-like, e.g. is a t'GI.Gtk.Objects.PopoverMenu.PopoverMenu'.
-- 
-- Particular uses of @GtkPopover@, such as touch selection popups or
-- magnifiers in @GtkEntry@ or @GtkTextView@ get style classes like
-- @.touch-selection@ or @.magnifier@ to differentiate from plain popovers.
-- 
-- When styling a popover directly, the @popover@ node should usually
-- not have any background. The visible part of the popover can have
-- a shadow. To specify it in CSS, set the box-shadow of the @contents@ node.
-- 
-- Note that, in order to accomplish appropriate arrow visuals, @GtkPopover@
-- uses custom drawing for the @arrow@ node. This makes it possible for the
-- arrow to change its shape dynamically, but it also limits the possibilities
-- of styling it using CSS. In particular, the @arrow@ gets drawn over the
-- @content@ node\'s border and shadow, so they look like one shape, which
-- means that the border width of the @content@ node and the @arrow@ node should
-- be the same. The arrow also does not support any border shape other than
-- solid, no border-radius, only one border width (border-bottom-width is
-- used) and no box-shadow.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.Popover
    ( 

-- * Exported types
    Popover(..)                             ,
    IsPopover                               ,
    toPopover                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [popdown]("GI.Gtk.Objects.Popover#g:method:popdown"), [popup]("GI.Gtk.Objects.Popover#g:method:popup"), [present]("GI.Gtk.Objects.Popover#g:method:present"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getAutohide]("GI.Gtk.Objects.Popover#g:method:getAutohide"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getCascadePopdown]("GI.Gtk.Objects.Popover#g:method:getCascadePopdown"), [getChild]("GI.Gtk.Objects.Popover#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasArrow]("GI.Gtk.Objects.Popover#g:method:getHasArrow"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMnemonicsVisible]("GI.Gtk.Objects.Popover#g:method:getMnemonicsVisible"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOffset]("GI.Gtk.Objects.Popover#g:method:getOffset"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPointingTo]("GI.Gtk.Objects.Popover#g:method:getPointingTo"), [getPosition]("GI.Gtk.Objects.Popover#g:method:getPosition"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setAutohide]("GI.Gtk.Objects.Popover#g:method:setAutohide"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setCascadePopdown]("GI.Gtk.Objects.Popover#g:method:setCascadePopdown"), [setChild]("GI.Gtk.Objects.Popover#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDefaultWidget]("GI.Gtk.Objects.Popover#g:method:setDefaultWidget"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasArrow]("GI.Gtk.Objects.Popover#g:method:setHasArrow"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMnemonicsVisible]("GI.Gtk.Objects.Popover#g:method:setMnemonicsVisible"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOffset]("GI.Gtk.Objects.Popover#g:method:setOffset"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPointingTo]("GI.Gtk.Objects.Popover#g:method:setPointingTo"), [setPosition]("GI.Gtk.Objects.Popover#g:method:setPosition"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolvePopoverMethod                    ,
#endif

-- ** getAutohide #method:getAutohide#

#if defined(ENABLE_OVERLOADING)
    PopoverGetAutohideMethodInfo            ,
#endif
    popoverGetAutohide                      ,


-- ** getCascadePopdown #method:getCascadePopdown#

#if defined(ENABLE_OVERLOADING)
    PopoverGetCascadePopdownMethodInfo      ,
#endif
    popoverGetCascadePopdown                ,


-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    PopoverGetChildMethodInfo               ,
#endif
    popoverGetChild                         ,


-- ** getHasArrow #method:getHasArrow#

#if defined(ENABLE_OVERLOADING)
    PopoverGetHasArrowMethodInfo            ,
#endif
    popoverGetHasArrow                      ,


-- ** getMnemonicsVisible #method:getMnemonicsVisible#

#if defined(ENABLE_OVERLOADING)
    PopoverGetMnemonicsVisibleMethodInfo    ,
#endif
    popoverGetMnemonicsVisible              ,


-- ** getOffset #method:getOffset#

#if defined(ENABLE_OVERLOADING)
    PopoverGetOffsetMethodInfo              ,
#endif
    popoverGetOffset                        ,


-- ** getPointingTo #method:getPointingTo#

#if defined(ENABLE_OVERLOADING)
    PopoverGetPointingToMethodInfo          ,
#endif
    popoverGetPointingTo                    ,


-- ** getPosition #method:getPosition#

#if defined(ENABLE_OVERLOADING)
    PopoverGetPositionMethodInfo            ,
#endif
    popoverGetPosition                      ,


-- ** new #method:new#

    popoverNew                              ,


-- ** popdown #method:popdown#

#if defined(ENABLE_OVERLOADING)
    PopoverPopdownMethodInfo                ,
#endif
    popoverPopdown                          ,


-- ** popup #method:popup#

#if defined(ENABLE_OVERLOADING)
    PopoverPopupMethodInfo                  ,
#endif
    popoverPopup                            ,


-- ** present #method:present#

#if defined(ENABLE_OVERLOADING)
    PopoverPresentMethodInfo                ,
#endif
    popoverPresent                          ,


-- ** setAutohide #method:setAutohide#

#if defined(ENABLE_OVERLOADING)
    PopoverSetAutohideMethodInfo            ,
#endif
    popoverSetAutohide                      ,


-- ** setCascadePopdown #method:setCascadePopdown#

#if defined(ENABLE_OVERLOADING)
    PopoverSetCascadePopdownMethodInfo      ,
#endif
    popoverSetCascadePopdown                ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    PopoverSetChildMethodInfo               ,
#endif
    popoverSetChild                         ,


-- ** setDefaultWidget #method:setDefaultWidget#

#if defined(ENABLE_OVERLOADING)
    PopoverSetDefaultWidgetMethodInfo       ,
#endif
    popoverSetDefaultWidget                 ,


-- ** setHasArrow #method:setHasArrow#

#if defined(ENABLE_OVERLOADING)
    PopoverSetHasArrowMethodInfo            ,
#endif
    popoverSetHasArrow                      ,


-- ** setMnemonicsVisible #method:setMnemonicsVisible#

#if defined(ENABLE_OVERLOADING)
    PopoverSetMnemonicsVisibleMethodInfo    ,
#endif
    popoverSetMnemonicsVisible              ,


-- ** setOffset #method:setOffset#

#if defined(ENABLE_OVERLOADING)
    PopoverSetOffsetMethodInfo              ,
#endif
    popoverSetOffset                        ,


-- ** setPointingTo #method:setPointingTo#

#if defined(ENABLE_OVERLOADING)
    PopoverSetPointingToMethodInfo          ,
#endif
    popoverSetPointingTo                    ,


-- ** setPosition #method:setPosition#

#if defined(ENABLE_OVERLOADING)
    PopoverSetPositionMethodInfo            ,
#endif
    popoverSetPosition                      ,




 -- * Properties


-- ** autohide #attr:autohide#
-- | Whether to dismiss the popover on outside clicks.

#if defined(ENABLE_OVERLOADING)
    PopoverAutohidePropertyInfo             ,
#endif
    constructPopoverAutohide                ,
    getPopoverAutohide                      ,
#if defined(ENABLE_OVERLOADING)
    popoverAutohide                         ,
#endif
    setPopoverAutohide                      ,


-- ** cascadePopdown #attr:cascadePopdown#
-- | Whether the popover pops down after a child popover.
-- 
-- This is used to implement the expected behavior of submenus.

#if defined(ENABLE_OVERLOADING)
    PopoverCascadePopdownPropertyInfo       ,
#endif
    constructPopoverCascadePopdown          ,
    getPopoverCascadePopdown                ,
#if defined(ENABLE_OVERLOADING)
    popoverCascadePopdown                   ,
#endif
    setPopoverCascadePopdown                ,


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    PopoverChildPropertyInfo                ,
#endif
    clearPopoverChild                       ,
    constructPopoverChild                   ,
    getPopoverChild                         ,
#if defined(ENABLE_OVERLOADING)
    popoverChild                            ,
#endif
    setPopoverChild                         ,


-- ** defaultWidget #attr:defaultWidget#
-- | The default widget inside the popover.

#if defined(ENABLE_OVERLOADING)
    PopoverDefaultWidgetPropertyInfo        ,
#endif
    clearPopoverDefaultWidget               ,
    constructPopoverDefaultWidget           ,
    getPopoverDefaultWidget                 ,
#if defined(ENABLE_OVERLOADING)
    popoverDefaultWidget                    ,
#endif
    setPopoverDefaultWidget                 ,


-- ** hasArrow #attr:hasArrow#
-- | Whether to draw an arrow.

#if defined(ENABLE_OVERLOADING)
    PopoverHasArrowPropertyInfo             ,
#endif
    constructPopoverHasArrow                ,
    getPopoverHasArrow                      ,
#if defined(ENABLE_OVERLOADING)
    popoverHasArrow                         ,
#endif
    setPopoverHasArrow                      ,


-- ** mnemonicsVisible #attr:mnemonicsVisible#
-- | Whether mnemonics are currently visible in this popover.

#if defined(ENABLE_OVERLOADING)
    PopoverMnemonicsVisiblePropertyInfo     ,
#endif
    constructPopoverMnemonicsVisible        ,
    getPopoverMnemonicsVisible              ,
#if defined(ENABLE_OVERLOADING)
    popoverMnemonicsVisible                 ,
#endif
    setPopoverMnemonicsVisible              ,


-- ** pointingTo #attr:pointingTo#
-- | Rectangle in the parent widget that the popover points to.

#if defined(ENABLE_OVERLOADING)
    PopoverPointingToPropertyInfo           ,
#endif
    clearPopoverPointingTo                  ,
    constructPopoverPointingTo              ,
    getPopoverPointingTo                    ,
#if defined(ENABLE_OVERLOADING)
    popoverPointingTo                       ,
#endif
    setPopoverPointingTo                    ,


-- ** position #attr:position#
-- | How to place the popover, relative to its parent.

#if defined(ENABLE_OVERLOADING)
    PopoverPositionPropertyInfo             ,
#endif
    constructPopoverPosition                ,
    getPopoverPosition                      ,
#if defined(ENABLE_OVERLOADING)
    popoverPosition                         ,
#endif
    setPopoverPosition                      ,




 -- * Signals


-- ** activateDefault #signal:activateDefault#

    PopoverActivateDefaultCallback          ,
#if defined(ENABLE_OVERLOADING)
    PopoverActivateDefaultSignalInfo        ,
#endif
    afterPopoverActivateDefault             ,
    onPopoverActivateDefault                ,


-- ** closed #signal:closed#

    PopoverClosedCallback                   ,
#if defined(ENABLE_OVERLOADING)
    PopoverClosedSignalInfo                 ,
#endif
    afterPopoverClosed                      ,
    onPopoverClosed                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype Popover = Popover (SP.ManagedPtr Popover)
    deriving (Eq)

instance SP.ManagedPtrNewtype Popover where
    toManagedPtr (Popover p) = p

foreign import ccall "gtk_popover_get_type"
    c_gtk_popover_get_type :: IO B.Types.GType

instance B.Types.TypedObject Popover where
    glibType = c_gtk_popover_get_type

instance B.Types.GObject Popover

-- | Type class for types which can be safely cast to `Popover`, for instance with `toPopover`.
class (SP.GObject o, O.IsDescendantOf Popover o) => IsPopover o
instance (SP.GObject o, O.IsDescendantOf Popover o) => IsPopover o

instance O.HasParentTypes Popover
type instance O.ParentTypes Popover = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Native.Native, Gtk.ShortcutManager.ShortcutManager]

-- | Cast to `Popover`, for types for which this is known to be safe. For general casts, use `Data.GI.Base.ManagedPtr.castTo`.
toPopover :: (MIO.MonadIO m, IsPopover o) => o -> m Popover
toPopover = MIO.liftIO . B.ManagedPtr.unsafeCastTo Popover

-- | Convert 'Popover' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Popover) where
    gvalueGType_ = c_gtk_popover_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Popover)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Popover)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Popover ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolvePopoverMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePopoverMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolvePopoverMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolvePopoverMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolvePopoverMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolvePopoverMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolvePopoverMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolvePopoverMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolvePopoverMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolvePopoverMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolvePopoverMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolvePopoverMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePopoverMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePopoverMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolvePopoverMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolvePopoverMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolvePopoverMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolvePopoverMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolvePopoverMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolvePopoverMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolvePopoverMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolvePopoverMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolvePopoverMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolvePopoverMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolvePopoverMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePopoverMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePopoverMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePopoverMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolvePopoverMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolvePopoverMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolvePopoverMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolvePopoverMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolvePopoverMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolvePopoverMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolvePopoverMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolvePopoverMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolvePopoverMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolvePopoverMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolvePopoverMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolvePopoverMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolvePopoverMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePopoverMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolvePopoverMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolvePopoverMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolvePopoverMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolvePopoverMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolvePopoverMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolvePopoverMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolvePopoverMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolvePopoverMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePopoverMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePopoverMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolvePopoverMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolvePopoverMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolvePopoverMethod "popdown" o = PopoverPopdownMethodInfo
    ResolvePopoverMethod "popup" o = PopoverPopupMethodInfo
    ResolvePopoverMethod "present" o = PopoverPresentMethodInfo
    ResolvePopoverMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolvePopoverMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolvePopoverMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolvePopoverMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolvePopoverMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePopoverMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePopoverMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolvePopoverMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolvePopoverMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolvePopoverMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolvePopoverMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolvePopoverMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolvePopoverMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolvePopoverMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePopoverMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolvePopoverMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolvePopoverMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolvePopoverMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolvePopoverMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePopoverMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePopoverMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePopoverMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolvePopoverMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolvePopoverMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolvePopoverMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolvePopoverMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolvePopoverMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePopoverMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolvePopoverMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolvePopoverMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolvePopoverMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolvePopoverMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolvePopoverMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolvePopoverMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePopoverMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolvePopoverMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolvePopoverMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolvePopoverMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolvePopoverMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolvePopoverMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolvePopoverMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolvePopoverMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolvePopoverMethod "getAutohide" o = PopoverGetAutohideMethodInfo
    ResolvePopoverMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolvePopoverMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolvePopoverMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolvePopoverMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolvePopoverMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolvePopoverMethod "getCascadePopdown" o = PopoverGetCascadePopdownMethodInfo
    ResolvePopoverMethod "getChild" o = PopoverGetChildMethodInfo
    ResolvePopoverMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolvePopoverMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolvePopoverMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolvePopoverMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolvePopoverMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolvePopoverMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolvePopoverMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePopoverMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolvePopoverMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolvePopoverMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolvePopoverMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolvePopoverMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolvePopoverMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolvePopoverMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolvePopoverMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolvePopoverMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolvePopoverMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolvePopoverMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolvePopoverMethod "getHasArrow" o = PopoverGetHasArrowMethodInfo
    ResolvePopoverMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolvePopoverMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolvePopoverMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolvePopoverMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolvePopoverMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolvePopoverMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolvePopoverMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolvePopoverMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolvePopoverMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolvePopoverMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolvePopoverMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolvePopoverMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolvePopoverMethod "getMnemonicsVisible" o = PopoverGetMnemonicsVisibleMethodInfo
    ResolvePopoverMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolvePopoverMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolvePopoverMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolvePopoverMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolvePopoverMethod "getOffset" o = PopoverGetOffsetMethodInfo
    ResolvePopoverMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolvePopoverMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolvePopoverMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolvePopoverMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolvePopoverMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolvePopoverMethod "getPointingTo" o = PopoverGetPointingToMethodInfo
    ResolvePopoverMethod "getPosition" o = PopoverGetPositionMethodInfo
    ResolvePopoverMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolvePopoverMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolvePopoverMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolvePopoverMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePopoverMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePopoverMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolvePopoverMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolvePopoverMethod "getRenderer" o = Gtk.Native.NativeGetRendererMethodInfo
    ResolvePopoverMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolvePopoverMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolvePopoverMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolvePopoverMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolvePopoverMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolvePopoverMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolvePopoverMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolvePopoverMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolvePopoverMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolvePopoverMethod "getSurface" o = Gtk.Native.NativeGetSurfaceMethodInfo
    ResolvePopoverMethod "getSurfaceTransform" o = Gtk.Native.NativeGetSurfaceTransformMethodInfo
    ResolvePopoverMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolvePopoverMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolvePopoverMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolvePopoverMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolvePopoverMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolvePopoverMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolvePopoverMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolvePopoverMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolvePopoverMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolvePopoverMethod "setAutohide" o = PopoverSetAutohideMethodInfo
    ResolvePopoverMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolvePopoverMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolvePopoverMethod "setCascadePopdown" o = PopoverSetCascadePopdownMethodInfo
    ResolvePopoverMethod "setChild" o = PopoverSetChildMethodInfo
    ResolvePopoverMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolvePopoverMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolvePopoverMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolvePopoverMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolvePopoverMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePopoverMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePopoverMethod "setDefaultWidget" o = PopoverSetDefaultWidgetMethodInfo
    ResolvePopoverMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolvePopoverMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolvePopoverMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolvePopoverMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolvePopoverMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolvePopoverMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolvePopoverMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolvePopoverMethod "setHasArrow" o = PopoverSetHasArrowMethodInfo
    ResolvePopoverMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolvePopoverMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolvePopoverMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolvePopoverMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolvePopoverMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolvePopoverMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolvePopoverMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolvePopoverMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolvePopoverMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolvePopoverMethod "setMnemonicsVisible" o = PopoverSetMnemonicsVisibleMethodInfo
    ResolvePopoverMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolvePopoverMethod "setOffset" o = PopoverSetOffsetMethodInfo
    ResolvePopoverMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolvePopoverMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolvePopoverMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolvePopoverMethod "setPointingTo" o = PopoverSetPointingToMethodInfo
    ResolvePopoverMethod "setPosition" o = PopoverSetPositionMethodInfo
    ResolvePopoverMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePopoverMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolvePopoverMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolvePopoverMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolvePopoverMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolvePopoverMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolvePopoverMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolvePopoverMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolvePopoverMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolvePopoverMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolvePopoverMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolvePopoverMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePopoverMethod t Popover, O.OverloadedMethod info Popover p) => OL.IsLabel t (Popover -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePopoverMethod t Popover, O.OverloadedMethod info Popover p, R.HasField t Popover p) => R.HasField t Popover p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePopoverMethod t Popover, O.OverloadedMethodInfo info Popover) => OL.IsLabel t (O.MethodProxy info Popover) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Popover::activate-default
-- | Emitted whend the user activates the default widget.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default binding for this signal is \<kbd>Enter\<\/kbd>.
type PopoverActivateDefaultCallback =
    IO ()

type C_PopoverActivateDefaultCallback =
    Ptr Popover ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_PopoverActivateDefaultCallback`.
foreign import ccall "wrapper"
    mk_PopoverActivateDefaultCallback :: C_PopoverActivateDefaultCallback -> IO (FunPtr C_PopoverActivateDefaultCallback)

wrap_PopoverActivateDefaultCallback :: 
    GObject a => (a -> PopoverActivateDefaultCallback) ->
    C_PopoverActivateDefaultCallback
wrap_PopoverActivateDefaultCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [activateDefault](#signal:activateDefault) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' popover #activateDefault callback
-- @
-- 
-- 
onPopoverActivateDefault :: (IsPopover a, MonadIO m) => a -> ((?self :: a) => PopoverActivateDefaultCallback) -> m SignalHandlerId
onPopoverActivateDefault obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PopoverActivateDefaultCallback wrapped
    wrapped'' <- mk_PopoverActivateDefaultCallback wrapped'
    connectSignalFunPtr obj "activate-default" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activateDefault](#signal:activateDefault) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' popover #activateDefault callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterPopoverActivateDefault :: (IsPopover a, MonadIO m) => a -> ((?self :: a) => PopoverActivateDefaultCallback) -> m SignalHandlerId
afterPopoverActivateDefault obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PopoverActivateDefaultCallback wrapped
    wrapped'' <- mk_PopoverActivateDefaultCallback wrapped'
    connectSignalFunPtr obj "activate-default" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data PopoverActivateDefaultSignalInfo
instance SignalInfo PopoverActivateDefaultSignalInfo where
    type HaskellCallbackType PopoverActivateDefaultSignalInfo = PopoverActivateDefaultCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_PopoverActivateDefaultCallback cb
        cb'' <- mk_PopoverActivateDefaultCallback cb'
        connectSignalFunPtr obj "activate-default" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover::activate-default"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#g:signal:activateDefault"})

#endif

-- signal Popover::closed
-- | Emitted when the popover is closed.
type PopoverClosedCallback =
    IO ()

type C_PopoverClosedCallback =
    Ptr Popover ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_PopoverClosedCallback`.
foreign import ccall "wrapper"
    mk_PopoverClosedCallback :: C_PopoverClosedCallback -> IO (FunPtr C_PopoverClosedCallback)

wrap_PopoverClosedCallback :: 
    GObject a => (a -> PopoverClosedCallback) ->
    C_PopoverClosedCallback
wrap_PopoverClosedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [closed](#signal:closed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' popover #closed callback
-- @
-- 
-- 
onPopoverClosed :: (IsPopover a, MonadIO m) => a -> ((?self :: a) => PopoverClosedCallback) -> m SignalHandlerId
onPopoverClosed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PopoverClosedCallback wrapped
    wrapped'' <- mk_PopoverClosedCallback wrapped'
    connectSignalFunPtr obj "closed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [closed](#signal:closed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' popover #closed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterPopoverClosed :: (IsPopover a, MonadIO m) => a -> ((?self :: a) => PopoverClosedCallback) -> m SignalHandlerId
afterPopoverClosed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_PopoverClosedCallback wrapped
    wrapped'' <- mk_PopoverClosedCallback wrapped'
    connectSignalFunPtr obj "closed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data PopoverClosedSignalInfo
instance SignalInfo PopoverClosedSignalInfo where
    type HaskellCallbackType PopoverClosedSignalInfo = PopoverClosedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_PopoverClosedCallback cb
        cb'' <- mk_PopoverClosedCallback cb'
        connectSignalFunPtr obj "closed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover::closed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#g:signal:closed"})

#endif

-- VVV Prop "autohide"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@autohide@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' popover #autohide
-- @
getPopoverAutohide :: (MonadIO m, IsPopover o) => o -> m Bool
getPopoverAutohide obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "autohide"

-- | Set the value of the “@autohide@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' popover [ #autohide 'Data.GI.Base.Attributes.:=' value ]
-- @
setPopoverAutohide :: (MonadIO m, IsPopover o) => o -> Bool -> m ()
setPopoverAutohide obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "autohide" val

-- | Construct a `GValueConstruct` with valid value for the “@autohide@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPopoverAutohide :: (IsPopover o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPopoverAutohide val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "autohide" val

#if defined(ENABLE_OVERLOADING)
data PopoverAutohidePropertyInfo
instance AttrInfo PopoverAutohidePropertyInfo where
    type AttrAllowedOps PopoverAutohidePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PopoverAutohidePropertyInfo = IsPopover
    type AttrSetTypeConstraint PopoverAutohidePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PopoverAutohidePropertyInfo = (~) Bool
    type AttrTransferType PopoverAutohidePropertyInfo = Bool
    type AttrGetType PopoverAutohidePropertyInfo = Bool
    type AttrLabel PopoverAutohidePropertyInfo = "autohide"
    type AttrOrigin PopoverAutohidePropertyInfo = Popover
    attrGet = getPopoverAutohide
    attrSet = setPopoverAutohide
    attrTransfer _ v = do
        return v
    attrConstruct = constructPopoverAutohide
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.autohide"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#g:attr:autohide"
        })
#endif

-- VVV Prop "cascade-popdown"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@cascade-popdown@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' popover #cascadePopdown
-- @
getPopoverCascadePopdown :: (MonadIO m, IsPopover o) => o -> m Bool
getPopoverCascadePopdown obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "cascade-popdown"

-- | Set the value of the “@cascade-popdown@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' popover [ #cascadePopdown 'Data.GI.Base.Attributes.:=' value ]
-- @
setPopoverCascadePopdown :: (MonadIO m, IsPopover o) => o -> Bool -> m ()
setPopoverCascadePopdown obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "cascade-popdown" val

-- | Construct a `GValueConstruct` with valid value for the “@cascade-popdown@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPopoverCascadePopdown :: (IsPopover o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPopoverCascadePopdown val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "cascade-popdown" val

#if defined(ENABLE_OVERLOADING)
data PopoverCascadePopdownPropertyInfo
instance AttrInfo PopoverCascadePopdownPropertyInfo where
    type AttrAllowedOps PopoverCascadePopdownPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PopoverCascadePopdownPropertyInfo = IsPopover
    type AttrSetTypeConstraint PopoverCascadePopdownPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PopoverCascadePopdownPropertyInfo = (~) Bool
    type AttrTransferType PopoverCascadePopdownPropertyInfo = Bool
    type AttrGetType PopoverCascadePopdownPropertyInfo = Bool
    type AttrLabel PopoverCascadePopdownPropertyInfo = "cascade-popdown"
    type AttrOrigin PopoverCascadePopdownPropertyInfo = Popover
    attrGet = getPopoverCascadePopdown
    attrSet = setPopoverCascadePopdown
    attrTransfer _ v = do
        return v
    attrConstruct = constructPopoverCascadePopdown
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.cascadePopdown"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#g:attr:cascadePopdown"
        })
#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' popover #child
-- @
getPopoverChild :: (MonadIO m, IsPopover o) => o -> m (Maybe Gtk.Widget.Widget)
getPopoverChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' popover [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setPopoverChild :: (MonadIO m, IsPopover o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setPopoverChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPopoverChild :: (IsPopover o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructPopoverChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearPopoverChild :: (MonadIO m, IsPopover o) => o -> m ()
clearPopoverChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data PopoverChildPropertyInfo
instance AttrInfo PopoverChildPropertyInfo where
    type AttrAllowedOps PopoverChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PopoverChildPropertyInfo = IsPopover
    type AttrSetTypeConstraint PopoverChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint PopoverChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType PopoverChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType PopoverChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel PopoverChildPropertyInfo = "child"
    type AttrOrigin PopoverChildPropertyInfo = Popover
    attrGet = getPopoverChild
    attrSet = setPopoverChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructPopoverChild
    attrClear = clearPopoverChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#g:attr:child"
        })
#endif

-- VVV Prop "default-widget"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Get the value of the “@default-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' popover #defaultWidget
-- @
getPopoverDefaultWidget :: (MonadIO m, IsPopover o) => o -> m (Maybe Gtk.Widget.Widget)
getPopoverDefaultWidget obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "default-widget" Gtk.Widget.Widget

-- | Set the value of the “@default-widget@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' popover [ #defaultWidget 'Data.GI.Base.Attributes.:=' value ]
-- @
setPopoverDefaultWidget :: (MonadIO m, IsPopover o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setPopoverDefaultWidget obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "default-widget" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@default-widget@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPopoverDefaultWidget :: (IsPopover o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructPopoverDefaultWidget val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "default-widget" (P.Just val)

-- | Set the value of the “@default-widget@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #defaultWidget
-- @
clearPopoverDefaultWidget :: (MonadIO m, IsPopover o) => o -> m ()
clearPopoverDefaultWidget obj = liftIO $ B.Properties.setObjectPropertyObject obj "default-widget" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data PopoverDefaultWidgetPropertyInfo
instance AttrInfo PopoverDefaultWidgetPropertyInfo where
    type AttrAllowedOps PopoverDefaultWidgetPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PopoverDefaultWidgetPropertyInfo = IsPopover
    type AttrSetTypeConstraint PopoverDefaultWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint PopoverDefaultWidgetPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType PopoverDefaultWidgetPropertyInfo = Gtk.Widget.Widget
    type AttrGetType PopoverDefaultWidgetPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel PopoverDefaultWidgetPropertyInfo = "default-widget"
    type AttrOrigin PopoverDefaultWidgetPropertyInfo = Popover
    attrGet = getPopoverDefaultWidget
    attrSet = setPopoverDefaultWidget
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructPopoverDefaultWidget
    attrClear = clearPopoverDefaultWidget
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.defaultWidget"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#g:attr:defaultWidget"
        })
#endif

-- VVV Prop "has-arrow"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@has-arrow@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' popover #hasArrow
-- @
getPopoverHasArrow :: (MonadIO m, IsPopover o) => o -> m Bool
getPopoverHasArrow obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-arrow"

-- | Set the value of the “@has-arrow@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' popover [ #hasArrow 'Data.GI.Base.Attributes.:=' value ]
-- @
setPopoverHasArrow :: (MonadIO m, IsPopover o) => o -> Bool -> m ()
setPopoverHasArrow obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "has-arrow" val

-- | Construct a `GValueConstruct` with valid value for the “@has-arrow@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPopoverHasArrow :: (IsPopover o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPopoverHasArrow val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-arrow" val

#if defined(ENABLE_OVERLOADING)
data PopoverHasArrowPropertyInfo
instance AttrInfo PopoverHasArrowPropertyInfo where
    type AttrAllowedOps PopoverHasArrowPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PopoverHasArrowPropertyInfo = IsPopover
    type AttrSetTypeConstraint PopoverHasArrowPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PopoverHasArrowPropertyInfo = (~) Bool
    type AttrTransferType PopoverHasArrowPropertyInfo = Bool
    type AttrGetType PopoverHasArrowPropertyInfo = Bool
    type AttrLabel PopoverHasArrowPropertyInfo = "has-arrow"
    type AttrOrigin PopoverHasArrowPropertyInfo = Popover
    attrGet = getPopoverHasArrow
    attrSet = setPopoverHasArrow
    attrTransfer _ v = do
        return v
    attrConstruct = constructPopoverHasArrow
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.hasArrow"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#g:attr:hasArrow"
        })
#endif

-- VVV Prop "mnemonics-visible"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@mnemonics-visible@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' popover #mnemonicsVisible
-- @
getPopoverMnemonicsVisible :: (MonadIO m, IsPopover o) => o -> m Bool
getPopoverMnemonicsVisible obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "mnemonics-visible"

-- | Set the value of the “@mnemonics-visible@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' popover [ #mnemonicsVisible 'Data.GI.Base.Attributes.:=' value ]
-- @
setPopoverMnemonicsVisible :: (MonadIO m, IsPopover o) => o -> Bool -> m ()
setPopoverMnemonicsVisible obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "mnemonics-visible" val

-- | Construct a `GValueConstruct` with valid value for the “@mnemonics-visible@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPopoverMnemonicsVisible :: (IsPopover o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructPopoverMnemonicsVisible val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "mnemonics-visible" val

#if defined(ENABLE_OVERLOADING)
data PopoverMnemonicsVisiblePropertyInfo
instance AttrInfo PopoverMnemonicsVisiblePropertyInfo where
    type AttrAllowedOps PopoverMnemonicsVisiblePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PopoverMnemonicsVisiblePropertyInfo = IsPopover
    type AttrSetTypeConstraint PopoverMnemonicsVisiblePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint PopoverMnemonicsVisiblePropertyInfo = (~) Bool
    type AttrTransferType PopoverMnemonicsVisiblePropertyInfo = Bool
    type AttrGetType PopoverMnemonicsVisiblePropertyInfo = Bool
    type AttrLabel PopoverMnemonicsVisiblePropertyInfo = "mnemonics-visible"
    type AttrOrigin PopoverMnemonicsVisiblePropertyInfo = Popover
    attrGet = getPopoverMnemonicsVisible
    attrSet = setPopoverMnemonicsVisible
    attrTransfer _ v = do
        return v
    attrConstruct = constructPopoverMnemonicsVisible
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.mnemonicsVisible"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#g:attr:mnemonicsVisible"
        })
#endif

-- VVV Prop "pointing-to"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Rectangle"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Just True)

-- | Get the value of the “@pointing-to@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' popover #pointingTo
-- @
getPopoverPointingTo :: (MonadIO m, IsPopover o) => o -> m (Maybe Gdk.Rectangle.Rectangle)
getPopoverPointingTo obj = MIO.liftIO $ B.Properties.getObjectPropertyBoxed obj "pointing-to" Gdk.Rectangle.Rectangle

-- | Set the value of the “@pointing-to@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' popover [ #pointingTo 'Data.GI.Base.Attributes.:=' value ]
-- @
setPopoverPointingTo :: (MonadIO m, IsPopover o) => o -> Gdk.Rectangle.Rectangle -> m ()
setPopoverPointingTo obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBoxed obj "pointing-to" (Just val)

-- | Construct a `GValueConstruct` with valid value for the “@pointing-to@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPopoverPointingTo :: (IsPopover o, MIO.MonadIO m) => Gdk.Rectangle.Rectangle -> m (GValueConstruct o)
constructPopoverPointingTo val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "pointing-to" (P.Just val)

-- | Set the value of the “@pointing-to@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #pointingTo
-- @
clearPopoverPointingTo :: (MonadIO m, IsPopover o) => o -> m ()
clearPopoverPointingTo obj = liftIO $ B.Properties.setObjectPropertyBoxed obj "pointing-to" (Nothing :: Maybe Gdk.Rectangle.Rectangle)

#if defined(ENABLE_OVERLOADING)
data PopoverPointingToPropertyInfo
instance AttrInfo PopoverPointingToPropertyInfo where
    type AttrAllowedOps PopoverPointingToPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint PopoverPointingToPropertyInfo = IsPopover
    type AttrSetTypeConstraint PopoverPointingToPropertyInfo = (~) Gdk.Rectangle.Rectangle
    type AttrTransferTypeConstraint PopoverPointingToPropertyInfo = (~) Gdk.Rectangle.Rectangle
    type AttrTransferType PopoverPointingToPropertyInfo = Gdk.Rectangle.Rectangle
    type AttrGetType PopoverPointingToPropertyInfo = (Maybe Gdk.Rectangle.Rectangle)
    type AttrLabel PopoverPointingToPropertyInfo = "pointing-to"
    type AttrOrigin PopoverPointingToPropertyInfo = Popover
    attrGet = getPopoverPointingTo
    attrSet = setPopoverPointingTo
    attrTransfer _ v = do
        return v
    attrConstruct = constructPopoverPointingTo
    attrClear = clearPopoverPointingTo
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.pointingTo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#g:attr:pointingTo"
        })
#endif

-- VVV Prop "position"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PositionType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' popover #position
-- @
getPopoverPosition :: (MonadIO m, IsPopover o) => o -> m Gtk.Enums.PositionType
getPopoverPosition obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "position"

-- | Set the value of the “@position@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' popover [ #position 'Data.GI.Base.Attributes.:=' value ]
-- @
setPopoverPosition :: (MonadIO m, IsPopover o) => o -> Gtk.Enums.PositionType -> m ()
setPopoverPosition obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "position" val

-- | Construct a `GValueConstruct` with valid value for the “@position@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructPopoverPosition :: (IsPopover o, MIO.MonadIO m) => Gtk.Enums.PositionType -> m (GValueConstruct o)
constructPopoverPosition val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "position" val

#if defined(ENABLE_OVERLOADING)
data PopoverPositionPropertyInfo
instance AttrInfo PopoverPositionPropertyInfo where
    type AttrAllowedOps PopoverPositionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint PopoverPositionPropertyInfo = IsPopover
    type AttrSetTypeConstraint PopoverPositionPropertyInfo = (~) Gtk.Enums.PositionType
    type AttrTransferTypeConstraint PopoverPositionPropertyInfo = (~) Gtk.Enums.PositionType
    type AttrTransferType PopoverPositionPropertyInfo = Gtk.Enums.PositionType
    type AttrGetType PopoverPositionPropertyInfo = Gtk.Enums.PositionType
    type AttrLabel PopoverPositionPropertyInfo = "position"
    type AttrOrigin PopoverPositionPropertyInfo = Popover
    attrGet = getPopoverPosition
    attrSet = setPopoverPosition
    attrTransfer _ v = do
        return v
    attrConstruct = constructPopoverPosition
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.position"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#g:attr:position"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Popover
type instance O.AttributeList Popover = PopoverAttributeList
type PopoverAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("autohide", PopoverAutohidePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("cascadePopdown", PopoverCascadePopdownPropertyInfo), '("child", PopoverChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("defaultWidget", PopoverDefaultWidgetPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasArrow", PopoverHasArrowPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("mnemonicsVisible", PopoverMnemonicsVisiblePropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("pointingTo", PopoverPointingToPropertyInfo), '("position", PopoverPositionPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
popoverAutohide :: AttrLabelProxy "autohide"
popoverAutohide = AttrLabelProxy

popoverCascadePopdown :: AttrLabelProxy "cascadePopdown"
popoverCascadePopdown = AttrLabelProxy

popoverChild :: AttrLabelProxy "child"
popoverChild = AttrLabelProxy

popoverDefaultWidget :: AttrLabelProxy "defaultWidget"
popoverDefaultWidget = AttrLabelProxy

popoverHasArrow :: AttrLabelProxy "hasArrow"
popoverHasArrow = AttrLabelProxy

popoverMnemonicsVisible :: AttrLabelProxy "mnemonicsVisible"
popoverMnemonicsVisible = AttrLabelProxy

popoverPointingTo :: AttrLabelProxy "pointingTo"
popoverPointingTo = AttrLabelProxy

popoverPosition :: AttrLabelProxy "position"
popoverPosition = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Popover = PopoverSignalList
type PopoverSignalList = ('[ '("activateDefault", PopoverActivateDefaultSignalInfo), '("closed", PopoverClosedSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Popover::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Popover" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_new" gtk_popover_new :: 
    IO (Ptr Popover)

-- | Creates a new @GtkPopover@.
popoverNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Popover
    -- ^ __Returns:__ the new @GtkPopover@
popoverNew  = liftIO $ do
    result <- gtk_popover_new
    checkUnexpectedReturnNULL "popoverNew" result
    result' <- (newObject Popover) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Popover::get_autohide
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_get_autohide" gtk_popover_get_autohide :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    IO CInt

-- | Returns whether the popover is modal.
-- 
-- See 'GI.Gtk.Objects.Popover.popoverSetAutohide' for the
-- implications of this.
popoverGetAutohide ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@popover@/ is modal
popoverGetAutohide popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    result <- gtk_popover_get_autohide popover'
    let result' = (/= 0) result
    touchManagedPtr popover
    return result'

#if defined(ENABLE_OVERLOADING)
data PopoverGetAutohideMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverGetAutohideMethodInfo a signature where
    overloadedMethod = popoverGetAutohide

instance O.OverloadedMethodInfo PopoverGetAutohideMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverGetAutohide",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverGetAutohide"
        })


#endif

-- method Popover::get_cascade_popdown
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_get_cascade_popdown" gtk_popover_get_cascade_popdown :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    IO CInt

-- | Returns whether the popover will close after a modal child is closed.
popoverGetCascadePopdown ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@popover@/ will close after a modal child.
popoverGetCascadePopdown popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    result <- gtk_popover_get_cascade_popdown popover'
    let result' = (/= 0) result
    touchManagedPtr popover
    return result'

#if defined(ENABLE_OVERLOADING)
data PopoverGetCascadePopdownMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverGetCascadePopdownMethodInfo a signature where
    overloadedMethod = popoverGetCascadePopdown

instance O.OverloadedMethodInfo PopoverGetCascadePopdownMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverGetCascadePopdown",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverGetCascadePopdown"
        })


#endif

-- method Popover::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_get_child" gtk_popover_get_child :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@popover@/.
popoverGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@popover@/
popoverGetChild popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    result <- gtk_popover_get_child popover'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr popover
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data PopoverGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverGetChildMethodInfo a signature where
    overloadedMethod = popoverGetChild

instance O.OverloadedMethodInfo PopoverGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverGetChild"
        })


#endif

-- method Popover::get_has_arrow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_get_has_arrow" gtk_popover_get_has_arrow :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    IO CInt

-- | Gets whether this popover is showing an arrow
-- pointing at the widget that it is relative to.
popoverGetHasArrow ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> m Bool
    -- ^ __Returns:__ whether the popover has an arrow
popoverGetHasArrow popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    result <- gtk_popover_get_has_arrow popover'
    let result' = (/= 0) result
    touchManagedPtr popover
    return result'

#if defined(ENABLE_OVERLOADING)
data PopoverGetHasArrowMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverGetHasArrowMethodInfo a signature where
    overloadedMethod = popoverGetHasArrow

instance O.OverloadedMethodInfo PopoverGetHasArrowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverGetHasArrow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverGetHasArrow"
        })


#endif

-- method Popover::get_mnemonics_visible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_get_mnemonics_visible" gtk_popover_get_mnemonics_visible :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    IO CInt

-- | Gets whether mnemonics are visible.
popoverGetMnemonicsVisible ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if mnemonics are supposed to be visible
    --   in this popover
popoverGetMnemonicsVisible popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    result <- gtk_popover_get_mnemonics_visible popover'
    let result' = (/= 0) result
    touchManagedPtr popover
    return result'

#if defined(ENABLE_OVERLOADING)
data PopoverGetMnemonicsVisibleMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverGetMnemonicsVisibleMethodInfo a signature where
    overloadedMethod = popoverGetMnemonicsVisible

instance O.OverloadedMethodInfo PopoverGetMnemonicsVisibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverGetMnemonicsVisible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverGetMnemonicsVisible"
        })


#endif

-- method Popover::get_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_offset"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location for the x_offset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "y_offset"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a location for the y_offset"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_get_offset" gtk_popover_get_offset :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    Ptr Int32 ->                            -- x_offset : TBasicType TInt
    Ptr Int32 ->                            -- y_offset : TBasicType TInt
    IO ()

-- | Gets the offset previous set with [method/@gtk@/.Popover.@/set_offset()/@].
popoverGetOffset ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> m ((Int32, Int32))
popoverGetOffset popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    xOffset <- allocMem :: IO (Ptr Int32)
    yOffset <- allocMem :: IO (Ptr Int32)
    gtk_popover_get_offset popover' xOffset yOffset
    xOffset' <- peek xOffset
    yOffset' <- peek yOffset
    touchManagedPtr popover
    freeMem xOffset
    freeMem yOffset
    return (xOffset', yOffset')

#if defined(ENABLE_OVERLOADING)
data PopoverGetOffsetMethodInfo
instance (signature ~ (m ((Int32, Int32))), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverGetOffsetMethodInfo a signature where
    overloadedMethod = popoverGetOffset

instance O.OverloadedMethodInfo PopoverGetOffsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverGetOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverGetOffset"
        })


#endif

-- method Popover::get_pointing_to
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rect"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the rectangle"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_get_pointing_to" gtk_popover_get_pointing_to :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    Ptr Gdk.Rectangle.Rectangle ->          -- rect : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO CInt

-- | Gets the rectangle that the popover points to.
-- 
-- If a rectangle to point to has been set, this function will
-- return 'P.True' and fill in /@rect@/ with such rectangle, otherwise
-- it will return 'P.False' and fill in /@rect@/ with the parent
-- widget coordinates.
popoverGetPointingTo ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> m ((Bool, Gdk.Rectangle.Rectangle))
    -- ^ __Returns:__ 'P.True' if a rectangle to point to was set.
popoverGetPointingTo popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    rect <- SP.callocBoxedBytes 16 :: IO (Ptr Gdk.Rectangle.Rectangle)
    result <- gtk_popover_get_pointing_to popover' rect
    let result' = (/= 0) result
    rect' <- (wrapBoxed Gdk.Rectangle.Rectangle) rect
    touchManagedPtr popover
    return (result', rect')

#if defined(ENABLE_OVERLOADING)
data PopoverGetPointingToMethodInfo
instance (signature ~ (m ((Bool, Gdk.Rectangle.Rectangle))), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverGetPointingToMethodInfo a signature where
    overloadedMethod = popoverGetPointingTo

instance O.OverloadedMethodInfo PopoverGetPointingToMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverGetPointingTo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverGetPointingTo"
        })


#endif

-- method Popover::get_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "PositionType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_get_position" gtk_popover_get_position :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    IO CUInt

-- | Returns the preferred position of /@popover@/.
popoverGetPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> m Gtk.Enums.PositionType
    -- ^ __Returns:__ The preferred position.
popoverGetPosition popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    result <- gtk_popover_get_position popover'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr popover
    return result'

#if defined(ENABLE_OVERLOADING)
data PopoverGetPositionMethodInfo
instance (signature ~ (m Gtk.Enums.PositionType), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverGetPositionMethodInfo a signature where
    overloadedMethod = popoverGetPosition

instance O.OverloadedMethodInfo PopoverGetPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverGetPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverGetPosition"
        })


#endif

-- method Popover::popdown
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_popdown" gtk_popover_popdown :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    IO ()

-- | Pops /@popover@/ down.
-- 
-- This may have the side-effect of closing a parent popover
-- as well. See [Popover:cascadePopdown]("GI.Gtk.Objects.Popover#g:attr:cascadePopdown").
popoverPopdown ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> m ()
popoverPopdown popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    gtk_popover_popdown popover'
    touchManagedPtr popover
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverPopdownMethodInfo
instance (signature ~ (m ()), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverPopdownMethodInfo a signature where
    overloadedMethod = popoverPopdown

instance O.OverloadedMethodInfo PopoverPopdownMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverPopdown",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverPopdown"
        })


#endif

-- method Popover::popup
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_popup" gtk_popover_popup :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    IO ()

-- | Pops /@popover@/ up.
popoverPopup ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> m ()
popoverPopup popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    gtk_popover_popup popover'
    touchManagedPtr popover
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverPopupMethodInfo
instance (signature ~ (m ()), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverPopupMethodInfo a signature where
    overloadedMethod = popoverPopup

instance O.OverloadedMethodInfo PopoverPopupMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverPopup",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverPopup"
        })


#endif

-- method Popover::present
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_present" gtk_popover_present :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    IO ()

-- | Allocate a size for the @GtkPopover@.
-- 
-- This function needs to be called in size-allocate by widgets
-- who have a @GtkPopover@ as child. When using a layout manager,
-- this is happening automatically.
-- 
-- To make a popover appear on screen, use 'GI.Gtk.Objects.Popover.popoverPopup'.
popoverPresent ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> m ()
popoverPresent popover = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    gtk_popover_present popover'
    touchManagedPtr popover
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverPresentMethodInfo
instance (signature ~ (m ()), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverPresentMethodInfo a signature where
    overloadedMethod = popoverPresent

instance O.OverloadedMethodInfo PopoverPresentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverPresent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverPresent"
        })


#endif

-- method Popover::set_autohide
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "autohide"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE to dismiss the popover on outside clicks"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_set_autohide" gtk_popover_set_autohide :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    CInt ->                                 -- autohide : TBasicType TBoolean
    IO ()

-- | Sets whether /@popover@/ is modal.
-- 
-- A modal popover will grab the keyboard focus on it when being
-- displayed. Focus will wrap around within the popover. Clicking
-- outside the popover area or pressing Esc will dismiss the popover.
-- 
-- Called this function on an already showing popup with a new
-- autohide value different from the current one, will cause the
-- popup to be hidden.
popoverSetAutohide ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> Bool
    -- ^ /@autohide@/: 'P.True' to dismiss the popover on outside clicks
    -> m ()
popoverSetAutohide popover autohide = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    let autohide' = (P.fromIntegral . P.fromEnum) autohide
    gtk_popover_set_autohide popover' autohide'
    touchManagedPtr popover
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverSetAutohideMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverSetAutohideMethodInfo a signature where
    overloadedMethod = popoverSetAutohide

instance O.OverloadedMethodInfo PopoverSetAutohideMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverSetAutohide",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverSetAutohide"
        })


#endif

-- method Popover::set_cascade_popdown
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cascade_popdown"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "%TRUE if the popover should follow a child closing"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_set_cascade_popdown" gtk_popover_set_cascade_popdown :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    CInt ->                                 -- cascade_popdown : TBasicType TBoolean
    IO ()

-- | If /@cascadePopdown@/ is 'P.True', the popover will be
-- closed when a child modal popover is closed.
-- 
-- If 'P.False', /@popover@/ will stay visible.
popoverSetCascadePopdown ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: A @GtkPopover@
    -> Bool
    -- ^ /@cascadePopdown@/: 'P.True' if the popover should follow a child closing
    -> m ()
popoverSetCascadePopdown popover cascadePopdown = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    let cascadePopdown' = (P.fromIntegral . P.fromEnum) cascadePopdown
    gtk_popover_set_cascade_popdown popover' cascadePopdown'
    touchManagedPtr popover
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverSetCascadePopdownMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverSetCascadePopdownMethodInfo a signature where
    overloadedMethod = popoverSetCascadePopdown

instance O.OverloadedMethodInfo PopoverSetCascadePopdownMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverSetCascadePopdown",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverSetCascadePopdown"
        })


#endif

-- method Popover::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_set_child" gtk_popover_set_child :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@popover@/.
popoverSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
popoverSetChild popover child = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_popover_set_child popover' maybeChild
    touchManagedPtr popover
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsPopover a, Gtk.Widget.IsWidget b) => O.OverloadedMethod PopoverSetChildMethodInfo a signature where
    overloadedMethod = popoverSetChild

instance O.OverloadedMethodInfo PopoverSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverSetChild"
        })


#endif

-- method Popover::set_default_widget
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "widget"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a child widget of @popover to set as\n  the default, or %NULL to unset the default widget for the popover"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_set_default_widget" gtk_popover_set_default_widget :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    Ptr Gtk.Widget.Widget ->                -- widget : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the default widget of a @GtkPopover@.
-- 
-- The default widget is the widget that’s activated when the user
-- presses Enter in a dialog (for example). This function sets or
-- unsets the default widget for a @GtkPopover@.
popoverSetDefaultWidget ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> Maybe (b)
    -- ^ /@widget@/: a child widget of /@popover@/ to set as
    --   the default, or 'P.Nothing' to unset the default widget for the popover
    -> m ()
popoverSetDefaultWidget popover widget = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    maybeWidget <- case widget of
        Nothing -> return FP.nullPtr
        Just jWidget -> do
            jWidget' <- unsafeManagedPtrCastPtr jWidget
            return jWidget'
    gtk_popover_set_default_widget popover' maybeWidget
    touchManagedPtr popover
    whenJust widget touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverSetDefaultWidgetMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsPopover a, Gtk.Widget.IsWidget b) => O.OverloadedMethod PopoverSetDefaultWidgetMethodInfo a signature where
    overloadedMethod = popoverSetDefaultWidget

instance O.OverloadedMethodInfo PopoverSetDefaultWidgetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverSetDefaultWidget",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverSetDefaultWidget"
        })


#endif

-- method Popover::set_has_arrow
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "has_arrow"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to draw an arrow"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_set_has_arrow" gtk_popover_set_has_arrow :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    CInt ->                                 -- has_arrow : TBasicType TBoolean
    IO ()

-- | Sets whether this popover should draw an arrow
-- pointing at the widget it is relative to.
popoverSetHasArrow ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> Bool
    -- ^ /@hasArrow@/: 'P.True' to draw an arrow
    -> m ()
popoverSetHasArrow popover hasArrow = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    let hasArrow' = (P.fromIntegral . P.fromEnum) hasArrow
    gtk_popover_set_has_arrow popover' hasArrow'
    touchManagedPtr popover
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverSetHasArrowMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverSetHasArrowMethodInfo a signature where
    overloadedMethod = popoverSetHasArrow

instance O.OverloadedMethodInfo PopoverSetHasArrowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverSetHasArrow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverSetHasArrow"
        })


#endif

-- method Popover::set_mnemonics_visible
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mnemonics_visible"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the new value" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_set_mnemonics_visible" gtk_popover_set_mnemonics_visible :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    CInt ->                                 -- mnemonics_visible : TBasicType TBoolean
    IO ()

-- | Sets whether mnemonics should be visible.
popoverSetMnemonicsVisible ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> Bool
    -- ^ /@mnemonicsVisible@/: the new value
    -> m ()
popoverSetMnemonicsVisible popover mnemonicsVisible = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    let mnemonicsVisible' = (P.fromIntegral . P.fromEnum) mnemonicsVisible
    gtk_popover_set_mnemonics_visible popover' mnemonicsVisible'
    touchManagedPtr popover
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverSetMnemonicsVisibleMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverSetMnemonicsVisibleMethodInfo a signature where
    overloadedMethod = popoverSetMnemonicsVisible

instance O.OverloadedMethodInfo PopoverSetMnemonicsVisibleMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverSetMnemonicsVisible",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverSetMnemonicsVisible"
        })


#endif

-- method Popover::set_offset
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x_offset"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the x offset to adjust the position by"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y_offset"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the y offset to adjust the position by"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_set_offset" gtk_popover_set_offset :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    Int32 ->                                -- x_offset : TBasicType TInt
    Int32 ->                                -- y_offset : TBasicType TInt
    IO ()

-- | Sets the offset to use when calculating the position
-- of the popover.
-- 
-- These values are used when preparing the [struct/@gdk@/.PopupLayout]
-- for positioning the popover.
popoverSetOffset ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> Int32
    -- ^ /@xOffset@/: the x offset to adjust the position by
    -> Int32
    -- ^ /@yOffset@/: the y offset to adjust the position by
    -> m ()
popoverSetOffset popover xOffset yOffset = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    gtk_popover_set_offset popover' xOffset yOffset
    touchManagedPtr popover
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverSetOffsetMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverSetOffsetMethodInfo a signature where
    overloadedMethod = popoverSetOffset

instance O.OverloadedMethodInfo PopoverSetOffsetMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverSetOffset",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverSetOffset"
        })


#endif

-- method Popover::set_pointing_to
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "rect"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Rectangle" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "rectangle to point to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_set_pointing_to" gtk_popover_set_pointing_to :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    Ptr Gdk.Rectangle.Rectangle ->          -- rect : TInterface (Name {namespace = "Gdk", name = "Rectangle"})
    IO ()

-- | Sets the rectangle that /@popover@/ points to.
-- 
-- This is in the coordinate space of the /@popover@/ parent.
popoverSetPointingTo ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> Maybe (Gdk.Rectangle.Rectangle)
    -- ^ /@rect@/: rectangle to point to
    -> m ()
popoverSetPointingTo popover rect = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    maybeRect <- case rect of
        Nothing -> return FP.nullPtr
        Just jRect -> do
            jRect' <- unsafeManagedPtrGetPtr jRect
            return jRect'
    gtk_popover_set_pointing_to popover' maybeRect
    touchManagedPtr popover
    whenJust rect touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverSetPointingToMethodInfo
instance (signature ~ (Maybe (Gdk.Rectangle.Rectangle) -> m ()), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverSetPointingToMethodInfo a signature where
    overloadedMethod = popoverSetPointingTo

instance O.OverloadedMethodInfo PopoverSetPointingToMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverSetPointingTo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverSetPointingTo"
        })


#endif

-- method Popover::set_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "popover"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Popover" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkPopover`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "position"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PositionType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "preferred popover position"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_popover_set_position" gtk_popover_set_position :: 
    Ptr Popover ->                          -- popover : TInterface (Name {namespace = "Gtk", name = "Popover"})
    CUInt ->                                -- position : TInterface (Name {namespace = "Gtk", name = "PositionType"})
    IO ()

-- | Sets the preferred position for /@popover@/ to appear.
-- 
-- If the /@popover@/ is currently visible, it will be immediately
-- updated.
-- 
-- This preference will be respected where possible, although
-- on lack of space (eg. if close to the window edges), the
-- @GtkPopover@ may choose to appear on the opposite side.
popoverSetPosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsPopover a) =>
    a
    -- ^ /@popover@/: a @GtkPopover@
    -> Gtk.Enums.PositionType
    -- ^ /@position@/: preferred popover position
    -> m ()
popoverSetPosition popover position = liftIO $ do
    popover' <- unsafeManagedPtrCastPtr popover
    let position' = (fromIntegral . fromEnum) position
    gtk_popover_set_position popover' position'
    touchManagedPtr popover
    return ()

#if defined(ENABLE_OVERLOADING)
data PopoverSetPositionMethodInfo
instance (signature ~ (Gtk.Enums.PositionType -> m ()), MonadIO m, IsPopover a) => O.OverloadedMethod PopoverSetPositionMethodInfo a signature where
    overloadedMethod = popoverSetPosition

instance O.OverloadedMethodInfo PopoverSetPositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.Popover.popoverSetPosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.9/docs/GI-Gtk-Objects-Popover.html#v:popoverSetPosition"
        })


#endif


